<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Financeiro extends CI_Controller {

	public function index()
	{
        $this->login->checkIsAdminSession();

        $query['nomepagina'] = 'Financeiro geral';
		$query['nomesistema'] =  $this->app->nomeSistema();
        $query['logo'] =  $this->app->logo();

        $this->load->view('pages/layout/header', $query);
        $this->load->view('pages/financeiro/geral', $query);
        $this->load->view('pages/layout/footer', $query);
	}
    public function configList()
	{
        $this->login->checkIsAdminSession();

        $query['nomepagina'] = 'Lista de configurações (Financeiro)';
		$query['nomesistema'] =  $this->app->nomeSistema();
        $query['logo'] =  $this->app->logo();

        // Configuração da paginação
        $config['base_url'] = site_url('financeiro/configList');
        $config['total_rows'] = $this->db->count_all_results('financeiro_config'); // Total de registros na tabela
        $config['per_page'] = 10; // Número de registros por página
        $config['uri_segment'] = 3; // Segmento da URI que contém o número da página
    
        // Estilo da paginação
        $config['full_tag_open'] = '<ul class="pagination justify-content-center">';
        $config['full_tag_close'] = '</ul>';
        $config['num_tag_open'] = '<li class="page-item">';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close'] = '</span></li>';
        $config['prev_tag_open'] = '<li class="page-item">';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li class="page-item">';
        $config['next_tag_close'] = '</li>';
        $config['attributes'] = array('class' => 'page-link');

        $config['first_link'] = 'Inicio';
        $config['last_link'] = 'Final';
    
        $this->pagination->initialize($config);

        $checkUsers = $this->app->checkUserExistInWallet();

        $query['config'] =  $this->db->limit($config['per_page'], $this->uri->segment($config['uri_segment']))->get('financeiro_config')->result();

        $this->load->view('pages/layout/header', $query);
        $this->load->view('pages/config/financeiro', $query);
        $this->load->view('pages/layout/footer', $query);
	}

    public function store()
	{
        $this->login->checkIsAdminSession();
        if ($this->input->post()) {
            $data = $this->input->post();
            $this->db->insert('financeiro_config', $data);

            $msg = "Configuração criada com sucesso!";
            $this->session->set_flashdata('msg', $msg);
            $this->session->set_flashdata('tipo', "success");

            redirect('financeiro/configList');
        } 
	}
    public function update($id)
	{
        $this->login->checkIsAdminSession();
        if ($this->input->post()) {
            $data = $this->input->post();
            
            $this->db->where('id', $id);
            $this->db->update('financeiro_config', $data);

            $msg = "Configuração atualizada com sucesso!";
            $this->session->set_flashdata('msg', $msg);
            $this->session->set_flashdata('tipo', "success");

            redirect('financeiro/configList');
        } 
	}
    
    public function saques()
	{
        $this->login->checkIsAdminSession();

        $query['nomepagina'] = 'Saques';
		$query['nomesistema'] =  $this->app->nomeSistema();
        $query['logo'] =  $this->app->logo();

        $query['transacoes_saque'] = $this->app->getSaques();

        $this->load->view('pages/layout/header', $query);
        $this->load->view('pages/financeiro/saque', $query);
        $this->load->view('pages/layout/footer', $query);
	}

    public function solicitacoes()
	{
        $this->login->checkIsAdminSession();

        $query['nomepagina'] = 'Saques';
		$query['nomesistema'] =  $this->app->nomeSistema();
        $query['logo'] =  $this->app->logo();

        
        $temCashback = $this->app->configFin('cashback-enable');
        $query['cashbackEnable'] = $temCashback;

        if(is_array($temCashback) && $temCashback['status'] == 1){
            $query['transacoes_saque'] = $this->app->getSoliSaquesWCashback();
        }else{
            $query['transacoes_saque'] = $this->app->getSoliSaques();
        }

        $this->load->view('pages/layout/header', $query);
        $this->load->view('pages/financeiro/solicitacoes', $query);
        $this->load->view('pages/layout/footer', $query);
	}
    public function depositos()
	{
        $this->login->checkIsAdminSession();

        $query['nomepagina'] = 'Saques';
		$query['nomesistema'] =  $this->app->nomeSistema();
        $query['logo'] =  $this->app->logo();

        $query['transacoes_saque'] = $this->app->getDep();
        
        $this->load->view('pages/layout/header', $query);
        $this->load->view('pages/financeiro/deposito', $query);
        $this->load->view('pages/layout/footer', $query);
	}
    public function movimentacoes()
	{
        $this->login->checkIsAdminSession();

        $query['nomepagina'] = 'Saques';
		$query['nomesistema'] =  $this->app->nomeSistema();
        $query['logo'] =  $this->app->logo();

        $query['transacoes_saque'] = $this->app->getMov();
        
        $this->load->view('pages/layout/header', $query);
        $this->load->view('pages/financeiro/movimentacoes', $query);
        $this->load->view('pages/layout/footer', $query);
	}

    public function aprovar($id) {

        date_default_timezone_set('America/Sao_Paulo');
        // Verificar configurações
        $isSuitPay = $this->app->isSuitPay();
        $isEzzyBank = $this->app->isEzzyBank();
        $temCashback = $this->app->configFin('cashback-enable');

        // Configurar consulta
        if (is_array($temCashback) && $temCashback['status'] == 1) {
        $this->db->select('saques.*, tmp_cashback.valor as cashback, tmp_cashback.id as cbid');
        } 
        $this->db->from('saques');
        
        if (is_array($temCashback) && $temCashback['status'] == 1) {
            $this->db->join('tmp_cashback', 'saques.usuario = tmp_cashback.usuario', 'left');
        }
        
        $query = $this->db->where('saques.id', $id)->get();

        // Verificar resultado da consulta
        if ($query) {
            // Processar resultado
            $result = $query->row();

            if ($result && $result->pago == 0) {
                $valor = $result->value;

                if (is_array($temCashback) && $temCashback['status'] == 1) {
                    $valor += (!empty($result->cashback)) ? $result->cashback : 0;
                }

                $uID = $result->usuario;
                $tipo = $result->typeKey;
                $key = $result->key;

                // Adicionar lógica para SuitPay
                if ($isSuitPay == true) {
                    $this->suitpay->criarSaque($uID, $valor, $tipo, $key);
                }

                // Adicionar lógica para EzzyBank
                if ($isEzzyBank == true) {
                    $this->ezze->criarSaque($uID, $valor, $tipo, $key);
                }

                // Atualizar status do saque
                $this->db->where('id', $id);
                $this->db->update('saques', array('status' => 'Pago', 'observacao' => 'Pagamento aprovado', 'pago' => 1));

                $histInsert = array(
                    "debito" => 'R$ ' . number_format($valor, 2),
                    "usuario" => $uID,
                    "pagina" => 'Saque aprovado',
                    'ip' => $this->input->ip_address(),
                    'data_hora' => date('d/m/Y H:i:s')
                );

                $this->db->insert('historico', $histInsert);

                if (is_array($temCashback) && $temCashback['status'] == 1) {

                    $this->db->where('id', $result->cbid);
                    $this->db->delete('tmp_cashback');

                    $this->db->insert('hist_cashback', array('status' => 'Pago', 'cashback' => $valor, 'usuario' => $uID, 'data' => date('d/m/Y')));
                }
            } 
        }
    }
    public function recusar($id){
       
        date_default_timezone_set('America/Sao_Paulo');
        $this->db->where('id', $id);
        $query = $this->db->get('saques')->row();

        $uID = $query->usuario;
        $saldo = $query->value;

        
        $histInsert = array(
            "credito" => 'R$ ' . number_format($valor, 2),
            "usuario" => $uID,
            "pagina" => 'Saque recusado',
            'ip' => $this->input->ip_address(),
            'data_hora' => date('d/m/Y H:i:s')
        );

        $this->db->insert('historico', $histInsert);

        $this->fiverscans->enviarSaldo($uID,$saldo);

        $this->db->where('id', $id);
        $this->db->update('saques', array('status' => 'Recusado', 'observacao' => 'Pagamento Recusado', 'pago' => 1));
    }
}
