<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
<div class="container mt-5">
        <div class="d-flex align-items-center">
            <h1 class="mb-4 font">Lista de Configurações (Financeiro)</h1>  
            
            <button class="btn btn-primary ms-auto me-2" data-bs-toggle="modal" data-bs-target="#novo"><i class="fa-solid fa-plus"></i></button>
        </div>
        <?php if ($this->session->flashdata('msg')): ?>
            <div class="alert alert-<?= $this->session->flashdata('tipo'); ?> font" role="alert">
                <?= $this->session->flashdata('msg'); ?>
            </div>
        <?php endif; ?>
        <?php if (empty($config)): ?>
            <div class="card text-center bg-card-black">
                <div class="card-body mt-5 mb-5">
                    <h2 class="font mb-5" >Nenhum registro encontrado.</h2>
                </div>
            </div>
        <?php else: ?>
          <div class="card bg-card-black">
            <div class="card-body">
                <div class="container">
                <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Codigo</th>
                                <th scope="col">Descrição</th>
                                <th scope="col">Valor</th>
                                <th scope="col">Status</th>
                                <th scope="col"></th>
                            </tr>
                        </thead>
                    <tbody>
                <?php foreach ($config as $configs): ?>  
                        <tr>
                            <th scope="row"><?php echo $configs->id; ?></th>
                            <td><?php echo $configs->cod; ?></td>
                            <td><?php echo $configs->descricao; ?></td>
                            <td><?php echo $configs->valor; ?></td>
                            <td>
                            <?php if ($configs->status == 1): ?>
                                <span class="badge text-bg-success">Ativado</span>
                            <?php else: ?>
                                <span class="badge text-bg-dark">Desativado</span>
                            <?php endif; ?>
                            </td>
                            <td><button class="btn btn-light" data-bs-toggle="modal" data-bs-target="#editar<?php echo $configs->id; ?>"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-pencil-ruler"><path d="m15 5 4 4"/><path d="M13 7 8.7 2.7a2.41 2.41 0 0 0-3.4 0L2.7 5.3a2.41 2.41 0 0 0 0 3.4L7 13"/><path d="m8 6 2-2"/><path d="m2 22 5.5-1.5L21.17 6.83a2.82 2.82 0 0 0-4-4L3.5 16.5Z"/><path d="m18 16 2-2"/><path d="m17 11 4.3 4.3c.94.94.94 2.46 0 3.4l-2.6 2.6c-.94.94-2.46.94-3.4 0L11 17"/></svg></button></td>
                        </tr>
                <?php endforeach; ?>
                    </tbody>
                </table>
                </div>
            </div>
            <nav class="mb-3">
                <?php echo $this->pagination->create_links(); ?>
            </nav>
        </div>
        <?php endif; ?>
    </div>
    </div>
</main>

<!-- Modal -->
<div class="modal fade" id="novo" tabindex="-1" aria-labelledby="novoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="novoLabel">Nova configuração</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <!-- Formulário para adicionar saldo -->
        <form method="post" action="<?php echo site_url('financeiro/store/'); ?>">
        <div class="mb-3">
            <label for="saldo" class="form-label">Codigo</label>
            <div class="input-group">
                <input type="text" class="form-control" id="cod" name="cod">
            </div>
        </div>
        <div class="mb-3">
            <label for="saldo" class="form-label">Descrição</label>
            <div class="input-group">
                <input type="text" class="form-control" id="descricao" name="descricao">
            </div>
        </div>
        <div class="mb-3">
            <label for="saldo" class="form-label">Valor</label>
            <div class="input-group">
                <input type="text" class="form-control" id="valor" name="valor">
            </div>
        </div>
       
        <div class="mb-3">
            <label for="saldo" class="form-label">Status</label>
            <div class="input-group">
            <select class="form-select" aria-label="Default select example" id="status" name="status">
                    <option value="1" selected>Ativado</option>
                    <option value="0">Desativado</option>
            </select>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
        <button type="submit" class="btn btn-primary">Salvar</button> 
    </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<?php foreach ($config as $configs): ?>  
<div class="modal fade" id="editar<?php echo $configs->id; ?>" tabindex="-1" aria-labelledby="editarLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarLabel">Editar configuração</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <!-- Formulário para adicionar saldo -->
        <form method="post" action="<?php echo site_url('financeiro/update/'.$configs->id); ?>">
        <div class="mb-3">
            <label for="saldo" class="form-label">Codigo</label>
            <div class="input-group">
                <input type="text" class="form-control" id="cod" name="cod" value="<?php echo $configs->cod; ?>">
            </div>
        </div>
        <div class="mb-3">
            <label for="saldo" class="form-label">Descrição</label>
            <div class="input-group">
                <input type="text" class="form-control" id="descricao" name="descricao" value="<?php echo $configs->descricao; ?>">
            </div>
        </div>
        <div class="mb-3">
            <label for="saldo" class="form-label">Valor</label>
            <div class="input-group">
                <input type="text" class="form-control" id="valor" name="valor" value="<?php echo $configs->valor; ?>">
            </div>
        </div>
       
        <div class="mb-3">
            <label for="saldo" class="form-label">Status</label>
            <div class="input-group">
            <select class="form-select" aria-label="Default select example" id="status" name="status">
                    <option value="1" selected>Ativado</option>
                    <option value="0">Desativado</option>
            </select>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
        <button type="submit" class="btn btn-primary">Salvar</button> 
    </form>
      </div>
    </div>
  </div>
</div>
<?php endforeach; ?>