<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
<div class="container mt-5">
        <div class="card">
            <div class="card-header">
                Todos os saques realizados 
            </div>

            <?php if ($this->session->flashdata('msg')): ?>
                <div class="alert alert-<?= $this->session->flashdata('tipo'); ?> font" role="alert">
                    <?= $this->session->flashdata('msg'); ?>
                </div>
             <?php endif; ?>

            <div class="card-body">
                <table class="table table-bordered stable">
                    <thead>
                        <tr>
                            <th>Cliente</th>
                            <th>CPF</th>
                            <th>E-mail</th>
                            <th>Tipo da Chave</th>
                            <th>Registrado</th>
                            <th>Status</th>
                            <th>Valor</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transacoes_saque as $transacao) { ?>
                            <tr id="<?= $transacao->id; ?>">
                                <td><?php echo $transacao->nome; ?></td>
                                <td><?php echo $transacao->cpf; ?></td>
                                <td><?php echo $transacao->email; ?></td>
                                <td><?php echo $transacao->typeKey; ?></td>
                                <td><?php echo $transacao->datahora; ?></td>
                                <td>
                                    <?php if ($transacao->status === 'Pago') { ?>
                                        <span class="badge bg-success">Pago</span>
                                    <?php } else { ?>
                                        <span class="badge bg-danger"><?php echo $transacao->status; ?></span>
                                    <?php } ?>
                                </td>
                                <td><?php echo 'R$ ' . number_format($transacao->value, 2); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>
