<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
<div class="container mt-5">
        <div class="card">
            <div class="card-header">
                Solicitações de Saques 
            </div>

            <?php if ($this->session->flashdata('msg')): ?>
                <div class="alert alert-<?= $this->session->flashdata('tipo'); ?> font" role="alert">
                    <?= $this->session->flashdata('msg'); ?>
                </div>
             <?php endif; ?>

            <div class="card-body">
                <table class="table table-bordered stable">
                    <thead>
                        <tr>
                            <th>Cliente</th>
                            <th>Tipo da Chave</th>
                            <th>Registrado</th>
                            <th>Status</th>
                            <th>Valor</th>
                            <?php if (is_array($cashbackEnable) && $cashbackEnable['status'] == 1): ?>
                            <th>com cashback ?</th>
                            <th>Total</th>
                            <?php endif; ?>
                            <th>#</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transacoes_saque as $transacao) { ?>
                            <tr id="<?= $transacao->id; ?>">
                                <td><?php echo $transacao->nome; ?></td>
                                <td><?php echo $transacao->typeKey; ?></td>
                                <td><?php echo $transacao->datahora; ?></td>
                                <td><?php echo $transacao->status; ?></td>
                                <td>R$ <?php echo $transacao->value; ?></td>
                                <?php if (is_array($cashbackEnable) && $cashbackEnable['status'] == 1): ?>
                                <td>
                               
                                    <?php if (!empty($transacao->cashback)): ?>
                                        <span class="badge text-bg-success">Sim</span>   R$ <?php echo $transacao->cashback; ?>
                                    <?php else: ?>
                                        <span class="badge text-bg-primary">Não</span>
                                    <?php endif; ?>    

                                </td>
                                <th>R$ <?php echo ($transacao->value + $transacao->cashback); ?></th>
                                <?php endif; ?>
                                <td>

                                <div class="d-grid gap-2 d-md-block">
                                    <button class="btn btn-primary aprovar" type="button">Aprovar</button>
                                    <button class="btn btn-danger cancelar" type="button">Recusar</button>
                                </div>

                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<script type="text/javascript">
            $(".aprovar").click(function() {

                var id = $(this).parents("tr").attr("id");

                swal({

                        title: "Aprovar pagamento",
                        text: "Você tem certeza?",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Sim!",
                        cancelButtonText: "Não, cancelar!",
                        closeOnConfirm: false,
                        closeOnCancel: false

                    },

                    function(isConfirm) {

                        if (isConfirm) {

                            $.ajax({

                                url: "<?php echo site_url('financeiro/aprovar/')?>" + id,
                                type: 'DELETE',
                                error: function() {
                                    swal("Error", "Ocorreu um erro, contate o administrador", "error");
                                },
                                success: function(data) {
                                    $("#" + id).remove();
                                    swal("Apagado!", "O pagamento foi aprovado com sucesso.", "success");
                                }
                            }).then(function() {
                                location.href = '<?php echo site_url('financeiro/solicitacoes')?>';
                            });

                        } else {
                            swal("Cancelado", "O pagamento não foi aprovado.", "error");
                        }

                    });

            });
        </script>
        <script type="text/javascript">
            $(".cancelar").click(function() {

                var id = $(this).parents("tr").attr("id");

                swal({

                        title: "Recusar pagamento",
                        text: "Você tem certeza?",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Sim!",
                        cancelButtonText: "Não, cancelar!",
                        closeOnConfirm: false,
                        closeOnCancel: false

                    },
                    function(isConfirm) {

                        if (isConfirm) {

                            $.ajax({

                                url: "<?php echo site_url('financeiro/recusar/')?>" + id,
                                type: 'DELETE',
                                error: function() {
                                    swal("Error", "Ocorreu um erro, contate o administrador", "error");
                                },
                                success: function(data) {
                                    $("#" + id).remove();
                                    swal("Apagado!", "O pagamento foi cancelado com sucesso.", "success");
                                }
                            }).then(function() {
                                location.href = '<?php echo site_url('financeiro/solicitacoes')?>';
                            });

                        } else {
                            swal("Cancelado", "O pagamento não foi cancelado.", "error");
                        }

                    });

            });
        </script>
