<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Games extends CI_Controller {

	public function ver($provedora, $game)
	{
		$this->login->checkSession();
		date_default_timezone_set('America/Sao_Paulo');

		$saldo = $this->session->userdata('saldo');

		$data = [
			'nomepagina' => 'Jogo',
			'config' => $this->app->config(),
			'provedora' => $provedora,
			'game' => $game,
		];

		$dados = [
			'usuario' =>  $this->session->userdata('id'),
			'pagina' => 'Acesso',
			'jogo' => $game,
			'ip' => $this->input->ip_address(),
			'saldo' => 'R$ ' . number_format($saldo, 2),
			'data_hora' => date('d/m/Y H:i:s'),
		];

		$this->app->inserir_historico($dados);

		if ($saldo <= 0.10) {
			$msg = "Parece que você tem pouco saldo para jogar, bora fazer um depósito";
			$this->session->set_flashdata('msg', $msg);
			$this->session->set_flashdata('tipo', "danger");
			redirect('');
		}

		$this->load->view('pages/welcome/game', $data);
	}

}
