<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment extends CI_Controller {

    public function deposit()
    {
        $valor = $this->input->post('field');
        $isBonus = $this->input->post('bonus');
        $bonus =  $this->app->configFin('deposit-bonus');

        $isSuitPay = $this->app->isSuitPay();
        $isEzzyBank = $this->app->isEzzyBank();

        if(is_array($bonus) && $bonus['status'] == 1){
            if($isBonus == true){
                $this->session->set_userdata('bonus', true);
            } 
        }

        if($isSuitPay == true){
            redirect('suit/criarQrCode/'.$valor);
        }
        if($isEzzyBank == true){
            redirect('ezze/criarQrCode/'.$valor);
        }
    }
    
    public function saque()
    {
        $isSuitPay = $this->app->isSuitPay();
        $isEzzyBank = $this->app->isEzzyBank();
    
        $uID = $this->session->id;
        $valor = $this->input->post('value');
    
        $this->db->where('usuario', $uID);
        $actual = $this->db->get('financeiro')->row()->saldo;
    
        $saldo = $this->session->userdata('saldo');
    
        if ($saldo > 0.10) {
            // Verifica se o valor do saque não ultrapassa o saldo atual
            if ($valor <= $actual) {
                $data = array(
                    'usuario' => $uID,
                    'key' => $this->input->post('key'),
                    'typeKey' => $this->input->post('type'),
                    'value' => $valor,
                    'pago' => 0,
                    'datahora' => date('d/m/Y H:m:s'),
                    'status' => 'pendente'
                );
    
                $saldoAjustado = ($valor - $saldo);
                $this->session->set_userdata('saldo', $saldoAjustado);
                
                $this->db->insert('saques', $data);
                $insert_id = $this->db->insert_id();
    
                if ($insert_id) {
                    $setSaldo = $this->fiverscans->sacarSaldo($uID, $valor);
    
                    $msg = "Saque solicitado com sucesso!";
                    $this->session->set_flashdata('msg', $msg);
                    $this->session->set_flashdata('tipo', "success");
    
                    redirect('');
                } else {
                    $msg = "Erro ao solicitar saque, tente novamente mais tarde ou entre em contato com o suporte!";
                    $this->session->set_flashdata('msg', $msg);
                    $this->session->set_flashdata('tipo', "danger");
    
                    redirect('');
                }
            } else {
                // O valor do saque é maior que o saldo atual
                $msg = "O valor do saque não pode ser maior que o saldo atual!";
                $this->session->set_flashdata('msg', $msg);
                $this->session->set_flashdata('tipo', "danger");
    
                redirect('');
            }
        } else {
            $msg = "Você não tem saldo para fazer o saque!";
            $this->session->set_flashdata('msg', $msg);
            $this->session->set_flashdata('tipo', "danger");
    
            redirect('');
        }
    }
    public function status()
    {
        $transacaoId = $this->session->transacao_id;
        $this->db->where('transacao_id', $transacaoId);
        $trans = $this->db->get('transacoes')->result();
    
        if (!empty($trans) && is_array($trans) && isset($trans[0]->status)) {
            if ($trans[0]->status == 'pago') {
                $insert = array(
                    'transacao_id' => $trans[0]->transacao_id,
                    'status' => 'pago'
                );
                echo $this->engine->output('200', $insert);
            } else {
                $insert = array(
                    'mensagem' => 'Nenhuma atualização',
                    'status' => 'CONSULTA'
                );
                echo $this->engine->output('200', $insert);
            }
        } else {

            $insert = array(
                'mensagem' => 'Erro na consulta',
                'status' => 'ERRO'
            );
            echo $this->engine->output('500', $insert);
        }
    }

    public function verificarStatus() {
        
        date_default_timezone_set('America/Sao_Paulo');

        $this->db->where('status','processamento');	
        $transacoes = $this->db->get('transacoes')->result();

        foreach($transacoes as $trans){

            $userID = $this->session->id;

            $url = getenv('APP_URL').'/suit/status/'.$trans->usuario.'/'.$trans->transacao_id;
            $response = file_get_contents($url);
    
            $data = json_decode($response, true);
    
            if ($data && isset($data['status'])) {
                $status = strtoupper($data['status']);

                if ($status === 'PAID_OUT') {
                    
                    $insert = array(
                        'transacao_id' => $trans->transacao_id,
                        'status' => 'pago'
                    );
                    $this->db->where('transacao_id', $trans->transacao_id);
                    $this->db->update('transacoes', $insert);
    
                    if($this->session->bonus == true){
                        $newValor = (2 * $trans->valor);
                    }else{
                        $newValor = $trans->valor;
                    };

                    $temCashback =  $this->app->configFin('cashback-enable');

                    if(is_array($temCashback) && $temCashback['status'] == 1){
                        
                        // Defina os valores da parte e do total
                        $parte = $temCashback['valor'] ; 
                        $total = $newValor;

                        // Calcule a porcentagem
                        $porcentagem = $total - ($total / 100 * $parte);

                        $ist = array(
                            'usuario' => $trans->usuario,
                            'valor' => number_format($porcentagem, 2),
                            'status' => 'novo',
                            'data_hora' => date('d-m-Y H:m:s')
                        );

                        $this->db->insert('tmp_cashback', $ist);
                    }

                    $this->cpa->checaCPA($userID,$trans->transacao_id);
                    $this->fiverscans->enviarSaldo($userID, $newValor); 

                    echo 'Transação: '. $trans->transacao_id . ' -  Status: pago  <br>';
                }else{
                    echo 'Transação: '. $trans->transacao_id . ' -  Status: não pago  <br>';
                }
                
            }
        };
    }

}
