<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuarios extends CI_Controller {

	public function minhaconta()
	{
		$this->login->checkSession();
        $data['nomepagina'] = 'Minha Conta';
		$data['config'] = $this->app->config();
        $this->db->where('id', $this->session->id);
		$data['usuario'] = $this->db->get('usuarios')->result();
		$data['historico'] = $this->app->getUsuarioHistoricoJogo($this->session->id);
        $query = $this->db->query("SELECT COUNT(*) as total_rows FROM usuarios WHERE afiliado = " . $data['usuario'][0]->usuario);

        if ($query) {
            if ($query->num_rows() > 0) {
                $result = $query->row();
                $data['total_indicados'] = $result->total_rows;
            } else {
                $data['total_indicados'] = 0;
            }
        } else {
            $data['total_indicados'] = 0;
        }

        $this->db->where('usuario', $this->session->id);
		$data['financeiro'] = $this->db->get('financeiro')->result();

        $data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
        $data['EnableCashback'] = $this->app->configFin('cashback-enable-text');

        $this->load->view('pages/layout/header', $data);
        $this->load->view('pages/layout/modals', $data);
        $this->load->view('pages/minhaconta/minhaconta', $data);
		$this->load->view('pages/layout/footer', $data);
	}
    public function editarconta()
	{
		$this->login->checkSession();
        $data['nomepagina'] = 'Editar Minha Conta';
		$data['config'] = $this->app->config();
        $this->db->where('id', $this->session->id);
		$data['usuario'] = $this->db->get('usuarios')->result();
        $data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
        $data['EnableCashback'] = $this->app->configFin('cashback-enable-text');

        $this->load->view('pages/layout/header', $data);
        $this->load->view('pages/layout/modals', $data);
        $this->load->view('pages/minhaconta/editarconta', $data);
		$this->load->view('pages/layout/footer', $data);
	}
    public function indique()
	{
		$this->login->checkSession();
        $data['nomepagina'] = 'Indique e ganhe';
		$data['config'] = $this->app->config();
        $this->db->where('id', $this->session->id);
		$data['usuario'] = $this->db->get('usuarios')->result();
        if($data['usuario'][0]->usuario == null){
            $ux = array('usuario' => rand(0, 20000).date('Ymd'));
            $this->db->where('id', $this->session->id);
            $this->db->update('usuarios', $ux);
        }
        $query = $this->db->query("SELECT COUNT(*) as total_rows FROM usuarios WHERE afiliado = " . $data['usuario'][0]->usuario);

        if ($query) {
            if ($query->num_rows() > 0) {
                $result = $query->row();
                $data['total_indicados'] = $result->total_rows;
            } else {
                $data['total_indicados'] = 0;
            }
        } else {
            $data['total_indicados'] = 0;
        }

        $this->db->where('usuario', $this->session->id);
		$data['afiliado'] = $this->db->get('afiliado')->result();

        $data['configRef']  = $this->app->configRef();
        $data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
        $data['EnableCashback'] = $this->app->configFin('cashback-enable-text');

        $this->load->view('pages/layout/header', $data);
        $this->load->view('pages/layout/modals', $data);
        $this->load->view('pages/minhaconta/indique', $data);
		$this->load->view('pages/layout/footer', $data);
	}
    public function novo()
	{
        $email = $this->input->post('email');
        $data = $this->input->post();
        $data['senha'] = md5($this->input->post('senha'));
        $data['usuario'] = rand(0, 20000).date('Ymd');
        $data['tipo'] = 'usuário';
        $data['status'] = 1;

        $this->criarUsuarioAPI($data['usuario']);
        if($this->db->insert('usuarios',$data)){ 
            $newUserId =  $this->db->insert_id();    

            $this->criarFinanceiro($newUserId);
            $this->criarFinAfiliado($newUserId);

          $msg = "Bem Vindo ".$data['nome']."! Você já pode se logar na sua conta";
                $this->session->set_flashdata('msg', $msg);
                $this->session->set_flashdata('tipo', "success");
    
          redirect($base_url);   
        }else{

            $this->db->where('email', $email);
            $data['login'] = $this->db->get('usuarios')->result();

            if($data['login']){ 
                $msg = "E-mail já cadastrado, tente recuperar sua senha clicando em esqueci minha senha.";
                $this->session->set_flashdata('msg', $msg);
                $this->session->set_flashdata('tipo', "danger");
                redirect($base_url);

            }else{
                $msg = "Atenção! Tente novamente mais tarde!";
                $this->session->set_flashdata('msg', $msg);
                $this->session->set_flashdata('tipo', "danger");
                redirect($base_url);
            }
        }
    }
	public function entrar()
    {
        $email =  $this->input->post('email');
        $pwd =  md5($this->input->post('senha'));
        $this->db->where('email', $email);
        $this->db->where('senha', $pwd);
        $data['login'] = $this->db->get('usuarios')->result();
        if(!$data['login'] == null){
            $session['id'] = $data['login'][0]->id;
            $session['nome'] = $data['login'][0]->nome;
            $session['email'] = $data['login'][0]->email;
            $session['afiliado'] = $data['login'][0]->afiliado;
            $session['cpf'] = $data['login'][0]->cpf;
            $session['userTipo'] = $data['login'][0]->tipo;
            $session['status'] = $data['login'][0]->status;
            $session['usuario'] = $data['login'][0]->usuario;
            $session['logged'] = true;


            if($data['login'][0]->usuario == null){
                $ux = array('usuario' => rand(0, 20000).date('Ymd'));
                $this->db->where('id', $this->session->id);
                $this->db->update('usuarios', $ux);  
            }

            $this->criarFinanceiro($data['login'][0]->id);
            $this->criarFinAfiliado($data['login'][0]->id);

            $this->setSaldo($data['login'][0]->id);
            $this->session->set_userdata($session);
            $msg = "Bem Vindo ".$session['nome']."! Você já pode começar a jogar!";
                $this->session->set_flashdata('msg', $msg);
                $this->session->set_flashdata('tipo', "success");
            redirect($base_url);

        }else{
            $msg = "E-mail ou senha invalidos, precisa de ajuda para lembrar seu login?.";
                    $this->session->set_flashdata('msg', $msg);
                    $this->session->set_flashdata('tipo', "danger");
            redirect($base_url);
        }
    }
    public function logout()
	{
		$this->session->sess_destroy();
		redirect('');
    }

    private function criarFinanceiro($id) {
        $this->db->where('usuario', $id);
        $query = $this->db->get('financeiro');
        if ($query->num_rows() == 0) {

            $temBonus = $this->app->configFin('signup-bonus');
            if($temBonus){

                $this->fiverscans->enviarSaldo($id, $temBonus['valor']); 

                $dados_novo_usuario = array(
                    'usuario' => $id,
                    'saldo' => $temBonus['valor'],
                    'bonus' => 0
                );
            }else{
                $dados_novo_usuario = array(
                    'usuario' => $id,
                    'saldo' => 0,
                    'bonus' => 0
                );
            }
            
            $this->db->insert('financeiro', $dados_novo_usuario);
            return true;
        }
        return false; 
    }

    private function criarFinAfiliado($id) {
        $this->db->where('usuario', $id);
        $query = $this->db->get('afiliado');
        if ($query->num_rows() == 0) {
            $dados_novo_usuario = array(
                'usuario' => $id,
                'saldo' => 0
            );
            $this->db->insert('afiliado', $dados_novo_usuario);
            return true;
        }
        return false; 
    }
    
    private function setSaldo($id){
        $this->db->where('usuario', $id);
        $query = $this->db->get('financeiro');
        $usuario = $query->row();
        $this->session->set_userdata('saldo', $usuario->saldo);
    }

    private function getKeys(){
        $this->db->where('id',0);	
        $fiverData = $this->db->get('fiverscan')->result();
        $data = array(
            'url' => $fiverData[0]->url,
            'agent_code' => $fiverData[0]->agent_code,
            'agent_token' => $fiverData[0]->agent_token
        );
        return $data;
    }

    private function criarUsuarioAPI($usuario) {
        $keys = $this->getKeys();
        $url = $keys['url']; 
        $data = array(
            'method' => 'user_create',
            'agent_code' => $keys['agent_code'],
            'agent_token' => $keys['agent_token'],
            'user_code' => $usuario
        );

        $json_data = json_encode($data);
        $ch = curl_init();
        $headerArray = ['Content-Type: application/json'];
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);
        return true;
    }
    public function update($id)
	{
        $data = $this->input->post();
        $this->db->where('id', $id);
        $this->db->update('usuarios', $data);
        $msg = "Foi atualizado com sucesso!";
        $this->session->set_flashdata('msg', $msg);
        $this->session->set_flashdata('tipo', "success");
        redirect('usuarios/minhaconta');

	}
    public function resetarsenha(){
        $email = $this->input->post('email');
        $cpf = $this->input->post('cpf');

        $existe = $this->db->get_where('usuarios', array('email' => $email, 'cpf' => $cpf))->row();

        $pass = rand(10000000, 99999999);

        if ($existe){
            $this->db->where('id', $existe->id);
            $this->db->update('usuarios', array('senha' => md5($pass)));

            $msg = "Sua senha foi resetada para ". $pass .", por favor altere sua senha após o login!";

            $this->session->set_flashdata('msg', $msg);
            $this->session->set_flashdata('tipo', "success");
            redirect('');
        }
        else{
            $msg = "E-mail ou CPF não encontrado no sistema, entre em contato com o suporte.";

            $this->session->set_flashdata('msg', $msg);
            $this->session->set_flashdata('tipo', "success");
            redirect('');
        }
    }
}
