<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Fiverscans{
    
        public function __construct()
        {
            $this->CI = &get_instance();
            $this->CI->load->helper('url');
            $this->CI->config->item('base_url');
            $this->CI->load->database();
        }
        private function enviarRequest($url, $config) {
            $ch = curl_init();
    
            $headerArray = ['Content-Type: application/json'];
            // Configurando as opções do cURL
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $config);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
            // Executando a requisição e obtendo a resposta
            $response = curl_exec($ch);
    
            // Fechando a conexão cURL
            curl_close($ch);
    
            return $response;
        }
    
        private function getKeys(){
            $this->CI->db->where('id',0);	
            $fiverData = $this->CI->db->get('fiverscan')->result();
    
            $data = array(
                'url' => $fiverData[0]->url,
                'agent_code' => $fiverData[0]->agent_code,
                'agent_token' => $fiverData[0]->agent_token
            );
    
            return $data;
        }

        public function enviarSaldo($id, $saldo){

            $keys = $this->getKeys();
    
            $url = $keys['url']; 
    
            $query['user'] = $this->CI->db->get_where('usuarios', array('id' => $id))->row();
    
            $num = floatval($saldo);
    
            // Dados para o corpo da requisição em formato JSON
            $data = array(
                'method' => 'user_deposit',
                'agent_code' => $keys['agent_code'],
                'agent_token' => $keys['agent_token'], 
                'user_code' => $query['user']->usuario,
                "amount" => $num
            );
    
            $json_data = json_encode($data);
    
    
            // Fazendo a requisição POST
            $response = $this->enviarRequest($url, $json_data);
    
            // Exibindo a resposta
    
            $data = json_decode($response, true);
    
            return true;
        }
        public function sacarSaldo($id, $saldo){

            $keys = $this->getKeys();
    
            $url = $keys['url']; 
    
            $query['user'] = $this->CI->db->get_where('usuarios', array('id' => $id))->row();
    
            $num = floatval($saldo);
    
            // Dados para o corpo da requisição em formato JSON
            $data = array(
                'method' => 'user_withdraw',
                'agent_code' => $keys['agent_code'],
                'agent_token' => $keys['agent_token'], 
                'user_code' => $query['user']->usuario,
                "amount" => $num
            );
    
            $json_data = json_encode($data);
    
    
            // Fazendo a requisição POST
            $response = $this->enviarRequest($url, $json_data);
    
            // Exibindo a resposta
    
            $data = json_decode($response, true);
    
            echo $response;
    
        }

        public function getHist($id){

            $dataAtual = date('Y-m-d');
            $dataObj = new DateTime($dataAtual);
            $dataAnterior = $dataObj->modify('-1 day');
            $diaAnterior = $dataAnterior->format('Y-m-d');
            $keys = $this->getKeys();
            $url = $keys['url']; 
            $query['user'] = $this->CI->db->get_where('usuarios', array('id' => $id))->row();
    
            $data = array(
                'method' => 'get_game_log',
                'agent_code' => $keys['agent_code'],
                'agent_token' => $keys['agent_token'], 
                'user_code' => $query['user']->usuario,
                'game_type' => 'slot',
                'start' => $diaAnterior.' 00:00:00',
                'end' => $dataAtual.' 23:59:00',
                'page' => 0,
                'perPage' => 10000
            );

            $json_data = json_encode($data);

            $response = $this->enviarRequest($url, $json_data);

            return $response;
        }
        public function pegarSaldo($id){

            $query['user'] = $this->CI->db->get_where('usuarios', array('id' => $id))->row();
            
            if($this->CI->session->logged == false){
                return "Usuário não logado!";
            } else {
                $keys = $this->getKeys();
                $url = $keys['url']; 
    
                $data = array(
                    'method' => 'money_info',
                    'agent_code' => $keys['agent_code'],
                    'agent_token' => $keys['agent_token'], 
                    'user_code' =>  $query['user']->usuario
                );
        
                $json_data = json_encode($data);
                $response = $this->enviarRequest($url, $json_data);
    
                $dados = json_decode($response, true);
        
                if (!empty($dados)) {
                    if ($dados['status'] === 0) {
                        echo $this->CI->session->saldo;
                    } else {
                        $novoSaldo = $dados['user']['balance'];
                        $this->CI->session->set_userdata('saldo', $novoSaldo);
                    }
                } else {
                    echo $this->CI->session->saldo;
                }
            }
        }
}