
<?php 
require_once APPPATH .'models/App_extends.php';  

class App_model extends App_extends {

    public function nomeSistema()
	{
		$this->db->where('id',0);	
		return $this->db->get('config')->row()->nome;
	}
	public function logo()
	{
		$this->db->where('id',0);	
		return $this->db->get('config')->row()->logo;
	}
	public function config()
	{
		$this->db->where('id',0);	
		return $this->db->get('config')->result();
	}
    public function configRef()
	{
		$this->db->where('id',0);	
		return $this->db->get('afiliados_config')->result();
	}
	public function isSuitPay() {
        // Verifica se o registro com id = 0 está ativo
        $query = $this->db->get_where('suitpay', array('id' => 0, 'ativo' => 1));

        // Verifica se a consulta retornou algum resultado
        if ($query->num_rows() > 0) {
            return true; // O registro está ativo
        } else {
            return false; // O registro não está ativo
        }
    }
	public function isEzzyBank() {
        $query = $this->db->get_where('ezzebank', array('id' => 0, 'ativo' => 1));
        if ($query->num_rows() > 0) {
            return true; 
        } else {
            return false; 
        }
    }
    public function inserir_historico($dados)
    {
        $this->db->insert('historico', $dados);
        return $this->db->insert_id();
    }
    public function configFin($codigo)
    {
        $query = $this->db->get_where('financeiro_config', array('cod' => $codigo, 'status' => 1));
        if ($query->num_rows() > 0) {

            $rest = array(
                'valor' => $query->row()->valor,
                'status' => $query->row()->status,
            );

            return $rest;
        } else {
            return false;
        }
    }
    public function getUsuarioHistoricoJogo($usuario_id) {
        $this->db->select('historico.*, games.game_name');
        $this->db->from('usuarios');
        $this->db->where('usuarios.id', $usuario_id);
        $this->db->join('historico', 'usuarios.id = historico.usuario', 'inner');
        $this->db->join('games', 'historico.jogo = games.game_code', 'left');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result(); // Retorna uma única linha de resultado
        } else {
            return null; // Retorna null se não houver resultados
        }
    }

    public function insertHist($dados){	
        date_default_timezone_set('America/Sao_Paulo');
        
        $historico_id = $dados['historico_id'];
        $usuario = $dados['usuario'];
        $existe_registro = $this->db->get_where('historico', array('historico_id' => $historico_id, 'usuario' => $usuario))->row();
        if (!$existe_registro) {
            $this->db->insert('historico', $dados);
            return true; 
        } else {
            return false; 
        }
    }
}