
<?php 

class Login_model extends CI_Model {

    public function checkSession()
	{
		$this->app->AccessLogger();
		if( $this->session->userdata('logged') == false){
			$msg = "Você precisa estar logado para acessar esta página!";
			$this->session->set_flashdata('msg', $msg);
			$this->session->set_flashdata('tipo', "danger");

			redirect ('');
		}else{
			$this->pegarHist();
			$this->fiverscans->pegarSaldo($this->session->id);
		}		
		   
	}

	public function checkIsAdminSession()
	{
		if($this->session->userdata('logged') == false || $this->session->userdata('is_admin') != 1){

			$msg = "Você precisa ser admin para logar essa pagina!";
			$this->session->set_flashdata('msg', $msg);
			$this->session->set_flashdata('tipo', "danger");

			redirect ('');
		}		
		   
	}

	private function pegarHist(){
		
		$json = $this->fiverscans->getHist($this->session->id);
		$data = json_decode($json, true);
        $history_ids = array();

        if(empty($data['slot'])){
        }else{
            foreach ($data['slot'] as $slot) {
                $history_ids[] = $slot['history_id'];
    
                // Determine the appropriate key for win_money
                $win_money_key = isset($slot['win_money']) ? 'win_money' : 'win';
    
                // Determine the appropriate key for bet_money
                $bet_money_key = isset($slot['bet_money']) ? 'bet_money' : 'bet';
    
                // Determine the appropriate key for win_money
                $user_balance = isset($slot['user_end_balance']) ? 'user_end_balance' : 'user_after_balance';
    
                $history_ids[] = $slot['history_id'];
    
                $this->rev->checaRev($this->session->id, $bet_money_key, $slot['history_id']);
                $dados = array(
                    "historico_id" => $slot['history_id'],
                    "credito" => 'R$ ' . number_format($slot[$win_money_key], 2),
                    "debito" => 'R$ ' . number_format($slot[$bet_money_key], 2),
                    "saldo" => 'R$ ' . number_format($slot[$user_balance], 2),
                    "usuario" => $this->session->id,
                    "pagina" => 'Aposta',
                    "jogo" => $slot['game_code'],
                    'ip' => $this->input->ip_address(),
                    'data_hora' => date('d/m/Y H:i:s'),
                );
    
                $this->app->insertHist($dados);
        }		
        };
	}

}