/*!
 * Webflow: Front-end site library
 * @license MIT
 * Inline scripts may access the api using an async handler:
 *   var Webflow = Webflow || [];
 *   Webflow.push(readyFunction);
 */

(() => {
  var QP = Object.create;
  var Hi = Object.defineProperty;
  var ZP = Object.getOwnPropertyDescriptor;
  var JP = Object.getOwnPropertyNames;
  var eC = Object.getPrototypeOf,
      tC = Object.prototype.hasOwnProperty;
  var rC = (e, t) => () => (e && (t = e(e = 0)), t);
  var E = (e, t) => () => (t || e((t = {
              exports: {}
          })
          .exports, t), t.exports),
      nC = (e, t) => {
          for (var r in t) Hi(e, r, {
              get: t[r],
              enumerable: !0
          })
      },
      lc = (e, t, r, n) => {
          if (t && typeof t == "object" || typeof t == "function")
              for (let i of JP(t)) !tC.call(e, i) && i !== r && Hi(e, i, {
                  get: () => t[i],
                  enumerable: !(n = ZP(t, i)) || n.enumerable
              });
          return e
      };
  var iC = (e, t, r) => (r = e != null ? QP(eC(e)) : {}, lc(t || !e || !e.__esModule ? Hi(r, "default", {
          value: e,
          enumerable: !0
      }) : r, e)),
      aC = e => lc(Hi({}, "__esModule", {
          value: !0
      }), e);
  var lo = E(() => {
      window.tram = function(e) {
          function t(M, H) {
              var j = new N.Bare;
              return j.init(M, H)
          }

          function r(M) {
              return M.replace(/[A-Z]/g, function(H) {
                  return "-" + H.toLowerCase()
              })
          }

          function n(M) {
              var H = parseInt(M.slice(1), 16),
                  j = H >> 16 & 255,
                  Y = H >> 8 & 255,
                  X = 255 & H;
              return [j, Y, X]
          }

          function i(M, H, j) {
              return "#" + (1 << 24 | M << 16 | H << 8 | j)
                  .toString(16)
                  .slice(1)
          }

          function a() {}

          function s(M, H) {
              f("Type warning: Expected: [" + M + "] Got: [" + typeof H + "] " + H)
          }

          function o(M, H, j) {
              f("Units do not match [" + M + "]: " + H + ", " + j)
          }

          function l(M, H, j) {
              if (H !== void 0 && (j = H), M === void 0) return j;
              var Y = j;
              return Ge.test(M) || !Ke.test(M) ? Y = parseInt(M, 10) : Ke.test(M) && (Y = 1e3 * parseFloat(M)), 0 > Y && (Y = 0), Y === Y ? Y : j
          }

          function f(M) {
              re.debug && window && window.console.warn(M)
          }

          function u(M) {
              for (var H = -1, j = M ? M.length : 0, Y = []; ++H < j;) {
                  var X = M[H];
                  X && Y.push(X)
              }
              return Y
          }
          var c = function(M, H, j) {
                  function Y(ne) {
                      return typeof ne == "object"
                  }

                  function X(ne) {
                      return typeof ne == "function"
                  }

                  function K() {}

                  function te(ne, me) {
                      function ee() {
                          var Ye = new le;
                          return X(Ye.init) && Ye.init.apply(Ye, arguments), Ye
                      }

                      function le() {}
                      me === j && (me = ne, ne = Object), ee.Bare = le;
                      var pe, xe = K[M] = ne[M],
                          Dt = le[M] = ee[M] = new K;
                      return Dt.constructor = ee, ee.mixin = function(Ye) {
                          return le[M] = ee[M] = te(ee, Ye)[M], ee
                      }, ee.open = function(Ye) {
                          if (pe = {}, X(Ye) ? pe = Ye.call(ee, Dt, xe, ee, ne) : Y(Ye) && (pe = Ye), Y(pe))
                              for (var Ln in pe) H.call(pe, Ln) && (Dt[Ln] = pe[Ln]);
                          return X(Dt.init) || (Dt.init = ne), ee
                      }, ee.open(me)
                  }
                  return te
              }("prototype", {}.hasOwnProperty),
              v = {
                  ease: ["ease", function(M, H, j, Y) {
                      var X = (M /= Y) * M,
                          K = X * M;
                      return H + j * (-2.75 * K * X + 11 * X * X + -15.5 * K + 8 * X + .25 * M)
                  }],
                  "ease-in": ["ease-in", function(M, H, j, Y) {
                      var X = (M /= Y) * M,
                          K = X * M;
                      return H + j * (-1 * K * X + 3 * X * X + -3 * K + 2 * X)
                  }],
                  "ease-out": ["ease-out", function(M, H, j, Y) {
                      var X = (M /= Y) * M,
                          K = X * M;
                      return H + j * (.3 * K * X + -1.6 * X * X + 2.2 * K + -1.8 * X + 1.9 * M)
                  }],
                  "ease-in-out": ["ease-in-out", function(M, H, j, Y) {
                      var X = (M /= Y) * M,
                          K = X * M;
                      return H + j * (2 * K * X + -5 * X * X + 2 * K + 2 * X)
                  }],
                  linear: ["linear", function(M, H, j, Y) {
                      return j * M / Y + H
                  }],
                  "ease-in-quad": ["cubic-bezier(0.550, 0.085, 0.680, 0.530)", function(M, H, j, Y) {
                      return j * (M /= Y) * M + H
                  }],
                  "ease-out-quad": ["cubic-bezier(0.250, 0.460, 0.450, 0.940)", function(M, H, j, Y) {
                      return -j * (M /= Y) * (M - 2) + H
                  }],
                  "ease-in-out-quad": ["cubic-bezier(0.455, 0.030, 0.515, 0.955)", function(M, H, j, Y) {
                      return (M /= Y / 2) < 1 ? j / 2 * M * M + H : -j / 2 * (--M * (M - 2) - 1) + H
                  }],
                  "ease-in-cubic": ["cubic-bezier(0.550, 0.055, 0.675, 0.190)", function(M, H, j, Y) {
                      return j * (M /= Y) * M * M + H
                  }],
                  "ease-out-cubic": ["cubic-bezier(0.215, 0.610, 0.355, 1)", function(M, H, j, Y) {
                      return j * ((M = M / Y - 1) * M * M + 1) + H
                  }],
                  "ease-in-out-cubic": ["cubic-bezier(0.645, 0.045, 0.355, 1)", function(M, H, j, Y) {
                      return (M /= Y / 2) < 1 ? j / 2 * M * M * M + H : j / 2 * ((M -= 2) * M * M + 2) + H
                  }],
                  "ease-in-quart": ["cubic-bezier(0.895, 0.030, 0.685, 0.220)", function(M, H, j, Y) {
                      return j * (M /= Y) * M * M * M + H
                  }],
                  "ease-out-quart": ["cubic-bezier(0.165, 0.840, 0.440, 1)", function(M, H, j, Y) {
                      return -j * ((M = M / Y - 1) * M * M * M - 1) + H
                  }],
                  "ease-in-out-quart": ["cubic-bezier(0.770, 0, 0.175, 1)", function(M, H, j, Y) {
                      return (M /= Y / 2) < 1 ? j / 2 * M * M * M * M + H : -j / 2 * ((M -= 2) * M * M * M - 2) + H
                  }],
                  "ease-in-quint": ["cubic-bezier(0.755, 0.050, 0.855, 0.060)", function(M, H, j, Y) {
                      return j * (M /= Y) * M * M * M * M + H
                  }],
                  "ease-out-quint": ["cubic-bezier(0.230, 1, 0.320, 1)", function(M, H, j, Y) {
                      return j * ((M = M / Y - 1) * M * M * M * M + 1) + H
                  }],
                  "ease-in-out-quint": ["cubic-bezier(0.860, 0, 0.070, 1)", function(M, H, j, Y) {
                      return (M /= Y / 2) < 1 ? j / 2 * M * M * M * M * M + H : j / 2 * ((M -= 2) * M * M * M * M + 2) + H
                  }],
                  "ease-in-sine": ["cubic-bezier(0.470, 0, 0.745, 0.715)", function(M, H, j, Y) {
                      return -j * Math.cos(M / Y * (Math.PI / 2)) + j + H
                  }],
                  "ease-out-sine": ["cubic-bezier(0.390, 0.575, 0.565, 1)", function(M, H, j, Y) {
                      return j * Math.sin(M / Y * (Math.PI / 2)) + H
                  }],
                  "ease-in-out-sine": ["cubic-bezier(0.445, 0.050, 0.550, 0.950)", function(M, H, j, Y) {
                      return -j / 2 * (Math.cos(Math.PI * M / Y) - 1) + H
                  }],
                  "ease-in-expo": ["cubic-bezier(0.950, 0.050, 0.795, 0.035)", function(M, H, j, Y) {
                      return M === 0 ? H : j * Math.pow(2, 10 * (M / Y - 1)) + H
                  }],
                  "ease-out-expo": ["cubic-bezier(0.190, 1, 0.220, 1)", function(M, H, j, Y) {
                      return M === Y ? H + j : j * (-Math.pow(2, -10 * M / Y) + 1) + H
                  }],
                  "ease-in-out-expo": ["cubic-bezier(1, 0, 0, 1)", function(M, H, j, Y) {
                      return M === 0 ? H : M === Y ? H + j : (M /= Y / 2) < 1 ? j / 2 * Math.pow(2, 10 * (M - 1)) + H : j / 2 * (-Math.pow(2, -10 * --M) + 2) + H
                  }],
                  "ease-in-circ": ["cubic-bezier(0.600, 0.040, 0.980, 0.335)", function(M, H, j, Y) {
                      return -j * (Math.sqrt(1 - (M /= Y) * M) - 1) + H
                  }],
                  "ease-out-circ": ["cubic-bezier(0.075, 0.820, 0.165, 1)", function(M, H, j, Y) {
                      return j * Math.sqrt(1 - (M = M / Y - 1) * M) + H
                  }],
                  "ease-in-out-circ": ["cubic-bezier(0.785, 0.135, 0.150, 0.860)", function(M, H, j, Y) {
                      return (M /= Y / 2) < 1 ? -j / 2 * (Math.sqrt(1 - M * M) - 1) + H : j / 2 * (Math.sqrt(1 - (M -= 2) * M) + 1) + H
                  }],
                  "ease-in-back": ["cubic-bezier(0.600, -0.280, 0.735, 0.045)", function(M, H, j, Y, X) {
                      return X === void 0 && (X = 1.70158), j * (M /= Y) * M * ((X + 1) * M - X) + H
                  }],
                  "ease-out-back": ["cubic-bezier(0.175, 0.885, 0.320, 1.275)", function(M, H, j, Y, X) {
                      return X === void 0 && (X = 1.70158), j * ((M = M / Y - 1) * M * ((X + 1) * M + X) + 1) + H
                  }],
                  "ease-in-out-back": ["cubic-bezier(0.680, -0.550, 0.265, 1.550)", function(M, H, j, Y, X) {
                      return X === void 0 && (X = 1.70158), (M /= Y / 2) < 1 ? j / 2 * M * M * (((X *= 1.525) + 1) * M - X) + H : j / 2 * ((M -= 2) * M * (((X *= 1.525) + 1) * M + X) + 2) + H
                  }]
              },
              d = {
                  "ease-in-back": "cubic-bezier(0.600, 0, 0.735, 0.045)",
                  "ease-out-back": "cubic-bezier(0.175, 0.885, 0.320, 1)",
                  "ease-in-out-back": "cubic-bezier(0.680, 0, 0.265, 1)"
              },
              p = document,
              m = window,
              h = "bkwld-tram",
              g = /[\-\.0-9]/g,
              y = /[A-Z]/,
              b = "number",
              _ = /^(rgb|#)/,
              I = /(em|cm|mm|in|pt|pc|px)$/,
              C = /(em|cm|mm|in|pt|pc|px|%)$/,
              x = /(deg|rad|turn)$/,
              O = "unitless",
              L = /(all|none) 0s ease 0s/,
              D = /^(width|height)$/,
              A = " ",
              q = p.createElement("a"),
              w = ["Webkit", "Moz", "O", "ms"],
              F = ["-webkit-", "-moz-", "-o-", "-ms-"],
              k = function(M) {
                  if (M in q.style) return {
                      dom: M,
                      css: M
                  };
                  var H, j, Y = "",
                      X = M.split("-");
                  for (H = 0; H < X.length; H++) Y += X[H].charAt(0)
                      .toUpperCase() + X[H].slice(1);
                  for (H = 0; H < w.length; H++)
                      if (j = w[H] + Y, j in q.style) return {
                          dom: j,
                          css: F[H] + M
                      }
              },
              U = t.support = {
                  bind: Function.prototype.bind,
                  transform: k("transform"),
                  transition: k("transition"),
                  backface: k("backface-visibility"),
                  timing: k("transition-timing-function")
              };
          if (U.transition) {
              var W = U.timing.dom;
              if (q.style[W] = v["ease-in-back"][0], !q.style[W])
                  for (var S in d) v[S][0] = d[S]
          }
          var R = t.frame = function() {
                  var M = m.requestAnimationFrame || m.webkitRequestAnimationFrame || m.mozRequestAnimationFrame || m.oRequestAnimationFrame || m.msRequestAnimationFrame;
                  return M && U.bind ? M.bind(m) : function(H) {
                      m.setTimeout(H, 16)
                  }
              }(),
              V = t.now = function() {
                  var M = m.performance,
                      H = M && (M.now || M.webkitNow || M.msNow || M.mozNow);
                  return H && U.bind ? H.bind(M) : Date.now || function() {
                      return +new Date
                  }
              }(),
              P = c(function(M) {
                  function H(se, ve) {
                      var Ce = u(("" + se)
                              .split(A)),
                          Ee = Ce[0];
                      ve = ve || {};
                      var Qe = ie[Ee];
                      if (!Qe) return f("Unsupported property: " + Ee);
                      if (!ve.weak || !this.props[Ee]) {
                          var bt = Qe[0],
                              it = this.props[Ee];
                          return it || (it = this.props[Ee] = new bt.Bare), it.init(this.$el, Ce, Qe, ve), it
                      }
                  }

                  function j(se, ve, Ce) {
                      if (se) {
                          var Ee = typeof se;
                          if (ve || (this.timer && this.timer.destroy(), this.queue = [], this.active = !1), Ee == "number" && ve) return this.timer = new J({
                              duration: se,
                              context: this,
                              complete: K
                          }), void(this.active = !0);
                          if (Ee == "string" && ve) {
                              switch (se) {
                                  case "hide":
                                      ee.call(this);
                                      break;
                                  case "stop":
                                      te.call(this);
                                      break;
                                  case "redraw":
                                      le.call(this);
                                      break;
                                  default:
                                      H.call(this, se, Ce && Ce[1])
                              }
                              return K.call(this)
                          }
                          if (Ee == "function") return void se.call(this, this);
                          if (Ee == "object") {
                              var Qe = 0;
                              Dt.call(this, se, function(Fe, YP) {
                                  Fe.span > Qe && (Qe = Fe.span), Fe.stop(), Fe.animate(YP)
                              }, function(Fe) {
                                  "wait" in Fe && (Qe = l(Fe.wait, 0))
                              }), xe.call(this), Qe > 0 && (this.timer = new J({
                                  duration: Qe,
                                  context: this
                              }), this.active = !0, ve && (this.timer.complete = K));
                              var bt = this,
                                  it = !1,
                                  zi = {};
                              R(function() {
                                  Dt.call(bt, se, function(Fe) {
                                      Fe.active && (it = !0, zi[Fe.name] = Fe.nextStyle)
                                  }), it && bt.$el.css(zi)
                              })
                          }
                      }
                  }

                  function Y(se) {
                      se = l(se, 0), this.active ? this.queue.push({
                          options: se
                      }) : (this.timer = new J({
                          duration: se,
                          context: this,
                          complete: K
                      }), this.active = !0)
                  }

                  function X(se) {
                      return this.active ? (this.queue.push({
                          options: se,
                          args: arguments
                      }), void(this.timer.complete = K)) : f("No active transition timer. Use start() or wait() before then().")
                  }

                  function K() {
                      if (this.timer && this.timer.destroy(), this.active = !1, this.queue.length) {
                          var se = this.queue.shift();
                          j.call(this, se.options, !0, se.args)
                      }
                  }

                  function te(se) {
                      this.timer && this.timer.destroy(), this.queue = [], this.active = !1;
                      var ve;
                      typeof se == "string" ? (ve = {}, ve[se] = 1) : ve = typeof se == "object" && se != null ? se : this.props, Dt.call(this, ve, Ye), xe.call(this)
                  }

                  function ne(se) {
                      te.call(this, se), Dt.call(this, se, Ln, $P)
                  }

                  function me(se) {
                      typeof se != "string" && (se = "block"), this.el.style.display = se
                  }

                  function ee() {
                      te.call(this), this.el.style.display = "none"
                  }

                  function le() {
                      this.el.offsetHeight
                  }

                  function pe() {
                      te.call(this), e.removeData(this.el, h), this.$el = this.el = null
                  }

                  function xe() {
                      var se, ve, Ce = [];
                      this.upstream && Ce.push(this.upstream);
                      for (se in this.props) ve = this.props[se], ve.active && Ce.push(ve.string);
                      Ce = Ce.join(","), this.style !== Ce && (this.style = Ce, this.el.style[U.transition.dom] = Ce)
                  }

                  function Dt(se, ve, Ce) {
                      var Ee, Qe, bt, it, zi = ve !== Ye,
                          Fe = {};
                      for (Ee in se) bt = se[Ee], Ee in Pe ? (Fe.transform || (Fe.transform = {}), Fe.transform[Ee] = bt) : (y.test(Ee) && (Ee = r(Ee)), Ee in ie ? Fe[Ee] = bt : (it || (it = {}), it[Ee] = bt));
                      for (Ee in Fe) {
                          if (bt = Fe[Ee], Qe = this.props[Ee], !Qe) {
                              if (!zi) continue;
                              Qe = H.call(this, Ee)
                          }
                          ve.call(this, Qe, bt)
                      }
                      Ce && it && Ce.call(this, it)
                  }

                  function Ye(se) {
                      se.stop()
                  }

                  function Ln(se, ve) {
                      se.set(ve)
                  }

                  function $P(se) {
                      this.$el.css(se)
                  }

                  function Et(se, ve) {
                      M[se] = function() {
                          return this.children ? KP.call(this, ve, arguments) : (this.el && ve.apply(this, arguments), this)
                      }
                  }

                  function KP(se, ve) {
                      var Ce, Ee = this.children.length;
                      for (Ce = 0; Ee > Ce; Ce++) se.apply(this.children[Ce], ve);
                      return this
                  }
                  M.init = function(se) {
                      if (this.$el = e(se), this.el = this.$el[0], this.props = {}, this.queue = [], this.style = "", this.active = !1, re.keepInherited && !re.fallback) {
                          var ve = ge(this.el, "transition");
                          ve && !L.test(ve) && (this.upstream = ve)
                      }
                      U.backface && re.hideBackface && fe(this.el, U.backface.css, "hidden")
                  }, Et("add", H), Et("start", j), Et("wait", Y), Et("then", X), Et("next", K), Et("stop", te), Et("set", ne), Et("show", me), Et("hide", ee), Et("redraw", le), Et("destroy", pe)
              }),
              N = c(P, function(M) {
                  function H(j, Y) {
                      var X = e.data(j, h) || e.data(j, h, new P.Bare);
                      return X.el || X.init(j), Y ? X.start(Y) : X
                  }
                  M.init = function(j, Y) {
                      var X = e(j);
                      if (!X.length) return this;
                      if (X.length === 1) return H(X[0], Y);
                      var K = [];
                      return X.each(function(te, ne) {
                          K.push(H(ne, Y))
                      }), this.children = K, this
                  }
              }),
              B = c(function(M) {
                  function H() {
                      var K = this.get();
                      this.update("auto");
                      var te = this.get();
                      return this.update(K), te
                  }

                  function j(K, te, ne) {
                      return te !== void 0 && (ne = te), K in v ? K : ne
                  }

                  function Y(K) {
                      var te = /rgba?\((\d+),\s*(\d+),\s*(\d+)/.exec(K);
                      return (te ? i(te[1], te[2], te[3]) : K)
                          .replace(/#(\w)(\w)(\w)$/, "#$1$1$2$2$3$3")
                  }
                  var X = {
                      duration: 500,
                      ease: "ease",
                      delay: 0
                  };
                  M.init = function(K, te, ne, me) {
                      this.$el = K, this.el = K[0];
                      var ee = te[0];
                      ne[2] && (ee = ne[2]), ye[ee] && (ee = ye[ee]), this.name = ee, this.type = ne[1], this.duration = l(te[1], this.duration, X.duration), this.ease = j(te[2], this.ease, X.ease), this.delay = l(te[3], this.delay, X.delay), this.span = this.duration + this.delay, this.active = !1, this.nextStyle = null, this.auto = D.test(this.name), this.unit = me.unit || this.unit || re.defaultUnit, this.angle = me.angle || this.angle || re.defaultAngle, re.fallback || me.fallback ? this.animate = this.fallback : (this.animate = this.transition, this.string = this.name + A + this.duration + "ms" + (this.ease != "ease" ? A + v[this.ease][0] : "") + (this.delay ? A + this.delay + "ms" : ""))
                  }, M.set = function(K) {
                      K = this.convert(K, this.type), this.update(K), this.redraw()
                  }, M.transition = function(K) {
                      this.active = !0, K = this.convert(K, this.type), this.auto && (this.el.style[this.name] == "auto" && (this.update(this.get()), this.redraw()), K == "auto" && (K = H.call(this))), this.nextStyle = K
                  }, M.fallback = function(K) {
                      var te = this.el.style[this.name] || this.convert(this.get(), this.type);
                      K = this.convert(K, this.type), this.auto && (te == "auto" && (te = this.convert(this.get(), this.type)), K == "auto" && (K = H.call(this))), this.tween = new G({
                          from: te,
                          to: K,
                          duration: this.duration,
                          delay: this.delay,
                          ease: this.ease,
                          update: this.update,
                          context: this
                      })
                  }, M.get = function() {
                      return ge(this.el, this.name)
                  }, M.update = function(K) {
                      fe(this.el, this.name, K)
                  }, M.stop = function() {
                      (this.active || this.nextStyle) && (this.active = !1, this.nextStyle = null, fe(this.el, this.name, this.get()));
                      var K = this.tween;
                      K && K.context && K.destroy()
                  }, M.convert = function(K, te) {
                      if (K == "auto" && this.auto) return K;
                      var ne, me = typeof K == "number",
                          ee = typeof K == "string";
                      switch (te) {
                          case b:
                              if (me) return K;
                              if (ee && K.replace(g, "") === "") return +K;
                              ne = "number(unitless)";
                              break;
                          case _:
                              if (ee) {
                                  if (K === "" && this.original) return this.original;
                                  if (te.test(K)) return K.charAt(0) == "#" && K.length == 7 ? K : Y(K)
                              }
                              ne = "hex or rgb string";
                              break;
                          case I:
                              if (me) return K + this.unit;
                              if (ee && te.test(K)) return K;
                              ne = "number(px) or string(unit)";
                              break;
                          case C:
                              if (me) return K + this.unit;
                              if (ee && te.test(K)) return K;
                              ne = "number(px) or string(unit or %)";
                              break;
                          case x:
                              if (me) return K + this.angle;
                              if (ee && te.test(K)) return K;
                              ne = "number(deg) or string(angle)";
                              break;
                          case O:
                              if (me || ee && C.test(K)) return K;
                              ne = "number(unitless) or string(unit or %)"
                      }
                      return s(ne, K), K
                  }, M.redraw = function() {
                      this.el.offsetHeight
                  }
              }),
              T = c(B, function(M, H) {
                  M.init = function() {
                      H.init.apply(this, arguments), this.original || (this.original = this.convert(this.get(), _))
                  }
              }),
              z = c(B, function(M, H) {
                  M.init = function() {
                      H.init.apply(this, arguments), this.animate = this.fallback
                  }, M.get = function() {
                      return this.$el[this.name]()
                  }, M.update = function(j) {
                      this.$el[this.name](j)
                  }
              }),
              Q = c(B, function(M, H) {
                  function j(Y, X) {
                      var K, te, ne, me, ee;
                      for (K in Y) me = Pe[K], ne = me[0], te = me[1] || K, ee = this.convert(Y[K], ne), X.call(this, te, ee, ne)
                  }
                  M.init = function() {
                      H.init.apply(this, arguments), this.current || (this.current = {}, Pe.perspective && re.perspective && (this.current.perspective = re.perspective, fe(this.el, this.name, this.style(this.current)), this.redraw()))
                  }, M.set = function(Y) {
                      j.call(this, Y, function(X, K) {
                          this.current[X] = K
                      }), fe(this.el, this.name, this.style(this.current)), this.redraw()
                  }, M.transition = function(Y) {
                      var X = this.values(Y);
                      this.tween = new ae({
                          current: this.current,
                          values: X,
                          duration: this.duration,
                          delay: this.delay,
                          ease: this.ease
                      });
                      var K, te = {};
                      for (K in this.current) te[K] = K in X ? X[K] : this.current[K];
                      this.active = !0, this.nextStyle = this.style(te)
                  }, M.fallback = function(Y) {
                      var X = this.values(Y);
                      this.tween = new ae({
                          current: this.current,
                          values: X,
                          duration: this.duration,
                          delay: this.delay,
                          ease: this.ease,
                          update: this.update,
                          context: this
                      })
                  }, M.update = function() {
                      fe(this.el, this.name, this.style(this.current))
                  }, M.style = function(Y) {
                      var X, K = "";
                      for (X in Y) K += X + "(" + Y[X] + ") ";
                      return K
                  }, M.values = function(Y) {
                      var X, K = {};
                      return j.call(this, Y, function(te, ne, me) {
                          K[te] = ne, this.current[te] === void 0 && (X = 0, ~te.indexOf("scale") && (X = 1), this.current[te] = this.convert(X, me))
                      }), K
                  }
              }),
              G = c(function(M) {
                  function H(ee) {
                      ne.push(ee) === 1 && R(j)
                  }

                  function j() {
                      var ee, le, pe, xe = ne.length;
                      if (xe)
                          for (R(j), le = V(), ee = xe; ee--;) pe = ne[ee], pe && pe.render(le)
                  }

                  function Y(ee) {
                      var le, pe = e.inArray(ee, ne);
                      pe >= 0 && (le = ne.slice(pe + 1), ne.length = pe, le.length && (ne = ne.concat(le)))
                  }

                  function X(ee) {
                      return Math.round(ee * me) / me
                  }

                  function K(ee, le, pe) {
                      return i(ee[0] + pe * (le[0] - ee[0]), ee[1] + pe * (le[1] - ee[1]), ee[2] + pe * (le[2] - ee[2]))
                  }
                  var te = {
                      ease: v.ease[1],
                      from: 0,
                      to: 1
                  };
                  M.init = function(ee) {
                      this.duration = ee.duration || 0, this.delay = ee.delay || 0;
                      var le = ee.ease || te.ease;
                      v[le] && (le = v[le][1]), typeof le != "function" && (le = te.ease), this.ease = le, this.update = ee.update || a, this.complete = ee.complete || a, this.context = ee.context || this, this.name = ee.name;
                      var pe = ee.from,
                          xe = ee.to;
                      pe === void 0 && (pe = te.from), xe === void 0 && (xe = te.to), this.unit = ee.unit || "", typeof pe == "number" && typeof xe == "number" ? (this.begin = pe, this.change = xe - pe) : this.format(xe, pe), this.value = this.begin + this.unit, this.start = V(), ee.autoplay !== !1 && this.play()
                  }, M.play = function() {
                      this.active || (this.start || (this.start = V()), this.active = !0, H(this))
                  }, M.stop = function() {
                      this.active && (this.active = !1, Y(this))
                  }, M.render = function(ee) {
                      var le, pe = ee - this.start;
                      if (this.delay) {
                          if (pe <= this.delay) return;
                          pe -= this.delay
                      }
                      if (pe < this.duration) {
                          var xe = this.ease(pe, 0, 1, this.duration);
                          return le = this.startRGB ? K(this.startRGB, this.endRGB, xe) : X(this.begin + xe * this.change), this.value = le + this.unit, void this.update.call(this.context, this.value)
                      }
                      le = this.endHex || this.begin + this.change, this.value = le + this.unit, this.update.call(this.context, this.value), this.complete.call(this.context), this.destroy()
                  }, M.format = function(ee, le) {
                      if (le += "", ee += "", ee.charAt(0) == "#") return this.startRGB = n(le), this.endRGB = n(ee), this.endHex = ee, this.begin = 0, void(this.change = 1);
                      if (!this.unit) {
                          var pe = le.replace(g, ""),
                              xe = ee.replace(g, "");
                          pe !== xe && o("tween", le, ee), this.unit = pe
                      }
                      le = parseFloat(le), ee = parseFloat(ee), this.begin = this.value = le, this.change = ee - le
                  }, M.destroy = function() {
                      this.stop(), this.context = null, this.ease = this.update = this.complete = a
                  };
                  var ne = [],
                      me = 1e3
              }),
              J = c(G, function(M) {
                  M.init = function(H) {
                      this.duration = H.duration || 0, this.complete = H.complete || a, this.context = H.context, this.play()
                  }, M.render = function(H) {
                      var j = H - this.start;
                      j < this.duration || (this.complete.call(this.context), this.destroy())
                  }
              }),
              ae = c(G, function(M, H) {
                  M.init = function(j) {
                      this.context = j.context, this.update = j.update, this.tweens = [], this.current = j.current;
                      var Y, X;
                      for (Y in j.values) X = j.values[Y], this.current[Y] !== X && this.tweens.push(new G({
                          name: Y,
                          from: this.current[Y],
                          to: X,
                          duration: j.duration,
                          delay: j.delay,
                          ease: j.ease,
                          autoplay: !1
                      }));
                      this.play()
                  }, M.render = function(j) {
                      var Y, X, K = this.tweens.length,
                          te = !1;
                      for (Y = K; Y--;) X = this.tweens[Y], X.context && (X.render(j), this.current[X.name] = X.value, te = !0);
                      return te ? void(this.update && this.update.call(this.context)) : this.destroy()
                  }, M.destroy = function() {
                      if (H.destroy.call(this), this.tweens) {
                          var j, Y = this.tweens.length;
                          for (j = Y; j--;) this.tweens[j].destroy();
                          this.tweens = null, this.current = null
                      }
                  }
              }),
              re = t.config = {
                  debug: !1,
                  defaultUnit: "px",
                  defaultAngle: "deg",
                  keepInherited: !1,
                  hideBackface: !1,
                  perspective: "",
                  fallback: !U.transition,
                  agentTests: []
              };
          t.fallback = function(M) {
              if (!U.transition) return re.fallback = !0;
              re.agentTests.push("(" + M + ")");
              var H = new RegExp(re.agentTests.join("|"), "i");
              re.fallback = H.test(navigator.userAgent)
          }, t.fallback("6.0.[2-5] Safari"), t.tween = function(M) {
              return new G(M)
          }, t.delay = function(M, H, j) {
              return new J({
                  complete: H,
                  duration: M,
                  context: j
              })
          }, e.fn.tram = function(M) {
              return t.call(null, this, M)
          };
          var fe = e.style,
              ge = e.css,
              ye = {
                  transform: U.transform && U.transform.css
              },
              ie = {
                  color: [T, _],
                  background: [T, _, "background-color"],
                  "outline-color": [T, _],
                  "border-color": [T, _],
                  "border-top-color": [T, _],
                  "border-right-color": [T, _],
                  "border-bottom-color": [T, _],
                  "border-left-color": [T, _],
                  "border-width": [B, I],
                  "border-top-width": [B, I],
                  "border-right-width": [B, I],
                  "border-bottom-width": [B, I],
                  "border-left-width": [B, I],
                  "border-spacing": [B, I],
                  "letter-spacing": [B, I],
                  margin: [B, I],
                  "margin-top": [B, I],
                  "margin-right": [B, I],
                  "margin-bottom": [B, I],
                  "margin-left": [B, I],
                  padding: [B, I],
                  "padding-top": [B, I],
                  "padding-right": [B, I],
                  "padding-bottom": [B, I],
                  "padding-left": [B, I],
                  "outline-width": [B, I],
                  opacity: [B, b],
                  top: [B, C],
                  right: [B, C],
                  bottom: [B, C],
                  left: [B, C],
                  "font-size": [B, C],
                  "text-indent": [B, C],
                  "word-spacing": [B, C],
                  width: [B, C],
                  "min-width": [B, C],
                  "max-width": [B, C],
                  height: [B, C],
                  "min-height": [B, C],
                  "max-height": [B, C],
                  "line-height": [B, O],
                  "scroll-top": [z, b, "scrollTop"],
                  "scroll-left": [z, b, "scrollLeft"]
              },
              Pe = {};
          U.transform && (ie.transform = [Q], Pe = {
              x: [C, "translateX"],
              y: [C, "translateY"],
              rotate: [x],
              rotateX: [x],
              rotateY: [x],
              scale: [b],
              scaleX: [b],
              scaleY: [b],
              skew: [x],
              skewX: [x],
              skewY: [x]
          }), U.transform && U.backface && (Pe.z = [C, "translateZ"], Pe.rotateZ = [x], Pe.scaleZ = [b], Pe.perspective = [I]);
          var Ge = /ms/,
              Ke = /s|\./;
          return e.tram = t
      }(window.jQuery)
  });
  var hc = E((Vte, uc) => {
      var sC = window.$,
          oC = lo() && sC.tram;
      uc.exports = function() {
          var e = {};
          e.VERSION = "1.6.0-Webflow";
          var t = {},
              r = Array.prototype,
              n = Object.prototype,
              i = Function.prototype,
              a = r.push,
              s = r.slice,
              o = r.concat,
              l = n.toString,
              f = n.hasOwnProperty,
              u = r.forEach,
              c = r.map,
              v = r.reduce,
              d = r.reduceRight,
              p = r.filter,
              m = r.every,
              h = r.some,
              g = r.indexOf,
              y = r.lastIndexOf,
              b = Array.isArray,
              _ = Object.keys,
              I = i.bind,
              C = e.each = e.forEach = function(w, F, k) {
                  if (w == null) return w;
                  if (u && w.forEach === u) w.forEach(F, k);
                  else if (w.length === +w.length) {
                      for (var U = 0, W = w.length; U < W; U++)
                          if (F.call(k, w[U], U, w) === t) return
                  } else
                      for (var S = e.keys(w), U = 0, W = S.length; U < W; U++)
                          if (F.call(k, w[S[U]], S[U], w) === t) return;
                  return w
              };
          e.map = e.collect = function(w, F, k) {
              var U = [];
              return w == null ? U : c && w.map === c ? w.map(F, k) : (C(w, function(W, S, R) {
                  U.push(F.call(k, W, S, R))
              }), U)
          }, e.find = e.detect = function(w, F, k) {
              var U;
              return x(w, function(W, S, R) {
                  if (F.call(k, W, S, R)) return U = W, !0
              }), U
          }, e.filter = e.select = function(w, F, k) {
              var U = [];
              return w == null ? U : p && w.filter === p ? w.filter(F, k) : (C(w, function(W, S, R) {
                  F.call(k, W, S, R) && U.push(W)
              }), U)
          };
          var x = e.some = e.any = function(w, F, k) {
              F || (F = e.identity);
              var U = !1;
              return w == null ? U : h && w.some === h ? w.some(F, k) : (C(w, function(W, S, R) {
                  if (U || (U = F.call(k, W, S, R))) return t
              }), !!U)
          };
          e.contains = e.include = function(w, F) {
              return w == null ? !1 : g && w.indexOf === g ? w.indexOf(F) != -1 : x(w, function(k) {
                  return k === F
              })
          }, e.delay = function(w, F) {
              var k = s.call(arguments, 2);
              return setTimeout(function() {
                  return w.apply(null, k)
              }, F)
          }, e.defer = function(w) {
              return e.delay.apply(e, [w, 1].concat(s.call(arguments, 1)))
          }, e.throttle = function(w) {
              var F, k, U;
              return function() {
                  F || (F = !0, k = arguments, U = this, oC.frame(function() {
                      F = !1, w.apply(U, k)
                  }))
              }
          }, e.debounce = function(w, F, k) {
              var U, W, S, R, V, P = function() {
                  var N = e.now() - R;
                  N < F ? U = setTimeout(P, F - N) : (U = null, k || (V = w.apply(S, W), S = W = null))
              };
              return function() {
                  S = this, W = arguments, R = e.now();
                  var N = k && !U;
                  return U || (U = setTimeout(P, F)), N && (V = w.apply(S, W), S = W = null), V
              }
          }, e.defaults = function(w) {
              if (!e.isObject(w)) return w;
              for (var F = 1, k = arguments.length; F < k; F++) {
                  var U = arguments[F];
                  for (var W in U) w[W] === void 0 && (w[W] = U[W])
              }
              return w
          }, e.keys = function(w) {
              if (!e.isObject(w)) return [];
              if (_) return _(w);
              var F = [];
              for (var k in w) e.has(w, k) && F.push(k);
              return F
          }, e.has = function(w, F) {
              return f.call(w, F)
          }, e.isObject = function(w) {
              return w === Object(w)
          }, e.now = Date.now || function() {
              return new Date()
                  .getTime()
          }, e.templateSettings = {
              evaluate: /<%([\s\S]+?)%>/g,
              interpolate: /<%=([\s\S]+?)%>/g,
              escape: /<%-([\s\S]+?)%>/g
          };
          var O = /(.)^/,
              L = {
                  "'": "'",
                  "\\": "\\",
                  "\r": "r",
                  "\n": "n",
                  "\u2028": "u2028",
                  "\u2029": "u2029"
              },
              D = /\\|'|\r|\n|\u2028|\u2029/g,
              A = function(w) {
                  return "\\" + L[w]
              },
              q = /^\s*(\w|\$)+\s*$/;
          return e.template = function(w, F, k) {
              !F && k && (F = k), F = e.defaults({}, F, e.templateSettings);
              var U = RegExp([(F.escape || O)
                      .source, (F.interpolate || O)
                      .source, (F.evaluate || O)
                      .source
                  ].join("|") + "|$", "g"),
                  W = 0,
                  S = "__p+='";
              w.replace(U, function(N, B, T, z, Q) {
                  return S += w.slice(W, Q)
                      .replace(D, A), W = Q + N.length, B ? S += `'+
((__t=(` + B + `))==null?'':_.escape(__t))+
'` : T ? S += `'+
((__t=(` + T + `))==null?'':__t)+
'` : z && (S += `';
` + z + `
__p+='`), N
              }), S += `';
`;
              var R = F.variable;
              if (R) {
                  if (!q.test(R)) throw new Error("variable is not a bare identifier: " + R)
              } else S = `with(obj||{}){
` + S + `}
`, R = "obj";
              S = `var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};
` + S + `return __p;
`;
              var V;
              try {
                  V = new Function(F.variable || "obj", "_", S)
              } catch (N) {
                  throw N.source = S, N
              }
              var P = function(N) {
                  return V.call(this, N, e)
              };
              return P.source = "function(" + R + `){
` + S + "}", P
          }, e
      }()
  });
  var Xe = E((Gte, yc) => {
      var be = {},
          $r = {},
          Kr = [],
          ho = window.Webflow || [],
          ar = window.jQuery,
          St = ar(window),
          lC = ar(document),
          Ft = ar.isFunction,
          _t = be._ = hc(),
          fc = be.tram = lo() && ar.tram,
          Wi = !1,
          co = !1;
      fc.config.hideBackface = !1;
      fc.config.keepInherited = !0;
      be.define = function(e, t, r) {
          $r[e] && dc($r[e]);
          var n = $r[e] = t(ar, _t, r) || {};
          return pc(n), n
      };
      be.require = function(e) {
          return $r[e]
      };

      function pc(e) {
          be.env() && (Ft(e.design) && St.on("__wf_design", e.design), Ft(e.preview) && St.on("__wf_preview", e.preview)), Ft(e.destroy) && St.on("__wf_destroy", e.destroy), e.ready && Ft(e.ready) && uC(e)
      }

      function uC(e) {
          if (Wi) {
              e.ready();
              return
          }
          _t.contains(Kr, e.ready) || Kr.push(e.ready)
      }

      function dc(e) {
          Ft(e.design) && St.off("__wf_design", e.design), Ft(e.preview) && St.off("__wf_preview", e.preview), Ft(e.destroy) && St.off("__wf_destroy", e.destroy), e.ready && Ft(e.ready) && hC(e)
      }

      function hC(e) {
          Kr = _t.filter(Kr, function(t) {
              return t !== e.ready
          })
      }
      be.push = function(e) {
          if (Wi) {
              Ft(e) && e();
              return
          }
          ho.push(e)
      };
      be.env = function(e) {
          var t = window.__wf_design,
              r = typeof t < "u";
          if (!e) return r;
          if (e === "design") return r && t;
          if (e === "preview") return r && !t;
          if (e === "slug") return r && window.__wf_slug;
          if (e === "editor") return window.WebflowEditor;
          if (e === "test") return window.__wf_test;
          if (e === "frame") return window !== window.top
      };
      var ji = navigator.userAgent.toLowerCase(),
          mc = be.env.touch = "ontouchstart" in window || window.DocumentTouch && document instanceof window.DocumentTouch,
          cC = be.env.chrome = /chrome/.test(ji) && /Google/.test(navigator.vendor) && parseInt(ji.match(/chrome\/(\d+)\./)[1], 10),
          fC = be.env.ios = /(ipod|iphone|ipad)/.test(ji);
      be.env.safari = /safari/.test(ji) && !cC && !fC;
      var uo;
      mc && lC.on("touchstart mousedown", function(e) {
          uo = e.target
      });
      be.validClick = mc ? function(e) {
          return e === uo || ar.contains(e, uo)
      } : function() {
          return !0
      };
      var vc = "resize.webflow orientationchange.webflow load.webflow",
          pC = "scroll.webflow " + vc;
      be.resize = fo(St, vc);
      be.scroll = fo(St, pC);
      be.redraw = fo();

      function fo(e, t) {
          var r = [],
              n = {};
          return n.up = _t.throttle(function(i) {
              _t.each(r, function(a) {
                  a(i)
              })
          }), e && t && e.on(t, n.up), n.on = function(i) {
              typeof i == "function" && (_t.contains(r, i) || r.push(i))
          }, n.off = function(i) {
              if (!arguments.length) {
                  r = [];
                  return
              }
              r = _t.filter(r, function(a) {
                  return a !== i
              })
          }, n
      }
      be.location = function(e) {
          window.location = e
      };
      be.env() && (be.location = function() {});
      be.ready = function() {
          Wi = !0, co ? dC() : _t.each(Kr, cc), _t.each(ho, cc), be.resize.up()
      };

      function cc(e) {
          Ft(e) && e()
      }

      function dC() {
          co = !1, _t.each($r, pc)
      }
      var Ar;
      be.load = function(e) {
          Ar.then(e)
      };

      function gc() {
          Ar && (Ar.reject(), St.off("load", Ar.resolve)), Ar = new ar.Deferred, St.on("load", Ar.resolve)
      }
      be.destroy = function(e) {
          e = e || {}, co = !0, St.triggerHandler("__wf_destroy"), e.domready != null && (Wi = e.domready), _t.each($r, dc), be.resize.off(), be.scroll.off(), be.redraw.off(), Kr = [], ho = [], Ar.state() === "pending" && gc()
      };
      ar(be.ready);
      gc();
      yc.exports = window.Webflow = be
  });
  var ut = E((zte, kn) => {
      function mC(e) {
          return e && e.__esModule ? e : {
              default: e
          }
      }
      kn.exports = mC, kn.exports.__esModule = !0, kn.exports.default = kn.exports
  });
  var Pr = E((Hte, Xt) => {
      function po() {
          return Xt.exports = po = Object.assign ? Object.assign.bind() : function(e) {
              for (var t = 1; t < arguments.length; t++) {
                  var r = arguments[t];
                  for (var n in r) Object.prototype.hasOwnProperty.call(r, n) && (e[n] = r[n])
              }
              return e
          }, Xt.exports.__esModule = !0, Xt.exports.default = Xt.exports, po.apply(this, arguments)
      }
      Xt.exports = po, Xt.exports.__esModule = !0, Xt.exports.default = Xt.exports
  });
  var Ec = E((jte, Nn) => {
      function vC(e, t, r) {
          return t in e ? Object.defineProperty(e, t, {
              value: r,
              enumerable: !0,
              configurable: !0,
              writable: !0
          }) : e[t] = r, e
      }
      Nn.exports = vC, Nn.exports.__esModule = !0, Nn.exports.default = Nn.exports
  });
  var mo = E((Wte, bc) => {
      function gC(e, t, r, n) {
          for (var i = e.length, a = r + (n ? 1 : -1); n ? a-- : ++a < i;)
              if (t(e[a], a, e)) return a;
          return -1
      }
      bc.exports = gC
  });
  var Sc = E((Ute, _c) => {
      function yC() {
          this.__data__ = [], this.size = 0
      }
      _c.exports = yC
  });
  var Ui = E((Xte, Ic) => {
      function EC(e, t) {
          return e === t || e !== e && t !== t
      }
      Ic.exports = EC
  });
  var Bn = E(($te, Tc) => {
      var bC = Ui();

      function _C(e, t) {
          for (var r = e.length; r--;)
              if (bC(e[r][0], t)) return r;
          return -1
      }
      Tc.exports = _C
  });
  var Ac = E((Kte, xc) => {
      var SC = Bn(),
          IC = Array.prototype,
          TC = IC.splice;

      function xC(e) {
          var t = this.__data__,
              r = SC(t, e);
          if (r < 0) return !1;
          var n = t.length - 1;
          return r == n ? t.pop() : TC.call(t, r, 1), --this.size, !0
      }
      xc.exports = xC
  });
  var Cc = E((Yte, Pc) => {
      var AC = Bn();

      function PC(e) {
          var t = this.__data__,
              r = AC(t, e);
          return r < 0 ? void 0 : t[r][1]
      }
      Pc.exports = PC
  });
  var Oc = E((Qte, wc) => {
      var CC = Bn();

      function wC(e) {
          return CC(this.__data__, e) > -1
      }
      wc.exports = wC
  });
  var Rc = E((Zte, Mc) => {
      var OC = Bn();

      function MC(e, t) {
          var r = this.__data__,
              n = OC(r, e);
          return n < 0 ? (++this.size, r.push([e, t])) : r[n][1] = t, this
      }
      Mc.exports = MC
  });
  var Vn = E((Jte, Dc) => {
      var RC = Sc(),
          DC = Ac(),
          FC = Cc(),
          qC = Oc(),
          LC = Rc();

      function Yr(e) {
          var t = -1,
              r = e == null ? 0 : e.length;
          for (this.clear(); ++t < r;) {
              var n = e[t];
              this.set(n[0], n[1])
          }
      }
      Yr.prototype.clear = RC;
      Yr.prototype.delete = DC;
      Yr.prototype.get = FC;
      Yr.prototype.has = qC;
      Yr.prototype.set = LC;
      Dc.exports = Yr
  });
  var qc = E((ere, Fc) => {
      var kC = Vn();

      function NC() {
          this.__data__ = new kC, this.size = 0
      }
      Fc.exports = NC
  });
  var kc = E((tre, Lc) => {
      function BC(e) {
          var t = this.__data__,
              r = t.delete(e);
          return this.size = t.size, r
      }
      Lc.exports = BC
  });
  var Bc = E((rre, Nc) => {
      function VC(e) {
          return this.__data__.get(e)
      }
      Nc.exports = VC
  });
  var Gc = E((nre, Vc) => {
      function GC(e) {
          return this.__data__.has(e)
      }
      Vc.exports = GC
  });
  var vo = E((ire, zc) => {
      var zC = typeof global == "object" && global && global.Object === Object && global;
      zc.exports = zC
  });
  var It = E((are, Hc) => {
      var HC = vo(),
          jC = typeof self == "object" && self && self.Object === Object && self,
          WC = HC || jC || Function("return this")();
      Hc.exports = WC
  });
  var Qr = E((sre, jc) => {
      var UC = It(),
          XC = UC.Symbol;
      jc.exports = XC
  });
  var $c = E((ore, Xc) => {
      var Wc = Qr(),
          Uc = Object.prototype,
          $C = Uc.hasOwnProperty,
          KC = Uc.toString,
          Gn = Wc ? Wc.toStringTag : void 0;

      function YC(e) {
          var t = $C.call(e, Gn),
              r = e[Gn];
          try {
              e[Gn] = void 0;
              var n = !0
          } catch {}
          var i = KC.call(e);
          return n && (t ? e[Gn] = r : delete e[Gn]), i
      }
      Xc.exports = YC
  });
  var Yc = E((lre, Kc) => {
      var QC = Object.prototype,
          ZC = QC.toString;

      function JC(e) {
          return ZC.call(e)
      }
      Kc.exports = JC
  });
  var sr = E((ure, Jc) => {
      var Qc = Qr(),
          ew = $c(),
          tw = Yc(),
          rw = "[object Null]",
          nw = "[object Undefined]",
          Zc = Qc ? Qc.toStringTag : void 0;

      function iw(e) {
          return e == null ? e === void 0 ? nw : rw : Zc && Zc in Object(e) ? ew(e) : tw(e)
      }
      Jc.exports = iw
  });
  var qt = E((hre, ef) => {
      function aw(e) {
          var t = typeof e;
          return e != null && (t == "object" || t == "function")
      }
      ef.exports = aw
  });
  var go = E((cre, tf) => {
      var sw = sr(),
          ow = qt(),
          lw = "[object AsyncFunction]",
          uw = "[object Function]",
          hw = "[object GeneratorFunction]",
          cw = "[object Proxy]";

      function fw(e) {
          if (!ow(e)) return !1;
          var t = sw(e);
          return t == uw || t == hw || t == lw || t == cw
      }
      tf.exports = fw
  });
  var nf = E((fre, rf) => {
      var pw = It(),
          dw = pw["__core-js_shared__"];
      rf.exports = dw
  });
  var of = E((pre, sf) => {
      var yo = nf(),
          af = function() {
              var e = /[^.]+$/.exec(yo && yo.keys && yo.keys.IE_PROTO || "");
              return e ? "Symbol(src)_1." + e : ""
          }();

      function mw(e) {
          return !!af && af in e
      }
      sf.exports = mw
  });
  var Eo = E((dre, lf) => {
      var vw = Function.prototype,
          gw = vw.toString;

      function yw(e) {
          if (e != null) {
              try {
                  return gw.call(e)
              } catch {}
              try {
                  return e + ""
              } catch {}
          }
          return ""
      }
      lf.exports = yw
  });
  var hf = E((mre, uf) => {
      var Ew = go(),
          bw = of(),
          _w = qt(),
          Sw = Eo(),
          Iw = /[\\^$.*+?()[\]{}|]/g,
          Tw = /^\[object .+?Constructor\]$/,
          xw = Function.prototype,
          Aw = Object.prototype,
          Pw = xw.toString,
          Cw = Aw.hasOwnProperty,
          ww = RegExp("^" + Pw.call(Cw)
              .replace(Iw, "\\$&")
              .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");

      function Ow(e) {
          if (!_w(e) || bw(e)) return !1;
          var t = Ew(e) ? ww : Tw;
          return t.test(Sw(e))
      }
      uf.exports = Ow
  });
  var ff = E((vre, cf) => {
      function Mw(e, t) {
          return e?.[t]
      }
      cf.exports = Mw
  });
  var or = E((gre, pf) => {
      var Rw = hf(),
          Dw = ff();

      function Fw(e, t) {
          var r = Dw(e, t);
          return Rw(r) ? r : void 0
      }
      pf.exports = Fw
  });
  var Xi = E((yre, df) => {
      var qw = or(),
          Lw = It(),
          kw = qw(Lw, "Map");
      df.exports = kw
  });
  var zn = E((Ere, mf) => {
      var Nw = or(),
          Bw = Nw(Object, "create");
      mf.exports = Bw
  });
  var yf = E((bre, gf) => {
      var vf = zn();

      function Vw() {
          this.__data__ = vf ? vf(null) : {}, this.size = 0
      }
      gf.exports = Vw
  });
  var bf = E((_re, Ef) => {
      function Gw(e) {
          var t = this.has(e) && delete this.__data__[e];
          return this.size -= t ? 1 : 0, t
      }
      Ef.exports = Gw
  });
  var Sf = E((Sre, _f) => {
      var zw = zn(),
          Hw = "__lodash_hash_undefined__",
          jw = Object.prototype,
          Ww = jw.hasOwnProperty;

      function Uw(e) {
          var t = this.__data__;
          if (zw) {
              var r = t[e];
              return r === Hw ? void 0 : r
          }
          return Ww.call(t, e) ? t[e] : void 0
      }
      _f.exports = Uw
  });
  var Tf = E((Ire, If) => {
      var Xw = zn(),
          $w = Object.prototype,
          Kw = $w.hasOwnProperty;

      function Yw(e) {
          var t = this.__data__;
          return Xw ? t[e] !== void 0 : Kw.call(t, e)
      }
      If.exports = Yw
  });
  var Af = E((Tre, xf) => {
      var Qw = zn(),
          Zw = "__lodash_hash_undefined__";

      function Jw(e, t) {
          var r = this.__data__;
          return this.size += this.has(e) ? 0 : 1, r[e] = Qw && t === void 0 ? Zw : t, this
      }
      xf.exports = Jw
  });
  var Cf = E((xre, Pf) => {
      var eO = yf(),
          tO = bf(),
          rO = Sf(),
          nO = Tf(),
          iO = Af();

      function Zr(e) {
          var t = -1,
              r = e == null ? 0 : e.length;
          for (this.clear(); ++t < r;) {
              var n = e[t];
              this.set(n[0], n[1])
          }
      }
      Zr.prototype.clear = eO;
      Zr.prototype.delete = tO;
      Zr.prototype.get = rO;
      Zr.prototype.has = nO;
      Zr.prototype.set = iO;
      Pf.exports = Zr
  });
  var Mf = E((Are, Of) => {
      var wf = Cf(),
          aO = Vn(),
          sO = Xi();

      function oO() {
          this.size = 0, this.__data__ = {
              hash: new wf,
              map: new(sO || aO),
              string: new wf
          }
      }
      Of.exports = oO
  });
  var Df = E((Pre, Rf) => {
      function lO(e) {
          var t = typeof e;
          return t == "string" || t == "number" || t == "symbol" || t == "boolean" ? e !== "__proto__" : e === null
      }
      Rf.exports = lO
  });
  var Hn = E((Cre, Ff) => {
      var uO = Df();

      function hO(e, t) {
          var r = e.__data__;
          return uO(t) ? r[typeof t == "string" ? "string" : "hash"] : r.map
      }
      Ff.exports = hO
  });
  var Lf = E((wre, qf) => {
      var cO = Hn();

      function fO(e) {
          var t = cO(this, e)
              .delete(e);
          return this.size -= t ? 1 : 0, t
      }
      qf.exports = fO
  });
  var Nf = E((Ore, kf) => {
      var pO = Hn();

      function dO(e) {
          return pO(this, e)
              .get(e)
      }
      kf.exports = dO
  });
  var Vf = E((Mre, Bf) => {
      var mO = Hn();

      function vO(e) {
          return mO(this, e)
              .has(e)
      }
      Bf.exports = vO
  });
  var zf = E((Rre, Gf) => {
      var gO = Hn();

      function yO(e, t) {
          var r = gO(this, e),
              n = r.size;
          return r.set(e, t), this.size += r.size == n ? 0 : 1, this
      }
      Gf.exports = yO
  });
  var $i = E((Dre, Hf) => {
      var EO = Mf(),
          bO = Lf(),
          _O = Nf(),
          SO = Vf(),
          IO = zf();

      function Jr(e) {
          var t = -1,
              r = e == null ? 0 : e.length;
          for (this.clear(); ++t < r;) {
              var n = e[t];
              this.set(n[0], n[1])
          }
      }
      Jr.prototype.clear = EO;
      Jr.prototype.delete = bO;
      Jr.prototype.get = _O;
      Jr.prototype.has = SO;
      Jr.prototype.set = IO;
      Hf.exports = Jr
  });
  var Wf = E((Fre, jf) => {
      var TO = Vn(),
          xO = Xi(),
          AO = $i(),
          PO = 200;

      function CO(e, t) {
          var r = this.__data__;
          if (r instanceof TO) {
              var n = r.__data__;
              if (!xO || n.length < PO - 1) return n.push([e, t]), this.size = ++r.size, this;
              r = this.__data__ = new AO(n)
          }
          return r.set(e, t), this.size = r.size, this
      }
      jf.exports = CO
  });
  var bo = E((qre, Uf) => {
      var wO = Vn(),
          OO = qc(),
          MO = kc(),
          RO = Bc(),
          DO = Gc(),
          FO = Wf();

      function en(e) {
          var t = this.__data__ = new wO(e);
          this.size = t.size
      }
      en.prototype.clear = OO;
      en.prototype.delete = MO;
      en.prototype.get = RO;
      en.prototype.has = DO;
      en.prototype.set = FO;
      Uf.exports = en
  });
  var $f = E((Lre, Xf) => {
      var qO = "__lodash_hash_undefined__";

      function LO(e) {
          return this.__data__.set(e, qO), this
      }
      Xf.exports = LO
  });
  var Yf = E((kre, Kf) => {
      function kO(e) {
          return this.__data__.has(e)
      }
      Kf.exports = kO
  });
  var Zf = E((Nre, Qf) => {
      var NO = $i(),
          BO = $f(),
          VO = Yf();

      function Ki(e) {
          var t = -1,
              r = e == null ? 0 : e.length;
          for (this.__data__ = new NO; ++t < r;) this.add(e[t])
      }
      Ki.prototype.add = Ki.prototype.push = BO;
      Ki.prototype.has = VO;
      Qf.exports = Ki
  });
  var ep = E((Bre, Jf) => {
      function GO(e, t) {
          for (var r = -1, n = e == null ? 0 : e.length; ++r < n;)
              if (t(e[r], r, e)) return !0;
          return !1
      }
      Jf.exports = GO
  });
  var rp = E((Vre, tp) => {
      function zO(e, t) {
          return e.has(t)
      }
      tp.exports = zO
  });
  var _o = E((Gre, np) => {
      var HO = Zf(),
          jO = ep(),
          WO = rp(),
          UO = 1,
          XO = 2;

      function $O(e, t, r, n, i, a) {
          var s = r & UO,
              o = e.length,
              l = t.length;
          if (o != l && !(s && l > o)) return !1;
          var f = a.get(e),
              u = a.get(t);
          if (f && u) return f == t && u == e;
          var c = -1,
              v = !0,
              d = r & XO ? new HO : void 0;
          for (a.set(e, t), a.set(t, e); ++c < o;) {
              var p = e[c],
                  m = t[c];
              if (n) var h = s ? n(m, p, c, t, e, a) : n(p, m, c, e, t, a);
              if (h !== void 0) {
                  if (h) continue;
                  v = !1;
                  break
              }
              if (d) {
                  if (!jO(t, function(g, y) {
                          if (!WO(d, y) && (p === g || i(p, g, r, n, a))) return d.push(y)
                      })) {
                      v = !1;
                      break
                  }
              } else if (!(p === m || i(p, m, r, n, a))) {
                  v = !1;
                  break
              }
          }
          return a.delete(e), a.delete(t), v
      }
      np.exports = $O
  });
  var ap = E((zre, ip) => {
      var KO = It(),
          YO = KO.Uint8Array;
      ip.exports = YO
  });
  var op = E((Hre, sp) => {
      function QO(e) {
          var t = -1,
              r = Array(e.size);
          return e.forEach(function(n, i) {
              r[++t] = [i, n]
          }), r
      }
      sp.exports = QO
  });
  var up = E((jre, lp) => {
      function ZO(e) {
          var t = -1,
              r = Array(e.size);
          return e.forEach(function(n) {
              r[++t] = n
          }), r
      }
      lp.exports = ZO
  });
  var dp = E((Wre, pp) => {
      var hp = Qr(),
          cp = ap(),
          JO = Ui(),
          eM = _o(),
          tM = op(),
          rM = up(),
          nM = 1,
          iM = 2,
          aM = "[object Boolean]",
          sM = "[object Date]",
          oM = "[object Error]",
          lM = "[object Map]",
          uM = "[object Number]",
          hM = "[object RegExp]",
          cM = "[object Set]",
          fM = "[object String]",
          pM = "[object Symbol]",
          dM = "[object ArrayBuffer]",
          mM = "[object DataView]",
          fp = hp ? hp.prototype : void 0,
          So = fp ? fp.valueOf : void 0;

      function vM(e, t, r, n, i, a, s) {
          switch (r) {
              case mM:
                  if (e.byteLength != t.byteLength || e.byteOffset != t.byteOffset) return !1;
                  e = e.buffer, t = t.buffer;
              case dM:
                  return !(e.byteLength != t.byteLength || !a(new cp(e), new cp(t)));
              case aM:
              case sM:
              case uM:
                  return JO(+e, +t);
              case oM:
                  return e.name == t.name && e.message == t.message;
              case hM:
              case fM:
                  return e == t + "";
              case lM:
                  var o = tM;
              case cM:
                  var l = n & nM;
                  if (o || (o = rM), e.size != t.size && !l) return !1;
                  var f = s.get(e);
                  if (f) return f == t;
                  n |= iM, s.set(e, t);
                  var u = eM(o(e), o(t), n, i, a, s);
                  return s.delete(e), u;
              case pM:
                  if (So) return So.call(e) == So.call(t)
          }
          return !1
      }
      pp.exports = vM
  });
  var Yi = E((Ure, mp) => {
      function gM(e, t) {
          for (var r = -1, n = t.length, i = e.length; ++r < n;) e[i + r] = t[r];
          return e
      }
      mp.exports = gM
  });
  var ze = E((Xre, vp) => {
      var yM = Array.isArray;
      vp.exports = yM
  });
  var Io = E(($re, gp) => {
      var EM = Yi(),
          bM = ze();

      function _M(e, t, r) {
          var n = t(e);
          return bM(e) ? n : EM(n, r(e))
      }
      gp.exports = _M
  });
  var Ep = E((Kre, yp) => {
      function SM(e, t) {
          for (var r = -1, n = e == null ? 0 : e.length, i = 0, a = []; ++r < n;) {
              var s = e[r];
              t(s, r, e) && (a[i++] = s)
          }
          return a
      }
      yp.exports = SM
  });
  var To = E((Yre, bp) => {
      function IM() {
          return []
      }
      bp.exports = IM
  });
  var xo = E((Qre, Sp) => {
      var TM = Ep(),
          xM = To(),
          AM = Object.prototype,
          PM = AM.propertyIsEnumerable,
          _p = Object.getOwnPropertySymbols,
          CM = _p ? function(e) {
              return e == null ? [] : (e = Object(e), TM(_p(e), function(t) {
                  return PM.call(e, t)
              }))
          } : xM;
      Sp.exports = CM
  });
  var Tp = E((Zre, Ip) => {
      function wM(e, t) {
          for (var r = -1, n = Array(e); ++r < e;) n[r] = t(r);
          return n
      }
      Ip.exports = wM
  });
  var $t = E((Jre, xp) => {
      function OM(e) {
          return e != null && typeof e == "object"
      }
      xp.exports = OM
  });
  var Pp = E((ene, Ap) => {
      var MM = sr(),
          RM = $t(),
          DM = "[object Arguments]";

      function FM(e) {
          return RM(e) && MM(e) == DM
      }
      Ap.exports = FM
  });
  var jn = E((tne, Op) => {
      var Cp = Pp(),
          qM = $t(),
          wp = Object.prototype,
          LM = wp.hasOwnProperty,
          kM = wp.propertyIsEnumerable,
          NM = Cp(function() {
              return arguments
          }()) ? Cp : function(e) {
              return qM(e) && LM.call(e, "callee") && !kM.call(e, "callee")
          };
      Op.exports = NM
  });
  var Rp = E((rne, Mp) => {
      function BM() {
          return !1
      }
      Mp.exports = BM
  });
  var Qi = E((Wn, tn) => {
      var VM = It(),
          GM = Rp(),
          qp = typeof Wn == "object" && Wn && !Wn.nodeType && Wn,
          Dp = qp && typeof tn == "object" && tn && !tn.nodeType && tn,
          zM = Dp && Dp.exports === qp,
          Fp = zM ? VM.Buffer : void 0,
          HM = Fp ? Fp.isBuffer : void 0,
          jM = HM || GM;
      tn.exports = jM
  });
  var Zi = E((nne, Lp) => {
      var WM = 9007199254740991,
          UM = /^(?:0|[1-9]\d*)$/;

      function XM(e, t) {
          var r = typeof e;
          return t = t ?? WM, !!t && (r == "number" || r != "symbol" && UM.test(e)) && e > -1 && e % 1 == 0 && e < t
      }
      Lp.exports = XM
  });
  var Ji = E((ine, kp) => {
      var $M = 9007199254740991;

      function KM(e) {
          return typeof e == "number" && e > -1 && e % 1 == 0 && e <= $M
      }
      kp.exports = KM
  });
  var Bp = E((ane, Np) => {
      var YM = sr(),
          QM = Ji(),
          ZM = $t(),
          JM = "[object Arguments]",
          eR = "[object Array]",
          tR = "[object Boolean]",
          rR = "[object Date]",
          nR = "[object Error]",
          iR = "[object Function]",
          aR = "[object Map]",
          sR = "[object Number]",
          oR = "[object Object]",
          lR = "[object RegExp]",
          uR = "[object Set]",
          hR = "[object String]",
          cR = "[object WeakMap]",
          fR = "[object ArrayBuffer]",
          pR = "[object DataView]",
          dR = "[object Float32Array]",
          mR = "[object Float64Array]",
          vR = "[object Int8Array]",
          gR = "[object Int16Array]",
          yR = "[object Int32Array]",
          ER = "[object Uint8Array]",
          bR = "[object Uint8ClampedArray]",
          _R = "[object Uint16Array]",
          SR = "[object Uint32Array]",
          Ie = {};
      Ie[dR] = Ie[mR] = Ie[vR] = Ie[gR] = Ie[yR] = Ie[ER] = Ie[bR] = Ie[_R] = Ie[SR] = !0;
      Ie[JM] = Ie[eR] = Ie[fR] = Ie[tR] = Ie[pR] = Ie[rR] = Ie[nR] = Ie[iR] = Ie[aR] = Ie[sR] = Ie[oR] = Ie[lR] = Ie[uR] = Ie[hR] = Ie[cR] = !1;

      function IR(e) {
          return ZM(e) && QM(e.length) && !!Ie[YM(e)]
      }
      Np.exports = IR
  });
  var Gp = E((sne, Vp) => {
      function TR(e) {
          return function(t) {
              return e(t)
          }
      }
      Vp.exports = TR
  });
  var Hp = E((Un, rn) => {
      var xR = vo(),
          zp = typeof Un == "object" && Un && !Un.nodeType && Un,
          Xn = zp && typeof rn == "object" && rn && !rn.nodeType && rn,
          AR = Xn && Xn.exports === zp,
          Ao = AR && xR.process,
          PR = function() {
              try {
                  var e = Xn && Xn.require && Xn.require("util")
                      .types;
                  return e || Ao && Ao.binding && Ao.binding("util")
              } catch {}
          }();
      rn.exports = PR
  });
  var ea = E((one, Up) => {
      var CR = Bp(),
          wR = Gp(),
          jp = Hp(),
          Wp = jp && jp.isTypedArray,
          OR = Wp ? wR(Wp) : CR;
      Up.exports = OR
  });
  var Po = E((lne, Xp) => {
      var MR = Tp(),
          RR = jn(),
          DR = ze(),
          FR = Qi(),
          qR = Zi(),
          LR = ea(),
          kR = Object.prototype,
          NR = kR.hasOwnProperty;

      function BR(e, t) {
          var r = DR(e),
              n = !r && RR(e),
              i = !r && !n && FR(e),
              a = !r && !n && !i && LR(e),
              s = r || n || i || a,
              o = s ? MR(e.length, String) : [],
              l = o.length;
          for (var f in e)(t || NR.call(e, f)) && !(s && (f == "length" || i && (f == "offset" || f == "parent") || a && (f == "buffer" || f == "byteLength" || f == "byteOffset") || qR(f, l))) && o.push(f);
          return o
      }
      Xp.exports = BR
  });
  var ta = E((une, $p) => {
      var VR = Object.prototype;

      function GR(e) {
          var t = e && e.constructor,
              r = typeof t == "function" && t.prototype || VR;
          return e === r
      }
      $p.exports = GR
  });
  var Co = E((hne, Kp) => {
      function zR(e, t) {
          return function(r) {
              return e(t(r))
          }
      }
      Kp.exports = zR
  });
  var Qp = E((cne, Yp) => {
      var HR = Co(),
          jR = HR(Object.keys, Object);
      Yp.exports = jR
  });
  var ra = E((fne, Zp) => {
      var WR = ta(),
          UR = Qp(),
          XR = Object.prototype,
          $R = XR.hasOwnProperty;

      function KR(e) {
          if (!WR(e)) return UR(e);
          var t = [];
          for (var r in Object(e)) $R.call(e, r) && r != "constructor" && t.push(r);
          return t
      }
      Zp.exports = KR
  });
  var Cr = E((pne, Jp) => {
      var YR = go(),
          QR = Ji();

      function ZR(e) {
          return e != null && QR(e.length) && !YR(e)
      }
      Jp.exports = ZR
  });
  var $n = E((dne, ed) => {
      var JR = Po(),
          eD = ra(),
          tD = Cr();

      function rD(e) {
          return tD(e) ? JR(e) : eD(e)
      }
      ed.exports = rD
  });
  var rd = E((mne, td) => {
      var nD = Io(),
          iD = xo(),
          aD = $n();

      function sD(e) {
          return nD(e, aD, iD)
      }
      td.exports = sD
  });
  var ad = E((vne, id) => {
      var nd = rd(),
          oD = 1,
          lD = Object.prototype,
          uD = lD.hasOwnProperty;

      function hD(e, t, r, n, i, a) {
          var s = r & oD,
              o = nd(e),
              l = o.length,
              f = nd(t),
              u = f.length;
          if (l != u && !s) return !1;
          for (var c = l; c--;) {
              var v = o[c];
              if (!(s ? v in t : uD.call(t, v))) return !1
          }
          var d = a.get(e),
              p = a.get(t);
          if (d && p) return d == t && p == e;
          var m = !0;
          a.set(e, t), a.set(t, e);
          for (var h = s; ++c < l;) {
              v = o[c];
              var g = e[v],
                  y = t[v];
              if (n) var b = s ? n(y, g, v, t, e, a) : n(g, y, v, e, t, a);
              if (!(b === void 0 ? g === y || i(g, y, r, n, a) : b)) {
                  m = !1;
                  break
              }
              h || (h = v == "constructor")
          }
          if (m && !h) {
              var _ = e.constructor,
                  I = t.constructor;
              _ != I && "constructor" in e && "constructor" in t && !(typeof _ == "function" && _ instanceof _ && typeof I == "function" && I instanceof I) && (m = !1)
          }
          return a.delete(e), a.delete(t), m
      }
      id.exports = hD
  });
  var od = E((gne, sd) => {
      var cD = or(),
          fD = It(),
          pD = cD(fD, "DataView");
      sd.exports = pD
  });
  var ud = E((yne, ld) => {
      var dD = or(),
          mD = It(),
          vD = dD(mD, "Promise");
      ld.exports = vD
  });
  var cd = E((Ene, hd) => {
      var gD = or(),
          yD = It(),
          ED = gD(yD, "Set");
      hd.exports = ED
  });
  var wo = E((bne, fd) => {
      var bD = or(),
          _D = It(),
          SD = bD(_D, "WeakMap");
      fd.exports = SD
  });
  var na = E((_ne, Ed) => {
      var Oo = od(),
          Mo = Xi(),
          Ro = ud(),
          Do = cd(),
          Fo = wo(),
          yd = sr(),
          nn = Eo(),
          pd = "[object Map]",
          ID = "[object Object]",
          dd = "[object Promise]",
          md = "[object Set]",
          vd = "[object WeakMap]",
          gd = "[object DataView]",
          TD = nn(Oo),
          xD = nn(Mo),
          AD = nn(Ro),
          PD = nn(Do),
          CD = nn(Fo),
          wr = yd;
      (Oo && wr(new Oo(new ArrayBuffer(1))) != gd || Mo && wr(new Mo) != pd || Ro && wr(Ro.resolve()) != dd || Do && wr(new Do) != md || Fo && wr(new Fo) != vd) && (wr = function(e) {
          var t = yd(e),
              r = t == ID ? e.constructor : void 0,
              n = r ? nn(r) : "";
          if (n) switch (n) {
              case TD:
                  return gd;
              case xD:
                  return pd;
              case AD:
                  return dd;
              case PD:
                  return md;
              case CD:
                  return vd
          }
          return t
      });
      Ed.exports = wr
  });
  var Pd = E((Sne, Ad) => {
      var qo = bo(),
          wD = _o(),
          OD = dp(),
          MD = ad(),
          bd = na(),
          _d = ze(),
          Sd = Qi(),
          RD = ea(),
          DD = 1,
          Id = "[object Arguments]",
          Td = "[object Array]",
          ia = "[object Object]",
          FD = Object.prototype,
          xd = FD.hasOwnProperty;

      function qD(e, t, r, n, i, a) {
          var s = _d(e),
              o = _d(t),
              l = s ? Td : bd(e),
              f = o ? Td : bd(t);
          l = l == Id ? ia : l, f = f == Id ? ia : f;
          var u = l == ia,
              c = f == ia,
              v = l == f;
          if (v && Sd(e)) {
              if (!Sd(t)) return !1;
              s = !0, u = !1
          }
          if (v && !u) return a || (a = new qo), s || RD(e) ? wD(e, t, r, n, i, a) : OD(e, t, l, r, n, i, a);
          if (!(r & DD)) {
              var d = u && xd.call(e, "__wrapped__"),
                  p = c && xd.call(t, "__wrapped__");
              if (d || p) {
                  var m = d ? e.value() : e,
                      h = p ? t.value() : t;
                  return a || (a = new qo), i(m, h, r, n, a)
              }
          }
          return v ? (a || (a = new qo), MD(e, t, r, n, i, a)) : !1
      }
      Ad.exports = qD
  });
  var Lo = E((Ine, Od) => {
      var LD = Pd(),
          Cd = $t();

      function wd(e, t, r, n, i) {
          return e === t ? !0 : e == null || t == null || !Cd(e) && !Cd(t) ? e !== e && t !== t : LD(e, t, r, n, wd, i)
      }
      Od.exports = wd
  });
  var Rd = E((Tne, Md) => {
      var kD = bo(),
          ND = Lo(),
          BD = 1,
          VD = 2;

      function GD(e, t, r, n) {
          var i = r.length,
              a = i,
              s = !n;
          if (e == null) return !a;
          for (e = Object(e); i--;) {
              var o = r[i];
              if (s && o[2] ? o[1] !== e[o[0]] : !(o[0] in e)) return !1
          }
          for (; ++i < a;) {
              o = r[i];
              var l = o[0],
                  f = e[l],
                  u = o[1];
              if (s && o[2]) {
                  if (f === void 0 && !(l in e)) return !1
              } else {
                  var c = new kD;
                  if (n) var v = n(f, u, l, e, t, c);
                  if (!(v === void 0 ? ND(u, f, BD | VD, n, c) : v)) return !1
              }
          }
          return !0
      }
      Md.exports = GD
  });
  var ko = E((xne, Dd) => {
      var zD = qt();

      function HD(e) {
          return e === e && !zD(e)
      }
      Dd.exports = HD
  });
  var qd = E((Ane, Fd) => {
      var jD = ko(),
          WD = $n();

      function UD(e) {
          for (var t = WD(e), r = t.length; r--;) {
              var n = t[r],
                  i = e[n];
              t[r] = [n, i, jD(i)]
          }
          return t
      }
      Fd.exports = UD
  });
  var No = E((Pne, Ld) => {
      function XD(e, t) {
          return function(r) {
              return r == null ? !1 : r[e] === t && (t !== void 0 || e in Object(r))
          }
      }
      Ld.exports = XD
  });
  var Nd = E((Cne, kd) => {
      var $D = Rd(),
          KD = qd(),
          YD = No();

      function QD(e) {
          var t = KD(e);
          return t.length == 1 && t[0][2] ? YD(t[0][0], t[0][1]) : function(r) {
              return r === e || $D(r, e, t)
          }
      }
      kd.exports = QD
  });
  var Kn = E((wne, Bd) => {
      var ZD = sr(),
          JD = $t(),
          eF = "[object Symbol]";

      function tF(e) {
          return typeof e == "symbol" || JD(e) && ZD(e) == eF
      }
      Bd.exports = tF
  });
  var aa = E((One, Vd) => {
      var rF = ze(),
          nF = Kn(),
          iF = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
          aF = /^\w*$/;

      function sF(e, t) {
          if (rF(e)) return !1;
          var r = typeof e;
          return r == "number" || r == "symbol" || r == "boolean" || e == null || nF(e) ? !0 : aF.test(e) || !iF.test(e) || t != null && e in Object(t)
      }
      Vd.exports = sF
  });
  var Hd = E((Mne, zd) => {
      var Gd = $i(),
          oF = "Expected a function";

      function Bo(e, t) {
          if (typeof e != "function" || t != null && typeof t != "function") throw new TypeError(oF);
          var r = function() {
              var n = arguments,
                  i = t ? t.apply(this, n) : n[0],
                  a = r.cache;
              if (a.has(i)) return a.get(i);
              var s = e.apply(this, n);
              return r.cache = a.set(i, s) || a, s
          };
          return r.cache = new(Bo.Cache || Gd), r
      }
      Bo.Cache = Gd;
      zd.exports = Bo
  });
  var Wd = E((Rne, jd) => {
      var lF = Hd(),
          uF = 500;

      function hF(e) {
          var t = lF(e, function(n) {
                  return r.size === uF && r.clear(), n
              }),
              r = t.cache;
          return t
      }
      jd.exports = hF
  });
  var Xd = E((Dne, Ud) => {
      var cF = Wd(),
          fF = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,
          pF = /\\(\\)?/g,
          dF = cF(function(e) {
              var t = [];
              return e.charCodeAt(0) === 46 && t.push(""), e.replace(fF, function(r, n, i, a) {
                  t.push(i ? a.replace(pF, "$1") : n || r)
              }), t
          });
      Ud.exports = dF
  });
  var Vo = E((Fne, $d) => {
      function mF(e, t) {
          for (var r = -1, n = e == null ? 0 : e.length, i = Array(n); ++r < n;) i[r] = t(e[r], r, e);
          return i
      }
      $d.exports = mF
  });
  var em = E((qne, Jd) => {
      var Kd = Qr(),
          vF = Vo(),
          gF = ze(),
          yF = Kn(),
          EF = 1 / 0,
          Yd = Kd ? Kd.prototype : void 0,
          Qd = Yd ? Yd.toString : void 0;

      function Zd(e) {
          if (typeof e == "string") return e;
          if (gF(e)) return vF(e, Zd) + "";
          if (yF(e)) return Qd ? Qd.call(e) : "";
          var t = e + "";
          return t == "0" && 1 / e == -EF ? "-0" : t
      }
      Jd.exports = Zd
  });
  var rm = E((Lne, tm) => {
      var bF = em();

      function _F(e) {
          return e == null ? "" : bF(e)
      }
      tm.exports = _F
  });
  var Yn = E((kne, nm) => {
      var SF = ze(),
          IF = aa(),
          TF = Xd(),
          xF = rm();

      function AF(e, t) {
          return SF(e) ? e : IF(e, t) ? [e] : TF(xF(e))
      }
      nm.exports = AF
  });
  var an = E((Nne, im) => {
      var PF = Kn(),
          CF = 1 / 0;

      function wF(e) {
          if (typeof e == "string" || PF(e)) return e;
          var t = e + "";
          return t == "0" && 1 / e == -CF ? "-0" : t
      }
      im.exports = wF
  });
  var sa = E((Bne, am) => {
      var OF = Yn(),
          MF = an();

      function RF(e, t) {
          t = OF(t, e);
          for (var r = 0, n = t.length; e != null && r < n;) e = e[MF(t[r++])];
          return r && r == n ? e : void 0
      }
      am.exports = RF
  });
  var oa = E((Vne, sm) => {
      var DF = sa();

      function FF(e, t, r) {
          var n = e == null ? void 0 : DF(e, t);
          return n === void 0 ? r : n
      }
      sm.exports = FF
  });
  var lm = E((Gne, om) => {
      function qF(e, t) {
          return e != null && t in Object(e)
      }
      om.exports = qF
  });
  var hm = E((zne, um) => {
      var LF = Yn(),
          kF = jn(),
          NF = ze(),
          BF = Zi(),
          VF = Ji(),
          GF = an();

      function zF(e, t, r) {
          t = LF(t, e);
          for (var n = -1, i = t.length, a = !1; ++n < i;) {
              var s = GF(t[n]);
              if (!(a = e != null && r(e, s))) break;
              e = e[s]
          }
          return a || ++n != i ? a : (i = e == null ? 0 : e.length, !!i && VF(i) && BF(s, i) && (NF(e) || kF(e)))
      }
      um.exports = zF
  });
  var fm = E((Hne, cm) => {
      var HF = lm(),
          jF = hm();

      function WF(e, t) {
          return e != null && jF(e, t, HF)
      }
      cm.exports = WF
  });
  var dm = E((jne, pm) => {
      var UF = Lo(),
          XF = oa(),
          $F = fm(),
          KF = aa(),
          YF = ko(),
          QF = No(),
          ZF = an(),
          JF = 1,
          eq = 2;

      function tq(e, t) {
          return KF(e) && YF(t) ? QF(ZF(e), t) : function(r) {
              var n = XF(r, e);
              return n === void 0 && n === t ? $F(r, e) : UF(t, n, JF | eq)
          }
      }
      pm.exports = tq
  });
  var la = E((Wne, mm) => {
      function rq(e) {
          return e
      }
      mm.exports = rq
  });
  var Go = E((Une, vm) => {
      function nq(e) {
          return function(t) {
              return t?.[e]
          }
      }
      vm.exports = nq
  });
  var ym = E((Xne, gm) => {
      var iq = sa();

      function aq(e) {
          return function(t) {
              return iq(t, e)
          }
      }
      gm.exports = aq
  });
  var bm = E(($ne, Em) => {
      var sq = Go(),
          oq = ym(),
          lq = aa(),
          uq = an();

      function hq(e) {
          return lq(e) ? sq(uq(e)) : oq(e)
      }
      Em.exports = hq
  });
  var lr = E((Kne, _m) => {
      var cq = Nd(),
          fq = dm(),
          pq = la(),
          dq = ze(),
          mq = bm();

      function vq(e) {
          return typeof e == "function" ? e : e == null ? pq : typeof e == "object" ? dq(e) ? fq(e[0], e[1]) : cq(e) : mq(e)
      }
      _m.exports = vq
  });
  var Im = E((Yne, Sm) => {
      var gq = /\s/;

      function yq(e) {
          for (var t = e.length; t-- && gq.test(e.charAt(t)););
          return t
      }
      Sm.exports = yq
  });
  var xm = E((Qne, Tm) => {
      var Eq = Im(),
          bq = /^\s+/;

      function _q(e) {
          return e && e.slice(0, Eq(e) + 1)
              .replace(bq, "")
      }
      Tm.exports = _q
  });
  var ua = E((Zne, Cm) => {
      var Sq = xm(),
          Am = qt(),
          Iq = Kn(),
          Pm = 0 / 0,
          Tq = /^[-+]0x[0-9a-f]+$/i,
          xq = /^0b[01]+$/i,
          Aq = /^0o[0-7]+$/i,
          Pq = parseInt;

      function Cq(e) {
          if (typeof e == "number") return e;
          if (Iq(e)) return Pm;
          if (Am(e)) {
              var t = typeof e.valueOf == "function" ? e.valueOf() : e;
              e = Am(t) ? t + "" : t
          }
          if (typeof e != "string") return e === 0 ? e : +e;
          e = Sq(e);
          var r = xq.test(e);
          return r || Aq.test(e) ? Pq(e.slice(2), r ? 2 : 8) : Tq.test(e) ? Pm : +e
      }
      Cm.exports = Cq
  });
  var Mm = E((Jne, Om) => {
      var wq = ua(),
          wm = 1 / 0,
          Oq = 17976931348623157e292;

      function Mq(e) {
          if (!e) return e === 0 ? e : 0;
          if (e = wq(e), e === wm || e === -wm) {
              var t = e < 0 ? -1 : 1;
              return t * Oq
          }
          return e === e ? e : 0
      }
      Om.exports = Mq
  });
  var zo = E((eie, Rm) => {
      var Rq = Mm();

      function Dq(e) {
          var t = Rq(e),
              r = t % 1;
          return t === t ? r ? t - r : t : 0
      }
      Rm.exports = Dq
  });
  var Ho = E((tie, Dm) => {
      var Fq = mo(),
          qq = lr(),
          Lq = zo(),
          kq = Math.max;

      function Nq(e, t, r) {
          var n = e == null ? 0 : e.length;
          if (!n) return -1;
          var i = r == null ? 0 : Lq(r);
          return i < 0 && (i = kq(n + i, 0)), Fq(e, qq(t, 3), i)
      }
      Dm.exports = Nq
  });
  var oe = E((rie, Fm) => {
      var ha = function(e) {
          return e && e.Math == Math && e
      };
      Fm.exports = ha(typeof globalThis == "object" && globalThis) || ha(typeof window == "object" && window) || ha(typeof self == "object" && self) || ha(typeof global == "object" && global) || function() {
          return this
      }() || Function("return this")()
  });
  var Ne = E((nie, qm) => {
      qm.exports = function(e) {
          try {
              return !!e()
          } catch {
              return !0
          }
      }
  });
  var Tt = E((iie, Lm) => {
      var Bq = Ne();
      Lm.exports = !Bq(function() {
          return Object.defineProperty({}, 1, {
              get: function() {
                  return 7
              }
          })[1] != 7
      })
  });
  var ht = E((aie, km) => {
      var Qn = Function.prototype.call;
      km.exports = Qn.bind ? Qn.bind(Qn) : function() {
          return Qn.apply(Qn, arguments)
      }
  });
  var Gm = E(Vm => {
      "use strict";
      var Nm = {}.propertyIsEnumerable,
          Bm = Object.getOwnPropertyDescriptor,
          Vq = Bm && !Nm.call({
              1: 2
          }, 1);
      Vm.f = Vq ? function(t) {
          var r = Bm(this, t);
          return !!r && r.enumerable
      } : Nm
  });
  var Zn = E((oie, zm) => {
      zm.exports = function(e, t) {
          return {
              enumerable: !(e & 1),
              configurable: !(e & 2),
              writable: !(e & 4),
              value: t
          }
      }
  });
  var Te = E((lie, jm) => {
      var Hm = Function.prototype,
          jo = Hm.bind,
          Wo = Hm.call,
          Gq = jo && jo.bind(Wo);
      jm.exports = jo ? function(e) {
          return e && Gq(Wo, e)
      } : function(e) {
          return e && function() {
              return Wo.apply(e, arguments)
          }
      }
  });
  var sn = E((uie, Um) => {
      var Wm = Te(),
          zq = Wm({}.toString),
          Hq = Wm("".slice);
      Um.exports = function(e) {
          return Hq(zq(e), 8, -1)
      }
  });
  var Or = E((hie, Xm) => {
      var jq = oe(),
          Wq = Te(),
          Uq = Ne(),
          Xq = sn(),
          Uo = jq.Object,
          $q = Wq("".split);
      Xm.exports = Uq(function() {
          return !Uo("z")
              .propertyIsEnumerable(0)
      }) ? function(e) {
          return Xq(e) == "String" ? $q(e, "") : Uo(e)
      } : Uo
  });
  var ca = E((cie, $m) => {
      var Kq = oe(),
          Yq = Kq.TypeError;
      $m.exports = function(e) {
          if (e == null) throw Yq("Can't call method on " + e);
          return e
      }
  });
  var Lt = E((fie, Km) => {
      var Qq = Or(),
          Zq = ca();
      Km.exports = function(e) {
          return Qq(Zq(e))
      }
  });
  var we = E((pie, Ym) => {
      Ym.exports = function(e) {
          return typeof e == "function"
      }
  });
  var Ze = E((die, Qm) => {
      var Jq = we();
      Qm.exports = function(e) {
          return typeof e == "object" ? e !== null : Jq(e)
      }
  });
  var ct = E((mie, Zm) => {
      var Xo = oe(),
          eL = we(),
          tL = function(e) {
              return eL(e) ? e : void 0
          };
      Zm.exports = function(e, t) {
          return arguments.length < 2 ? tL(Xo[e]) : Xo[e] && Xo[e][t]
      }
  });
  var fa = E((vie, Jm) => {
      var rL = Te();
      Jm.exports = rL({}.isPrototypeOf)
  });
  var ur = E((gie, ev) => {
      var nL = ct();
      ev.exports = nL("navigator", "userAgent") || ""
  });
  var hr = E((yie, sv) => {
      var av = oe(),
          $o = ur(),
          tv = av.process,
          rv = av.Deno,
          nv = tv && tv.versions || rv && rv.version,
          iv = nv && nv.v8,
          xt, pa;
      iv && (xt = iv.split("."), pa = xt[0] > 0 && xt[0] < 4 ? 1 : +(xt[0] + xt[1]));
      !pa && $o && (xt = $o.match(/Edge\/(\d+)/), (!xt || xt[1] >= 74) && (xt = $o.match(/Chrome\/(\d+)/), xt && (pa = +xt[1])));
      sv.exports = pa
  });
  var Ko = E((Eie, lv) => {
      var ov = hr(),
          iL = Ne();
      lv.exports = !!Object.getOwnPropertySymbols && !iL(function() {
          var e = Symbol();
          return !String(e) || !(Object(e) instanceof Symbol) || !Symbol.sham && ov && ov < 41
      })
  });
  var Yo = E((bie, uv) => {
      var aL = Ko();
      uv.exports = aL && !Symbol.sham && typeof Symbol.iterator == "symbol"
  });
  var Qo = E((_ie, hv) => {
      var sL = oe(),
          oL = ct(),
          lL = we(),
          uL = fa(),
          hL = Yo(),
          cL = sL.Object;
      hv.exports = hL ? function(e) {
          return typeof e == "symbol"
      } : function(e) {
          var t = oL("Symbol");
          return lL(t) && uL(t.prototype, cL(e))
      }
  });
  var Jn = E((Sie, cv) => {
      var fL = oe(),
          pL = fL.String;
      cv.exports = function(e) {
          try {
              return pL(e)
          } catch {
              return "Object"
          }
      }
  });
  var At = E((Iie, fv) => {
      var dL = oe(),
          mL = we(),
          vL = Jn(),
          gL = dL.TypeError;
      fv.exports = function(e) {
          if (mL(e)) return e;
          throw gL(vL(e) + " is not a function")
      }
  });
  var cr = E((Tie, pv) => {
      var yL = At();
      pv.exports = function(e, t) {
          var r = e[t];
          return r == null ? void 0 : yL(r)
      }
  });
  var mv = E((xie, dv) => {
      var EL = oe(),
          Zo = ht(),
          Jo = we(),
          el = Ze(),
          bL = EL.TypeError;
      dv.exports = function(e, t) {
          var r, n;
          if (t === "string" && Jo(r = e.toString) && !el(n = Zo(r, e)) || Jo(r = e.valueOf) && !el(n = Zo(r, e)) || t !== "string" && Jo(r = e.toString) && !el(n = Zo(r, e))) return n;
          throw bL("Can't convert object to primitive value")
      }
  });
  var on = E((Aie, vv) => {
      vv.exports = !1
  });
  var da = E((Pie, yv) => {
      var gv = oe(),
          _L = Object.defineProperty;
      yv.exports = function(e, t) {
          try {
              _L(gv, e, {
                  value: t,
                  configurable: !0,
                  writable: !0
              })
          } catch {
              gv[e] = t
          }
          return t
      }
  });
  var ei = E((Cie, bv) => {
      var SL = oe(),
          IL = da(),
          Ev = "__core-js_shared__",
          TL = SL[Ev] || IL(Ev, {});
      bv.exports = TL
  });
  var tl = E((wie, Sv) => {
      var xL = on(),
          _v = ei();
      (Sv.exports = function(e, t) {
          return _v[e] || (_v[e] = t !== void 0 ? t : {})
      })("versions", [])
      .push({
          version: "3.19.0",
          mode: xL ? "pure" : "global",
          copyright: "\xA9 2021 Denis Pushkarev (zloirock.ru)"
      })
  });
  var Re = E((Oie, Iv) => {
      var AL = oe(),
          PL = ca(),
          CL = AL.Object;
      Iv.exports = function(e) {
          return CL(PL(e))
      }
  });
  var ft = E((Mie, Tv) => {
      var wL = Te(),
          OL = Re(),
          ML = wL({}.hasOwnProperty);
      Tv.exports = Object.hasOwn || function(t, r) {
          return ML(OL(t), r)
      }
  });
  var ma = E((Rie, xv) => {
      var RL = Te(),
          DL = 0,
          FL = Math.random(),
          qL = RL(1 .toString);
      xv.exports = function(e) {
          return "Symbol(" + (e === void 0 ? "" : e) + ")_" + qL(++DL + FL, 36)
      }
  });
  var Oe = E((Die, Ov) => {
      var LL = oe(),
          kL = tl(),
          Av = ft(),
          NL = ma(),
          Pv = Ko(),
          wv = Yo(),
          ln = kL("wks"),
          Mr = LL.Symbol,
          Cv = Mr && Mr.for,
          BL = wv ? Mr : Mr && Mr.withoutSetter || NL;
      Ov.exports = function(e) {
          if (!Av(ln, e) || !(Pv || typeof ln[e] == "string")) {
              var t = "Symbol." + e;
              Pv && Av(Mr, e) ? ln[e] = Mr[e] : wv && Cv ? ln[e] = Cv(t) : ln[e] = BL(t)
          }
          return ln[e]
      }
  });
  var Fv = E((Fie, Dv) => {
      var VL = oe(),
          GL = ht(),
          Mv = Ze(),
          Rv = Qo(),
          zL = cr(),
          HL = mv(),
          jL = Oe(),
          WL = VL.TypeError,
          UL = jL("toPrimitive");
      Dv.exports = function(e, t) {
          if (!Mv(e) || Rv(e)) return e;
          var r = zL(e, UL),
              n;
          if (r) {
              if (t === void 0 && (t = "default"), n = GL(r, e, t), !Mv(n) || Rv(n)) return n;
              throw WL("Can't convert object to primitive value")
          }
          return t === void 0 && (t = "number"), HL(e, t)
      }
  });
  var ti = E((qie, qv) => {
      var XL = Fv(),
          $L = Qo();
      qv.exports = function(e) {
          var t = XL(e, "string");
          return $L(t) ? t : t + ""
      }
  });
  var va = E((Lie, kv) => {
      var KL = oe(),
          Lv = Ze(),
          rl = KL.document,
          YL = Lv(rl) && Lv(rl.createElement);
      kv.exports = function(e) {
          return YL ? rl.createElement(e) : {}
      }
  });
  var nl = E((kie, Nv) => {
      var QL = Tt(),
          ZL = Ne(),
          JL = va();
      Nv.exports = !QL && !ZL(function() {
          return Object.defineProperty(JL("div"), "a", {
                  get: function() {
                      return 7
                  }
              })
              .a != 7
      })
  });
  var ga = E(Vv => {
      var e2 = Tt(),
          t2 = ht(),
          r2 = Gm(),
          n2 = Zn(),
          i2 = Lt(),
          a2 = ti(),
          s2 = ft(),
          o2 = nl(),
          Bv = Object.getOwnPropertyDescriptor;
      Vv.f = e2 ? Bv : function(t, r) {
          if (t = i2(t), r = a2(r), o2) try {
              return Bv(t, r)
          } catch {}
          if (s2(t, r)) return n2(!t2(r2.f, t, r), t[r])
      }
  });
  var $e = E((Bie, zv) => {
      var Gv = oe(),
          l2 = Ze(),
          u2 = Gv.String,
          h2 = Gv.TypeError;
      zv.exports = function(e) {
          if (l2(e)) return e;
          throw h2(u2(e) + " is not an object")
      }
  });
  var pt = E(Wv => {
      var c2 = oe(),
          f2 = Tt(),
          p2 = nl(),
          Hv = $e(),
          d2 = ti(),
          m2 = c2.TypeError,
          jv = Object.defineProperty;
      Wv.f = f2 ? jv : function(t, r, n) {
          if (Hv(t), r = d2(r), Hv(n), p2) try {
              return jv(t, r, n)
          } catch {}
          if ("get" in n || "set" in n) throw m2("Accessors not supported");
          return "value" in n && (t[r] = n.value), t
      }
  });
  var ri = E((Gie, Uv) => {
      var v2 = Tt(),
          g2 = pt(),
          y2 = Zn();
      Uv.exports = v2 ? function(e, t, r) {
          return g2.f(e, t, y2(1, r))
      } : function(e, t, r) {
          return e[t] = r, e
      }
  });
  var ni = E((zie, Xv) => {
      var E2 = Te(),
          b2 = we(),
          il = ei(),
          _2 = E2(Function.toString);
      b2(il.inspectSource) || (il.inspectSource = function(e) {
          return _2(e)
      });
      Xv.exports = il.inspectSource
  });
  var Yv = E((Hie, Kv) => {
      var S2 = oe(),
          I2 = we(),
          T2 = ni(),
          $v = S2.WeakMap;
      Kv.exports = I2($v) && /native code/.test(T2($v))
  });
  var ya = E((jie, Zv) => {
      var x2 = tl(),
          A2 = ma(),
          Qv = x2("keys");
      Zv.exports = function(e) {
          return Qv[e] || (Qv[e] = A2(e))
      }
  });
  var ii = E((Wie, Jv) => {
      Jv.exports = {}
  });
  var Dr = E((Uie, ig) => {
      var P2 = Yv(),
          ng = oe(),
          al = Te(),
          C2 = Ze(),
          w2 = ri(),
          sl = ft(),
          ol = ei(),
          O2 = ya(),
          M2 = ii(),
          eg = "Object already initialized",
          ul = ng.TypeError,
          R2 = ng.WeakMap,
          Ea, ai, ba, D2 = function(e) {
              return ba(e) ? ai(e) : Ea(e, {})
          },
          F2 = function(e) {
              return function(t) {
                  var r;
                  if (!C2(t) || (r = ai(t))
                      .type !== e) throw ul("Incompatible receiver, " + e + " required");
                  return r
              }
          };
      P2 || ol.state ? (fr = ol.state || (ol.state = new R2), tg = al(fr.get), ll = al(fr.has), rg = al(fr.set), Ea = function(e, t) {
          if (ll(fr, e)) throw new ul(eg);
          return t.facade = e, rg(fr, e, t), t
      }, ai = function(e) {
          return tg(fr, e) || {}
      }, ba = function(e) {
          return ll(fr, e)
      }) : (Rr = O2("state"), M2[Rr] = !0, Ea = function(e, t) {
          if (sl(e, Rr)) throw new ul(eg);
          return t.facade = e, w2(e, Rr, t), t
      }, ai = function(e) {
          return sl(e, Rr) ? e[Rr] : {}
      }, ba = function(e) {
          return sl(e, Rr)
      });
      var fr, tg, ll, rg, Rr;
      ig.exports = {
          set: Ea,
          get: ai,
          has: ba,
          enforce: D2,
          getterFor: F2
      }
  });
  var fl = E((Xie, sg) => {
      var hl = Tt(),
          q2 = ft(),
          ag = Function.prototype,
          L2 = hl && Object.getOwnPropertyDescriptor,
          cl = q2(ag, "name"),
          k2 = cl && function() {}.name === "something",
          N2 = cl && (!hl || hl && L2(ag, "name")
              .configurable);
      sg.exports = {
          EXISTS: cl,
          PROPER: k2,
          CONFIGURABLE: N2
      }
  });
  var Kt = E(($ie, hg) => {
      var B2 = oe(),
          og = we(),
          V2 = ft(),
          lg = ri(),
          G2 = da(),
          z2 = ni(),
          ug = Dr(),
          H2 = fl()
          .CONFIGURABLE,
          j2 = ug.get,
          W2 = ug.enforce,
          U2 = String(String)
          .split("String");
      (hg.exports = function(e, t, r, n) {
          var i = n ? !!n.unsafe : !1,
              a = n ? !!n.enumerable : !1,
              s = n ? !!n.noTargetGet : !1,
              o = n && n.name !== void 0 ? n.name : t,
              l;
          if (og(r) && (String(o)
                  .slice(0, 7) === "Symbol(" && (o = "[" + String(o)
                      .replace(/^Symbol\(([^)]*)\)/, "$1") + "]"), (!V2(r, "name") || H2 && r.name !== o) && lg(r, "name", o), l = W2(r), l.source || (l.source = U2.join(typeof o == "string" ? o : ""))), e === B2) {
              a ? e[t] = r : G2(t, r);
              return
          } else i ? !s && e[t] && (a = !0) : delete e[t];
          a ? e[t] = r : lg(e, t, r)
      })(Function.prototype, "toString", function() {
          return og(this) && j2(this)
              .source || z2(this)
      })
  });
  var pr = E((Kie, cg) => {
      var X2 = Math.ceil,
          $2 = Math.floor;
      cg.exports = function(e) {
          var t = +e;
          return t !== t || t === 0 ? 0 : (t > 0 ? $2 : X2)(t)
      }
  });
  var un = E((Yie, fg) => {
      var K2 = pr(),
          Y2 = Math.max,
          Q2 = Math.min;
      fg.exports = function(e, t) {
          var r = K2(e);
          return r < 0 ? Y2(r + t, 0) : Q2(r, t)
      }
  });
  var dg = E((Qie, pg) => {
      var Z2 = pr(),
          J2 = Math.min;
      pg.exports = function(e) {
          return e > 0 ? J2(Z2(e), 9007199254740991) : 0
      }
  });
  var Ae = E((Zie, mg) => {
      var ek = dg();
      mg.exports = function(e) {
          return ek(e.length)
      }
  });
  var _a = E((Jie, gg) => {
      var tk = Lt(),
          rk = un(),
          nk = Ae(),
          vg = function(e) {
              return function(t, r, n) {
                  var i = tk(t),
                      a = nk(i),
                      s = rk(n, a),
                      o;
                  if (e && r != r) {
                      for (; a > s;)
                          if (o = i[s++], o != o) return !0
                  } else
                      for (; a > s; s++)
                          if ((e || s in i) && i[s] === r) return e || s || 0;
                  return !e && -1
              }
          };
      gg.exports = {
          includes: vg(!0),
          indexOf: vg(!1)
      }
  });
  var dl = E((eae, Eg) => {
      var ik = Te(),
          pl = ft(),
          ak = Lt(),
          sk = _a()
          .indexOf,
          ok = ii(),
          yg = ik([].push);
      Eg.exports = function(e, t) {
          var r = ak(e),
              n = 0,
              i = [],
              a;
          for (a in r) !pl(ok, a) && pl(r, a) && yg(i, a);
          for (; t.length > n;) pl(r, a = t[n++]) && (~sk(i, a) || yg(i, a));
          return i
      }
  });
  var Sa = E((tae, bg) => {
      bg.exports = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"]
  });
  var Ia = E(_g => {
      var lk = dl(),
          uk = Sa(),
          hk = uk.concat("length", "prototype");
      _g.f = Object.getOwnPropertyNames || function(t) {
          return lk(t, hk)
      }
  });
  var Ig = E(Sg => {
      Sg.f = Object.getOwnPropertySymbols
  });
  var xg = E((iae, Tg) => {
      var ck = ct(),
          fk = Te(),
          pk = Ia(),
          dk = Ig(),
          mk = $e(),
          vk = fk([].concat);
      Tg.exports = ck("Reflect", "ownKeys") || function(t) {
          var r = pk.f(mk(t)),
              n = dk.f;
          return n ? vk(r, n(t)) : r
      }
  });
  var Pg = E((aae, Ag) => {
      var gk = ft(),
          yk = xg(),
          Ek = ga(),
          bk = pt();
      Ag.exports = function(e, t) {
          for (var r = yk(t), n = bk.f, i = Ek.f, a = 0; a < r.length; a++) {
              var s = r[a];
              gk(e, s) || n(e, s, i(t, s))
          }
      }
  });
  var Ta = E((sae, Cg) => {
      var _k = Ne(),
          Sk = we(),
          Ik = /#|\.prototype\./,
          si = function(e, t) {
              var r = xk[Tk(e)];
              return r == Pk ? !0 : r == Ak ? !1 : Sk(t) ? _k(t) : !!t
          },
          Tk = si.normalize = function(e) {
              return String(e)
                  .replace(Ik, ".")
                  .toLowerCase()
          },
          xk = si.data = {},
          Ak = si.NATIVE = "N",
          Pk = si.POLYFILL = "P";
      Cg.exports = si
  });
  var de = E((oae, wg) => {
      var ml = oe(),
          Ck = ga()
          .f,
          wk = ri(),
          Ok = Kt(),
          Mk = da(),
          Rk = Pg(),
          Dk = Ta();
      wg.exports = function(e, t) {
          var r = e.target,
              n = e.global,
              i = e.stat,
              a, s, o, l, f, u;
          if (n ? s = ml : i ? s = ml[r] || Mk(r, {}) : s = (ml[r] || {})
              .prototype, s)
              for (o in t) {
                  if (f = t[o], e.noTargetGet ? (u = Ck(s, o), l = u && u.value) : l = s[o], a = Dk(n ? o : r + (i ? "." : "#") + o, e.forced), !a && l !== void 0) {
                      if (typeof f == typeof l) continue;
                      Rk(f, l)
                  }(e.sham || l && l.sham) && wk(f, "sham", !0), Ok(s, o, f, e)
              }
      }
  });
  var Pt = E((lae, Rg) => {
      var Og = Te(),
          Fk = At(),
          Mg = Og(Og.bind);
      Rg.exports = function(e, t) {
          return Fk(e), t === void 0 ? e : Mg ? Mg(e, t) : function() {
              return e.apply(t, arguments)
          }
      }
  });
  var vl = E((uae, Fg) => {
      var qk = ht(),
          Dg = $e(),
          Lk = cr();
      Fg.exports = function(e, t, r) {
          var n, i;
          Dg(e);
          try {
              if (n = Lk(e, "return"), !n) {
                  if (t === "throw") throw r;
                  return r
              }
              n = qk(n, e)
          } catch (a) {
              i = !0, n = a
          }
          if (t === "throw") throw r;
          if (i) throw n;
          return Dg(n), r
      }
  });
  var Lg = E((hae, qg) => {
      var kk = $e(),
          Nk = vl();
      qg.exports = function(e, t, r, n) {
          try {
              return n ? t(kk(r)[0], r[1]) : t(r)
          } catch (i) {
              Nk(e, "throw", i)
          }
      }
  });
  var hn = E((cae, kg) => {
      kg.exports = {}
  });
  var gl = E((fae, Ng) => {
      var Bk = Oe(),
          Vk = hn(),
          Gk = Bk("iterator"),
          zk = Array.prototype;
      Ng.exports = function(e) {
          return e !== void 0 && (Vk.Array === e || zk[Gk] === e)
      }
  });
  var xa = E((pae, Vg) => {
      var Hk = Oe(),
          jk = Hk("toStringTag"),
          Bg = {};
      Bg[jk] = "z";
      Vg.exports = String(Bg) === "[object z]"
  });
  var oi = E((dae, Gg) => {
      var Wk = oe(),
          Uk = xa(),
          Xk = we(),
          Aa = sn(),
          $k = Oe(),
          Kk = $k("toStringTag"),
          Yk = Wk.Object,
          Qk = Aa(function() {
              return arguments
          }()) == "Arguments",
          Zk = function(e, t) {
              try {
                  return e[t]
              } catch {}
          };
      Gg.exports = Uk ? Aa : function(e) {
          var t, r, n;
          return e === void 0 ? "Undefined" : e === null ? "Null" : typeof(r = Zk(t = Yk(e), Kk)) == "string" ? r : Qk ? Aa(t) : (n = Aa(t)) == "Object" && Xk(t.callee) ? "Arguments" : n
      }
  });
  var Fr = E((mae, Wg) => {
      var Jk = Te(),
          eN = Ne(),
          zg = we(),
          tN = oi(),
          rN = ct(),
          nN = ni(),
          Hg = function() {},
          iN = [],
          jg = rN("Reflect", "construct"),
          yl = /^\s*(?:class|function)\b/,
          aN = Jk(yl.exec),
          sN = !yl.exec(Hg),
          li = function(e) {
              if (!zg(e)) return !1;
              try {
                  return jg(Hg, iN, e), !0
              } catch {
                  return !1
              }
          },
          oN = function(e) {
              if (!zg(e)) return !1;
              switch (tN(e)) {
                  case "AsyncFunction":
                  case "GeneratorFunction":
                  case "AsyncGeneratorFunction":
                      return !1
              }
              return sN || !!aN(yl, nN(e))
          };
      Wg.exports = !jg || eN(function() {
          var e;
          return li(li.call) || !li(Object) || !li(function() {
              e = !0
          }) || e
      }) ? oN : li
  });
  var cn = E((vae, Ug) => {
      "use strict";
      var lN = ti(),
          uN = pt(),
          hN = Zn();
      Ug.exports = function(e, t, r) {
          var n = lN(t);
          n in e ? uN.f(e, n, hN(0, r)) : e[n] = r
      }
  });
  var ui = E((gae, $g) => {
      var cN = oi(),
          Xg = cr(),
          fN = hn(),
          pN = Oe(),
          dN = pN("iterator");
      $g.exports = function(e) {
          if (e != null) return Xg(e, dN) || Xg(e, "@@iterator") || fN[cN(e)]
      }
  });
  var hi = E((yae, Kg) => {
      var mN = oe(),
          vN = ht(),
          gN = At(),
          yN = $e(),
          EN = Jn(),
          bN = ui(),
          _N = mN.TypeError;
      Kg.exports = function(e, t) {
          var r = arguments.length < 2 ? bN(e) : t;
          if (gN(r)) return yN(vN(r, e));
          throw _N(EN(e) + " is not iterable")
      }
  });
  var Jg = E((Eae, Zg) => {
      "use strict";
      var SN = oe(),
          IN = Pt(),
          TN = ht(),
          xN = Re(),
          AN = Lg(),
          PN = gl(),
          CN = Fr(),
          wN = Ae(),
          Yg = cn(),
          ON = hi(),
          MN = ui(),
          Qg = SN.Array;
      Zg.exports = function(t) {
          var r = xN(t),
              n = CN(this),
              i = arguments.length,
              a = i > 1 ? arguments[1] : void 0,
              s = a !== void 0;
          s && (a = IN(a, i > 2 ? arguments[2] : void 0));
          var o = MN(r),
              l = 0,
              f, u, c, v, d, p;
          if (o && !(this == Qg && PN(o)))
              for (v = ON(r, o), d = v.next, u = n ? new this : []; !(c = TN(d, v))
                  .done; l++) p = s ? AN(v, a, [c.value, l], !0) : c.value, Yg(u, l, p);
          else
              for (f = wN(r), u = n ? new this(f) : Qg(f); f > l; l++) p = s ? a(r[l], l) : r[l], Yg(u, l, p);
          return u.length = l, u
      }
  });
  var Pa = E((bae, ny) => {
      var RN = Oe(),
          ty = RN("iterator"),
          ry = !1;
      try {
          ey = 0, El = {
              next: function() {
                  return {
                      done: !!ey++
                  }
              },
              return: function() {
                  ry = !0
              }
          }, El[ty] = function() {
              return this
          }, Array.from(El, function() {
              throw 2
          })
      } catch {}
      var ey, El;
      ny.exports = function(e, t) {
          if (!t && !ry) return !1;
          var r = !1;
          try {
              var n = {};
              n[ty] = function() {
                  return {
                      next: function() {
                          return {
                              done: r = !0
                          }
                      }
                  }
              }, e(n)
          } catch {}
          return r
      }
  });
  var iy = E(() => {
      var DN = de(),
          FN = Jg(),
          qN = Pa(),
          LN = !qN(function(e) {
              Array.from(e)
          });
      DN({
          target: "Array",
          stat: !0,
          forced: LN
      }, {
          from: FN
      })
  });
  var dr = E((Iae, ay) => {
      var kN = sn();
      ay.exports = Array.isArray || function(t) {
          return kN(t) == "Array"
      }
  });
  var sy = E(() => {
      var NN = de(),
          BN = dr();
      NN({
          target: "Array",
          stat: !0
      }, {
          isArray: BN
      })
  });
  var ly = E(() => {
      "use strict";
      var VN = de(),
          GN = oe(),
          zN = Ne(),
          HN = Fr(),
          jN = cn(),
          oy = GN.Array,
          WN = zN(function() {
              function e() {}
              return !(oy.of.call(e) instanceof e)
          });
      VN({
          target: "Array",
          stat: !0,
          forced: WN
      }, {
          of: function() {
              for (var t = 0, r = arguments.length, n = new(HN(this) ? this : oy)(r); r > t;) jN(n, t, arguments[t++]);
              return n.length = r, n
          }
      })
  });
  var hy = E((Cae, uy) => {
      var UN = dl(),
          XN = Sa();
      uy.exports = Object.keys || function(t) {
          return UN(t, XN)
      }
  });
  var fy = E((wae, cy) => {
      var $N = Tt(),
          KN = pt(),
          YN = $e(),
          QN = Lt(),
          ZN = hy();
      cy.exports = $N ? Object.defineProperties : function(t, r) {
          YN(t);
          for (var n = QN(r), i = ZN(r), a = i.length, s = 0, o; a > s;) KN.f(t, o = i[s++], n[o]);
          return t
      }
  });
  var bl = E((Oae, py) => {
      var JN = ct();
      py.exports = JN("document", "documentElement")
  });
  var mr = E((Mae, by) => {
      var eB = $e(),
          tB = fy(),
          dy = Sa(),
          rB = ii(),
          nB = bl(),
          iB = va(),
          aB = ya(),
          my = ">",
          vy = "<",
          Sl = "prototype",
          Il = "script",
          yy = aB("IE_PROTO"),
          _l = function() {},
          Ey = function(e) {
              return vy + Il + my + e + vy + "/" + Il + my
          },
          gy = function(e) {
              e.write(Ey("")), e.close();
              var t = e.parentWindow.Object;
              return e = null, t
          },
          sB = function() {
              var e = iB("iframe"),
                  t = "java" + Il + ":",
                  r;
              return e.style.display = "none", nB.appendChild(e), e.src = String(t), r = e.contentWindow.document, r.open(), r.write(Ey("document.F=Object")), r.close(), r.F
          },
          Ca, wa = function() {
              try {
                  Ca = new ActiveXObject("htmlfile")
              } catch {}
              wa = typeof document < "u" ? document.domain && Ca ? gy(Ca) : sB() : gy(Ca);
              for (var e = dy.length; e--;) delete wa[Sl][dy[e]];
              return wa()
          };
      rB[yy] = !0;
      by.exports = Object.create || function(t, r) {
          var n;
          return t !== null ? (_l[Sl] = eB(t), n = new _l, _l[Sl] = null, n[yy] = t) : n = wa(), r === void 0 ? n : tB(n, r)
      }
  });
  var qe = E((Rae, _y) => {
      var oB = Oe(),
          lB = mr(),
          uB = pt(),
          Tl = oB("unscopables"),
          xl = Array.prototype;
      xl[Tl] == null && uB.f(xl, Tl, {
          configurable: !0,
          value: lB(null)
      });
      _y.exports = function(e) {
          xl[Tl][e] = !0
      }
  });
  var Al = E(() => {
      "use strict";
      var hB = de(),
          cB = Re(),
          fB = Ae(),
          pB = pr(),
          dB = qe();
      hB({
          target: "Array",
          proto: !0
      }, {
          at: function(t) {
              var r = cB(this),
                  n = fB(r),
                  i = pB(t),
                  a = i >= 0 ? i : n + i;
              return a < 0 || a >= n ? void 0 : r[a]
          }
      });
      dB("at")
  });
  var Pl = E((qae, Ty) => {
      var mB = oe(),
          Sy = dr(),
          vB = Fr(),
          gB = Ze(),
          yB = Oe(),
          EB = yB("species"),
          Iy = mB.Array;
      Ty.exports = function(e) {
          var t;
          return Sy(e) && (t = e.constructor, vB(t) && (t === Iy || Sy(t.prototype)) ? t = void 0 : gB(t) && (t = t[EB], t === null && (t = void 0))), t === void 0 ? Iy : t
      }
  });
  var qr = E((Lae, xy) => {
      var bB = Pl();
      xy.exports = function(e, t) {
          return new(bB(e))(t === 0 ? 0 : t)
      }
  });
  var fn = E((kae, Ay) => {
      var _B = Ne(),
          SB = Oe(),
          IB = hr(),
          TB = SB("species");
      Ay.exports = function(e) {
          return IB >= 51 || !_B(function() {
              var t = [],
                  r = t.constructor = {};
              return r[TB] = function() {
                      return {
                          foo: 1
                      }
                  }, t[e](Boolean)
                  .foo !== 1
          })
      }
  });
  var Ry = E(() => {
      "use strict";
      var xB = de(),
          AB = oe(),
          PB = Ne(),
          CB = dr(),
          wB = Ze(),
          OB = Re(),
          MB = Ae(),
          Py = cn(),
          RB = qr(),
          DB = fn(),
          FB = Oe(),
          qB = hr(),
          My = FB("isConcatSpreadable"),
          Cy = 9007199254740991,
          wy = "Maximum allowed index exceeded",
          Oy = AB.TypeError,
          LB = qB >= 51 || !PB(function() {
              var e = [];
              return e[My] = !1, e.concat()[0] !== e
          }),
          kB = DB("concat"),
          NB = function(e) {
              if (!wB(e)) return !1;
              var t = e[My];
              return t !== void 0 ? !!t : CB(e)
          },
          BB = !LB || !kB;
      xB({
          target: "Array",
          proto: !0,
          forced: BB
      }, {
          concat: function(t) {
              var r = OB(this),
                  n = RB(r, 0),
                  i = 0,
                  a, s, o, l, f;
              for (a = -1, o = arguments.length; a < o; a++)
                  if (f = a === -1 ? r : arguments[a], NB(f)) {
                      if (l = MB(f), i + l > Cy) throw Oy(wy);
                      for (s = 0; s < l; s++, i++) s in f && Py(n, i, f[s])
                  } else {
                      if (i >= Cy) throw Oy(wy);
                      Py(n, i++, f)
                  } return n.length = i, n
          }
      })
  });
  var Fy = E((Vae, Dy) => {
      "use strict";
      var VB = Re(),
          Cl = un(),
          GB = Ae(),
          zB = Math.min;
      Dy.exports = [].copyWithin || function(t, r) {
          var n = VB(this),
              i = GB(n),
              a = Cl(t, i),
              s = Cl(r, i),
              o = arguments.length > 2 ? arguments[2] : void 0,
              l = zB((o === void 0 ? i : Cl(o, i)) - s, i - a),
              f = 1;
          for (s < a && a < s + l && (f = -1, s += l - 1, a += l - 1); l-- > 0;) s in n ? n[a] = n[s] : delete n[a], a += f, s += f;
          return n
      }
  });
  var qy = E(() => {
      var HB = de(),
          jB = Fy(),
          WB = qe();
      HB({
          target: "Array",
          proto: !0
      }, {
          copyWithin: jB
      });
      WB("copyWithin")
  });
  var kt = E((Hae, ky) => {
      var UB = Pt(),
          XB = Te(),
          $B = Or(),
          KB = Re(),
          YB = Ae(),
          QB = qr(),
          Ly = XB([].push),
          vr = function(e) {
              var t = e == 1,
                  r = e == 2,
                  n = e == 3,
                  i = e == 4,
                  a = e == 6,
                  s = e == 7,
                  o = e == 5 || a;
              return function(l, f, u, c) {
                  for (var v = KB(l), d = $B(v), p = UB(f, u), m = YB(d), h = 0, g = c || QB, y = t ? g(l, m) : r || s ? g(l, 0) : void 0, b, _; m > h; h++)
                      if ((o || h in d) && (b = d[h], _ = p(b, h, v), e))
                          if (t) y[h] = _;
                          else if (_) switch (e) {
                      case 3:
                          return !0;
                      case 5:
                          return b;
                      case 6:
                          return h;
                      case 2:
                          Ly(y, b)
                  } else switch (e) {
                      case 4:
                          return !1;
                      case 7:
                          Ly(y, b)
                  }
                  return a ? -1 : n || i ? i : y
              }
          };
      ky.exports = {
          forEach: vr(0),
          map: vr(1),
          filter: vr(2),
          some: vr(3),
          every: vr(4),
          find: vr(5),
          findIndex: vr(6),
          filterReject: vr(7)
      }
  });
  var Nt = E((jae, Ny) => {
      "use strict";
      var ZB = Ne();
      Ny.exports = function(e, t) {
          var r = [][e];
          return !!r && ZB(function() {
              r.call(null, t || function() {
                  throw 1
              }, 1)
          })
      }
  });
  var By = E(() => {
      "use strict";
      var JB = de(),
          eV = kt()
          .every,
          tV = Nt(),
          rV = tV("every");
      JB({
          target: "Array",
          proto: !0,
          forced: !rV
      }, {
          every: function(t) {
              return eV(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      })
  });
  var zy = E((Xae, Gy) => {
      "use strict";
      var nV = Re(),
          Vy = un(),
          iV = Ae();
      Gy.exports = function(t) {
          for (var r = nV(this), n = iV(r), i = arguments.length, a = Vy(i > 1 ? arguments[1] : void 0, n), s = i > 2 ? arguments[2] : void 0, o = s === void 0 ? n : Vy(s, n); o > a;) r[a++] = t;
          return r
      }
  });
  var Hy = E(() => {
      var aV = de(),
          sV = zy(),
          oV = qe();
      aV({
          target: "Array",
          proto: !0
      }, {
          fill: sV
      });
      oV("fill")
  });
  var jy = E(() => {
      "use strict";
      var lV = de(),
          uV = kt()
          .filter,
          hV = fn(),
          cV = hV("filter");
      lV({
          target: "Array",
          proto: !0,
          forced: !cV
      }, {
          filter: function(t) {
              return uV(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      })
  });
  var Uy = E(() => {
      "use strict";
      var fV = de(),
          pV = kt()
          .find,
          dV = qe(),
          wl = "find",
          Wy = !0;
      wl in [] && Array(1)[wl](function() {
          Wy = !1
      });
      fV({
          target: "Array",
          proto: !0,
          forced: Wy
      }, {
          find: function(t) {
              return pV(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      dV(wl)
  });
  var $y = E(() => {
      "use strict";
      var mV = de(),
          vV = kt()
          .findIndex,
          gV = qe(),
          Ol = "findIndex",
          Xy = !0;
      Ol in [] && Array(1)[Ol](function() {
          Xy = !1
      });
      mV({
          target: "Array",
          proto: !0,
          forced: Xy
      }, {
          findIndex: function(t) {
              return vV(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      gV(Ol)
  });
  var Ml = E((rse, Yy) => {
      "use strict";
      var yV = oe(),
          EV = dr(),
          bV = Ae(),
          _V = Pt(),
          SV = yV.TypeError,
          Ky = function(e, t, r, n, i, a, s, o) {
              for (var l = i, f = 0, u = s ? _V(s, o) : !1, c, v; f < n;) {
                  if (f in r) {
                      if (c = u ? u(r[f], f, t) : r[f], a > 0 && EV(c)) v = bV(c), l = Ky(e, t, c, v, l, a - 1) - 1;
                      else {
                          if (l >= 9007199254740991) throw SV("Exceed the acceptable array length");
                          e[l] = c
                      }
                      l++
                  }
                  f++
              }
              return l
          };
      Yy.exports = Ky
  });
  var Qy = E(() => {
      "use strict";
      var IV = de(),
          TV = Ml(),
          xV = Re(),
          AV = Ae(),
          PV = pr(),
          CV = qr();
      IV({
          target: "Array",
          proto: !0
      }, {
          flat: function() {
              var t = arguments.length ? arguments[0] : void 0,
                  r = xV(this),
                  n = AV(r),
                  i = CV(r, 0);
              return i.length = TV(i, r, r, n, 0, t === void 0 ? 1 : PV(t)), i
          }
      })
  });
  var Zy = E(() => {
      "use strict";
      var wV = de(),
          OV = Ml(),
          MV = At(),
          RV = Re(),
          DV = Ae(),
          FV = qr();
      wV({
          target: "Array",
          proto: !0
      }, {
          flatMap: function(t) {
              var r = RV(this),
                  n = DV(r),
                  i;
              return MV(t), i = FV(r, 0), i.length = OV(i, r, r, n, 0, 1, t, arguments.length > 1 ? arguments[1] : void 0), i
          }
      })
  });
  var e0 = E((ose, Jy) => {
      "use strict";
      var qV = kt()
          .forEach,
          LV = Nt(),
          kV = LV("forEach");
      Jy.exports = kV ? [].forEach : function(t) {
          return qV(this, t, arguments.length > 1 ? arguments[1] : void 0)
      }
  });
  var r0 = E(() => {
      "use strict";
      var NV = de(),
          t0 = e0();
      NV({
          target: "Array",
          proto: !0,
          forced: [].forEach != t0
      }, {
          forEach: t0
      })
  });
  var Rl = E(() => {
      "use strict";
      var BV = de(),
          VV = _a()
          .includes,
          GV = qe();
      BV({
          target: "Array",
          proto: !0
      }, {
          includes: function(t) {
              return VV(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      GV("includes")
  });
  var i0 = E(() => {
      "use strict";
      var zV = de(),
          HV = Te(),
          jV = _a()
          .indexOf,
          WV = Nt(),
          Dl = HV([].indexOf),
          n0 = !!Dl && 1 / Dl([1], 1, -0) < 0,
          UV = WV("indexOf");
      zV({
          target: "Array",
          proto: !0,
          forced: n0 || !UV
      }, {
          indexOf: function(t) {
              var r = arguments.length > 1 ? arguments[1] : void 0;
              return n0 ? Dl(this, t, r) || 0 : jV(this, t, r)
          }
      })
  });
  var s0 = E((dse, a0) => {
      var XV = Ne();
      a0.exports = !XV(function() {
          function e() {}
          return e.prototype.constructor = null, Object.getPrototypeOf(new e) !== e.prototype
      })
  });
  var Oa = E((mse, l0) => {
      var $V = oe(),
          KV = ft(),
          YV = we(),
          QV = Re(),
          ZV = ya(),
          JV = s0(),
          o0 = ZV("IE_PROTO"),
          Fl = $V.Object,
          eG = Fl.prototype;
      l0.exports = JV ? Fl.getPrototypeOf : function(e) {
          var t = QV(e);
          if (KV(t, o0)) return t[o0];
          var r = t.constructor;
          return YV(r) && t instanceof r ? r.prototype : t instanceof Fl ? eG : null
      }
  });
  var Nl = E((vse, c0) => {
      "use strict";
      var tG = Ne(),
          rG = we(),
          nG = mr(),
          u0 = Oa(),
          iG = Kt(),
          aG = Oe(),
          sG = on(),
          kl = aG("iterator"),
          h0 = !1,
          Yt, ql, Ll;
      [].keys && (Ll = [].keys(), "next" in Ll ? (ql = u0(u0(Ll)), ql !== Object.prototype && (Yt = ql)) : h0 = !0);
      var oG = Yt == null || tG(function() {
          var e = {};
          return Yt[kl].call(e) !== e
      });
      oG ? Yt = {} : sG && (Yt = nG(Yt));
      rG(Yt[kl]) || iG(Yt, kl, function() {
          return this
      });
      c0.exports = {
          IteratorPrototype: Yt,
          BUGGY_SAFARI_ITERATORS: h0
      }
  });
  var ci = E((gse, p0) => {
      var lG = pt()
          .f,
          uG = ft(),
          hG = Oe(),
          f0 = hG("toStringTag");
      p0.exports = function(e, t, r) {
          e && !uG(e = r ? e : e.prototype, f0) && lG(e, f0, {
              configurable: !0,
              value: t
          })
      }
  });
  var m0 = E((yse, d0) => {
      "use strict";
      var cG = Nl()
          .IteratorPrototype,
          fG = mr(),
          pG = Zn(),
          dG = ci(),
          mG = hn(),
          vG = function() {
              return this
          };
      d0.exports = function(e, t, r) {
          var n = t + " Iterator";
          return e.prototype = fG(cG, {
              next: pG(1, r)
          }), dG(e, n, !1, !0), mG[n] = vG, e
      }
  });
  var y0 = E((Ese, g0) => {
      var v0 = oe(),
          gG = we(),
          yG = v0.String,
          EG = v0.TypeError;
      g0.exports = function(e) {
          if (typeof e == "object" || gG(e)) return e;
          throw EG("Can't set " + yG(e) + " as a prototype")
      }
  });
  var Ma = E((bse, E0) => {
      var bG = Te(),
          _G = $e(),
          SG = y0();
      E0.exports = Object.setPrototypeOf || ("__proto__" in {} ? function() {
          var e = !1,
              t = {},
              r;
          try {
              r = bG(Object.getOwnPropertyDescriptor(Object.prototype, "__proto__")
                  .set), r(t, []), e = t instanceof Array
          } catch {}
          return function(i, a) {
              return _G(i), SG(a), e ? r(i, a) : i.__proto__ = a, i
          }
      }() : void 0)
  });
  var Fa = E((_se, w0) => {
      "use strict";
      var IG = de(),
          TG = ht(),
          Ra = on(),
          P0 = fl(),
          xG = we(),
          AG = m0(),
          b0 = Oa(),
          _0 = Ma(),
          PG = ci(),
          CG = ri(),
          Bl = Kt(),
          wG = Oe(),
          S0 = hn(),
          C0 = Nl(),
          OG = P0.PROPER,
          MG = P0.CONFIGURABLE,
          I0 = C0.IteratorPrototype,
          Da = C0.BUGGY_SAFARI_ITERATORS,
          fi = wG("iterator"),
          T0 = "keys",
          pi = "values",
          x0 = "entries",
          A0 = function() {
              return this
          };
      w0.exports = function(e, t, r, n, i, a, s) {
          AG(r, t, n);
          var o = function(g) {
                  if (g === i && v) return v;
                  if (!Da && g in u) return u[g];
                  switch (g) {
                      case T0:
                          return function() {
                              return new r(this, g)
                          };
                      case pi:
                          return function() {
                              return new r(this, g)
                          };
                      case x0:
                          return function() {
                              return new r(this, g)
                          }
                  }
                  return function() {
                      return new r(this)
                  }
              },
              l = t + " Iterator",
              f = !1,
              u = e.prototype,
              c = u[fi] || u["@@iterator"] || i && u[i],
              v = !Da && c || o(i),
              d = t == "Array" && u.entries || c,
              p, m, h;
          if (d && (p = b0(d.call(new e)), p !== Object.prototype && p.next && (!Ra && b0(p) !== I0 && (_0 ? _0(p, I0) : xG(p[fi]) || Bl(p, fi, A0)), PG(p, l, !0, !0), Ra && (S0[l] = A0))), OG && i == pi && c && c.name !== pi && (!Ra && MG ? CG(u, "name", pi) : (f = !0, v = function() {
                  return TG(c, this)
              })), i)
              if (m = {
                      values: o(pi),
                      keys: a ? v : o(T0),
                      entries: o(x0)
                  }, s)
                  for (h in m)(Da || f || !(h in u)) && Bl(u, h, m[h]);
              else IG({
                  target: t,
                  proto: !0,
                  forced: Da || f
              }, m);
          return (!Ra || s) && u[fi] !== v && Bl(u, fi, v, {
              name: i
          }), S0[t] = v, m
      }
  });
  var F0 = E((Sse, D0) => {
      "use strict";
      var RG = Lt(),
          Vl = qe(),
          O0 = hn(),
          M0 = Dr(),
          DG = Fa(),
          R0 = "Array Iterator",
          FG = M0.set,
          qG = M0.getterFor(R0);
      D0.exports = DG(Array, "Array", function(e, t) {
          FG(this, {
              type: R0,
              target: RG(e),
              index: 0,
              kind: t
          })
      }, function() {
          var e = qG(this),
              t = e.target,
              r = e.kind,
              n = e.index++;
          return !t || n >= t.length ? (e.target = void 0, {
              value: void 0,
              done: !0
          }) : r == "keys" ? {
              value: n,
              done: !1
          } : r == "values" ? {
              value: t[n],
              done: !1
          } : {
              value: [n, t[n]],
              done: !1
          }
      }, "values");
      O0.Arguments = O0.Array;
      Vl("keys");
      Vl("values");
      Vl("entries")
  });
  var q0 = E(() => {
      "use strict";
      var LG = de(),
          kG = Te(),
          NG = Or(),
          BG = Lt(),
          VG = Nt(),
          GG = kG([].join),
          zG = NG != Object,
          HG = VG("join", ",");
      LG({
          target: "Array",
          proto: !0,
          forced: zG || !HG
      }, {
          join: function(t) {
              return GG(BG(this), t === void 0 ? "," : t)
          }
      })
  });
  var qa = E((xse, N0) => {
      var Gl = Function.prototype,
          L0 = Gl.apply,
          jG = Gl.bind,
          k0 = Gl.call;
      N0.exports = typeof Reflect == "object" && Reflect.apply || (jG ? k0.bind(L0) : function() {
          return k0.apply(L0, arguments)
      })
  });
  var G0 = E((Ase, V0) => {
      "use strict";
      var WG = qa(),
          UG = Lt(),
          XG = pr(),
          $G = Ae(),
          KG = Nt(),
          YG = Math.min,
          zl = [].lastIndexOf,
          B0 = !!zl && 1 / [1].lastIndexOf(1, -0) < 0,
          QG = KG("lastIndexOf"),
          ZG = B0 || !QG;
      V0.exports = ZG ? function(t) {
          if (B0) return WG(zl, this, arguments) || 0;
          var r = UG(this),
              n = $G(r),
              i = n - 1;
          for (arguments.length > 1 && (i = YG(i, XG(arguments[1]))), i < 0 && (i = n + i); i >= 0; i--)
              if (i in r && r[i] === t) return i || 0;
          return -1
      } : zl
  });
  var H0 = E(() => {
      var JG = de(),
          z0 = G0();
      JG({
          target: "Array",
          proto: !0,
          forced: z0 !== [].lastIndexOf
      }, {
          lastIndexOf: z0
      })
  });
  var j0 = E(() => {
      "use strict";
      var e3 = de(),
          t3 = kt()
          .map,
          r3 = fn(),
          n3 = r3("map");
      e3({
          target: "Array",
          proto: !0,
          forced: !n3
      }, {
          map: function(t) {
              return t3(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      })
  });
  var Hl = E((Mse, U0) => {
      var i3 = oe(),
          a3 = At(),
          s3 = Re(),
          o3 = Or(),
          l3 = Ae(),
          u3 = i3.TypeError,
          W0 = function(e) {
              return function(t, r, n, i) {
                  a3(r);
                  var a = s3(t),
                      s = o3(a),
                      o = l3(a),
                      l = e ? o - 1 : 0,
                      f = e ? -1 : 1;
                  if (n < 2)
                      for (;;) {
                          if (l in s) {
                              i = s[l], l += f;
                              break
                          }
                          if (l += f, e ? l < 0 : o <= l) throw u3("Reduce of empty array with no initial value")
                      }
                  for (; e ? l >= 0 : o > l; l += f) l in s && (i = r(i, s[l], l, a));
                  return i
              }
          };
      U0.exports = {
          left: W0(!1),
          right: W0(!0)
      }
  });
  var pn = E((Rse, X0) => {
      var h3 = sn(),
          c3 = oe();
      X0.exports = h3(c3.process) == "process"
  });
  var K0 = E(() => {
      "use strict";
      var f3 = de(),
          p3 = Hl()
          .left,
          d3 = Nt(),
          $0 = hr(),
          m3 = pn(),
          v3 = d3("reduce"),
          g3 = !m3 && $0 > 79 && $0 < 83;
      f3({
          target: "Array",
          proto: !0,
          forced: !v3 || g3
      }, {
          reduce: function(t) {
              var r = arguments.length;
              return p3(this, t, r, r > 1 ? arguments[1] : void 0)
          }
      })
  });
  var Q0 = E(() => {
      "use strict";
      var y3 = de(),
          E3 = Hl()
          .right,
          b3 = Nt(),
          Y0 = hr(),
          _3 = pn(),
          S3 = b3("reduceRight"),
          I3 = !_3 && Y0 > 79 && Y0 < 83;
      y3({
          target: "Array",
          proto: !0,
          forced: !S3 || I3
      }, {
          reduceRight: function(t) {
              return E3(this, t, arguments.length, arguments.length > 1 ? arguments[1] : void 0)
          }
      })
  });
  var J0 = E(() => {
      "use strict";
      var T3 = de(),
          x3 = Te(),
          A3 = dr(),
          P3 = x3([].reverse),
          Z0 = [1, 2];
      T3({
          target: "Array",
          proto: !0,
          forced: String(Z0) === String(Z0.reverse())
      }, {
          reverse: function() {
              return A3(this) && (this.length = this.length), P3(this)
          }
      })
  });
  var di = E((Bse, eE) => {
      var C3 = Te();
      eE.exports = C3([].slice)
  });
  var nE = E(() => {
      "use strict";
      var w3 = de(),
          O3 = oe(),
          tE = dr(),
          M3 = Fr(),
          R3 = Ze(),
          rE = un(),
          D3 = Ae(),
          F3 = Lt(),
          q3 = cn(),
          L3 = Oe(),
          k3 = fn(),
          N3 = di(),
          B3 = k3("slice"),
          V3 = L3("species"),
          jl = O3.Array,
          G3 = Math.max;
      w3({
          target: "Array",
          proto: !0,
          forced: !B3
      }, {
          slice: function(t, r) {
              var n = F3(this),
                  i = D3(n),
                  a = rE(t, i),
                  s = rE(r === void 0 ? i : r, i),
                  o, l, f;
              if (tE(n) && (o = n.constructor, M3(o) && (o === jl || tE(o.prototype)) ? o = void 0 : R3(o) && (o = o[V3], o === null && (o = void 0)), o === jl || o === void 0)) return N3(n, a, s);
              for (l = new(o === void 0 ? jl : o)(G3(s - a, 0)), f = 0; a < s; a++, f++) a in n && q3(l, f, n[a]);
              return l.length = f, l
          }
      })
  });
  var iE = E(() => {
      "use strict";
      var z3 = de(),
          H3 = kt()
          .some,
          j3 = Nt(),
          W3 = j3("some");
      z3({
          target: "Array",
          proto: !0,
          forced: !W3
      }, {
          some: function(t) {
              return H3(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      })
  });
  var La = E((jse, aE) => {
      var U3 = oe(),
          X3 = oi(),
          $3 = U3.String;
      aE.exports = function(e) {
          if (X3(e) === "Symbol") throw TypeError("Cannot convert a Symbol value to a string");
          return $3(e)
      }
  });
  var lE = E((Wse, oE) => {
      var sE = di(),
          K3 = Math.floor,
          Wl = function(e, t) {
              var r = e.length,
                  n = K3(r / 2);
              return r < 8 ? Y3(e, t) : Q3(e, Wl(sE(e, 0, n), t), Wl(sE(e, n), t), t)
          },
          Y3 = function(e, t) {
              for (var r = e.length, n = 1, i, a; n < r;) {
                  for (a = n, i = e[n]; a && t(e[a - 1], i) > 0;) e[a] = e[--a];
                  a !== n++ && (e[a] = i)
              }
              return e
          },
          Q3 = function(e, t, r, n) {
              for (var i = t.length, a = r.length, s = 0, o = 0; s < i || o < a;) e[s + o] = s < i && o < a ? n(t[s], r[o]) <= 0 ? t[s++] : r[o++] : s < i ? t[s++] : r[o++];
              return e
          };
      oE.exports = Wl
  });
  var cE = E((Use, hE) => {
      var Z3 = ur(),
          uE = Z3.match(/firefox\/(\d+)/i);
      hE.exports = !!uE && +uE[1]
  });
  var pE = E((Xse, fE) => {
      var J3 = ur();
      fE.exports = /MSIE|Trident/.test(J3)
  });
  var vE = E(($se, mE) => {
      var e5 = ur(),
          dE = e5.match(/AppleWebKit\/(\d+)\./);
      mE.exports = !!dE && +dE[1]
  });
  var TE = E(() => {
      "use strict";
      var t5 = de(),
          SE = Te(),
          r5 = At(),
          n5 = Re(),
          i5 = Ae(),
          gE = La(),
          Ul = Ne(),
          a5 = lE(),
          s5 = Nt(),
          yE = cE(),
          o5 = pE(),
          EE = hr(),
          bE = vE(),
          gr = [],
          _E = SE(gr.sort),
          l5 = SE(gr.push),
          u5 = Ul(function() {
              gr.sort(void 0)
          }),
          h5 = Ul(function() {
              gr.sort(null)
          }),
          c5 = s5("sort"),
          IE = !Ul(function() {
              if (EE) return EE < 70;
              if (!(yE && yE > 3)) {
                  if (o5) return !0;
                  if (bE) return bE < 603;
                  var e = "",
                      t, r, n, i;
                  for (t = 65; t < 76; t++) {
                      switch (r = String.fromCharCode(t), t) {
                          case 66:
                          case 69:
                          case 70:
                          case 72:
                              n = 3;
                              break;
                          case 68:
                          case 71:
                              n = 4;
                              break;
                          default:
                              n = 2
                      }
                      for (i = 0; i < 47; i++) gr.push({
                          k: r + i,
                          v: n
                      })
                  }
                  for (gr.sort(function(a, s) {
                          return s.v - a.v
                      }), i = 0; i < gr.length; i++) r = gr[i].k.charAt(0), e.charAt(e.length - 1) !== r && (e += r);
                  return e !== "DGBEFHACIJK"
              }
          }),
          f5 = u5 || !h5 || !c5 || !IE,
          p5 = function(e) {
              return function(t, r) {
                  return r === void 0 ? -1 : t === void 0 ? 1 : e !== void 0 ? +e(t, r) || 0 : gE(t) > gE(r) ? 1 : -1
              }
          };
      t5({
          target: "Array",
          proto: !0,
          forced: f5
      }, {
          sort: function(t) {
              t !== void 0 && r5(t);
              var r = n5(this);
              if (IE) return t === void 0 ? _E(r) : _E(r, t);
              var n = [],
                  i = i5(r),
                  a, s;
              for (s = 0; s < i; s++) s in r && l5(n, r[s]);
              for (a5(n, p5(t)), a = n.length, s = 0; s < a;) r[s] = n[s++];
              for (; s < i;) delete r[s++];
              return r
          }
      })
  });
  var ka = E((Qse, AE) => {
      "use strict";
      var d5 = ct(),
          m5 = pt(),
          v5 = Oe(),
          g5 = Tt(),
          xE = v5("species");
      AE.exports = function(e) {
          var t = d5(e),
              r = m5.f;
          g5 && t && !t[xE] && r(t, xE, {
              configurable: !0,
              get: function() {
                  return this
              }
          })
      }
  });
  var PE = E(() => {
      var y5 = ka();
      y5("Array")
  });
  var CE = E(() => {
      "use strict";
      var E5 = de(),
          b5 = oe(),
          _5 = un(),
          S5 = pr(),
          I5 = Ae(),
          T5 = Re(),
          x5 = qr(),
          A5 = cn(),
          P5 = fn(),
          C5 = P5("splice"),
          w5 = b5.TypeError,
          O5 = Math.max,
          M5 = Math.min,
          R5 = 9007199254740991,
          D5 = "Maximum allowed length exceeded";
      E5({
          target: "Array",
          proto: !0,
          forced: !C5
      }, {
          splice: function(t, r) {
              var n = T5(this),
                  i = I5(n),
                  a = _5(t, i),
                  s = arguments.length,
                  o, l, f, u, c, v;
              if (s === 0 ? o = l = 0 : s === 1 ? (o = 0, l = i - a) : (o = s - 2, l = M5(O5(S5(r), 0), i - a)), i + o - l > R5) throw w5(D5);
              for (f = x5(n, l), u = 0; u < l; u++) c = a + u, c in n && A5(f, u, n[c]);
              if (f.length = l, o < l) {
                  for (u = a; u < i - l; u++) c = u + l, v = u + o, c in n ? n[v] = n[c] : delete n[v];
                  for (u = i; u > i - l + o; u--) delete n[u - 1]
              } else if (o > l)
                  for (u = i - l; u > a; u--) c = u + l - 1, v = u + o - 1, c in n ? n[v] = n[c] : delete n[v];
              for (u = 0; u < o; u++) n[u + a] = arguments[u + 2];
              return n.length = i - l + o, f
          }
      })
  });
  var wE = E(() => {
      var F5 = qe();
      F5("flat")
  });
  var OE = E(() => {
      var q5 = qe();
      q5("flatMap")
  });
  var RE = E((soe, ME) => {
      "use strict";
      var L5 = xa(),
          k5 = oi();
      ME.exports = L5 ? {}.toString : function() {
          return "[object " + k5(this) + "]"
      }
  });
  var DE = E(() => {
      var N5 = xa(),
          B5 = Kt(),
          V5 = RE();
      N5 || B5(Object.prototype, "toString", V5, {
          unsafe: !0
      })
  });
  var kE = E((uoe, LE) => {
      var Xl = Te(),
          G5 = pr(),
          z5 = La(),
          H5 = ca(),
          j5 = Xl("".charAt),
          FE = Xl("".charCodeAt),
          W5 = Xl("".slice),
          qE = function(e) {
              return function(t, r) {
                  var n = z5(H5(t)),
                      i = G5(r),
                      a = n.length,
                      s, o;
                  return i < 0 || i >= a ? e ? "" : void 0 : (s = FE(n, i), s < 55296 || s > 56319 || i + 1 === a || (o = FE(n, i + 1)) < 56320 || o > 57343 ? e ? j5(n, i) : s : e ? W5(n, i, i + 2) : (s - 55296 << 10) + (o - 56320) + 65536)
              }
          };
      LE.exports = {
          codeAt: qE(!1),
          charAt: qE(!0)
      }
  });
  var VE = E(() => {
      "use strict";
      var U5 = kE()
          .charAt,
          X5 = La(),
          NE = Dr(),
          $5 = Fa(),
          BE = "String Iterator",
          K5 = NE.set,
          Y5 = NE.getterFor(BE);
      $5(String, "String", function(e) {
          K5(this, {
              type: BE,
              string: X5(e),
              index: 0
          })
      }, function() {
          var t = Y5(this),
              r = t.string,
              n = t.index,
              i;
          return n >= r.length ? {
              value: void 0,
              done: !0
          } : (i = U5(r, n), t.index += i.length, {
              value: i,
              done: !1
          })
      })
  });
  var zE = E((foe, GE) => {
      var Q5 = oe();
      GE.exports = Q5
  });
  var jE = E((poe, HE) => {
      iy();
      sy();
      ly();
      Al();
      Ry();
      qy();
      By();
      Hy();
      jy();
      Uy();
      $y();
      Qy();
      Zy();
      r0();
      Rl();
      i0();
      F0();
      q0();
      H0();
      j0();
      K0();
      Q0();
      J0();
      nE();
      iE();
      TE();
      PE();
      CE();
      wE();
      OE();
      DE();
      VE();
      var Z5 = zE();
      HE.exports = Z5.Array
  });
  var UE = E((doe, WE) => {
      var J5 = jE();
      WE.exports = J5
  });
  var YE = E((moe, KE) => {
      var ez = sn(),
          tz = Lt(),
          XE = Ia()
          .f,
          rz = di(),
          $E = typeof window == "object" && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [],
          nz = function(e) {
              try {
                  return XE(e)
              } catch {
                  return rz($E)
              }
          };
      KE.exports.f = function(t) {
          return $E && ez(t) == "Window" ? nz(t) : XE(tz(t))
      }
  });
  var ZE = E((voe, QE) => {
      var iz = Ne();
      QE.exports = !iz(function() {
          return Object.isExtensible(Object.preventExtensions({}))
      })
  });
  var Ql = E((goe, t1) => {
      var az = de(),
          sz = Te(),
          oz = ii(),
          lz = Ze(),
          $l = ft(),
          uz = pt()
          .f,
          JE = Ia(),
          hz = YE(),
          cz = ma(),
          fz = ZE(),
          e1 = !1,
          Qt = cz("meta"),
          pz = 0,
          Kl = Object.isExtensible || function() {
              return !0
          },
          Yl = function(e) {
              uz(e, Qt, {
                  value: {
                      objectID: "O" + pz++,
                      weakData: {}
                  }
              })
          },
          dz = function(e, t) {
              if (!lz(e)) return typeof e == "symbol" ? e : (typeof e == "string" ? "S" : "P") + e;
              if (!$l(e, Qt)) {
                  if (!Kl(e)) return "F";
                  if (!t) return "E";
                  Yl(e)
              }
              return e[Qt].objectID
          },
          mz = function(e, t) {
              if (!$l(e, Qt)) {
                  if (!Kl(e)) return !0;
                  if (!t) return !1;
                  Yl(e)
              }
              return e[Qt].weakData
          },
          vz = function(e) {
              return fz && e1 && Kl(e) && !$l(e, Qt) && Yl(e), e
          },
          gz = function() {
              yz.enable = function() {}, e1 = !0;
              var e = JE.f,
                  t = sz([].splice),
                  r = {};
              r[Qt] = 1, e(r)
                  .length && (JE.f = function(n) {
                      for (var i = e(n), a = 0, s = i.length; a < s; a++)
                          if (i[a] === Qt) {
                              t(i, a, 1);
                              break
                          } return i
                  }, az({
                      target: "Object",
                      stat: !0,
                      forced: !0
                  }, {
                      getOwnPropertyNames: hz.f
                  }))
          },
          yz = t1.exports = {
              enable: gz,
              fastKey: dz,
              getWeakData: mz,
              onFreeze: vz
          };
      oz[Qt] = !0
  });
  var Ba = E((yoe, a1) => {
      var Ez = oe(),
          bz = Pt(),
          _z = ht(),
          Sz = $e(),
          Iz = Jn(),
          Tz = gl(),
          xz = Ae(),
          r1 = fa(),
          Az = hi(),
          Pz = ui(),
          n1 = vl(),
          Cz = Ez.TypeError,
          Na = function(e, t) {
              this.stopped = e, this.result = t
          },
          i1 = Na.prototype;
      a1.exports = function(e, t, r) {
          var n = r && r.that,
              i = !!(r && r.AS_ENTRIES),
              a = !!(r && r.IS_ITERATOR),
              s = !!(r && r.INTERRUPTED),
              o = bz(t, n),
              l, f, u, c, v, d, p, m = function(g) {
                  return l && n1(l, "normal", g), new Na(!0, g)
              },
              h = function(g) {
                  return i ? (Sz(g), s ? o(g[0], g[1], m) : o(g[0], g[1])) : s ? o(g, m) : o(g)
              };
          if (a) l = e;
          else {
              if (f = Pz(e), !f) throw Cz(Iz(e) + " is not iterable");
              if (Tz(f)) {
                  for (u = 0, c = xz(e); c > u; u++)
                      if (v = h(e[u]), v && r1(i1, v)) return v;
                  return new Na(!1)
              }
              l = Az(e, f)
          }
          for (d = l.next; !(p = _z(d, l))
              .done;) {
              try {
                  v = h(p.value)
              } catch (g) {
                  n1(l, "throw", g)
              }
              if (typeof v == "object" && v && r1(i1, v)) return v
          }
          return new Na(!1)
      }
  });
  var Va = E((Eoe, s1) => {
      var wz = oe(),
          Oz = fa(),
          Mz = wz.TypeError;
      s1.exports = function(e, t) {
          if (Oz(t, e)) return e;
          throw Mz("Incorrect invocation")
      }
  });
  var u1 = E((boe, l1) => {
      var Rz = we(),
          Dz = Ze(),
          o1 = Ma();
      l1.exports = function(e, t, r) {
          var n, i;
          return o1 && Rz(n = t.constructor) && n !== r && Dz(i = n.prototype) && i !== r.prototype && o1(e, i), e
      }
  });
  var f1 = E((_oe, c1) => {
      "use strict";
      var Fz = de(),
          qz = oe(),
          Lz = Te(),
          h1 = Ta(),
          kz = Kt(),
          Nz = Ql(),
          Bz = Ba(),
          Vz = Va(),
          Gz = we(),
          Zl = Ze(),
          Jl = Ne(),
          zz = Pa(),
          Hz = ci(),
          jz = u1();
      c1.exports = function(e, t, r) {
          var n = e.indexOf("Map") !== -1,
              i = e.indexOf("Weak") !== -1,
              a = n ? "set" : "add",
              s = qz[e],
              o = s && s.prototype,
              l = s,
              f = {},
              u = function(g) {
                  var y = Lz(o[g]);
                  kz(o, g, g == "add" ? function(_) {
                      return y(this, _ === 0 ? 0 : _), this
                  } : g == "delete" ? function(b) {
                      return i && !Zl(b) ? !1 : y(this, b === 0 ? 0 : b)
                  } : g == "get" ? function(_) {
                      return i && !Zl(_) ? void 0 : y(this, _ === 0 ? 0 : _)
                  } : g == "has" ? function(_) {
                      return i && !Zl(_) ? !1 : y(this, _ === 0 ? 0 : _)
                  } : function(_, I) {
                      return y(this, _ === 0 ? 0 : _, I), this
                  })
              },
              c = h1(e, !Gz(s) || !(i || o.forEach && !Jl(function() {
                  new s()
                      .entries()
                      .next()
              })));
          if (c) l = r.getConstructor(t, e, n, a), Nz.enable();
          else if (h1(e, !0)) {
              var v = new l,
                  d = v[a](i ? {} : -0, 1) != v,
                  p = Jl(function() {
                      v.has(1)
                  }),
                  m = zz(function(g) {
                      new s(g)
                  }),
                  h = !i && Jl(function() {
                      for (var g = new s, y = 5; y--;) g[a](y, y);
                      return !g.has(-0)
                  });
              m || (l = t(function(g, y) {
                  Vz(g, o);
                  var b = jz(new s, g, l);
                  return y != null && Bz(y, b[a], {
                      that: b,
                      AS_ENTRIES: n
                  }), b
              }), l.prototype = o, o.constructor = l), (p || h) && (u("delete"), u("has"), n && u("get")), (h || d) && u(a), i && o.clear && delete o.clear
          }
          return f[e] = l, Fz({
              global: !0,
              forced: l != s
          }, f), Hz(l, e), i || r.setStrong(l, e, n), l
      }
  });
  var Ga = E((Soe, p1) => {
      var Wz = Kt();
      p1.exports = function(e, t, r) {
          for (var n in t) Wz(e, n, t[n], r);
          return e
      }
  });
  var E1 = E((Ioe, y1) => {
      "use strict";
      var Uz = pt()
          .f,
          Xz = mr(),
          d1 = Ga(),
          $z = Pt(),
          Kz = Va(),
          Yz = Ba(),
          Qz = Fa(),
          Zz = ka(),
          mi = Tt(),
          m1 = Ql()
          .fastKey,
          g1 = Dr(),
          v1 = g1.set,
          eu = g1.getterFor;
      y1.exports = {
          getConstructor: function(e, t, r, n) {
              var i = e(function(f, u) {
                      Kz(f, a), v1(f, {
                          type: t,
                          index: Xz(null),
                          first: void 0,
                          last: void 0,
                          size: 0
                      }), mi || (f.size = 0), u != null && Yz(u, f[n], {
                          that: f,
                          AS_ENTRIES: r
                      })
                  }),
                  a = i.prototype,
                  s = eu(t),
                  o = function(f, u, c) {
                      var v = s(f),
                          d = l(f, u),
                          p, m;
                      return d ? d.value = c : (v.last = d = {
                          index: m = m1(u, !0),
                          key: u,
                          value: c,
                          previous: p = v.last,
                          next: void 0,
                          removed: !1
                      }, v.first || (v.first = d), p && (p.next = d), mi ? v.size++ : f.size++, m !== "F" && (v.index[m] = d)), f
                  },
                  l = function(f, u) {
                      var c = s(f),
                          v = m1(u),
                          d;
                      if (v !== "F") return c.index[v];
                      for (d = c.first; d; d = d.next)
                          if (d.key == u) return d
                  };
              return d1(a, {
                  clear: function() {
                      for (var u = this, c = s(u), v = c.index, d = c.first; d;) d.removed = !0, d.previous && (d.previous = d.previous.next = void 0), delete v[d.index], d = d.next;
                      c.first = c.last = void 0, mi ? c.size = 0 : u.size = 0
                  },
                  delete: function(f) {
                      var u = this,
                          c = s(u),
                          v = l(u, f);
                      if (v) {
                          var d = v.next,
                              p = v.previous;
                          delete c.index[v.index], v.removed = !0, p && (p.next = d), d && (d.previous = p), c.first == v && (c.first = d), c.last == v && (c.last = p), mi ? c.size-- : u.size--
                      }
                      return !!v
                  },
                  forEach: function(u) {
                      for (var c = s(this), v = $z(u, arguments.length > 1 ? arguments[1] : void 0), d; d = d ? d.next : c.first;)
                          for (v(d.value, d.key, this); d && d.removed;) d = d.previous
                  },
                  has: function(u) {
                      return !!l(this, u)
                  }
              }), d1(a, r ? {
                  get: function(u) {
                      var c = l(this, u);
                      return c && c.value
                  },
                  set: function(u, c) {
                      return o(this, u === 0 ? 0 : u, c)
                  }
              } : {
                  add: function(u) {
                      return o(this, u = u === 0 ? 0 : u, u)
                  }
              }), mi && Uz(a, "size", {
                  get: function() {
                      return s(this)
                          .size
                  }
              }), i
          },
          setStrong: function(e, t, r) {
              var n = t + " Iterator",
                  i = eu(t),
                  a = eu(n);
              Qz(e, t, function(s, o) {
                  v1(this, {
                      type: n,
                      target: s,
                      state: i(s),
                      kind: o,
                      last: void 0
                  })
              }, function() {
                  for (var s = a(this), o = s.kind, l = s.last; l && l.removed;) l = l.previous;
                  return !s.target || !(s.last = l = l ? l.next : s.state.first) ? (s.target = void 0, {
                      value: void 0,
                      done: !0
                  }) : o == "keys" ? {
                      value: l.key,
                      done: !1
                  } : o == "values" ? {
                      value: l.value,
                      done: !1
                  } : {
                      value: [l.key, l.value],
                      done: !1
                  }
              }, r ? "entries" : "values", !r, !0), Zz(t)
          }
      }
  });
  var b1 = E(() => {
      "use strict";
      var Jz = f1(),
          eH = E1();
      Jz("Map", function(e) {
          return function() {
              return e(this, arguments.length ? arguments[0] : void 0)
          }
      }, eH)
  });
  var S1 = E((Aoe, _1) => {
      var tH = oe();
      _1.exports = tH.Promise
  });
  var T1 = E((Poe, I1) => {
      var rH = oe(),
          nH = Fr(),
          iH = Jn(),
          aH = rH.TypeError;
      I1.exports = function(e) {
          if (nH(e)) return e;
          throw aH(iH(e) + " is not a constructor")
      }
  });
  var P1 = E((Coe, A1) => {
      var x1 = $e(),
          sH = T1(),
          oH = Oe(),
          lH = oH("species");
      A1.exports = function(e, t) {
          var r = x1(e)
              .constructor,
              n;
          return r === void 0 || (n = x1(r)[lH]) == null ? t : sH(n)
      }
  });
  var tu = E((woe, C1) => {
      var uH = ur();
      C1.exports = /(?:ipad|iphone|ipod).*applewebkit/i.test(uH)
  });
  var hu = E((Ooe, L1) => {
      var at = oe(),
          hH = qa(),
          cH = Pt(),
          w1 = we(),
          fH = ft(),
          pH = Ne(),
          O1 = bl(),
          dH = di(),
          M1 = va(),
          mH = tu(),
          vH = pn(),
          ou = at.setImmediate,
          lu = at.clearImmediate,
          gH = at.process,
          ru = at.Dispatch,
          yH = at.Function,
          R1 = at.MessageChannel,
          EH = at.String,
          nu = 0,
          vi = {},
          D1 = "onreadystatechange",
          gi, Lr, iu, au;
      try {
          gi = at.location
      } catch {}
      var uu = function(e) {
              if (fH(vi, e)) {
                  var t = vi[e];
                  delete vi[e], t()
              }
          },
          su = function(e) {
              return function() {
                  uu(e)
              }
          },
          F1 = function(e) {
              uu(e.data)
          },
          q1 = function(e) {
              at.postMessage(EH(e), gi.protocol + "//" + gi.host)
          };
      (!ou || !lu) && (ou = function(t) {
          var r = dH(arguments, 1);
          return vi[++nu] = function() {
              hH(w1(t) ? t : yH(t), void 0, r)
          }, Lr(nu), nu
      }, lu = function(t) {
          delete vi[t]
      }, vH ? Lr = function(e) {
          gH.nextTick(su(e))
      } : ru && ru.now ? Lr = function(e) {
          ru.now(su(e))
      } : R1 && !mH ? (iu = new R1, au = iu.port2, iu.port1.onmessage = F1, Lr = cH(au.postMessage, au)) : at.addEventListener && w1(at.postMessage) && !at.importScripts && gi && gi.protocol !== "file:" && !pH(q1) ? (Lr = q1, at.addEventListener("message", F1, !1)) : D1 in M1("script") ? Lr = function(e) {
          O1.appendChild(M1("script"))[D1] = function() {
              O1.removeChild(this), uu(e)
          }
      } : Lr = function(e) {
          setTimeout(su(e), 0)
      });
      L1.exports = {
          set: ou,
          clear: lu
      }
  });
  var N1 = E((Moe, k1) => {
      var bH = ur(),
          _H = oe();
      k1.exports = /ipad|iphone|ipod/i.test(bH) && _H.Pebble !== void 0
  });
  var V1 = E((Roe, B1) => {
      var SH = ur();
      B1.exports = /web0s(?!.*chrome)/i.test(SH)
  });
  var K1 = E((Doe, $1) => {
      var Nr = oe(),
          G1 = Pt(),
          IH = ga()
          .f,
          cu = hu()
          .set,
          TH = tu(),
          xH = N1(),
          AH = V1(),
          fu = pn(),
          z1 = Nr.MutationObserver || Nr.WebKitMutationObserver,
          H1 = Nr.document,
          j1 = Nr.process,
          za = Nr.Promise,
          W1 = IH(Nr, "queueMicrotask"),
          X1 = W1 && W1.value,
          yi, kr, Ei, dn, pu, du, Ha, U1;
      X1 || (yi = function() {
          var e, t;
          for (fu && (e = j1.domain) && e.exit(); kr;) {
              t = kr.fn, kr = kr.next;
              try {
                  t()
              } catch (r) {
                  throw kr ? dn() : Ei = void 0, r
              }
          }
          Ei = void 0, e && e.enter()
      }, !TH && !fu && !AH && z1 && H1 ? (pu = !0, du = H1.createTextNode(""), new z1(yi)
          .observe(du, {
              characterData: !0
          }), dn = function() {
              du.data = pu = !pu
          }) : !xH && za && za.resolve ? (Ha = za.resolve(void 0), Ha.constructor = za, U1 = G1(Ha.then, Ha), dn = function() {
          U1(yi)
      }) : fu ? dn = function() {
          j1.nextTick(yi)
      } : (cu = G1(cu, Nr), dn = function() {
          cu(yi)
      }));
      $1.exports = X1 || function(e) {
          var t = {
              fn: e,
              next: void 0
          };
          Ei && (Ei.next = t), kr || (kr = t, dn()), Ei = t
      }
  });
  var mu = E((Foe, Q1) => {
      "use strict";
      var Y1 = At(),
          PH = function(e) {
              var t, r;
              this.promise = new e(function(n, i) {
                  if (t !== void 0 || r !== void 0) throw TypeError("Bad Promise constructor");
                  t = n, r = i
              }), this.resolve = Y1(t), this.reject = Y1(r)
          };
      Q1.exports.f = function(e) {
          return new PH(e)
      }
  });
  var J1 = E((qoe, Z1) => {
      var CH = $e(),
          wH = Ze(),
          OH = mu();
      Z1.exports = function(e, t) {
          if (CH(e), wH(t) && t.constructor === e) return t;
          var r = OH.f(e),
              n = r.resolve;
          return n(t), r.promise
      }
  });
  var tb = E((Loe, eb) => {
      var MH = oe();
      eb.exports = function(e, t) {
          var r = MH.console;
          r && r.error && (arguments.length == 1 ? r.error(e) : r.error(e, t))
      }
  });
  var nb = E((koe, rb) => {
      rb.exports = function(e) {
          try {
              return {
                  error: !1,
                  value: e()
              }
          } catch (t) {
              return {
                  error: !0,
                  value: t
              }
          }
      }
  });
  var ab = E((Noe, ib) => {
      ib.exports = typeof window == "object"
  });
  var Ab = E(() => {
      "use strict";
      var $a = de(),
          Wa = on(),
          Zt = oe(),
          RH = ct(),
          Jt = ht(),
          Ua = S1(),
          sb = Kt(),
          DH = Ga(),
          lb = Ma(),
          FH = ci(),
          qH = ka(),
          vu = At(),
          bi = we(),
          LH = Ze(),
          kH = Va(),
          NH = ni(),
          ub = Ba(),
          BH = Pa(),
          VH = P1(),
          vb = hu()
          .set,
          gb = K1(),
          GH = J1(),
          zH = tb(),
          yb = mu(),
          gu = nb(),
          _u = Dr(),
          HH = Ta(),
          jH = Oe(),
          WH = ab(),
          Xa = pn(),
          hb = hr(),
          UH = jH("species"),
          er = "Promise",
          cb = _u.get,
          XH = _u.set,
          $H = _u.getterFor(er),
          Br = Ua && Ua.prototype,
          dt = Ua,
          mn = Br,
          Eb = Zt.TypeError,
          yu = Zt.document,
          Su = Zt.process,
          yn = yb.f,
          KH = yn,
          YH = !!(yu && yu.createEvent && Zt.dispatchEvent),
          bb = bi(Zt.PromiseRejectionEvent),
          _b = "unhandledrejection",
          QH = "rejectionhandled",
          fb = 0,
          Sb = 1,
          ZH = 2,
          Iu = 1,
          Ib = 2,
          Eu = !1,
          ja, pb, Tu, db, _i = HH(er, function() {
              var e = NH(dt),
                  t = e !== String(dt);
              if (!t && hb === 66 || Wa && !mn.finally) return !0;
              if (hb >= 51 && /native code/.test(e)) return !1;
              var r = new dt(function(a) {
                      a(1)
                  }),
                  n = function(a) {
                      a(function() {}, function() {})
                  },
                  i = r.constructor = {};
              return i[UH] = n, Eu = r.then(function() {}) instanceof n, Eu ? !t && WH && !bb : !0
          }),
          JH = _i || !BH(function(e) {
              dt.all(e)
                  .catch(function() {})
          }),
          Tb = function(e) {
              var t;
              return LH(e) && bi(t = e.then) ? t : !1
          },
          xu = function(e, t) {
              if (!e.notified) {
                  e.notified = !0;
                  var r = e.reactions;
                  gb(function() {
                      for (var n = e.value, i = e.state == Sb, a = 0; r.length > a;) {
                          var s = r[a++],
                              o = i ? s.ok : s.fail,
                              l = s.resolve,
                              f = s.reject,
                              u = s.domain,
                              c, v, d;
                          try {
                              o ? (i || (e.rejection === Ib && tj(e), e.rejection = Iu), o === !0 ? c = n : (u && u.enter(), c = o(n), u && (u.exit(), d = !0)), c === s.promise ? f(Eb("Promise-chain cycle")) : (v = Tb(c)) ? Jt(v, c, l, f) : l(c)) : f(n)
                          } catch (p) {
                              u && !d && u.exit(), f(p)
                          }
                      }
                      e.reactions = [], e.notified = !1, t && !e.rejection && ej(e)
                  })
              }
          },
          xb = function(e, t, r) {
              var n, i;
              YH ? (n = yu.createEvent("Event"), n.promise = t, n.reason = r, n.initEvent(e, !1, !0), Zt.dispatchEvent(n)) : n = {
                  promise: t,
                  reason: r
              }, !bb && (i = Zt["on" + e]) ? i(n) : e === _b && zH("Unhandled promise rejection", r)
          },
          ej = function(e) {
              Jt(vb, Zt, function() {
                  var t = e.facade,
                      r = e.value,
                      n = mb(e),
                      i;
                  if (n && (i = gu(function() {
                          Xa ? Su.emit("unhandledRejection", r, t) : xb(_b, t, r)
                      }), e.rejection = Xa || mb(e) ? Ib : Iu, i.error)) throw i.value
              })
          },
          mb = function(e) {
              return e.rejection !== Iu && !e.parent
          },
          tj = function(e) {
              Jt(vb, Zt, function() {
                  var t = e.facade;
                  Xa ? Su.emit("rejectionHandled", t) : xb(QH, t, e.value)
              })
          },
          vn = function(e, t, r) {
              return function(n) {
                  e(t, n, r)
              }
          },
          gn = function(e, t, r) {
              e.done || (e.done = !0, r && (e = r), e.value = t, e.state = ZH, xu(e, !0))
          },
          bu = function(e, t, r) {
              if (!e.done) {
                  e.done = !0, r && (e = r);
                  try {
                      if (e.facade === t) throw Eb("Promise can't be resolved itself");
                      var n = Tb(t);
                      n ? gb(function() {
                          var i = {
                              done: !1
                          };
                          try {
                              Jt(n, t, vn(bu, i, e), vn(gn, i, e))
                          } catch (a) {
                              gn(i, a, e)
                          }
                      }) : (e.value = t, e.state = Sb, xu(e, !1))
                  } catch (i) {
                      gn({
                          done: !1
                      }, i, e)
                  }
              }
          };
      if (_i && (dt = function(t) {
              kH(this, mn), vu(t), Jt(ja, this);
              var r = cb(this);
              try {
                  t(vn(bu, r), vn(gn, r))
              } catch (n) {
                  gn(r, n)
              }
          }, mn = dt.prototype, ja = function(t) {
              XH(this, {
                  type: er,
                  done: !1,
                  notified: !1,
                  parent: !1,
                  reactions: [],
                  rejection: !1,
                  state: fb,
                  value: void 0
              })
          }, ja.prototype = DH(mn, {
              then: function(t, r) {
                  var n = $H(this),
                      i = n.reactions,
                      a = yn(VH(this, dt));
                  return a.ok = bi(t) ? t : !0, a.fail = bi(r) && r, a.domain = Xa ? Su.domain : void 0, n.parent = !0, i[i.length] = a, n.state != fb && xu(n, !1), a.promise
              },
              catch: function(e) {
                  return this.then(void 0, e)
              }
          }), pb = function() {
              var e = new ja,
                  t = cb(e);
              this.promise = e, this.resolve = vn(bu, t), this.reject = vn(gn, t)
          }, yb.f = yn = function(e) {
              return e === dt || e === Tu ? new pb(e) : KH(e)
          }, !Wa && bi(Ua) && Br !== Object.prototype)) {
          db = Br.then, Eu || (sb(Br, "then", function(t, r) {
              var n = this;
              return new dt(function(i, a) {
                      Jt(db, n, i, a)
                  })
                  .then(t, r)
          }, {
              unsafe: !0
          }), sb(Br, "catch", mn.catch, {
              unsafe: !0
          }));
          try {
              delete Br.constructor
          } catch {}
          lb && lb(Br, mn)
      }
      $a({
          global: !0,
          wrap: !0,
          forced: _i
      }, {
          Promise: dt
      });
      FH(dt, er, !1, !0);
      qH(er);
      Tu = RH(er);
      $a({
          target: er,
          stat: !0,
          forced: _i
      }, {
          reject: function(t) {
              var r = yn(this);
              return Jt(r.reject, void 0, t), r.promise
          }
      });
      $a({
          target: er,
          stat: !0,
          forced: Wa || _i
      }, {
          resolve: function(t) {
              return GH(Wa && this === Tu ? dt : this, t)
          }
      });
      $a({
          target: er,
          stat: !0,
          forced: JH
      }, {
          all: function(t) {
              var r = this,
                  n = yn(r),
                  i = n.resolve,
                  a = n.reject,
                  s = gu(function() {
                      var o = vu(r.resolve),
                          l = [],
                          f = 0,
                          u = 1;
                      ub(t, function(c) {
                          var v = f++,
                              d = !1;
                          u++, Jt(o, r, c)
                              .then(function(p) {
                                  d || (d = !0, l[v] = p, --u || i(l))
                              }, a)
                      }), --u || i(l)
                  });
              return s.error && a(s.value), n.promise
          },
          race: function(t) {
              var r = this,
                  n = yn(r),
                  i = n.reject,
                  a = gu(function() {
                      var s = vu(r.resolve);
                      ub(t, function(o) {
                          Jt(s, r, o)
                              .then(n.resolve, i)
                      })
                  });
              return a.error && i(a.value), n.promise
          }
      })
  });
  var qb = E((Goe, Fb) => {
      var Mb = oe(),
          Rb = ei(),
          Db = we(),
          rj = mr(),
          Ka = Oa(),
          nj = Kt(),
          ij = Oe(),
          aj = on(),
          Pb = "USE_FUNCTION_CONSTRUCTOR",
          Cb = ij("asyncIterator"),
          wb = Mb.AsyncIterator,
          Ob = Rb.AsyncIteratorPrototype,
          Bt, Au;
      if (Ob) Bt = Ob;
      else if (Db(wb)) Bt = wb.prototype;
      else if (Rb[Pb] || Mb[Pb]) try {
          Au = Ka(Ka(Ka(Function("return async function*(){}()")()))), Ka(Au) === Object.prototype && (Bt = Au)
      } catch {}
      Bt ? aj && (Bt = rj(Bt)) : Bt = {};
      Db(Bt[Cb]) || nj(Bt, Cb, function() {
          return this
      });
      Fb.exports = Bt
  });
  var Ou = E((zoe, Bb) => {
      "use strict";
      var Pu = qa(),
          Ya = $e(),
          sj = mr(),
          Lb = cr(),
          oj = Ga(),
          kb = Dr(),
          lj = ct(),
          uj = qb(),
          Qa = lj("Promise"),
          hj = kb.set,
          Cu = kb.get,
          wu = function(e, t, r) {
              var n = e.done;
              Qa.resolve(e.value)
                  .then(function(i) {
                      t({
                          done: n,
                          value: i
                      })
                  }, r)
          },
          Nb = function(t) {
              hj(this, {
                  iterator: Ya(t),
                  next: t.next
              })
          };
      Nb.prototype = oj(sj(uj), {
          next: function(t) {
              var r = Cu(this),
                  n = !!arguments.length;
              return new Qa(function(i, a) {
                  var s = Ya(Pu(r.next, r.iterator, n ? [t] : []));
                  wu(s, i, a)
              })
          },
          return: function(e) {
              var t = Cu(this)
                  .iterator,
                  r = !!arguments.length;
              return new Qa(function(n, i) {
                  var a = Lb(t, "return");
                  if (a === void 0) return n({
                      done: !0,
                      value: e
                  });
                  var s = Ya(Pu(a, t, r ? [e] : []));
                  wu(s, n, i)
              })
          },
          throw: function(e) {
              var t = Cu(this)
                  .iterator,
                  r = !!arguments.length;
              return new Qa(function(n, i) {
                  var a = Lb(t, "throw");
                  if (a === void 0) return i(e);
                  var s = Ya(Pu(a, t, r ? [e] : []));
                  wu(s, n, i)
              })
          }
      });
      Bb.exports = Nb
  });
  var Gb = E((Hoe, Vb) => {
      var cj = ht(),
          fj = Ou(),
          pj = $e(),
          dj = hi(),
          mj = cr(),
          vj = Oe(),
          gj = vj("asyncIterator");
      Vb.exports = function(e, t) {
          var r = arguments.length < 2 ? mj(e, gj) : t;
          return r ? pj(cj(r, e)) : new fj(dj(e))
      }
  });
  var Hb = E((joe, zb) => {
      var yj = oe();
      zb.exports = function(e) {
          return yj[e].prototype
      }
  });
  var Xb = E((Woe, Ub) => {
      "use strict";
      var Ej = oe(),
          jb = ht(),
          Wb = At(),
          Mu = $e(),
          bj = ct(),
          _j = cr(),
          Sj = 9007199254740991,
          Ij = Ej.TypeError,
          Si = function(e) {
              var t = e == 0,
                  r = e == 1,
                  n = e == 2,
                  i = e == 3;
              return function(a, s, o) {
                  Mu(a);
                  var l = bj("Promise"),
                      f = Wb(a.next),
                      u = 0,
                      c = s !== void 0;
                  return (c || !t) && Wb(s), new l(function(v, d) {
                      var p = function(g, y) {
                              try {
                                  var b = _j(a, "return");
                                  if (b) return l.resolve(jb(b, a))
                                      .then(function() {
                                          g(y)
                                      }, function(_) {
                                          d(_)
                                      })
                              } catch (_) {
                                  return d(_)
                              }
                              g(y)
                          },
                          m = function(g) {
                              p(d, g)
                          },
                          h = function() {
                              try {
                                  if (t && u > Sj && c) throw Ij("The allowed number of iterations has been exceeded");
                                  l.resolve(Mu(jb(f, a)))
                                      .then(function(g) {
                                          try {
                                              if (Mu(g)
                                                  .done) t ? (o.length = u, v(o)) : v(i ? !1 : n || void 0);
                                              else {
                                                  var y = g.value;
                                                  c ? l.resolve(t ? s(y, u) : s(y))
                                                      .then(function(b) {
                                                          r ? h() : n ? b ? h() : p(v, !1) : t ? (o[u++] = b, h()) : b ? p(v, i || y) : h()
                                                      }, m) : (o[u++] = y, h())
                                              }
                                          } catch (b) {
                                              m(b)
                                          }
                                      }, m)
                              } catch (g) {
                                  m(g)
                              }
                          };
                      h()
                  })
              }
          };
      Ub.exports = {
          toArray: Si(0),
          forEach: Si(1),
          every: Si(2),
          some: Si(3),
          find: Si(4)
      }
  });
  var Kb = E((Uoe, $b) => {
      "use strict";
      var Tj = Pt(),
          xj = Re(),
          Aj = Fr(),
          Pj = Gb(),
          Cj = hi(),
          wj = ui(),
          Oj = cr(),
          Mj = Hb(),
          Rj = ct(),
          Dj = Oe(),
          Fj = Ou(),
          qj = Xb()
          .toArray,
          Lj = Dj("asyncIterator"),
          kj = Mj("Array")
          .values;
      $b.exports = function(t) {
          var r = this,
              n = arguments.length,
              i = n > 1 ? arguments[1] : void 0,
              a = n > 2 ? arguments[2] : void 0;
          return new(Rj("Promise"))(function(s) {
              var o = xj(t);
              i !== void 0 && (i = Tj(i, a));
              var l = Oj(o, Lj),
                  f = l ? void 0 : wj(o) || kj,
                  u = Aj(r) ? new r : [],
                  c = l ? Pj(o, l) : new Fj(Cj(o, f));
              s(qj(c, i, u))
          })
      }
  });
  var Yb = E(() => {
      var Nj = de(),
          Bj = Kb();
      Nj({
          target: "Array",
          stat: !0
      }, {
          fromAsync: Bj
      })
  });
  var Qb = E(() => {
      Al()
  });
  var Zb = E(() => {
      "use strict";
      var Vj = de(),
          Gj = kt()
          .filterReject,
          zj = qe();
      Vj({
          target: "Array",
          proto: !0
      }, {
          filterOut: function(t) {
              return Gj(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      zj("filterOut")
  });
  var Jb = E(() => {
      "use strict";
      var Hj = de(),
          jj = kt()
          .filterReject,
          Wj = qe();
      Hj({
          target: "Array",
          proto: !0
      }, {
          filterReject: function(t) {
              return jj(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      Wj("filterReject")
  });
  var Ru = E((tle, t_) => {
      var Uj = Pt(),
          Xj = Or(),
          $j = Re(),
          Kj = Ae(),
          e_ = function(e) {
              var t = e == 1;
              return function(r, n, i) {
                  for (var a = $j(r), s = Xj(a), o = Uj(n, i), l = Kj(s), f, u; l-- > 0;)
                      if (f = s[l], u = o(f, l, a), u) switch (e) {
                          case 0:
                              return f;
                          case 1:
                              return l
                      }
                  return t ? -1 : void 0
              }
          };
      t_.exports = {
          findLast: e_(0),
          findLastIndex: e_(1)
      }
  });
  var r_ = E(() => {
      "use strict";
      var Yj = de(),
          Qj = Ru()
          .findLast,
          Zj = qe();
      Yj({
          target: "Array",
          proto: !0
      }, {
          findLast: function(t) {
              return Qj(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      Zj("findLast")
  });
  var n_ = E(() => {
      "use strict";
      var Jj = de(),
          eW = Ru()
          .findLastIndex,
          tW = qe();
      Jj({
          target: "Array",
          proto: !0
      }, {
          findLastIndex: function(t) {
              return eW(this, t, arguments.length > 1 ? arguments[1] : void 0)
          }
      });
      tW("findLastIndex")
  });
  var a_ = E((sle, i_) => {
      i_.exports = function(e, t) {
          for (var r = 0, n = t.length, i = new e(n); n > r;) i[r] = t[r++];
          return i
      }
  });
  var o_ = E((ole, s_) => {
      var rW = oe(),
          nW = Pt(),
          iW = Te(),
          aW = Or(),
          sW = Re(),
          oW = ti(),
          lW = Ae(),
          uW = mr(),
          hW = a_(),
          cW = rW.Array,
          fW = iW([].push);
      s_.exports = function(e, t, r, n) {
          for (var i = sW(e), a = aW(i), s = nW(t, r), o = uW(null), l = lW(a), f = 0, u, c, v; l > f; f++) v = a[f], c = oW(s(v, f, i)), c in o ? fW(o[c], v) : o[c] = [v];
          if (n && (u = n(i), u !== cW))
              for (c in o) o[c] = hW(u, o[c]);
          return o
      }
  });
  var l_ = E(() => {
      "use strict";
      var pW = de(),
          dW = o_(),
          mW = Pl(),
          vW = qe();
      pW({
          target: "Array",
          proto: !0
      }, {
          groupBy: function(t) {
              var r = arguments.length > 1 ? arguments[1] : void 0;
              return dW(this, t, r, mW)
          }
      });
      vW("groupBy")
  });
  var c_ = E(() => {
      var gW = de(),
          yW = dr(),
          u_ = Object.isFrozen,
          h_ = function(e, t) {
              if (!u_ || !yW(e) || !u_(e)) return !1;
              for (var r = 0, n = e.length, i; r < n;)
                  if (i = e[r++], !(typeof i == "string" || t && typeof i > "u")) return !1;
              return n !== 0
          };
      gW({
          target: "Array",
          stat: !0
      }, {
          isTemplateObject: function(t) {
              if (!h_(t, !0)) return !1;
              var r = t.raw;
              return !(r.length !== t.length || !h_(r, !1))
          }
      })
  });
  var d_ = E(() => {
      "use strict";
      var EW = Tt(),
          bW = qe(),
          f_ = Re(),
          p_ = Ae(),
          _W = pt()
          .f;
      EW && !("lastItem" in []) && (_W(Array.prototype, "lastItem", {
          configurable: !0,
          get: function() {
              var t = f_(this),
                  r = p_(t);
              return r == 0 ? void 0 : t[r - 1]
          },
          set: function(t) {
              var r = f_(this),
                  n = p_(r);
              return r[n == 0 ? 0 : n - 1] = t
          }
      }), bW("lastItem"))
  });
  var m_ = E(() => {
      "use strict";
      var SW = Tt(),
          IW = qe(),
          TW = Re(),
          xW = Ae(),
          AW = pt()
          .f;
      SW && !("lastIndex" in []) && (AW(Array.prototype, "lastIndex", {
          configurable: !0,
          get: function() {
              var t = TW(this),
                  r = xW(t);
              return r == 0 ? 0 : r - 1
          }
      }), IW("lastIndex"))
  });
  var y_ = E((vle, g_) => {
      "use strict";
      var PW = ct(),
          Za = Te(),
          CW = At(),
          wW = Ae(),
          OW = Re(),
          MW = qr(),
          v_ = PW("Map"),
          Du = v_.prototype,
          RW = Za(Du.forEach),
          DW = Za(Du.has),
          FW = Za(Du.set),
          qW = Za([].push);
      g_.exports = function(t) {
          var r = OW(this),
              n = wW(r),
              i = MW(r, 0),
              a = new v_,
              s = t != null ? CW(t) : function(u) {
                  return u
              },
              o, l, f;
          for (o = 0; o < n; o++) l = r[o], f = s(l), DW(a, f) || FW(a, f, l);
          return RW(a, function(u) {
              qW(i, u)
          }), i
      }
  });
  var E_ = E(() => {
      "use strict";
      var LW = de(),
          kW = qe(),
          NW = y_();
      LW({
          target: "Array",
          proto: !0
      }, {
          uniqueBy: NW
      });
      kW("uniqueBy")
  });
  var __ = E((Ele, b_) => {
      var BW = UE();
      b1();
      Ab();
      Yb();
      Qb();
      Zb();
      Jb();
      r_();
      n_();
      l_();
      c_();
      d_();
      m_();
      E_();
      b_.exports = BW
  });
  var B_ = E(is => {
      "use strict";
      Object.defineProperty(is, "__esModule", {
          value: !0
      });
      is.strFromU8 = N_;
      is.unzip = ZW;
      var S_ = {},
          VW = function(e, t, r, n, i) {
              let a = new Worker(S_[t] || (S_[t] = URL.createObjectURL(new Blob([e + ';addEventListener("error",function(e){e=e.error;postMessage({$e$:[e.message,e.code,e.stack]})})'], {
                  type: "text/javascript"
              }))));
              return a.onmessage = function(s) {
                  let o = s.data,
                      l = o.$e$;
                  if (l) {
                      let f = new Error(l[0]);
                      f.code = l[1], f.stack = l[2], i(f, null)
                  } else i(null, o)
              }, a.postMessage(r, n), a
          },
          et = Uint8Array,
          Er = Uint16Array,
          Fu = Uint32Array,
          qu = new et([0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 0, 0, 0]),
          Lu = new et([0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 0, 0]),
          A_ = new et([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]),
          P_ = function(e, t) {
              let r = new Er(31);
              for (var n = 0; n < 31; ++n) r[n] = t += 1 << e[n - 1];
              let i = new Fu(r[30]);
              for (n = 1; n < 30; ++n)
                  for (let a = r[n]; a < r[n + 1]; ++a) i[a] = a - r[n] << 5 | n;
              return [r, i]
          },
          C_ = P_(qu, 2),
          ku = C_[0],
          GW = C_[1];
      ku[28] = 258, GW[258] = 28;
      var zW = P_(Lu, 0),
          w_ = zW[0],
          rs = new Er(32768);
      for (Se = 0; Se < 32768; ++Se) {
          let e = (43690 & Se) >>> 1 | (21845 & Se) << 1;
          e = (52428 & e) >>> 2 | (13107 & e) << 2, e = (61680 & e) >>> 4 | (3855 & e) << 4, rs[Se] = ((65280 & e) >>> 8 | (255 & e) << 8) >>> 1
      }
      var Se, En = function(e, t, r) {
              let n = e.length,
                  i = 0,
                  a = new Er(t);
              for (; i < n; ++i) e[i] && ++a[e[i] - 1];
              let s = new Er(t);
              for (i = 0; i < t; ++i) s[i] = s[i - 1] + a[i - 1] << 1;
              let o;
              if (r) {
                  o = new Er(1 << t);
                  let l = 15 - t;
                  for (i = 0; i < n; ++i)
                      if (e[i]) {
                          let f = i << 4 | e[i],
                              u = t - e[i],
                              c = s[e[i] - 1]++ << u;
                          for (let v = c | (1 << u) - 1; c <= v; ++c) o[rs[c] >>> l] = f
                      }
              } else
                  for (o = new Er(n), i = 0; i < n; ++i) e[i] && (o[i] = rs[s[e[i] - 1]++] >>> 15 - e[i]);
              return o
          },
          Ii = new et(288);
      for (Se = 0; Se < 144; ++Se) Ii[Se] = 8;
      for (Se = 144; Se < 256; ++Se) Ii[Se] = 9;
      for (Se = 256; Se < 280; ++Se) Ii[Se] = 7;
      for (Se = 280; Se < 288; ++Se) Ii[Se] = 8;
      var O_ = new et(32);
      for (Se = 0; Se < 32; ++Se) O_[Se] = 5;
      var M_ = En(Ii, 9, 1),
          R_ = En(O_, 5, 1),
          es = function(e) {
              let t = e[0];
              for (let r = 1; r < e.length; ++r) e[r] > t && (t = e[r]);
              return t
          },
          mt = function(e, t, r) {
              let n = t / 8 | 0;
              return (e[n] | e[n + 1] << 8) >> (7 & t) & r
          },
          ts = function(e, t) {
              let r = t / 8 | 0;
              return (e[r] | e[r + 1] << 8 | e[r + 2] << 16) >> (7 & t)
          },
          D_ = function(e) {
              return (e + 7) / 8 | 0
          },
          ns = function(e, t, r) {
              (t == null || t < 0) && (t = 0), (r == null || r > e.length) && (r = e.length);
              let n = new(e.BYTES_PER_ELEMENT === 2 ? Er : e.BYTES_PER_ELEMENT === 4 ? Fu : et)(r - t);
              return n.set(e.subarray(t, r)), n
          },
          F_ = ["unexpected EOF", "invalid block type", "invalid length/literal", "invalid distance", "stream finished", "no stream handler", , "no callback", "invalid UTF-8 data", "extra field too long", "date not in range 1980-2099", "filename too long", "stream finishing", "invalid zip data"],
          Je = function(e, t, r) {
              let n = new Error(t || F_[e]);
              if (n.code = e, Error.captureStackTrace && Error.captureStackTrace(n, Je), !r) throw n;
              return n
          },
          q_ = function(e, t, r) {
              let n = e.length;
              if (!n || r && r.f && !r.l) return t || new et(0);
              let i = !t || r,
                  a = !r || r.i;
              r || (r = {}), t || (t = new et(3 * n));
              let s = function(_) {
                      let I = t.length;
                      if (_ > I) {
                          let C = new et(Math.max(2 * I, _));
                          C.set(t), t = C
                      }
                  },
                  o = r.f || 0,
                  l = r.p || 0,
                  f = r.b || 0,
                  u = r.l,
                  c = r.d,
                  v = r.m,
                  d = r.n,
                  p = 8 * n;
              do {
                  if (!u) {
                      o = mt(e, l, 1);
                      let x = mt(e, l + 1, 3);
                      if (l += 3, !x) {
                          let O = e[(h = D_(l) + 4) - 4] | e[h - 3] << 8,
                              L = h + O;
                          if (L > n) {
                              a && Je(0);
                              break
                          }
                          i && s(f + O), t.set(e.subarray(h, L), f), r.b = f += O, r.p = l = 8 * L, r.f = o;
                          continue
                      }
                      if (x === 1) u = M_, c = R_, v = 9, d = 5;
                      else if (x === 2) {
                          let O = mt(e, l, 31) + 257,
                              L = mt(e, l + 10, 15) + 4,
                              D = O + mt(e, l + 5, 31) + 1;
                          l += 14;
                          let A = new et(D),
                              q = new et(19);
                          for (var m = 0; m < L; ++m) q[A_[m]] = mt(e, l + 3 * m, 7);
                          l += 3 * L;
                          let w = es(q),
                              F = (1 << w) - 1,
                              k = En(q, w, 1);
                          for (m = 0; m < D;) {
                              let W = k[mt(e, l, F)];
                              var h;
                              if (l += 15 & W, (h = W >>> 4) < 16) A[m++] = h;
                              else {
                                  var g = 0;
                                  let S = 0;
                                  for (h === 16 ? (S = 3 + mt(e, l, 3), l += 2, g = A[m - 1]) : h === 17 ? (S = 3 + mt(e, l, 7), l += 3) : h === 18 && (S = 11 + mt(e, l, 127), l += 7); S--;) A[m++] = g
                              }
                          }
                          let U = A.subarray(0, O);
                          var y = A.subarray(O);
                          v = es(U), d = es(y), u = En(U, v, 1), c = En(y, d, 1)
                      } else Je(1);
                      if (l > p) {
                          a && Je(0);
                          break
                      }
                  }
                  i && s(f + 131072);
                  let _ = (1 << v) - 1,
                      I = (1 << d) - 1,
                      C = l;
                  for (;; C = l) {
                      let x = (g = u[ts(e, l) & _]) >>> 4;
                      if (l += 15 & g, l > p) {
                          a && Je(0);
                          break
                      }
                      if (g || Je(2), x < 256) t[f++] = x;
                      else {
                          if (x === 256) {
                              C = l, u = null;
                              break
                          } {
                              let O = x - 254;
                              if (x > 264) {
                                  var b = qu[m = x - 257];
                                  O = mt(e, l, (1 << b) - 1) + ku[m], l += b
                              }
                              let L = c[ts(e, l) & I],
                                  D = L >>> 4;
                              if (L || Je(3), l += 15 & L, y = w_[D], D > 3 && (b = Lu[D], y += ts(e, l) & (1 << b) - 1, l += b), l > p) {
                                  a && Je(0);
                                  break
                              }
                              i && s(f + 131072);
                              let A = f + O;
                              for (; f < A; f += 4) t[f] = t[f - y], t[f + 1] = t[f + 1 - y], t[f + 2] = t[f + 2 - y], t[f + 3] = t[f + 3 - y];
                              f = A
                          }
                      }
                  }
                  r.l = u, r.p = C, r.b = f, r.f = o, u && (o = 1, r.m = v, r.d = c, r.n = d)
              } while (!o);
              return f === t.length ? t : ns(t, 0, f)
          },
          HW = function(e, t) {
              let r = {};
              for (var n in e) r[n] = e[n];
              for (var n in t) r[n] = t[n];
              return r
          },
          I_ = function(e, t, r) {
              let n = e(),
                  i = e.toString(),
                  a = i.slice(i.indexOf("[") + 1, i.lastIndexOf("]"))
                  .replace(/\s+/g, "")
                  .split(",");
              for (let s = 0; s < n.length; ++s) {
                  let o = n[s],
                      l = a[s];
                  if (typeof o == "function") {
                      t += ";" + l + "=";
                      let f = o.toString();
                      if (o.prototype)
                          if (f.indexOf("[native code]") !== -1) {
                              let u = f.indexOf(" ", 8) + 1;
                              t += f.slice(u, f.indexOf("(", u))
                          } else {
                              t += f;
                              for (let u in o.prototype) t += ";" + l + ".prototype." + u + "=" + o.prototype[u].toString()
                          }
                      else t += f
                  } else r[l] = o
              }
              return [t, r]
          },
          Ja = [],
          jW = function(e) {
              let t = [];
              for (let r in e) e[r].buffer && t.push((e[r] = new e[r].constructor(e[r]))
                  .buffer);
              return t
          },
          WW = function(e, t, r, n) {
              let i;
              if (!Ja[r]) {
                  let s = "",
                      o = {},
                      l = e.length - 1;
                  for (let f = 0; f < l; ++f) i = I_(e[f], s, o), s = i[0], o = i[1];
                  Ja[r] = I_(e[l], s, o)
              }
              let a = HW({}, Ja[r][1]);
              return VW(Ja[r][0] + ";onmessage=function(e){for(var kz in e.data)self[kz]=e.data[kz];onmessage=" + t.toString() + "}", r, a, jW(a), n)
          },
          UW = function() {
              return [et, Er, Fu, qu, Lu, A_, ku, w_, M_, R_, rs, F_, En, es, mt, ts, D_, ns, Je, q_, Nu, L_, k_]
          },
          L_ = function(e) {
              return postMessage(e, [e.buffer])
          },
          k_ = function(e) {
              return e && e.size && new et(e.size)
          },
          XW = function(e, t, r, n, i, a) {
              var s = WW(r, n, i, function(o, l) {
                  s.terminate(), a(o, l)
              });
              return s.postMessage([e, t], t.consume ? [e.buffer] : []),
                  function() {
                      s.terminate()
                  }
          },
          yr = function(e, t) {
              return e[t] | e[t + 1] << 8
          },
          tr = function(e, t) {
              return (e[t] | e[t + 1] << 8 | e[t + 2] << 16 | e[t + 3] << 24) >>> 0
          };

      function $W(e, t, r) {
          return r || (r = t, t = {}), typeof r != "function" && Je(7), XW(e, t, [UW], function(n) {
              return L_(Nu(n.data[0], k_(n.data[1])))
          }, 1, r)
      }

      function Nu(e, t) {
          return q_(e, t)
      }
      var T_ = typeof TextDecoder < "u" && new TextDecoder,
          KW = function(e) {
              for (let t = "", r = 0;;) {
                  let n = e[r++],
                      i = (n > 127) + (n > 223) + (n > 239);
                  if (r + i > e.length) return [t, ns(e, r - 1)];
                  i ? i === 3 ? (n = ((15 & n) << 18 | (63 & e[r++]) << 12 | (63 & e[r++]) << 6 | 63 & e[r++]) - 65536, t += String.fromCharCode(55296 | n >> 10, 56320 | 1023 & n)) : t += 1 & i ? String.fromCharCode((31 & n) << 6 | 63 & e[r++]) : String.fromCharCode((15 & n) << 12 | (63 & e[r++]) << 6 | 63 & e[r++]) : t += String.fromCharCode(n)
              }
          };

      function N_(e, t) {
          if (t) {
              let r = "";
              for (let n = 0; n < e.length; n += 16384) r += String.fromCharCode.apply(null, e.subarray(n, n + 16384));
              return r
          }
          if (T_) return T_.decode(e);
          {
              let r = KW(e),
                  n = r[0];
              return r[1].length && Je(8), n
          }
      }
      var YW = function(e, t) {
              return t + 30 + yr(e, t + 26) + yr(e, t + 28)
          },
          QW = function(e, t, r) {
              let n = yr(e, t + 28),
                  i = N_(e.subarray(t + 46, t + 46 + n), !(2048 & yr(e, t + 8))),
                  a = t + 46 + n,
                  s = tr(e, t + 20),
                  o = r && s === 4294967295 ? z64e(e, a) : [s, tr(e, t + 24), tr(e, t + 42)],
                  l = o[0],
                  f = o[1],
                  u = o[2];
              return [yr(e, t + 10), l, f, i, a + yr(e, t + 30) + yr(e, t + 32), u]
          },
          x_ = typeof queueMicrotask == "function" ? queueMicrotask : typeof setTimeout == "function" ? setTimeout : function(e) {
              e()
          };

      function ZW(e, t, r) {
          r || (r = t, t = {}), typeof r != "function" && Je(7);
          let n = [],
              i = function() {
                  for (let f = 0; f < n.length; ++f) n[f]()
              },
              a = {},
              s = function(f, u) {
                  x_(function() {
                      r(f, u)
                  })
              };
          x_(function() {
              s = r
          });
          let o = e.length - 22;
          for (; tr(e, o) !== 101010256; --o)
              if (!o || e.length - o > 65558) return s(Je(13, 0, 1), null), i;
          let l = yr(e, o + 8);
          if (l) {
              let f = l,
                  u = tr(e, o + 16),
                  c = u === 4294967295 || f === 65535;
              if (c) {
                  let p = tr(e, o - 12);
                  c = tr(e, p) === 101075792, c && (f = l = tr(e, p + 32), u = tr(e, p + 48))
              }
              let v = t && t.filter,
                  d = function() {
                      let p = QW(e, u, c),
                          m = p[0],
                          h = p[1],
                          g = p[2],
                          y = p[3],
                          b = p[4],
                          _ = p[5],
                          I = YW(e, _);
                      u = b;
                      let C = function(x, O) {
                          x ? (i(), s(x, null)) : (O && (a[y] = O), --l || s(null, a))
                      };
                      if (!v || v({
                              name: y,
                              size: h,
                              originalSize: g,
                              compression: m
                          }))
                          if (m)
                              if (m === 8) {
                                  let x = e.subarray(I, I + h);
                                  if (h < 32e4) try {
                                      C(null, Nu(x, new et(g)))
                                  } catch (O) {
                                      C(O, null)
                                  } else n.push($W(x, {
                                      size: g
                                  }, C))
                              } else C(Je(14, "unknown compression type " + m, 1), null);
                      else C(null, ns(e, I, I + h));
                      else C(null, null)
                  };
              for (let p = 0; p < f; ++p) d(p)
          } else s(null, {});
          return i
      }
  });
  var G_ = {};
  nC(G_, {
      fetchLottie: () => aU,
      unZipDotLottie: () => V_
  });

  function JW(e) {
      let t = JSON.parse(e);
      if (!("animations" in t)) throw new Error("Manifest not found");
      if (t.animations.length === 0) throw new Error("No animations listed in the manifest");
      return t
  }

  function eU(e) {
      let t = new Uint8Array(e, 0, 32);
      return t[0] === 80 && t[1] === 75 && t[2] === 3 && t[3] === 4
  }
  async function tU(e) {
      return await fetch(new URL(e)
              .href)
          .then(t => t.arrayBuffer())
  }
  async function rU(e) {
      return (await new Promise(r => {
              let n = new FileReader;
              n.readAsDataURL(new Blob([e])), n.onload = () => r(n.result)
          }))
          .split(",", 2)[1]
  }
  async function nU(e) {
      let t = new Uint8Array(e),
          r = await new Promise((n, i) => {
              (0, as.unzip)(t, (a, s) => a ? i(a) : n(s))
          });
      return {
          read: n => (0, as.strFromU8)(r[n]),
          readB64: async n => await rU(r[n])
      }
  }
  async function iU(e, t) {
      if (!("assets" in e)) return e;
      async function r(i) {
          let {
              p: a
          } = i;
          if (a == null || t.read(`images/${a}`) == null) return i;
          let s = a.split(".")
              .pop(),
              o = await t.readB64(`images/${a}`);
          if (s?.startsWith("data:")) return i.p = s, i.e = 1, i;
          switch (s) {
              case "svg":
              case "svg+xml":
                  i.p = `data:image/svg+xml;base64,${o}`;
                  break;
              case "png":
              case "jpg":
              case "jpeg":
              case "gif":
              case "webp":
                  i.p = `data:image/${s};base64,${o}`;
                  break;
              default:
                  i.p = `data:;base64,${o}`
          }
          return i.e = 1, i
      }
      return (await Promise.all(e.assets.map(r)))
          .map((i, a) => {
              e.assets[a] = i
          }), e
  }
  async function V_(e) {
      let t = await nU(e),
          r = JW(t.read("manifest.json"));
      return (await Promise.all(r.animations.map(i => {
          let a = JSON.parse(t.read(`animations/${i.id}.json`));
          return iU(a, t)
      })))[0]
  }
  async function aU(e) {
      let t = await tU(e);
      return eU(t) ? await V_(t) : JSON.parse(new TextDecoder()
          .decode(t))
  }
  var as, z_ = rC(() => {
      as = iC(B_())
  });
  var X_ = E(vt => {
      "use strict";
      var zu = ut()
          .default;
      Object.defineProperty(vt, "__esModule", {
          value: !0
      });
      vt.ready = vt.init = vt.destroy = vt.createInstance = vt.cleanupElement = void 0;
      var sU = zu(Pr()),
          ss = zu(Ec()),
          Bu = zu(Ho());
      __();
      var oU = (z_(), aC(G_)),
          lU = () => window.Webflow.require("lottie")
          .lottie,
          uU = () => !!(window.Webflow.env("design") || window.Webflow.env("preview")),
          Ti = {
              Playing: "playing",
              Stopped: "stopped"
          },
          Vu = class {
              constructor() {
                  (0, ss.default)(this, "_cache", [])
              }
              set(t, r) {
                  let n = (0, Bu.default)(this._cache, ({
                      wrapper: i
                  }) => i === t);
                  n !== -1 && this._cache.splice(n, 1), this._cache.push({
                      wrapper: t,
                      instance: r
                  })
              }
              delete(t) {
                  let r = (0, Bu.default)(this._cache, ({
                      wrapper: n
                  }) => n === t);
                  r !== -1 && this._cache.splice(r, 1)
              }
              get(t) {
                  let r = (0, Bu.default)(this._cache, ({
                      wrapper: n
                  }) => n === t);
                  return r !== -1 ? this._cache[r].instance : null
              }
          },
          os = new Vu,
          H_ = {},
          Gu = class {
              constructor() {
                  (0, ss.default)(this, "config", null), (0, ss.default)(this, "currentState", Ti.Stopped), (0, ss.default)(this, "handlers", {
                      enterFrame: [],
                      complete: [],
                      loop: [],
                      dataReady: [],
                      destroy: [],
                      error: []
                  })
              }
              load(t) {
                  let n = (t.dataset || H_)
                      .src || "";
                  n.endsWith(".lottie") ? (0, oU.fetchLottie)(n)
                      .then(i => {
                          this._loadAnimation(t, i)
                      }) : this._loadAnimation(t, void 0), os.set(t, this), this.container = t
              }
              _loadAnimation(t, r) {
                  let n = t.dataset || H_,
                      i = n.src || "",
                      a = n.preserveAspectRatio || "xMidYMid meet",
                      s = n.renderer || "svg",
                      o = parseFloat(n.loop) === 1,
                      l = parseFloat(n.direction) || 1,
                      f = parseFloat(n.autoplay) === 1,
                      u = parseFloat(n.duration) || 0,
                      c = parseFloat(n.isIx2Target) === 1,
                      v = parseFloat(n.ix2InitialState);
                  isNaN(v) && (v = null);
                  let d = {
                      src: i,
                      loop: o,
                      autoplay: f,
                      renderer: s,
                      direction: l,
                      duration: u,
                      hasIx2: c,
                      ix2InitialValue: v,
                      preserveAspectRatio: a
                  };
                  if (this.animationItem && this.config && this.config.src === i && s === this.config.renderer && a === this.config.preserveAspectRatio) {
                      if (o !== this.config.loop && this.setLooping(o), c || (l !== this.config.direction && this.setDirection(l), u !== this.config.duration && (u > 0 && u !== this.duration ? this.setSpeed(this.duration / u) : this.setSpeed(1))), f && this.play(), v && v !== this.config.ix2InitialValue) {
                          let m = v / 100;
                          this.goToFrame(this.frames * m)
                      }
                      this.config = d;
                      return
                  }
                  let p = {
                      container: t,
                      loop: o,
                      autoplay: f,
                      renderer: s,
                      rendererSettings: {
                          preserveAspectRatio: a,
                          progressiveLoad: !0,
                          hideOnTransparent: !0
                      }
                  };
                  try {
                      this.animationItem && this.destroy(), this.animationItem = lU()
                          .loadAnimation((0, sU.default)({}, p, r ? {
                              animationData: r
                          } : {
                              path: i
                          }))
                  } catch (m) {
                      this.handlers.error.forEach(h => h(m));
                      return
                  }
                  this.animationItem && (uU() && (this.animationItem.addEventListener("enterFrame", () => {
                      if (!this.isPlaying) return;
                      let {
                          currentFrame: m,
                          totalFrames: h,
                          playDirection: g
                      } = this.animationItem, y = m / h * 100, b = Math.round(g === 1 ? y : 100 - y);
                      this.handlers.enterFrame.forEach(_ => _(b, m))
                  }), this.animationItem.addEventListener("complete", () => {
                      if (this.currentState !== Ti.Playing) {
                          this.handlers.complete.forEach(m => m());
                          return
                      }
                      if (!this.animationItem.loop) {
                          this.handlers.complete.forEach(m => m());
                          return
                      }
                      this.currentState = Ti.Stopped
                  }), this.animationItem.addEventListener("loopComplete", m => {
                      this.handlers.loop.forEach(h => h(m))
                  }), this.animationItem.addEventListener("data_failed", m => {
                      this.handlers.error.forEach(h => h(m))
                  }), this.animationItem.addEventListener("error", m => {
                      this.handlers.error.forEach(h => h(m))
                  })), this.isLoaded ? (this.handlers.dataReady.forEach(m => m()), f && this.play()) : this.animationItem.addEventListener("data_ready", () => {
                      if (this.handlers.dataReady.forEach(m => m()), c || (this.setDirection(l), u > 0 && u !== this.duration && this.setSpeed(this.duration / u), f && this.play()), v) {
                          let m = v / 100;
                          this.goToFrame(this.frames * m)
                      }
                  }), this.config = d)
              }
              onFrameChange(t) {
                  this.handlers.enterFrame.indexOf(t) === -1 && this.handlers.enterFrame.push(t)
              }
              onPlaybackComplete(t) {
                  this.handlers.complete.indexOf(t) === -1 && this.handlers.complete.push(t)
              }
              onLoopComplete(t) {
                  this.handlers.loop.indexOf(t) === -1 && this.handlers.loop.push(t)
              }
              onDestroy(t) {
                  this.handlers.destroy.indexOf(t) === -1 && this.handlers.destroy.push(t)
              }
              onDataReady(t) {
                  this.handlers.dataReady.indexOf(t) === -1 && this.handlers.dataReady.push(t)
              }
              onError(t) {
                  this.handlers.error.indexOf(t) === -1 && this.handlers.error.push(t)
              }
              play() {
                  if (!this.animationItem) return;
                  let t = this.animationItem.playDirection === 1 ? 0 : this.frames;
                  this.animationItem.goToAndPlay(t, !0), this.currentState = Ti.Playing
              }
              stop() {
                  if (this.animationItem) {
                      if (this.isPlaying) {
                          let {
                              playDirection: t
                          } = this.animationItem, r = t === 1 ? 0 : this.frames;
                          this.animationItem.goToAndStop(r, !0)
                      }
                      this.currentState = Ti.Stopped
                  }
              }
              destroy() {
                  this.animationItem && (this.isPlaying && this.stop(), this.handlers.destroy.forEach(t => t()), this.container && os.delete(this.container), this.animationItem.destroy(), Object.keys(this.handlers)
                      .forEach(t => this.handlers[t].length = 0), this.animationItem = null, this.container = null, this.config = null)
              }
              get isPlaying() {
                  return this.animationItem ? !this.animationItem.isPaused : !1
              }
              get isPaused() {
                  return this.animationItem ? this.animationItem.isPaused : !1
              }
              get duration() {
                  return this.animationItem ? this.animationItem.getDuration() : 0
              }
              get frames() {
                  return this.animationItem ? this.animationItem.totalFrames : 0
              }
              get direction() {
                  return this.animationItem ? this.animationItem.playDirection : 1
              }
              get isLoaded() {
                  return this.animationItem, this.animationItem.isLoaded
              }
              get ix2InitialValue() {
                  return this.config ? this.config.ix2InitialValue : null
              }
              goToFrame(t) {
                  this.animationItem && this.animationItem.setCurrentRawFrameValue(t)
              }
              setSubframe(t) {
                  this.animationItem && this.animationItem.setSubframe(t)
              }
              setSpeed(t = 1) {
                  this.animationItem && (this.isPlaying && this.stop(), this.animationItem.setSpeed(t))
              }
              setLooping(t) {
                  this.animationItem && (this.isPlaying && this.stop(), this.animationItem.loop = t)
              }
              setDirection(t) {
                  this.animationItem && (this.isPlaying && this.stop(), this.animationItem.setDirection(t), this.goToFrame(t === 1 ? 0 : this.frames))
              }
          },
          j_ = () => Array.from(document.querySelectorAll('[data-animation-type="lottie"]')),
          W_ = e => {
              let t = os.get(e);
              return t == null && (t = new Gu), t.load(e), t
          };
      vt.createInstance = W_;
      var Hu = e => {
          let t = os.get(e);
          t && t.destroy()
      };
      vt.cleanupElement = Hu;
      var U_ = () => {
          j_()
              .forEach(e => {
                  parseFloat(e.getAttribute("data-is-ix2-target")) === 1 || Hu(e), W_(e)
              })
      };
      vt.init = U_;
      var hU = () => {
          j_()
              .forEach(Hu)
      };
      vt.destroy = hU;
      var cU = U_;
      vt.ready = cU
  });
  var $_ = E((exports, module) => {
      typeof navigator < "u" && function(e, t) {
          typeof exports == "object" && typeof module < "u" ? module.exports = t() : typeof define == "function" && define.amd ? define(t) : (e = typeof globalThis < "u" ? globalThis : e || self)
              .lottie = t()
      }(exports, function() {
          "use strict";
          var svgNS = "http://www.w3.org/2000/svg",
              locationHref = "",
              _useWebWorker = !1,
              initialDefaultFrame = -999999,
              setWebWorker = function(e) {
                  _useWebWorker = !!e
              },
              getWebWorker = function() {
                  return _useWebWorker
              },
              setLocationHref = function(e) {
                  locationHref = e
              },
              getLocationHref = function() {
                  return locationHref
              };

          function createTag(e) {
              return document.createElement(e)
          }

          function extendPrototype(e, t) {
              var r, n, i = e.length;
              for (r = 0; r < i; r += 1)
                  for (var a in n = e[r].prototype) Object.prototype.hasOwnProperty.call(n, a) && (t.prototype[a] = n[a])
          }

          function getDescriptor(e, t) {
              return Object.getOwnPropertyDescriptor(e, t)
          }

          function createProxyFunction(e) {
              function t() {}
              return t.prototype = e, t
          }
          var audioControllerFactory = function() {
                  function e(t) {
                      this.audios = [], this.audioFactory = t, this._volume = 1, this._isMuted = !1
                  }
                  return e.prototype = {
                          addAudio: function(t) {
                              this.audios.push(t)
                          },
                          pause: function() {
                              var t, r = this.audios.length;
                              for (t = 0; t < r; t += 1) this.audios[t].pause()
                          },
                          resume: function() {
                              var t, r = this.audios.length;
                              for (t = 0; t < r; t += 1) this.audios[t].resume()
                          },
                          setRate: function(t) {
                              var r, n = this.audios.length;
                              for (r = 0; r < n; r += 1) this.audios[r].setRate(t)
                          },
                          createAudio: function(t) {
                              return this.audioFactory ? this.audioFactory(t) : window.Howl ? new window.Howl({
                                  src: [t]
                              }) : {
                                  isPlaying: !1,
                                  play: function() {
                                      this.isPlaying = !0
                                  },
                                  seek: function() {
                                      this.isPlaying = !1
                                  },
                                  playing: function() {},
                                  rate: function() {},
                                  setVolume: function() {}
                              }
                          },
                          setAudioFactory: function(t) {
                              this.audioFactory = t
                          },
                          setVolume: function(t) {
                              this._volume = t, this._updateVolume()
                          },
                          mute: function() {
                              this._isMuted = !0, this._updateVolume()
                          },
                          unmute: function() {
                              this._isMuted = !1, this._updateVolume()
                          },
                          getVolume: function() {
                              return this._volume
                          },
                          _updateVolume: function() {
                              var t, r = this.audios.length;
                              for (t = 0; t < r; t += 1) this.audios[t].volume(this._volume * (this._isMuted ? 0 : 1))
                          }
                      },
                      function() {
                          return new e
                      }
              }(),
              createTypedArray = function() {
                  function e(t, r) {
                      var n, i = 0,
                          a = [];
                      switch (t) {
                          case "int16":
                          case "uint8c":
                              n = 1;
                              break;
                          default:
                              n = 1.1
                      }
                      for (i = 0; i < r; i += 1) a.push(n);
                      return a
                  }
                  return typeof Uint8ClampedArray == "function" && typeof Float32Array == "function" ? function(t, r) {
                      return t === "float32" ? new Float32Array(r) : t === "int16" ? new Int16Array(r) : t === "uint8c" ? new Uint8ClampedArray(r) : e(t, r)
                  } : e
              }();

          function createSizedArray(e) {
              return Array.apply(null, {
                  length: e
              })
          }

          function _typeof$6(e) {
              return _typeof$6 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof$6(e)
          }
          var subframeEnabled = !0,
              expressionsPlugin = null,
              expressionsInterfaces = null,
              idPrefix$1 = "",
              isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent),
              _shouldRoundValues = !1,
              bmPow = Math.pow,
              bmSqrt = Math.sqrt,
              bmFloor = Math.floor,
              bmMax = Math.max,
              bmMin = Math.min,
              BMMath = {};

          function ProjectInterface$1() {
              return {}
          }(function() {
              var e, t = ["abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "atan2", "ceil", "cbrt", "expm1", "clz32", "cos", "cosh", "exp", "floor", "fround", "hypot", "imul", "log", "log1p", "log2", "log10", "max", "min", "pow", "random", "round", "sign", "sin", "sinh", "sqrt", "tan", "tanh", "trunc", "E", "LN10", "LN2", "LOG10E", "LOG2E", "PI", "SQRT1_2", "SQRT2"],
                  r = t.length;
              for (e = 0; e < r; e += 1) BMMath[t[e]] = Math[t[e]]
          })(), BMMath.random = Math.random, BMMath.abs = function(e) {
              if (_typeof$6(e) === "object" && e.length) {
                  var t, r = createSizedArray(e.length),
                      n = e.length;
                  for (t = 0; t < n; t += 1) r[t] = Math.abs(e[t]);
                  return r
              }
              return Math.abs(e)
          };
          var defaultCurveSegments = 150,
              degToRads = Math.PI / 180,
              roundCorner = .5519;

          function roundValues(e) {
              _shouldRoundValues = !!e
          }

          function bmRnd(e) {
              return _shouldRoundValues ? Math.round(e) : e
          }

          function styleDiv(e) {
              e.style.position = "absolute", e.style.top = 0, e.style.left = 0, e.style.display = "block", e.style.transformOrigin = "0 0", e.style.webkitTransformOrigin = "0 0", e.style.backfaceVisibility = "visible", e.style.webkitBackfaceVisibility = "visible", e.style.transformStyle = "preserve-3d", e.style.webkitTransformStyle = "preserve-3d", e.style.mozTransformStyle = "preserve-3d"
          }

          function BMEnterFrameEvent(e, t, r, n) {
              this.type = e, this.currentTime = t, this.totalTime = r, this.direction = n < 0 ? -1 : 1
          }

          function BMCompleteEvent(e, t) {
              this.type = e, this.direction = t < 0 ? -1 : 1
          }

          function BMCompleteLoopEvent(e, t, r, n) {
              this.type = e, this.currentLoop = r, this.totalLoops = t, this.direction = n < 0 ? -1 : 1
          }

          function BMSegmentStartEvent(e, t, r) {
              this.type = e, this.firstFrame = t, this.totalFrames = r
          }

          function BMDestroyEvent(e, t) {
              this.type = e, this.target = t
          }

          function BMRenderFrameErrorEvent(e, t) {
              this.type = "renderFrameError", this.nativeError = e, this.currentTime = t
          }

          function BMConfigErrorEvent(e) {
              this.type = "configError", this.nativeError = e
          }

          function BMAnimationConfigErrorEvent(e, t) {
              this.type = e, this.nativeError = t
          }
          var createElementID = (_count = 0, function() {
                  return idPrefix$1 + "__lottie_element_" + (_count += 1)
              }),
              _count;

          function HSVtoRGB(e, t, r) {
              var n, i, a, s, o, l, f, u;
              switch (l = r * (1 - t), f = r * (1 - (o = 6 * e - (s = Math.floor(6 * e))) * t), u = r * (1 - (1 - o) * t), s % 6) {
                  case 0:
                      n = r, i = u, a = l;
                      break;
                  case 1:
                      n = f, i = r, a = l;
                      break;
                  case 2:
                      n = l, i = r, a = u;
                      break;
                  case 3:
                      n = l, i = f, a = r;
                      break;
                  case 4:
                      n = u, i = l, a = r;
                      break;
                  case 5:
                      n = r, i = l, a = f
              }
              return [n, i, a]
          }

          function RGBtoHSV(e, t, r) {
              var n, i = Math.max(e, t, r),
                  a = Math.min(e, t, r),
                  s = i - a,
                  o = i === 0 ? 0 : s / i,
                  l = i / 255;
              switch (i) {
                  case a:
                      n = 0;
                      break;
                  case e:
                      n = t - r + s * (t < r ? 6 : 0), n /= 6 * s;
                      break;
                  case t:
                      n = r - e + 2 * s, n /= 6 * s;
                      break;
                  case r:
                      n = e - t + 4 * s, n /= 6 * s
              }
              return [n, o, l]
          }

          function addSaturationToRGB(e, t) {
              var r = RGBtoHSV(255 * e[0], 255 * e[1], 255 * e[2]);
              return r[1] += t, r[1] > 1 ? r[1] = 1 : r[1] <= 0 && (r[1] = 0), HSVtoRGB(r[0], r[1], r[2])
          }

          function addBrightnessToRGB(e, t) {
              var r = RGBtoHSV(255 * e[0], 255 * e[1], 255 * e[2]);
              return r[2] += t, r[2] > 1 ? r[2] = 1 : r[2] < 0 && (r[2] = 0), HSVtoRGB(r[0], r[1], r[2])
          }

          function addHueToRGB(e, t) {
              var r = RGBtoHSV(255 * e[0], 255 * e[1], 255 * e[2]);
              return r[0] += t / 360, r[0] > 1 ? r[0] -= 1 : r[0] < 0 && (r[0] += 1), HSVtoRGB(r[0], r[1], r[2])
          }
          var rgbToHex = function() {
                  var e, t, r = [];
                  for (e = 0; e < 256; e += 1) t = e.toString(16), r[e] = t.length === 1 ? "0" + t : t;
                  return function(n, i, a) {
                      return n < 0 && (n = 0), i < 0 && (i = 0), a < 0 && (a = 0), "#" + r[n] + r[i] + r[a]
                  }
              }(),
              setSubframeEnabled = function(e) {
                  subframeEnabled = !!e
              },
              getSubframeEnabled = function() {
                  return subframeEnabled
              },
              setExpressionsPlugin = function(e) {
                  expressionsPlugin = e
              },
              getExpressionsPlugin = function() {
                  return expressionsPlugin
              },
              setExpressionInterfaces = function(e) {
                  expressionsInterfaces = e
              },
              getExpressionInterfaces = function() {
                  return expressionsInterfaces
              },
              setDefaultCurveSegments = function(e) {
                  defaultCurveSegments = e
              },
              getDefaultCurveSegments = function() {
                  return defaultCurveSegments
              },
              setIdPrefix = function(e) {
                  idPrefix$1 = e
              },
              getIdPrefix = function() {
                  return idPrefix$1
              };

          function createNS(e) {
              return document.createElementNS(svgNS, e)
          }

          function _typeof$5(e) {
              return _typeof$5 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof$5(e)
          }
          var dataManager = function() {
                  var e, t, r = 1,
                      n = [],
                      i = {
                          onmessage: function() {},
                          postMessage: function(l) {
                              e({
                                  data: l
                              })
                          }
                      },
                      a = {
                          postMessage: function(l) {
                              i.onmessage({
                                  data: l
                              })
                          }
                      };

                  function s() {
                      t || (t = function(l) {
                          if (window.Worker && window.Blob && getWebWorker()) {
                              var f = new Blob(["var _workerSelf = self; self.onmessage = ", l.toString()], {
                                      type: "text/javascript"
                                  }),
                                  u = URL.createObjectURL(f);
                              return new Worker(u)
                          }
                          return e = l, i
                      }(function(l) {
                          if (a.dataManager || (a.dataManager = function() {
                                  function u(x, O) {
                                      var L, D, A, q, w, F, k = x.length;
                                      for (D = 0; D < k; D += 1)
                                          if ("ks" in (L = x[D]) && !L.completed) {
                                              if (L.completed = !0, L.hasMask) {
                                                  var U = L.masksProperties;
                                                  for (q = U.length, A = 0; A < q; A += 1)
                                                      if (U[A].pt.k.i) d(U[A].pt.k);
                                                      else
                                                          for (F = U[A].pt.k.length, w = 0; w < F; w += 1) U[A].pt.k[w].s && d(U[A].pt.k[w].s[0]), U[A].pt.k[w].e && d(U[A].pt.k[w].e[0])
                                              }
                                              L.ty === 0 ? (L.layers = c(L.refId, O), u(L.layers, O)) : L.ty === 4 ? v(L.shapes) : L.ty === 5 && I(L)
                                          }
                                  }

                                  function c(x, O) {
                                      var L = function(D, A) {
                                          for (var q = 0, w = A.length; q < w;) {
                                              if (A[q].id === D) return A[q];
                                              q += 1
                                          }
                                          return null
                                      }(x, O);
                                      return L ? L.layers.__used ? JSON.parse(JSON.stringify(L.layers)) : (L.layers.__used = !0, L.layers) : null
                                  }

                                  function v(x) {
                                      var O, L, D;
                                      for (O = x.length - 1; O >= 0; O -= 1)
                                          if (x[O].ty === "sh")
                                              if (x[O].ks.k.i) d(x[O].ks.k);
                                              else
                                                  for (D = x[O].ks.k.length, L = 0; L < D; L += 1) x[O].ks.k[L].s && d(x[O].ks.k[L].s[0]), x[O].ks.k[L].e && d(x[O].ks.k[L].e[0]);
                                      else x[O].ty === "gr" && v(x[O].it)
                                  }

                                  function d(x) {
                                      var O, L = x.i.length;
                                      for (O = 0; O < L; O += 1) x.i[O][0] += x.v[O][0], x.i[O][1] += x.v[O][1], x.o[O][0] += x.v[O][0], x.o[O][1] += x.v[O][1]
                                  }

                                  function p(x, O) {
                                      var L = O ? O.split(".") : [100, 100, 100];
                                      return x[0] > L[0] || !(L[0] > x[0]) && (x[1] > L[1] || !(L[1] > x[1]) && (x[2] > L[2] || !(L[2] > x[2]) && null))
                                  }
                                  var m, h = function() {
                                          var x = [4, 4, 14];

                                          function O(L) {
                                              var D, A, q, w = L.length;
                                              for (D = 0; D < w; D += 1) L[D].ty === 5 && (q = void 0, q = (A = L[D])
                                                  .t.d, A.t.d = {
                                                      k: [{
                                                          s: q,
                                                          t: 0
                                                      }]
                                                  })
                                          }
                                          return function(L) {
                                              if (p(x, L.v) && (O(L.layers), L.assets)) {
                                                  var D, A = L.assets.length;
                                                  for (D = 0; D < A; D += 1) L.assets[D].layers && O(L.assets[D].layers)
                                              }
                                          }
                                      }(),
                                      g = (m = [4, 7, 99], function(x) {
                                          if (x.chars && !p(m, x.v)) {
                                              var O, L = x.chars.length;
                                              for (O = 0; O < L; O += 1) {
                                                  var D = x.chars[O];
                                                  D.data && D.data.shapes && (v(D.data.shapes), D.data.ip = 0, D.data.op = 99999, D.data.st = 0, D.data.sr = 1, D.data.ks = {
                                                      p: {
                                                          k: [0, 0],
                                                          a: 0
                                                      },
                                                      s: {
                                                          k: [100, 100],
                                                          a: 0
                                                      },
                                                      a: {
                                                          k: [0, 0],
                                                          a: 0
                                                      },
                                                      r: {
                                                          k: 0,
                                                          a: 0
                                                      },
                                                      o: {
                                                          k: 100,
                                                          a: 0
                                                      }
                                                  }, x.chars[O].t || (D.data.shapes.push({
                                                      ty: "no"
                                                  }), D.data.shapes[0].it.push({
                                                      p: {
                                                          k: [0, 0],
                                                          a: 0
                                                      },
                                                      s: {
                                                          k: [100, 100],
                                                          a: 0
                                                      },
                                                      a: {
                                                          k: [0, 0],
                                                          a: 0
                                                      },
                                                      r: {
                                                          k: 0,
                                                          a: 0
                                                      },
                                                      o: {
                                                          k: 100,
                                                          a: 0
                                                      },
                                                      sk: {
                                                          k: 0,
                                                          a: 0
                                                      },
                                                      sa: {
                                                          k: 0,
                                                          a: 0
                                                      },
                                                      ty: "tr"
                                                  })))
                                              }
                                          }
                                      }),
                                      y = function() {
                                          var x = [5, 7, 15];

                                          function O(L) {
                                              var D, A, q = L.length;
                                              for (D = 0; D < q; D += 1) L[D].ty === 5 && (A = void 0, typeof(A = L[D].t.p)
                                                  .a == "number" && (A.a = {
                                                      a: 0,
                                                      k: A.a
                                                  }), typeof A.p == "number" && (A.p = {
                                                      a: 0,
                                                      k: A.p
                                                  }), typeof A.r == "number" && (A.r = {
                                                      a: 0,
                                                      k: A.r
                                                  }))
                                          }
                                          return function(L) {
                                              if (p(x, L.v) && (O(L.layers), L.assets)) {
                                                  var D, A = L.assets.length;
                                                  for (D = 0; D < A; D += 1) L.assets[D].layers && O(L.assets[D].layers)
                                              }
                                          }
                                      }(),
                                      b = function() {
                                          var x = [4, 1, 9];

                                          function O(D) {
                                              var A, q, w, F = D.length;
                                              for (A = 0; A < F; A += 1)
                                                  if (D[A].ty === "gr") O(D[A].it);
                                                  else if (D[A].ty === "fl" || D[A].ty === "st")
                                                  if (D[A].c.k && D[A].c.k[0].i)
                                                      for (w = D[A].c.k.length, q = 0; q < w; q += 1) D[A].c.k[q].s && (D[A].c.k[q].s[0] /= 255, D[A].c.k[q].s[1] /= 255, D[A].c.k[q].s[2] /= 255, D[A].c.k[q].s[3] /= 255), D[A].c.k[q].e && (D[A].c.k[q].e[0] /= 255, D[A].c.k[q].e[1] /= 255, D[A].c.k[q].e[2] /= 255, D[A].c.k[q].e[3] /= 255);
                                                  else D[A].c.k[0] /= 255, D[A].c.k[1] /= 255, D[A].c.k[2] /= 255, D[A].c.k[3] /= 255
                                          }

                                          function L(D) {
                                              var A, q = D.length;
                                              for (A = 0; A < q; A += 1) D[A].ty === 4 && O(D[A].shapes)
                                          }
                                          return function(D) {
                                              if (p(x, D.v) && (L(D.layers), D.assets)) {
                                                  var A, q = D.assets.length;
                                                  for (A = 0; A < q; A += 1) D.assets[A].layers && L(D.assets[A].layers)
                                              }
                                          }
                                      }(),
                                      _ = function() {
                                          var x = [4, 4, 18];

                                          function O(D) {
                                              var A, q, w;
                                              for (A = D.length - 1; A >= 0; A -= 1)
                                                  if (D[A].ty === "sh")
                                                      if (D[A].ks.k.i) D[A].ks.k.c = D[A].closed;
                                                      else
                                                          for (w = D[A].ks.k.length, q = 0; q < w; q += 1) D[A].ks.k[q].s && (D[A].ks.k[q].s[0].c = D[A].closed), D[A].ks.k[q].e && (D[A].ks.k[q].e[0].c = D[A].closed);
                                              else D[A].ty === "gr" && O(D[A].it)
                                          }

                                          function L(D) {
                                              var A, q, w, F, k, U, W = D.length;
                                              for (q = 0; q < W; q += 1) {
                                                  if ((A = D[q])
                                                      .hasMask) {
                                                      var S = A.masksProperties;
                                                      for (F = S.length, w = 0; w < F; w += 1)
                                                          if (S[w].pt.k.i) S[w].pt.k.c = S[w].cl;
                                                          else
                                                              for (U = S[w].pt.k.length, k = 0; k < U; k += 1) S[w].pt.k[k].s && (S[w].pt.k[k].s[0].c = S[w].cl), S[w].pt.k[k].e && (S[w].pt.k[k].e[0].c = S[w].cl)
                                                  }
                                                  A.ty === 4 && O(A.shapes)
                                              }
                                          }
                                          return function(D) {
                                              if (p(x, D.v) && (L(D.layers), D.assets)) {
                                                  var A, q = D.assets.length;
                                                  for (A = 0; A < q; A += 1) D.assets[A].layers && L(D.assets[A].layers)
                                              }
                                          }
                                      }();

                                  function I(x) {
                                      x.t.a.length === 0 && x.t.p
                                  }
                                  var C = {
                                      completeData: function(x) {
                                          x.__complete || (b(x), h(x), g(x), y(x), _(x), u(x.layers, x.assets), function(O, L) {
                                              if (O) {
                                                  var D = 0,
                                                      A = O.length;
                                                  for (D = 0; D < A; D += 1) O[D].t === 1 && (O[D].data.layers = c(O[D].data.refId, L), u(O[D].data.layers, L))
                                              }
                                          }(x.chars, x.assets), x.__complete = !0)
                                      }
                                  };
                                  return C.checkColors = b, C.checkChars = g, C.checkPathProperties = y, C.checkShapes = _, C.completeLayers = u, C
                              }()), a.assetLoader || (a.assetLoader = function() {
                                  function u(c) {
                                      var v = c.getResponseHeader("content-type");
                                      return v && c.responseType === "json" && v.indexOf("json") !== -1 || c.response && _typeof$5(c.response) === "object" ? c.response : c.response && typeof c.response == "string" ? JSON.parse(c.response) : c.responseText ? JSON.parse(c.responseText) : null
                                  }
                                  return {
                                      load: function(c, v, d, p) {
                                          var m, h = new XMLHttpRequest;
                                          try {
                                              h.responseType = "json"
                                          } catch {}
                                          h.onreadystatechange = function() {
                                              if (h.readyState === 4)
                                                  if (h.status === 200) m = u(h), d(m);
                                                  else try {
                                                      m = u(h), d(m)
                                                  } catch (g) {
                                                      p && p(g)
                                                  }
                                          };
                                          try {
                                              h.open(["G", "E", "T"].join(""), c, !0)
                                          } catch {
                                              h.open(["G", "E", "T"].join(""), v + "/" + c, !0)
                                          }
                                          h.send()
                                      }
                                  }
                              }()), l.data.type === "loadAnimation") a.assetLoader.load(l.data.path, l.data.fullPath, function(u) {
                              a.dataManager.completeData(u), a.postMessage({
                                  id: l.data.id,
                                  payload: u,
                                  status: "success"
                              })
                          }, function() {
                              a.postMessage({
                                  id: l.data.id,
                                  status: "error"
                              })
                          });
                          else if (l.data.type === "complete") {
                              var f = l.data.animation;
                              a.dataManager.completeData(f), a.postMessage({
                                  id: l.data.id,
                                  payload: f,
                                  status: "success"
                              })
                          } else l.data.type === "loadData" && a.assetLoader.load(l.data.path, l.data.fullPath, function(u) {
                              a.postMessage({
                                  id: l.data.id,
                                  payload: u,
                                  status: "success"
                              })
                          }, function() {
                              a.postMessage({
                                  id: l.data.id,
                                  status: "error"
                              })
                          })
                      }), t.onmessage = function(l) {
                          var f = l.data,
                              u = f.id,
                              c = n[u];
                          n[u] = null, f.status === "success" ? c.onComplete(f.payload) : c.onError && c.onError()
                      })
                  }

                  function o(l, f) {
                      var u = "processId_" + (r += 1);
                      return n[u] = {
                          onComplete: l,
                          onError: f
                      }, u
                  }
                  return {
                      loadAnimation: function(l, f, u) {
                          s();
                          var c = o(f, u);
                          t.postMessage({
                              type: "loadAnimation",
                              path: l,
                              fullPath: window.location.origin + window.location.pathname,
                              id: c
                          })
                      },
                      loadData: function(l, f, u) {
                          s();
                          var c = o(f, u);
                          t.postMessage({
                              type: "loadData",
                              path: l,
                              fullPath: window.location.origin + window.location.pathname,
                              id: c
                          })
                      },
                      completeAnimation: function(l, f, u) {
                          s();
                          var c = o(f, u);
                          t.postMessage({
                              type: "complete",
                              animation: l,
                              id: c
                          })
                      }
                  }
              }(),
              ImagePreloader = function() {
                  var e = function() {
                      var o = createTag("canvas");
                      o.width = 1, o.height = 1;
                      var l = o.getContext("2d");
                      return l.fillStyle = "rgba(0,0,0,0)", l.fillRect(0, 0, 1, 1), o
                  }();

                  function t() {
                      this.loadedAssets += 1, this.loadedAssets === this.totalImages && this.loadedFootagesCount === this.totalFootages && this.imagesLoadedCb && this.imagesLoadedCb(null)
                  }

                  function r() {
                      this.loadedFootagesCount += 1, this.loadedAssets === this.totalImages && this.loadedFootagesCount === this.totalFootages && this.imagesLoadedCb && this.imagesLoadedCb(null)
                  }

                  function n(o, l, f) {
                      var u = "";
                      if (o.e) u = o.p;
                      else if (l) {
                          var c = o.p;
                          c.indexOf("images/") !== -1 && (c = c.split("/")[1]), u = l + c
                      } else u = f, u += o.u ? o.u : "", u += o.p;
                      return u
                  }

                  function i(o) {
                      var l = 0,
                          f = setInterval(function() {
                              (o.getBBox()
                                  .width || l > 500) && (this._imageLoaded(), clearInterval(f)), l += 1
                          }.bind(this), 50)
                  }

                  function a(o) {
                      var l = {
                              assetData: o
                          },
                          f = n(o, this.assetsPath, this.path);
                      return dataManager.loadData(f, function(u) {
                          l.img = u, this._footageLoaded()
                      }.bind(this), function() {
                          l.img = {}, this._footageLoaded()
                      }.bind(this)), l
                  }

                  function s() {
                      this._imageLoaded = t.bind(this), this._footageLoaded = r.bind(this), this.testImageLoaded = i.bind(this), this.createFootageData = a.bind(this), this.assetsPath = "", this.path = "", this.totalImages = 0, this.totalFootages = 0, this.loadedAssets = 0, this.loadedFootagesCount = 0, this.imagesLoadedCb = null, this.images = []
                  }
                  return s.prototype = {
                      loadAssets: function(o, l) {
                          var f;
                          this.imagesLoadedCb = l;
                          var u = o.length;
                          for (f = 0; f < u; f += 1) o[f].layers || (o[f].t && o[f].t !== "seq" ? o[f].t === 3 && (this.totalFootages += 1, this.images.push(this.createFootageData(o[f]))) : (this.totalImages += 1, this.images.push(this._createImageData(o[f]))))
                      },
                      setAssetsPath: function(o) {
                          this.assetsPath = o || ""
                      },
                      setPath: function(o) {
                          this.path = o || ""
                      },
                      loadedImages: function() {
                          return this.totalImages === this.loadedAssets
                      },
                      loadedFootages: function() {
                          return this.totalFootages === this.loadedFootagesCount
                      },
                      destroy: function() {
                          this.imagesLoadedCb = null, this.images.length = 0
                      },
                      getAsset: function(o) {
                          for (var l = 0, f = this.images.length; l < f;) {
                              if (this.images[l].assetData === o) return this.images[l].img;
                              l += 1
                          }
                          return null
                      },
                      createImgData: function(o) {
                          var l = n(o, this.assetsPath, this.path),
                              f = createTag("img");
                          f.crossOrigin = "anonymous", f.addEventListener("load", this._imageLoaded, !1), f.addEventListener("error", function() {
                              u.img = e, this._imageLoaded()
                          }.bind(this), !1), f.src = l;
                          var u = {
                              img: f,
                              assetData: o
                          };
                          return u
                      },
                      createImageData: function(o) {
                          var l = n(o, this.assetsPath, this.path),
                              f = createNS("image");
                          isSafari ? this.testImageLoaded(f) : f.addEventListener("load", this._imageLoaded, !1), f.addEventListener("error", function() {
                              u.img = e, this._imageLoaded()
                          }.bind(this), !1), f.setAttributeNS("http://www.w3.org/1999/xlink", "href", l), this._elementHelper.append ? this._elementHelper.append(f) : this._elementHelper.appendChild(f);
                          var u = {
                              img: f,
                              assetData: o
                          };
                          return u
                      },
                      imageLoaded: t,
                      footageLoaded: r,
                      setCacheType: function(o, l) {
                          o === "svg" ? (this._elementHelper = l, this._createImageData = this.createImageData.bind(this)) : this._createImageData = this.createImgData.bind(this)
                      }
                  }, s
              }();

          function BaseEvent() {}
          BaseEvent.prototype = {
              triggerEvent: function(e, t) {
                  if (this._cbs[e])
                      for (var r = this._cbs[e], n = 0; n < r.length; n += 1) r[n](t)
              },
              addEventListener: function(e, t) {
                  return this._cbs[e] || (this._cbs[e] = []), this._cbs[e].push(t),
                      function() {
                          this.removeEventListener(e, t)
                      }.bind(this)
              },
              removeEventListener: function(e, t) {
                  if (t) {
                      if (this._cbs[e]) {
                          for (var r = 0, n = this._cbs[e].length; r < n;) this._cbs[e][r] === t && (this._cbs[e].splice(r, 1), r -= 1, n -= 1), r += 1;
                          this._cbs[e].length || (this._cbs[e] = null)
                      }
                  } else this._cbs[e] = null
              }
          };
          var markerParser = function() {
                  function e(t) {
                      for (var r, n = t.split(`\r
`), i = {}, a = 0, s = 0; s < n.length; s += 1)(r = n[s].split(":"))
                          .length === 2 && (i[r[0]] = r[1].trim(), a += 1);
                      if (a === 0) throw new Error;
                      return i
                  }
                  return function(t) {
                      for (var r = [], n = 0; n < t.length; n += 1) {
                          var i = t[n],
                              a = {
                                  time: i.tm,
                                  duration: i.dr
                              };
                          try {
                              a.payload = JSON.parse(t[n].cm)
                          } catch {
                              try {
                                  a.payload = e(t[n].cm)
                              } catch {
                                  a.payload = {
                                      name: t[n].cm
                                  }
                              }
                          }
                          r.push(a)
                      }
                      return r
                  }
              }(),
              ProjectInterface = function() {
                  function e(t) {
                      this.compositions.push(t)
                  }
                  return function() {
                      function t(r) {
                          for (var n = 0, i = this.compositions.length; n < i;) {
                              if (this.compositions[n].data && this.compositions[n].data.nm === r) return this.compositions[n].prepareFrame && this.compositions[n].data.xt && this.compositions[n].prepareFrame(this.currentFrame), this.compositions[n].compInterface;
                              n += 1
                          }
                          return null
                      }
                      return t.compositions = [], t.currentFrame = 0, t.registerComposition = e, t
                  }
              }(),
              renderers = {},
              registerRenderer = function(e, t) {
                  renderers[e] = t
              };

          function getRenderer(e) {
              return renderers[e]
          }

          function getRegisteredRenderer() {
              if (renderers.canvas) return "canvas";
              for (var e in renderers)
                  if (renderers[e]) return e;
              return ""
          }

          function _typeof$4(e) {
              return _typeof$4 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof$4(e)
          }
          var AnimationItem = function() {
              this._cbs = [], this.name = "", this.path = "", this.isLoaded = !1, this.currentFrame = 0, this.currentRawFrame = 0, this.firstFrame = 0, this.totalFrames = 0, this.frameRate = 0, this.frameMult = 0, this.playSpeed = 1, this.playDirection = 1, this.playCount = 0, this.animationData = {}, this.assets = [], this.isPaused = !0, this.autoplay = !1, this.loop = !0, this.renderer = null, this.animationID = createElementID(), this.assetsPath = "", this.timeCompleted = 0, this.segmentPos = 0, this.isSubframeEnabled = getSubframeEnabled(), this.segments = [], this._idle = !0, this._completedLoop = !1, this.projectInterface = ProjectInterface(), this.imagePreloader = new ImagePreloader, this.audioController = audioControllerFactory(), this.markers = [], this.configAnimation = this.configAnimation.bind(this), this.onSetupError = this.onSetupError.bind(this), this.onSegmentComplete = this.onSegmentComplete.bind(this), this.drawnFrameEvent = new BMEnterFrameEvent("drawnFrame", 0, 0, 0), this.expressionsPlugin = getExpressionsPlugin()
          };
          extendPrototype([BaseEvent], AnimationItem), AnimationItem.prototype.setParams = function(e) {
              (e.wrapper || e.container) && (this.wrapper = e.wrapper || e.container);
              var t = "svg";
              e.animType ? t = e.animType : e.renderer && (t = e.renderer);
              var r = getRenderer(t);
              this.renderer = new r(this, e.rendererSettings), this.imagePreloader.setCacheType(t, this.renderer.globalData.defs), this.renderer.setProjectInterface(this.projectInterface), this.animType = t, e.loop === "" || e.loop === null || e.loop === void 0 || e.loop === !0 ? this.loop = !0 : e.loop === !1 ? this.loop = !1 : this.loop = parseInt(e.loop, 10), this.autoplay = !("autoplay" in e) || e.autoplay, this.name = e.name ? e.name : "", this.autoloadSegments = !Object.prototype.hasOwnProperty.call(e, "autoloadSegments") || e.autoloadSegments, this.assetsPath = e.assetsPath, this.initialSegment = e.initialSegment, e.audioFactory && this.audioController.setAudioFactory(e.audioFactory), e.animationData ? this.setupAnimation(e.animationData) : e.path && (e.path.lastIndexOf("\\") !== -1 ? this.path = e.path.substr(0, e.path.lastIndexOf("\\") + 1) : this.path = e.path.substr(0, e.path.lastIndexOf("/") + 1), this.fileName = e.path.substr(e.path.lastIndexOf("/") + 1), this.fileName = this.fileName.substr(0, this.fileName.lastIndexOf(".json")), dataManager.loadAnimation(e.path, this.configAnimation, this.onSetupError))
          }, AnimationItem.prototype.onSetupError = function() {
              this.trigger("data_failed")
          }, AnimationItem.prototype.setupAnimation = function(e) {
              dataManager.completeAnimation(e, this.configAnimation)
          }, AnimationItem.prototype.setData = function(e, t) {
              t && _typeof$4(t) !== "object" && (t = JSON.parse(t));
              var r = {
                      wrapper: e,
                      animationData: t
                  },
                  n = e.attributes;
              r.path = n.getNamedItem("data-animation-path") ? n.getNamedItem("data-animation-path")
                  .value : n.getNamedItem("data-bm-path") ? n.getNamedItem("data-bm-path")
                  .value : n.getNamedItem("bm-path") ? n.getNamedItem("bm-path")
                  .value : "", r.animType = n.getNamedItem("data-anim-type") ? n.getNamedItem("data-anim-type")
                  .value : n.getNamedItem("data-bm-type") ? n.getNamedItem("data-bm-type")
                  .value : n.getNamedItem("bm-type") ? n.getNamedItem("bm-type")
                  .value : n.getNamedItem("data-bm-renderer") ? n.getNamedItem("data-bm-renderer")
                  .value : n.getNamedItem("bm-renderer") ? n.getNamedItem("bm-renderer")
                  .value : getRegisteredRenderer() || "canvas";
              var i = n.getNamedItem("data-anim-loop") ? n.getNamedItem("data-anim-loop")
                  .value : n.getNamedItem("data-bm-loop") ? n.getNamedItem("data-bm-loop")
                  .value : n.getNamedItem("bm-loop") ? n.getNamedItem("bm-loop")
                  .value : "";
              i === "false" ? r.loop = !1 : i === "true" ? r.loop = !0 : i !== "" && (r.loop = parseInt(i, 10));
              var a = n.getNamedItem("data-anim-autoplay") ? n.getNamedItem("data-anim-autoplay")
                  .value : n.getNamedItem("data-bm-autoplay") ? n.getNamedItem("data-bm-autoplay")
                  .value : !n.getNamedItem("bm-autoplay") || n.getNamedItem("bm-autoplay")
                  .value;
              r.autoplay = a !== "false", r.name = n.getNamedItem("data-name") ? n.getNamedItem("data-name")
                  .value : n.getNamedItem("data-bm-name") ? n.getNamedItem("data-bm-name")
                  .value : n.getNamedItem("bm-name") ? n.getNamedItem("bm-name")
                  .value : "", (n.getNamedItem("data-anim-prerender") ? n.getNamedItem("data-anim-prerender")
                      .value : n.getNamedItem("data-bm-prerender") ? n.getNamedItem("data-bm-prerender")
                      .value : n.getNamedItem("bm-prerender") ? n.getNamedItem("bm-prerender")
                      .value : "") === "false" && (r.prerender = !1), r.path ? this.setParams(r) : this.trigger("destroy")
          }, AnimationItem.prototype.includeLayers = function(e) {
              e.op > this.animationData.op && (this.animationData.op = e.op, this.totalFrames = Math.floor(e.op - this.animationData.ip));
              var t, r, n = this.animationData.layers,
                  i = n.length,
                  a = e.layers,
                  s = a.length;
              for (r = 0; r < s; r += 1)
                  for (t = 0; t < i;) {
                      if (n[t].id === a[r].id) {
                          n[t] = a[r];
                          break
                      }
                      t += 1
                  }
              if ((e.chars || e.fonts) && (this.renderer.globalData.fontManager.addChars(e.chars), this.renderer.globalData.fontManager.addFonts(e.fonts, this.renderer.globalData.defs)), e.assets)
                  for (i = e.assets.length, t = 0; t < i; t += 1) this.animationData.assets.push(e.assets[t]);
              this.animationData.__complete = !1, dataManager.completeAnimation(this.animationData, this.onSegmentComplete)
          }, AnimationItem.prototype.onSegmentComplete = function(e) {
              this.animationData = e;
              var t = getExpressionsPlugin();
              t && t.initExpressions(this), this.loadNextSegment()
          }, AnimationItem.prototype.loadNextSegment = function() {
              var e = this.animationData.segments;
              if (!e || e.length === 0 || !this.autoloadSegments) return this.trigger("data_ready"), void(this.timeCompleted = this.totalFrames);
              var t = e.shift();
              this.timeCompleted = t.time * this.frameRate;
              var r = this.path + this.fileName + "_" + this.segmentPos + ".json";
              this.segmentPos += 1, dataManager.loadData(r, this.includeLayers.bind(this), function() {
                  this.trigger("data_failed")
              }.bind(this))
          }, AnimationItem.prototype.loadSegments = function() {
              this.animationData.segments || (this.timeCompleted = this.totalFrames), this.loadNextSegment()
          }, AnimationItem.prototype.imagesLoaded = function() {
              this.trigger("loaded_images"), this.checkLoaded()
          }, AnimationItem.prototype.preloadImages = function() {
              this.imagePreloader.setAssetsPath(this.assetsPath), this.imagePreloader.setPath(this.path), this.imagePreloader.loadAssets(this.animationData.assets, this.imagesLoaded.bind(this))
          }, AnimationItem.prototype.configAnimation = function(e) {
              if (this.renderer) try {
                  this.animationData = e, this.initialSegment ? (this.totalFrames = Math.floor(this.initialSegment[1] - this.initialSegment[0]), this.firstFrame = Math.round(this.initialSegment[0])) : (this.totalFrames = Math.floor(this.animationData.op - this.animationData.ip), this.firstFrame = Math.round(this.animationData.ip)), this.renderer.configAnimation(e), e.assets || (e.assets = []), this.assets = this.animationData.assets, this.frameRate = this.animationData.fr, this.frameMult = this.animationData.fr / 1e3, this.renderer.searchExtraCompositions(e.assets), this.markers = markerParser(e.markers || []), this.trigger("config_ready"), this.preloadImages(), this.loadSegments(), this.updaFrameModifier(), this.waitForFontsLoaded(), this.isPaused && this.audioController.pause()
              } catch (t) {
                  this.triggerConfigError(t)
              }
          }, AnimationItem.prototype.waitForFontsLoaded = function() {
              this.renderer && (this.renderer.globalData.fontManager.isLoaded ? this.checkLoaded() : setTimeout(this.waitForFontsLoaded.bind(this), 20))
          }, AnimationItem.prototype.checkLoaded = function() {
              if (!this.isLoaded && this.renderer.globalData.fontManager.isLoaded && (this.imagePreloader.loadedImages() || this.renderer.rendererType !== "canvas") && this.imagePreloader.loadedFootages()) {
                  this.isLoaded = !0;
                  var e = getExpressionsPlugin();
                  e && e.initExpressions(this), this.renderer.initItems(), setTimeout(function() {
                      this.trigger("DOMLoaded")
                  }.bind(this), 0), this.gotoFrame(), this.autoplay && this.play()
              }
          }, AnimationItem.prototype.resize = function(e, t) {
              var r = typeof e == "number" ? e : void 0,
                  n = typeof t == "number" ? t : void 0;
              this.renderer.updateContainerSize(r, n)
          }, AnimationItem.prototype.setSubframe = function(e) {
              this.isSubframeEnabled = !!e
          }, AnimationItem.prototype.gotoFrame = function() {
              this.currentFrame = this.isSubframeEnabled ? this.currentRawFrame : ~~this.currentRawFrame, this.timeCompleted !== this.totalFrames && this.currentFrame > this.timeCompleted && (this.currentFrame = this.timeCompleted), this.trigger("enterFrame"), this.renderFrame(), this.trigger("drawnFrame")
          }, AnimationItem.prototype.renderFrame = function() {
              if (this.isLoaded !== !1 && this.renderer) try {
                  this.expressionsPlugin && this.expressionsPlugin.resetFrame(), this.renderer.renderFrame(this.currentFrame + this.firstFrame)
              } catch (e) {
                  this.triggerRenderFrameError(e)
              }
          }, AnimationItem.prototype.play = function(e) {
              e && this.name !== e || this.isPaused === !0 && (this.isPaused = !1, this.trigger("_play"), this.audioController.resume(), this._idle && (this._idle = !1, this.trigger("_active")))
          }, AnimationItem.prototype.pause = function(e) {
              e && this.name !== e || this.isPaused === !1 && (this.isPaused = !0, this.trigger("_pause"), this._idle = !0, this.trigger("_idle"), this.audioController.pause())
          }, AnimationItem.prototype.togglePause = function(e) {
              e && this.name !== e || (this.isPaused === !0 ? this.play() : this.pause())
          }, AnimationItem.prototype.stop = function(e) {
              e && this.name !== e || (this.pause(), this.playCount = 0, this._completedLoop = !1, this.setCurrentRawFrameValue(0))
          }, AnimationItem.prototype.getMarkerData = function(e) {
              for (var t, r = 0; r < this.markers.length; r += 1)
                  if ((t = this.markers[r])
                      .payload && t.payload.name === e) return t;
              return null
          }, AnimationItem.prototype.goToAndStop = function(e, t, r) {
              if (!r || this.name === r) {
                  var n = Number(e);
                  if (isNaN(n)) {
                      var i = this.getMarkerData(e);
                      i && this.goToAndStop(i.time, !0)
                  } else t ? this.setCurrentRawFrameValue(e) : this.setCurrentRawFrameValue(e * this.frameModifier);
                  this.pause()
              }
          }, AnimationItem.prototype.goToAndPlay = function(e, t, r) {
              if (!r || this.name === r) {
                  var n = Number(e);
                  if (isNaN(n)) {
                      var i = this.getMarkerData(e);
                      i && (i.duration ? this.playSegments([i.time, i.time + i.duration], !0) : this.goToAndStop(i.time, !0))
                  } else this.goToAndStop(n, t, r);
                  this.play()
              }
          }, AnimationItem.prototype.advanceTime = function(e) {
              if (this.isPaused !== !0 && this.isLoaded !== !1) {
                  var t = this.currentRawFrame + e * this.frameModifier,
                      r = !1;
                  t >= this.totalFrames - 1 && this.frameModifier > 0 ? this.loop && this.playCount !== this.loop ? t >= this.totalFrames ? (this.playCount += 1, this.checkSegments(t % this.totalFrames) || (this.setCurrentRawFrameValue(t % this.totalFrames), this._completedLoop = !0, this.trigger("loopComplete"))) : this.setCurrentRawFrameValue(t) : this.checkSegments(t > this.totalFrames ? t % this.totalFrames : 0) || (r = !0, t = this.totalFrames - 1) : t < 0 ? this.checkSegments(t % this.totalFrames) || (!this.loop || this.playCount-- <= 0 && this.loop !== !0 ? (r = !0, t = 0) : (this.setCurrentRawFrameValue(this.totalFrames + t % this.totalFrames), this._completedLoop ? this.trigger("loopComplete") : this._completedLoop = !0)) : this.setCurrentRawFrameValue(t), r && (this.setCurrentRawFrameValue(t), this.pause(), this.trigger("complete"))
              }
          }, AnimationItem.prototype.adjustSegment = function(e, t) {
              this.playCount = 0, e[1] < e[0] ? (this.frameModifier > 0 && (this.playSpeed < 0 ? this.setSpeed(-this.playSpeed) : this.setDirection(-1)), this.totalFrames = e[0] - e[1], this.timeCompleted = this.totalFrames, this.firstFrame = e[1], this.setCurrentRawFrameValue(this.totalFrames - .001 - t)) : e[1] > e[0] && (this.frameModifier < 0 && (this.playSpeed < 0 ? this.setSpeed(-this.playSpeed) : this.setDirection(1)), this.totalFrames = e[1] - e[0], this.timeCompleted = this.totalFrames, this.firstFrame = e[0], this.setCurrentRawFrameValue(.001 + t)), this.trigger("segmentStart")
          }, AnimationItem.prototype.setSegment = function(e, t) {
              var r = -1;
              this.isPaused && (this.currentRawFrame + this.firstFrame < e ? r = e : this.currentRawFrame + this.firstFrame > t && (r = t - e)), this.firstFrame = e, this.totalFrames = t - e, this.timeCompleted = this.totalFrames, r !== -1 && this.goToAndStop(r, !0)
          }, AnimationItem.prototype.playSegments = function(e, t) {
              if (t && (this.segments.length = 0), _typeof$4(e[0]) === "object") {
                  var r, n = e.length;
                  for (r = 0; r < n; r += 1) this.segments.push(e[r])
              } else this.segments.push(e);
              this.segments.length && t && this.adjustSegment(this.segments.shift(), 0), this.isPaused && this.play()
          }, AnimationItem.prototype.resetSegments = function(e) {
              this.segments.length = 0, this.segments.push([this.animationData.ip, this.animationData.op]), e && this.checkSegments(0)
          }, AnimationItem.prototype.checkSegments = function(e) {
              return !!this.segments.length && (this.adjustSegment(this.segments.shift(), e), !0)
          }, AnimationItem.prototype.destroy = function(e) {
              e && this.name !== e || !this.renderer || (this.renderer.destroy(), this.imagePreloader.destroy(), this.trigger("destroy"), this._cbs = null, this.onEnterFrame = null, this.onLoopComplete = null, this.onComplete = null, this.onSegmentStart = null, this.onDestroy = null, this.renderer = null, this.expressionsPlugin = null, this.imagePreloader = null, this.projectInterface = null)
          }, AnimationItem.prototype.setCurrentRawFrameValue = function(e) {
              this.currentRawFrame = e, this.gotoFrame()
          }, AnimationItem.prototype.setSpeed = function(e) {
              this.playSpeed = e, this.updaFrameModifier()
          }, AnimationItem.prototype.setDirection = function(e) {
              this.playDirection = e < 0 ? -1 : 1, this.updaFrameModifier()
          }, AnimationItem.prototype.setLoop = function(e) {
              this.loop = e
          }, AnimationItem.prototype.setVolume = function(e, t) {
              t && this.name !== t || this.audioController.setVolume(e)
          }, AnimationItem.prototype.getVolume = function() {
              return this.audioController.getVolume()
          }, AnimationItem.prototype.mute = function(e) {
              e && this.name !== e || this.audioController.mute()
          }, AnimationItem.prototype.unmute = function(e) {
              e && this.name !== e || this.audioController.unmute()
          }, AnimationItem.prototype.updaFrameModifier = function() {
              this.frameModifier = this.frameMult * this.playSpeed * this.playDirection, this.audioController.setRate(this.playSpeed * this.playDirection)
          }, AnimationItem.prototype.getPath = function() {
              return this.path
          }, AnimationItem.prototype.getAssetsPath = function(e) {
              var t = "";
              if (e.e) t = e.p;
              else if (this.assetsPath) {
                  var r = e.p;
                  r.indexOf("images/") !== -1 && (r = r.split("/")[1]), t = this.assetsPath + r
              } else t = this.path, t += e.u ? e.u : "", t += e.p;
              return t
          }, AnimationItem.prototype.getAssetData = function(e) {
              for (var t = 0, r = this.assets.length; t < r;) {
                  if (e === this.assets[t].id) return this.assets[t];
                  t += 1
              }
              return null
          }, AnimationItem.prototype.hide = function() {
              this.renderer.hide()
          }, AnimationItem.prototype.show = function() {
              this.renderer.show()
          }, AnimationItem.prototype.getDuration = function(e) {
              return e ? this.totalFrames : this.totalFrames / this.frameRate
          }, AnimationItem.prototype.updateDocumentData = function(e, t, r) {
              try {
                  this.renderer.getElementByPath(e)
                      .updateDocumentData(t, r)
              } catch {}
          }, AnimationItem.prototype.trigger = function(e) {
              if (this._cbs && this._cbs[e]) switch (e) {
                  case "enterFrame":
                      this.triggerEvent(e, new BMEnterFrameEvent(e, this.currentFrame, this.totalFrames, this.frameModifier));
                      break;
                  case "drawnFrame":
                      this.drawnFrameEvent.currentTime = this.currentFrame, this.drawnFrameEvent.totalTime = this.totalFrames, this.drawnFrameEvent.direction = this.frameModifier, this.triggerEvent(e, this.drawnFrameEvent);
                      break;
                  case "loopComplete":
                      this.triggerEvent(e, new BMCompleteLoopEvent(e, this.loop, this.playCount, this.frameMult));
                      break;
                  case "complete":
                      this.triggerEvent(e, new BMCompleteEvent(e, this.frameMult));
                      break;
                  case "segmentStart":
                      this.triggerEvent(e, new BMSegmentStartEvent(e, this.firstFrame, this.totalFrames));
                      break;
                  case "destroy":
                      this.triggerEvent(e, new BMDestroyEvent(e, this));
                      break;
                  default:
                      this.triggerEvent(e)
              }
              e === "enterFrame" && this.onEnterFrame && this.onEnterFrame.call(this, new BMEnterFrameEvent(e, this.currentFrame, this.totalFrames, this.frameMult)), e === "loopComplete" && this.onLoopComplete && this.onLoopComplete.call(this, new BMCompleteLoopEvent(e, this.loop, this.playCount, this.frameMult)), e === "complete" && this.onComplete && this.onComplete.call(this, new BMCompleteEvent(e, this.frameMult)), e === "segmentStart" && this.onSegmentStart && this.onSegmentStart.call(this, new BMSegmentStartEvent(e, this.firstFrame, this.totalFrames)), e === "destroy" && this.onDestroy && this.onDestroy.call(this, new BMDestroyEvent(e, this))
          }, AnimationItem.prototype.triggerRenderFrameError = function(e) {
              var t = new BMRenderFrameErrorEvent(e, this.currentFrame);
              this.triggerEvent("error", t), this.onError && this.onError.call(this, t)
          }, AnimationItem.prototype.triggerConfigError = function(e) {
              var t = new BMConfigErrorEvent(e, this.currentFrame);
              this.triggerEvent("error", t), this.onError && this.onError.call(this, t)
          };
          var animationManager = function() {
                  var e = {},
                      t = [],
                      r = 0,
                      n = 0,
                      i = 0,
                      a = !0,
                      s = !1;

                  function o(m) {
                      for (var h = 0, g = m.target; h < n;) t[h].animation === g && (t.splice(h, 1), h -= 1, n -= 1, g.isPaused || u()), h += 1
                  }

                  function l(m, h) {
                      if (!m) return null;
                      for (var g = 0; g < n;) {
                          if (t[g].elem === m && t[g].elem !== null) return t[g].animation;
                          g += 1
                      }
                      var y = new AnimationItem;
                      return c(y, m), y.setData(m, h), y
                  }

                  function f() {
                      i += 1, p()
                  }

                  function u() {
                      i -= 1
                  }

                  function c(m, h) {
                      m.addEventListener("destroy", o), m.addEventListener("_active", f), m.addEventListener("_idle", u), t.push({
                          elem: h,
                          animation: m
                      }), n += 1
                  }

                  function v(m) {
                      var h, g = m - r;
                      for (h = 0; h < n; h += 1) t[h].animation.advanceTime(g);
                      r = m, i && !s ? window.requestAnimationFrame(v) : a = !0
                  }

                  function d(m) {
                      r = m, window.requestAnimationFrame(v)
                  }

                  function p() {
                      !s && i && a && (window.requestAnimationFrame(d), a = !1)
                  }
                  return e.registerAnimation = l, e.loadAnimation = function(m) {
                      var h = new AnimationItem;
                      return c(h, null), h.setParams(m), h
                  }, e.setSpeed = function(m, h) {
                      var g;
                      for (g = 0; g < n; g += 1) t[g].animation.setSpeed(m, h)
                  }, e.setDirection = function(m, h) {
                      var g;
                      for (g = 0; g < n; g += 1) t[g].animation.setDirection(m, h)
                  }, e.play = function(m) {
                      var h;
                      for (h = 0; h < n; h += 1) t[h].animation.play(m)
                  }, e.pause = function(m) {
                      var h;
                      for (h = 0; h < n; h += 1) t[h].animation.pause(m)
                  }, e.stop = function(m) {
                      var h;
                      for (h = 0; h < n; h += 1) t[h].animation.stop(m)
                  }, e.togglePause = function(m) {
                      var h;
                      for (h = 0; h < n; h += 1) t[h].animation.togglePause(m)
                  }, e.searchAnimations = function(m, h, g) {
                      var y, b = [].concat([].slice.call(document.getElementsByClassName("lottie")), [].slice.call(document.getElementsByClassName("bodymovin"))),
                          _ = b.length;
                      for (y = 0; y < _; y += 1) g && b[y].setAttribute("data-bm-type", g), l(b[y], m);
                      if (h && _ === 0) {
                          g || (g = "svg");
                          var I = document.getElementsByTagName("body")[0];
                          I.innerText = "";
                          var C = createTag("div");
                          C.style.width = "100%", C.style.height = "100%", C.setAttribute("data-bm-type", g), I.appendChild(C), l(C, m)
                      }
                  }, e.resize = function() {
                      var m;
                      for (m = 0; m < n; m += 1) t[m].animation.resize()
                  }, e.goToAndStop = function(m, h, g) {
                      var y;
                      for (y = 0; y < n; y += 1) t[y].animation.goToAndStop(m, h, g)
                  }, e.destroy = function(m) {
                      var h;
                      for (h = n - 1; h >= 0; h -= 1) t[h].animation.destroy(m)
                  }, e.freeze = function() {
                      s = !0
                  }, e.unfreeze = function() {
                      s = !1, p()
                  }, e.setVolume = function(m, h) {
                      var g;
                      for (g = 0; g < n; g += 1) t[g].animation.setVolume(m, h)
                  }, e.mute = function(m) {
                      var h;
                      for (h = 0; h < n; h += 1) t[h].animation.mute(m)
                  }, e.unmute = function(m) {
                      var h;
                      for (h = 0; h < n; h += 1) t[h].animation.unmute(m)
                  }, e.getRegisteredAnimations = function() {
                      var m, h = t.length,
                          g = [];
                      for (m = 0; m < h; m += 1) g.push(t[m].animation);
                      return g
                  }, e
              }(),
              BezierFactory = function() {
                  var e = {
                          getBezierEasing: function(u, c, v, d, p) {
                              var m = p || ("bez_" + u + "_" + c + "_" + v + "_" + d)
                                  .replace(/\./g, "p");
                              if (t[m]) return t[m];
                              var h = new f([u, c, v, d]);
                              return t[m] = h, h
                          }
                      },
                      t = {},
                      r = .1,
                      n = typeof Float32Array == "function";

                  function i(u, c) {
                      return 1 - 3 * c + 3 * u
                  }

                  function a(u, c) {
                      return 3 * c - 6 * u
                  }

                  function s(u) {
                      return 3 * u
                  }

                  function o(u, c, v) {
                      return ((i(c, v) * u + a(c, v)) * u + s(c)) * u
                  }

                  function l(u, c, v) {
                      return 3 * i(c, v) * u * u + 2 * a(c, v) * u + s(c)
                  }

                  function f(u) {
                      this._p = u, this._mSampleValues = n ? new Float32Array(11) : new Array(11), this._precomputed = !1, this.get = this.get.bind(this)
                  }
                  return f.prototype = {
                      get: function(u) {
                          var c = this._p[0],
                              v = this._p[1],
                              d = this._p[2],
                              p = this._p[3];
                          return this._precomputed || this._precompute(), c === v && d === p ? u : u === 0 ? 0 : u === 1 ? 1 : o(this._getTForX(u), v, p)
                      },
                      _precompute: function() {
                          var u = this._p[0],
                              c = this._p[1],
                              v = this._p[2],
                              d = this._p[3];
                          this._precomputed = !0, u === c && v === d || this._calcSampleValues()
                      },
                      _calcSampleValues: function() {
                          for (var u = this._p[0], c = this._p[2], v = 0; v < 11; ++v) this._mSampleValues[v] = o(v * r, u, c)
                      },
                      _getTForX: function(u) {
                          for (var c = this._p[0], v = this._p[2], d = this._mSampleValues, p = 0, m = 1; m !== 10 && d[m] <= u; ++m) p += r;
                          var h = p + (u - d[--m]) / (d[m + 1] - d[m]) * r,
                              g = l(h, c, v);
                          return g >= .001 ? function(y, b, _, I) {
                              for (var C = 0; C < 4; ++C) {
                                  var x = l(b, _, I);
                                  if (x === 0) return b;
                                  b -= (o(b, _, I) - y) / x
                              }
                              return b
                          }(u, h, c, v) : g === 0 ? h : function(y, b, _, I, C) {
                              var x, O, L = 0;
                              do(x = o(O = b + (_ - b) / 2, I, C) - y) > 0 ? _ = O : b = O; while (Math.abs(x) > 1e-7 && ++L < 10);
                              return O
                          }(u, p, p + r, c, v)
                      }
                  }, e
              }(),
              pooling = {
                  double: function(e) {
                      return e.concat(createSizedArray(e.length))
                  }
              },
              poolFactory = function(e, t, r) {
                  var n = 0,
                      i = e,
                      a = createSizedArray(i);
                  return {
                      newElement: function() {
                          return n ? a[n -= 1] : t()
                      },
                      release: function(s) {
                          n === i && (a = pooling.double(a), i *= 2), r && r(s), a[n] = s, n += 1
                      }
                  }
              },
              bezierLengthPool = poolFactory(8, function() {
                  return {
                      addedLength: 0,
                      percents: createTypedArray("float32", getDefaultCurveSegments()),
                      lengths: createTypedArray("float32", getDefaultCurveSegments())
                  }
              }),
              segmentsLengthPool = poolFactory(8, function() {
                  return {
                      lengths: [],
                      totalLength: 0
                  }
              }, function(e) {
                  var t, r = e.lengths.length;
                  for (t = 0; t < r; t += 1) bezierLengthPool.release(e.lengths[t]);
                  e.lengths.length = 0
              });

          function bezFunction() {
              var e = Math;

              function t(f, u, c, v, d, p) {
                  var m = f * v + u * d + c * p - d * v - p * f - c * u;
                  return m > -.001 && m < .001
              }
              var r = function(f, u, c, v) {
                  var d, p, m, h, g, y, b = getDefaultCurveSegments(),
                      _ = 0,
                      I = [],
                      C = [],
                      x = bezierLengthPool.newElement();
                  for (m = c.length, d = 0; d < b; d += 1) {
                      for (g = d / (b - 1), y = 0, p = 0; p < m; p += 1) h = bmPow(1 - g, 3) * f[p] + 3 * bmPow(1 - g, 2) * g * c[p] + 3 * (1 - g) * bmPow(g, 2) * v[p] + bmPow(g, 3) * u[p], I[p] = h, C[p] !== null && (y += bmPow(I[p] - C[p], 2)), C[p] = I[p];
                      y && (_ += y = bmSqrt(y)), x.percents[d] = g, x.lengths[d] = _
                  }
                  return x.addedLength = _, x
              };

              function n(f) {
                  this.segmentLength = 0, this.points = new Array(f)
              }

              function i(f, u) {
                  this.partialLength = f, this.point = u
              }
              var a, s = (a = {}, function(f, u, c, v) {
                  var d = (f[0] + "_" + f[1] + "_" + u[0] + "_" + u[1] + "_" + c[0] + "_" + c[1] + "_" + v[0] + "_" + v[1])
                      .replace(/\./g, "p");
                  if (!a[d]) {
                      var p, m, h, g, y, b, _, I = getDefaultCurveSegments(),
                          C = 0,
                          x = null;
                      f.length === 2 && (f[0] !== u[0] || f[1] !== u[1]) && t(f[0], f[1], u[0], u[1], f[0] + c[0], f[1] + c[1]) && t(f[0], f[1], u[0], u[1], u[0] + v[0], u[1] + v[1]) && (I = 2);
                      var O = new n(I);
                      for (h = c.length, p = 0; p < I; p += 1) {
                          for (_ = createSizedArray(h), y = p / (I - 1), b = 0, m = 0; m < h; m += 1) g = bmPow(1 - y, 3) * f[m] + 3 * bmPow(1 - y, 2) * y * (f[m] + c[m]) + 3 * (1 - y) * bmPow(y, 2) * (u[m] + v[m]) + bmPow(y, 3) * u[m], _[m] = g, x !== null && (b += bmPow(_[m] - x[m], 2));
                          C += b = bmSqrt(b), O.points[p] = new i(b, _), x = _
                      }
                      O.segmentLength = C, a[d] = O
                  }
                  return a[d]
              });

              function o(f, u) {
                  var c = u.percents,
                      v = u.lengths,
                      d = c.length,
                      p = bmFloor((d - 1) * f),
                      m = f * u.addedLength,
                      h = 0;
                  if (p === d - 1 || p === 0 || m === v[p]) return c[p];
                  for (var g = v[p] > m ? -1 : 1, y = !0; y;)
                      if (v[p] <= m && v[p + 1] > m ? (h = (m - v[p]) / (v[p + 1] - v[p]), y = !1) : p += g, p < 0 || p >= d - 1) {
                          if (p === d - 1) return c[p];
                          y = !1
                      } return c[p] + (c[p + 1] - c[p]) * h
              }
              var l = createTypedArray("float32", 8);
              return {
                  getSegmentsLength: function(f) {
                      var u, c = segmentsLengthPool.newElement(),
                          v = f.c,
                          d = f.v,
                          p = f.o,
                          m = f.i,
                          h = f._length,
                          g = c.lengths,
                          y = 0;
                      for (u = 0; u < h - 1; u += 1) g[u] = r(d[u], d[u + 1], p[u], m[u + 1]), y += g[u].addedLength;
                      return v && h && (g[u] = r(d[u], d[0], p[u], m[0]), y += g[u].addedLength), c.totalLength = y, c
                  },
                  getNewSegment: function(f, u, c, v, d, p, m) {
                      d < 0 ? d = 0 : d > 1 && (d = 1);
                      var h, g = o(d, m),
                          y = o(p = p > 1 ? 1 : p, m),
                          b = f.length,
                          _ = 1 - g,
                          I = 1 - y,
                          C = _ * _ * _,
                          x = g * _ * _ * 3,
                          O = g * g * _ * 3,
                          L = g * g * g,
                          D = _ * _ * I,
                          A = g * _ * I + _ * g * I + _ * _ * y,
                          q = g * g * I + _ * g * y + g * _ * y,
                          w = g * g * y,
                          F = _ * I * I,
                          k = g * I * I + _ * y * I + _ * I * y,
                          U = g * y * I + _ * y * y + g * I * y,
                          W = g * y * y,
                          S = I * I * I,
                          R = y * I * I + I * y * I + I * I * y,
                          V = y * y * I + I * y * y + y * I * y,
                          P = y * y * y;
                      for (h = 0; h < b; h += 1) l[4 * h] = e.round(1e3 * (C * f[h] + x * c[h] + O * v[h] + L * u[h])) / 1e3, l[4 * h + 1] = e.round(1e3 * (D * f[h] + A * c[h] + q * v[h] + w * u[h])) / 1e3, l[4 * h + 2] = e.round(1e3 * (F * f[h] + k * c[h] + U * v[h] + W * u[h])) / 1e3, l[4 * h + 3] = e.round(1e3 * (S * f[h] + R * c[h] + V * v[h] + P * u[h])) / 1e3;
                      return l
                  },
                  getPointInSegment: function(f, u, c, v, d, p) {
                      var m = o(d, p),
                          h = 1 - m;
                      return [e.round(1e3 * (h * h * h * f[0] + (m * h * h + h * m * h + h * h * m) * c[0] + (m * m * h + h * m * m + m * h * m) * v[0] + m * m * m * u[0])) / 1e3, e.round(1e3 * (h * h * h * f[1] + (m * h * h + h * m * h + h * h * m) * c[1] + (m * m * h + h * m * m + m * h * m) * v[1] + m * m * m * u[1])) / 1e3]
                  },
                  buildBezierData: s,
                  pointOnLine2D: t,
                  pointOnLine3D: function(f, u, c, v, d, p, m, h, g) {
                      if (c === 0 && p === 0 && g === 0) return t(f, u, v, d, m, h);
                      var y, b = e.sqrt(e.pow(v - f, 2) + e.pow(d - u, 2) + e.pow(p - c, 2)),
                          _ = e.sqrt(e.pow(m - f, 2) + e.pow(h - u, 2) + e.pow(g - c, 2)),
                          I = e.sqrt(e.pow(m - v, 2) + e.pow(h - d, 2) + e.pow(g - p, 2));
                      return (y = b > _ ? b > I ? b - _ - I : I - _ - b : I > _ ? I - _ - b : _ - b - I) > -1e-4 && y < 1e-4
                  }
              }
          }
          var bez = bezFunction(),
              initFrame = initialDefaultFrame,
              mathAbs = Math.abs;

          function interpolateValue(e, t) {
              var r, n = this.offsetTime;
              this.propType === "multidimensional" && (r = createTypedArray("float32", this.pv.length));
              for (var i, a, s, o, l, f, u, c, v, d = t.lastIndex, p = d, m = this.keyframes.length - 1, h = !0; h;) {
                  if (i = this.keyframes[p], a = this.keyframes[p + 1], p === m - 1 && e >= a.t - n) {
                      i.h && (i = a), d = 0;
                      break
                  }
                  if (a.t - n > e) {
                      d = p;
                      break
                  }
                  p < m - 1 ? p += 1 : (d = 0, h = !1)
              }
              s = this.keyframesMetadata[p] || {};
              var g, y = a.t - n,
                  b = i.t - n;
              if (i.to) {
                  s.bezierData || (s.bezierData = bez.buildBezierData(i.s, a.s || i.e, i.to, i.ti));
                  var _ = s.bezierData;
                  if (e >= y || e < b) {
                      var I = e >= y ? _.points.length - 1 : 0;
                      for (l = _.points[I].point.length, o = 0; o < l; o += 1) r[o] = _.points[I].point[o]
                  } else {
                      s.__fnct ? v = s.__fnct : (v = BezierFactory.getBezierEasing(i.o.x, i.o.y, i.i.x, i.i.y, i.n)
                          .get, s.__fnct = v), f = v((e - b) / (y - b));
                      var C, x = _.segmentLength * f,
                          O = t.lastFrame < e && t._lastKeyframeIndex === p ? t._lastAddedLength : 0;
                      for (c = t.lastFrame < e && t._lastKeyframeIndex === p ? t._lastPoint : 0, h = !0, u = _.points.length; h;) {
                          if (O += _.points[c].partialLength, x === 0 || f === 0 || c === _.points.length - 1) {
                              for (l = _.points[c].point.length, o = 0; o < l; o += 1) r[o] = _.points[c].point[o];
                              break
                          }
                          if (x >= O && x < O + _.points[c + 1].partialLength) {
                              for (C = (x - O) / _.points[c + 1].partialLength, l = _.points[c].point.length, o = 0; o < l; o += 1) r[o] = _.points[c].point[o] + (_.points[c + 1].point[o] - _.points[c].point[o]) * C;
                              break
                          }
                          c < u - 1 ? c += 1 : h = !1
                      }
                      t._lastPoint = c, t._lastAddedLength = O - _.points[c].partialLength, t._lastKeyframeIndex = p
                  }
              } else {
                  var L, D, A, q, w;
                  if (m = i.s.length, g = a.s || i.e, this.sh && i.h !== 1) e >= y ? (r[0] = g[0], r[1] = g[1], r[2] = g[2]) : e <= b ? (r[0] = i.s[0], r[1] = i.s[1], r[2] = i.s[2]) : quaternionToEuler(r, slerp(createQuaternion(i.s), createQuaternion(g), (e - b) / (y - b)));
                  else
                      for (p = 0; p < m; p += 1) i.h !== 1 && (e >= y ? f = 1 : e < b ? f = 0 : (i.o.x.constructor === Array ? (s.__fnct || (s.__fnct = []), s.__fnct[p] ? v = s.__fnct[p] : (L = i.o.x[p] === void 0 ? i.o.x[0] : i.o.x[p], D = i.o.y[p] === void 0 ? i.o.y[0] : i.o.y[p], A = i.i.x[p] === void 0 ? i.i.x[0] : i.i.x[p], q = i.i.y[p] === void 0 ? i.i.y[0] : i.i.y[p], v = BezierFactory.getBezierEasing(L, D, A, q)
                          .get, s.__fnct[p] = v)) : s.__fnct ? v = s.__fnct : (L = i.o.x, D = i.o.y, A = i.i.x, q = i.i.y, v = BezierFactory.getBezierEasing(L, D, A, q)
                          .get, i.keyframeMetadata = v), f = v((e - b) / (y - b)))), g = a.s || i.e, w = i.h === 1 ? i.s[p] : i.s[p] + (g[p] - i.s[p]) * f, this.propType === "multidimensional" ? r[p] = w : r = w
              }
              return t.lastIndex = d, r
          }

          function slerp(e, t, r) {
              var n, i, a, s, o, l = [],
                  f = e[0],
                  u = e[1],
                  c = e[2],
                  v = e[3],
                  d = t[0],
                  p = t[1],
                  m = t[2],
                  h = t[3];
              return (i = f * d + u * p + c * m + v * h) < 0 && (i = -i, d = -d, p = -p, m = -m, h = -h), 1 - i > 1e-6 ? (n = Math.acos(i), a = Math.sin(n), s = Math.sin((1 - r) * n) / a, o = Math.sin(r * n) / a) : (s = 1 - r, o = r), l[0] = s * f + o * d, l[1] = s * u + o * p, l[2] = s * c + o * m, l[3] = s * v + o * h, l
          }

          function quaternionToEuler(e, t) {
              var r = t[0],
                  n = t[1],
                  i = t[2],
                  a = t[3],
                  s = Math.atan2(2 * n * a - 2 * r * i, 1 - 2 * n * n - 2 * i * i),
                  o = Math.asin(2 * r * n + 2 * i * a),
                  l = Math.atan2(2 * r * a - 2 * n * i, 1 - 2 * r * r - 2 * i * i);
              e[0] = s / degToRads, e[1] = o / degToRads, e[2] = l / degToRads
          }

          function createQuaternion(e) {
              var t = e[0] * degToRads,
                  r = e[1] * degToRads,
                  n = e[2] * degToRads,
                  i = Math.cos(t / 2),
                  a = Math.cos(r / 2),
                  s = Math.cos(n / 2),
                  o = Math.sin(t / 2),
                  l = Math.sin(r / 2),
                  f = Math.sin(n / 2);
              return [o * l * s + i * a * f, o * a * s + i * l * f, i * l * s - o * a * f, i * a * s - o * l * f]
          }

          function getValueAtCurrentTime() {
              var e = this.comp.renderedFrame - this.offsetTime,
                  t = this.keyframes[0].t - this.offsetTime,
                  r = this.keyframes[this.keyframes.length - 1].t - this.offsetTime;
              if (!(e === this._caching.lastFrame || this._caching.lastFrame !== initFrame && (this._caching.lastFrame >= r && e >= r || this._caching.lastFrame < t && e < t))) {
                  this._caching.lastFrame >= e && (this._caching._lastKeyframeIndex = -1, this._caching.lastIndex = 0);
                  var n = this.interpolateValue(e, this._caching);
                  this.pv = n
              }
              return this._caching.lastFrame = e, this.pv
          }

          function setVValue(e) {
              var t;
              if (this.propType === "unidimensional") t = e * this.mult, mathAbs(this.v - t) > 1e-5 && (this.v = t, this._mdf = !0);
              else
                  for (var r = 0, n = this.v.length; r < n;) t = e[r] * this.mult, mathAbs(this.v[r] - t) > 1e-5 && (this.v[r] = t, this._mdf = !0), r += 1
          }

          function processEffectsSequence() {
              if (this.elem.globalData.frameId !== this.frameId && this.effectsSequence.length)
                  if (this.lock) this.setVValue(this.pv);
                  else {
                      var e;
                      this.lock = !0, this._mdf = this._isFirstFrame;
                      var t = this.effectsSequence.length,
                          r = this.kf ? this.pv : this.data.k;
                      for (e = 0; e < t; e += 1) r = this.effectsSequence[e](r);
                      this.setVValue(r), this._isFirstFrame = !1, this.lock = !1, this.frameId = this.elem.globalData.frameId
                  }
          }

          function addEffect(e) {
              this.effectsSequence.push(e), this.container.addDynamicProperty(this)
          }

          function ValueProperty(e, t, r, n) {
              this.propType = "unidimensional", this.mult = r || 1, this.data = t, this.v = r ? t.k * r : t.k, this.pv = t.k, this._mdf = !1, this.elem = e, this.container = n, this.comp = e.comp, this.k = !1, this.kf = !1, this.vel = 0, this.effectsSequence = [], this._isFirstFrame = !0, this.getValue = processEffectsSequence, this.setVValue = setVValue, this.addEffect = addEffect
          }

          function MultiDimensionalProperty(e, t, r, n) {
              var i;
              this.propType = "multidimensional", this.mult = r || 1, this.data = t, this._mdf = !1, this.elem = e, this.container = n, this.comp = e.comp, this.k = !1, this.kf = !1, this.frameId = -1;
              var a = t.k.length;
              for (this.v = createTypedArray("float32", a), this.pv = createTypedArray("float32", a), this.vel = createTypedArray("float32", a), i = 0; i < a; i += 1) this.v[i] = t.k[i] * this.mult, this.pv[i] = t.k[i];
              this._isFirstFrame = !0, this.effectsSequence = [], this.getValue = processEffectsSequence, this.setVValue = setVValue, this.addEffect = addEffect
          }

          function KeyframedValueProperty(e, t, r, n) {
              this.propType = "unidimensional", this.keyframes = t.k, this.keyframesMetadata = [], this.offsetTime = e.data.st, this.frameId = -1, this._caching = {
                  lastFrame: initFrame,
                  lastIndex: 0,
                  value: 0,
                  _lastKeyframeIndex: -1
              }, this.k = !0, this.kf = !0, this.data = t, this.mult = r || 1, this.elem = e, this.container = n, this.comp = e.comp, this.v = initFrame, this.pv = initFrame, this._isFirstFrame = !0, this.getValue = processEffectsSequence, this.setVValue = setVValue, this.interpolateValue = interpolateValue, this.effectsSequence = [getValueAtCurrentTime.bind(this)], this.addEffect = addEffect
          }

          function KeyframedMultidimensionalProperty(e, t, r, n) {
              var i;
              this.propType = "multidimensional";
              var a, s, o, l, f = t.k.length;
              for (i = 0; i < f - 1; i += 1) t.k[i].to && t.k[i].s && t.k[i + 1] && t.k[i + 1].s && (a = t.k[i].s, s = t.k[i + 1].s, o = t.k[i].to, l = t.k[i].ti, (a.length === 2 && (a[0] !== s[0] || a[1] !== s[1]) && bez.pointOnLine2D(a[0], a[1], s[0], s[1], a[0] + o[0], a[1] + o[1]) && bez.pointOnLine2D(a[0], a[1], s[0], s[1], s[0] + l[0], s[1] + l[1]) || a.length === 3 && (a[0] !== s[0] || a[1] !== s[1] || a[2] !== s[2]) && bez.pointOnLine3D(a[0], a[1], a[2], s[0], s[1], s[2], a[0] + o[0], a[1] + o[1], a[2] + o[2]) && bez.pointOnLine3D(a[0], a[1], a[2], s[0], s[1], s[2], s[0] + l[0], s[1] + l[1], s[2] + l[2])) && (t.k[i].to = null, t.k[i].ti = null), a[0] === s[0] && a[1] === s[1] && o[0] === 0 && o[1] === 0 && l[0] === 0 && l[1] === 0 && (a.length === 2 || a[2] === s[2] && o[2] === 0 && l[2] === 0) && (t.k[i].to = null, t.k[i].ti = null));
              this.effectsSequence = [getValueAtCurrentTime.bind(this)], this.data = t, this.keyframes = t.k, this.keyframesMetadata = [], this.offsetTime = e.data.st, this.k = !0, this.kf = !0, this._isFirstFrame = !0, this.mult = r || 1, this.elem = e, this.container = n, this.comp = e.comp, this.getValue = processEffectsSequence, this.setVValue = setVValue, this.interpolateValue = interpolateValue, this.frameId = -1;
              var u = t.k[0].s.length;
              for (this.v = createTypedArray("float32", u), this.pv = createTypedArray("float32", u), i = 0; i < u; i += 1) this.v[i] = initFrame, this.pv[i] = initFrame;
              this._caching = {
                  lastFrame: initFrame,
                  lastIndex: 0,
                  value: createTypedArray("float32", u)
              }, this.addEffect = addEffect
          }
          var PropertyFactory = {
              getProp: function(e, t, r, n, i) {
                  var a;
                  if (t.sid && (t = e.globalData.slotManager.getProp(t)), t.k.length)
                      if (typeof t.k[0] == "number") a = new MultiDimensionalProperty(e, t, n, i);
                      else switch (r) {
                          case 0:
                              a = new KeyframedValueProperty(e, t, n, i);
                              break;
                          case 1:
                              a = new KeyframedMultidimensionalProperty(e, t, n, i)
                      } else a = new ValueProperty(e, t, n, i);
                  return a.effectsSequence.length && i.addDynamicProperty(a), a
              }
          };

          function DynamicPropertyContainer() {}
          DynamicPropertyContainer.prototype = {
              addDynamicProperty: function(e) {
                  this.dynamicProperties.indexOf(e) === -1 && (this.dynamicProperties.push(e), this.container.addDynamicProperty(this), this._isAnimated = !0)
              },
              iterateDynamicProperties: function() {
                  var e;
                  this._mdf = !1;
                  var t = this.dynamicProperties.length;
                  for (e = 0; e < t; e += 1) this.dynamicProperties[e].getValue(), this.dynamicProperties[e]._mdf && (this._mdf = !0)
              },
              initDynamicPropertyContainer: function(e) {
                  this.container = e, this.dynamicProperties = [], this._mdf = !1, this._isAnimated = !1
              }
          };
          var pointPool = poolFactory(8, function() {
              return createTypedArray("float32", 2)
          });

          function ShapePath() {
              this.c = !1, this._length = 0, this._maxLength = 8, this.v = createSizedArray(this._maxLength), this.o = createSizedArray(this._maxLength), this.i = createSizedArray(this._maxLength)
          }
          ShapePath.prototype.setPathData = function(e, t) {
              this.c = e, this.setLength(t);
              for (var r = 0; r < t;) this.v[r] = pointPool.newElement(), this.o[r] = pointPool.newElement(), this.i[r] = pointPool.newElement(), r += 1
          }, ShapePath.prototype.setLength = function(e) {
              for (; this._maxLength < e;) this.doubleArrayLength();
              this._length = e
          }, ShapePath.prototype.doubleArrayLength = function() {
              this.v = this.v.concat(createSizedArray(this._maxLength)), this.i = this.i.concat(createSizedArray(this._maxLength)), this.o = this.o.concat(createSizedArray(this._maxLength)), this._maxLength *= 2
          }, ShapePath.prototype.setXYAt = function(e, t, r, n, i) {
              var a;
              switch (this._length = Math.max(this._length, n + 1), this._length >= this._maxLength && this.doubleArrayLength(), r) {
                  case "v":
                      a = this.v;
                      break;
                  case "i":
                      a = this.i;
                      break;
                  case "o":
                      a = this.o;
                      break;
                  default:
                      a = []
              }(!a[n] || a[n] && !i) && (a[n] = pointPool.newElement()), a[n][0] = e, a[n][1] = t
          }, ShapePath.prototype.setTripleAt = function(e, t, r, n, i, a, s, o) {
              this.setXYAt(e, t, "v", s, o), this.setXYAt(r, n, "o", s, o), this.setXYAt(i, a, "i", s, o)
          }, ShapePath.prototype.reverse = function() {
              var e = new ShapePath;
              e.setPathData(this.c, this._length);
              var t = this.v,
                  r = this.o,
                  n = this.i,
                  i = 0;
              this.c && (e.setTripleAt(t[0][0], t[0][1], n[0][0], n[0][1], r[0][0], r[0][1], 0, !1), i = 1);
              var a, s = this._length - 1,
                  o = this._length;
              for (a = i; a < o; a += 1) e.setTripleAt(t[s][0], t[s][1], n[s][0], n[s][1], r[s][0], r[s][1], a, !1), s -= 1;
              return e
          }, ShapePath.prototype.length = function() {
              return this._length
          };
          var shapePool = (factory = poolFactory(4, function() {
                  return new ShapePath
              }, function(e) {
                  var t, r = e._length;
                  for (t = 0; t < r; t += 1) pointPool.release(e.v[t]), pointPool.release(e.i[t]), pointPool.release(e.o[t]), e.v[t] = null, e.i[t] = null, e.o[t] = null;
                  e._length = 0, e.c = !1
              }), factory.clone = function(e) {
                  var t, r = factory.newElement(),
                      n = e._length === void 0 ? e.v.length : e._length;
                  for (r.setLength(n), r.c = e.c, t = 0; t < n; t += 1) r.setTripleAt(e.v[t][0], e.v[t][1], e.o[t][0], e.o[t][1], e.i[t][0], e.i[t][1], t);
                  return r
              }, factory),
              factory;

          function ShapeCollection() {
              this._length = 0, this._maxLength = 4, this.shapes = createSizedArray(this._maxLength)
          }
          ShapeCollection.prototype.addShape = function(e) {
              this._length === this._maxLength && (this.shapes = this.shapes.concat(createSizedArray(this._maxLength)), this._maxLength *= 2), this.shapes[this._length] = e, this._length += 1
          }, ShapeCollection.prototype.releaseShapes = function() {
              var e;
              for (e = 0; e < this._length; e += 1) shapePool.release(this.shapes[e]);
              this._length = 0
          };
          var shapeCollectionPool = (ob = {
                  newShapeCollection: function() {
                      return _length ? pool[_length -= 1] : new ShapeCollection
                  },
                  release: function(e) {
                      var t, r = e._length;
                      for (t = 0; t < r; t += 1) shapePool.release(e.shapes[t]);
                      e._length = 0, _length === _maxLength && (pool = pooling.double(pool), _maxLength *= 2), pool[_length] = e, _length += 1
                  }
              }, _length = 0, _maxLength = 4, pool = createSizedArray(_maxLength), ob),
              ob, _length, _maxLength, pool, ShapePropertyFactory = function() {
                  var e = -999999;

                  function t(d, p, m) {
                      var h, g, y, b, _, I, C, x, O, L = m.lastIndex,
                          D = this.keyframes;
                      if (d < D[0].t - this.offsetTime) h = D[0].s[0], y = !0, L = 0;
                      else if (d >= D[D.length - 1].t - this.offsetTime) h = D[D.length - 1].s ? D[D.length - 1].s[0] : D[D.length - 2].e[0], y = !0;
                      else {
                          for (var A, q, w, F = L, k = D.length - 1, U = !0; U && (A = D[F], !((q = D[F + 1])
                                  .t - this.offsetTime > d));) F < k - 1 ? F += 1 : U = !1;
                          if (w = this.keyframesMetadata[F] || {}, L = F, !(y = A.h === 1)) {
                              if (d >= q.t - this.offsetTime) x = 1;
                              else if (d < A.t - this.offsetTime) x = 0;
                              else {
                                  var W;
                                  w.__fnct ? W = w.__fnct : (W = BezierFactory.getBezierEasing(A.o.x, A.o.y, A.i.x, A.i.y)
                                      .get, w.__fnct = W), x = W((d - (A.t - this.offsetTime)) / (q.t - this.offsetTime - (A.t - this.offsetTime)))
                              }
                              g = q.s ? q.s[0] : A.e[0]
                          }
                          h = A.s[0]
                      }
                      for (I = p._length, C = h.i[0].length, m.lastIndex = L, b = 0; b < I; b += 1)
                          for (_ = 0; _ < C; _ += 1) O = y ? h.i[b][_] : h.i[b][_] + (g.i[b][_] - h.i[b][_]) * x, p.i[b][_] = O, O = y ? h.o[b][_] : h.o[b][_] + (g.o[b][_] - h.o[b][_]) * x, p.o[b][_] = O, O = y ? h.v[b][_] : h.v[b][_] + (g.v[b][_] - h.v[b][_]) * x, p.v[b][_] = O
                  }

                  function r() {
                      var d = this.comp.renderedFrame - this.offsetTime,
                          p = this.keyframes[0].t - this.offsetTime,
                          m = this.keyframes[this.keyframes.length - 1].t - this.offsetTime,
                          h = this._caching.lastFrame;
                      return h !== e && (h < p && d < p || h > m && d > m) || (this._caching.lastIndex = h < d ? this._caching.lastIndex : 0, this.interpolateShape(d, this.pv, this._caching)), this._caching.lastFrame = d, this.pv
                  }

                  function n() {
                      this.paths = this.localShapeCollection
                  }

                  function i(d) {
                      (function(p, m) {
                          if (p._length !== m._length || p.c !== m.c) return !1;
                          var h, g = p._length;
                          for (h = 0; h < g; h += 1)
                              if (p.v[h][0] !== m.v[h][0] || p.v[h][1] !== m.v[h][1] || p.o[h][0] !== m.o[h][0] || p.o[h][1] !== m.o[h][1] || p.i[h][0] !== m.i[h][0] || p.i[h][1] !== m.i[h][1]) return !1;
                          return !0
                      })(this.v, d) || (this.v = shapePool.clone(d), this.localShapeCollection.releaseShapes(), this.localShapeCollection.addShape(this.v), this._mdf = !0, this.paths = this.localShapeCollection)
                  }

                  function a() {
                      if (this.elem.globalData.frameId !== this.frameId)
                          if (this.effectsSequence.length)
                              if (this.lock) this.setVValue(this.pv);
                              else {
                                  var d, p;
                                  this.lock = !0, this._mdf = !1, d = this.kf ? this.pv : this.data.ks ? this.data.ks.k : this.data.pt.k;
                                  var m = this.effectsSequence.length;
                                  for (p = 0; p < m; p += 1) d = this.effectsSequence[p](d);
                                  this.setVValue(d), this.lock = !1, this.frameId = this.elem.globalData.frameId
                              }
                      else this._mdf = !1
                  }

                  function s(d, p, m) {
                      this.propType = "shape", this.comp = d.comp, this.container = d, this.elem = d, this.data = p, this.k = !1, this.kf = !1, this._mdf = !1;
                      var h = m === 3 ? p.pt.k : p.ks.k;
                      this.v = shapePool.clone(h), this.pv = shapePool.clone(this.v), this.localShapeCollection = shapeCollectionPool.newShapeCollection(), this.paths = this.localShapeCollection, this.paths.addShape(this.v), this.reset = n, this.effectsSequence = []
                  }

                  function o(d) {
                      this.effectsSequence.push(d), this.container.addDynamicProperty(this)
                  }

                  function l(d, p, m) {
                      this.propType = "shape", this.comp = d.comp, this.elem = d, this.container = d, this.offsetTime = d.data.st, this.keyframes = m === 3 ? p.pt.k : p.ks.k, this.keyframesMetadata = [], this.k = !0, this.kf = !0;
                      var h = this.keyframes[0].s[0].i.length;
                      this.v = shapePool.newElement(), this.v.setPathData(this.keyframes[0].s[0].c, h), this.pv = shapePool.clone(this.v), this.localShapeCollection = shapeCollectionPool.newShapeCollection(), this.paths = this.localShapeCollection, this.paths.addShape(this.v), this.lastFrame = e, this.reset = n, this._caching = {
                          lastFrame: e,
                          lastIndex: 0
                      }, this.effectsSequence = [r.bind(this)]
                  }
                  s.prototype.interpolateShape = t, s.prototype.getValue = a, s.prototype.setVValue = i, s.prototype.addEffect = o, l.prototype.getValue = a, l.prototype.interpolateShape = t, l.prototype.setVValue = i, l.prototype.addEffect = o;
                  var f = function() {
                          var d = roundCorner;

                          function p(m, h) {
                              this.v = shapePool.newElement(), this.v.setPathData(!0, 4), this.localShapeCollection = shapeCollectionPool.newShapeCollection(), this.paths = this.localShapeCollection, this.localShapeCollection.addShape(this.v), this.d = h.d, this.elem = m, this.comp = m.comp, this.frameId = -1, this.initDynamicPropertyContainer(m), this.p = PropertyFactory.getProp(m, h.p, 1, 0, this), this.s = PropertyFactory.getProp(m, h.s, 1, 0, this), this.dynamicProperties.length ? this.k = !0 : (this.k = !1, this.convertEllToPath())
                          }
                          return p.prototype = {
                              reset: n,
                              getValue: function() {
                                  this.elem.globalData.frameId !== this.frameId && (this.frameId = this.elem.globalData.frameId, this.iterateDynamicProperties(), this._mdf && this.convertEllToPath())
                              },
                              convertEllToPath: function() {
                                  var m = this.p.v[0],
                                      h = this.p.v[1],
                                      g = this.s.v[0] / 2,
                                      y = this.s.v[1] / 2,
                                      b = this.d !== 3,
                                      _ = this.v;
                                  _.v[0][0] = m, _.v[0][1] = h - y, _.v[1][0] = b ? m + g : m - g, _.v[1][1] = h, _.v[2][0] = m, _.v[2][1] = h + y, _.v[3][0] = b ? m - g : m + g, _.v[3][1] = h, _.i[0][0] = b ? m - g * d : m + g * d, _.i[0][1] = h - y, _.i[1][0] = b ? m + g : m - g, _.i[1][1] = h - y * d, _.i[2][0] = b ? m + g * d : m - g * d, _.i[2][1] = h + y, _.i[3][0] = b ? m - g : m + g, _.i[3][1] = h + y * d, _.o[0][0] = b ? m + g * d : m - g * d, _.o[0][1] = h - y, _.o[1][0] = b ? m + g : m - g, _.o[1][1] = h + y * d, _.o[2][0] = b ? m - g * d : m + g * d, _.o[2][1] = h + y, _.o[3][0] = b ? m - g : m + g, _.o[3][1] = h - y * d
                              }
                          }, extendPrototype([DynamicPropertyContainer], p), p
                      }(),
                      u = function() {
                          function d(p, m) {
                              this.v = shapePool.newElement(), this.v.setPathData(!0, 0), this.elem = p, this.comp = p.comp, this.data = m, this.frameId = -1, this.d = m.d, this.initDynamicPropertyContainer(p), m.sy === 1 ? (this.ir = PropertyFactory.getProp(p, m.ir, 0, 0, this), this.is = PropertyFactory.getProp(p, m.is, 0, .01, this), this.convertToPath = this.convertStarToPath) : this.convertToPath = this.convertPolygonToPath, this.pt = PropertyFactory.getProp(p, m.pt, 0, 0, this), this.p = PropertyFactory.getProp(p, m.p, 1, 0, this), this.r = PropertyFactory.getProp(p, m.r, 0, degToRads, this), this.or = PropertyFactory.getProp(p, m.or, 0, 0, this), this.os = PropertyFactory.getProp(p, m.os, 0, .01, this), this.localShapeCollection = shapeCollectionPool.newShapeCollection(), this.localShapeCollection.addShape(this.v), this.paths = this.localShapeCollection, this.dynamicProperties.length ? this.k = !0 : (this.k = !1, this.convertToPath())
                          }
                          return d.prototype = {
                              reset: n,
                              getValue: function() {
                                  this.elem.globalData.frameId !== this.frameId && (this.frameId = this.elem.globalData.frameId, this.iterateDynamicProperties(), this._mdf && this.convertToPath())
                              },
                              convertStarToPath: function() {
                                  var p, m, h, g, y = 2 * Math.floor(this.pt.v),
                                      b = 2 * Math.PI / y,
                                      _ = !0,
                                      I = this.or.v,
                                      C = this.ir.v,
                                      x = this.os.v,
                                      O = this.is.v,
                                      L = 2 * Math.PI * I / (2 * y),
                                      D = 2 * Math.PI * C / (2 * y),
                                      A = -Math.PI / 2;
                                  A += this.r.v;
                                  var q = this.data.d === 3 ? -1 : 1;
                                  for (this.v._length = 0, p = 0; p < y; p += 1) {
                                      h = _ ? x : O, g = _ ? L : D;
                                      var w = (m = _ ? I : C) * Math.cos(A),
                                          F = m * Math.sin(A),
                                          k = w === 0 && F === 0 ? 0 : F / Math.sqrt(w * w + F * F),
                                          U = w === 0 && F === 0 ? 0 : -w / Math.sqrt(w * w + F * F);
                                      w += +this.p.v[0], F += +this.p.v[1], this.v.setTripleAt(w, F, w - k * g * h * q, F - U * g * h * q, w + k * g * h * q, F + U * g * h * q, p, !0), _ = !_, A += b * q
                                  }
                              },
                              convertPolygonToPath: function() {
                                  var p, m = Math.floor(this.pt.v),
                                      h = 2 * Math.PI / m,
                                      g = this.or.v,
                                      y = this.os.v,
                                      b = 2 * Math.PI * g / (4 * m),
                                      _ = .5 * -Math.PI,
                                      I = this.data.d === 3 ? -1 : 1;
                                  for (_ += this.r.v, this.v._length = 0, p = 0; p < m; p += 1) {
                                      var C = g * Math.cos(_),
                                          x = g * Math.sin(_),
                                          O = C === 0 && x === 0 ? 0 : x / Math.sqrt(C * C + x * x),
                                          L = C === 0 && x === 0 ? 0 : -C / Math.sqrt(C * C + x * x);
                                      C += +this.p.v[0], x += +this.p.v[1], this.v.setTripleAt(C, x, C - O * b * y * I, x - L * b * y * I, C + O * b * y * I, x + L * b * y * I, p, !0), _ += h * I
                                  }
                                  this.paths.length = 0, this.paths[0] = this.v
                              }
                          }, extendPrototype([DynamicPropertyContainer], d), d
                      }(),
                      c = function() {
                          function d(p, m) {
                              this.v = shapePool.newElement(), this.v.c = !0, this.localShapeCollection = shapeCollectionPool.newShapeCollection(), this.localShapeCollection.addShape(this.v), this.paths = this.localShapeCollection, this.elem = p, this.comp = p.comp, this.frameId = -1, this.d = m.d, this.initDynamicPropertyContainer(p), this.p = PropertyFactory.getProp(p, m.p, 1, 0, this), this.s = PropertyFactory.getProp(p, m.s, 1, 0, this), this.r = PropertyFactory.getProp(p, m.r, 0, 0, this), this.dynamicProperties.length ? this.k = !0 : (this.k = !1, this.convertRectToPath())
                          }
                          return d.prototype = {
                              convertRectToPath: function() {
                                  var p = this.p.v[0],
                                      m = this.p.v[1],
                                      h = this.s.v[0] / 2,
                                      g = this.s.v[1] / 2,
                                      y = bmMin(h, g, this.r.v),
                                      b = y * (1 - roundCorner);
                                  this.v._length = 0, this.d === 2 || this.d === 1 ? (this.v.setTripleAt(p + h, m - g + y, p + h, m - g + y, p + h, m - g + b, 0, !0), this.v.setTripleAt(p + h, m + g - y, p + h, m + g - b, p + h, m + g - y, 1, !0), y !== 0 ? (this.v.setTripleAt(p + h - y, m + g, p + h - y, m + g, p + h - b, m + g, 2, !0), this.v.setTripleAt(p - h + y, m + g, p - h + b, m + g, p - h + y, m + g, 3, !0), this.v.setTripleAt(p - h, m + g - y, p - h, m + g - y, p - h, m + g - b, 4, !0), this.v.setTripleAt(p - h, m - g + y, p - h, m - g + b, p - h, m - g + y, 5, !0), this.v.setTripleAt(p - h + y, m - g, p - h + y, m - g, p - h + b, m - g, 6, !0), this.v.setTripleAt(p + h - y, m - g, p + h - b, m - g, p + h - y, m - g, 7, !0)) : (this.v.setTripleAt(p - h, m + g, p - h + b, m + g, p - h, m + g, 2), this.v.setTripleAt(p - h, m - g, p - h, m - g + b, p - h, m - g, 3))) : (this.v.setTripleAt(p + h, m - g + y, p + h, m - g + b, p + h, m - g + y, 0, !0), y !== 0 ? (this.v.setTripleAt(p + h - y, m - g, p + h - y, m - g, p + h - b, m - g, 1, !0), this.v.setTripleAt(p - h + y, m - g, p - h + b, m - g, p - h + y, m - g, 2, !0), this.v.setTripleAt(p - h, m - g + y, p - h, m - g + y, p - h, m - g + b, 3, !0), this.v.setTripleAt(p - h, m + g - y, p - h, m + g - b, p - h, m + g - y, 4, !0), this.v.setTripleAt(p - h + y, m + g, p - h + y, m + g, p - h + b, m + g, 5, !0), this.v.setTripleAt(p + h - y, m + g, p + h - b, m + g, p + h - y, m + g, 6, !0), this.v.setTripleAt(p + h, m + g - y, p + h, m + g - y, p + h, m + g - b, 7, !0)) : (this.v.setTripleAt(p - h, m - g, p - h + b, m - g, p - h, m - g, 1, !0), this.v.setTripleAt(p - h, m + g, p - h, m + g - b, p - h, m + g, 2, !0), this.v.setTripleAt(p + h, m + g, p + h - b, m + g, p + h, m + g, 3, !0)))
                              },
                              getValue: function() {
                                  this.elem.globalData.frameId !== this.frameId && (this.frameId = this.elem.globalData.frameId, this.iterateDynamicProperties(), this._mdf && this.convertRectToPath())
                              },
                              reset: n
                          }, extendPrototype([DynamicPropertyContainer], d), d
                      }(),
                      v = {
                          getShapeProp: function(d, p, m) {
                              var h;
                              return m === 3 || m === 4 ? h = (m === 3 ? p.pt : p.ks)
                                  .k.length ? new l(d, p, m) : new s(d, p, m) : m === 5 ? h = new c(d, p) : m === 6 ? h = new f(d, p) : m === 7 && (h = new u(d, p)), h.k && d.addDynamicProperty(h), h
                          },
                          getConstructorFunction: function() {
                              return s
                          },
                          getKeyframedConstructorFunction: function() {
                              return l
                          }
                      };
                  return v
              }(),
              Matrix = function() {
                  var e = Math.cos,
                      t = Math.sin,
                      r = Math.tan,
                      n = Math.round;

                  function i() {
                      return this.props[0] = 1, this.props[1] = 0, this.props[2] = 0, this.props[3] = 0, this.props[4] = 0, this.props[5] = 1, this.props[6] = 0, this.props[7] = 0, this.props[8] = 0, this.props[9] = 0, this.props[10] = 1, this.props[11] = 0, this.props[12] = 0, this.props[13] = 0, this.props[14] = 0, this.props[15] = 1, this
                  }

                  function a(S) {
                      if (S === 0) return this;
                      var R = e(S),
                          V = t(S);
                      return this._t(R, -V, 0, 0, V, R, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                  }

                  function s(S) {
                      if (S === 0) return this;
                      var R = e(S),
                          V = t(S);
                      return this._t(1, 0, 0, 0, 0, R, -V, 0, 0, V, R, 0, 0, 0, 0, 1)
                  }

                  function o(S) {
                      if (S === 0) return this;
                      var R = e(S),
                          V = t(S);
                      return this._t(R, 0, V, 0, 0, 1, 0, 0, -V, 0, R, 0, 0, 0, 0, 1)
                  }

                  function l(S) {
                      if (S === 0) return this;
                      var R = e(S),
                          V = t(S);
                      return this._t(R, -V, 0, 0, V, R, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                  }

                  function f(S, R) {
                      return this._t(1, R, S, 1, 0, 0)
                  }

                  function u(S, R) {
                      return this.shear(r(S), r(R))
                  }

                  function c(S, R) {
                      var V = e(R),
                          P = t(R);
                      return this._t(V, P, 0, 0, -P, V, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                          ._t(1, 0, 0, 0, r(S), 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                          ._t(V, -P, 0, 0, P, V, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
                  }

                  function v(S, R, V) {
                      return V || V === 0 || (V = 1), S === 1 && R === 1 && V === 1 ? this : this._t(S, 0, 0, 0, 0, R, 0, 0, 0, 0, V, 0, 0, 0, 0, 1)
                  }

                  function d(S, R, V, P, N, B, T, z, Q, G, J, ae, re, fe, ge, ye) {
                      return this.props[0] = S, this.props[1] = R, this.props[2] = V, this.props[3] = P, this.props[4] = N, this.props[5] = B, this.props[6] = T, this.props[7] = z, this.props[8] = Q, this.props[9] = G, this.props[10] = J, this.props[11] = ae, this.props[12] = re, this.props[13] = fe, this.props[14] = ge, this.props[15] = ye, this
                  }

                  function p(S, R, V) {
                      return V = V || 0, S !== 0 || R !== 0 || V !== 0 ? this._t(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, S, R, V, 1) : this
                  }

                  function m(S, R, V, P, N, B, T, z, Q, G, J, ae, re, fe, ge, ye) {
                      var ie = this.props;
                      if (S === 1 && R === 0 && V === 0 && P === 0 && N === 0 && B === 1 && T === 0 && z === 0 && Q === 0 && G === 0 && J === 1 && ae === 0) return ie[12] = ie[12] * S + ie[15] * re, ie[13] = ie[13] * B + ie[15] * fe, ie[14] = ie[14] * J + ie[15] * ge, ie[15] *= ye, this._identityCalculated = !1, this;
                      var Pe = ie[0],
                          Ge = ie[1],
                          Ke = ie[2],
                          M = ie[3],
                          H = ie[4],
                          j = ie[5],
                          Y = ie[6],
                          X = ie[7],
                          K = ie[8],
                          te = ie[9],
                          ne = ie[10],
                          me = ie[11],
                          ee = ie[12],
                          le = ie[13],
                          pe = ie[14],
                          xe = ie[15];
                      return ie[0] = Pe * S + Ge * N + Ke * Q + M * re, ie[1] = Pe * R + Ge * B + Ke * G + M * fe, ie[2] = Pe * V + Ge * T + Ke * J + M * ge, ie[3] = Pe * P + Ge * z + Ke * ae + M * ye, ie[4] = H * S + j * N + Y * Q + X * re, ie[5] = H * R + j * B + Y * G + X * fe, ie[6] = H * V + j * T + Y * J + X * ge, ie[7] = H * P + j * z + Y * ae + X * ye, ie[8] = K * S + te * N + ne * Q + me * re, ie[9] = K * R + te * B + ne * G + me * fe, ie[10] = K * V + te * T + ne * J + me * ge, ie[11] = K * P + te * z + ne * ae + me * ye, ie[12] = ee * S + le * N + pe * Q + xe * re, ie[13] = ee * R + le * B + pe * G + xe * fe, ie[14] = ee * V + le * T + pe * J + xe * ge, ie[15] = ee * P + le * z + pe * ae + xe * ye, this._identityCalculated = !1, this
                  }

                  function h(S) {
                      var R = S.props;
                      return this.transform(R[0], R[1], R[2], R[3], R[4], R[5], R[6], R[7], R[8], R[9], R[10], R[11], R[12], R[13], R[14], R[15])
                  }

                  function g() {
                      return this._identityCalculated || (this._identity = !(this.props[0] !== 1 || this.props[1] !== 0 || this.props[2] !== 0 || this.props[3] !== 0 || this.props[4] !== 0 || this.props[5] !== 1 || this.props[6] !== 0 || this.props[7] !== 0 || this.props[8] !== 0 || this.props[9] !== 0 || this.props[10] !== 1 || this.props[11] !== 0 || this.props[12] !== 0 || this.props[13] !== 0 || this.props[14] !== 0 || this.props[15] !== 1), this._identityCalculated = !0), this._identity
                  }

                  function y(S) {
                      for (var R = 0; R < 16;) {
                          if (S.props[R] !== this.props[R]) return !1;
                          R += 1
                      }
                      return !0
                  }

                  function b(S) {
                      var R;
                      for (R = 0; R < 16; R += 1) S.props[R] = this.props[R];
                      return S
                  }

                  function _(S) {
                      var R;
                      for (R = 0; R < 16; R += 1) this.props[R] = S[R]
                  }

                  function I(S, R, V) {
                      return {
                          x: S * this.props[0] + R * this.props[4] + V * this.props[8] + this.props[12],
                          y: S * this.props[1] + R * this.props[5] + V * this.props[9] + this.props[13],
                          z: S * this.props[2] + R * this.props[6] + V * this.props[10] + this.props[14]
                      }
                  }

                  function C(S, R, V) {
                      return S * this.props[0] + R * this.props[4] + V * this.props[8] + this.props[12]
                  }

                  function x(S, R, V) {
                      return S * this.props[1] + R * this.props[5] + V * this.props[9] + this.props[13]
                  }

                  function O(S, R, V) {
                      return S * this.props[2] + R * this.props[6] + V * this.props[10] + this.props[14]
                  }

                  function L() {
                      var S = this.props[0] * this.props[5] - this.props[1] * this.props[4],
                          R = this.props[5] / S,
                          V = -this.props[1] / S,
                          P = -this.props[4] / S,
                          N = this.props[0] / S,
                          B = (this.props[4] * this.props[13] - this.props[5] * this.props[12]) / S,
                          T = -(this.props[0] * this.props[13] - this.props[1] * this.props[12]) / S,
                          z = new Matrix;
                      return z.props[0] = R, z.props[1] = V, z.props[4] = P, z.props[5] = N, z.props[12] = B, z.props[13] = T, z
                  }

                  function D(S) {
                      return this.getInverseMatrix()
                          .applyToPointArray(S[0], S[1], S[2] || 0)
                  }

                  function A(S) {
                      var R, V = S.length,
                          P = [];
                      for (R = 0; R < V; R += 1) P[R] = D(S[R]);
                      return P
                  }

                  function q(S, R, V) {
                      var P = createTypedArray("float32", 6);
                      if (this.isIdentity()) P[0] = S[0], P[1] = S[1], P[2] = R[0], P[3] = R[1], P[4] = V[0], P[5] = V[1];
                      else {
                          var N = this.props[0],
                              B = this.props[1],
                              T = this.props[4],
                              z = this.props[5],
                              Q = this.props[12],
                              G = this.props[13];
                          P[0] = S[0] * N + S[1] * T + Q, P[1] = S[0] * B + S[1] * z + G, P[2] = R[0] * N + R[1] * T + Q, P[3] = R[0] * B + R[1] * z + G, P[4] = V[0] * N + V[1] * T + Q, P[5] = V[0] * B + V[1] * z + G
                      }
                      return P
                  }

                  function w(S, R, V) {
                      return this.isIdentity() ? [S, R, V] : [S * this.props[0] + R * this.props[4] + V * this.props[8] + this.props[12], S * this.props[1] + R * this.props[5] + V * this.props[9] + this.props[13], S * this.props[2] + R * this.props[6] + V * this.props[10] + this.props[14]]
                  }

                  function F(S, R) {
                      if (this.isIdentity()) return S + "," + R;
                      var V = this.props;
                      return Math.round(100 * (S * V[0] + R * V[4] + V[12])) / 100 + "," + Math.round(100 * (S * V[1] + R * V[5] + V[13])) / 100
                  }

                  function k() {
                      for (var S = 0, R = this.props, V = "matrix3d("; S < 16;) V += n(1e4 * R[S]) / 1e4, V += S === 15 ? ")" : ",", S += 1;
                      return V
                  }

                  function U(S) {
                      return S < 1e-6 && S > 0 || S > -1e-6 && S < 0 ? n(1e4 * S) / 1e4 : S
                  }

                  function W() {
                      var S = this.props;
                      return "matrix(" + U(S[0]) + "," + U(S[1]) + "," + U(S[4]) + "," + U(S[5]) + "," + U(S[12]) + "," + U(S[13]) + ")"
                  }
                  return function() {
                      this.reset = i, this.rotate = a, this.rotateX = s, this.rotateY = o, this.rotateZ = l, this.skew = u, this.skewFromAxis = c, this.shear = f, this.scale = v, this.setTransform = d, this.translate = p, this.transform = m, this.multiply = h, this.applyToPoint = I, this.applyToX = C, this.applyToY = x, this.applyToZ = O, this.applyToPointArray = w, this.applyToTriplePoints = q, this.applyToPointStringified = F, this.toCSS = k, this.to2dCSS = W, this.clone = b, this.cloneFromProps = _, this.equals = y, this.inversePoints = A, this.inversePoint = D, this.getInverseMatrix = L, this._t = this.transform, this.isIdentity = g, this._identity = !0, this._identityCalculated = !1, this.props = createTypedArray("float32", 16), this.reset()
                  }
              }();

          function _typeof$3(e) {
              return _typeof$3 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof$3(e)
          }
          var lottie = {},
              standalone = "__[STANDALONE]__",
              animationData = "__[ANIMATIONDATA]__",
              renderer = "";

          function setLocation(e) {
              setLocationHref(e)
          }

          function searchAnimations() {
              standalone === !0 ? animationManager.searchAnimations(animationData, standalone, renderer) : animationManager.searchAnimations()
          }

          function setSubframeRendering(e) {
              setSubframeEnabled(e)
          }

          function setPrefix(e) {
              setIdPrefix(e)
          }

          function loadAnimation(e) {
              return standalone === !0 && (e.animationData = JSON.parse(animationData)), animationManager.loadAnimation(e)
          }

          function setQuality(e) {
              if (typeof e == "string") switch (e) {
                  case "high":
                      setDefaultCurveSegments(200);
                      break;
                  default:
                  case "medium":
                      setDefaultCurveSegments(50);
                      break;
                  case "low":
                      setDefaultCurveSegments(10)
              } else !isNaN(e) && e > 1 && setDefaultCurveSegments(e);
              getDefaultCurveSegments() >= 50 ? roundValues(!1) : roundValues(!0)
          }

          function inBrowser() {
              return typeof navigator < "u"
          }

          function installPlugin(e, t) {
              e === "expressions" && setExpressionsPlugin(t)
          }

          function getFactory(e) {
              switch (e) {
                  case "propertyFactory":
                      return PropertyFactory;
                  case "shapePropertyFactory":
                      return ShapePropertyFactory;
                  case "matrix":
                      return Matrix;
                  default:
                      return null
              }
          }

          function checkReady() {
              document.readyState === "complete" && (clearInterval(readyStateCheckInterval), searchAnimations())
          }

          function getQueryVariable(e) {
              for (var t = queryString.split("&"), r = 0; r < t.length; r += 1) {
                  var n = t[r].split("=");
                  if (decodeURIComponent(n[0]) == e) return decodeURIComponent(n[1])
              }
              return null
          }
          lottie.play = animationManager.play, lottie.pause = animationManager.pause, lottie.setLocationHref = setLocation, lottie.togglePause = animationManager.togglePause, lottie.setSpeed = animationManager.setSpeed, lottie.setDirection = animationManager.setDirection, lottie.stop = animationManager.stop, lottie.searchAnimations = searchAnimations, lottie.registerAnimation = animationManager.registerAnimation, lottie.loadAnimation = loadAnimation, lottie.setSubframeRendering = setSubframeRendering, lottie.resize = animationManager.resize, lottie.goToAndStop = animationManager.goToAndStop, lottie.destroy = animationManager.destroy, lottie.setQuality = setQuality, lottie.inBrowser = inBrowser, lottie.installPlugin = installPlugin, lottie.freeze = animationManager.freeze, lottie.unfreeze = animationManager.unfreeze, lottie.setVolume = animationManager.setVolume, lottie.mute = animationManager.mute, lottie.unmute = animationManager.unmute, lottie.getRegisteredAnimations = animationManager.getRegisteredAnimations, lottie.useWebWorker = setWebWorker, lottie.setIDPrefix = setPrefix, lottie.__getFactory = getFactory, lottie.version = "5.12.2";
          var queryString = "";
          if (standalone) {
              var scripts = document.getElementsByTagName("script"),
                  index = scripts.length - 1,
                  myScript = scripts[index] || {
                      src: ""
                  };
              queryString = myScript.src ? myScript.src.replace(/^[^\?]+\??/, "") : "", renderer = getQueryVariable("renderer")
          }
          var readyStateCheckInterval = setInterval(checkReady, 100);
          try {
              (typeof exports > "u" ? "undefined" : _typeof$3(exports)) === "object" && typeof module < "u" || typeof define == "function" && define.amd || (window.bodymovin = lottie)
          } catch (e) {}
          var ShapeModifiers = function() {
              var e = {},
                  t = {};
              return e.registerModifier = function(r, n) {
                  t[r] || (t[r] = n)
              }, e.getModifier = function(r, n, i) {
                  return new t[r](n, i)
              }, e
          }();

          function ShapeModifier() {}

          function TrimModifier() {}

          function PuckerAndBloatModifier() {}
          ShapeModifier.prototype.initModifierProperties = function() {}, ShapeModifier.prototype.addShapeToModifier = function() {}, ShapeModifier.prototype.addShape = function(e) {
              if (!this.closed) {
                  e.sh.container.addDynamicProperty(e.sh);
                  var t = {
                      shape: e.sh,
                      data: e,
                      localShapeCollection: shapeCollectionPool.newShapeCollection()
                  };
                  this.shapes.push(t), this.addShapeToModifier(t), this._isAnimated && e.setAsAnimated()
              }
          }, ShapeModifier.prototype.init = function(e, t) {
              this.shapes = [], this.elem = e, this.initDynamicPropertyContainer(e), this.initModifierProperties(e, t), this.frameId = initialDefaultFrame, this.closed = !1, this.k = !1, this.dynamicProperties.length ? this.k = !0 : this.getValue(!0)
          }, ShapeModifier.prototype.processKeys = function() {
              this.elem.globalData.frameId !== this.frameId && (this.frameId = this.elem.globalData.frameId, this.iterateDynamicProperties())
          }, extendPrototype([DynamicPropertyContainer], ShapeModifier), extendPrototype([ShapeModifier], TrimModifier), TrimModifier.prototype.initModifierProperties = function(e, t) {
              this.s = PropertyFactory.getProp(e, t.s, 0, .01, this), this.e = PropertyFactory.getProp(e, t.e, 0, .01, this), this.o = PropertyFactory.getProp(e, t.o, 0, 0, this), this.sValue = 0, this.eValue = 0, this.getValue = this.processKeys, this.m = t.m, this._isAnimated = !!this.s.effectsSequence.length || !!this.e.effectsSequence.length || !!this.o.effectsSequence.length
          }, TrimModifier.prototype.addShapeToModifier = function(e) {
              e.pathsData = []
          }, TrimModifier.prototype.calculateShapeEdges = function(e, t, r, n, i) {
              var a = [];
              t <= 1 ? a.push({
                  s: e,
                  e: t
              }) : e >= 1 ? a.push({
                  s: e - 1,
                  e: t - 1
              }) : (a.push({
                  s: e,
                  e: 1
              }), a.push({
                  s: 0,
                  e: t - 1
              }));
              var s, o, l = [],
                  f = a.length;
              for (s = 0; s < f; s += 1) {
                  var u, c;
                  (o = a[s])
                  .e * i < n || o.s * i > n + r || (u = o.s * i <= n ? 0 : (o.s * i - n) / r, c = o.e * i >= n + r ? 1 : (o.e * i - n) / r, l.push([u, c]))
              }
              return l.length || l.push([0, 0]), l
          }, TrimModifier.prototype.releasePathsData = function(e) {
              var t, r = e.length;
              for (t = 0; t < r; t += 1) segmentsLengthPool.release(e[t]);
              return e.length = 0, e
          }, TrimModifier.prototype.processShapes = function(e) {
              var t, r, n, i;
              if (this._mdf || e) {
                  var a = this.o.v % 360 / 360;
                  if (a < 0 && (a += 1), (t = this.s.v > 1 ? 1 + a : this.s.v < 0 ? 0 + a : this.s.v + a) > (r = this.e.v > 1 ? 1 + a : this.e.v < 0 ? 0 + a : this.e.v + a)) {
                      var s = t;
                      t = r, r = s
                  }
                  t = 1e-4 * Math.round(1e4 * t), r = 1e-4 * Math.round(1e4 * r), this.sValue = t, this.eValue = r
              } else t = this.sValue, r = this.eValue;
              var o, l, f, u, c, v = this.shapes.length,
                  d = 0;
              if (r === t)
                  for (i = 0; i < v; i += 1) this.shapes[i].localShapeCollection.releaseShapes(), this.shapes[i].shape._mdf = !0, this.shapes[i].shape.paths = this.shapes[i].localShapeCollection, this._mdf && (this.shapes[i].pathsData.length = 0);
              else if (r === 1 && t === 0 || r === 0 && t === 1) {
                  if (this._mdf)
                      for (i = 0; i < v; i += 1) this.shapes[i].pathsData.length = 0, this.shapes[i].shape._mdf = !0
              } else {
                  var p, m, h = [];
                  for (i = 0; i < v; i += 1)
                      if ((p = this.shapes[i])
                          .shape._mdf || this._mdf || e || this.m === 2) {
                          if (l = (n = p.shape.paths)
                              ._length, c = 0, !p.shape._mdf && p.pathsData.length) c = p.totalShapeLength;
                          else {
                              for (f = this.releasePathsData(p.pathsData), o = 0; o < l; o += 1) u = bez.getSegmentsLength(n.shapes[o]), f.push(u), c += u.totalLength;
                              p.totalShapeLength = c, p.pathsData = f
                          }
                          d += c, p.shape._mdf = !0
                      } else p.shape.paths = p.localShapeCollection;
                  var g, y = t,
                      b = r,
                      _ = 0;
                  for (i = v - 1; i >= 0; i -= 1)
                      if ((p = this.shapes[i])
                          .shape._mdf) {
                          for ((m = p.localShapeCollection)
                              .releaseShapes(), this.m === 2 && v > 1 ? (g = this.calculateShapeEdges(t, r, p.totalShapeLength, _, d), _ += p.totalShapeLength) : g = [
                                  [y, b]
                              ], l = g.length, o = 0; o < l; o += 1) {
                              y = g[o][0], b = g[o][1], h.length = 0, b <= 1 ? h.push({
                                  s: p.totalShapeLength * y,
                                  e: p.totalShapeLength * b
                              }) : y >= 1 ? h.push({
                                  s: p.totalShapeLength * (y - 1),
                                  e: p.totalShapeLength * (b - 1)
                              }) : (h.push({
                                  s: p.totalShapeLength * y,
                                  e: p.totalShapeLength
                              }), h.push({
                                  s: 0,
                                  e: p.totalShapeLength * (b - 1)
                              }));
                              var I = this.addShapes(p, h[0]);
                              if (h[0].s !== h[0].e) {
                                  if (h.length > 1)
                                      if (p.shape.paths.shapes[p.shape.paths._length - 1].c) {
                                          var C = I.pop();
                                          this.addPaths(I, m), I = this.addShapes(p, h[1], C)
                                      } else this.addPaths(I, m), I = this.addShapes(p, h[1]);
                                  this.addPaths(I, m)
                              }
                          }
                          p.shape.paths = m
                      }
              }
          }, TrimModifier.prototype.addPaths = function(e, t) {
              var r, n = e.length;
              for (r = 0; r < n; r += 1) t.addShape(e[r])
          }, TrimModifier.prototype.addSegment = function(e, t, r, n, i, a, s) {
              i.setXYAt(t[0], t[1], "o", a), i.setXYAt(r[0], r[1], "i", a + 1), s && i.setXYAt(e[0], e[1], "v", a), i.setXYAt(n[0], n[1], "v", a + 1)
          }, TrimModifier.prototype.addSegmentFromArray = function(e, t, r, n) {
              t.setXYAt(e[1], e[5], "o", r), t.setXYAt(e[2], e[6], "i", r + 1), n && t.setXYAt(e[0], e[4], "v", r), t.setXYAt(e[3], e[7], "v", r + 1)
          }, TrimModifier.prototype.addShapes = function(e, t, r) {
              var n, i, a, s, o, l, f, u, c = e.pathsData,
                  v = e.shape.paths.shapes,
                  d = e.shape.paths._length,
                  p = 0,
                  m = [],
                  h = !0;
              for (r ? (o = r._length, u = r._length) : (r = shapePool.newElement(), o = 0, u = 0), m.push(r), n = 0; n < d; n += 1) {
                  for (l = c[n].lengths, r.c = v[n].c, a = v[n].c ? l.length : l.length + 1, i = 1; i < a; i += 1)
                      if (p + (s = l[i - 1])
                          .addedLength < t.s) p += s.addedLength, r.c = !1;
                      else {
                          if (p > t.e) {
                              r.c = !1;
                              break
                          }
                          t.s <= p && t.e >= p + s.addedLength ? (this.addSegment(v[n].v[i - 1], v[n].o[i - 1], v[n].i[i], v[n].v[i], r, o, h), h = !1) : (f = bez.getNewSegment(v[n].v[i - 1], v[n].v[i], v[n].o[i - 1], v[n].i[i], (t.s - p) / s.addedLength, (t.e - p) / s.addedLength, l[i - 1]), this.addSegmentFromArray(f, r, o, h), h = !1, r.c = !1), p += s.addedLength, o += 1
                      } if (v[n].c && l.length) {
                      if (s = l[i - 1], p <= t.e) {
                          var g = l[i - 1].addedLength;
                          t.s <= p && t.e >= p + g ? (this.addSegment(v[n].v[i - 1], v[n].o[i - 1], v[n].i[0], v[n].v[0], r, o, h), h = !1) : (f = bez.getNewSegment(v[n].v[i - 1], v[n].v[0], v[n].o[i - 1], v[n].i[0], (t.s - p) / g, (t.e - p) / g, l[i - 1]), this.addSegmentFromArray(f, r, o, h), h = !1, r.c = !1)
                      } else r.c = !1;
                      p += s.addedLength, o += 1
                  }
                  if (r._length && (r.setXYAt(r.v[u][0], r.v[u][1], "i", u), r.setXYAt(r.v[r._length - 1][0], r.v[r._length - 1][1], "o", r._length - 1)), p > t.e) break;
                  n < d - 1 && (r = shapePool.newElement(), h = !0, m.push(r), o = 0)
              }
              return m
          }, extendPrototype([ShapeModifier], PuckerAndBloatModifier), PuckerAndBloatModifier.prototype.initModifierProperties = function(e, t) {
              this.getValue = this.processKeys, this.amount = PropertyFactory.getProp(e, t.a, 0, null, this), this._isAnimated = !!this.amount.effectsSequence.length
          }, PuckerAndBloatModifier.prototype.processPath = function(e, t) {
              var r = t / 100,
                  n = [0, 0],
                  i = e._length,
                  a = 0;
              for (a = 0; a < i; a += 1) n[0] += e.v[a][0], n[1] += e.v[a][1];
              n[0] /= i, n[1] /= i;
              var s, o, l, f, u, c, v = shapePool.newElement();
              for (v.c = e.c, a = 0; a < i; a += 1) s = e.v[a][0] + (n[0] - e.v[a][0]) * r, o = e.v[a][1] + (n[1] - e.v[a][1]) * r, l = e.o[a][0] + (n[0] - e.o[a][0]) * -r, f = e.o[a][1] + (n[1] - e.o[a][1]) * -r, u = e.i[a][0] + (n[0] - e.i[a][0]) * -r, c = e.i[a][1] + (n[1] - e.i[a][1]) * -r, v.setTripleAt(s, o, l, f, u, c, a);
              return v
          }, PuckerAndBloatModifier.prototype.processShapes = function(e) {
              var t, r, n, i, a, s, o = this.shapes.length,
                  l = this.amount.v;
              if (l !== 0)
                  for (r = 0; r < o; r += 1) {
                      if (s = (a = this.shapes[r])
                          .localShapeCollection, a.shape._mdf || this._mdf || e)
                          for (s.releaseShapes(), a.shape._mdf = !0, t = a.shape.paths.shapes, i = a.shape.paths._length, n = 0; n < i; n += 1) s.addShape(this.processPath(t[n], l));
                      a.shape.paths = a.localShapeCollection
                  }
              this.dynamicProperties.length || (this._mdf = !1)
          };
          var TransformPropertyFactory = function() {
              var e = [0, 0];

              function t(r, n, i) {
                  if (this.elem = r, this.frameId = -1, this.propType = "transform", this.data = n, this.v = new Matrix, this.pre = new Matrix, this.appliedTransformations = 0, this.initDynamicPropertyContainer(i || r), n.p && n.p.s ? (this.px = PropertyFactory.getProp(r, n.p.x, 0, 0, this), this.py = PropertyFactory.getProp(r, n.p.y, 0, 0, this), n.p.z && (this.pz = PropertyFactory.getProp(r, n.p.z, 0, 0, this))) : this.p = PropertyFactory.getProp(r, n.p || {
                          k: [0, 0, 0]
                      }, 1, 0, this), n.rx) {
                      if (this.rx = PropertyFactory.getProp(r, n.rx, 0, degToRads, this), this.ry = PropertyFactory.getProp(r, n.ry, 0, degToRads, this), this.rz = PropertyFactory.getProp(r, n.rz, 0, degToRads, this), n.or.k[0].ti) {
                          var a, s = n.or.k.length;
                          for (a = 0; a < s; a += 1) n.or.k[a].to = null, n.or.k[a].ti = null
                      }
                      this.or = PropertyFactory.getProp(r, n.or, 1, degToRads, this), this.or.sh = !0
                  } else this.r = PropertyFactory.getProp(r, n.r || {
                      k: 0
                  }, 0, degToRads, this);
                  n.sk && (this.sk = PropertyFactory.getProp(r, n.sk, 0, degToRads, this), this.sa = PropertyFactory.getProp(r, n.sa, 0, degToRads, this)), this.a = PropertyFactory.getProp(r, n.a || {
                      k: [0, 0, 0]
                  }, 1, 0, this), this.s = PropertyFactory.getProp(r, n.s || {
                      k: [100, 100, 100]
                  }, 1, .01, this), n.o ? this.o = PropertyFactory.getProp(r, n.o, 0, .01, r) : this.o = {
                      _mdf: !1,
                      v: 1
                  }, this._isDirty = !0, this.dynamicProperties.length || this.getValue(!0)
              }
              return t.prototype = {
                  applyToMatrix: function(r) {
                      var n = this._mdf;
                      this.iterateDynamicProperties(), this._mdf = this._mdf || n, this.a && r.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]), this.s && r.scale(this.s.v[0], this.s.v[1], this.s.v[2]), this.sk && r.skewFromAxis(-this.sk.v, this.sa.v), this.r ? r.rotate(-this.r.v) : r.rotateZ(-this.rz.v)
                          .rotateY(this.ry.v)
                          .rotateX(this.rx.v)
                          .rotateZ(-this.or.v[2])
                          .rotateY(this.or.v[1])
                          .rotateX(this.or.v[0]), this.data.p.s ? this.data.p.z ? r.translate(this.px.v, this.py.v, -this.pz.v) : r.translate(this.px.v, this.py.v, 0) : r.translate(this.p.v[0], this.p.v[1], -this.p.v[2])
                  },
                  getValue: function(r) {
                      if (this.elem.globalData.frameId !== this.frameId) {
                          if (this._isDirty && (this.precalculateMatrix(), this._isDirty = !1), this.iterateDynamicProperties(), this._mdf || r) {
                              var n;
                              if (this.v.cloneFromProps(this.pre.props), this.appliedTransformations < 1 && this.v.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]), this.appliedTransformations < 2 && this.v.scale(this.s.v[0], this.s.v[1], this.s.v[2]), this.sk && this.appliedTransformations < 3 && this.v.skewFromAxis(-this.sk.v, this.sa.v), this.r && this.appliedTransformations < 4 ? this.v.rotate(-this.r.v) : !this.r && this.appliedTransformations < 4 && this.v.rotateZ(-this.rz.v)
                                  .rotateY(this.ry.v)
                                  .rotateX(this.rx.v)
                                  .rotateZ(-this.or.v[2])
                                  .rotateY(this.or.v[1])
                                  .rotateX(this.or.v[0]), this.autoOriented) {
                                  var i, a;
                                  if (n = this.elem.globalData.frameRate, this.p && this.p.keyframes && this.p.getValueAtTime) this.p._caching.lastFrame + this.p.offsetTime <= this.p.keyframes[0].t ? (i = this.p.getValueAtTime((this.p.keyframes[0].t + .01) / n, 0), a = this.p.getValueAtTime(this.p.keyframes[0].t / n, 0)) : this.p._caching.lastFrame + this.p.offsetTime >= this.p.keyframes[this.p.keyframes.length - 1].t ? (i = this.p.getValueAtTime(this.p.keyframes[this.p.keyframes.length - 1].t / n, 0), a = this.p.getValueAtTime((this.p.keyframes[this.p.keyframes.length - 1].t - .05) / n, 0)) : (i = this.p.pv, a = this.p.getValueAtTime((this.p._caching.lastFrame + this.p.offsetTime - .01) / n, this.p.offsetTime));
                                  else if (this.px && this.px.keyframes && this.py.keyframes && this.px.getValueAtTime && this.py.getValueAtTime) {
                                      i = [], a = [];
                                      var s = this.px,
                                          o = this.py;
                                      s._caching.lastFrame + s.offsetTime <= s.keyframes[0].t ? (i[0] = s.getValueAtTime((s.keyframes[0].t + .01) / n, 0), i[1] = o.getValueAtTime((o.keyframes[0].t + .01) / n, 0), a[0] = s.getValueAtTime(s.keyframes[0].t / n, 0), a[1] = o.getValueAtTime(o.keyframes[0].t / n, 0)) : s._caching.lastFrame + s.offsetTime >= s.keyframes[s.keyframes.length - 1].t ? (i[0] = s.getValueAtTime(s.keyframes[s.keyframes.length - 1].t / n, 0), i[1] = o.getValueAtTime(o.keyframes[o.keyframes.length - 1].t / n, 0), a[0] = s.getValueAtTime((s.keyframes[s.keyframes.length - 1].t - .01) / n, 0), a[1] = o.getValueAtTime((o.keyframes[o.keyframes.length - 1].t - .01) / n, 0)) : (i = [s.pv, o.pv], a[0] = s.getValueAtTime((s._caching.lastFrame + s.offsetTime - .01) / n, s.offsetTime), a[1] = o.getValueAtTime((o._caching.lastFrame + o.offsetTime - .01) / n, o.offsetTime))
                                  } else i = a = e;
                                  this.v.rotate(-Math.atan2(i[1] - a[1], i[0] - a[0]))
                              }
                              this.data.p && this.data.p.s ? this.data.p.z ? this.v.translate(this.px.v, this.py.v, -this.pz.v) : this.v.translate(this.px.v, this.py.v, 0) : this.v.translate(this.p.v[0], this.p.v[1], -this.p.v[2])
                          }
                          this.frameId = this.elem.globalData.frameId
                      }
                  },
                  precalculateMatrix: function() {
                      if (this.appliedTransformations = 0, this.pre.reset(), !this.a.effectsSequence.length && (this.pre.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]), this.appliedTransformations = 1, !this.s.effectsSequence.length)) {
                          if (this.pre.scale(this.s.v[0], this.s.v[1], this.s.v[2]), this.appliedTransformations = 2, this.sk) {
                              if (this.sk.effectsSequence.length || this.sa.effectsSequence.length) return;
                              this.pre.skewFromAxis(-this.sk.v, this.sa.v), this.appliedTransformations = 3
                          }
                          this.r ? this.r.effectsSequence.length || (this.pre.rotate(-this.r.v), this.appliedTransformations = 4) : this.rz.effectsSequence.length || this.ry.effectsSequence.length || this.rx.effectsSequence.length || this.or.effectsSequence.length || (this.pre.rotateZ(-this.rz.v)
                              .rotateY(this.ry.v)
                              .rotateX(this.rx.v)
                              .rotateZ(-this.or.v[2])
                              .rotateY(this.or.v[1])
                              .rotateX(this.or.v[0]), this.appliedTransformations = 4)
                      }
                  },
                  autoOrient: function() {}
              }, extendPrototype([DynamicPropertyContainer], t), t.prototype.addDynamicProperty = function(r) {
                  this._addDynamicProperty(r), this.elem.addDynamicProperty(r), this._isDirty = !0
              }, t.prototype._addDynamicProperty = DynamicPropertyContainer.prototype.addDynamicProperty, {
                  getTransformProperty: function(r, n, i) {
                      return new t(r, n, i)
                  }
              }
          }();

          function RepeaterModifier() {}

          function RoundCornersModifier() {}

          function floatEqual(e, t) {
              return 1e5 * Math.abs(e - t) <= Math.min(Math.abs(e), Math.abs(t))
          }

          function floatZero(e) {
              return Math.abs(e) <= 1e-5
          }

          function lerp(e, t, r) {
              return e * (1 - r) + t * r
          }

          function lerpPoint(e, t, r) {
              return [lerp(e[0], t[0], r), lerp(e[1], t[1], r)]
          }

          function quadRoots(e, t, r) {
              if (e === 0) return [];
              var n = t * t - 4 * e * r;
              if (n < 0) return [];
              var i = -t / (2 * e);
              if (n === 0) return [i];
              var a = Math.sqrt(n) / (2 * e);
              return [i - a, i + a]
          }

          function polynomialCoefficients(e, t, r, n) {
              return [3 * t - e - 3 * r + n, 3 * e - 6 * t + 3 * r, -3 * e + 3 * t, e]
          }

          function singlePoint(e) {
              return new PolynomialBezier(e, e, e, e, !1)
          }

          function PolynomialBezier(e, t, r, n, i) {
              i && pointEqual(e, t) && (t = lerpPoint(e, n, 1 / 3)), i && pointEqual(r, n) && (r = lerpPoint(e, n, 2 / 3));
              var a = polynomialCoefficients(e[0], t[0], r[0], n[0]),
                  s = polynomialCoefficients(e[1], t[1], r[1], n[1]);
              this.a = [a[0], s[0]], this.b = [a[1], s[1]], this.c = [a[2], s[2]], this.d = [a[3], s[3]], this.points = [e, t, r, n]
          }

          function extrema(e, t) {
              var r = e.points[0][t],
                  n = e.points[e.points.length - 1][t];
              if (r > n) {
                  var i = n;
                  n = r, r = i
              }
              for (var a = quadRoots(3 * e.a[t], 2 * e.b[t], e.c[t]), s = 0; s < a.length; s += 1)
                  if (a[s] > 0 && a[s] < 1) {
                      var o = e.point(a[s])[t];
                      o < r ? r = o : o > n && (n = o)
                  } return {
                  min: r,
                  max: n
              }
          }

          function intersectData(e, t, r) {
              var n = e.boundingBox();
              return {
                  cx: n.cx,
                  cy: n.cy,
                  width: n.width,
                  height: n.height,
                  bez: e,
                  t: (t + r) / 2,
                  t1: t,
                  t2: r
              }
          }

          function splitData(e) {
              var t = e.bez.split(.5);
              return [intersectData(t[0], e.t1, e.t), intersectData(t[1], e.t, e.t2)]
          }

          function boxIntersect(e, t) {
              return 2 * Math.abs(e.cx - t.cx) < e.width + t.width && 2 * Math.abs(e.cy - t.cy) < e.height + t.height
          }

          function intersectsImpl(e, t, r, n, i, a) {
              if (boxIntersect(e, t))
                  if (r >= a || e.width <= n && e.height <= n && t.width <= n && t.height <= n) i.push([e.t, t.t]);
                  else {
                      var s = splitData(e),
                          o = splitData(t);
                      intersectsImpl(s[0], o[0], r + 1, n, i, a), intersectsImpl(s[0], o[1], r + 1, n, i, a), intersectsImpl(s[1], o[0], r + 1, n, i, a), intersectsImpl(s[1], o[1], r + 1, n, i, a)
                  }
          }

          function crossProduct(e, t) {
              return [e[1] * t[2] - e[2] * t[1], e[2] * t[0] - e[0] * t[2], e[0] * t[1] - e[1] * t[0]]
          }

          function lineIntersection(e, t, r, n) {
              var i = [e[0], e[1], 1],
                  a = [t[0], t[1], 1],
                  s = [r[0], r[1], 1],
                  o = [n[0], n[1], 1],
                  l = crossProduct(crossProduct(i, a), crossProduct(s, o));
              return floatZero(l[2]) ? null : [l[0] / l[2], l[1] / l[2]]
          }

          function polarOffset(e, t, r) {
              return [e[0] + Math.cos(t) * r, e[1] - Math.sin(t) * r]
          }

          function pointDistance(e, t) {
              return Math.hypot(e[0] - t[0], e[1] - t[1])
          }

          function pointEqual(e, t) {
              return floatEqual(e[0], t[0]) && floatEqual(e[1], t[1])
          }

          function ZigZagModifier() {}

          function setPoint(e, t, r, n, i, a, s) {
              var o = r - Math.PI / 2,
                  l = r + Math.PI / 2,
                  f = t[0] + Math.cos(r) * n * i,
                  u = t[1] - Math.sin(r) * n * i;
              e.setTripleAt(f, u, f + Math.cos(o) * a, u - Math.sin(o) * a, f + Math.cos(l) * s, u - Math.sin(l) * s, e.length())
          }

          function getPerpendicularVector(e, t) {
              var r = [t[0] - e[0], t[1] - e[1]],
                  n = .5 * -Math.PI;
              return [Math.cos(n) * r[0] - Math.sin(n) * r[1], Math.sin(n) * r[0] + Math.cos(n) * r[1]]
          }

          function getProjectingAngle(e, t) {
              var r = t === 0 ? e.length() - 1 : t - 1,
                  n = (t + 1) % e.length(),
                  i = getPerpendicularVector(e.v[r], e.v[n]);
              return Math.atan2(0, 1) - Math.atan2(i[1], i[0])
          }

          function zigZagCorner(e, t, r, n, i, a, s) {
              var o = getProjectingAngle(t, r),
                  l = t.v[r % t._length],
                  f = t.v[r === 0 ? t._length - 1 : r - 1],
                  u = t.v[(r + 1) % t._length],
                  c = a === 2 ? Math.sqrt(Math.pow(l[0] - f[0], 2) + Math.pow(l[1] - f[1], 2)) : 0,
                  v = a === 2 ? Math.sqrt(Math.pow(l[0] - u[0], 2) + Math.pow(l[1] - u[1], 2)) : 0;
              setPoint(e, t.v[r % t._length], o, s, n, v / (2 * (i + 1)), c / (2 * (i + 1)), a)
          }

          function zigZagSegment(e, t, r, n, i, a) {
              for (var s = 0; s < n; s += 1) {
                  var o = (s + 1) / (n + 1),
                      l = i === 2 ? Math.sqrt(Math.pow(t.points[3][0] - t.points[0][0], 2) + Math.pow(t.points[3][1] - t.points[0][1], 2)) : 0,
                      f = t.normalAngle(o);
                  setPoint(e, t.point(o), f, a, r, l / (2 * (n + 1)), l / (2 * (n + 1)), i), a = -a
              }
              return a
          }

          function linearOffset(e, t, r) {
              var n = Math.atan2(t[0] - e[0], t[1] - e[1]);
              return [polarOffset(e, n, r), polarOffset(t, n, r)]
          }

          function offsetSegment(e, t) {
              var r, n, i, a, s, o, l;
              r = (l = linearOffset(e.points[0], e.points[1], t))[0], n = l[1], i = (l = linearOffset(e.points[1], e.points[2], t))[0], a = l[1], s = (l = linearOffset(e.points[2], e.points[3], t))[0], o = l[1];
              var f = lineIntersection(r, n, i, a);
              f === null && (f = n);
              var u = lineIntersection(s, o, i, a);
              return u === null && (u = s), new PolynomialBezier(r, f, u, o)
          }

          function joinLines(e, t, r, n, i) {
              var a = t.points[3],
                  s = r.points[0];
              if (n === 3 || pointEqual(a, s)) return a;
              if (n === 2) {
                  var o = -t.tangentAngle(1),
                      l = -r.tangentAngle(0) + Math.PI,
                      f = lineIntersection(a, polarOffset(a, o + Math.PI / 2, 100), s, polarOffset(s, o + Math.PI / 2, 100)),
                      u = f ? pointDistance(f, a) : pointDistance(a, s) / 2,
                      c = polarOffset(a, o, 2 * u * roundCorner);
                  return e.setXYAt(c[0], c[1], "o", e.length() - 1), c = polarOffset(s, l, 2 * u * roundCorner), e.setTripleAt(s[0], s[1], s[0], s[1], c[0], c[1], e.length()), s
              }
              var v = lineIntersection(pointEqual(a, t.points[2]) ? t.points[0] : t.points[2], a, s, pointEqual(s, r.points[1]) ? r.points[3] : r.points[1]);
              return v && pointDistance(v, a) < i ? (e.setTripleAt(v[0], v[1], v[0], v[1], v[0], v[1], e.length()), v) : a
          }

          function getIntersection(e, t) {
              var r = e.intersections(t);
              return r.length && floatEqual(r[0][0], 1) && r.shift(), r.length ? r[0] : null
          }

          function pruneSegmentIntersection(e, t) {
              var r = e.slice(),
                  n = t.slice(),
                  i = getIntersection(e[e.length - 1], t[0]);
              return i && (r[e.length - 1] = e[e.length - 1].split(i[0])[0], n[0] = t[0].split(i[1])[1]), e.length > 1 && t.length > 1 && (i = getIntersection(e[0], t[t.length - 1])) ? [
                  [e[0].split(i[0])[0]],
                  [t[t.length - 1].split(i[1])[1]]
              ] : [r, n]
          }

          function pruneIntersections(e) {
              for (var t, r = 1; r < e.length; r += 1) t = pruneSegmentIntersection(e[r - 1], e[r]), e[r - 1] = t[0], e[r] = t[1];
              return e.length > 1 && (t = pruneSegmentIntersection(e[e.length - 1], e[0]), e[e.length - 1] = t[0], e[0] = t[1]), e
          }

          function offsetSegmentSplit(e, t) {
              var r, n, i, a, s = e.inflectionPoints();
              if (s.length === 0) return [offsetSegment(e, t)];
              if (s.length === 1 || floatEqual(s[1], 1)) return r = (i = e.split(s[0]))[0], n = i[1], [offsetSegment(r, t), offsetSegment(n, t)];
              r = (i = e.split(s[0]))[0];
              var o = (s[1] - s[0]) / (1 - s[0]);
              return a = (i = i[1].split(o))[0], n = i[1], [offsetSegment(r, t), offsetSegment(a, t), offsetSegment(n, t)]
          }

          function OffsetPathModifier() {}

          function getFontProperties(e) {
              for (var t = e.fStyle ? e.fStyle.split(" ") : [], r = "normal", n = "normal", i = t.length, a = 0; a < i; a += 1) switch (t[a].toLowerCase()) {
                  case "italic":
                      n = "italic";
                      break;
                  case "bold":
                      r = "700";
                      break;
                  case "black":
                      r = "900";
                      break;
                  case "medium":
                      r = "500";
                      break;
                  case "regular":
                  case "normal":
                      r = "400";
                      break;
                  case "light":
                  case "thin":
                      r = "200"
              }
              return {
                  style: n,
                  weight: e.fWeight || r
              }
          }
          extendPrototype([ShapeModifier], RepeaterModifier), RepeaterModifier.prototype.initModifierProperties = function(e, t) {
              this.getValue = this.processKeys, this.c = PropertyFactory.getProp(e, t.c, 0, null, this), this.o = PropertyFactory.getProp(e, t.o, 0, null, this), this.tr = TransformPropertyFactory.getTransformProperty(e, t.tr, this), this.so = PropertyFactory.getProp(e, t.tr.so, 0, .01, this), this.eo = PropertyFactory.getProp(e, t.tr.eo, 0, .01, this), this.data = t, this.dynamicProperties.length || this.getValue(!0), this._isAnimated = !!this.dynamicProperties.length, this.pMatrix = new Matrix, this.rMatrix = new Matrix, this.sMatrix = new Matrix, this.tMatrix = new Matrix, this.matrix = new Matrix
          }, RepeaterModifier.prototype.applyTransforms = function(e, t, r, n, i, a) {
              var s = a ? -1 : 1,
                  o = n.s.v[0] + (1 - n.s.v[0]) * (1 - i),
                  l = n.s.v[1] + (1 - n.s.v[1]) * (1 - i);
              e.translate(n.p.v[0] * s * i, n.p.v[1] * s * i, n.p.v[2]), t.translate(-n.a.v[0], -n.a.v[1], n.a.v[2]), t.rotate(-n.r.v * s * i), t.translate(n.a.v[0], n.a.v[1], n.a.v[2]), r.translate(-n.a.v[0], -n.a.v[1], n.a.v[2]), r.scale(a ? 1 / o : o, a ? 1 / l : l), r.translate(n.a.v[0], n.a.v[1], n.a.v[2])
          }, RepeaterModifier.prototype.init = function(e, t, r, n) {
              for (this.elem = e, this.arr = t, this.pos = r, this.elemsData = n, this._currentCopies = 0, this._elements = [], this._groups = [], this.frameId = -1, this.initDynamicPropertyContainer(e), this.initModifierProperties(e, t[r]); r > 0;) r -= 1, this._elements.unshift(t[r]);
              this.dynamicProperties.length ? this.k = !0 : this.getValue(!0)
          }, RepeaterModifier.prototype.resetElements = function(e) {
              var t, r = e.length;
              for (t = 0; t < r; t += 1) e[t]._processed = !1, e[t].ty === "gr" && this.resetElements(e[t].it)
          }, RepeaterModifier.prototype.cloneElements = function(e) {
              var t = JSON.parse(JSON.stringify(e));
              return this.resetElements(t), t
          }, RepeaterModifier.prototype.changeGroupRender = function(e, t) {
              var r, n = e.length;
              for (r = 0; r < n; r += 1) e[r]._render = t, e[r].ty === "gr" && this.changeGroupRender(e[r].it, t)
          }, RepeaterModifier.prototype.processShapes = function(e) {
              var t, r, n, i, a, s = !1;
              if (this._mdf || e) {
                  var o, l = Math.ceil(this.c.v);
                  if (this._groups.length < l) {
                      for (; this._groups.length < l;) {
                          var f = {
                              it: this.cloneElements(this._elements),
                              ty: "gr"
                          };
                          f.it.push({
                              a: {
                                  a: 0,
                                  ix: 1,
                                  k: [0, 0]
                              },
                              nm: "Transform",
                              o: {
                                  a: 0,
                                  ix: 7,
                                  k: 100
                              },
                              p: {
                                  a: 0,
                                  ix: 2,
                                  k: [0, 0]
                              },
                              r: {
                                  a: 1,
                                  ix: 6,
                                  k: [{
                                      s: 0,
                                      e: 0,
                                      t: 0
                                  }, {
                                      s: 0,
                                      e: 0,
                                      t: 1
                                  }]
                              },
                              s: {
                                  a: 0,
                                  ix: 3,
                                  k: [100, 100]
                              },
                              sa: {
                                  a: 0,
                                  ix: 5,
                                  k: 0
                              },
                              sk: {
                                  a: 0,
                                  ix: 4,
                                  k: 0
                              },
                              ty: "tr"
                          }), this.arr.splice(0, 0, f), this._groups.splice(0, 0, f), this._currentCopies += 1
                      }
                      this.elem.reloadShapes(), s = !0
                  }
                  for (a = 0, n = 0; n <= this._groups.length - 1; n += 1) {
                      if (o = a < l, this._groups[n]._render = o, this.changeGroupRender(this._groups[n].it, o), !o) {
                          var u = this.elemsData[n].it,
                              c = u[u.length - 1];
                          c.transform.op.v !== 0 ? (c.transform.op._mdf = !0, c.transform.op.v = 0) : c.transform.op._mdf = !1
                      }
                      a += 1
                  }
                  this._currentCopies = l;
                  var v = this.o.v,
                      d = v % 1,
                      p = v > 0 ? Math.floor(v) : Math.ceil(v),
                      m = this.pMatrix.props,
                      h = this.rMatrix.props,
                      g = this.sMatrix.props;
                  this.pMatrix.reset(), this.rMatrix.reset(), this.sMatrix.reset(), this.tMatrix.reset(), this.matrix.reset();
                  var y, b, _ = 0;
                  if (v > 0) {
                      for (; _ < p;) this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, 1, !1), _ += 1;
                      d && (this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, d, !1), _ += d)
                  } else if (v < 0) {
                      for (; _ > p;) this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, 1, !0), _ -= 1;
                      d && (this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, -d, !0), _ -= d)
                  }
                  for (n = this.data.m === 1 ? 0 : this._currentCopies - 1, i = this.data.m === 1 ? 1 : -1, a = this._currentCopies; a;) {
                      if (b = (r = (t = this.elemsData[n].it)[t.length - 1].transform.mProps.v.props)
                          .length, t[t.length - 1].transform.mProps._mdf = !0, t[t.length - 1].transform.op._mdf = !0, t[t.length - 1].transform.op.v = this._currentCopies === 1 ? this.so.v : this.so.v + (this.eo.v - this.so.v) * (n / (this._currentCopies - 1)), _ !== 0) {
                          for ((n !== 0 && i === 1 || n !== this._currentCopies - 1 && i === -1) && this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, 1, !1), this.matrix.transform(h[0], h[1], h[2], h[3], h[4], h[5], h[6], h[7], h[8], h[9], h[10], h[11], h[12], h[13], h[14], h[15]), this.matrix.transform(g[0], g[1], g[2], g[3], g[4], g[5], g[6], g[7], g[8], g[9], g[10], g[11], g[12], g[13], g[14], g[15]), this.matrix.transform(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11], m[12], m[13], m[14], m[15]), y = 0; y < b; y += 1) r[y] = this.matrix.props[y];
                          this.matrix.reset()
                      } else
                          for (this.matrix.reset(), y = 0; y < b; y += 1) r[y] = this.matrix.props[y];
                      _ += 1, a -= 1, n += i
                  }
              } else
                  for (a = this._currentCopies, n = 0, i = 1; a;) r = (t = this.elemsData[n].it)[t.length - 1].transform.mProps.v.props, t[t.length - 1].transform.mProps._mdf = !1, t[t.length - 1].transform.op._mdf = !1, a -= 1, n += i;
              return s
          }, RepeaterModifier.prototype.addShape = function() {}, extendPrototype([ShapeModifier], RoundCornersModifier), RoundCornersModifier.prototype.initModifierProperties = function(e, t) {
              this.getValue = this.processKeys, this.rd = PropertyFactory.getProp(e, t.r, 0, null, this), this._isAnimated = !!this.rd.effectsSequence.length
          }, RoundCornersModifier.prototype.processPath = function(e, t) {
              var r, n = shapePool.newElement();
              n.c = e.c;
              var i, a, s, o, l, f, u, c, v, d, p, m, h = e._length,
                  g = 0;
              for (r = 0; r < h; r += 1) i = e.v[r], s = e.o[r], a = e.i[r], i[0] === s[0] && i[1] === s[1] && i[0] === a[0] && i[1] === a[1] ? r !== 0 && r !== h - 1 || e.c ? (o = r === 0 ? e.v[h - 1] : e.v[r - 1], f = (l = Math.sqrt(Math.pow(i[0] - o[0], 2) + Math.pow(i[1] - o[1], 2))) ? Math.min(l / 2, t) / l : 0, u = p = i[0] + (o[0] - i[0]) * f, c = m = i[1] - (i[1] - o[1]) * f, v = u - (u - i[0]) * roundCorner, d = c - (c - i[1]) * roundCorner, n.setTripleAt(u, c, v, d, p, m, g), g += 1, o = r === h - 1 ? e.v[0] : e.v[r + 1], f = (l = Math.sqrt(Math.pow(i[0] - o[0], 2) + Math.pow(i[1] - o[1], 2))) ? Math.min(l / 2, t) / l : 0, u = v = i[0] + (o[0] - i[0]) * f, c = d = i[1] + (o[1] - i[1]) * f, p = u - (u - i[0]) * roundCorner, m = c - (c - i[1]) * roundCorner, n.setTripleAt(u, c, v, d, p, m, g), g += 1) : (n.setTripleAt(i[0], i[1], s[0], s[1], a[0], a[1], g), g += 1) : (n.setTripleAt(e.v[r][0], e.v[r][1], e.o[r][0], e.o[r][1], e.i[r][0], e.i[r][1], g), g += 1);
              return n
          }, RoundCornersModifier.prototype.processShapes = function(e) {
              var t, r, n, i, a, s, o = this.shapes.length,
                  l = this.rd.v;
              if (l !== 0)
                  for (r = 0; r < o; r += 1) {
                      if (s = (a = this.shapes[r])
                          .localShapeCollection, a.shape._mdf || this._mdf || e)
                          for (s.releaseShapes(), a.shape._mdf = !0, t = a.shape.paths.shapes, i = a.shape.paths._length, n = 0; n < i; n += 1) s.addShape(this.processPath(t[n], l));
                      a.shape.paths = a.localShapeCollection
                  }
              this.dynamicProperties.length || (this._mdf = !1)
          }, PolynomialBezier.prototype.point = function(e) {
              return [((this.a[0] * e + this.b[0]) * e + this.c[0]) * e + this.d[0], ((this.a[1] * e + this.b[1]) * e + this.c[1]) * e + this.d[1]]
          }, PolynomialBezier.prototype.derivative = function(e) {
              return [(3 * e * this.a[0] + 2 * this.b[0]) * e + this.c[0], (3 * e * this.a[1] + 2 * this.b[1]) * e + this.c[1]]
          }, PolynomialBezier.prototype.tangentAngle = function(e) {
              var t = this.derivative(e);
              return Math.atan2(t[1], t[0])
          }, PolynomialBezier.prototype.normalAngle = function(e) {
              var t = this.derivative(e);
              return Math.atan2(t[0], t[1])
          }, PolynomialBezier.prototype.inflectionPoints = function() {
              var e = this.a[1] * this.b[0] - this.a[0] * this.b[1];
              if (floatZero(e)) return [];
              var t = -.5 * (this.a[1] * this.c[0] - this.a[0] * this.c[1]) / e,
                  r = t * t - 1 / 3 * (this.b[1] * this.c[0] - this.b[0] * this.c[1]) / e;
              if (r < 0) return [];
              var n = Math.sqrt(r);
              return floatZero(n) ? n > 0 && n < 1 ? [t] : [] : [t - n, t + n].filter(function(i) {
                  return i > 0 && i < 1
              })
          }, PolynomialBezier.prototype.split = function(e) {
              if (e <= 0) return [singlePoint(this.points[0]), this];
              if (e >= 1) return [this, singlePoint(this.points[this.points.length - 1])];
              var t = lerpPoint(this.points[0], this.points[1], e),
                  r = lerpPoint(this.points[1], this.points[2], e),
                  n = lerpPoint(this.points[2], this.points[3], e),
                  i = lerpPoint(t, r, e),
                  a = lerpPoint(r, n, e),
                  s = lerpPoint(i, a, e);
              return [new PolynomialBezier(this.points[0], t, i, s, !0), new PolynomialBezier(s, a, n, this.points[3], !0)]
          }, PolynomialBezier.prototype.bounds = function() {
              return {
                  x: extrema(this, 0),
                  y: extrema(this, 1)
              }
          }, PolynomialBezier.prototype.boundingBox = function() {
              var e = this.bounds();
              return {
                  left: e.x.min,
                  right: e.x.max,
                  top: e.y.min,
                  bottom: e.y.max,
                  width: e.x.max - e.x.min,
                  height: e.y.max - e.y.min,
                  cx: (e.x.max + e.x.min) / 2,
                  cy: (e.y.max + e.y.min) / 2
              }
          }, PolynomialBezier.prototype.intersections = function(e, t, r) {
              t === void 0 && (t = 2), r === void 0 && (r = 7);
              var n = [];
              return intersectsImpl(intersectData(this, 0, 1), intersectData(e, 0, 1), 0, t, n, r), n
          }, PolynomialBezier.shapeSegment = function(e, t) {
              var r = (t + 1) % e.length();
              return new PolynomialBezier(e.v[t], e.o[t], e.i[r], e.v[r], !0)
          }, PolynomialBezier.shapeSegmentInverted = function(e, t) {
              var r = (t + 1) % e.length();
              return new PolynomialBezier(e.v[r], e.i[r], e.o[t], e.v[t], !0)
          }, extendPrototype([ShapeModifier], ZigZagModifier), ZigZagModifier.prototype.initModifierProperties = function(e, t) {
              this.getValue = this.processKeys, this.amplitude = PropertyFactory.getProp(e, t.s, 0, null, this), this.frequency = PropertyFactory.getProp(e, t.r, 0, null, this), this.pointsType = PropertyFactory.getProp(e, t.pt, 0, null, this), this._isAnimated = this.amplitude.effectsSequence.length !== 0 || this.frequency.effectsSequence.length !== 0 || this.pointsType.effectsSequence.length !== 0
          }, ZigZagModifier.prototype.processPath = function(e, t, r, n) {
              var i = e._length,
                  a = shapePool.newElement();
              if (a.c = e.c, e.c || (i -= 1), i === 0) return a;
              var s = -1,
                  o = PolynomialBezier.shapeSegment(e, 0);
              zigZagCorner(a, e, 0, t, r, n, s);
              for (var l = 0; l < i; l += 1) s = zigZagSegment(a, o, t, r, n, -s), o = l !== i - 1 || e.c ? PolynomialBezier.shapeSegment(e, (l + 1) % i) : null, zigZagCorner(a, e, l + 1, t, r, n, s);
              return a
          }, ZigZagModifier.prototype.processShapes = function(e) {
              var t, r, n, i, a, s, o = this.shapes.length,
                  l = this.amplitude.v,
                  f = Math.max(0, Math.round(this.frequency.v)),
                  u = this.pointsType.v;
              if (l !== 0)
                  for (r = 0; r < o; r += 1) {
                      if (s = (a = this.shapes[r])
                          .localShapeCollection, a.shape._mdf || this._mdf || e)
                          for (s.releaseShapes(), a.shape._mdf = !0, t = a.shape.paths.shapes, i = a.shape.paths._length, n = 0; n < i; n += 1) s.addShape(this.processPath(t[n], l, f, u));
                      a.shape.paths = a.localShapeCollection
                  }
              this.dynamicProperties.length || (this._mdf = !1)
          }, extendPrototype([ShapeModifier], OffsetPathModifier), OffsetPathModifier.prototype.initModifierProperties = function(e, t) {
              this.getValue = this.processKeys, this.amount = PropertyFactory.getProp(e, t.a, 0, null, this), this.miterLimit = PropertyFactory.getProp(e, t.ml, 0, null, this), this.lineJoin = t.lj, this._isAnimated = this.amount.effectsSequence.length !== 0
          }, OffsetPathModifier.prototype.processPath = function(e, t, r, n) {
              var i = shapePool.newElement();
              i.c = e.c;
              var a, s, o, l = e.length();
              e.c || (l -= 1);
              var f = [];
              for (a = 0; a < l; a += 1) o = PolynomialBezier.shapeSegment(e, a), f.push(offsetSegmentSplit(o, t));
              if (!e.c)
                  for (a = l - 1; a >= 0; a -= 1) o = PolynomialBezier.shapeSegmentInverted(e, a), f.push(offsetSegmentSplit(o, t));
              f = pruneIntersections(f);
              var u = null,
                  c = null;
              for (a = 0; a < f.length; a += 1) {
                  var v = f[a];
                  for (c && (u = joinLines(i, c, v[0], r, n)), c = v[v.length - 1], s = 0; s < v.length; s += 1) o = v[s], u && pointEqual(o.points[0], u) ? i.setXYAt(o.points[1][0], o.points[1][1], "o", i.length() - 1) : i.setTripleAt(o.points[0][0], o.points[0][1], o.points[1][0], o.points[1][1], o.points[0][0], o.points[0][1], i.length()), i.setTripleAt(o.points[3][0], o.points[3][1], o.points[3][0], o.points[3][1], o.points[2][0], o.points[2][1], i.length()), u = o.points[3]
              }
              return f.length && joinLines(i, c, f[0][0], r, n), i
          }, OffsetPathModifier.prototype.processShapes = function(e) {
              var t, r, n, i, a, s, o = this.shapes.length,
                  l = this.amount.v,
                  f = this.miterLimit.v,
                  u = this.lineJoin;
              if (l !== 0)
                  for (r = 0; r < o; r += 1) {
                      if (s = (a = this.shapes[r])
                          .localShapeCollection, a.shape._mdf || this._mdf || e)
                          for (s.releaseShapes(), a.shape._mdf = !0, t = a.shape.paths.shapes, i = a.shape.paths._length, n = 0; n < i; n += 1) s.addShape(this.processPath(t[n], l, u, f));
                      a.shape.paths = a.localShapeCollection
                  }
              this.dynamicProperties.length || (this._mdf = !1)
          };
          var FontManager = function() {
              var e = {
                      w: 0,
                      size: 0,
                      shapes: [],
                      data: {
                          shapes: []
                      }
                  },
                  t = [];
              t = t.concat([2304, 2305, 2306, 2307, 2362, 2363, 2364, 2364, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373, 2374, 2375, 2376, 2377, 2378, 2379, 2380, 2381, 2382, 2383, 2387, 2388, 2389, 2390, 2391, 2402, 2403]);
              var r = 127988,
                  n = ["d83cdffb", "d83cdffc", "d83cdffd", "d83cdffe", "d83cdfff"];

              function i(u, c) {
                  var v = createTag("span");
                  v.setAttribute("aria-hidden", !0), v.style.fontFamily = c;
                  var d = createTag("span");
                  d.innerText = "giItT1WQy@!-/#", v.style.position = "absolute", v.style.left = "-10000px", v.style.top = "-10000px", v.style.fontSize = "300px", v.style.fontVariant = "normal", v.style.fontStyle = "normal", v.style.fontWeight = "normal", v.style.letterSpacing = "0", v.appendChild(d), document.body.appendChild(v);
                  var p = d.offsetWidth;
                  return d.style.fontFamily = function(m) {
                      var h, g = m.split(","),
                          y = g.length,
                          b = [];
                      for (h = 0; h < y; h += 1) g[h] !== "sans-serif" && g[h] !== "monospace" && b.push(g[h]);
                      return b.join(",")
                  }(u) + ", " + c, {
                      node: d,
                      w: p,
                      parent: v
                  }
              }

              function a(u, c) {
                  var v, d = document.body && c ? "svg" : "canvas",
                      p = getFontProperties(u);
                  if (d === "svg") {
                      var m = createNS("text");
                      m.style.fontSize = "100px", m.setAttribute("font-family", u.fFamily), m.setAttribute("font-style", p.style), m.setAttribute("font-weight", p.weight), m.textContent = "1", u.fClass ? (m.style.fontFamily = "inherit", m.setAttribute("class", u.fClass)) : m.style.fontFamily = u.fFamily, c.appendChild(m), v = m
                  } else {
                      var h = new OffscreenCanvas(500, 500)
                          .getContext("2d");
                      h.font = p.style + " " + p.weight + " 100px " + u.fFamily, v = h
                  }
                  return {
                      measureText: function(g) {
                          return d === "svg" ? (v.textContent = g, v.getComputedTextLength()) : v.measureText(g)
                              .width
                      }
                  }
              }

              function s(u) {
                  var c = 0,
                      v = u.charCodeAt(0);
                  if (v >= 55296 && v <= 56319) {
                      var d = u.charCodeAt(1);
                      d >= 56320 && d <= 57343 && (c = 1024 * (v - 55296) + d - 56320 + 65536)
                  }
                  return c
              }

              function o(u) {
                  var c = s(u);
                  return c >= 127462 && c <= 127487
              }
              var l = function() {
                  this.fonts = [], this.chars = null, this.typekitLoaded = 0, this.isLoaded = !1, this._warned = !1, this.initTime = Date.now(), this.setIsLoadedBinded = this.setIsLoaded.bind(this), this.checkLoadedFontsBinded = this.checkLoadedFonts.bind(this)
              };
              l.isModifier = function(u, c) {
                  var v = u.toString(16) + c.toString(16);
                  return n.indexOf(v) !== -1
              }, l.isZeroWidthJoiner = function(u) {
                  return u === 8205
              }, l.isFlagEmoji = function(u) {
                  return o(u.substr(0, 2)) && o(u.substr(2, 2))
              }, l.isRegionalCode = o, l.isCombinedCharacter = function(u) {
                  return t.indexOf(u) !== -1
              }, l.isRegionalFlag = function(u, c) {
                  var v = s(u.substr(c, 2));
                  if (v !== r) return !1;
                  var d = 0;
                  for (c += 2; d < 5;) {
                      if ((v = s(u.substr(c, 2))) < 917601 || v > 917626) return !1;
                      d += 1, c += 2
                  }
                  return s(u.substr(c, 2)) === 917631
              }, l.isVariationSelector = function(u) {
                  return u === 65039
              }, l.BLACK_FLAG_CODE_POINT = r;
              var f = {
                  addChars: function(u) {
                      if (u) {
                          var c;
                          this.chars || (this.chars = []);
                          var v, d, p = u.length,
                              m = this.chars.length;
                          for (c = 0; c < p; c += 1) {
                              for (v = 0, d = !1; v < m;) this.chars[v].style === u[c].style && this.chars[v].fFamily === u[c].fFamily && this.chars[v].ch === u[c].ch && (d = !0), v += 1;
                              d || (this.chars.push(u[c]), m += 1)
                          }
                      }
                  },
                  addFonts: function(u, c) {
                      if (u) {
                          if (this.chars) return this.isLoaded = !0, void(this.fonts = u.list);
                          if (!document.body) return this.isLoaded = !0, u.list.forEach(function(C) {
                              C.helper = a(C), C.cache = {}
                          }), void(this.fonts = u.list);
                          var v, d = u.list,
                              p = d.length,
                              m = p;
                          for (v = 0; v < p; v += 1) {
                              var h, g, y = !0;
                              if (d[v].loaded = !1, d[v].monoCase = i(d[v].fFamily, "monospace"), d[v].sansCase = i(d[v].fFamily, "sans-serif"), d[v].fPath) {
                                  if (d[v].fOrigin === "p" || d[v].origin === 3) {
                                      if ((h = document.querySelectorAll('style[f-forigin="p"][f-family="' + d[v].fFamily + '"], style[f-origin="3"][f-family="' + d[v].fFamily + '"]'))
                                          .length > 0 && (y = !1), y) {
                                          var b = createTag("style");
                                          b.setAttribute("f-forigin", d[v].fOrigin), b.setAttribute("f-origin", d[v].origin), b.setAttribute("f-family", d[v].fFamily), b.type = "text/css", b.innerText = "@font-face {font-family: " + d[v].fFamily + "; font-style: normal; src: url('" + d[v].fPath + "');}", c.appendChild(b)
                                      }
                                  } else if (d[v].fOrigin === "g" || d[v].origin === 1) {
                                      for (h = document.querySelectorAll('link[f-forigin="g"], link[f-origin="1"]'), g = 0; g < h.length; g += 1) h[g].href.indexOf(d[v].fPath) !== -1 && (y = !1);
                                      if (y) {
                                          var _ = createTag("link");
                                          _.setAttribute("f-forigin", d[v].fOrigin), _.setAttribute("f-origin", d[v].origin), _.type = "text/css", _.rel = "stylesheet", _.href = d[v].fPath, document.body.appendChild(_)
                                      }
                                  } else if (d[v].fOrigin === "t" || d[v].origin === 2) {
                                      for (h = document.querySelectorAll('script[f-forigin="t"], script[f-origin="2"]'), g = 0; g < h.length; g += 1) d[v].fPath === h[g].src && (y = !1);
                                      if (y) {
                                          var I = createTag("link");
                                          I.setAttribute("f-forigin", d[v].fOrigin), I.setAttribute("f-origin", d[v].origin), I.setAttribute("rel", "stylesheet"), I.setAttribute("href", d[v].fPath), c.appendChild(I)
                                      }
                                  }
                              } else d[v].loaded = !0, m -= 1;
                              d[v].helper = a(d[v], c), d[v].cache = {}, this.fonts.push(d[v])
                          }
                          m === 0 ? this.isLoaded = !0 : setTimeout(this.checkLoadedFonts.bind(this), 100)
                      } else this.isLoaded = !0
                  },
                  getCharData: function(u, c, v) {
                      for (var d = 0, p = this.chars.length; d < p;) {
                          if (this.chars[d].ch === u && this.chars[d].style === c && this.chars[d].fFamily === v) return this.chars[d];
                          d += 1
                      }
                      return (typeof u == "string" && u.charCodeAt(0) !== 13 || !u) && console && console.warn && !this._warned && (this._warned = !0, console.warn("Missing character from exported characters list: ", u, c, v)), e
                  },
                  getFontByName: function(u) {
                      for (var c = 0, v = this.fonts.length; c < v;) {
                          if (this.fonts[c].fName === u) return this.fonts[c];
                          c += 1
                      }
                      return this.fonts[0]
                  },
                  measureText: function(u, c, v) {
                      var d = this.getFontByName(c),
                          p = u;
                      if (!d.cache[p]) {
                          var m = d.helper;
                          if (u === " ") {
                              var h = m.measureText("|" + u + "|"),
                                  g = m.measureText("||");
                              d.cache[p] = (h - g) / 100
                          } else d.cache[p] = m.measureText(u) / 100
                      }
                      return d.cache[p] * v
                  },
                  checkLoadedFonts: function() {
                      var u, c, v, d = this.fonts.length,
                          p = d;
                      for (u = 0; u < d; u += 1) this.fonts[u].loaded ? p -= 1 : this.fonts[u].fOrigin === "n" || this.fonts[u].origin === 0 ? this.fonts[u].loaded = !0 : (c = this.fonts[u].monoCase.node, v = this.fonts[u].monoCase.w, c.offsetWidth !== v ? (p -= 1, this.fonts[u].loaded = !0) : (c = this.fonts[u].sansCase.node, v = this.fonts[u].sansCase.w, c.offsetWidth !== v && (p -= 1, this.fonts[u].loaded = !0)), this.fonts[u].loaded && (this.fonts[u].sansCase.parent.parentNode.removeChild(this.fonts[u].sansCase.parent), this.fonts[u].monoCase.parent.parentNode.removeChild(this.fonts[u].monoCase.parent)));
                      p !== 0 && Date.now() - this.initTime < 5e3 ? setTimeout(this.checkLoadedFontsBinded, 20) : setTimeout(this.setIsLoadedBinded, 10)
                  },
                  setIsLoaded: function() {
                      this.isLoaded = !0
                  }
              };
              return l.prototype = f, l
          }();

          function SlotManager(e) {
              this.animationData = e
          }

          function slotFactory(e) {
              return new SlotManager(e)
          }

          function RenderableElement() {}
          SlotManager.prototype.getProp = function(e) {
              return this.animationData.slots && this.animationData.slots[e.sid] ? Object.assign(e, this.animationData.slots[e.sid].p) : e
          }, RenderableElement.prototype = {
              initRenderable: function() {
                  this.isInRange = !1, this.hidden = !1, this.isTransparent = !1, this.renderableComponents = []
              },
              addRenderableComponent: function(e) {
                  this.renderableComponents.indexOf(e) === -1 && this.renderableComponents.push(e)
              },
              removeRenderableComponent: function(e) {
                  this.renderableComponents.indexOf(e) !== -1 && this.renderableComponents.splice(this.renderableComponents.indexOf(e), 1)
              },
              prepareRenderableFrame: function(e) {
                  this.checkLayerLimits(e)
              },
              checkTransparency: function() {
                  this.finalTransform.mProp.o.v <= 0 ? !this.isTransparent && this.globalData.renderConfig.hideOnTransparent && (this.isTransparent = !0, this.hide()) : this.isTransparent && (this.isTransparent = !1, this.show())
              },
              checkLayerLimits: function(e) {
                  this.data.ip - this.data.st <= e && this.data.op - this.data.st > e ? this.isInRange !== !0 && (this.globalData._mdf = !0, this._mdf = !0, this.isInRange = !0, this.show()) : this.isInRange !== !1 && (this.globalData._mdf = !0, this.isInRange = !1, this.hide())
              },
              renderRenderable: function() {
                  var e, t = this.renderableComponents.length;
                  for (e = 0; e < t; e += 1) this.renderableComponents[e].renderFrame(this._isFirstFrame)
              },
              sourceRectAtTime: function() {
                  return {
                      top: 0,
                      left: 0,
                      width: 100,
                      height: 100
                  }
              },
              getLayerSize: function() {
                  return this.data.ty === 5 ? {
                      w: this.data.textData.width,
                      h: this.data.textData.height
                  } : {
                      w: this.data.width,
                      h: this.data.height
                  }
              }
          };
          var getBlendMode = (blendModeEnums = {
                  0: "source-over",
                  1: "multiply",
                  2: "screen",
                  3: "overlay",
                  4: "darken",
                  5: "lighten",
                  6: "color-dodge",
                  7: "color-burn",
                  8: "hard-light",
                  9: "soft-light",
                  10: "difference",
                  11: "exclusion",
                  12: "hue",
                  13: "saturation",
                  14: "color",
                  15: "luminosity"
              }, function(e) {
                  return blendModeEnums[e] || ""
              }),
              blendModeEnums;

          function SliderEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 0, 0, r)
          }

          function AngleEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 0, 0, r)
          }

          function ColorEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 1, 0, r)
          }

          function PointEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 1, 0, r)
          }

          function LayerIndexEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 0, 0, r)
          }

          function MaskIndexEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 0, 0, r)
          }

          function CheckboxEffect(e, t, r) {
              this.p = PropertyFactory.getProp(t, e.v, 0, 0, r)
          }

          function NoValueEffect() {
              this.p = {}
          }

          function EffectsManager(e, t) {
              var r, n = e.ef || [];
              this.effectElements = [];
              var i, a = n.length;
              for (r = 0; r < a; r += 1) i = new GroupEffect(n[r], t), this.effectElements.push(i)
          }

          function GroupEffect(e, t) {
              this.init(e, t)
          }

          function BaseElement() {}

          function FrameElement() {}

          function FootageElement(e, t, r) {
              this.initFrame(), this.initRenderable(), this.assetData = t.getAssetData(e.refId), this.footageData = t.imageLoader.getAsset(this.assetData), this.initBaseData(e, t, r)
          }

          function AudioElement(e, t, r) {
              this.initFrame(), this.initRenderable(), this.assetData = t.getAssetData(e.refId), this.initBaseData(e, t, r), this._isPlaying = !1, this._canPlay = !1;
              var n = this.globalData.getAssetsPath(this.assetData);
              this.audio = this.globalData.audioController.createAudio(n), this._currentTime = 0, this.globalData.audioController.addAudio(this), this._volumeMultiplier = 1, this._volume = 1, this._previousVolume = null, this.tm = e.tm ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this) : {
                  _placeholder: !0
              }, this.lv = PropertyFactory.getProp(this, e.au && e.au.lv ? e.au.lv : {
                  k: [100]
              }, 1, .01, this)
          }

          function BaseRenderer() {}
          extendPrototype([DynamicPropertyContainer], GroupEffect), GroupEffect.prototype.getValue = GroupEffect.prototype.iterateDynamicProperties, GroupEffect.prototype.init = function(e, t) {
              var r;
              this.data = e, this.effectElements = [], this.initDynamicPropertyContainer(t);
              var n, i = this.data.ef.length,
                  a = this.data.ef;
              for (r = 0; r < i; r += 1) {
                  switch (n = null, a[r].ty) {
                      case 0:
                          n = new SliderEffect(a[r], t, this);
                          break;
                      case 1:
                          n = new AngleEffect(a[r], t, this);
                          break;
                      case 2:
                          n = new ColorEffect(a[r], t, this);
                          break;
                      case 3:
                          n = new PointEffect(a[r], t, this);
                          break;
                      case 4:
                      case 7:
                          n = new CheckboxEffect(a[r], t, this);
                          break;
                      case 10:
                          n = new LayerIndexEffect(a[r], t, this);
                          break;
                      case 11:
                          n = new MaskIndexEffect(a[r], t, this);
                          break;
                      case 5:
                          n = new EffectsManager(a[r], t, this);
                          break;
                      default:
                          n = new NoValueEffect(a[r], t, this)
                  }
                  n && this.effectElements.push(n)
              }
          }, BaseElement.prototype = {
              checkMasks: function() {
                  if (!this.data.hasMask) return !1;
                  for (var e = 0, t = this.data.masksProperties.length; e < t;) {
                      if (this.data.masksProperties[e].mode !== "n" && this.data.masksProperties[e].cl !== !1) return !0;
                      e += 1
                  }
                  return !1
              },
              initExpressions: function() {
                  var e = getExpressionInterfaces();
                  if (e) {
                      var t = e("layer"),
                          r = e("effects"),
                          n = e("shape"),
                          i = e("text"),
                          a = e("comp");
                      this.layerInterface = t(this), this.data.hasMask && this.maskManager && this.layerInterface.registerMaskInterface(this.maskManager);
                      var s = r.createEffectsInterface(this, this.layerInterface);
                      this.layerInterface.registerEffectsInterface(s), this.data.ty === 0 || this.data.xt ? this.compInterface = a(this) : this.data.ty === 4 ? (this.layerInterface.shapeInterface = n(this.shapesData, this.itemsData, this.layerInterface), this.layerInterface.content = this.layerInterface.shapeInterface) : this.data.ty === 5 && (this.layerInterface.textInterface = i(this), this.layerInterface.text = this.layerInterface.textInterface)
                  }
              },
              setBlendMode: function() {
                  var e = getBlendMode(this.data.bm);
                  (this.baseElement || this.layerElement)
                  .style["mix-blend-mode"] = e
              },
              initBaseData: function(e, t, r) {
                  this.globalData = t, this.comp = r, this.data = e, this.layerId = createElementID(), this.data.sr || (this.data.sr = 1), this.effectsManager = new EffectsManager(this.data, this, this.dynamicProperties)
              },
              getType: function() {
                  return this.type
              },
              sourceRectAtTime: function() {}
          }, FrameElement.prototype = {
              initFrame: function() {
                  this._isFirstFrame = !1, this.dynamicProperties = [], this._mdf = !1
              },
              prepareProperties: function(e, t) {
                  var r, n = this.dynamicProperties.length;
                  for (r = 0; r < n; r += 1)(t || this._isParent && this.dynamicProperties[r].propType === "transform") && (this.dynamicProperties[r].getValue(), this.dynamicProperties[r]._mdf && (this.globalData._mdf = !0, this._mdf = !0))
              },
              addDynamicProperty: function(e) {
                  this.dynamicProperties.indexOf(e) === -1 && this.dynamicProperties.push(e)
              }
          }, FootageElement.prototype.prepareFrame = function() {}, extendPrototype([RenderableElement, BaseElement, FrameElement], FootageElement), FootageElement.prototype.getBaseElement = function() {
              return null
          }, FootageElement.prototype.renderFrame = function() {}, FootageElement.prototype.destroy = function() {}, FootageElement.prototype.initExpressions = function() {
              var e = getExpressionInterfaces();
              if (e) {
                  var t = e("footage");
                  this.layerInterface = t(this)
              }
          }, FootageElement.prototype.getFootageData = function() {
              return this.footageData
          }, AudioElement.prototype.prepareFrame = function(e) {
              if (this.prepareRenderableFrame(e, !0), this.prepareProperties(e, !0), this.tm._placeholder) this._currentTime = e / this.data.sr;
              else {
                  var t = this.tm.v;
                  this._currentTime = t
              }
              this._volume = this.lv.v[0];
              var r = this._volume * this._volumeMultiplier;
              this._previousVolume !== r && (this._previousVolume = r, this.audio.volume(r))
          }, extendPrototype([RenderableElement, BaseElement, FrameElement], AudioElement), AudioElement.prototype.renderFrame = function() {
              this.isInRange && this._canPlay && (this._isPlaying ? (!this.audio.playing() || Math.abs(this._currentTime / this.globalData.frameRate - this.audio.seek()) > .1) && this.audio.seek(this._currentTime / this.globalData.frameRate) : (this.audio.play(), this.audio.seek(this._currentTime / this.globalData.frameRate), this._isPlaying = !0))
          }, AudioElement.prototype.show = function() {}, AudioElement.prototype.hide = function() {
              this.audio.pause(), this._isPlaying = !1
          }, AudioElement.prototype.pause = function() {
              this.audio.pause(), this._isPlaying = !1, this._canPlay = !1
          }, AudioElement.prototype.resume = function() {
              this._canPlay = !0
          }, AudioElement.prototype.setRate = function(e) {
              this.audio.rate(e)
          }, AudioElement.prototype.volume = function(e) {
              this._volumeMultiplier = e, this._previousVolume = e * this._volume, this.audio.volume(this._previousVolume)
          }, AudioElement.prototype.getBaseElement = function() {
              return null
          }, AudioElement.prototype.destroy = function() {}, AudioElement.prototype.sourceRectAtTime = function() {}, AudioElement.prototype.initExpressions = function() {}, BaseRenderer.prototype.checkLayers = function(e) {
              var t, r, n = this.layers.length;
              for (this.completeLayers = !0, t = n - 1; t >= 0; t -= 1) this.elements[t] || (r = this.layers[t])
                  .ip - r.st <= e - this.layers[t].st && r.op - r.st > e - this.layers[t].st && this.buildItem(t), this.completeLayers = !!this.elements[t] && this.completeLayers;
              this.checkPendingElements()
          }, BaseRenderer.prototype.createItem = function(e) {
              switch (e.ty) {
                  case 2:
                      return this.createImage(e);
                  case 0:
                      return this.createComp(e);
                  case 1:
                      return this.createSolid(e);
                  case 3:
                  default:
                      return this.createNull(e);
                  case 4:
                      return this.createShape(e);
                  case 5:
                      return this.createText(e);
                  case 6:
                      return this.createAudio(e);
                  case 13:
                      return this.createCamera(e);
                  case 15:
                      return this.createFootage(e)
              }
          }, BaseRenderer.prototype.createCamera = function() {
              throw new Error("You're using a 3d camera. Try the html renderer.")
          }, BaseRenderer.prototype.createAudio = function(e) {
              return new AudioElement(e, this.globalData, this)
          }, BaseRenderer.prototype.createFootage = function(e) {
              return new FootageElement(e, this.globalData, this)
          }, BaseRenderer.prototype.buildAllItems = function() {
              var e, t = this.layers.length;
              for (e = 0; e < t; e += 1) this.buildItem(e);
              this.checkPendingElements()
          }, BaseRenderer.prototype.includeLayers = function(e) {
              var t;
              this.completeLayers = !1;
              var r, n = e.length,
                  i = this.layers.length;
              for (t = 0; t < n; t += 1)
                  for (r = 0; r < i;) {
                      if (this.layers[r].id === e[t].id) {
                          this.layers[r] = e[t];
                          break
                      }
                      r += 1
                  }
          }, BaseRenderer.prototype.setProjectInterface = function(e) {
              this.globalData.projectInterface = e
          }, BaseRenderer.prototype.initItems = function() {
              this.globalData.progressiveLoad || this.buildAllItems()
          }, BaseRenderer.prototype.buildElementParenting = function(e, t, r) {
              for (var n = this.elements, i = this.layers, a = 0, s = i.length; a < s;) i[a].ind == t && (n[a] && n[a] !== !0 ? (r.push(n[a]), n[a].setAsParent(), i[a].parent !== void 0 ? this.buildElementParenting(e, i[a].parent, r) : e.setHierarchy(r)) : (this.buildItem(a), this.addPendingElement(e))), a += 1
          }, BaseRenderer.prototype.addPendingElement = function(e) {
              this.pendingElements.push(e)
          }, BaseRenderer.prototype.searchExtraCompositions = function(e) {
              var t, r = e.length;
              for (t = 0; t < r; t += 1)
                  if (e[t].xt) {
                      var n = this.createComp(e[t]);
                      n.initExpressions(), this.globalData.projectInterface.registerComposition(n)
                  }
          }, BaseRenderer.prototype.getElementById = function(e) {
              var t, r = this.elements.length;
              for (t = 0; t < r; t += 1)
                  if (this.elements[t].data.ind === e) return this.elements[t];
              return null
          }, BaseRenderer.prototype.getElementByPath = function(e) {
              var t, r = e.shift();
              if (typeof r == "number") t = this.elements[r];
              else {
                  var n, i = this.elements.length;
                  for (n = 0; n < i; n += 1)
                      if (this.elements[n].data.nm === r) {
                          t = this.elements[n];
                          break
                      }
              }
              return e.length === 0 ? t : t.getElementByPath(e)
          }, BaseRenderer.prototype.setupGlobalData = function(e, t) {
              this.globalData.fontManager = new FontManager, this.globalData.slotManager = slotFactory(e), this.globalData.fontManager.addChars(e.chars), this.globalData.fontManager.addFonts(e.fonts, t), this.globalData.getAssetData = this.animationItem.getAssetData.bind(this.animationItem), this.globalData.getAssetsPath = this.animationItem.getAssetsPath.bind(this.animationItem), this.globalData.imageLoader = this.animationItem.imagePreloader, this.globalData.audioController = this.animationItem.audioController, this.globalData.frameId = 0, this.globalData.frameRate = e.fr, this.globalData.nm = e.nm, this.globalData.compSize = {
                  w: e.w,
                  h: e.h
              }
          };
          var effectTypes = {
              TRANSFORM_EFFECT: "transformEFfect"
          };

          function TransformElement() {}

          function MaskElement(e, t, r) {
              this.data = e, this.element = t, this.globalData = r, this.storedData = [], this.masksProperties = this.data.masksProperties || [], this.maskElement = null;
              var n, i, a = this.globalData.defs,
                  s = this.masksProperties ? this.masksProperties.length : 0;
              this.viewData = createSizedArray(s), this.solidPath = "";
              var o, l, f, u, c, v, d = this.masksProperties,
                  p = 0,
                  m = [],
                  h = createElementID(),
                  g = "clipPath",
                  y = "clip-path";
              for (n = 0; n < s; n += 1)
                  if ((d[n].mode !== "a" && d[n].mode !== "n" || d[n].inv || d[n].o.k !== 100 || d[n].o.x) && (g = "mask", y = "mask"), d[n].mode !== "s" && d[n].mode !== "i" || p !== 0 ? f = null : ((f = createNS("rect"))
                          .setAttribute("fill", "#ffffff"), f.setAttribute("width", this.element.comp.data.w || 0), f.setAttribute("height", this.element.comp.data.h || 0), m.push(f)), i = createNS("path"), d[n].mode === "n") this.viewData[n] = {
                      op: PropertyFactory.getProp(this.element, d[n].o, 0, .01, this.element),
                      prop: ShapePropertyFactory.getShapeProp(this.element, d[n], 3),
                      elem: i,
                      lastPath: ""
                  }, a.appendChild(i);
                  else {
                      var b;
                      if (p += 1, i.setAttribute("fill", d[n].mode === "s" ? "#000000" : "#ffffff"), i.setAttribute("clip-rule", "nonzero"), d[n].x.k !== 0 ? (g = "mask", y = "mask", v = PropertyFactory.getProp(this.element, d[n].x, 0, null, this.element), b = createElementID(), (u = createNS("filter"))
                              .setAttribute("id", b), (c = createNS("feMorphology"))
                              .setAttribute("operator", "erode"), c.setAttribute("in", "SourceGraphic"), c.setAttribute("radius", "0"), u.appendChild(c), a.appendChild(u), i.setAttribute("stroke", d[n].mode === "s" ? "#000000" : "#ffffff")) : (c = null, v = null), this.storedData[n] = {
                              elem: i,
                              x: v,
                              expan: c,
                              lastPath: "",
                              lastOperator: "",
                              filterId: b,
                              lastRadius: 0
                          }, d[n].mode === "i") {
                          l = m.length;
                          var _ = createNS("g");
                          for (o = 0; o < l; o += 1) _.appendChild(m[o]);
                          var I = createNS("mask");
                          I.setAttribute("mask-type", "alpha"), I.setAttribute("id", h + "_" + p), I.appendChild(i), a.appendChild(I), _.setAttribute("mask", "url(" + getLocationHref() + "#" + h + "_" + p + ")"), m.length = 0, m.push(_)
                      } else m.push(i);
                      d[n].inv && !this.solidPath && (this.solidPath = this.createLayerSolidPath()), this.viewData[n] = {
                          elem: i,
                          lastPath: "",
                          op: PropertyFactory.getProp(this.element, d[n].o, 0, .01, this.element),
                          prop: ShapePropertyFactory.getShapeProp(this.element, d[n], 3),
                          invRect: f
                      }, this.viewData[n].prop.k || this.drawPath(d[n], this.viewData[n].prop.v, this.viewData[n])
                  } for (this.maskElement = createNS(g), s = m.length, n = 0; n < s; n += 1) this.maskElement.appendChild(m[n]);
              p > 0 && (this.maskElement.setAttribute("id", h), this.element.maskedElement.setAttribute(y, "url(" + getLocationHref() + "#" + h + ")"), a.appendChild(this.maskElement)), this.viewData.length && this.element.addRenderableComponent(this)
          }
          TransformElement.prototype = {
              initTransform: function() {
                  var e = new Matrix;
                  this.finalTransform = {
                      mProp: this.data.ks ? TransformPropertyFactory.getTransformProperty(this, this.data.ks, this) : {
                          o: 0
                      },
                      _matMdf: !1,
                      _localMatMdf: !1,
                      _opMdf: !1,
                      mat: e,
                      localMat: e,
                      localOpacity: 1
                  }, this.data.ao && (this.finalTransform.mProp.autoOriented = !0), this.data.ty
              },
              renderTransform: function() {
                  if (this.finalTransform._opMdf = this.finalTransform.mProp.o._mdf || this._isFirstFrame, this.finalTransform._matMdf = this.finalTransform.mProp._mdf || this._isFirstFrame, this.hierarchy) {
                      var e, t = this.finalTransform.mat,
                          r = 0,
                          n = this.hierarchy.length;
                      if (!this.finalTransform._matMdf)
                          for (; r < n;) {
                              if (this.hierarchy[r].finalTransform.mProp._mdf) {
                                  this.finalTransform._matMdf = !0;
                                  break
                              }
                              r += 1
                          }
                      if (this.finalTransform._matMdf)
                          for (e = this.finalTransform.mProp.v.props, t.cloneFromProps(e), r = 0; r < n; r += 1) t.multiply(this.hierarchy[r].finalTransform.mProp.v)
                  }
                  this.finalTransform._matMdf && (this.finalTransform._localMatMdf = this.finalTransform._matMdf), this.finalTransform._opMdf && (this.finalTransform.localOpacity = this.finalTransform.mProp.o.v)
              },
              renderLocalTransform: function() {
                  if (this.localTransforms) {
                      var e = 0,
                          t = this.localTransforms.length;
                      if (this.finalTransform._localMatMdf = this.finalTransform._matMdf, !this.finalTransform._localMatMdf || !this.finalTransform._opMdf)
                          for (; e < t;) this.localTransforms[e]._mdf && (this.finalTransform._localMatMdf = !0), this.localTransforms[e]._opMdf && !this.finalTransform._opMdf && (this.finalTransform.localOpacity = this.finalTransform.mProp.o.v, this.finalTransform._opMdf = !0), e += 1;
                      if (this.finalTransform._localMatMdf) {
                          var r = this.finalTransform.localMat;
                          for (this.localTransforms[0].matrix.clone(r), e = 1; e < t; e += 1) {
                              var n = this.localTransforms[e].matrix;
                              r.multiply(n)
                          }
                          r.multiply(this.finalTransform.mat)
                      }
                      if (this.finalTransform._opMdf) {
                          var i = this.finalTransform.localOpacity;
                          for (e = 0; e < t; e += 1) i *= .01 * this.localTransforms[e].opacity;
                          this.finalTransform.localOpacity = i
                      }
                  }
              },
              searchEffectTransforms: function() {
                  if (this.renderableEffectsManager) {
                      var e = this.renderableEffectsManager.getEffects(effectTypes.TRANSFORM_EFFECT);
                      if (e.length) {
                          this.localTransforms = [], this.finalTransform.localMat = new Matrix;
                          var t = 0,
                              r = e.length;
                          for (t = 0; t < r; t += 1) this.localTransforms.push(e[t])
                      }
                  }
              },
              globalToLocal: function(e) {
                  var t = [];
                  t.push(this.finalTransform);
                  for (var r, n = !0, i = this.comp; n;) i.finalTransform ? (i.data.hasMask && t.splice(0, 0, i.finalTransform), i = i.comp) : n = !1;
                  var a, s = t.length;
                  for (r = 0; r < s; r += 1) a = t[r].mat.applyToPointArray(0, 0, 0), e = [e[0] - a[0], e[1] - a[1], 0];
                  return e
              },
              mHelper: new Matrix
          }, MaskElement.prototype.getMaskProperty = function(e) {
              return this.viewData[e].prop
          }, MaskElement.prototype.renderFrame = function(e) {
              var t, r = this.element.finalTransform.mat,
                  n = this.masksProperties.length;
              for (t = 0; t < n; t += 1)
                  if ((this.viewData[t].prop._mdf || e) && this.drawPath(this.masksProperties[t], this.viewData[t].prop.v, this.viewData[t]), (this.viewData[t].op._mdf || e) && this.viewData[t].elem.setAttribute("fill-opacity", this.viewData[t].op.v), this.masksProperties[t].mode !== "n" && (this.viewData[t].invRect && (this.element.finalTransform.mProp._mdf || e) && this.viewData[t].invRect.setAttribute("transform", r.getInverseMatrix()
                          .to2dCSS()), this.storedData[t].x && (this.storedData[t].x._mdf || e))) {
                      var i = this.storedData[t].expan;
                      this.storedData[t].x.v < 0 ? (this.storedData[t].lastOperator !== "erode" && (this.storedData[t].lastOperator = "erode", this.storedData[t].elem.setAttribute("filter", "url(" + getLocationHref() + "#" + this.storedData[t].filterId + ")")), i.setAttribute("radius", -this.storedData[t].x.v)) : (this.storedData[t].lastOperator !== "dilate" && (this.storedData[t].lastOperator = "dilate", this.storedData[t].elem.setAttribute("filter", null)), this.storedData[t].elem.setAttribute("stroke-width", 2 * this.storedData[t].x.v))
                  }
          }, MaskElement.prototype.getMaskelement = function() {
              return this.maskElement
          }, MaskElement.prototype.createLayerSolidPath = function() {
              var e = "M0,0 ";
              return e += " h" + this.globalData.compSize.w, e += " v" + this.globalData.compSize.h, e += " h-" + this.globalData.compSize.w, e += " v-" + this.globalData.compSize.h + " "
          }, MaskElement.prototype.drawPath = function(e, t, r) {
              var n, i, a = " M" + t.v[0][0] + "," + t.v[0][1];
              for (i = t._length, n = 1; n < i; n += 1) a += " C" + t.o[n - 1][0] + "," + t.o[n - 1][1] + " " + t.i[n][0] + "," + t.i[n][1] + " " + t.v[n][0] + "," + t.v[n][1];
              if (t.c && i > 1 && (a += " C" + t.o[n - 1][0] + "," + t.o[n - 1][1] + " " + t.i[0][0] + "," + t.i[0][1] + " " + t.v[0][0] + "," + t.v[0][1]), r.lastPath !== a) {
                  var s = "";
                  r.elem && (t.c && (s = e.inv ? this.solidPath + a : a), r.elem.setAttribute("d", s)), r.lastPath = a
              }
          }, MaskElement.prototype.destroy = function() {
              this.element = null, this.globalData = null, this.maskElement = null, this.data = null, this.masksProperties = null
          };
          var filtersFactory = function() {
                  var e = {};
                  return e.createFilter = function(t, r) {
                      var n = createNS("filter");
                      return n.setAttribute("id", t), r !== !0 && (n.setAttribute("filterUnits", "objectBoundingBox"), n.setAttribute("x", "0%"), n.setAttribute("y", "0%"), n.setAttribute("width", "100%"), n.setAttribute("height", "100%")), n
                  }, e.createAlphaToLuminanceFilter = function() {
                      var t = createNS("feColorMatrix");
                      return t.setAttribute("type", "matrix"), t.setAttribute("color-interpolation-filters", "sRGB"), t.setAttribute("values", "0 0 0 1 0  0 0 0 1 0  0 0 0 1 0  0 0 0 1 1"), t
                  }, e
              }(),
              featureSupport = function() {
                  var e = {
                      maskType: !0,
                      svgLumaHidden: !0,
                      offscreenCanvas: typeof OffscreenCanvas < "u"
                  };
                  return (/MSIE 10/i.test(navigator.userAgent) || /MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent) || /Edge\/\d./i.test(navigator.userAgent)) && (e.maskType = !1), /firefox/i.test(navigator.userAgent) && (e.svgLumaHidden = !1), e
              }(),
              registeredEffects$1 = {},
              idPrefix = "filter_result_";

          function SVGEffects(e) {
              var t, r, n = "SourceGraphic",
                  i = e.data.ef ? e.data.ef.length : 0,
                  a = createElementID(),
                  s = filtersFactory.createFilter(a, !0),
                  o = 0;
              for (this.filters = [], t = 0; t < i; t += 1) {
                  r = null;
                  var l = e.data.ef[t].ty;
                  registeredEffects$1[l] && (r = new registeredEffects$1[l].effect(s, e.effectsManager.effectElements[t], e, idPrefix + o, n), n = idPrefix + o, registeredEffects$1[l].countsAsEffect && (o += 1)), r && this.filters.push(r)
              }
              o && (e.globalData.defs.appendChild(s), e.layerElement.setAttribute("filter", "url(" + getLocationHref() + "#" + a + ")")), this.filters.length && e.addRenderableComponent(this)
          }

          function registerEffect$1(e, t, r) {
              registeredEffects$1[e] = {
                  effect: t,
                  countsAsEffect: r
              }
          }

          function SVGBaseElement() {}

          function HierarchyElement() {}

          function RenderableDOMElement() {}

          function IImageElement(e, t, r) {
              this.assetData = t.getAssetData(e.refId), this.assetData && this.assetData.sid && (this.assetData = t.slotManager.getProp(this.assetData)), this.initElement(e, t, r), this.sourceRect = {
                  top: 0,
                  left: 0,
                  width: this.assetData.w,
                  height: this.assetData.h
              }
          }

          function ProcessedElement(e, t) {
              this.elem = e, this.pos = t
          }

          function IShapeElement() {}
          SVGEffects.prototype.renderFrame = function(e) {
              var t, r = this.filters.length;
              for (t = 0; t < r; t += 1) this.filters[t].renderFrame(e)
          }, SVGEffects.prototype.getEffects = function(e) {
              var t, r = this.filters.length,
                  n = [];
              for (t = 0; t < r; t += 1) this.filters[t].type === e && n.push(this.filters[t]);
              return n
          }, SVGBaseElement.prototype = {
              initRendererElement: function() {
                  this.layerElement = createNS("g")
              },
              createContainerElements: function() {
                  this.matteElement = createNS("g"), this.transformedElement = this.layerElement, this.maskedElement = this.layerElement, this._sizeChanged = !1;
                  var e = null;
                  if (this.data.td) {
                      this.matteMasks = {};
                      var t = createNS("g");
                      t.setAttribute("id", this.layerId), t.appendChild(this.layerElement), e = t, this.globalData.defs.appendChild(t)
                  } else this.data.tt ? (this.matteElement.appendChild(this.layerElement), e = this.matteElement, this.baseElement = this.matteElement) : this.baseElement = this.layerElement;
                  if (this.data.ln && this.layerElement.setAttribute("id", this.data.ln), this.data.cl && this.layerElement.setAttribute("class", this.data.cl), this.data.ty === 0 && !this.data.hd) {
                      var r = createNS("clipPath"),
                          n = createNS("path");
                      n.setAttribute("d", "M0,0 L" + this.data.w + ",0 L" + this.data.w + "," + this.data.h + " L0," + this.data.h + "z");
                      var i = createElementID();
                      if (r.setAttribute("id", i), r.appendChild(n), this.globalData.defs.appendChild(r), this.checkMasks()) {
                          var a = createNS("g");
                          a.setAttribute("clip-path", "url(" + getLocationHref() + "#" + i + ")"), a.appendChild(this.layerElement), this.transformedElement = a, e ? e.appendChild(this.transformedElement) : this.baseElement = this.transformedElement
                      } else this.layerElement.setAttribute("clip-path", "url(" + getLocationHref() + "#" + i + ")")
                  }
                  this.data.bm !== 0 && this.setBlendMode()
              },
              renderElement: function() {
                  this.finalTransform._localMatMdf && this.transformedElement.setAttribute("transform", this.finalTransform.localMat.to2dCSS()), this.finalTransform._opMdf && this.transformedElement.setAttribute("opacity", this.finalTransform.localOpacity)
              },
              destroyBaseElement: function() {
                  this.layerElement = null, this.matteElement = null, this.maskManager.destroy()
              },
              getBaseElement: function() {
                  return this.data.hd ? null : this.baseElement
              },
              createRenderableComponents: function() {
                  this.maskManager = new MaskElement(this.data, this, this.globalData), this.renderableEffectsManager = new SVGEffects(this), this.searchEffectTransforms()
              },
              getMatte: function(e) {
                  if (this.matteMasks || (this.matteMasks = {}), !this.matteMasks[e]) {
                      var t, r, n, i, a = this.layerId + "_" + e;
                      if (e === 1 || e === 3) {
                          var s = createNS("mask");
                          s.setAttribute("id", a), s.setAttribute("mask-type", e === 3 ? "luminance" : "alpha"), (n = createNS("use"))
                              .setAttributeNS("http://www.w3.org/1999/xlink", "href", "#" + this.layerId), s.appendChild(n), this.globalData.defs.appendChild(s), featureSupport.maskType || e !== 1 || (s.setAttribute("mask-type", "luminance"), t = createElementID(), r = filtersFactory.createFilter(t), this.globalData.defs.appendChild(r), r.appendChild(filtersFactory.createAlphaToLuminanceFilter()), (i = createNS("g"))
                                  .appendChild(n), s.appendChild(i), i.setAttribute("filter", "url(" + getLocationHref() + "#" + t + ")"))
                      } else if (e === 2) {
                          var o = createNS("mask");
                          o.setAttribute("id", a), o.setAttribute("mask-type", "alpha");
                          var l = createNS("g");
                          o.appendChild(l), t = createElementID(), r = filtersFactory.createFilter(t);
                          var f = createNS("feComponentTransfer");
                          f.setAttribute("in", "SourceGraphic"), r.appendChild(f);
                          var u = createNS("feFuncA");
                          u.setAttribute("type", "table"), u.setAttribute("tableValues", "1.0 0.0"), f.appendChild(u), this.globalData.defs.appendChild(r);
                          var c = createNS("rect");
                          c.setAttribute("width", this.comp.data.w), c.setAttribute("height", this.comp.data.h), c.setAttribute("x", "0"), c.setAttribute("y", "0"), c.setAttribute("fill", "#ffffff"), c.setAttribute("opacity", "0"), l.setAttribute("filter", "url(" + getLocationHref() + "#" + t + ")"), l.appendChild(c), (n = createNS("use"))
                              .setAttributeNS("http://www.w3.org/1999/xlink", "href", "#" + this.layerId), l.appendChild(n), featureSupport.maskType || (o.setAttribute("mask-type", "luminance"), r.appendChild(filtersFactory.createAlphaToLuminanceFilter()), i = createNS("g"), l.appendChild(c), i.appendChild(this.layerElement), l.appendChild(i)), this.globalData.defs.appendChild(o)
                      }
                      this.matteMasks[e] = a
                  }
                  return this.matteMasks[e]
              },
              setMatte: function(e) {
                  this.matteElement && this.matteElement.setAttribute("mask", "url(" + getLocationHref() + "#" + e + ")")
              }
          }, HierarchyElement.prototype = {
              initHierarchy: function() {
                  this.hierarchy = [], this._isParent = !1, this.checkParenting()
              },
              setHierarchy: function(e) {
                  this.hierarchy = e
              },
              setAsParent: function() {
                  this._isParent = !0
              },
              checkParenting: function() {
                  this.data.parent !== void 0 && this.comp.buildElementParenting(this, this.data.parent, [])
              }
          }, extendPrototype([RenderableElement, createProxyFunction({
              initElement: function(e, t, r) {
                  this.initFrame(), this.initBaseData(e, t, r), this.initTransform(e, t, r), this.initHierarchy(), this.initRenderable(), this.initRendererElement(), this.createContainerElements(), this.createRenderableComponents(), this.createContent(), this.hide()
              },
              hide: function() {
                  this.hidden || this.isInRange && !this.isTransparent || ((this.baseElement || this.layerElement)
                      .style.display = "none", this.hidden = !0)
              },
              show: function() {
                  this.isInRange && !this.isTransparent && (this.data.hd || ((this.baseElement || this.layerElement)
                      .style.display = "block"), this.hidden = !1, this._isFirstFrame = !0)
              },
              renderFrame: function() {
                  this.data.hd || this.hidden || (this.renderTransform(), this.renderRenderable(), this.renderLocalTransform(), this.renderElement(), this.renderInnerContent(), this._isFirstFrame && (this._isFirstFrame = !1))
              },
              renderInnerContent: function() {},
              prepareFrame: function(e) {
                  this._mdf = !1, this.prepareRenderableFrame(e), this.prepareProperties(e, this.isInRange), this.checkTransparency()
              },
              destroy: function() {
                  this.innerElem = null, this.destroyBaseElement()
              }
          })], RenderableDOMElement), extendPrototype([BaseElement, TransformElement, SVGBaseElement, HierarchyElement, FrameElement, RenderableDOMElement], IImageElement), IImageElement.prototype.createContent = function() {
              var e = this.globalData.getAssetsPath(this.assetData);
              this.innerElem = createNS("image"), this.innerElem.setAttribute("width", this.assetData.w + "px"), this.innerElem.setAttribute("height", this.assetData.h + "px"), this.innerElem.setAttribute("preserveAspectRatio", this.assetData.pr || this.globalData.renderConfig.imagePreserveAspectRatio), this.innerElem.setAttributeNS("http://www.w3.org/1999/xlink", "href", e), this.layerElement.appendChild(this.innerElem)
          }, IImageElement.prototype.sourceRectAtTime = function() {
              return this.sourceRect
          }, IShapeElement.prototype = {
              addShapeToModifiers: function(e) {
                  var t, r = this.shapeModifiers.length;
                  for (t = 0; t < r; t += 1) this.shapeModifiers[t].addShape(e)
              },
              isShapeInAnimatedModifiers: function(e) {
                  for (var t = this.shapeModifiers.length; 0 < t;)
                      if (this.shapeModifiers[0].isAnimatedWithShape(e)) return !0;
                  return !1
              },
              renderModifiers: function() {
                  if (this.shapeModifiers.length) {
                      var e, t = this.shapes.length;
                      for (e = 0; e < t; e += 1) this.shapes[e].sh.reset();
                      for (e = (t = this.shapeModifiers.length) - 1; e >= 0 && !this.shapeModifiers[e].processShapes(this._isFirstFrame); e -= 1);
                  }
              },
              searchProcessedElement: function(e) {
                  for (var t = this.processedElements, r = 0, n = t.length; r < n;) {
                      if (t[r].elem === e) return t[r].pos;
                      r += 1
                  }
                  return 0
              },
              addProcessedElement: function(e, t) {
                  for (var r = this.processedElements, n = r.length; n;)
                      if (r[n -= 1].elem === e) return void(r[n].pos = t);
                  r.push(new ProcessedElement(e, t))
              },
              prepareFrame: function(e) {
                  this.prepareRenderableFrame(e), this.prepareProperties(e, this.isInRange)
              }
          };
          var lineCapEnum = {
                  1: "butt",
                  2: "round",
                  3: "square"
              },
              lineJoinEnum = {
                  1: "miter",
                  2: "round",
                  3: "bevel"
              };

          function SVGShapeData(e, t, r) {
              this.caches = [], this.styles = [], this.transformers = e, this.lStr = "", this.sh = r, this.lvl = t, this._isAnimated = !!r.k;
              for (var n = 0, i = e.length; n < i;) {
                  if (e[n].mProps.dynamicProperties.length) {
                      this._isAnimated = !0;
                      break
                  }
                  n += 1
              }
          }

          function SVGStyleData(e, t) {
              this.data = e, this.type = e.ty, this.d = "", this.lvl = t, this._mdf = !1, this.closed = e.hd === !0, this.pElem = createNS("path"), this.msElem = null
          }

          function DashProperty(e, t, r, n) {
              var i;
              this.elem = e, this.frameId = -1, this.dataProps = createSizedArray(t.length), this.renderer = r, this.k = !1, this.dashStr = "", this.dashArray = createTypedArray("float32", t.length ? t.length - 1 : 0), this.dashoffset = createTypedArray("float32", 1), this.initDynamicPropertyContainer(n);
              var a, s = t.length || 0;
              for (i = 0; i < s; i += 1) a = PropertyFactory.getProp(e, t[i].v, 0, 0, this), this.k = a.k || this.k, this.dataProps[i] = {
                  n: t[i].n,
                  p: a
              };
              this.k || this.getValue(!0), this._isAnimated = this.k
          }

          function SVGStrokeStyleData(e, t, r) {
              this.initDynamicPropertyContainer(e), this.getValue = this.iterateDynamicProperties, this.o = PropertyFactory.getProp(e, t.o, 0, .01, this), this.w = PropertyFactory.getProp(e, t.w, 0, null, this), this.d = new DashProperty(e, t.d || {}, "svg", this), this.c = PropertyFactory.getProp(e, t.c, 1, 255, this), this.style = r, this._isAnimated = !!this._isAnimated
          }

          function SVGFillStyleData(e, t, r) {
              this.initDynamicPropertyContainer(e), this.getValue = this.iterateDynamicProperties, this.o = PropertyFactory.getProp(e, t.o, 0, .01, this), this.c = PropertyFactory.getProp(e, t.c, 1, 255, this), this.style = r
          }

          function SVGNoStyleData(e, t, r) {
              this.initDynamicPropertyContainer(e), this.getValue = this.iterateDynamicProperties, this.style = r
          }

          function GradientProperty(e, t, r) {
              this.data = t, this.c = createTypedArray("uint8c", 4 * t.p);
              var n = t.k.k[0].s ? t.k.k[0].s.length - 4 * t.p : t.k.k.length - 4 * t.p;
              this.o = createTypedArray("float32", n), this._cmdf = !1, this._omdf = !1, this._collapsable = this.checkCollapsable(), this._hasOpacity = n, this.initDynamicPropertyContainer(r), this.prop = PropertyFactory.getProp(e, t.k, 1, null, this), this.k = this.prop.k, this.getValue(!0)
          }

          function SVGGradientFillStyleData(e, t, r) {
              this.initDynamicPropertyContainer(e), this.getValue = this.iterateDynamicProperties, this.initGradientData(e, t, r)
          }

          function SVGGradientStrokeStyleData(e, t, r) {
              this.initDynamicPropertyContainer(e), this.getValue = this.iterateDynamicProperties, this.w = PropertyFactory.getProp(e, t.w, 0, null, this), this.d = new DashProperty(e, t.d || {}, "svg", this), this.initGradientData(e, t, r), this._isAnimated = !!this._isAnimated
          }

          function ShapeGroupData() {
              this.it = [], this.prevViewData = [], this.gr = createNS("g")
          }

          function SVGTransformData(e, t, r) {
              this.transform = {
                  mProps: e,
                  op: t,
                  container: r
              }, this.elements = [], this._isAnimated = this.transform.mProps.dynamicProperties.length || this.transform.op.effectsSequence.length
          }
          SVGShapeData.prototype.setAsAnimated = function() {
              this._isAnimated = !0
          }, SVGStyleData.prototype.reset = function() {
              this.d = "", this._mdf = !1
          }, DashProperty.prototype.getValue = function(e) {
              if ((this.elem.globalData.frameId !== this.frameId || e) && (this.frameId = this.elem.globalData.frameId, this.iterateDynamicProperties(), this._mdf = this._mdf || e, this._mdf)) {
                  var t = 0,
                      r = this.dataProps.length;
                  for (this.renderer === "svg" && (this.dashStr = ""), t = 0; t < r; t += 1) this.dataProps[t].n !== "o" ? this.renderer === "svg" ? this.dashStr += " " + this.dataProps[t].p.v : this.dashArray[t] = this.dataProps[t].p.v : this.dashoffset[0] = this.dataProps[t].p.v
              }
          }, extendPrototype([DynamicPropertyContainer], DashProperty), extendPrototype([DynamicPropertyContainer], SVGStrokeStyleData), extendPrototype([DynamicPropertyContainer], SVGFillStyleData), extendPrototype([DynamicPropertyContainer], SVGNoStyleData), GradientProperty.prototype.comparePoints = function(e, t) {
              for (var r = 0, n = this.o.length / 2; r < n;) {
                  if (Math.abs(e[4 * r] - e[4 * t + 2 * r]) > .01) return !1;
                  r += 1
              }
              return !0
          }, GradientProperty.prototype.checkCollapsable = function() {
              if (this.o.length / 2 != this.c.length / 4) return !1;
              if (this.data.k.k[0].s)
                  for (var e = 0, t = this.data.k.k.length; e < t;) {
                      if (!this.comparePoints(this.data.k.k[e].s, this.data.p)) return !1;
                      e += 1
                  } else if (!this.comparePoints(this.data.k.k, this.data.p)) return !1;
              return !0
          }, GradientProperty.prototype.getValue = function(e) {
              if (this.prop.getValue(), this._mdf = !1, this._cmdf = !1, this._omdf = !1, this.prop._mdf || e) {
                  var t, r, n, i = 4 * this.data.p;
                  for (t = 0; t < i; t += 1) r = t % 4 == 0 ? 100 : 255, n = Math.round(this.prop.v[t] * r), this.c[t] !== n && (this.c[t] = n, this._cmdf = !e);
                  if (this.o.length)
                      for (i = this.prop.v.length, t = 4 * this.data.p; t < i; t += 1) r = t % 2 == 0 ? 100 : 1, n = t % 2 == 0 ? Math.round(100 * this.prop.v[t]) : this.prop.v[t], this.o[t - 4 * this.data.p] !== n && (this.o[t - 4 * this.data.p] = n, this._omdf = !e);
                  this._mdf = !e
              }
          }, extendPrototype([DynamicPropertyContainer], GradientProperty), SVGGradientFillStyleData.prototype.initGradientData = function(e, t, r) {
              this.o = PropertyFactory.getProp(e, t.o, 0, .01, this), this.s = PropertyFactory.getProp(e, t.s, 1, null, this), this.e = PropertyFactory.getProp(e, t.e, 1, null, this), this.h = PropertyFactory.getProp(e, t.h || {
                  k: 0
              }, 0, .01, this), this.a = PropertyFactory.getProp(e, t.a || {
                  k: 0
              }, 0, degToRads, this), this.g = new GradientProperty(e, t.g, this), this.style = r, this.stops = [], this.setGradientData(r.pElem, t), this.setGradientOpacity(t, r), this._isAnimated = !!this._isAnimated
          }, SVGGradientFillStyleData.prototype.setGradientData = function(e, t) {
              var r = createElementID(),
                  n = createNS(t.t === 1 ? "linearGradient" : "radialGradient");
              n.setAttribute("id", r), n.setAttribute("spreadMethod", "pad"), n.setAttribute("gradientUnits", "userSpaceOnUse");
              var i, a, s, o = [];
              for (s = 4 * t.g.p, a = 0; a < s; a += 4) i = createNS("stop"), n.appendChild(i), o.push(i);
              e.setAttribute(t.ty === "gf" ? "fill" : "stroke", "url(" + getLocationHref() + "#" + r + ")"), this.gf = n, this.cst = o
          }, SVGGradientFillStyleData.prototype.setGradientOpacity = function(e, t) {
              if (this.g._hasOpacity && !this.g._collapsable) {
                  var r, n, i, a = createNS("mask"),
                      s = createNS("path");
                  a.appendChild(s);
                  var o = createElementID(),
                      l = createElementID();
                  a.setAttribute("id", l);
                  var f = createNS(e.t === 1 ? "linearGradient" : "radialGradient");
                  f.setAttribute("id", o), f.setAttribute("spreadMethod", "pad"), f.setAttribute("gradientUnits", "userSpaceOnUse"), i = e.g.k.k[0].s ? e.g.k.k[0].s.length : e.g.k.k.length;
                  var u = this.stops;
                  for (n = 4 * e.g.p; n < i; n += 2)(r = createNS("stop"))
                      .setAttribute("stop-color", "rgb(255,255,255)"), f.appendChild(r), u.push(r);
                  s.setAttribute(e.ty === "gf" ? "fill" : "stroke", "url(" + getLocationHref() + "#" + o + ")"), e.ty === "gs" && (s.setAttribute("stroke-linecap", lineCapEnum[e.lc || 2]), s.setAttribute("stroke-linejoin", lineJoinEnum[e.lj || 2]), e.lj === 1 && s.setAttribute("stroke-miterlimit", e.ml)), this.of = f, this.ms = a, this.ost = u, this.maskId = l, t.msElem = s
              }
          }, extendPrototype([DynamicPropertyContainer], SVGGradientFillStyleData), extendPrototype([SVGGradientFillStyleData, DynamicPropertyContainer], SVGGradientStrokeStyleData);
          var buildShapeString = function(e, t, r, n) {
                  if (t === 0) return "";
                  var i, a = e.o,
                      s = e.i,
                      o = e.v,
                      l = " M" + n.applyToPointStringified(o[0][0], o[0][1]);
                  for (i = 1; i < t; i += 1) l += " C" + n.applyToPointStringified(a[i - 1][0], a[i - 1][1]) + " " + n.applyToPointStringified(s[i][0], s[i][1]) + " " + n.applyToPointStringified(o[i][0], o[i][1]);
                  return r && t && (l += " C" + n.applyToPointStringified(a[i - 1][0], a[i - 1][1]) + " " + n.applyToPointStringified(s[0][0], s[0][1]) + " " + n.applyToPointStringified(o[0][0], o[0][1]), l += "z"), l
              },
              SVGElementsRenderer = function() {
                  var e = new Matrix,
                      t = new Matrix;

                  function r(f, u, c) {
                      (c || u.transform.op._mdf) && u.transform.container.setAttribute("opacity", u.transform.op.v), (c || u.transform.mProps._mdf) && u.transform.container.setAttribute("transform", u.transform.mProps.v.to2dCSS())
                  }

                  function n() {}

                  function i(f, u, c) {
                      var v, d, p, m, h, g, y, b, _, I, C = u.styles.length,
                          x = u.lvl;
                      for (g = 0; g < C; g += 1) {
                          if (m = u.sh._mdf || c, u.styles[g].lvl < x) {
                              for (b = t.reset(), _ = x - u.styles[g].lvl, I = u.transformers.length - 1; !m && _ > 0;) m = u.transformers[I].mProps._mdf || m, _ -= 1, I -= 1;
                              if (m)
                                  for (_ = x - u.styles[g].lvl, I = u.transformers.length - 1; _ > 0;) b.multiply(u.transformers[I].mProps.v), _ -= 1, I -= 1
                          } else b = e;
                          if (d = (y = u.sh.paths)
                              ._length, m) {
                              for (p = "", v = 0; v < d; v += 1)(h = y.shapes[v]) && h._length && (p += buildShapeString(h, h._length, h.c, b));
                              u.caches[g] = p
                          } else p = u.caches[g];
                          u.styles[g].d += f.hd === !0 ? "" : p, u.styles[g]._mdf = m || u.styles[g]._mdf
                      }
                  }

                  function a(f, u, c) {
                      var v = u.style;
                      (u.c._mdf || c) && v.pElem.setAttribute("fill", "rgb(" + bmFloor(u.c.v[0]) + "," + bmFloor(u.c.v[1]) + "," + bmFloor(u.c.v[2]) + ")"), (u.o._mdf || c) && v.pElem.setAttribute("fill-opacity", u.o.v)
                  }

                  function s(f, u, c) {
                      o(f, u, c), l(f, u, c)
                  }

                  function o(f, u, c) {
                      var v, d, p, m, h, g = u.gf,
                          y = u.g._hasOpacity,
                          b = u.s.v,
                          _ = u.e.v;
                      if (u.o._mdf || c) {
                          var I = f.ty === "gf" ? "fill-opacity" : "stroke-opacity";
                          u.style.pElem.setAttribute(I, u.o.v)
                      }
                      if (u.s._mdf || c) {
                          var C = f.t === 1 ? "x1" : "cx",
                              x = C === "x1" ? "y1" : "cy";
                          g.setAttribute(C, b[0]), g.setAttribute(x, b[1]), y && !u.g._collapsable && (u.of.setAttribute(C, b[0]), u.of.setAttribute(x, b[1]))
                      }
                      if (u.g._cmdf || c) {
                          v = u.cst;
                          var O = u.g.c;
                          for (p = v.length, d = 0; d < p; d += 1)(m = v[d])
                              .setAttribute("offset", O[4 * d] + "%"), m.setAttribute("stop-color", "rgb(" + O[4 * d + 1] + "," + O[4 * d + 2] + "," + O[4 * d + 3] + ")")
                      }
                      if (y && (u.g._omdf || c)) {
                          var L = u.g.o;
                          for (p = (v = u.g._collapsable ? u.cst : u.ost)
                              .length, d = 0; d < p; d += 1) m = v[d], u.g._collapsable || m.setAttribute("offset", L[2 * d] + "%"), m.setAttribute("stop-opacity", L[2 * d + 1])
                      }
                      if (f.t === 1)(u.e._mdf || c) && (g.setAttribute("x2", _[0]), g.setAttribute("y2", _[1]), y && !u.g._collapsable && (u.of.setAttribute("x2", _[0]), u.of.setAttribute("y2", _[1])));
                      else if ((u.s._mdf || u.e._mdf || c) && (h = Math.sqrt(Math.pow(b[0] - _[0], 2) + Math.pow(b[1] - _[1], 2)), g.setAttribute("r", h), y && !u.g._collapsable && u.of.setAttribute("r", h)), u.e._mdf || u.h._mdf || u.a._mdf || c) {
                          h || (h = Math.sqrt(Math.pow(b[0] - _[0], 2) + Math.pow(b[1] - _[1], 2)));
                          var D = Math.atan2(_[1] - b[1], _[0] - b[0]),
                              A = u.h.v;
                          A >= 1 ? A = .99 : A <= -1 && (A = -.99);
                          var q = h * A,
                              w = Math.cos(D + u.a.v) * q + b[0],
                              F = Math.sin(D + u.a.v) * q + b[1];
                          g.setAttribute("fx", w), g.setAttribute("fy", F), y && !u.g._collapsable && (u.of.setAttribute("fx", w), u.of.setAttribute("fy", F))
                      }
                  }

                  function l(f, u, c) {
                      var v = u.style,
                          d = u.d;
                      d && (d._mdf || c) && d.dashStr && (v.pElem.setAttribute("stroke-dasharray", d.dashStr), v.pElem.setAttribute("stroke-dashoffset", d.dashoffset[0])), u.c && (u.c._mdf || c) && v.pElem.setAttribute("stroke", "rgb(" + bmFloor(u.c.v[0]) + "," + bmFloor(u.c.v[1]) + "," + bmFloor(u.c.v[2]) + ")"), (u.o._mdf || c) && v.pElem.setAttribute("stroke-opacity", u.o.v), (u.w._mdf || c) && (v.pElem.setAttribute("stroke-width", u.w.v), v.msElem && v.msElem.setAttribute("stroke-width", u.w.v))
                  }
                  return {
                      createRenderFunction: function(f) {
                          switch (f.ty) {
                              case "fl":
                                  return a;
                              case "gf":
                                  return o;
                              case "gs":
                                  return s;
                              case "st":
                                  return l;
                              case "sh":
                              case "el":
                              case "rc":
                              case "sr":
                                  return i;
                              case "tr":
                                  return r;
                              case "no":
                                  return n;
                              default:
                                  return null
                          }
                      }
                  }
              }();

          function SVGShapeElement(e, t, r) {
              this.shapes = [], this.shapesData = e.shapes, this.stylesList = [], this.shapeModifiers = [], this.itemsData = [], this.processedElements = [], this.animatedContents = [], this.initElement(e, t, r), this.prevViewData = []
          }

          function LetterProps(e, t, r, n, i, a) {
              this.o = e, this.sw = t, this.sc = r, this.fc = n, this.m = i, this.p = a, this._mdf = {
                  o: !0,
                  sw: !!t,
                  sc: !!r,
                  fc: !!n,
                  m: !0,
                  p: !0
              }
          }

          function TextProperty(e, t) {
              this._frameId = initialDefaultFrame, this.pv = "", this.v = "", this.kf = !1, this._isFirstFrame = !0, this._mdf = !1, t.d && t.d.sid && (t.d = e.globalData.slotManager.getProp(t.d)), this.data = t, this.elem = e, this.comp = this.elem.comp, this.keysIndex = 0, this.canResize = !1, this.minimumFontSize = 1, this.effectsSequence = [], this.currentData = {
                  ascent: 0,
                  boxWidth: this.defaultBoxWidth,
                  f: "",
                  fStyle: "",
                  fWeight: "",
                  fc: "",
                  j: "",
                  justifyOffset: "",
                  l: [],
                  lh: 0,
                  lineWidths: [],
                  ls: "",
                  of: "",
                  s: "",
                  sc: "",
                  sw: 0,
                  t: 0,
                  tr: 0,
                  sz: 0,
                  ps: null,
                  fillColorAnim: !1,
                  strokeColorAnim: !1,
                  strokeWidthAnim: !1,
                  yOffset: 0,
                  finalSize: 0,
                  finalText: [],
                  finalLineHeight: 0,
                  __complete: !1
              }, this.copyData(this.currentData, this.data.d.k[0].s), this.searchProperty() || this.completeTextData(this.currentData)
          }
          extendPrototype([BaseElement, TransformElement, SVGBaseElement, IShapeElement, HierarchyElement, FrameElement, RenderableDOMElement], SVGShapeElement), SVGShapeElement.prototype.initSecondaryElement = function() {}, SVGShapeElement.prototype.identityMatrix = new Matrix, SVGShapeElement.prototype.buildExpressionInterface = function() {}, SVGShapeElement.prototype.createContent = function() {
              this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, this.layerElement, 0, [], !0), this.filterUniqueShapes()
          }, SVGShapeElement.prototype.filterUniqueShapes = function() {
              var e, t, r, n, i = this.shapes.length,
                  a = this.stylesList.length,
                  s = [],
                  o = !1;
              for (r = 0; r < a; r += 1) {
                  for (n = this.stylesList[r], o = !1, s.length = 0, e = 0; e < i; e += 1)(t = this.shapes[e])
                      .styles.indexOf(n) !== -1 && (s.push(t), o = t._isAnimated || o);
                  s.length > 1 && o && this.setShapesAsAnimated(s)
              }
          }, SVGShapeElement.prototype.setShapesAsAnimated = function(e) {
              var t, r = e.length;
              for (t = 0; t < r; t += 1) e[t].setAsAnimated()
          }, SVGShapeElement.prototype.createStyleElement = function(e, t) {
              var r, n = new SVGStyleData(e, t),
                  i = n.pElem;
              return e.ty === "st" ? r = new SVGStrokeStyleData(this, e, n) : e.ty === "fl" ? r = new SVGFillStyleData(this, e, n) : e.ty === "gf" || e.ty === "gs" ? (r = new(e.ty === "gf" ? SVGGradientFillStyleData : SVGGradientStrokeStyleData)(this, e, n), this.globalData.defs.appendChild(r.gf), r.maskId && (this.globalData.defs.appendChild(r.ms), this.globalData.defs.appendChild(r.of), i.setAttribute("mask", "url(" + getLocationHref() + "#" + r.maskId + ")"))) : e.ty === "no" && (r = new SVGNoStyleData(this, e, n)), e.ty !== "st" && e.ty !== "gs" || (i.setAttribute("stroke-linecap", lineCapEnum[e.lc || 2]), i.setAttribute("stroke-linejoin", lineJoinEnum[e.lj || 2]), i.setAttribute("fill-opacity", "0"), e.lj === 1 && i.setAttribute("stroke-miterlimit", e.ml)), e.r === 2 && i.setAttribute("fill-rule", "evenodd"), e.ln && i.setAttribute("id", e.ln), e.cl && i.setAttribute("class", e.cl), e.bm && (i.style["mix-blend-mode"] = getBlendMode(e.bm)), this.stylesList.push(n), this.addToAnimatedContents(e, r), r
          }, SVGShapeElement.prototype.createGroupElement = function(e) {
              var t = new ShapeGroupData;
              return e.ln && t.gr.setAttribute("id", e.ln), e.cl && t.gr.setAttribute("class", e.cl), e.bm && (t.gr.style["mix-blend-mode"] = getBlendMode(e.bm)), t
          }, SVGShapeElement.prototype.createTransformElement = function(e, t) {
              var r = TransformPropertyFactory.getTransformProperty(this, e, this),
                  n = new SVGTransformData(r, r.o, t);
              return this.addToAnimatedContents(e, n), n
          }, SVGShapeElement.prototype.createShapeElement = function(e, t, r) {
              var n = 4;
              e.ty === "rc" ? n = 5 : e.ty === "el" ? n = 6 : e.ty === "sr" && (n = 7);
              var i = new SVGShapeData(t, r, ShapePropertyFactory.getShapeProp(this, e, n, this));
              return this.shapes.push(i), this.addShapeToModifiers(i), this.addToAnimatedContents(e, i), i
          }, SVGShapeElement.prototype.addToAnimatedContents = function(e, t) {
              for (var r = 0, n = this.animatedContents.length; r < n;) {
                  if (this.animatedContents[r].element === t) return;
                  r += 1
              }
              this.animatedContents.push({
                  fn: SVGElementsRenderer.createRenderFunction(e),
                  element: t,
                  data: e
              })
          }, SVGShapeElement.prototype.setElementStyles = function(e) {
              var t, r = e.styles,
                  n = this.stylesList.length;
              for (t = 0; t < n; t += 1) this.stylesList[t].closed || r.push(this.stylesList[t])
          }, SVGShapeElement.prototype.reloadShapes = function() {
              var e;
              this._isFirstFrame = !0;
              var t = this.itemsData.length;
              for (e = 0; e < t; e += 1) this.prevViewData[e] = this.itemsData[e];
              for (this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, this.layerElement, 0, [], !0), this.filterUniqueShapes(), t = this.dynamicProperties.length, e = 0; e < t; e += 1) this.dynamicProperties[e].getValue();
              this.renderModifiers()
          }, SVGShapeElement.prototype.searchShapes = function(e, t, r, n, i, a, s) {
              var o, l, f, u, c, v, d = [].concat(a),
                  p = e.length - 1,
                  m = [],
                  h = [];
              for (o = p; o >= 0; o -= 1) {
                  if ((v = this.searchProcessedElement(e[o])) ? t[o] = r[v - 1] : e[o]._render = s, e[o].ty === "fl" || e[o].ty === "st" || e[o].ty === "gf" || e[o].ty === "gs" || e[o].ty === "no") v ? t[o].style.closed = !1 : t[o] = this.createStyleElement(e[o], i), e[o]._render && t[o].style.pElem.parentNode !== n && n.appendChild(t[o].style.pElem), m.push(t[o].style);
                  else if (e[o].ty === "gr") {
                      if (v)
                          for (f = t[o].it.length, l = 0; l < f; l += 1) t[o].prevViewData[l] = t[o].it[l];
                      else t[o] = this.createGroupElement(e[o]);
                      this.searchShapes(e[o].it, t[o].it, t[o].prevViewData, t[o].gr, i + 1, d, s), e[o]._render && t[o].gr.parentNode !== n && n.appendChild(t[o].gr)
                  } else e[o].ty === "tr" ? (v || (t[o] = this.createTransformElement(e[o], n)), u = t[o].transform, d.push(u)) : e[o].ty === "sh" || e[o].ty === "rc" || e[o].ty === "el" || e[o].ty === "sr" ? (v || (t[o] = this.createShapeElement(e[o], d, i)), this.setElementStyles(t[o])) : e[o].ty === "tm" || e[o].ty === "rd" || e[o].ty === "ms" || e[o].ty === "pb" || e[o].ty === "zz" || e[o].ty === "op" ? (v ? (c = t[o])
                      .closed = !1 : ((c = ShapeModifiers.getModifier(e[o].ty))
                          .init(this, e[o]), t[o] = c, this.shapeModifiers.push(c)), h.push(c)) : e[o].ty === "rp" && (v ? (c = t[o])
                      .closed = !0 : (c = ShapeModifiers.getModifier(e[o].ty), t[o] = c, c.init(this, e, o, t), this.shapeModifiers.push(c), s = !1), h.push(c));
                  this.addProcessedElement(e[o], o + 1)
              }
              for (p = m.length, o = 0; o < p; o += 1) m[o].closed = !0;
              for (p = h.length, o = 0; o < p; o += 1) h[o].closed = !0
          }, SVGShapeElement.prototype.renderInnerContent = function() {
              var e;
              this.renderModifiers();
              var t = this.stylesList.length;
              for (e = 0; e < t; e += 1) this.stylesList[e].reset();
              for (this.renderShape(), e = 0; e < t; e += 1)(this.stylesList[e]._mdf || this._isFirstFrame) && (this.stylesList[e].msElem && (this.stylesList[e].msElem.setAttribute("d", this.stylesList[e].d), this.stylesList[e].d = "M0 0" + this.stylesList[e].d), this.stylesList[e].pElem.setAttribute("d", this.stylesList[e].d || "M0 0"))
          }, SVGShapeElement.prototype.renderShape = function() {
              var e, t, r = this.animatedContents.length;
              for (e = 0; e < r; e += 1) t = this.animatedContents[e], (this._isFirstFrame || t.element._isAnimated) && t.data !== !0 && t.fn(t.data, t.element, this._isFirstFrame)
          }, SVGShapeElement.prototype.destroy = function() {
              this.destroyBaseElement(), this.shapesData = null, this.itemsData = null
          }, LetterProps.prototype.update = function(e, t, r, n, i, a) {
              this._mdf.o = !1, this._mdf.sw = !1, this._mdf.sc = !1, this._mdf.fc = !1, this._mdf.m = !1, this._mdf.p = !1;
              var s = !1;
              return this.o !== e && (this.o = e, this._mdf.o = !0, s = !0), this.sw !== t && (this.sw = t, this._mdf.sw = !0, s = !0), this.sc !== r && (this.sc = r, this._mdf.sc = !0, s = !0), this.fc !== n && (this.fc = n, this._mdf.fc = !0, s = !0), this.m !== i && (this.m = i, this._mdf.m = !0, s = !0), !a.length || this.p[0] === a[0] && this.p[1] === a[1] && this.p[4] === a[4] && this.p[5] === a[5] && this.p[12] === a[12] && this.p[13] === a[13] || (this.p = a, this._mdf.p = !0, s = !0), s
          }, TextProperty.prototype.defaultBoxWidth = [0, 0], TextProperty.prototype.copyData = function(e, t) {
              for (var r in t) Object.prototype.hasOwnProperty.call(t, r) && (e[r] = t[r]);
              return e
          }, TextProperty.prototype.setCurrentData = function(e) {
              e.__complete || this.completeTextData(e), this.currentData = e, this.currentData.boxWidth = this.currentData.boxWidth || this.defaultBoxWidth, this._mdf = !0
          }, TextProperty.prototype.searchProperty = function() {
              return this.searchKeyframes()
          }, TextProperty.prototype.searchKeyframes = function() {
              return this.kf = this.data.d.k.length > 1, this.kf && this.addEffect(this.getKeyframeValue.bind(this)), this.kf
          }, TextProperty.prototype.addEffect = function(e) {
              this.effectsSequence.push(e), this.elem.addDynamicProperty(this)
          }, TextProperty.prototype.getValue = function(e) {
              if (this.elem.globalData.frameId !== this.frameId && this.effectsSequence.length || e) {
                  this.currentData.t = this.data.d.k[this.keysIndex].s.t;
                  var t = this.currentData,
                      r = this.keysIndex;
                  if (this.lock) this.setCurrentData(this.currentData);
                  else {
                      var n;
                      this.lock = !0, this._mdf = !1;
                      var i = this.effectsSequence.length,
                          a = e || this.data.d.k[this.keysIndex].s;
                      for (n = 0; n < i; n += 1) a = r !== this.keysIndex ? this.effectsSequence[n](a, a.t) : this.effectsSequence[n](this.currentData, a.t);
                      t !== a && this.setCurrentData(a), this.v = this.currentData, this.pv = this.v, this.lock = !1, this.frameId = this.elem.globalData.frameId
                  }
              }
          }, TextProperty.prototype.getKeyframeValue = function() {
              for (var e = this.data.d.k, t = this.elem.comp.renderedFrame, r = 0, n = e.length; r <= n - 1 && !(r === n - 1 || e[r + 1].t > t);) r += 1;
              return this.keysIndex !== r && (this.keysIndex = r), this.data.d.k[this.keysIndex].s
          }, TextProperty.prototype.buildFinalText = function(e) {
              for (var t, r, n = [], i = 0, a = e.length, s = !1, o = !1, l = ""; i < a;) s = o, o = !1, t = e.charCodeAt(i), l = e.charAt(i), FontManager.isCombinedCharacter(t) ? s = !0 : t >= 55296 && t <= 56319 ? FontManager.isRegionalFlag(e, i) ? l = e.substr(i, 14) : (r = e.charCodeAt(i + 1)) >= 56320 && r <= 57343 && (FontManager.isModifier(t, r) ? (l = e.substr(i, 2), s = !0) : l = FontManager.isFlagEmoji(e.substr(i, 4)) ? e.substr(i, 4) : e.substr(i, 2)) : t > 56319 ? (r = e.charCodeAt(i + 1), FontManager.isVariationSelector(t) && (s = !0)) : FontManager.isZeroWidthJoiner(t) && (s = !0, o = !0), s ? (n[n.length - 1] += l, s = !1) : n.push(l), i += l.length;
              return n
          }, TextProperty.prototype.completeTextData = function(e) {
              e.__complete = !0;
              var t, r, n, i, a, s, o, l = this.elem.globalData.fontManager,
                  f = this.data,
                  u = [],
                  c = 0,
                  v = f.m.g,
                  d = 0,
                  p = 0,
                  m = 0,
                  h = [],
                  g = 0,
                  y = 0,
                  b = l.getFontByName(e.f),
                  _ = 0,
                  I = getFontProperties(b);
              e.fWeight = I.weight, e.fStyle = I.style, e.finalSize = e.s, e.finalText = this.buildFinalText(e.t), r = e.finalText.length, e.finalLineHeight = e.lh;
              var C, x = e.tr / 1e3 * e.finalSize;
              if (e.sz)
                  for (var O, L, D = !0, A = e.sz[0], q = e.sz[1]; D;) {
                      O = 0, g = 0, r = (L = this.buildFinalText(e.t))
                          .length, x = e.tr / 1e3 * e.finalSize;
                      var w = -1;
                      for (t = 0; t < r; t += 1) C = L[t].charCodeAt(0), n = !1, L[t] === " " ? w = t : C !== 13 && C !== 3 || (g = 0, n = !0, O += e.finalLineHeight || 1.2 * e.finalSize), l.chars ? (o = l.getCharData(L[t], b.fStyle, b.fFamily), _ = n ? 0 : o.w * e.finalSize / 100) : _ = l.measureText(L[t], e.f, e.finalSize), g + _ > A && L[t] !== " " ? (w === -1 ? r += 1 : t = w, O += e.finalLineHeight || 1.2 * e.finalSize, L.splice(t, w === t ? 1 : 0, "\r"), w = -1, g = 0) : (g += _, g += x);
                      O += b.ascent * e.finalSize / 100, this.canResize && e.finalSize > this.minimumFontSize && q < O ? (e.finalSize -= 1, e.finalLineHeight = e.finalSize * e.lh / e.s) : (e.finalText = L, r = e.finalText.length, D = !1)
                  }
              g = -x, _ = 0;
              var F, k = 0;
              for (t = 0; t < r; t += 1)
                  if (n = !1, (C = (F = e.finalText[t])
                          .charCodeAt(0)) === 13 || C === 3 ? (k = 0, h.push(g), y = g > y ? g : y, g = -2 * x, i = "", n = !0, m += 1) : i = F, l.chars ? (o = l.getCharData(F, b.fStyle, l.getFontByName(e.f)
                          .fFamily), _ = n ? 0 : o.w * e.finalSize / 100) : _ = l.measureText(i, e.f, e.finalSize), F === " " ? k += _ + x : (g += _ + x + k, k = 0), u.push({
                          l: _,
                          an: _,
                          add: d,
                          n,
                          anIndexes: [],
                          val: i,
                          line: m,
                          animatorJustifyOffset: 0
                      }), v == 2) {
                      if (d += _, i === "" || i === " " || t === r - 1) {
                          for (i !== "" && i !== " " || (d -= _); p <= t;) u[p].an = d, u[p].ind = c, u[p].extra = _, p += 1;
                          c += 1, d = 0
                      }
                  } else if (v == 3) {
                  if (d += _, i === "" || t === r - 1) {
                      for (i === "" && (d -= _); p <= t;) u[p].an = d, u[p].ind = c, u[p].extra = _, p += 1;
                      d = 0, c += 1
                  }
              } else u[c].ind = c, u[c].extra = 0, c += 1;
              if (e.l = u, y = g > y ? g : y, h.push(g), e.sz) e.boxWidth = e.sz[0], e.justifyOffset = 0;
              else switch (e.boxWidth = y, e.j) {
                  case 1:
                      e.justifyOffset = -e.boxWidth;
                      break;
                  case 2:
                      e.justifyOffset = -e.boxWidth / 2;
                      break;
                  default:
                      e.justifyOffset = 0
              }
              e.lineWidths = h;
              var U, W, S, R, V = f.a;
              s = V.length;
              var P = [];
              for (a = 0; a < s; a += 1) {
                  for ((U = V[a])
                      .a.sc && (e.strokeColorAnim = !0), U.a.sw && (e.strokeWidthAnim = !0), (U.a.fc || U.a.fh || U.a.fs || U.a.fb) && (e.fillColorAnim = !0), R = 0, S = U.s.b, t = 0; t < r; t += 1)(W = u[t])
                      .anIndexes[a] = R, (S == 1 && W.val !== "" || S == 2 && W.val !== "" && W.val !== " " || S == 3 && (W.n || W.val == " " || t == r - 1) || S == 4 && (W.n || t == r - 1)) && (U.s.rn === 1 && P.push(R), R += 1);
                  f.a[a].s.totalChars = R;
                  var N, B = -1;
                  if (U.s.rn === 1)
                      for (t = 0; t < r; t += 1) B != (W = u[t])
                          .anIndexes[a] && (B = W.anIndexes[a], N = P.splice(Math.floor(Math.random() * P.length), 1)[0]), W.anIndexes[a] = N
              }
              e.yOffset = e.finalLineHeight || 1.2 * e.finalSize, e.ls = e.ls || 0, e.ascent = b.ascent * e.finalSize / 100
          }, TextProperty.prototype.updateDocumentData = function(e, t) {
              t = t === void 0 ? this.keysIndex : t;
              var r = this.copyData({}, this.data.d.k[t].s);
              r = this.copyData(r, e), this.data.d.k[t].s = r, this.recalculate(t), this.setCurrentData(r), this.elem.addDynamicProperty(this)
          }, TextProperty.prototype.recalculate = function(e) {
              var t = this.data.d.k[e].s;
              t.__complete = !1, this.keysIndex = 0, this._isFirstFrame = !0, this.getValue(t)
          }, TextProperty.prototype.canResizeFont = function(e) {
              this.canResize = e, this.recalculate(this.keysIndex), this.elem.addDynamicProperty(this)
          }, TextProperty.prototype.setMinimumFontSize = function(e) {
              this.minimumFontSize = Math.floor(e) || 1, this.recalculate(this.keysIndex), this.elem.addDynamicProperty(this)
          };
          var TextSelectorProp = function() {
              var e = Math.max,
                  t = Math.min,
                  r = Math.floor;

              function n(i, a) {
                  this._currentTextLength = -1, this.k = !1, this.data = a, this.elem = i, this.comp = i.comp, this.finalS = 0, this.finalE = 0, this.initDynamicPropertyContainer(i), this.s = PropertyFactory.getProp(i, a.s || {
                      k: 0
                  }, 0, 0, this), this.e = "e" in a ? PropertyFactory.getProp(i, a.e, 0, 0, this) : {
                      v: 100
                  }, this.o = PropertyFactory.getProp(i, a.o || {
                      k: 0
                  }, 0, 0, this), this.xe = PropertyFactory.getProp(i, a.xe || {
                      k: 0
                  }, 0, 0, this), this.ne = PropertyFactory.getProp(i, a.ne || {
                      k: 0
                  }, 0, 0, this), this.sm = PropertyFactory.getProp(i, a.sm || {
                      k: 100
                  }, 0, 0, this), this.a = PropertyFactory.getProp(i, a.a, 0, .01, this), this.dynamicProperties.length || this.getValue()
              }
              return n.prototype = {
                  getMult: function(i) {
                      this._currentTextLength !== this.elem.textProperty.currentData.l.length && this.getValue();
                      var a = 0,
                          s = 0,
                          o = 1,
                          l = 1;
                      this.ne.v > 0 ? a = this.ne.v / 100 : s = -this.ne.v / 100, this.xe.v > 0 ? o = 1 - this.xe.v / 100 : l = 1 + this.xe.v / 100;
                      var f = BezierFactory.getBezierEasing(a, s, o, l)
                          .get,
                          u = 0,
                          c = this.finalS,
                          v = this.finalE,
                          d = this.data.sh;
                      if (d === 2) u = f(u = v === c ? i >= v ? 1 : 0 : e(0, t(.5 / (v - c) + (i - c) / (v - c), 1)));
                      else if (d === 3) u = f(u = v === c ? i >= v ? 0 : 1 : 1 - e(0, t(.5 / (v - c) + (i - c) / (v - c), 1)));
                      else if (d === 4) v === c ? u = 0 : (u = e(0, t(.5 / (v - c) + (i - c) / (v - c), 1))) < .5 ? u *= 2 : u = 1 - 2 * (u - .5), u = f(u);
                      else if (d === 5) {
                          if (v === c) u = 0;
                          else {
                              var p = v - c,
                                  m = -p / 2 + (i = t(e(0, i + .5 - c), v - c)),
                                  h = p / 2;
                              u = Math.sqrt(1 - m * m / (h * h))
                          }
                          u = f(u)
                      } else d === 6 ? (v === c ? u = 0 : (i = t(e(0, i + .5 - c), v - c), u = (1 + Math.cos(Math.PI + 2 * Math.PI * i / (v - c))) / 2), u = f(u)) : (i >= r(c) && (u = e(0, t(i - c < 0 ? t(v, 1) - (c - i) : v - i, 1))), u = f(u));
                      if (this.sm.v !== 100) {
                          var g = .01 * this.sm.v;
                          g === 0 && (g = 1e-8);
                          var y = .5 - .5 * g;
                          u < y ? u = 0 : (u = (u - y) / g) > 1 && (u = 1)
                      }
                      return u * this.a.v
                  },
                  getValue: function(i) {
                      this.iterateDynamicProperties(), this._mdf = i || this._mdf, this._currentTextLength = this.elem.textProperty.currentData.l.length || 0, i && this.data.r === 2 && (this.e.v = this._currentTextLength);
                      var a = this.data.r === 2 ? 1 : 100 / this.data.totalChars,
                          s = this.o.v / a,
                          o = this.s.v / a + s,
                          l = this.e.v / a + s;
                      if (o > l) {
                          var f = o;
                          o = l, l = f
                      }
                      this.finalS = o, this.finalE = l
                  }
              }, extendPrototype([DynamicPropertyContainer], n), {
                  getTextSelectorProp: function(i, a, s) {
                      return new n(i, a, s)
                  }
              }
          }();

          function TextAnimatorDataProperty(e, t, r) {
              var n = {
                      propType: !1
                  },
                  i = PropertyFactory.getProp,
                  a = t.a;
              this.a = {
                  r: a.r ? i(e, a.r, 0, degToRads, r) : n,
                  rx: a.rx ? i(e, a.rx, 0, degToRads, r) : n,
                  ry: a.ry ? i(e, a.ry, 0, degToRads, r) : n,
                  sk: a.sk ? i(e, a.sk, 0, degToRads, r) : n,
                  sa: a.sa ? i(e, a.sa, 0, degToRads, r) : n,
                  s: a.s ? i(e, a.s, 1, .01, r) : n,
                  a: a.a ? i(e, a.a, 1, 0, r) : n,
                  o: a.o ? i(e, a.o, 0, .01, r) : n,
                  p: a.p ? i(e, a.p, 1, 0, r) : n,
                  sw: a.sw ? i(e, a.sw, 0, 0, r) : n,
                  sc: a.sc ? i(e, a.sc, 1, 0, r) : n,
                  fc: a.fc ? i(e, a.fc, 1, 0, r) : n,
                  fh: a.fh ? i(e, a.fh, 0, 0, r) : n,
                  fs: a.fs ? i(e, a.fs, 0, .01, r) : n,
                  fb: a.fb ? i(e, a.fb, 0, .01, r) : n,
                  t: a.t ? i(e, a.t, 0, 0, r) : n
              }, this.s = TextSelectorProp.getTextSelectorProp(e, t.s, r), this.s.t = t.s.t
          }

          function TextAnimatorProperty(e, t, r) {
              this._isFirstFrame = !0, this._hasMaskedPath = !1, this._frameId = -1, this._textData = e, this._renderType = t, this._elem = r, this._animatorsData = createSizedArray(this._textData.a.length), this._pathData = {}, this._moreOptions = {
                  alignment: {}
              }, this.renderedLetters = [], this.lettersChangedFlag = !1, this.initDynamicPropertyContainer(r)
          }

          function ITextElement() {}
          TextAnimatorProperty.prototype.searchProperties = function() {
              var e, t, r = this._textData.a.length,
                  n = PropertyFactory.getProp;
              for (e = 0; e < r; e += 1) t = this._textData.a[e], this._animatorsData[e] = new TextAnimatorDataProperty(this._elem, t, this);
              this._textData.p && "m" in this._textData.p ? (this._pathData = {
                  a: n(this._elem, this._textData.p.a, 0, 0, this),
                  f: n(this._elem, this._textData.p.f, 0, 0, this),
                  l: n(this._elem, this._textData.p.l, 0, 0, this),
                  r: n(this._elem, this._textData.p.r, 0, 0, this),
                  p: n(this._elem, this._textData.p.p, 0, 0, this),
                  m: this._elem.maskManager.getMaskProperty(this._textData.p.m)
              }, this._hasMaskedPath = !0) : this._hasMaskedPath = !1, this._moreOptions.alignment = n(this._elem, this._textData.m.a, 1, 0, this)
          }, TextAnimatorProperty.prototype.getMeasures = function(e, t) {
              if (this.lettersChangedFlag = t, this._mdf || this._isFirstFrame || t || this._hasMaskedPath && this._pathData.m._mdf) {
                  this._isFirstFrame = !1;
                  var r, n, i, a, s, o, l, f, u, c, v, d, p, m, h, g, y, b, _, I = this._moreOptions.alignment.v,
                      C = this._animatorsData,
                      x = this._textData,
                      O = this.mHelper,
                      L = this._renderType,
                      D = this.renderedLetters.length,
                      A = e.l;
                  if (this._hasMaskedPath) {
                      if (_ = this._pathData.m, !this._pathData.n || this._pathData._mdf) {
                          var q, w = _.v;
                          for (this._pathData.r.v && (w = w.reverse()), s = {
                                  tLength: 0,
                                  segments: []
                              }, a = w._length - 1, g = 0, i = 0; i < a; i += 1) q = bez.buildBezierData(w.v[i], w.v[i + 1], [w.o[i][0] - w.v[i][0], w.o[i][1] - w.v[i][1]], [w.i[i + 1][0] - w.v[i + 1][0], w.i[i + 1][1] - w.v[i + 1][1]]), s.tLength += q.segmentLength, s.segments.push(q), g += q.segmentLength;
                          i = a, _.v.c && (q = bez.buildBezierData(w.v[i], w.v[0], [w.o[i][0] - w.v[i][0], w.o[i][1] - w.v[i][1]], [w.i[0][0] - w.v[0][0], w.i[0][1] - w.v[0][1]]), s.tLength += q.segmentLength, s.segments.push(q), g += q.segmentLength), this._pathData.pi = s
                      }
                      if (s = this._pathData.pi, o = this._pathData.f.v, v = 0, c = 1, f = 0, u = !0, m = s.segments, o < 0 && _.v.c)
                          for (s.tLength < Math.abs(o) && (o = -Math.abs(o) % s.tLength), c = (p = m[v = m.length - 1].points)
                              .length - 1; o < 0;) o += p[c].partialLength, (c -= 1) < 0 && (c = (p = m[v -= 1].points)
                              .length - 1);
                      d = (p = m[v].points)[c - 1], h = (l = p[c])
                          .partialLength
                  }
                  a = A.length, r = 0, n = 0;
                  var F, k, U, W, S, R = 1.2 * e.finalSize * .714,
                      V = !0;
                  U = C.length;
                  var P, N, B, T, z, Q, G, J, ae, re, fe, ge, ye = -1,
                      ie = o,
                      Pe = v,
                      Ge = c,
                      Ke = -1,
                      M = "",
                      H = this.defaultPropsArray;
                  if (e.j === 2 || e.j === 1) {
                      var j = 0,
                          Y = 0,
                          X = e.j === 2 ? -.5 : -1,
                          K = 0,
                          te = !0;
                      for (i = 0; i < a; i += 1)
                          if (A[i].n) {
                              for (j && (j += Y); K < i;) A[K].animatorJustifyOffset = j, K += 1;
                              j = 0, te = !0
                          } else {
                              for (k = 0; k < U; k += 1)(F = C[k].a)
                                  .t.propType && (te && e.j === 2 && (Y += F.t.v * X), (S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars))
                                      .length ? j += F.t.v * S[0] * X : j += F.t.v * S * X);
                              te = !1
                          } for (j && (j += Y); K < i;) A[K].animatorJustifyOffset = j, K += 1
                  }
                  for (i = 0; i < a; i += 1) {
                      if (O.reset(), T = 1, A[i].n) r = 0, n += e.yOffset, n += V ? 1 : 0, o = ie, V = !1, this._hasMaskedPath && (c = Ge, d = (p = m[v = Pe].points)[c - 1], h = (l = p[c])
                          .partialLength, f = 0), M = "", fe = "", ae = "", ge = "", H = this.defaultPropsArray;
                      else {
                          if (this._hasMaskedPath) {
                              if (Ke !== A[i].line) {
                                  switch (e.j) {
                                      case 1:
                                          o += g - e.lineWidths[A[i].line];
                                          break;
                                      case 2:
                                          o += (g - e.lineWidths[A[i].line]) / 2
                                  }
                                  Ke = A[i].line
                              }
                              ye !== A[i].ind && (A[ye] && (o += A[ye].extra), o += A[i].an / 2, ye = A[i].ind), o += I[0] * A[i].an * .005;
                              var ne = 0;
                              for (k = 0; k < U; k += 1)(F = C[k].a)
                                  .p.propType && ((S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars))
                                      .length ? ne += F.p.v[0] * S[0] : ne += F.p.v[0] * S), F.a.propType && ((S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars))
                                      .length ? ne += F.a.v[0] * S[0] : ne += F.a.v[0] * S);
                              for (u = !0, this._pathData.a.v && (o = .5 * A[0].an + (g - this._pathData.f.v - .5 * A[0].an - .5 * A[A.length - 1].an) * ye / (a - 1), o += this._pathData.f.v); u;) f + h >= o + ne || !p ? (y = (o + ne - f) / l.partialLength, N = d.point[0] + (l.point[0] - d.point[0]) * y, B = d.point[1] + (l.point[1] - d.point[1]) * y, O.translate(-I[0] * A[i].an * .005, -I[1] * R * .01), u = !1) : p && (f += l.partialLength, (c += 1) >= p.length && (c = 0, m[v += 1] ? p = m[v].points : _.v.c ? (c = 0, p = m[v = 0].points) : (f -= l.partialLength, p = null)), p && (d = l, h = (l = p[c])
                                  .partialLength));
                              P = A[i].an / 2 - A[i].add, O.translate(-P, 0, 0)
                          } else P = A[i].an / 2 - A[i].add, O.translate(-P, 0, 0), O.translate(-I[0] * A[i].an * .005, -I[1] * R * .01, 0);
                          for (k = 0; k < U; k += 1)(F = C[k].a)
                              .t.propType && (S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars), r === 0 && e.j === 0 || (this._hasMaskedPath ? S.length ? o += F.t.v * S[0] : o += F.t.v * S : S.length ? r += F.t.v * S[0] : r += F.t.v * S));
                          for (e.strokeWidthAnim && (Q = e.sw || 0), e.strokeColorAnim && (z = e.sc ? [e.sc[0], e.sc[1], e.sc[2]] : [0, 0, 0]), e.fillColorAnim && e.fc && (G = [e.fc[0], e.fc[1], e.fc[2]]), k = 0; k < U; k += 1)(F = C[k].a)
                              .a.propType && ((S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars))
                                  .length ? O.translate(-F.a.v[0] * S[0], -F.a.v[1] * S[1], F.a.v[2] * S[2]) : O.translate(-F.a.v[0] * S, -F.a.v[1] * S, F.a.v[2] * S));
                          for (k = 0; k < U; k += 1)(F = C[k].a)
                              .s.propType && ((S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars))
                                  .length ? O.scale(1 + (F.s.v[0] - 1) * S[0], 1 + (F.s.v[1] - 1) * S[1], 1) : O.scale(1 + (F.s.v[0] - 1) * S, 1 + (F.s.v[1] - 1) * S, 1));
                          for (k = 0; k < U; k += 1) {
                              if (F = C[k].a, S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars), F.sk.propType && (S.length ? O.skewFromAxis(-F.sk.v * S[0], F.sa.v * S[1]) : O.skewFromAxis(-F.sk.v * S, F.sa.v * S)), F.r.propType && (S.length ? O.rotateZ(-F.r.v * S[2]) : O.rotateZ(-F.r.v * S)), F.ry.propType && (S.length ? O.rotateY(F.ry.v * S[1]) : O.rotateY(F.ry.v * S)), F.rx.propType && (S.length ? O.rotateX(F.rx.v * S[0]) : O.rotateX(F.rx.v * S)), F.o.propType && (S.length ? T += (F.o.v * S[0] - T) * S[0] : T += (F.o.v * S - T) * S), e.strokeWidthAnim && F.sw.propType && (S.length ? Q += F.sw.v * S[0] : Q += F.sw.v * S), e.strokeColorAnim && F.sc.propType)
                                  for (J = 0; J < 3; J += 1) S.length ? z[J] += (F.sc.v[J] - z[J]) * S[0] : z[J] += (F.sc.v[J] - z[J]) * S;
                              if (e.fillColorAnim && e.fc) {
                                  if (F.fc.propType)
                                      for (J = 0; J < 3; J += 1) S.length ? G[J] += (F.fc.v[J] - G[J]) * S[0] : G[J] += (F.fc.v[J] - G[J]) * S;
                                  F.fh.propType && (G = S.length ? addHueToRGB(G, F.fh.v * S[0]) : addHueToRGB(G, F.fh.v * S)), F.fs.propType && (G = S.length ? addSaturationToRGB(G, F.fs.v * S[0]) : addSaturationToRGB(G, F.fs.v * S)), F.fb.propType && (G = S.length ? addBrightnessToRGB(G, F.fb.v * S[0]) : addBrightnessToRGB(G, F.fb.v * S))
                              }
                          }
                          for (k = 0; k < U; k += 1)(F = C[k].a)
                              .p.propType && (S = C[k].s.getMult(A[i].anIndexes[k], x.a[k].s.totalChars), this._hasMaskedPath ? S.length ? O.translate(0, F.p.v[1] * S[0], -F.p.v[2] * S[1]) : O.translate(0, F.p.v[1] * S, -F.p.v[2] * S) : S.length ? O.translate(F.p.v[0] * S[0], F.p.v[1] * S[1], -F.p.v[2] * S[2]) : O.translate(F.p.v[0] * S, F.p.v[1] * S, -F.p.v[2] * S));
                          if (e.strokeWidthAnim && (ae = Q < 0 ? 0 : Q), e.strokeColorAnim && (re = "rgb(" + Math.round(255 * z[0]) + "," + Math.round(255 * z[1]) + "," + Math.round(255 * z[2]) + ")"), e.fillColorAnim && e.fc && (fe = "rgb(" + Math.round(255 * G[0]) + "," + Math.round(255 * G[1]) + "," + Math.round(255 * G[2]) + ")"), this._hasMaskedPath) {
                              if (O.translate(0, -e.ls), O.translate(0, I[1] * R * .01 + n, 0), this._pathData.p.v) {
                                  b = (l.point[1] - d.point[1]) / (l.point[0] - d.point[0]);
                                  var me = 180 * Math.atan(b) / Math.PI;
                                  l.point[0] < d.point[0] && (me += 180), O.rotate(-me * Math.PI / 180)
                              }
                              O.translate(N, B, 0), o -= I[0] * A[i].an * .005, A[i + 1] && ye !== A[i + 1].ind && (o += A[i].an / 2, o += .001 * e.tr * e.finalSize)
                          } else {
                              switch (O.translate(r, n, 0), e.ps && O.translate(e.ps[0], e.ps[1] + e.ascent, 0), e.j) {
                                  case 1:
                                      O.translate(A[i].animatorJustifyOffset + e.justifyOffset + (e.boxWidth - e.lineWidths[A[i].line]), 0, 0);
                                      break;
                                  case 2:
                                      O.translate(A[i].animatorJustifyOffset + e.justifyOffset + (e.boxWidth - e.lineWidths[A[i].line]) / 2, 0, 0)
                              }
                              O.translate(0, -e.ls), O.translate(P, 0, 0), O.translate(I[0] * A[i].an * .005, I[1] * R * .01, 0), r += A[i].l + .001 * e.tr * e.finalSize
                          }
                          L === "html" ? M = O.toCSS() : L === "svg" ? M = O.to2dCSS() : H = [O.props[0], O.props[1], O.props[2], O.props[3], O.props[4], O.props[5], O.props[6], O.props[7], O.props[8], O.props[9], O.props[10], O.props[11], O.props[12], O.props[13], O.props[14], O.props[15]], ge = T
                      }
                      D <= i ? (W = new LetterProps(ge, ae, re, fe, M, H), this.renderedLetters.push(W), D += 1, this.lettersChangedFlag = !0) : (W = this.renderedLetters[i], this.lettersChangedFlag = W.update(ge, ae, re, fe, M, H) || this.lettersChangedFlag)
                  }
              }
          }, TextAnimatorProperty.prototype.getValue = function() {
              this._elem.globalData.frameId !== this._frameId && (this._frameId = this._elem.globalData.frameId, this.iterateDynamicProperties())
          }, TextAnimatorProperty.prototype.mHelper = new Matrix, TextAnimatorProperty.prototype.defaultPropsArray = [], extendPrototype([DynamicPropertyContainer], TextAnimatorProperty), ITextElement.prototype.initElement = function(e, t, r) {
              this.lettersChangedFlag = !0, this.initFrame(), this.initBaseData(e, t, r), this.textProperty = new TextProperty(this, e.t, this.dynamicProperties), this.textAnimator = new TextAnimatorProperty(e.t, this.renderType, this), this.initTransform(e, t, r), this.initHierarchy(), this.initRenderable(), this.initRendererElement(), this.createContainerElements(), this.createRenderableComponents(), this.createContent(), this.hide(), this.textAnimator.searchProperties(this.dynamicProperties)
          }, ITextElement.prototype.prepareFrame = function(e) {
              this._mdf = !1, this.prepareRenderableFrame(e), this.prepareProperties(e, this.isInRange)
          }, ITextElement.prototype.createPathShape = function(e, t) {
              var r, n, i = t.length,
                  a = "";
              for (r = 0; r < i; r += 1) t[r].ty === "sh" && (n = t[r].ks.k, a += buildShapeString(n, n.i.length, !0, e));
              return a
          }, ITextElement.prototype.updateDocumentData = function(e, t) {
              this.textProperty.updateDocumentData(e, t)
          }, ITextElement.prototype.canResizeFont = function(e) {
              this.textProperty.canResizeFont(e)
          }, ITextElement.prototype.setMinimumFontSize = function(e) {
              this.textProperty.setMinimumFontSize(e)
          }, ITextElement.prototype.applyTextPropertiesToMatrix = function(e, t, r, n, i) {
              switch (e.ps && t.translate(e.ps[0], e.ps[1] + e.ascent, 0), t.translate(0, -e.ls, 0), e.j) {
                  case 1:
                      t.translate(e.justifyOffset + (e.boxWidth - e.lineWidths[r]), 0, 0);
                      break;
                  case 2:
                      t.translate(e.justifyOffset + (e.boxWidth - e.lineWidths[r]) / 2, 0, 0)
              }
              t.translate(n, i, 0)
          }, ITextElement.prototype.buildColor = function(e) {
              return "rgb(" + Math.round(255 * e[0]) + "," + Math.round(255 * e[1]) + "," + Math.round(255 * e[2]) + ")"
          }, ITextElement.prototype.emptyProp = new LetterProps, ITextElement.prototype.destroy = function() {}, ITextElement.prototype.validateText = function() {
              (this.textProperty._mdf || this.textProperty._isFirstFrame) && (this.buildNewText(), this.textProperty._isFirstFrame = !1, this.textProperty._mdf = !1)
          };
          var emptyShapeData = {
              shapes: []
          };

          function SVGTextLottieElement(e, t, r) {
              this.textSpans = [], this.renderType = "svg", this.initElement(e, t, r)
          }

          function ISolidElement(e, t, r) {
              this.initElement(e, t, r)
          }

          function NullElement(e, t, r) {
              this.initFrame(), this.initBaseData(e, t, r), this.initFrame(), this.initTransform(e, t, r), this.initHierarchy()
          }

          function SVGRendererBase() {}

          function ICompElement() {}

          function SVGCompElement(e, t, r) {
              this.layers = e.layers, this.supports3d = !0, this.completeLayers = !1, this.pendingElements = [], this.elements = this.layers ? createSizedArray(this.layers.length) : [], this.initElement(e, t, r), this.tm = e.tm ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this) : {
                  _placeholder: !0
              }
          }

          function SVGRenderer(e, t) {
              this.animationItem = e, this.layers = null, this.renderedFrame = -1, this.svgElement = createNS("svg");
              var r = "";
              if (t && t.title) {
                  var n = createNS("title"),
                      i = createElementID();
                  n.setAttribute("id", i), n.textContent = t.title, this.svgElement.appendChild(n), r += i
              }
              if (t && t.description) {
                  var a = createNS("desc"),
                      s = createElementID();
                  a.setAttribute("id", s), a.textContent = t.description, this.svgElement.appendChild(a), r += " " + s
              }
              r && this.svgElement.setAttribute("aria-labelledby", r);
              var o = createNS("defs");
              this.svgElement.appendChild(o);
              var l = createNS("g");
              this.svgElement.appendChild(l), this.layerElement = l, this.renderConfig = {
                  preserveAspectRatio: t && t.preserveAspectRatio || "xMidYMid meet",
                  imagePreserveAspectRatio: t && t.imagePreserveAspectRatio || "xMidYMid slice",
                  contentVisibility: t && t.contentVisibility || "visible",
                  progressiveLoad: t && t.progressiveLoad || !1,
                  hideOnTransparent: !(t && t.hideOnTransparent === !1),
                  viewBoxOnly: t && t.viewBoxOnly || !1,
                  viewBoxSize: t && t.viewBoxSize || !1,
                  className: t && t.className || "",
                  id: t && t.id || "",
                  focusable: t && t.focusable,
                  filterSize: {
                      width: t && t.filterSize && t.filterSize.width || "100%",
                      height: t && t.filterSize && t.filterSize.height || "100%",
                      x: t && t.filterSize && t.filterSize.x || "0%",
                      y: t && t.filterSize && t.filterSize.y || "0%"
                  },
                  width: t && t.width,
                  height: t && t.height,
                  runExpressions: !t || t.runExpressions === void 0 || t.runExpressions
              }, this.globalData = {
                  _mdf: !1,
                  frameNum: -1,
                  defs: o,
                  renderConfig: this.renderConfig
              }, this.elements = [], this.pendingElements = [], this.destroyed = !1, this.rendererType = "svg"
          }

          function ShapeTransformManager() {
              this.sequences = {}, this.sequenceList = [], this.transform_key_count = 0
          }
          extendPrototype([BaseElement, TransformElement, SVGBaseElement, HierarchyElement, FrameElement, RenderableDOMElement, ITextElement], SVGTextLottieElement), SVGTextLottieElement.prototype.createContent = function() {
              this.data.singleShape && !this.globalData.fontManager.chars && (this.textContainer = createNS("text"))
          }, SVGTextLottieElement.prototype.buildTextContents = function(e) {
              for (var t = 0, r = e.length, n = [], i = ""; t < r;) e[t] === String.fromCharCode(13) || e[t] === String.fromCharCode(3) ? (n.push(i), i = "") : i += e[t], t += 1;
              return n.push(i), n
          }, SVGTextLottieElement.prototype.buildShapeData = function(e, t) {
              if (e.shapes && e.shapes.length) {
                  var r = e.shapes[0];
                  if (r.it) {
                      var n = r.it[r.it.length - 1];
                      n.s && (n.s.k[0] = t, n.s.k[1] = t)
                  }
              }
              return e
          }, SVGTextLottieElement.prototype.buildNewText = function() {
              var e, t;
              this.addDynamicProperty(this);
              var r = this.textProperty.currentData;
              this.renderedLetters = createSizedArray(r ? r.l.length : 0), r.fc ? this.layerElement.setAttribute("fill", this.buildColor(r.fc)) : this.layerElement.setAttribute("fill", "rgba(0,0,0,0)"), r.sc && (this.layerElement.setAttribute("stroke", this.buildColor(r.sc)), this.layerElement.setAttribute("stroke-width", r.sw)), this.layerElement.setAttribute("font-size", r.finalSize);
              var n = this.globalData.fontManager.getFontByName(r.f);
              if (n.fClass) this.layerElement.setAttribute("class", n.fClass);
              else {
                  this.layerElement.setAttribute("font-family", n.fFamily);
                  var i = r.fWeight,
                      a = r.fStyle;
                  this.layerElement.setAttribute("font-style", a), this.layerElement.setAttribute("font-weight", i)
              }
              this.layerElement.setAttribute("aria-label", r.t);
              var s, o = r.l || [],
                  l = !!this.globalData.fontManager.chars;
              t = o.length;
              var f = this.mHelper,
                  u = this.data.singleShape,
                  c = 0,
                  v = 0,
                  d = !0,
                  p = .001 * r.tr * r.finalSize;
              if (!u || l || r.sz) {
                  var m, h = this.textSpans.length;
                  for (e = 0; e < t; e += 1) {
                      if (this.textSpans[e] || (this.textSpans[e] = {
                              span: null,
                              childSpan: null,
                              glyph: null
                          }), !l || !u || e === 0) {
                          if (s = h > e ? this.textSpans[e].span : createNS(l ? "g" : "text"), h <= e) {
                              if (s.setAttribute("stroke-linecap", "butt"), s.setAttribute("stroke-linejoin", "round"), s.setAttribute("stroke-miterlimit", "4"), this.textSpans[e].span = s, l) {
                                  var g = createNS("g");
                                  s.appendChild(g), this.textSpans[e].childSpan = g
                              }
                              this.textSpans[e].span = s, this.layerElement.appendChild(s)
                          }
                          s.style.display = "inherit"
                      }
                      if (f.reset(), u && (o[e].n && (c = -p, v += r.yOffset, v += d ? 1 : 0, d = !1), this.applyTextPropertiesToMatrix(r, f, o[e].line, c, v), c += o[e].l || 0, c += p), l) {
                          var y;
                          if ((m = this.globalData.fontManager.getCharData(r.finalText[e], n.fStyle, this.globalData.fontManager.getFontByName(r.f)
                                  .fFamily))
                              .t === 1) y = new SVGCompElement(m.data, this.globalData, this);
                          else {
                              var b = emptyShapeData;
                              m.data && m.data.shapes && (b = this.buildShapeData(m.data, r.finalSize)), y = new SVGShapeElement(b, this.globalData, this)
                          }
                          if (this.textSpans[e].glyph) {
                              var _ = this.textSpans[e].glyph;
                              this.textSpans[e].childSpan.removeChild(_.layerElement), _.destroy()
                          }
                          this.textSpans[e].glyph = y, y._debug = !0, y.prepareFrame(0), y.renderFrame(), this.textSpans[e].childSpan.appendChild(y.layerElement), m.t === 1 && this.textSpans[e].childSpan.setAttribute("transform", "scale(" + r.finalSize / 100 + "," + r.finalSize / 100 + ")")
                      } else u && s.setAttribute("transform", "translate(" + f.props[12] + "," + f.props[13] + ")"), s.textContent = o[e].val, s.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve")
                  }
                  u && s && s.setAttribute("d", "")
              } else {
                  var I = this.textContainer,
                      C = "start";
                  switch (r.j) {
                      case 1:
                          C = "end";
                          break;
                      case 2:
                          C = "middle";
                          break;
                      default:
                          C = "start"
                  }
                  I.setAttribute("text-anchor", C), I.setAttribute("letter-spacing", p);
                  var x = this.buildTextContents(r.finalText);
                  for (t = x.length, v = r.ps ? r.ps[1] + r.ascent : 0, e = 0; e < t; e += 1)(s = this.textSpans[e].span || createNS("tspan"))
                      .textContent = x[e], s.setAttribute("x", 0), s.setAttribute("y", v), s.style.display = "inherit", I.appendChild(s), this.textSpans[e] || (this.textSpans[e] = {
                          span: null,
                          glyph: null
                      }), this.textSpans[e].span = s, v += r.finalLineHeight;
                  this.layerElement.appendChild(I)
              }
              for (; e < this.textSpans.length;) this.textSpans[e].span.style.display = "none", e += 1;
              this._sizeChanged = !0
          }, SVGTextLottieElement.prototype.sourceRectAtTime = function() {
              if (this.prepareFrame(this.comp.renderedFrame - this.data.st), this.renderInnerContent(), this._sizeChanged) {
                  this._sizeChanged = !1;
                  var e = this.layerElement.getBBox();
                  this.bbox = {
                      top: e.y,
                      left: e.x,
                      width: e.width,
                      height: e.height
                  }
              }
              return this.bbox
          }, SVGTextLottieElement.prototype.getValue = function() {
              var e, t, r = this.textSpans.length;
              for (this.renderedFrame = this.comp.renderedFrame, e = 0; e < r; e += 1)(t = this.textSpans[e].glyph) && (t.prepareFrame(this.comp.renderedFrame - this.data.st), t._mdf && (this._mdf = !0))
          }, SVGTextLottieElement.prototype.renderInnerContent = function() {
              if (this.validateText(), (!this.data.singleShape || this._mdf) && (this.textAnimator.getMeasures(this.textProperty.currentData, this.lettersChangedFlag), this.lettersChangedFlag || this.textAnimator.lettersChangedFlag)) {
                  var e, t;
                  this._sizeChanged = !0;
                  var r, n, i, a = this.textAnimator.renderedLetters,
                      s = this.textProperty.currentData.l;
                  for (t = s.length, e = 0; e < t; e += 1) s[e].n || (r = a[e], n = this.textSpans[e].span, (i = this.textSpans[e].glyph) && i.renderFrame(), r._mdf.m && n.setAttribute("transform", r.m), r._mdf.o && n.setAttribute("opacity", r.o), r._mdf.sw && n.setAttribute("stroke-width", r.sw), r._mdf.sc && n.setAttribute("stroke", r.sc), r._mdf.fc && n.setAttribute("fill", r.fc))
              }
          }, extendPrototype([IImageElement], ISolidElement), ISolidElement.prototype.createContent = function() {
              var e = createNS("rect");
              e.setAttribute("width", this.data.sw), e.setAttribute("height", this.data.sh), e.setAttribute("fill", this.data.sc), this.layerElement.appendChild(e)
          }, NullElement.prototype.prepareFrame = function(e) {
              this.prepareProperties(e, !0)
          }, NullElement.prototype.renderFrame = function() {}, NullElement.prototype.getBaseElement = function() {
              return null
          }, NullElement.prototype.destroy = function() {}, NullElement.prototype.sourceRectAtTime = function() {}, NullElement.prototype.hide = function() {}, extendPrototype([BaseElement, TransformElement, HierarchyElement, FrameElement], NullElement), extendPrototype([BaseRenderer], SVGRendererBase), SVGRendererBase.prototype.createNull = function(e) {
              return new NullElement(e, this.globalData, this)
          }, SVGRendererBase.prototype.createShape = function(e) {
              return new SVGShapeElement(e, this.globalData, this)
          }, SVGRendererBase.prototype.createText = function(e) {
              return new SVGTextLottieElement(e, this.globalData, this)
          }, SVGRendererBase.prototype.createImage = function(e) {
              return new IImageElement(e, this.globalData, this)
          }, SVGRendererBase.prototype.createSolid = function(e) {
              return new ISolidElement(e, this.globalData, this)
          }, SVGRendererBase.prototype.configAnimation = function(e) {
              this.svgElement.setAttribute("xmlns", "http://www.w3.org/2000/svg"), this.svgElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink"), this.renderConfig.viewBoxSize ? this.svgElement.setAttribute("viewBox", this.renderConfig.viewBoxSize) : this.svgElement.setAttribute("viewBox", "0 0 " + e.w + " " + e.h), this.renderConfig.viewBoxOnly || (this.svgElement.setAttribute("width", e.w), this.svgElement.setAttribute("height", e.h), this.svgElement.style.width = "100%", this.svgElement.style.height = "100%", this.svgElement.style.transform = "translate3d(0,0,0)", this.svgElement.style.contentVisibility = this.renderConfig.contentVisibility), this.renderConfig.width && this.svgElement.setAttribute("width", this.renderConfig.width), this.renderConfig.height && this.svgElement.setAttribute("height", this.renderConfig.height), this.renderConfig.className && this.svgElement.setAttribute("class", this.renderConfig.className), this.renderConfig.id && this.svgElement.setAttribute("id", this.renderConfig.id), this.renderConfig.focusable !== void 0 && this.svgElement.setAttribute("focusable", this.renderConfig.focusable), this.svgElement.setAttribute("preserveAspectRatio", this.renderConfig.preserveAspectRatio), this.animationItem.wrapper.appendChild(this.svgElement);
              var t = this.globalData.defs;
              this.setupGlobalData(e, t), this.globalData.progressiveLoad = this.renderConfig.progressiveLoad, this.data = e;
              var r = createNS("clipPath"),
                  n = createNS("rect");
              n.setAttribute("width", e.w), n.setAttribute("height", e.h), n.setAttribute("x", 0), n.setAttribute("y", 0);
              var i = createElementID();
              r.setAttribute("id", i), r.appendChild(n), this.layerElement.setAttribute("clip-path", "url(" + getLocationHref() + "#" + i + ")"), t.appendChild(r), this.layers = e.layers, this.elements = createSizedArray(e.layers.length)
          }, SVGRendererBase.prototype.destroy = function() {
              var e;
              this.animationItem.wrapper && (this.animationItem.wrapper.innerText = ""), this.layerElement = null, this.globalData.defs = null;
              var t = this.layers ? this.layers.length : 0;
              for (e = 0; e < t; e += 1) this.elements[e] && this.elements[e].destroy && this.elements[e].destroy();
              this.elements.length = 0, this.destroyed = !0, this.animationItem = null
          }, SVGRendererBase.prototype.updateContainerSize = function() {}, SVGRendererBase.prototype.findIndexByInd = function(e) {
              var t = 0,
                  r = this.layers.length;
              for (t = 0; t < r; t += 1)
                  if (this.layers[t].ind === e) return t;
              return -1
          }, SVGRendererBase.prototype.buildItem = function(e) {
              var t = this.elements;
              if (!t[e] && this.layers[e].ty !== 99) {
                  t[e] = !0;
                  var r = this.createItem(this.layers[e]);
                  if (t[e] = r, getExpressionsPlugin() && (this.layers[e].ty === 0 && this.globalData.projectInterface.registerComposition(r), r.initExpressions()), this.appendElementInPos(r, e), this.layers[e].tt) {
                      var n = "tp" in this.layers[e] ? this.findIndexByInd(this.layers[e].tp) : e - 1;
                      if (n === -1) return;
                      if (this.elements[n] && this.elements[n] !== !0) {
                          var i = t[n].getMatte(this.layers[e].tt);
                          r.setMatte(i)
                      } else this.buildItem(n), this.addPendingElement(r)
                  }
              }
          }, SVGRendererBase.prototype.checkPendingElements = function() {
              for (; this.pendingElements.length;) {
                  var e = this.pendingElements.pop();
                  if (e.checkParenting(), e.data.tt)
                      for (var t = 0, r = this.elements.length; t < r;) {
                          if (this.elements[t] === e) {
                              var n = "tp" in e.data ? this.findIndexByInd(e.data.tp) : t - 1,
                                  i = this.elements[n].getMatte(this.layers[t].tt);
                              e.setMatte(i);
                              break
                          }
                          t += 1
                      }
              }
          }, SVGRendererBase.prototype.renderFrame = function(e) {
              if (this.renderedFrame !== e && !this.destroyed) {
                  var t;
                  e === null ? e = this.renderedFrame : this.renderedFrame = e, this.globalData.frameNum = e, this.globalData.frameId += 1, this.globalData.projectInterface.currentFrame = e, this.globalData._mdf = !1;
                  var r = this.layers.length;
                  for (this.completeLayers || this.checkLayers(e), t = r - 1; t >= 0; t -= 1)(this.completeLayers || this.elements[t]) && this.elements[t].prepareFrame(e - this.layers[t].st);
                  if (this.globalData._mdf)
                      for (t = 0; t < r; t += 1)(this.completeLayers || this.elements[t]) && this.elements[t].renderFrame()
              }
          }, SVGRendererBase.prototype.appendElementInPos = function(e, t) {
              var r = e.getBaseElement();
              if (r) {
                  for (var n, i = 0; i < t;) this.elements[i] && this.elements[i] !== !0 && this.elements[i].getBaseElement() && (n = this.elements[i].getBaseElement()), i += 1;
                  n ? this.layerElement.insertBefore(r, n) : this.layerElement.appendChild(r)
              }
          }, SVGRendererBase.prototype.hide = function() {
              this.layerElement.style.display = "none"
          }, SVGRendererBase.prototype.show = function() {
              this.layerElement.style.display = "block"
          }, extendPrototype([BaseElement, TransformElement, HierarchyElement, FrameElement, RenderableDOMElement], ICompElement), ICompElement.prototype.initElement = function(e, t, r) {
              this.initFrame(), this.initBaseData(e, t, r), this.initTransform(e, t, r), this.initRenderable(), this.initHierarchy(), this.initRendererElement(), this.createContainerElements(), this.createRenderableComponents(), !this.data.xt && t.progressiveLoad || this.buildAllItems(), this.hide()
          }, ICompElement.prototype.prepareFrame = function(e) {
              if (this._mdf = !1, this.prepareRenderableFrame(e), this.prepareProperties(e, this.isInRange), this.isInRange || this.data.xt) {
                  if (this.tm._placeholder) this.renderedFrame = e / this.data.sr;
                  else {
                      var t = this.tm.v;
                      t === this.data.op && (t = this.data.op - 1), this.renderedFrame = t
                  }
                  var r, n = this.elements.length;
                  for (this.completeLayers || this.checkLayers(this.renderedFrame), r = n - 1; r >= 0; r -= 1)(this.completeLayers || this.elements[r]) && (this.elements[r].prepareFrame(this.renderedFrame - this.layers[r].st), this.elements[r]._mdf && (this._mdf = !0))
              }
          }, ICompElement.prototype.renderInnerContent = function() {
              var e, t = this.layers.length;
              for (e = 0; e < t; e += 1)(this.completeLayers || this.elements[e]) && this.elements[e].renderFrame()
          }, ICompElement.prototype.setElements = function(e) {
              this.elements = e
          }, ICompElement.prototype.getElements = function() {
              return this.elements
          }, ICompElement.prototype.destroyElements = function() {
              var e, t = this.layers.length;
              for (e = 0; e < t; e += 1) this.elements[e] && this.elements[e].destroy()
          }, ICompElement.prototype.destroy = function() {
              this.destroyElements(), this.destroyBaseElement()
          }, extendPrototype([SVGRendererBase, ICompElement, SVGBaseElement], SVGCompElement), SVGCompElement.prototype.createComp = function(e) {
              return new SVGCompElement(e, this.globalData, this)
          }, extendPrototype([SVGRendererBase], SVGRenderer), SVGRenderer.prototype.createComp = function(e) {
              return new SVGCompElement(e, this.globalData, this)
          }, ShapeTransformManager.prototype = {
              addTransformSequence: function(e) {
                  var t, r = e.length,
                      n = "_";
                  for (t = 0; t < r; t += 1) n += e[t].transform.key + "_";
                  var i = this.sequences[n];
                  return i || (i = {
                      transforms: [].concat(e),
                      finalTransform: new Matrix,
                      _mdf: !1
                  }, this.sequences[n] = i, this.sequenceList.push(i)), i
              },
              processSequence: function(e, t) {
                  for (var r = 0, n = e.transforms.length, i = t; r < n && !t;) {
                      if (e.transforms[r].transform.mProps._mdf) {
                          i = !0;
                          break
                      }
                      r += 1
                  }
                  if (i)
                      for (e.finalTransform.reset(), r = n - 1; r >= 0; r -= 1) e.finalTransform.multiply(e.transforms[r].transform.mProps.v);
                  e._mdf = i
              },
              processSequences: function(e) {
                  var t, r = this.sequenceList.length;
                  for (t = 0; t < r; t += 1) this.processSequence(this.sequenceList[t], e)
              },
              getNewKey: function() {
                  return this.transform_key_count += 1, "_" + this.transform_key_count
              }
          };
          var lumaLoader = function() {
              var e = "__lottie_element_luma_buffer",
                  t = null,
                  r = null,
                  n = null;

              function i() {
                  var a, s, o;
                  t || (a = createNS("svg"), s = createNS("filter"), o = createNS("feColorMatrix"), s.setAttribute("id", e), o.setAttribute("type", "matrix"), o.setAttribute("color-interpolation-filters", "sRGB"), o.setAttribute("values", "0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0"), s.appendChild(o), a.appendChild(s), a.setAttribute("id", e + "_svg"), featureSupport.svgLumaHidden && (a.style.display = "none"), n = a, document.body.appendChild(n), t = createTag("canvas"), (r = t.getContext("2d"))
                      .filter = "url(#" + e + ")", r.fillStyle = "rgba(0,0,0,0)", r.fillRect(0, 0, 1, 1))
              }
              return {
                  load: i,
                  get: function(a) {
                      return t || i(), t.width = a.width, t.height = a.height, r.filter = "url(#" + e + ")", t
                  }
              }
          };

          function createCanvas(e, t) {
              if (featureSupport.offscreenCanvas) return new OffscreenCanvas(e, t);
              var r = createTag("canvas");
              return r.width = e, r.height = t, r
          }
          var assetLoader = {
                  loadLumaCanvas: lumaLoader.load,
                  getLumaCanvas: lumaLoader.get,
                  createCanvas
              },
              registeredEffects = {};

          function CVEffects(e) {
              var t, r, n = e.data.ef ? e.data.ef.length : 0;
              for (this.filters = [], t = 0; t < n; t += 1) {
                  r = null;
                  var i = e.data.ef[t].ty;
                  registeredEffects[i] && (r = new registeredEffects[i].effect(e.effectsManager.effectElements[t], e)), r && this.filters.push(r)
              }
              this.filters.length && e.addRenderableComponent(this)
          }

          function registerEffect(e, t) {
              registeredEffects[e] = {
                  effect: t
              }
          }

          function CVMaskElement(e, t) {
              var r;
              this.data = e, this.element = t, this.masksProperties = this.data.masksProperties || [], this.viewData = createSizedArray(this.masksProperties.length);
              var n = this.masksProperties.length,
                  i = !1;
              for (r = 0; r < n; r += 1) this.masksProperties[r].mode !== "n" && (i = !0), this.viewData[r] = ShapePropertyFactory.getShapeProp(this.element, this.masksProperties[r], 3);
              this.hasMasks = i, i && this.element.addRenderableComponent(this)
          }

          function CVBaseElement() {}
          CVEffects.prototype.renderFrame = function(e) {
              var t, r = this.filters.length;
              for (t = 0; t < r; t += 1) this.filters[t].renderFrame(e)
          }, CVEffects.prototype.getEffects = function(e) {
              var t, r = this.filters.length,
                  n = [];
              for (t = 0; t < r; t += 1) this.filters[t].type === e && n.push(this.filters[t]);
              return n
          }, CVMaskElement.prototype.renderFrame = function() {
              if (this.hasMasks) {
                  var e, t, r, n, i = this.element.finalTransform.mat,
                      a = this.element.canvasContext,
                      s = this.masksProperties.length;
                  for (a.beginPath(), e = 0; e < s; e += 1)
                      if (this.masksProperties[e].mode !== "n") {
                          var o;
                          this.masksProperties[e].inv && (a.moveTo(0, 0), a.lineTo(this.element.globalData.compSize.w, 0), a.lineTo(this.element.globalData.compSize.w, this.element.globalData.compSize.h), a.lineTo(0, this.element.globalData.compSize.h), a.lineTo(0, 0)), n = this.viewData[e].v, t = i.applyToPointArray(n.v[0][0], n.v[0][1], 0), a.moveTo(t[0], t[1]);
                          var l = n._length;
                          for (o = 1; o < l; o += 1) r = i.applyToTriplePoints(n.o[o - 1], n.i[o], n.v[o]), a.bezierCurveTo(r[0], r[1], r[2], r[3], r[4], r[5]);
                          r = i.applyToTriplePoints(n.o[o - 1], n.i[0], n.v[0]), a.bezierCurveTo(r[0], r[1], r[2], r[3], r[4], r[5])
                      } this.element.globalData.renderer.save(!0), a.clip()
              }
          }, CVMaskElement.prototype.getMaskProperty = MaskElement.prototype.getMaskProperty, CVMaskElement.prototype.destroy = function() {
              this.element = null
          };
          var operationsMap = {
              1: "source-in",
              2: "source-out",
              3: "source-in",
              4: "source-out"
          };

          function CVShapeData(e, t, r, n) {
              this.styledShapes = [], this.tr = [0, 0, 0, 0, 0, 0];
              var i, a = 4;
              t.ty === "rc" ? a = 5 : t.ty === "el" ? a = 6 : t.ty === "sr" && (a = 7), this.sh = ShapePropertyFactory.getShapeProp(e, t, a, e);
              var s, o = r.length;
              for (i = 0; i < o; i += 1) r[i].closed || (s = {
                  transforms: n.addTransformSequence(r[i].transforms),
                  trNodes: []
              }, this.styledShapes.push(s), r[i].elements.push(s))
          }

          function CVShapeElement(e, t, r) {
              this.shapes = [], this.shapesData = e.shapes, this.stylesList = [], this.itemsData = [], this.prevViewData = [], this.shapeModifiers = [], this.processedElements = [], this.transformsManager = new ShapeTransformManager, this.initElement(e, t, r)
          }

          function CVTextElement(e, t, r) {
              this.textSpans = [], this.yOffset = 0, this.fillColorAnim = !1, this.strokeColorAnim = !1, this.strokeWidthAnim = !1, this.stroke = !1, this.fill = !1, this.justifyOffset = 0, this.currentRender = null, this.renderType = "canvas", this.values = {
                  fill: "rgba(0,0,0,0)",
                  stroke: "rgba(0,0,0,0)",
                  sWidth: 0,
                  fValue: ""
              }, this.initElement(e, t, r)
          }

          function CVImageElement(e, t, r) {
              this.assetData = t.getAssetData(e.refId), this.img = t.imageLoader.getAsset(this.assetData), this.initElement(e, t, r)
          }

          function CVSolidElement(e, t, r) {
              this.initElement(e, t, r)
          }

          function CanvasRendererBase() {}

          function CanvasContext() {
              this.opacity = -1, this.transform = createTypedArray("float32", 16), this.fillStyle = "", this.strokeStyle = "", this.lineWidth = "", this.lineCap = "", this.lineJoin = "", this.miterLimit = "", this.id = Math.random()
          }

          function CVContextData() {
              var e;
              for (this.stack = [], this.cArrPos = 0, this.cTr = new Matrix, e = 0; e < 15; e += 1) {
                  var t = new CanvasContext;
                  this.stack[e] = t
              }
              this._length = 15, this.nativeContext = null, this.transformMat = new Matrix, this.currentOpacity = 1, this.currentFillStyle = "", this.appliedFillStyle = "", this.currentStrokeStyle = "", this.appliedStrokeStyle = "", this.currentLineWidth = "", this.appliedLineWidth = "", this.currentLineCap = "", this.appliedLineCap = "", this.currentLineJoin = "", this.appliedLineJoin = "", this.appliedMiterLimit = "", this.currentMiterLimit = ""
          }

          function CVCompElement(e, t, r) {
              this.completeLayers = !1, this.layers = e.layers, this.pendingElements = [], this.elements = createSizedArray(this.layers.length), this.initElement(e, t, r), this.tm = e.tm ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this) : {
                  _placeholder: !0
              }
          }

          function CanvasRenderer(e, t) {
              this.animationItem = e, this.renderConfig = {
                  clearCanvas: !t || t.clearCanvas === void 0 || t.clearCanvas,
                  context: t && t.context || null,
                  progressiveLoad: t && t.progressiveLoad || !1,
                  preserveAspectRatio: t && t.preserveAspectRatio || "xMidYMid meet",
                  imagePreserveAspectRatio: t && t.imagePreserveAspectRatio || "xMidYMid slice",
                  contentVisibility: t && t.contentVisibility || "visible",
                  className: t && t.className || "",
                  id: t && t.id || "",
                  runExpressions: !t || t.runExpressions === void 0 || t.runExpressions
              }, this.renderConfig.dpr = t && t.dpr || 1, this.animationItem.wrapper && (this.renderConfig.dpr = t && t.dpr || window.devicePixelRatio || 1), this.renderedFrame = -1, this.globalData = {
                  frameNum: -1,
                  _mdf: !1,
                  renderConfig: this.renderConfig,
                  currentGlobalAlpha: -1
              }, this.contextData = new CVContextData, this.elements = [], this.pendingElements = [], this.transformMat = new Matrix, this.completeLayers = !1, this.rendererType = "canvas", this.renderConfig.clearCanvas && (this.ctxTransform = this.contextData.transform.bind(this.contextData), this.ctxOpacity = this.contextData.opacity.bind(this.contextData), this.ctxFillStyle = this.contextData.fillStyle.bind(this.contextData), this.ctxStrokeStyle = this.contextData.strokeStyle.bind(this.contextData), this.ctxLineWidth = this.contextData.lineWidth.bind(this.contextData), this.ctxLineCap = this.contextData.lineCap.bind(this.contextData), this.ctxLineJoin = this.contextData.lineJoin.bind(this.contextData), this.ctxMiterLimit = this.contextData.miterLimit.bind(this.contextData), this.ctxFill = this.contextData.fill.bind(this.contextData), this.ctxFillRect = this.contextData.fillRect.bind(this.contextData), this.ctxStroke = this.contextData.stroke.bind(this.contextData), this.save = this.contextData.save.bind(this.contextData))
          }

          function HBaseElement() {}

          function HSolidElement(e, t, r) {
              this.initElement(e, t, r)
          }

          function HShapeElement(e, t, r) {
              this.shapes = [], this.shapesData = e.shapes, this.stylesList = [], this.shapeModifiers = [], this.itemsData = [], this.processedElements = [], this.animatedContents = [], this.shapesContainer = createNS("g"), this.initElement(e, t, r), this.prevViewData = [], this.currentBBox = {
                  x: 999999,
                  y: -999999,
                  h: 0,
                  w: 0
              }
          }

          function HTextElement(e, t, r) {
              this.textSpans = [], this.textPaths = [], this.currentBBox = {
                  x: 999999,
                  y: -999999,
                  h: 0,
                  w: 0
              }, this.renderType = "svg", this.isMasked = !1, this.initElement(e, t, r)
          }

          function HCameraElement(e, t, r) {
              this.initFrame(), this.initBaseData(e, t, r), this.initHierarchy();
              var n = PropertyFactory.getProp;
              if (this.pe = n(this, e.pe, 0, 0, this), e.ks.p.s ? (this.px = n(this, e.ks.p.x, 1, 0, this), this.py = n(this, e.ks.p.y, 1, 0, this), this.pz = n(this, e.ks.p.z, 1, 0, this)) : this.p = n(this, e.ks.p, 1, 0, this), e.ks.a && (this.a = n(this, e.ks.a, 1, 0, this)), e.ks.or.k.length && e.ks.or.k[0].to) {
                  var i, a = e.ks.or.k.length;
                  for (i = 0; i < a; i += 1) e.ks.or.k[i].to = null, e.ks.or.k[i].ti = null
              }
              this.or = n(this, e.ks.or, 1, degToRads, this), this.or.sh = !0, this.rx = n(this, e.ks.rx, 0, degToRads, this), this.ry = n(this, e.ks.ry, 0, degToRads, this), this.rz = n(this, e.ks.rz, 0, degToRads, this), this.mat = new Matrix, this._prevMat = new Matrix, this._isFirstFrame = !0, this.finalTransform = {
                  mProp: this
              }
          }

          function HImageElement(e, t, r) {
              this.assetData = t.getAssetData(e.refId), this.initElement(e, t, r)
          }

          function HybridRendererBase(e, t) {
              this.animationItem = e, this.layers = null, this.renderedFrame = -1, this.renderConfig = {
                  className: t && t.className || "",
                  imagePreserveAspectRatio: t && t.imagePreserveAspectRatio || "xMidYMid slice",
                  hideOnTransparent: !(t && t.hideOnTransparent === !1),
                  filterSize: {
                      width: t && t.filterSize && t.filterSize.width || "400%",
                      height: t && t.filterSize && t.filterSize.height || "400%",
                      x: t && t.filterSize && t.filterSize.x || "-100%",
                      y: t && t.filterSize && t.filterSize.y || "-100%"
                  }
              }, this.globalData = {
                  _mdf: !1,
                  frameNum: -1,
                  renderConfig: this.renderConfig
              }, this.pendingElements = [], this.elements = [], this.threeDElements = [], this.destroyed = !1, this.camera = null, this.supports3d = !0, this.rendererType = "html"
          }

          function HCompElement(e, t, r) {
              this.layers = e.layers, this.supports3d = !e.hasMask, this.completeLayers = !1, this.pendingElements = [], this.elements = this.layers ? createSizedArray(this.layers.length) : [], this.initElement(e, t, r), this.tm = e.tm ? PropertyFactory.getProp(this, e.tm, 0, t.frameRate, this) : {
                  _placeholder: !0
              }
          }

          function HybridRenderer(e, t) {
              this.animationItem = e, this.layers = null, this.renderedFrame = -1, this.renderConfig = {
                  className: t && t.className || "",
                  imagePreserveAspectRatio: t && t.imagePreserveAspectRatio || "xMidYMid slice",
                  hideOnTransparent: !(t && t.hideOnTransparent === !1),
                  filterSize: {
                      width: t && t.filterSize && t.filterSize.width || "400%",
                      height: t && t.filterSize && t.filterSize.height || "400%",
                      x: t && t.filterSize && t.filterSize.x || "-100%",
                      y: t && t.filterSize && t.filterSize.y || "-100%"
                  },
                  runExpressions: !t || t.runExpressions === void 0 || t.runExpressions
              }, this.globalData = {
                  _mdf: !1,
                  frameNum: -1,
                  renderConfig: this.renderConfig
              }, this.pendingElements = [], this.elements = [], this.threeDElements = [], this.destroyed = !1, this.camera = null, this.supports3d = !0, this.rendererType = "html"
          }
          CVBaseElement.prototype = {
                  createElements: function() {},
                  initRendererElement: function() {},
                  createContainerElements: function() {
                      if (this.data.tt >= 1) {
                          this.buffers = [];
                          var e = this.globalData.canvasContext,
                              t = assetLoader.createCanvas(e.canvas.width, e.canvas.height);
                          this.buffers.push(t);
                          var r = assetLoader.createCanvas(e.canvas.width, e.canvas.height);
                          this.buffers.push(r), this.data.tt >= 3 && !document._isProxy && assetLoader.loadLumaCanvas()
                      }
                      this.canvasContext = this.globalData.canvasContext, this.transformCanvas = this.globalData.transformCanvas, this.renderableEffectsManager = new CVEffects(this), this.searchEffectTransforms()
                  },
                  createContent: function() {},
                  setBlendMode: function() {
                      var e = this.globalData;
                      if (e.blendMode !== this.data.bm) {
                          e.blendMode = this.data.bm;
                          var t = getBlendMode(this.data.bm);
                          e.canvasContext.globalCompositeOperation = t
                      }
                  },
                  createRenderableComponents: function() {
                      this.maskManager = new CVMaskElement(this.data, this), this.transformEffects = this.renderableEffectsManager.getEffects(effectTypes.TRANSFORM_EFFECT)
                  },
                  hideElement: function() {
                      this.hidden || this.isInRange && !this.isTransparent || (this.hidden = !0)
                  },
                  showElement: function() {
                      this.isInRange && !this.isTransparent && (this.hidden = !1, this._isFirstFrame = !0, this.maskManager._isFirstFrame = !0)
                  },
                  clearCanvas: function(e) {
                      e.clearRect(this.transformCanvas.tx, this.transformCanvas.ty, this.transformCanvas.w * this.transformCanvas.sx, this.transformCanvas.h * this.transformCanvas.sy)
                  },
                  prepareLayer: function() {
                      if (this.data.tt >= 1) {
                          var e = this.buffers[0].getContext("2d");
                          this.clearCanvas(e), e.drawImage(this.canvasContext.canvas, 0, 0), this.currentTransform = this.canvasContext.getTransform(), this.canvasContext.setTransform(1, 0, 0, 1, 0, 0), this.clearCanvas(this.canvasContext), this.canvasContext.setTransform(this.currentTransform)
                      }
                  },
                  exitLayer: function() {
                      if (this.data.tt >= 1) {
                          var e = this.buffers[1],
                              t = e.getContext("2d");
                          if (this.clearCanvas(t), t.drawImage(this.canvasContext.canvas, 0, 0), this.canvasContext.setTransform(1, 0, 0, 1, 0, 0), this.clearCanvas(this.canvasContext), this.canvasContext.setTransform(this.currentTransform), this.comp.getElementById("tp" in this.data ? this.data.tp : this.data.ind - 1)
                              .renderFrame(!0), this.canvasContext.setTransform(1, 0, 0, 1, 0, 0), this.data.tt >= 3 && !document._isProxy) {
                              var r = assetLoader.getLumaCanvas(this.canvasContext.canvas);
                              r.getContext("2d")
                                  .drawImage(this.canvasContext.canvas, 0, 0), this.clearCanvas(this.canvasContext), this.canvasContext.drawImage(r, 0, 0)
                          }
                          this.canvasContext.globalCompositeOperation = operationsMap[this.data.tt], this.canvasContext.drawImage(e, 0, 0), this.canvasContext.globalCompositeOperation = "destination-over", this.canvasContext.drawImage(this.buffers[0], 0, 0), this.canvasContext.setTransform(this.currentTransform), this.canvasContext.globalCompositeOperation = "source-over"
                      }
                  },
                  renderFrame: function(e) {
                      if (!this.hidden && !this.data.hd && (this.data.td !== 1 || e)) {
                          this.renderTransform(), this.renderRenderable(), this.renderLocalTransform(), this.setBlendMode();
                          var t = this.data.ty === 0;
                          this.prepareLayer(), this.globalData.renderer.save(t), this.globalData.renderer.ctxTransform(this.finalTransform.localMat.props), this.globalData.renderer.ctxOpacity(this.finalTransform.localOpacity), this.renderInnerContent(), this.globalData.renderer.restore(t), this.exitLayer(), this.maskManager.hasMasks && this.globalData.renderer.restore(!0), this._isFirstFrame && (this._isFirstFrame = !1)
                      }
                  },
                  destroy: function() {
                      this.canvasContext = null, this.data = null, this.globalData = null, this.maskManager.destroy()
                  },
                  mHelper: new Matrix
              }, CVBaseElement.prototype.hide = CVBaseElement.prototype.hideElement, CVBaseElement.prototype.show = CVBaseElement.prototype.showElement, CVShapeData.prototype.setAsAnimated = SVGShapeData.prototype.setAsAnimated, extendPrototype([BaseElement, TransformElement, CVBaseElement, IShapeElement, HierarchyElement, FrameElement, RenderableElement], CVShapeElement), CVShapeElement.prototype.initElement = RenderableDOMElement.prototype.initElement, CVShapeElement.prototype.transformHelper = {
                  opacity: 1,
                  _opMdf: !1
              }, CVShapeElement.prototype.dashResetter = [], CVShapeElement.prototype.createContent = function() {
                  this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, !0, [])
              }, CVShapeElement.prototype.createStyleElement = function(e, t) {
                  var r = {
                          data: e,
                          type: e.ty,
                          preTransforms: this.transformsManager.addTransformSequence(t),
                          transforms: [],
                          elements: [],
                          closed: e.hd === !0
                      },
                      n = {};
                  if (e.ty === "fl" || e.ty === "st" ? (n.c = PropertyFactory.getProp(this, e.c, 1, 255, this), n.c.k || (r.co = "rgb(" + bmFloor(n.c.v[0]) + "," + bmFloor(n.c.v[1]) + "," + bmFloor(n.c.v[2]) + ")")) : e.ty !== "gf" && e.ty !== "gs" || (n.s = PropertyFactory.getProp(this, e.s, 1, null, this), n.e = PropertyFactory.getProp(this, e.e, 1, null, this), n.h = PropertyFactory.getProp(this, e.h || {
                          k: 0
                      }, 0, .01, this), n.a = PropertyFactory.getProp(this, e.a || {
                          k: 0
                      }, 0, degToRads, this), n.g = new GradientProperty(this, e.g, this)), n.o = PropertyFactory.getProp(this, e.o, 0, .01, this), e.ty === "st" || e.ty === "gs") {
                      if (r.lc = lineCapEnum[e.lc || 2], r.lj = lineJoinEnum[e.lj || 2], e.lj == 1 && (r.ml = e.ml), n.w = PropertyFactory.getProp(this, e.w, 0, null, this), n.w.k || (r.wi = n.w.v), e.d) {
                          var i = new DashProperty(this, e.d, "canvas", this);
                          n.d = i, n.d.k || (r.da = n.d.dashArray, r.do = n.d.dashoffset[0])
                      }
                  } else r.r = e.r === 2 ? "evenodd" : "nonzero";
                  return this.stylesList.push(r), n.style = r, n
              }, CVShapeElement.prototype.createGroupElement = function() {
                  return {
                      it: [],
                      prevViewData: []
                  }
              }, CVShapeElement.prototype.createTransformElement = function(e) {
                  return {
                      transform: {
                          opacity: 1,
                          _opMdf: !1,
                          key: this.transformsManager.getNewKey(),
                          op: PropertyFactory.getProp(this, e.o, 0, .01, this),
                          mProps: TransformPropertyFactory.getTransformProperty(this, e, this)
                      }
                  }
              }, CVShapeElement.prototype.createShapeElement = function(e) {
                  var t = new CVShapeData(this, e, this.stylesList, this.transformsManager);
                  return this.shapes.push(t), this.addShapeToModifiers(t), t
              }, CVShapeElement.prototype.reloadShapes = function() {
                  var e;
                  this._isFirstFrame = !0;
                  var t = this.itemsData.length;
                  for (e = 0; e < t; e += 1) this.prevViewData[e] = this.itemsData[e];
                  for (this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, !0, []), t = this.dynamicProperties.length, e = 0; e < t; e += 1) this.dynamicProperties[e].getValue();
                  this.renderModifiers(), this.transformsManager.processSequences(this._isFirstFrame)
              }, CVShapeElement.prototype.addTransformToStyleList = function(e) {
                  var t, r = this.stylesList.length;
                  for (t = 0; t < r; t += 1) this.stylesList[t].closed || this.stylesList[t].transforms.push(e)
              }, CVShapeElement.prototype.removeTransformFromStyleList = function() {
                  var e, t = this.stylesList.length;
                  for (e = 0; e < t; e += 1) this.stylesList[e].closed || this.stylesList[e].transforms.pop()
              }, CVShapeElement.prototype.closeStyles = function(e) {
                  var t, r = e.length;
                  for (t = 0; t < r; t += 1) e[t].closed = !0
              }, CVShapeElement.prototype.searchShapes = function(e, t, r, n, i) {
                  var a, s, o, l, f, u, c = e.length - 1,
                      v = [],
                      d = [],
                      p = [].concat(i);
                  for (a = c; a >= 0; a -= 1) {
                      if ((l = this.searchProcessedElement(e[a])) ? t[a] = r[l - 1] : e[a]._shouldRender = n, e[a].ty === "fl" || e[a].ty === "st" || e[a].ty === "gf" || e[a].ty === "gs") l ? t[a].style.closed = !1 : t[a] = this.createStyleElement(e[a], p), v.push(t[a].style);
                      else if (e[a].ty === "gr") {
                          if (l)
                              for (o = t[a].it.length, s = 0; s < o; s += 1) t[a].prevViewData[s] = t[a].it[s];
                          else t[a] = this.createGroupElement(e[a]);
                          this.searchShapes(e[a].it, t[a].it, t[a].prevViewData, n, p)
                      } else e[a].ty === "tr" ? (l || (u = this.createTransformElement(e[a]), t[a] = u), p.push(t[a]), this.addTransformToStyleList(t[a])) : e[a].ty === "sh" || e[a].ty === "rc" || e[a].ty === "el" || e[a].ty === "sr" ? l || (t[a] = this.createShapeElement(e[a])) : e[a].ty === "tm" || e[a].ty === "rd" || e[a].ty === "pb" || e[a].ty === "zz" || e[a].ty === "op" ? (l ? (f = t[a])
                          .closed = !1 : ((f = ShapeModifiers.getModifier(e[a].ty))
                              .init(this, e[a]), t[a] = f, this.shapeModifiers.push(f)), d.push(f)) : e[a].ty === "rp" && (l ? (f = t[a])
                          .closed = !0 : (f = ShapeModifiers.getModifier(e[a].ty), t[a] = f, f.init(this, e, a, t), this.shapeModifiers.push(f), n = !1), d.push(f));
                      this.addProcessedElement(e[a], a + 1)
                  }
                  for (this.removeTransformFromStyleList(), this.closeStyles(v), c = d.length, a = 0; a < c; a += 1) d[a].closed = !0
              }, CVShapeElement.prototype.renderInnerContent = function() {
                  this.transformHelper.opacity = 1, this.transformHelper._opMdf = !1, this.renderModifiers(), this.transformsManager.processSequences(this._isFirstFrame), this.renderShape(this.transformHelper, this.shapesData, this.itemsData, !0)
              }, CVShapeElement.prototype.renderShapeTransform = function(e, t) {
                  (e._opMdf || t.op._mdf || this._isFirstFrame) && (t.opacity = e.opacity, t.opacity *= t.op.v, t._opMdf = !0)
              }, CVShapeElement.prototype.drawLayer = function() {
                  var e, t, r, n, i, a, s, o, l, f = this.stylesList.length,
                      u = this.globalData.renderer,
                      c = this.globalData.canvasContext;
                  for (e = 0; e < f; e += 1)
                      if (((o = (l = this.stylesList[e])
                              .type) !== "st" && o !== "gs" || l.wi !== 0) && l.data._shouldRender && l.coOp !== 0 && this.globalData.currentGlobalAlpha !== 0) {
                          for (u.save(), a = l.elements, o === "st" || o === "gs" ? (u.ctxStrokeStyle(o === "st" ? l.co : l.grd), u.ctxLineWidth(l.wi), u.ctxLineCap(l.lc), u.ctxLineJoin(l.lj), u.ctxMiterLimit(l.ml || 0)) : u.ctxFillStyle(o === "fl" ? l.co : l.grd), u.ctxOpacity(l.coOp), o !== "st" && o !== "gs" && c.beginPath(), u.ctxTransform(l.preTransforms.finalTransform.props), r = a.length, t = 0; t < r; t += 1) {
                              for (o !== "st" && o !== "gs" || (c.beginPath(), l.da && (c.setLineDash(l.da), c.lineDashOffset = l.do)), i = (s = a[t].trNodes)
                                  .length, n = 0; n < i; n += 1) s[n].t === "m" ? c.moveTo(s[n].p[0], s[n].p[1]) : s[n].t === "c" ? c.bezierCurveTo(s[n].pts[0], s[n].pts[1], s[n].pts[2], s[n].pts[3], s[n].pts[4], s[n].pts[5]) : c.closePath();
                              o !== "st" && o !== "gs" || (u.ctxStroke(), l.da && c.setLineDash(this.dashResetter))
                          }
                          o !== "st" && o !== "gs" && this.globalData.renderer.ctxFill(l.r), u.restore()
                      }
              }, CVShapeElement.prototype.renderShape = function(e, t, r, n) {
                  var i, a;
                  for (a = e, i = t.length - 1; i >= 0; i -= 1) t[i].ty === "tr" ? (a = r[i].transform, this.renderShapeTransform(e, a)) : t[i].ty === "sh" || t[i].ty === "el" || t[i].ty === "rc" || t[i].ty === "sr" ? this.renderPath(t[i], r[i]) : t[i].ty === "fl" ? this.renderFill(t[i], r[i], a) : t[i].ty === "st" ? this.renderStroke(t[i], r[i], a) : t[i].ty === "gf" || t[i].ty === "gs" ? this.renderGradientFill(t[i], r[i], a) : t[i].ty === "gr" ? this.renderShape(a, t[i].it, r[i].it) : t[i].ty;
                  n && this.drawLayer()
              }, CVShapeElement.prototype.renderStyledShape = function(e, t) {
                  if (this._isFirstFrame || t._mdf || e.transforms._mdf) {
                      var r, n, i, a = e.trNodes,
                          s = t.paths,
                          o = s._length;
                      a.length = 0;
                      var l = e.transforms.finalTransform;
                      for (i = 0; i < o; i += 1) {
                          var f = s.shapes[i];
                          if (f && f.v) {
                              for (n = f._length, r = 1; r < n; r += 1) r === 1 && a.push({
                                  t: "m",
                                  p: l.applyToPointArray(f.v[0][0], f.v[0][1], 0)
                              }), a.push({
                                  t: "c",
                                  pts: l.applyToTriplePoints(f.o[r - 1], f.i[r], f.v[r])
                              });
                              n === 1 && a.push({
                                  t: "m",
                                  p: l.applyToPointArray(f.v[0][0], f.v[0][1], 0)
                              }), f.c && n && (a.push({
                                  t: "c",
                                  pts: l.applyToTriplePoints(f.o[r - 1], f.i[0], f.v[0])
                              }), a.push({
                                  t: "z"
                              }))
                          }
                      }
                      e.trNodes = a
                  }
              }, CVShapeElement.prototype.renderPath = function(e, t) {
                  if (e.hd !== !0 && e._shouldRender) {
                      var r, n = t.styledShapes.length;
                      for (r = 0; r < n; r += 1) this.renderStyledShape(t.styledShapes[r], t.sh)
                  }
              }, CVShapeElement.prototype.renderFill = function(e, t, r) {
                  var n = t.style;
                  (t.c._mdf || this._isFirstFrame) && (n.co = "rgb(" + bmFloor(t.c.v[0]) + "," + bmFloor(t.c.v[1]) + "," + bmFloor(t.c.v[2]) + ")"), (t.o._mdf || r._opMdf || this._isFirstFrame) && (n.coOp = t.o.v * r.opacity)
              }, CVShapeElement.prototype.renderGradientFill = function(e, t, r) {
                  var n, i = t.style;
                  if (!i.grd || t.g._mdf || t.s._mdf || t.e._mdf || e.t !== 1 && (t.h._mdf || t.a._mdf)) {
                      var a, s = this.globalData.canvasContext,
                          o = t.s.v,
                          l = t.e.v;
                      if (e.t === 1) n = s.createLinearGradient(o[0], o[1], l[0], l[1]);
                      else {
                          var f = Math.sqrt(Math.pow(o[0] - l[0], 2) + Math.pow(o[1] - l[1], 2)),
                              u = Math.atan2(l[1] - o[1], l[0] - o[0]),
                              c = t.h.v;
                          c >= 1 ? c = .99 : c <= -1 && (c = -.99);
                          var v = f * c,
                              d = Math.cos(u + t.a.v) * v + o[0],
                              p = Math.sin(u + t.a.v) * v + o[1];
                          n = s.createRadialGradient(d, p, 0, o[0], o[1], f)
                      }
                      var m = e.g.p,
                          h = t.g.c,
                          g = 1;
                      for (a = 0; a < m; a += 1) t.g._hasOpacity && t.g._collapsable && (g = t.g.o[2 * a + 1]), n.addColorStop(h[4 * a] / 100, "rgba(" + h[4 * a + 1] + "," + h[4 * a + 2] + "," + h[4 * a + 3] + "," + g + ")");
                      i.grd = n
                  }
                  i.coOp = t.o.v * r.opacity
              }, CVShapeElement.prototype.renderStroke = function(e, t, r) {
                  var n = t.style,
                      i = t.d;
                  i && (i._mdf || this._isFirstFrame) && (n.da = i.dashArray, n.do = i.dashoffset[0]), (t.c._mdf || this._isFirstFrame) && (n.co = "rgb(" + bmFloor(t.c.v[0]) + "," + bmFloor(t.c.v[1]) + "," + bmFloor(t.c.v[2]) + ")"), (t.o._mdf || r._opMdf || this._isFirstFrame) && (n.coOp = t.o.v * r.opacity), (t.w._mdf || this._isFirstFrame) && (n.wi = t.w.v)
              }, CVShapeElement.prototype.destroy = function() {
                  this.shapesData = null, this.globalData = null, this.canvasContext = null, this.stylesList.length = 0, this.itemsData.length = 0
              }, extendPrototype([BaseElement, TransformElement, CVBaseElement, HierarchyElement, FrameElement, RenderableElement, ITextElement], CVTextElement), CVTextElement.prototype.tHelper = createTag("canvas")
              .getContext("2d"), CVTextElement.prototype.buildNewText = function() {
                  var e = this.textProperty.currentData;
                  this.renderedLetters = createSizedArray(e.l ? e.l.length : 0);
                  var t = !1;
                  e.fc ? (t = !0, this.values.fill = this.buildColor(e.fc)) : this.values.fill = "rgba(0,0,0,0)", this.fill = t;
                  var r = !1;
                  e.sc && (r = !0, this.values.stroke = this.buildColor(e.sc), this.values.sWidth = e.sw);
                  var n, i, a, s, o, l, f, u, c, v, d, p, m = this.globalData.fontManager.getFontByName(e.f),
                      h = e.l,
                      g = this.mHelper;
                  this.stroke = r, this.values.fValue = e.finalSize + "px " + this.globalData.fontManager.getFontByName(e.f)
                      .fFamily, i = e.finalText.length;
                  var y = this.data.singleShape,
                      b = .001 * e.tr * e.finalSize,
                      _ = 0,
                      I = 0,
                      C = !0,
                      x = 0;
                  for (n = 0; n < i; n += 1) {
                      s = (a = this.globalData.fontManager.getCharData(e.finalText[n], m.fStyle, this.globalData.fontManager.getFontByName(e.f)
                              .fFamily)) && a.data || {}, g.reset(), y && h[n].n && (_ = -b, I += e.yOffset, I += C ? 1 : 0, C = !1), c = (f = s.shapes ? s.shapes[0].it : [])
                          .length, g.scale(e.finalSize / 100, e.finalSize / 100), y && this.applyTextPropertiesToMatrix(e, g, h[n].line, _, I), d = createSizedArray(c - 1);
                      var O = 0;
                      for (u = 0; u < c; u += 1)
                          if (f[u].ty === "sh") {
                              for (l = f[u].ks.k.i.length, v = f[u].ks.k, p = [], o = 1; o < l; o += 1) o === 1 && p.push(g.applyToX(v.v[0][0], v.v[0][1], 0), g.applyToY(v.v[0][0], v.v[0][1], 0)), p.push(g.applyToX(v.o[o - 1][0], v.o[o - 1][1], 0), g.applyToY(v.o[o - 1][0], v.o[o - 1][1], 0), g.applyToX(v.i[o][0], v.i[o][1], 0), g.applyToY(v.i[o][0], v.i[o][1], 0), g.applyToX(v.v[o][0], v.v[o][1], 0), g.applyToY(v.v[o][0], v.v[o][1], 0));
                              p.push(g.applyToX(v.o[o - 1][0], v.o[o - 1][1], 0), g.applyToY(v.o[o - 1][0], v.o[o - 1][1], 0), g.applyToX(v.i[0][0], v.i[0][1], 0), g.applyToY(v.i[0][0], v.i[0][1], 0), g.applyToX(v.v[0][0], v.v[0][1], 0), g.applyToY(v.v[0][0], v.v[0][1], 0)), d[O] = p, O += 1
                          } y && (_ += h[n].l, _ += b), this.textSpans[x] ? this.textSpans[x].elem = d : this.textSpans[x] = {
                          elem: d
                      }, x += 1
                  }
              }, CVTextElement.prototype.renderInnerContent = function() {
                  var e, t, r, n, i, a;
                  this.validateText(), this.canvasContext.font = this.values.fValue, this.globalData.renderer.ctxLineCap("butt"), this.globalData.renderer.ctxLineJoin("miter"), this.globalData.renderer.ctxMiterLimit(4), this.data.singleShape || this.textAnimator.getMeasures(this.textProperty.currentData, this.lettersChangedFlag);
                  var s, o = this.textAnimator.renderedLetters,
                      l = this.textProperty.currentData.l;
                  t = l.length;
                  var f, u, c = null,
                      v = null,
                      d = null,
                      p = this.globalData.renderer;
                  for (e = 0; e < t; e += 1)
                      if (!l[e].n) {
                          if ((s = o[e]) && (p.save(), p.ctxTransform(s.p), p.ctxOpacity(s.o)), this.fill) {
                              for (s && s.fc ? c !== s.fc && (p.ctxFillStyle(s.fc), c = s.fc) : c !== this.values.fill && (c = this.values.fill, p.ctxFillStyle(this.values.fill)), n = (f = this.textSpans[e].elem)
                                  .length, this.globalData.canvasContext.beginPath(), r = 0; r < n; r += 1)
                                  for (a = (u = f[r])
                                      .length, this.globalData.canvasContext.moveTo(u[0], u[1]), i = 2; i < a; i += 6) this.globalData.canvasContext.bezierCurveTo(u[i], u[i + 1], u[i + 2], u[i + 3], u[i + 4], u[i + 5]);
                              this.globalData.canvasContext.closePath(), p.ctxFill()
                          }
                          if (this.stroke) {
                              for (s && s.sw ? d !== s.sw && (d = s.sw, p.ctxLineWidth(s.sw)) : d !== this.values.sWidth && (d = this.values.sWidth, p.ctxLineWidth(this.values.sWidth)), s && s.sc ? v !== s.sc && (v = s.sc, p.ctxStrokeStyle(s.sc)) : v !== this.values.stroke && (v = this.values.stroke, p.ctxStrokeStyle(this.values.stroke)), n = (f = this.textSpans[e].elem)
                                  .length, this.globalData.canvasContext.beginPath(), r = 0; r < n; r += 1)
                                  for (a = (u = f[r])
                                      .length, this.globalData.canvasContext.moveTo(u[0], u[1]), i = 2; i < a; i += 6) this.globalData.canvasContext.bezierCurveTo(u[i], u[i + 1], u[i + 2], u[i + 3], u[i + 4], u[i + 5]);
                              this.globalData.canvasContext.closePath(), p.ctxStroke()
                          }
                          s && this.globalData.renderer.restore()
                      }
              }, extendPrototype([BaseElement, TransformElement, CVBaseElement, HierarchyElement, FrameElement, RenderableElement], CVImageElement), CVImageElement.prototype.initElement = SVGShapeElement.prototype.initElement, CVImageElement.prototype.prepareFrame = IImageElement.prototype.prepareFrame, CVImageElement.prototype.createContent = function() {
                  if (this.img.width && (this.assetData.w !== this.img.width || this.assetData.h !== this.img.height)) {
                      var e = createTag("canvas");
                      e.width = this.assetData.w, e.height = this.assetData.h;
                      var t, r, n = e.getContext("2d"),
                          i = this.img.width,
                          a = this.img.height,
                          s = i / a,
                          o = this.assetData.w / this.assetData.h,
                          l = this.assetData.pr || this.globalData.renderConfig.imagePreserveAspectRatio;
                      s > o && l === "xMidYMid slice" || s < o && l !== "xMidYMid slice" ? t = (r = a) * o : r = (t = i) / o, n.drawImage(this.img, (i - t) / 2, (a - r) / 2, t, r, 0, 0, this.assetData.w, this.assetData.h), this.img = e
                  }
              }, CVImageElement.prototype.renderInnerContent = function() {
                  this.canvasContext.drawImage(this.img, 0, 0)
              }, CVImageElement.prototype.destroy = function() {
                  this.img = null
              }, extendPrototype([BaseElement, TransformElement, CVBaseElement, HierarchyElement, FrameElement, RenderableElement], CVSolidElement), CVSolidElement.prototype.initElement = SVGShapeElement.prototype.initElement, CVSolidElement.prototype.prepareFrame = IImageElement.prototype.prepareFrame, CVSolidElement.prototype.renderInnerContent = function() {
                  this.globalData.renderer.ctxFillStyle(this.data.sc), this.globalData.renderer.ctxFillRect(0, 0, this.data.sw, this.data.sh)
              }, extendPrototype([BaseRenderer], CanvasRendererBase), CanvasRendererBase.prototype.createShape = function(e) {
                  return new CVShapeElement(e, this.globalData, this)
              }, CanvasRendererBase.prototype.createText = function(e) {
                  return new CVTextElement(e, this.globalData, this)
              }, CanvasRendererBase.prototype.createImage = function(e) {
                  return new CVImageElement(e, this.globalData, this)
              }, CanvasRendererBase.prototype.createSolid = function(e) {
                  return new CVSolidElement(e, this.globalData, this)
              }, CanvasRendererBase.prototype.createNull = SVGRenderer.prototype.createNull, CanvasRendererBase.prototype.ctxTransform = function(e) {
                  e[0] === 1 && e[1] === 0 && e[4] === 0 && e[5] === 1 && e[12] === 0 && e[13] === 0 || this.canvasContext.transform(e[0], e[1], e[4], e[5], e[12], e[13])
              }, CanvasRendererBase.prototype.ctxOpacity = function(e) {
                  this.canvasContext.globalAlpha *= e < 0 ? 0 : e
              }, CanvasRendererBase.prototype.ctxFillStyle = function(e) {
                  this.canvasContext.fillStyle = e
              }, CanvasRendererBase.prototype.ctxStrokeStyle = function(e) {
                  this.canvasContext.strokeStyle = e
              }, CanvasRendererBase.prototype.ctxLineWidth = function(e) {
                  this.canvasContext.lineWidth = e
              }, CanvasRendererBase.prototype.ctxLineCap = function(e) {
                  this.canvasContext.lineCap = e
              }, CanvasRendererBase.prototype.ctxLineJoin = function(e) {
                  this.canvasContext.lineJoin = e
              }, CanvasRendererBase.prototype.ctxMiterLimit = function(e) {
                  this.canvasContext.miterLimit = e
              }, CanvasRendererBase.prototype.ctxFill = function(e) {
                  this.canvasContext.fill(e)
              }, CanvasRendererBase.prototype.ctxFillRect = function(e, t, r, n) {
                  this.canvasContext.fillRect(e, t, r, n)
              }, CanvasRendererBase.prototype.ctxStroke = function() {
                  this.canvasContext.stroke()
              }, CanvasRendererBase.prototype.reset = function() {
                  this.renderConfig.clearCanvas ? this.contextData.reset() : this.canvasContext.restore()
              }, CanvasRendererBase.prototype.save = function() {
                  this.canvasContext.save()
              }, CanvasRendererBase.prototype.restore = function(e) {
                  this.renderConfig.clearCanvas ? (e && (this.globalData.blendMode = "source-over"), this.contextData.restore(e)) : this.canvasContext.restore()
              }, CanvasRendererBase.prototype.configAnimation = function(e) {
                  if (this.animationItem.wrapper) {
                      this.animationItem.container = createTag("canvas");
                      var t = this.animationItem.container.style;
                      t.width = "100%", t.height = "100%";
                      var r = "0px 0px 0px";
                      t.transformOrigin = r, t.mozTransformOrigin = r, t.webkitTransformOrigin = r, t["-webkit-transform"] = r, t.contentVisibility = this.renderConfig.contentVisibility, this.animationItem.wrapper.appendChild(this.animationItem.container), this.canvasContext = this.animationItem.container.getContext("2d"), this.renderConfig.className && this.animationItem.container.setAttribute("class", this.renderConfig.className), this.renderConfig.id && this.animationItem.container.setAttribute("id", this.renderConfig.id)
                  } else this.canvasContext = this.renderConfig.context;
                  this.contextData.setContext(this.canvasContext), this.data = e, this.layers = e.layers, this.transformCanvas = {
                      w: e.w,
                      h: e.h,
                      sx: 0,
                      sy: 0,
                      tx: 0,
                      ty: 0
                  }, this.setupGlobalData(e, document.body), this.globalData.canvasContext = this.canvasContext, this.globalData.renderer = this, this.globalData.isDashed = !1, this.globalData.progressiveLoad = this.renderConfig.progressiveLoad, this.globalData.transformCanvas = this.transformCanvas, this.elements = createSizedArray(e.layers.length), this.updateContainerSize()
              }, CanvasRendererBase.prototype.updateContainerSize = function(e, t) {
                  var r, n, i, a;
                  if (this.reset(), e ? (r = e, n = t, this.canvasContext.canvas.width = r, this.canvasContext.canvas.height = n) : (this.animationItem.wrapper && this.animationItem.container ? (r = this.animationItem.wrapper.offsetWidth, n = this.animationItem.wrapper.offsetHeight) : (r = this.canvasContext.canvas.width, n = this.canvasContext.canvas.height), this.canvasContext.canvas.width = r * this.renderConfig.dpr, this.canvasContext.canvas.height = n * this.renderConfig.dpr), this.renderConfig.preserveAspectRatio.indexOf("meet") !== -1 || this.renderConfig.preserveAspectRatio.indexOf("slice") !== -1) {
                      var s = this.renderConfig.preserveAspectRatio.split(" "),
                          o = s[1] || "meet",
                          l = s[0] || "xMidYMid",
                          f = l.substr(0, 4),
                          u = l.substr(4);
                      i = r / n, (a = this.transformCanvas.w / this.transformCanvas.h) > i && o === "meet" || a < i && o === "slice" ? (this.transformCanvas.sx = r / (this.transformCanvas.w / this.renderConfig.dpr), this.transformCanvas.sy = r / (this.transformCanvas.w / this.renderConfig.dpr)) : (this.transformCanvas.sx = n / (this.transformCanvas.h / this.renderConfig.dpr), this.transformCanvas.sy = n / (this.transformCanvas.h / this.renderConfig.dpr)), this.transformCanvas.tx = f === "xMid" && (a < i && o === "meet" || a > i && o === "slice") ? (r - this.transformCanvas.w * (n / this.transformCanvas.h)) / 2 * this.renderConfig.dpr : f === "xMax" && (a < i && o === "meet" || a > i && o === "slice") ? (r - this.transformCanvas.w * (n / this.transformCanvas.h)) * this.renderConfig.dpr : 0, this.transformCanvas.ty = u === "YMid" && (a > i && o === "meet" || a < i && o === "slice") ? (n - this.transformCanvas.h * (r / this.transformCanvas.w)) / 2 * this.renderConfig.dpr : u === "YMax" && (a > i && o === "meet" || a < i && o === "slice") ? (n - this.transformCanvas.h * (r / this.transformCanvas.w)) * this.renderConfig.dpr : 0
                  } else this.renderConfig.preserveAspectRatio === "none" ? (this.transformCanvas.sx = r / (this.transformCanvas.w / this.renderConfig.dpr), this.transformCanvas.sy = n / (this.transformCanvas.h / this.renderConfig.dpr), this.transformCanvas.tx = 0, this.transformCanvas.ty = 0) : (this.transformCanvas.sx = this.renderConfig.dpr, this.transformCanvas.sy = this.renderConfig.dpr, this.transformCanvas.tx = 0, this.transformCanvas.ty = 0);
                  this.transformCanvas.props = [this.transformCanvas.sx, 0, 0, 0, 0, this.transformCanvas.sy, 0, 0, 0, 0, 1, 0, this.transformCanvas.tx, this.transformCanvas.ty, 0, 1], this.ctxTransform(this.transformCanvas.props), this.canvasContext.beginPath(), this.canvasContext.rect(0, 0, this.transformCanvas.w, this.transformCanvas.h), this.canvasContext.closePath(), this.canvasContext.clip(), this.renderFrame(this.renderedFrame, !0)
              }, CanvasRendererBase.prototype.destroy = function() {
                  var e;
                  for (this.renderConfig.clearCanvas && this.animationItem.wrapper && (this.animationItem.wrapper.innerText = ""), e = (this.layers ? this.layers.length : 0) - 1; e >= 0; e -= 1) this.elements[e] && this.elements[e].destroy && this.elements[e].destroy();
                  this.elements.length = 0, this.globalData.canvasContext = null, this.animationItem.container = null, this.destroyed = !0
              }, CanvasRendererBase.prototype.renderFrame = function(e, t) {
                  if ((this.renderedFrame !== e || this.renderConfig.clearCanvas !== !0 || t) && !this.destroyed && e !== -1) {
                      var r;
                      this.renderedFrame = e, this.globalData.frameNum = e - this.animationItem._isFirstFrame, this.globalData.frameId += 1, this.globalData._mdf = !this.renderConfig.clearCanvas || t, this.globalData.projectInterface.currentFrame = e;
                      var n = this.layers.length;
                      for (this.completeLayers || this.checkLayers(e), r = n - 1; r >= 0; r -= 1)(this.completeLayers || this.elements[r]) && this.elements[r].prepareFrame(e - this.layers[r].st);
                      if (this.globalData._mdf) {
                          for (this.renderConfig.clearCanvas === !0 ? this.canvasContext.clearRect(0, 0, this.transformCanvas.w, this.transformCanvas.h) : this.save(), r = n - 1; r >= 0; r -= 1)(this.completeLayers || this.elements[r]) && this.elements[r].renderFrame();
                          this.renderConfig.clearCanvas !== !0 && this.restore()
                      }
                  }
              }, CanvasRendererBase.prototype.buildItem = function(e) {
                  var t = this.elements;
                  if (!t[e] && this.layers[e].ty !== 99) {
                      var r = this.createItem(this.layers[e], this, this.globalData);
                      t[e] = r, r.initExpressions()
                  }
              }, CanvasRendererBase.prototype.checkPendingElements = function() {
                  for (; this.pendingElements.length;) this.pendingElements.pop()
                      .checkParenting()
              }, CanvasRendererBase.prototype.hide = function() {
                  this.animationItem.container.style.display = "none"
              }, CanvasRendererBase.prototype.show = function() {
                  this.animationItem.container.style.display = "block"
              }, CVContextData.prototype.duplicate = function() {
                  var e = 2 * this._length,
                      t = 0;
                  for (t = this._length; t < e; t += 1) this.stack[t] = new CanvasContext;
                  this._length = e
              }, CVContextData.prototype.reset = function() {
                  this.cArrPos = 0, this.cTr.reset(), this.stack[this.cArrPos].opacity = 1
              }, CVContextData.prototype.restore = function(e) {
                  this.cArrPos -= 1;
                  var t, r = this.stack[this.cArrPos],
                      n = r.transform,
                      i = this.cTr.props;
                  for (t = 0; t < 16; t += 1) i[t] = n[t];
                  if (e) {
                      this.nativeContext.restore();
                      var a = this.stack[this.cArrPos + 1];
                      this.appliedFillStyle = a.fillStyle, this.appliedStrokeStyle = a.strokeStyle, this.appliedLineWidth = a.lineWidth, this.appliedLineCap = a.lineCap, this.appliedLineJoin = a.lineJoin, this.appliedMiterLimit = a.miterLimit
                  }
                  this.nativeContext.setTransform(n[0], n[1], n[4], n[5], n[12], n[13]), (e || r.opacity !== -1 && this.currentOpacity !== r.opacity) && (this.nativeContext.globalAlpha = r.opacity, this.currentOpacity = r.opacity), this.currentFillStyle = r.fillStyle, this.currentStrokeStyle = r.strokeStyle, this.currentLineWidth = r.lineWidth, this.currentLineCap = r.lineCap, this.currentLineJoin = r.lineJoin, this.currentMiterLimit = r.miterLimit
              }, CVContextData.prototype.save = function(e) {
                  e && this.nativeContext.save();
                  var t = this.cTr.props;
                  this._length <= this.cArrPos && this.duplicate();
                  var r, n = this.stack[this.cArrPos];
                  for (r = 0; r < 16; r += 1) n.transform[r] = t[r];
                  this.cArrPos += 1;
                  var i = this.stack[this.cArrPos];
                  i.opacity = n.opacity, i.fillStyle = n.fillStyle, i.strokeStyle = n.strokeStyle, i.lineWidth = n.lineWidth, i.lineCap = n.lineCap, i.lineJoin = n.lineJoin, i.miterLimit = n.miterLimit
              }, CVContextData.prototype.setOpacity = function(e) {
                  this.stack[this.cArrPos].opacity = e
              }, CVContextData.prototype.setContext = function(e) {
                  this.nativeContext = e
              }, CVContextData.prototype.fillStyle = function(e) {
                  this.stack[this.cArrPos].fillStyle !== e && (this.currentFillStyle = e, this.stack[this.cArrPos].fillStyle = e)
              }, CVContextData.prototype.strokeStyle = function(e) {
                  this.stack[this.cArrPos].strokeStyle !== e && (this.currentStrokeStyle = e, this.stack[this.cArrPos].strokeStyle = e)
              }, CVContextData.prototype.lineWidth = function(e) {
                  this.stack[this.cArrPos].lineWidth !== e && (this.currentLineWidth = e, this.stack[this.cArrPos].lineWidth = e)
              }, CVContextData.prototype.lineCap = function(e) {
                  this.stack[this.cArrPos].lineCap !== e && (this.currentLineCap = e, this.stack[this.cArrPos].lineCap = e)
              }, CVContextData.prototype.lineJoin = function(e) {
                  this.stack[this.cArrPos].lineJoin !== e && (this.currentLineJoin = e, this.stack[this.cArrPos].lineJoin = e)
              }, CVContextData.prototype.miterLimit = function(e) {
                  this.stack[this.cArrPos].miterLimit !== e && (this.currentMiterLimit = e, this.stack[this.cArrPos].miterLimit = e)
              }, CVContextData.prototype.transform = function(e) {
                  this.transformMat.cloneFromProps(e);
                  var t = this.cTr;
                  this.transformMat.multiply(t), t.cloneFromProps(this.transformMat.props);
                  var r = t.props;
                  this.nativeContext.setTransform(r[0], r[1], r[4], r[5], r[12], r[13])
              }, CVContextData.prototype.opacity = function(e) {
                  var t = this.stack[this.cArrPos].opacity;
                  t *= e < 0 ? 0 : e, this.stack[this.cArrPos].opacity !== t && (this.currentOpacity !== e && (this.nativeContext.globalAlpha = e, this.currentOpacity = e), this.stack[this.cArrPos].opacity = t)
              }, CVContextData.prototype.fill = function(e) {
                  this.appliedFillStyle !== this.currentFillStyle && (this.appliedFillStyle = this.currentFillStyle, this.nativeContext.fillStyle = this.appliedFillStyle), this.nativeContext.fill(e)
              }, CVContextData.prototype.fillRect = function(e, t, r, n) {
                  this.appliedFillStyle !== this.currentFillStyle && (this.appliedFillStyle = this.currentFillStyle, this.nativeContext.fillStyle = this.appliedFillStyle), this.nativeContext.fillRect(e, t, r, n)
              }, CVContextData.prototype.stroke = function() {
                  this.appliedStrokeStyle !== this.currentStrokeStyle && (this.appliedStrokeStyle = this.currentStrokeStyle, this.nativeContext.strokeStyle = this.appliedStrokeStyle), this.appliedLineWidth !== this.currentLineWidth && (this.appliedLineWidth = this.currentLineWidth, this.nativeContext.lineWidth = this.appliedLineWidth), this.appliedLineCap !== this.currentLineCap && (this.appliedLineCap = this.currentLineCap, this.nativeContext.lineCap = this.appliedLineCap), this.appliedLineJoin !== this.currentLineJoin && (this.appliedLineJoin = this.currentLineJoin, this.nativeContext.lineJoin = this.appliedLineJoin), this.appliedMiterLimit !== this.currentMiterLimit && (this.appliedMiterLimit = this.currentMiterLimit, this.nativeContext.miterLimit = this.appliedMiterLimit), this.nativeContext.stroke()
              }, extendPrototype([CanvasRendererBase, ICompElement, CVBaseElement], CVCompElement), CVCompElement.prototype.renderInnerContent = function() {
                  var e, t = this.canvasContext;
                  for (t.beginPath(), t.moveTo(0, 0), t.lineTo(this.data.w, 0), t.lineTo(this.data.w, this.data.h), t.lineTo(0, this.data.h), t.lineTo(0, 0), t.clip(), e = this.layers.length - 1; e >= 0; e -= 1)(this.completeLayers || this.elements[e]) && this.elements[e].renderFrame()
              }, CVCompElement.prototype.destroy = function() {
                  var e;
                  for (e = this.layers.length - 1; e >= 0; e -= 1) this.elements[e] && this.elements[e].destroy();
                  this.layers = null, this.elements = null
              }, CVCompElement.prototype.createComp = function(e) {
                  return new CVCompElement(e, this.globalData, this)
              }, extendPrototype([CanvasRendererBase], CanvasRenderer), CanvasRenderer.prototype.createComp = function(e) {
                  return new CVCompElement(e, this.globalData, this)
              }, HBaseElement.prototype = {
                  checkBlendMode: function() {},
                  initRendererElement: function() {
                      this.baseElement = createTag(this.data.tg || "div"), this.data.hasMask ? (this.svgElement = createNS("svg"), this.layerElement = createNS("g"), this.maskedElement = this.layerElement, this.svgElement.appendChild(this.layerElement), this.baseElement.appendChild(this.svgElement)) : this.layerElement = this.baseElement, styleDiv(this.baseElement)
                  },
                  createContainerElements: function() {
                      this.renderableEffectsManager = new CVEffects(this), this.transformedElement = this.baseElement, this.maskedElement = this.layerElement, this.data.ln && this.layerElement.setAttribute("id", this.data.ln), this.data.cl && this.layerElement.setAttribute("class", this.data.cl), this.data.bm !== 0 && this.setBlendMode()
                  },
                  renderElement: function() {
                      var e = this.transformedElement ? this.transformedElement.style : {};
                      if (this.finalTransform._matMdf) {
                          var t = this.finalTransform.mat.toCSS();
                          e.transform = t, e.webkitTransform = t
                      }
                      this.finalTransform._opMdf && (e.opacity = this.finalTransform.mProp.o.v)
                  },
                  renderFrame: function() {
                      this.data.hd || this.hidden || (this.renderTransform(), this.renderRenderable(), this.renderElement(), this.renderInnerContent(), this._isFirstFrame && (this._isFirstFrame = !1))
                  },
                  destroy: function() {
                      this.layerElement = null, this.transformedElement = null, this.matteElement && (this.matteElement = null), this.maskManager && (this.maskManager.destroy(), this.maskManager = null)
                  },
                  createRenderableComponents: function() {
                      this.maskManager = new MaskElement(this.data, this, this.globalData)
                  },
                  addEffects: function() {},
                  setMatte: function() {}
              }, HBaseElement.prototype.getBaseElement = SVGBaseElement.prototype.getBaseElement, HBaseElement.prototype.destroyBaseElement = HBaseElement.prototype.destroy, HBaseElement.prototype.buildElementParenting = BaseRenderer.prototype.buildElementParenting, extendPrototype([BaseElement, TransformElement, HBaseElement, HierarchyElement, FrameElement, RenderableDOMElement], HSolidElement), HSolidElement.prototype.createContent = function() {
                  var e;
                  this.data.hasMask ? ((e = createNS("rect"))
                      .setAttribute("width", this.data.sw), e.setAttribute("height", this.data.sh), e.setAttribute("fill", this.data.sc), this.svgElement.setAttribute("width", this.data.sw), this.svgElement.setAttribute("height", this.data.sh)) : ((e = createTag("div"))
                      .style.width = this.data.sw + "px", e.style.height = this.data.sh + "px", e.style.backgroundColor = this.data.sc), this.layerElement.appendChild(e)
              }, extendPrototype([BaseElement, TransformElement, HSolidElement, SVGShapeElement, HBaseElement, HierarchyElement, FrameElement, RenderableElement], HShapeElement), HShapeElement.prototype._renderShapeFrame = HShapeElement.prototype.renderInnerContent, HShapeElement.prototype.createContent = function() {
                  var e;
                  if (this.baseElement.style.fontSize = 0, this.data.hasMask) this.layerElement.appendChild(this.shapesContainer), e = this.svgElement;
                  else {
                      e = createNS("svg");
                      var t = this.comp.data ? this.comp.data : this.globalData.compSize;
                      e.setAttribute("width", t.w), e.setAttribute("height", t.h), e.appendChild(this.shapesContainer), this.layerElement.appendChild(e)
                  }
                  this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, this.shapesContainer, 0, [], !0), this.filterUniqueShapes(), this.shapeCont = e
              }, HShapeElement.prototype.getTransformedPoint = function(e, t) {
                  var r, n = e.length;
                  for (r = 0; r < n; r += 1) t = e[r].mProps.v.applyToPointArray(t[0], t[1], 0);
                  return t
              }, HShapeElement.prototype.calculateShapeBoundingBox = function(e, t) {
                  var r, n, i, a, s, o = e.sh.v,
                      l = e.transformers,
                      f = o._length;
                  if (!(f <= 1)) {
                      for (r = 0; r < f - 1; r += 1) n = this.getTransformedPoint(l, o.v[r]), i = this.getTransformedPoint(l, o.o[r]), a = this.getTransformedPoint(l, o.i[r + 1]), s = this.getTransformedPoint(l, o.v[r + 1]), this.checkBounds(n, i, a, s, t);
                      o.c && (n = this.getTransformedPoint(l, o.v[r]), i = this.getTransformedPoint(l, o.o[r]), a = this.getTransformedPoint(l, o.i[0]), s = this.getTransformedPoint(l, o.v[0]), this.checkBounds(n, i, a, s, t))
                  }
              }, HShapeElement.prototype.checkBounds = function(e, t, r, n, i) {
                  this.getBoundsOfCurve(e, t, r, n);
                  var a = this.shapeBoundingBox;
                  i.x = bmMin(a.left, i.x), i.xMax = bmMax(a.right, i.xMax), i.y = bmMin(a.top, i.y), i.yMax = bmMax(a.bottom, i.yMax)
              }, HShapeElement.prototype.shapeBoundingBox = {
                  left: 0,
                  right: 0,
                  top: 0,
                  bottom: 0
              }, HShapeElement.prototype.tempBoundingBox = {
                  x: 0,
                  xMax: 0,
                  y: 0,
                  yMax: 0,
                  width: 0,
                  height: 0
              }, HShapeElement.prototype.getBoundsOfCurve = function(e, t, r, n) {
                  for (var i, a, s, o, l, f, u, c = [
                          [e[0], n[0]],
                          [e[1], n[1]]
                      ], v = 0; v < 2; ++v) a = 6 * e[v] - 12 * t[v] + 6 * r[v], i = -3 * e[v] + 9 * t[v] - 9 * r[v] + 3 * n[v], s = 3 * t[v] - 3 * e[v], a |= 0, s |= 0, (i |= 0) === 0 && a === 0 || (i === 0 ? (o = -s / a) > 0 && o < 1 && c[v].push(this.calculateF(o, e, t, r, n, v)) : (l = a * a - 4 * s * i) >= 0 && ((f = (-a + bmSqrt(l)) / (2 * i)) > 0 && f < 1 && c[v].push(this.calculateF(f, e, t, r, n, v)), (u = (-a - bmSqrt(l)) / (2 * i)) > 0 && u < 1 && c[v].push(this.calculateF(u, e, t, r, n, v))));
                  this.shapeBoundingBox.left = bmMin.apply(null, c[0]), this.shapeBoundingBox.top = bmMin.apply(null, c[1]), this.shapeBoundingBox.right = bmMax.apply(null, c[0]), this.shapeBoundingBox.bottom = bmMax.apply(null, c[1])
              }, HShapeElement.prototype.calculateF = function(e, t, r, n, i, a) {
                  return bmPow(1 - e, 3) * t[a] + 3 * bmPow(1 - e, 2) * e * r[a] + 3 * (1 - e) * bmPow(e, 2) * n[a] + bmPow(e, 3) * i[a]
              }, HShapeElement.prototype.calculateBoundingBox = function(e, t) {
                  var r, n = e.length;
                  for (r = 0; r < n; r += 1) e[r] && e[r].sh ? this.calculateShapeBoundingBox(e[r], t) : e[r] && e[r].it ? this.calculateBoundingBox(e[r].it, t) : e[r] && e[r].style && e[r].w && this.expandStrokeBoundingBox(e[r].w, t)
              }, HShapeElement.prototype.expandStrokeBoundingBox = function(e, t) {
                  var r = 0;
                  if (e.keyframes) {
                      for (var n = 0; n < e.keyframes.length; n += 1) {
                          var i = e.keyframes[n].s;
                          i > r && (r = i)
                      }
                      r *= e.mult
                  } else r = e.v * e.mult;
                  t.x -= r, t.xMax += r, t.y -= r, t.yMax += r
              }, HShapeElement.prototype.currentBoxContains = function(e) {
                  return this.currentBBox.x <= e.x && this.currentBBox.y <= e.y && this.currentBBox.width + this.currentBBox.x >= e.x + e.width && this.currentBBox.height + this.currentBBox.y >= e.y + e.height
              }, HShapeElement.prototype.renderInnerContent = function() {
                  if (this._renderShapeFrame(), !this.hidden && (this._isFirstFrame || this._mdf)) {
                      var e = this.tempBoundingBox,
                          t = 999999;
                      if (e.x = t, e.xMax = -t, e.y = t, e.yMax = -t, this.calculateBoundingBox(this.itemsData, e), e.width = e.xMax < e.x ? 0 : e.xMax - e.x, e.height = e.yMax < e.y ? 0 : e.yMax - e.y, this.currentBoxContains(e)) return;
                      var r = !1;
                      if (this.currentBBox.w !== e.width && (this.currentBBox.w = e.width, this.shapeCont.setAttribute("width", e.width), r = !0), this.currentBBox.h !== e.height && (this.currentBBox.h = e.height, this.shapeCont.setAttribute("height", e.height), r = !0), r || this.currentBBox.x !== e.x || this.currentBBox.y !== e.y) {
                          this.currentBBox.w = e.width, this.currentBBox.h = e.height, this.currentBBox.x = e.x, this.currentBBox.y = e.y, this.shapeCont.setAttribute("viewBox", this.currentBBox.x + " " + this.currentBBox.y + " " + this.currentBBox.w + " " + this.currentBBox.h);
                          var n = this.shapeCont.style,
                              i = "translate(" + this.currentBBox.x + "px," + this.currentBBox.y + "px)";
                          n.transform = i, n.webkitTransform = i
                      }
                  }
              }, extendPrototype([BaseElement, TransformElement, HBaseElement, HierarchyElement, FrameElement, RenderableDOMElement, ITextElement], HTextElement), HTextElement.prototype.createContent = function() {
                  if (this.isMasked = this.checkMasks(), this.isMasked) {
                      this.renderType = "svg", this.compW = this.comp.data.w, this.compH = this.comp.data.h, this.svgElement.setAttribute("width", this.compW), this.svgElement.setAttribute("height", this.compH);
                      var e = createNS("g");
                      this.maskedElement.appendChild(e), this.innerElem = e
                  } else this.renderType = "html", this.innerElem = this.layerElement;
                  this.checkParenting()
              }, HTextElement.prototype.buildNewText = function() {
                  var e = this.textProperty.currentData;
                  this.renderedLetters = createSizedArray(e.l ? e.l.length : 0);
                  var t = this.innerElem.style,
                      r = e.fc ? this.buildColor(e.fc) : "rgba(0,0,0,0)";
                  t.fill = r, t.color = r, e.sc && (t.stroke = this.buildColor(e.sc), t.strokeWidth = e.sw + "px");
                  var n, i, a = this.globalData.fontManager.getFontByName(e.f);
                  if (!this.globalData.fontManager.chars)
                      if (t.fontSize = e.finalSize + "px", t.lineHeight = e.finalSize + "px", a.fClass) this.innerElem.className = a.fClass;
                      else {
                          t.fontFamily = a.fFamily;
                          var s = e.fWeight,
                              o = e.fStyle;
                          t.fontStyle = o, t.fontWeight = s
                      } var l, f, u, c = e.l;
                  i = c.length;
                  var v, d = this.mHelper,
                      p = "",
                      m = 0;
                  for (n = 0; n < i; n += 1) {
                      if (this.globalData.fontManager.chars ? (this.textPaths[m] ? l = this.textPaths[m] : ((l = createNS("path"))
                              .setAttribute("stroke-linecap", lineCapEnum[1]), l.setAttribute("stroke-linejoin", lineJoinEnum[2]), l.setAttribute("stroke-miterlimit", "4")), this.isMasked || (this.textSpans[m] ? u = (f = this.textSpans[m])
                              .children[0] : ((f = createTag("div"))
                                  .style.lineHeight = 0, (u = createNS("svg"))
                                  .appendChild(l), styleDiv(f)))) : this.isMasked ? l = this.textPaths[m] ? this.textPaths[m] : createNS("text") : this.textSpans[m] ? (f = this.textSpans[m], l = this.textPaths[m]) : (styleDiv(f = createTag("span")), styleDiv(l = createTag("span")), f.appendChild(l)), this.globalData.fontManager.chars) {
                          var h, g = this.globalData.fontManager.getCharData(e.finalText[n], a.fStyle, this.globalData.fontManager.getFontByName(e.f)
                              .fFamily);
                          if (h = g ? g.data : null, d.reset(), h && h.shapes && h.shapes.length && (v = h.shapes[0].it, d.scale(e.finalSize / 100, e.finalSize / 100), p = this.createPathShape(d, v), l.setAttribute("d", p)), this.isMasked) this.innerElem.appendChild(l);
                          else {
                              if (this.innerElem.appendChild(f), h && h.shapes) {
                                  document.body.appendChild(u);
                                  var y = u.getBBox();
                                  u.setAttribute("width", y.width + 2), u.setAttribute("height", y.height + 2), u.setAttribute("viewBox", y.x - 1 + " " + (y.y - 1) + " " + (y.width + 2) + " " + (y.height + 2));
                                  var b = u.style,
                                      _ = "translate(" + (y.x - 1) + "px," + (y.y - 1) + "px)";
                                  b.transform = _, b.webkitTransform = _, c[n].yOffset = y.y - 1
                              } else u.setAttribute("width", 1), u.setAttribute("height", 1);
                              f.appendChild(u)
                          }
                      } else if (l.textContent = c[n].val, l.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve"), this.isMasked) this.innerElem.appendChild(l);
                      else {
                          this.innerElem.appendChild(f);
                          var I = l.style,
                              C = "translate3d(0," + -e.finalSize / 1.2 + "px,0)";
                          I.transform = C, I.webkitTransform = C
                      }
                      this.isMasked ? this.textSpans[m] = l : this.textSpans[m] = f, this.textSpans[m].style.display = "block", this.textPaths[m] = l, m += 1
                  }
                  for (; m < this.textSpans.length;) this.textSpans[m].style.display = "none", m += 1
              }, HTextElement.prototype.renderInnerContent = function() {
                  var e;
                  if (this.validateText(), this.data.singleShape) {
                      if (!this._isFirstFrame && !this.lettersChangedFlag) return;
                      if (this.isMasked && this.finalTransform._matMdf) {
                          this.svgElement.setAttribute("viewBox", -this.finalTransform.mProp.p.v[0] + " " + -this.finalTransform.mProp.p.v[1] + " " + this.compW + " " + this.compH), e = this.svgElement.style;
                          var t = "translate(" + -this.finalTransform.mProp.p.v[0] + "px," + -this.finalTransform.mProp.p.v[1] + "px)";
                          e.transform = t, e.webkitTransform = t
                      }
                  }
                  if (this.textAnimator.getMeasures(this.textProperty.currentData, this.lettersChangedFlag), this.lettersChangedFlag || this.textAnimator.lettersChangedFlag) {
                      var r, n, i, a, s, o = 0,
                          l = this.textAnimator.renderedLetters,
                          f = this.textProperty.currentData.l;
                      for (n = f.length, r = 0; r < n; r += 1) f[r].n ? o += 1 : (a = this.textSpans[r], s = this.textPaths[r], i = l[o], o += 1, i._mdf.m && (this.isMasked ? a.setAttribute("transform", i.m) : (a.style.webkitTransform = i.m, a.style.transform = i.m)), a.style.opacity = i.o, i.sw && i._mdf.sw && s.setAttribute("stroke-width", i.sw), i.sc && i._mdf.sc && s.setAttribute("stroke", i.sc), i.fc && i._mdf.fc && (s.setAttribute("fill", i.fc), s.style.color = i.fc));
                      if (this.innerElem.getBBox && !this.hidden && (this._isFirstFrame || this._mdf)) {
                          var u = this.innerElem.getBBox();
                          if (this.currentBBox.w !== u.width && (this.currentBBox.w = u.width, this.svgElement.setAttribute("width", u.width)), this.currentBBox.h !== u.height && (this.currentBBox.h = u.height, this.svgElement.setAttribute("height", u.height)), this.currentBBox.w !== u.width + 2 || this.currentBBox.h !== u.height + 2 || this.currentBBox.x !== u.x - 1 || this.currentBBox.y !== u.y - 1) {
                              this.currentBBox.w = u.width + 2, this.currentBBox.h = u.height + 2, this.currentBBox.x = u.x - 1, this.currentBBox.y = u.y - 1, this.svgElement.setAttribute("viewBox", this.currentBBox.x + " " + this.currentBBox.y + " " + this.currentBBox.w + " " + this.currentBBox.h), e = this.svgElement.style;
                              var c = "translate(" + this.currentBBox.x + "px," + this.currentBBox.y + "px)";
                              e.transform = c, e.webkitTransform = c
                          }
                      }
                  }
              }, extendPrototype([BaseElement, FrameElement, HierarchyElement], HCameraElement), HCameraElement.prototype.setup = function() {
                  var e, t, r, n, i = this.comp.threeDElements.length;
                  for (e = 0; e < i; e += 1)
                      if ((t = this.comp.threeDElements[e])
                          .type === "3d") {
                          r = t.perspectiveElem.style, n = t.container.style;
                          var a = this.pe.v + "px",
                              s = "0px 0px 0px",
                              o = "matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";
                          r.perspective = a, r.webkitPerspective = a, n.transformOrigin = s, n.mozTransformOrigin = s, n.webkitTransformOrigin = s, r.transform = o, r.webkitTransform = o
                      }
              }, HCameraElement.prototype.createElements = function() {}, HCameraElement.prototype.hide = function() {}, HCameraElement.prototype.renderFrame = function() {
                  var e, t, r = this._isFirstFrame;
                  if (this.hierarchy)
                      for (t = this.hierarchy.length, e = 0; e < t; e += 1) r = this.hierarchy[e].finalTransform.mProp._mdf || r;
                  if (r || this.pe._mdf || this.p && this.p._mdf || this.px && (this.px._mdf || this.py._mdf || this.pz._mdf) || this.rx._mdf || this.ry._mdf || this.rz._mdf || this.or._mdf || this.a && this.a._mdf) {
                      if (this.mat.reset(), this.hierarchy)
                          for (e = t = this.hierarchy.length - 1; e >= 0; e -= 1) {
                              var n = this.hierarchy[e].finalTransform.mProp;
                              this.mat.translate(-n.p.v[0], -n.p.v[1], n.p.v[2]), this.mat.rotateX(-n.or.v[0])
                                  .rotateY(-n.or.v[1])
                                  .rotateZ(n.or.v[2]), this.mat.rotateX(-n.rx.v)
                                  .rotateY(-n.ry.v)
                                  .rotateZ(n.rz.v), this.mat.scale(1 / n.s.v[0], 1 / n.s.v[1], 1 / n.s.v[2]), this.mat.translate(n.a.v[0], n.a.v[1], n.a.v[2])
                          }
                      if (this.p ? this.mat.translate(-this.p.v[0], -this.p.v[1], this.p.v[2]) : this.mat.translate(-this.px.v, -this.py.v, this.pz.v), this.a) {
                          var i;
                          i = this.p ? [this.p.v[0] - this.a.v[0], this.p.v[1] - this.a.v[1], this.p.v[2] - this.a.v[2]] : [this.px.v - this.a.v[0], this.py.v - this.a.v[1], this.pz.v - this.a.v[2]];
                          var a = Math.sqrt(Math.pow(i[0], 2) + Math.pow(i[1], 2) + Math.pow(i[2], 2)),
                              s = [i[0] / a, i[1] / a, i[2] / a],
                              o = Math.sqrt(s[2] * s[2] + s[0] * s[0]),
                              l = Math.atan2(s[1], o),
                              f = Math.atan2(s[0], -s[2]);
                          this.mat.rotateY(f)
                              .rotateX(-l)
                      }
                      this.mat.rotateX(-this.rx.v)
                          .rotateY(-this.ry.v)
                          .rotateZ(this.rz.v), this.mat.rotateX(-this.or.v[0])
                          .rotateY(-this.or.v[1])
                          .rotateZ(this.or.v[2]), this.mat.translate(this.globalData.compSize.w / 2, this.globalData.compSize.h / 2, 0), this.mat.translate(0, 0, this.pe.v);
                      var u = !this._prevMat.equals(this.mat);
                      if ((u || this.pe._mdf) && this.comp.threeDElements) {
                          var c, v, d;
                          for (t = this.comp.threeDElements.length, e = 0; e < t; e += 1)
                              if ((c = this.comp.threeDElements[e])
                                  .type === "3d") {
                                  if (u) {
                                      var p = this.mat.toCSS();
                                      (d = c.container.style)
                                      .transform = p, d.webkitTransform = p
                                  }
                                  this.pe._mdf && ((v = c.perspectiveElem.style)
                                      .perspective = this.pe.v + "px", v.webkitPerspective = this.pe.v + "px")
                              } this.mat.clone(this._prevMat)
                      }
                  }
                  this._isFirstFrame = !1
              }, HCameraElement.prototype.prepareFrame = function(e) {
                  this.prepareProperties(e, !0)
              }, HCameraElement.prototype.destroy = function() {}, HCameraElement.prototype.getBaseElement = function() {
                  return null
              }, extendPrototype([BaseElement, TransformElement, HBaseElement, HSolidElement, HierarchyElement, FrameElement, RenderableElement], HImageElement), HImageElement.prototype.createContent = function() {
                  var e = this.globalData.getAssetsPath(this.assetData),
                      t = new Image;
                  this.data.hasMask ? (this.imageElem = createNS("image"), this.imageElem.setAttribute("width", this.assetData.w + "px"), this.imageElem.setAttribute("height", this.assetData.h + "px"), this.imageElem.setAttributeNS("http://www.w3.org/1999/xlink", "href", e), this.layerElement.appendChild(this.imageElem), this.baseElement.setAttribute("width", this.assetData.w), this.baseElement.setAttribute("height", this.assetData.h)) : this.layerElement.appendChild(t), t.crossOrigin = "anonymous", t.src = e, this.data.ln && this.baseElement.setAttribute("id", this.data.ln)
              }, extendPrototype([BaseRenderer], HybridRendererBase), HybridRendererBase.prototype.buildItem = SVGRenderer.prototype.buildItem, HybridRendererBase.prototype.checkPendingElements = function() {
                  for (; this.pendingElements.length;) this.pendingElements.pop()
                      .checkParenting()
              }, HybridRendererBase.prototype.appendElementInPos = function(e, t) {
                  var r = e.getBaseElement();
                  if (r) {
                      var n = this.layers[t];
                      if (n.ddd && this.supports3d) this.addTo3dContainer(r, t);
                      else if (this.threeDElements) this.addTo3dContainer(r, t);
                      else {
                          for (var i, a, s = 0; s < t;) this.elements[s] && this.elements[s] !== !0 && this.elements[s].getBaseElement && (a = this.elements[s], i = (this.layers[s].ddd ? this.getThreeDContainerByPos(s) : a.getBaseElement()) || i), s += 1;
                          i ? n.ddd && this.supports3d || this.layerElement.insertBefore(r, i) : n.ddd && this.supports3d || this.layerElement.appendChild(r)
                      }
                  }
              }, HybridRendererBase.prototype.createShape = function(e) {
                  return this.supports3d ? new HShapeElement(e, this.globalData, this) : new SVGShapeElement(e, this.globalData, this)
              }, HybridRendererBase.prototype.createText = function(e) {
                  return this.supports3d ? new HTextElement(e, this.globalData, this) : new SVGTextLottieElement(e, this.globalData, this)
              }, HybridRendererBase.prototype.createCamera = function(e) {
                  return this.camera = new HCameraElement(e, this.globalData, this), this.camera
              }, HybridRendererBase.prototype.createImage = function(e) {
                  return this.supports3d ? new HImageElement(e, this.globalData, this) : new IImageElement(e, this.globalData, this)
              }, HybridRendererBase.prototype.createSolid = function(e) {
                  return this.supports3d ? new HSolidElement(e, this.globalData, this) : new ISolidElement(e, this.globalData, this)
              }, HybridRendererBase.prototype.createNull = SVGRenderer.prototype.createNull, HybridRendererBase.prototype.getThreeDContainerByPos = function(e) {
                  for (var t = 0, r = this.threeDElements.length; t < r;) {
                      if (this.threeDElements[t].startPos <= e && this.threeDElements[t].endPos >= e) return this.threeDElements[t].perspectiveElem;
                      t += 1
                  }
                  return null
              }, HybridRendererBase.prototype.createThreeDContainer = function(e, t) {
                  var r, n, i = createTag("div");
                  styleDiv(i);
                  var a = createTag("div");
                  if (styleDiv(a), t === "3d") {
                      (r = i.style)
                      .width = this.globalData.compSize.w + "px", r.height = this.globalData.compSize.h + "px";
                      var s = "50% 50%";
                      r.webkitTransformOrigin = s, r.mozTransformOrigin = s, r.transformOrigin = s;
                      var o = "matrix3d(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)";
                      (n = a.style)
                      .transform = o, n.webkitTransform = o
                  }
                  i.appendChild(a);
                  var l = {
                      container: a,
                      perspectiveElem: i,
                      startPos: e,
                      endPos: e,
                      type: t
                  };
                  return this.threeDElements.push(l), l
              }, HybridRendererBase.prototype.build3dContainers = function() {
                  var e, t, r = this.layers.length,
                      n = "";
                  for (e = 0; e < r; e += 1) this.layers[e].ddd && this.layers[e].ty !== 3 ? (n !== "3d" && (n = "3d", t = this.createThreeDContainer(e, "3d")), t.endPos = Math.max(t.endPos, e)) : (n !== "2d" && (n = "2d", t = this.createThreeDContainer(e, "2d")), t.endPos = Math.max(t.endPos, e));
                  for (e = (r = this.threeDElements.length) - 1; e >= 0; e -= 1) this.resizerElem.appendChild(this.threeDElements[e].perspectiveElem)
              }, HybridRendererBase.prototype.addTo3dContainer = function(e, t) {
                  for (var r = 0, n = this.threeDElements.length; r < n;) {
                      if (t <= this.threeDElements[r].endPos) {
                          for (var i, a = this.threeDElements[r].startPos; a < t;) this.elements[a] && this.elements[a].getBaseElement && (i = this.elements[a].getBaseElement()), a += 1;
                          i ? this.threeDElements[r].container.insertBefore(e, i) : this.threeDElements[r].container.appendChild(e);
                          break
                      }
                      r += 1
                  }
              }, HybridRendererBase.prototype.configAnimation = function(e) {
                  var t = createTag("div"),
                      r = this.animationItem.wrapper,
                      n = t.style;
                  n.width = e.w + "px", n.height = e.h + "px", this.resizerElem = t, styleDiv(t), n.transformStyle = "flat", n.mozTransformStyle = "flat", n.webkitTransformStyle = "flat", this.renderConfig.className && t.setAttribute("class", this.renderConfig.className), r.appendChild(t), n.overflow = "hidden";
                  var i = createNS("svg");
                  i.setAttribute("width", "1"), i.setAttribute("height", "1"), styleDiv(i), this.resizerElem.appendChild(i);
                  var a = createNS("defs");
                  i.appendChild(a), this.data = e, this.setupGlobalData(e, i), this.globalData.defs = a, this.layers = e.layers, this.layerElement = this.resizerElem, this.build3dContainers(), this.updateContainerSize()
              }, HybridRendererBase.prototype.destroy = function() {
                  var e;
                  this.animationItem.wrapper && (this.animationItem.wrapper.innerText = ""), this.animationItem.container = null, this.globalData.defs = null;
                  var t = this.layers ? this.layers.length : 0;
                  for (e = 0; e < t; e += 1) this.elements[e] && this.elements[e].destroy && this.elements[e].destroy();
                  this.elements.length = 0, this.destroyed = !0, this.animationItem = null
              }, HybridRendererBase.prototype.updateContainerSize = function() {
                  var e, t, r, n, i = this.animationItem.wrapper.offsetWidth,
                      a = this.animationItem.wrapper.offsetHeight,
                      s = i / a;
                  this.globalData.compSize.w / this.globalData.compSize.h > s ? (e = i / this.globalData.compSize.w, t = i / this.globalData.compSize.w, r = 0, n = (a - this.globalData.compSize.h * (i / this.globalData.compSize.w)) / 2) : (e = a / this.globalData.compSize.h, t = a / this.globalData.compSize.h, r = (i - this.globalData.compSize.w * (a / this.globalData.compSize.h)) / 2, n = 0);
                  var o = this.resizerElem.style;
                  o.webkitTransform = "matrix3d(" + e + ",0,0,0,0," + t + ",0,0,0,0,1,0," + r + "," + n + ",0,1)", o.transform = o.webkitTransform
              }, HybridRendererBase.prototype.renderFrame = SVGRenderer.prototype.renderFrame, HybridRendererBase.prototype.hide = function() {
                  this.resizerElem.style.display = "none"
              }, HybridRendererBase.prototype.show = function() {
                  this.resizerElem.style.display = "block"
              }, HybridRendererBase.prototype.initItems = function() {
                  if (this.buildAllItems(), this.camera) this.camera.setup();
                  else {
                      var e, t = this.globalData.compSize.w,
                          r = this.globalData.compSize.h,
                          n = this.threeDElements.length;
                      for (e = 0; e < n; e += 1) {
                          var i = this.threeDElements[e].perspectiveElem.style;
                          i.webkitPerspective = Math.sqrt(Math.pow(t, 2) + Math.pow(r, 2)) + "px", i.perspective = i.webkitPerspective
                      }
                  }
              }, HybridRendererBase.prototype.searchExtraCompositions = function(e) {
                  var t, r = e.length,
                      n = createTag("div");
                  for (t = 0; t < r; t += 1)
                      if (e[t].xt) {
                          var i = this.createComp(e[t], n, this.globalData.comp, null);
                          i.initExpressions(), this.globalData.projectInterface.registerComposition(i)
                      }
              }, extendPrototype([HybridRendererBase, ICompElement, HBaseElement], HCompElement), HCompElement.prototype._createBaseContainerElements = HCompElement.prototype.createContainerElements, HCompElement.prototype.createContainerElements = function() {
                  this._createBaseContainerElements(), this.data.hasMask ? (this.svgElement.setAttribute("width", this.data.w), this.svgElement.setAttribute("height", this.data.h), this.transformedElement = this.baseElement) : this.transformedElement = this.layerElement
              }, HCompElement.prototype.addTo3dContainer = function(e, t) {
                  for (var r, n = 0; n < t;) this.elements[n] && this.elements[n].getBaseElement && (r = this.elements[n].getBaseElement()), n += 1;
                  r ? this.layerElement.insertBefore(e, r) : this.layerElement.appendChild(e)
              }, HCompElement.prototype.createComp = function(e) {
                  return this.supports3d ? new HCompElement(e, this.globalData, this) : new SVGCompElement(e, this.globalData, this)
              }, extendPrototype([HybridRendererBase], HybridRenderer), HybridRenderer.prototype.createComp = function(e) {
                  return this.supports3d ? new HCompElement(e, this.globalData, this) : new SVGCompElement(e, this.globalData, this)
              };
          var CompExpressionInterface = function(e) {
              function t(r) {
                  for (var n = 0, i = e.layers.length; n < i;) {
                      if (e.layers[n].nm === r || e.layers[n].ind === r) return e.elements[n].layerInterface;
                      n += 1
                  }
                  return null
              }
              return Object.defineProperty(t, "_name", {
                  value: e.data.nm
              }), t.layer = t, t.pixelAspect = 1, t.height = e.data.h || e.globalData.compSize.h, t.width = e.data.w || e.globalData.compSize.w, t.pixelAspect = 1, t.frameDuration = 1 / e.globalData.frameRate, t.displayStartTime = 0, t.numLayers = e.layers.length, t
          };

          function _typeof$2(e) {
              return _typeof$2 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof$2(e)
          }

          function seedRandom(e, t) {
              var r, n = this,
                  i = 256,
                  a = t.pow(i, 6),
                  s = t.pow(2, 52),
                  o = 2 * s,
                  l = 255;

              function f(p) {
                  var m, h = p.length,
                      g = this,
                      y = 0,
                      b = g.i = g.j = 0,
                      _ = g.S = [];
                  for (h || (p = [h++]); y < i;) _[y] = y++;
                  for (y = 0; y < i; y++) _[y] = _[b = l & b + p[y % h] + (m = _[y])], _[b] = m;
                  g.g = function(I) {
                      for (var C, x = 0, O = g.i, L = g.j, D = g.S; I--;) C = D[O = l & O + 1], x = x * i + D[l & (D[O] = D[L = l & L + C]) + (D[L] = C)];
                      return g.i = O, g.j = L, x
                  }
              }

              function u(p, m) {
                  return m.i = p.i, m.j = p.j, m.S = p.S.slice(), m
              }

              function c(p, m) {
                  var h, g = [],
                      y = _typeof$2(p);
                  if (m && y == "object")
                      for (h in p) try {
                          g.push(c(p[h], m - 1))
                      } catch {}
                  return g.length ? g : y == "string" ? p : p + "\0"
              }

              function v(p, m) {
                  for (var h, g = p + "", y = 0; y < g.length;) m[l & y] = l & (h ^= 19 * m[l & y]) + g.charCodeAt(y++);
                  return d(m)
              }

              function d(p) {
                  return String.fromCharCode.apply(0, p)
              }
              t.seedrandom = function(p, m, h) {
                  var g = [],
                      y = v(c((m = m === !0 ? {
                              entropy: !0
                          } : m || {})
                          .entropy ? [p, d(e)] : p === null ? function() {
                              try {
                                  var I = new Uint8Array(i);
                                  return (n.crypto || n.msCrypto)
                                      .getRandomValues(I), d(I)
                              } catch {
                                  var C = n.navigator,
                                      x = C && C.plugins;
                                  return [+new Date, n, x, n.screen, d(e)]
                              }
                          }() : p, 3), g),
                      b = new f(g),
                      _ = function() {
                          for (var I = b.g(6), C = a, x = 0; I < s;) I = (I + x) * i, C *= i, x = b.g(1);
                          for (; I >= o;) I /= 2, C /= 2, x >>>= 1;
                          return (I + x) / C
                      };
                  return _.int32 = function() {
                      return 0 | b.g(4)
                  }, _.quick = function() {
                      return b.g(4) / 4294967296
                  }, _.double = _, v(d(b.S), e), (m.pass || h || function(I, C, x, O) {
                      return O && (O.S && u(O, b), I.state = function() {
                          return u(b, {})
                      }), x ? (t.random = I, C) : I
                  })(_, y, "global" in m ? m.global : this == t, m.state)
              }, v(t.random(), e)
          }

          function initialize$2(e) {
              seedRandom([], e)
          }
          var propTypes = {
              SHAPE: "shape"
          };

          function _typeof$1(e) {
              return _typeof$1 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof$1(e)
          }
          var ExpressionManager = function() {
                  var ob = {},
                      Math = BMMath,
                      window = null,
                      document = null,
                      XMLHttpRequest = null,
                      fetch = null,
                      frames = null,
                      _lottieGlobal = {};

                  function resetFrame() {
                      _lottieGlobal = {}
                  }

                  function $bm_isInstanceOfArray(e) {
                      return e.constructor === Array || e.constructor === Float32Array
                  }

                  function isNumerable(e, t) {
                      return e === "number" || t instanceof Number || e === "boolean" || e === "string"
                  }

                  function $bm_neg(e) {
                      var t = _typeof$1(e);
                      if (t === "number" || e instanceof Number || t === "boolean") return -e;
                      if ($bm_isInstanceOfArray(e)) {
                          var r, n = e.length,
                              i = [];
                          for (r = 0; r < n; r += 1) i[r] = -e[r];
                          return i
                      }
                      return e.propType ? e.v : -e
                  }
                  initialize$2(BMMath);
                  var easeInBez = BezierFactory.getBezierEasing(.333, 0, .833, .833, "easeIn")
                      .get,
                      easeOutBez = BezierFactory.getBezierEasing(.167, .167, .667, 1, "easeOut")
                      .get,
                      easeInOutBez = BezierFactory.getBezierEasing(.33, 0, .667, 1, "easeInOut")
                      .get;

                  function sum(e, t) {
                      var r = _typeof$1(e),
                          n = _typeof$1(t);
                      if (isNumerable(r, e) && isNumerable(n, t) || r === "string" || n === "string") return e + t;
                      if ($bm_isInstanceOfArray(e) && isNumerable(n, t)) return (e = e.slice(0))[0] += t, e;
                      if (isNumerable(r, e) && $bm_isInstanceOfArray(t)) return (t = t.slice(0))[0] = e + t[0], t;
                      if ($bm_isInstanceOfArray(e) && $bm_isInstanceOfArray(t)) {
                          for (var i = 0, a = e.length, s = t.length, o = []; i < a || i < s;)(typeof e[i] == "number" || e[i] instanceof Number) && (typeof t[i] == "number" || t[i] instanceof Number) ? o[i] = e[i] + t[i] : o[i] = t[i] === void 0 ? e[i] : e[i] || t[i], i += 1;
                          return o
                      }
                      return 0
                  }
                  var add = sum;

                  function sub(e, t) {
                      var r = _typeof$1(e),
                          n = _typeof$1(t);
                      if (isNumerable(r, e) && isNumerable(n, t)) return r === "string" && (e = parseInt(e, 10)), n === "string" && (t = parseInt(t, 10)), e - t;
                      if ($bm_isInstanceOfArray(e) && isNumerable(n, t)) return (e = e.slice(0))[0] -= t, e;
                      if (isNumerable(r, e) && $bm_isInstanceOfArray(t)) return (t = t.slice(0))[0] = e - t[0], t;
                      if ($bm_isInstanceOfArray(e) && $bm_isInstanceOfArray(t)) {
                          for (var i = 0, a = e.length, s = t.length, o = []; i < a || i < s;)(typeof e[i] == "number" || e[i] instanceof Number) && (typeof t[i] == "number" || t[i] instanceof Number) ? o[i] = e[i] - t[i] : o[i] = t[i] === void 0 ? e[i] : e[i] || t[i], i += 1;
                          return o
                      }
                      return 0
                  }

                  function mul(e, t) {
                      var r, n, i, a = _typeof$1(e),
                          s = _typeof$1(t);
                      if (isNumerable(a, e) && isNumerable(s, t)) return e * t;
                      if ($bm_isInstanceOfArray(e) && isNumerable(s, t)) {
                          for (i = e.length, r = createTypedArray("float32", i), n = 0; n < i; n += 1) r[n] = e[n] * t;
                          return r
                      }
                      if (isNumerable(a, e) && $bm_isInstanceOfArray(t)) {
                          for (i = t.length, r = createTypedArray("float32", i), n = 0; n < i; n += 1) r[n] = e * t[n];
                          return r
                      }
                      return 0
                  }

                  function div(e, t) {
                      var r, n, i, a = _typeof$1(e),
                          s = _typeof$1(t);
                      if (isNumerable(a, e) && isNumerable(s, t)) return e / t;
                      if ($bm_isInstanceOfArray(e) && isNumerable(s, t)) {
                          for (i = e.length, r = createTypedArray("float32", i), n = 0; n < i; n += 1) r[n] = e[n] / t;
                          return r
                      }
                      if (isNumerable(a, e) && $bm_isInstanceOfArray(t)) {
                          for (i = t.length, r = createTypedArray("float32", i), n = 0; n < i; n += 1) r[n] = e / t[n];
                          return r
                      }
                      return 0
                  }

                  function mod(e, t) {
                      return typeof e == "string" && (e = parseInt(e, 10)), typeof t == "string" && (t = parseInt(t, 10)), e % t
                  }
                  var $bm_sum = sum,
                      $bm_sub = sub,
                      $bm_mul = mul,
                      $bm_div = div,
                      $bm_mod = mod;

                  function clamp(e, t, r) {
                      if (t > r) {
                          var n = r;
                          r = t, t = n
                      }
                      return Math.min(Math.max(e, t), r)
                  }

                  function radiansToDegrees(e) {
                      return e / degToRads
                  }
                  var radians_to_degrees = radiansToDegrees;

                  function degreesToRadians(e) {
                      return e * degToRads
                  }
                  var degrees_to_radians = radiansToDegrees,
                      helperLengthArray = [0, 0, 0, 0, 0, 0];

                  function length(e, t) {
                      if (typeof e == "number" || e instanceof Number) return t = t || 0, Math.abs(e - t);
                      var r;
                      t || (t = helperLengthArray);
                      var n = Math.min(e.length, t.length),
                          i = 0;
                      for (r = 0; r < n; r += 1) i += Math.pow(t[r] - e[r], 2);
                      return Math.sqrt(i)
                  }

                  function normalize(e) {
                      return div(e, length(e))
                  }

                  function rgbToHsl(e) {
                      var t, r, n = e[0],
                          i = e[1],
                          a = e[2],
                          s = Math.max(n, i, a),
                          o = Math.min(n, i, a),
                          l = (s + o) / 2;
                      if (s === o) t = 0, r = 0;
                      else {
                          var f = s - o;
                          switch (r = l > .5 ? f / (2 - s - o) : f / (s + o), s) {
                              case n:
                                  t = (i - a) / f + (i < a ? 6 : 0);
                                  break;
                              case i:
                                  t = (a - n) / f + 2;
                                  break;
                              case a:
                                  t = (n - i) / f + 4
                          }
                          t /= 6
                      }
                      return [t, r, l, e[3]]
                  }

                  function hue2rgb(e, t, r) {
                      return r < 0 && (r += 1), r > 1 && (r -= 1), r < 1 / 6 ? e + 6 * (t - e) * r : r < .5 ? t : r < 2 / 3 ? e + (t - e) * (2 / 3 - r) * 6 : e
                  }

                  function hslToRgb(e) {
                      var t, r, n, i = e[0],
                          a = e[1],
                          s = e[2];
                      if (a === 0) t = s, n = s, r = s;
                      else {
                          var o = s < .5 ? s * (1 + a) : s + a - s * a,
                              l = 2 * s - o;
                          t = hue2rgb(l, o, i + 1 / 3), r = hue2rgb(l, o, i), n = hue2rgb(l, o, i - 1 / 3)
                      }
                      return [t, r, n, e[3]]
                  }

                  function linear(e, t, r, n, i) {
                      if (n !== void 0 && i !== void 0 || (n = t, i = r, t = 0, r = 1), r < t) {
                          var a = r;
                          r = t, t = a
                      }
                      if (e <= t) return n;
                      if (e >= r) return i;
                      var s, o = r === t ? 0 : (e - t) / (r - t);
                      if (!n.length) return n + (i - n) * o;
                      var l = n.length,
                          f = createTypedArray("float32", l);
                      for (s = 0; s < l; s += 1) f[s] = n[s] + (i[s] - n[s]) * o;
                      return f
                  }

                  function random(e, t) {
                      if (t === void 0 && (e === void 0 ? (e = 0, t = 1) : (t = e, e = void 0)), t.length) {
                          var r, n = t.length;
                          e || (e = createTypedArray("float32", n));
                          var i = createTypedArray("float32", n),
                              a = BMMath.random();
                          for (r = 0; r < n; r += 1) i[r] = e[r] + a * (t[r] - e[r]);
                          return i
                      }
                      return e === void 0 && (e = 0), e + BMMath.random() * (t - e)
                  }

                  function createPath(e, t, r, n) {
                      var i, a = e.length,
                          s = shapePool.newElement();
                      s.setPathData(!!n, a);
                      var o, l, f = [0, 0];
                      for (i = 0; i < a; i += 1) o = t && t[i] ? t[i] : f, l = r && r[i] ? r[i] : f, s.setTripleAt(e[i][0], e[i][1], l[0] + e[i][0], l[1] + e[i][1], o[0] + e[i][0], o[1] + e[i][1], i, !0);
                      return s
                  }

                  function initiateExpression(elem, data, property) {
                      function noOp(e) {
                          return e
                      }
                      if (!elem.globalData.renderConfig.runExpressions) return noOp;
                      var val = data.x,
                          needsVelocity = /velocity(?![\w\d])/.test(val),
                          _needsRandom = val.indexOf("random") !== -1,
                          elemType = elem.data.ty,
                          transform, $bm_transform, content, effect, thisProperty = property;
                      thisProperty.valueAtTime = thisProperty.getValueAtTime, Object.defineProperty(thisProperty, "value", {
                          get: function() {
                              return thisProperty.v
                          }
                      }), elem.comp.frameDuration = 1 / elem.comp.globalData.frameRate, elem.comp.displayStartTime = 0;
                      var inPoint = elem.data.ip / elem.comp.globalData.frameRate,
                          outPoint = elem.data.op / elem.comp.globalData.frameRate,
                          width = elem.data.sw ? elem.data.sw : 0,
                          height = elem.data.sh ? elem.data.sh : 0,
                          name = elem.data.nm,
                          loopIn, loop_in, loopOut, loop_out, smooth, toWorld, fromWorld, fromComp, toComp, fromCompToSurface, position, rotation, anchorPoint, scale, thisLayer, thisComp, mask, valueAtTime, velocityAtTime, scoped_bm_rt, expression_function = eval("[function _expression_function(){" + val + ";scoped_bm_rt=$bm_rt}]")[0],
                          numKeys = property.kf ? data.k.length : 0,
                          active = !this.data || this.data.hd !== !0,
                          wiggle = function(e, t) {
                              var r, n, i = this.pv.length ? this.pv.length : 1,
                                  a = createTypedArray("float32", i),
                                  s = Math.floor(5 * time);
                              for (r = 0, n = 0; r < s;) {
                                  for (n = 0; n < i; n += 1) a[n] += -t + 2 * t * BMMath.random();
                                  r += 1
                              }
                              var o = 5 * time,
                                  l = o - Math.floor(o),
                                  f = createTypedArray("float32", i);
                              if (i > 1) {
                                  for (n = 0; n < i; n += 1) f[n] = this.pv[n] + a[n] + (-t + 2 * t * BMMath.random()) * l;
                                  return f
                              }
                              return this.pv + a[0] + (-t + 2 * t * BMMath.random()) * l
                          }.bind(this);

                      function loopInDuration(e, t) {
                          return loopIn(e, t, !0)
                      }

                      function loopOutDuration(e, t) {
                          return loopOut(e, t, !0)
                      }
                      thisProperty.loopIn && (loopIn = thisProperty.loopIn.bind(thisProperty), loop_in = loopIn), thisProperty.loopOut && (loopOut = thisProperty.loopOut.bind(thisProperty), loop_out = loopOut), thisProperty.smooth && (smooth = thisProperty.smooth.bind(thisProperty)), this.getValueAtTime && (valueAtTime = this.getValueAtTime.bind(this)), this.getVelocityAtTime && (velocityAtTime = this.getVelocityAtTime.bind(this));
                      var comp = elem.comp.globalData.projectInterface.bind(elem.comp.globalData.projectInterface),
                          time, velocity, value, text, textIndex, textTotal, selectorValue;

                      function lookAt(e, t) {
                          var r = [t[0] - e[0], t[1] - e[1], t[2] - e[2]],
                              n = Math.atan2(r[0], Math.sqrt(r[1] * r[1] + r[2] * r[2])) / degToRads;
                          return [-Math.atan2(r[1], r[2]) / degToRads, n, 0]
                      }

                      function easeOut(e, t, r, n, i) {
                          return applyEase(easeOutBez, e, t, r, n, i)
                      }

                      function easeIn(e, t, r, n, i) {
                          return applyEase(easeInBez, e, t, r, n, i)
                      }

                      function ease(e, t, r, n, i) {
                          return applyEase(easeInOutBez, e, t, r, n, i)
                      }

                      function applyEase(e, t, r, n, i, a) {
                          i === void 0 ? (i = r, a = n) : t = (t - r) / (n - r), t > 1 ? t = 1 : t < 0 && (t = 0);
                          var s = e(t);
                          if ($bm_isInstanceOfArray(i)) {
                              var o, l = i.length,
                                  f = createTypedArray("float32", l);
                              for (o = 0; o < l; o += 1) f[o] = (a[o] - i[o]) * s + i[o];
                              return f
                          }
                          return (a - i) * s + i
                      }

                      function nearestKey(e) {
                          var t, r, n, i = data.k.length;
                          if (data.k.length && typeof data.k[0] != "number")
                              if (r = -1, (e *= elem.comp.globalData.frameRate) < data.k[0].t) r = 1, n = data.k[0].t;
                              else {
                                  for (t = 0; t < i - 1; t += 1) {
                                      if (e === data.k[t].t) {
                                          r = t + 1, n = data.k[t].t;
                                          break
                                      }
                                      if (e > data.k[t].t && e < data.k[t + 1].t) {
                                          e - data.k[t].t > data.k[t + 1].t - e ? (r = t + 2, n = data.k[t + 1].t) : (r = t + 1, n = data.k[t].t);
                                          break
                                      }
                                  }
                                  r === -1 && (r = t + 1, n = data.k[t].t)
                              }
                          else r = 0, n = 0;
                          var a = {};
                          return a.index = r, a.time = n / elem.comp.globalData.frameRate, a
                      }

                      function key(e) {
                          var t, r, n;
                          if (!data.k.length || typeof data.k[0] == "number") throw new Error("The property has no keyframe at index " + e);
                          e -= 1, t = {
                              time: data.k[e].t / elem.comp.globalData.frameRate,
                              value: []
                          };
                          var i = Object.prototype.hasOwnProperty.call(data.k[e], "s") ? data.k[e].s : data.k[e - 1].e;
                          for (n = i.length, r = 0; r < n; r += 1) t[r] = i[r], t.value[r] = i[r];
                          return t
                      }

                      function framesToTime(e, t) {
                          return t || (t = elem.comp.globalData.frameRate), e / t
                      }

                      function timeToFrames(e, t) {
                          return e || e === 0 || (e = time), t || (t = elem.comp.globalData.frameRate), e * t
                      }

                      function seedRandom(e) {
                          BMMath.seedrandom(randSeed + e)
                      }

                      function sourceRectAtTime() {
                          return elem.sourceRectAtTime()
                      }

                      function substring(e, t) {
                          return typeof value == "string" ? t === void 0 ? value.substring(e) : value.substring(e, t) : ""
                      }

                      function substr(e, t) {
                          return typeof value == "string" ? t === void 0 ? value.substr(e) : value.substr(e, t) : ""
                      }

                      function posterizeTime(e) {
                          time = e === 0 ? 0 : Math.floor(time * e) / e, value = valueAtTime(time)
                      }
                      var index = elem.data.ind,
                          hasParent = !(!elem.hierarchy || !elem.hierarchy.length),
                          parent, randSeed = Math.floor(1e6 * Math.random()),
                          globalData = elem.globalData;

                      function executeExpression(e) {
                          return value = e, this.frameExpressionId === elem.globalData.frameId && this.propType !== "textSelector" ? value : (this.propType === "textSelector" && (textIndex = this.textIndex, textTotal = this.textTotal, selectorValue = this.selectorValue), thisLayer || (text = elem.layerInterface.text, thisLayer = elem.layerInterface, thisComp = elem.comp.compInterface, toWorld = thisLayer.toWorld.bind(thisLayer), fromWorld = thisLayer.fromWorld.bind(thisLayer), fromComp = thisLayer.fromComp.bind(thisLayer), toComp = thisLayer.toComp.bind(thisLayer), mask = thisLayer.mask ? thisLayer.mask.bind(thisLayer) : null, fromCompToSurface = fromComp), transform || (transform = elem.layerInterface("ADBE Transform Group"), $bm_transform = transform, transform && (anchorPoint = transform.anchorPoint)), elemType !== 4 || content || (content = thisLayer("ADBE Root Vectors Group")), effect || (effect = thisLayer(4)), (hasParent = !(!elem.hierarchy || !elem.hierarchy.length)) && !parent && (parent = elem.hierarchy[0].layerInterface), time = this.comp.renderedFrame / this.comp.globalData.frameRate, _needsRandom && seedRandom(randSeed + time), needsVelocity && (velocity = velocityAtTime(time)), expression_function(), this.frameExpressionId = elem.globalData.frameId, scoped_bm_rt = scoped_bm_rt.propType === propTypes.SHAPE ? scoped_bm_rt.v : scoped_bm_rt)
                      }
                      return executeExpression.__preventDeadCodeRemoval = [$bm_transform, anchorPoint, time, velocity, inPoint, outPoint, width, height, name, loop_in, loop_out, smooth, toComp, fromCompToSurface, toWorld, fromWorld, mask, position, rotation, scale, thisComp, numKeys, active, wiggle, loopInDuration, loopOutDuration, comp, lookAt, easeOut, easeIn, ease, nearestKey, key, text, textIndex, textTotal, selectorValue, framesToTime, timeToFrames, sourceRectAtTime, substring, substr, posterizeTime, index, globalData], executeExpression
                  }
                  return ob.initiateExpression = initiateExpression, ob.__preventDeadCodeRemoval = [window, document, XMLHttpRequest, fetch, frames, $bm_neg, add, $bm_sum, $bm_sub, $bm_mul, $bm_div, $bm_mod, clamp, radians_to_degrees, degreesToRadians, degrees_to_radians, normalize, rgbToHsl, hslToRgb, linear, random, createPath, _lottieGlobal], ob.resetFrame = resetFrame, ob
              }(),
              Expressions = function() {
                  var e = {};
                  return e.initExpressions = function(t) {
                      var r = 0,
                          n = [];
                      t.renderer.compInterface = CompExpressionInterface(t.renderer), t.renderer.globalData.projectInterface.registerComposition(t.renderer), t.renderer.globalData.pushExpression = function() {
                          r += 1
                      }, t.renderer.globalData.popExpression = function() {
                          (r -= 1) == 0 && function() {
                              var i, a = n.length;
                              for (i = 0; i < a; i += 1) n[i].release();
                              n.length = 0
                          }()
                      }, t.renderer.globalData.registerExpressionProperty = function(i) {
                          n.indexOf(i) === -1 && n.push(i)
                      }
                  }, e.resetFrame = ExpressionManager.resetFrame, e
              }(),
              MaskManagerInterface = function() {
                  function e(t, r) {
                      this._mask = t, this._data = r
                  }
                  return Object.defineProperty(e.prototype, "maskPath", {
                          get: function() {
                              return this._mask.prop.k && this._mask.prop.getValue(), this._mask.prop
                          }
                      }), Object.defineProperty(e.prototype, "maskOpacity", {
                          get: function() {
                              return this._mask.op.k && this._mask.op.getValue(), 100 * this._mask.op.v
                          }
                      }),
                      function(t) {
                          var r, n = createSizedArray(t.viewData.length),
                              i = t.viewData.length;
                          for (r = 0; r < i; r += 1) n[r] = new e(t.viewData[r], t.masksProperties[r]);
                          return function(a) {
                              for (r = 0; r < i;) {
                                  if (t.masksProperties[r].nm === a) return n[r];
                                  r += 1
                              }
                              return null
                          }
                      }
              }(),
              ExpressionPropertyInterface = function() {
                  var e = {
                          pv: 0,
                          v: 0,
                          mult: 1
                      },
                      t = {
                          pv: [0, 0, 0],
                          v: [0, 0, 0],
                          mult: 1
                      };

                  function r(i, a, s) {
                      Object.defineProperty(i, "velocity", {
                          get: function() {
                              return a.getVelocityAtTime(a.comp.currentFrame)
                          }
                      }), i.numKeys = a.keyframes ? a.keyframes.length : 0, i.key = function(o) {
                          if (!i.numKeys) return 0;
                          var l = "";
                          l = "s" in a.keyframes[o - 1] ? a.keyframes[o - 1].s : "e" in a.keyframes[o - 2] ? a.keyframes[o - 2].e : a.keyframes[o - 2].s;
                          var f = s === "unidimensional" ? new Number(l) : Object.assign({}, l);
                          return f.time = a.keyframes[o - 1].t / a.elem.comp.globalData.frameRate, f.value = s === "unidimensional" ? l[0] : l, f
                      }, i.valueAtTime = a.getValueAtTime, i.speedAtTime = a.getSpeedAtTime, i.velocityAtTime = a.getVelocityAtTime, i.propertyGroup = a.propertyGroup
                  }

                  function n() {
                      return e
                  }
                  return function(i) {
                      return i ? i.propType === "unidimensional" ? function(a) {
                          a && "pv" in a || (a = e);
                          var s = 1 / a.mult,
                              o = a.pv * s,
                              l = new Number(o);
                          return l.value = o, r(l, a, "unidimensional"),
                              function() {
                                  return a.k && a.getValue(), o = a.v * s, l.value !== o && ((l = new Number(o))
                                      .value = o, r(l, a, "unidimensional")), l
                              }
                      }(i) : function(a) {
                          a && "pv" in a || (a = t);
                          var s = 1 / a.mult,
                              o = a.data && a.data.l || a.pv.length,
                              l = createTypedArray("float32", o),
                              f = createTypedArray("float32", o);
                          return l.value = f, r(l, a, "multidimensional"),
                              function() {
                                  a.k && a.getValue();
                                  for (var u = 0; u < o; u += 1) f[u] = a.v[u] * s, l[u] = f[u];
                                  return l
                              }
                      }(i) : n
                  }
              }(),
              TransformExpressionInterface = function(e) {
                  function t(s) {
                      switch (s) {
                          case "scale":
                          case "Scale":
                          case "ADBE Scale":
                          case 6:
                              return t.scale;
                          case "rotation":
                          case "Rotation":
                          case "ADBE Rotation":
                          case "ADBE Rotate Z":
                          case 10:
                              return t.rotation;
                          case "ADBE Rotate X":
                              return t.xRotation;
                          case "ADBE Rotate Y":
                              return t.yRotation;
                          case "position":
                          case "Position":
                          case "ADBE Position":
                          case 2:
                              return t.position;
                          case "ADBE Position_0":
                              return t.xPosition;
                          case "ADBE Position_1":
                              return t.yPosition;
                          case "ADBE Position_2":
                              return t.zPosition;
                          case "anchorPoint":
                          case "AnchorPoint":
                          case "Anchor Point":
                          case "ADBE AnchorPoint":
                          case 1:
                              return t.anchorPoint;
                          case "opacity":
                          case "Opacity":
                          case 11:
                              return t.opacity;
                          default:
                              return null
                      }
                  }
                  var r, n, i, a;
                  return Object.defineProperty(t, "rotation", {
                      get: ExpressionPropertyInterface(e.r || e.rz)
                  }), Object.defineProperty(t, "zRotation", {
                      get: ExpressionPropertyInterface(e.rz || e.r)
                  }), Object.defineProperty(t, "xRotation", {
                      get: ExpressionPropertyInterface(e.rx)
                  }), Object.defineProperty(t, "yRotation", {
                      get: ExpressionPropertyInterface(e.ry)
                  }), Object.defineProperty(t, "scale", {
                      get: ExpressionPropertyInterface(e.s)
                  }), e.p ? a = ExpressionPropertyInterface(e.p) : (r = ExpressionPropertyInterface(e.px), n = ExpressionPropertyInterface(e.py), e.pz && (i = ExpressionPropertyInterface(e.pz))), Object.defineProperty(t, "position", {
                      get: function() {
                          return e.p ? a() : [r(), n(), i ? i() : 0]
                      }
                  }), Object.defineProperty(t, "xPosition", {
                      get: ExpressionPropertyInterface(e.px)
                  }), Object.defineProperty(t, "yPosition", {
                      get: ExpressionPropertyInterface(e.py)
                  }), Object.defineProperty(t, "zPosition", {
                      get: ExpressionPropertyInterface(e.pz)
                  }), Object.defineProperty(t, "anchorPoint", {
                      get: ExpressionPropertyInterface(e.a)
                  }), Object.defineProperty(t, "opacity", {
                      get: ExpressionPropertyInterface(e.o)
                  }), Object.defineProperty(t, "skew", {
                      get: ExpressionPropertyInterface(e.sk)
                  }), Object.defineProperty(t, "skewAxis", {
                      get: ExpressionPropertyInterface(e.sa)
                  }), Object.defineProperty(t, "orientation", {
                      get: ExpressionPropertyInterface(e.or)
                  }), t
              },
              LayerExpressionInterface = function() {
                  function e(f) {
                      var u = new Matrix;
                      return f !== void 0 ? this._elem.finalTransform.mProp.getValueAtTime(f)
                          .clone(u) : this._elem.finalTransform.mProp.applyToMatrix(u), u
                  }

                  function t(f, u) {
                      var c = this.getMatrix(u);
                      return c.props[12] = 0, c.props[13] = 0, c.props[14] = 0, this.applyPoint(c, f)
                  }

                  function r(f, u) {
                      var c = this.getMatrix(u);
                      return this.applyPoint(c, f)
                  }

                  function n(f, u) {
                      var c = this.getMatrix(u);
                      return c.props[12] = 0, c.props[13] = 0, c.props[14] = 0, this.invertPoint(c, f)
                  }

                  function i(f, u) {
                      var c = this.getMatrix(u);
                      return this.invertPoint(c, f)
                  }

                  function a(f, u) {
                      if (this._elem.hierarchy && this._elem.hierarchy.length) {
                          var c, v = this._elem.hierarchy.length;
                          for (c = 0; c < v; c += 1) this._elem.hierarchy[c].finalTransform.mProp.applyToMatrix(f)
                      }
                      return f.applyToPointArray(u[0], u[1], u[2] || 0)
                  }

                  function s(f, u) {
                      if (this._elem.hierarchy && this._elem.hierarchy.length) {
                          var c, v = this._elem.hierarchy.length;
                          for (c = 0; c < v; c += 1) this._elem.hierarchy[c].finalTransform.mProp.applyToMatrix(f)
                      }
                      return f.inversePoint(u)
                  }

                  function o(f) {
                      var u = new Matrix;
                      if (u.reset(), this._elem.finalTransform.mProp.applyToMatrix(u), this._elem.hierarchy && this._elem.hierarchy.length) {
                          var c, v = this._elem.hierarchy.length;
                          for (c = 0; c < v; c += 1) this._elem.hierarchy[c].finalTransform.mProp.applyToMatrix(u);
                          return u.inversePoint(f)
                      }
                      return u.inversePoint(f)
                  }

                  function l() {
                      return [1, 1, 1, 1]
                  }
                  return function(f) {
                      var u;

                      function c(d) {
                          switch (d) {
                              case "ADBE Root Vectors Group":
                              case "Contents":
                              case 2:
                                  return c.shapeInterface;
                              case 1:
                              case 6:
                              case "Transform":
                              case "transform":
                              case "ADBE Transform Group":
                                  return u;
                              case 4:
                              case "ADBE Effect Parade":
                              case "effects":
                              case "Effects":
                                  return c.effect;
                              case "ADBE Text Properties":
                                  return c.textInterface;
                              default:
                                  return null
                          }
                      }
                      c.getMatrix = e, c.invertPoint = s, c.applyPoint = a, c.toWorld = r, c.toWorldVec = t, c.fromWorld = i, c.fromWorldVec = n, c.toComp = r, c.fromComp = o, c.sampleImage = l, c.sourceRectAtTime = f.sourceRectAtTime.bind(f), c._elem = f;
                      var v = getDescriptor(u = TransformExpressionInterface(f.finalTransform.mProp), "anchorPoint");
                      return Object.defineProperties(c, {
                          hasParent: {
                              get: function() {
                                  return f.hierarchy.length
                              }
                          },
                          parent: {
                              get: function() {
                                  return f.hierarchy[0].layerInterface
                              }
                          },
                          rotation: getDescriptor(u, "rotation"),
                          scale: getDescriptor(u, "scale"),
                          position: getDescriptor(u, "position"),
                          opacity: getDescriptor(u, "opacity"),
                          anchorPoint: v,
                          anchor_point: v,
                          transform: {
                              get: function() {
                                  return u
                              }
                          },
                          active: {
                              get: function() {
                                  return f.isInRange
                              }
                          }
                      }), c.startTime = f.data.st, c.index = f.data.ind, c.source = f.data.refId, c.height = f.data.ty === 0 ? f.data.h : 100, c.width = f.data.ty === 0 ? f.data.w : 100, c.inPoint = f.data.ip / f.comp.globalData.frameRate, c.outPoint = f.data.op / f.comp.globalData.frameRate, c._name = f.data.nm, c.registerMaskInterface = function(d) {
                          c.mask = new MaskManagerInterface(d, f)
                      }, c.registerEffectsInterface = function(d) {
                          c.effect = d
                      }, c
                  }
              }(),
              propertyGroupFactory = function(e, t) {
                  return function(r) {
                      return (r = r === void 0 ? 1 : r) <= 0 ? e : t(r - 1)
                  }
              },
              PropertyInterface = function(e, t) {
                  var r = {
                      _name: e
                  };
                  return function(n) {
                      return (n = n === void 0 ? 1 : n) <= 0 ? r : t(n - 1)
                  }
              },
              EffectsExpressionInterface = function() {
                  function e(r, n, i, a) {
                      function s(c) {
                          for (var v = r.ef, d = 0, p = v.length; d < p;) {
                              if (c === v[d].nm || c === v[d].mn || c === v[d].ix) return v[d].ty === 5 ? f[d] : f[d]();
                              d += 1
                          }
                          throw new Error
                      }
                      var o, l = propertyGroupFactory(s, i),
                          f = [],
                          u = r.ef.length;
                      for (o = 0; o < u; o += 1) r.ef[o].ty === 5 ? f.push(e(r.ef[o], n.effectElements[o], n.effectElements[o].propertyGroup, a)) : f.push(t(n.effectElements[o], r.ef[o].ty, a, l));
                      return r.mn === "ADBE Color Control" && Object.defineProperty(s, "color", {
                          get: function() {
                              return f[0]()
                          }
                      }), Object.defineProperties(s, {
                          numProperties: {
                              get: function() {
                                  return r.np
                              }
                          },
                          _name: {
                              value: r.nm
                          },
                          propertyGroup: {
                              value: l
                          }
                      }), s.enabled = r.en !== 0, s.active = s.enabled, s
                  }

                  function t(r, n, i, a) {
                      var s = ExpressionPropertyInterface(r.p);
                      return r.p.setGroupProperty && r.p.setGroupProperty(PropertyInterface("", a)),
                          function() {
                              return n === 10 ? i.comp.compInterface(r.p.v) : s()
                          }
                  }
                  return {
                      createEffectsInterface: function(r, n) {
                          if (r.effectsManager) {
                              var i, a = [],
                                  s = r.data.ef,
                                  o = r.effectsManager.effectElements.length;
                              for (i = 0; i < o; i += 1) a.push(e(s[i], r.effectsManager.effectElements[i], n, r));
                              var l = r.data.ef || [],
                                  f = function(u) {
                                      for (i = 0, o = l.length; i < o;) {
                                          if (u === l[i].nm || u === l[i].mn || u === l[i].ix) return a[i];
                                          i += 1
                                      }
                                      return null
                                  };
                              return Object.defineProperty(f, "numProperties", {
                                  get: function() {
                                      return l.length
                                  }
                              }), f
                          }
                          return null
                      }
                  }
              }(),
              ShapePathInterface = function(e, t, r) {
                  var n = t.sh;

                  function i(s) {
                      return s === "Shape" || s === "shape" || s === "Path" || s === "path" || s === "ADBE Vector Shape" || s === 2 ? i.path : null
                  }
                  var a = propertyGroupFactory(i, r);
                  return n.setGroupProperty(PropertyInterface("Path", a)), Object.defineProperties(i, {
                      path: {
                          get: function() {
                              return n.k && n.getValue(), n
                          }
                      },
                      shape: {
                          get: function() {
                              return n.k && n.getValue(), n
                          }
                      },
                      _name: {
                          value: e.nm
                      },
                      ix: {
                          value: e.ix
                      },
                      propertyIndex: {
                          value: e.ix
                      },
                      mn: {
                          value: e.mn
                      },
                      propertyGroup: {
                          value: r
                      }
                  }), i
              },
              ShapeExpressionInterface = function() {
                  function e(d, p, m) {
                      var h, g = [],
                          y = d ? d.length : 0;
                      for (h = 0; h < y; h += 1) d[h].ty === "gr" ? g.push(t(d[h], p[h], m)) : d[h].ty === "fl" ? g.push(r(d[h], p[h], m)) : d[h].ty === "st" ? g.push(a(d[h], p[h], m)) : d[h].ty === "tm" ? g.push(s(d[h], p[h], m)) : d[h].ty === "tr" || (d[h].ty === "el" ? g.push(l(d[h], p[h], m)) : d[h].ty === "sr" ? g.push(f(d[h], p[h], m)) : d[h].ty === "sh" ? g.push(ShapePathInterface(d[h], p[h], m)) : d[h].ty === "rc" ? g.push(u(d[h], p[h], m)) : d[h].ty === "rd" ? g.push(c(d[h], p[h], m)) : d[h].ty === "rp" ? g.push(v(d[h], p[h], m)) : d[h].ty === "gf" ? g.push(n(d[h], p[h], m)) : g.push(i(d[h], p[h])));
                      return g
                  }

                  function t(d, p, m) {
                      var h = function(b) {
                          switch (b) {
                              case "ADBE Vectors Group":
                              case "Contents":
                              case 2:
                                  return h.content;
                              default:
                                  return h.transform
                          }
                      };
                      h.propertyGroup = propertyGroupFactory(h, m);
                      var g = function(b, _, I) {
                              var C, x = function(L) {
                                  for (var D = 0, A = C.length; D < A;) {
                                      if (C[D]._name === L || C[D].mn === L || C[D].propertyIndex === L || C[D].ix === L || C[D].ind === L) return C[D];
                                      D += 1
                                  }
                                  return typeof L == "number" ? C[L - 1] : null
                              };
                              x.propertyGroup = propertyGroupFactory(x, I), C = e(b.it, _.it, x.propertyGroup), x.numProperties = C.length;
                              var O = o(b.it[b.it.length - 1], _.it[_.it.length - 1], x.propertyGroup);
                              return x.transform = O, x.propertyIndex = b.cix, x._name = b.nm, x
                          }(d, p, h.propertyGroup),
                          y = o(d.it[d.it.length - 1], p.it[p.it.length - 1], h.propertyGroup);
                      return h.content = g, h.transform = y, Object.defineProperty(h, "_name", {
                          get: function() {
                              return d.nm
                          }
                      }), h.numProperties = d.np, h.propertyIndex = d.ix, h.nm = d.nm, h.mn = d.mn, h
                  }

                  function r(d, p, m) {
                      function h(g) {
                          return g === "Color" || g === "color" ? h.color : g === "Opacity" || g === "opacity" ? h.opacity : null
                      }
                      return Object.defineProperties(h, {
                          color: {
                              get: ExpressionPropertyInterface(p.c)
                          },
                          opacity: {
                              get: ExpressionPropertyInterface(p.o)
                          },
                          _name: {
                              value: d.nm
                          },
                          mn: {
                              value: d.mn
                          }
                      }), p.c.setGroupProperty(PropertyInterface("Color", m)), p.o.setGroupProperty(PropertyInterface("Opacity", m)), h
                  }

                  function n(d, p, m) {
                      function h(g) {
                          return g === "Start Point" || g === "start point" ? h.startPoint : g === "End Point" || g === "end point" ? h.endPoint : g === "Opacity" || g === "opacity" ? h.opacity : null
                      }
                      return Object.defineProperties(h, {
                          startPoint: {
                              get: ExpressionPropertyInterface(p.s)
                          },
                          endPoint: {
                              get: ExpressionPropertyInterface(p.e)
                          },
                          opacity: {
                              get: ExpressionPropertyInterface(p.o)
                          },
                          type: {
                              get: function() {
                                  return "a"
                              }
                          },
                          _name: {
                              value: d.nm
                          },
                          mn: {
                              value: d.mn
                          }
                      }), p.s.setGroupProperty(PropertyInterface("Start Point", m)), p.e.setGroupProperty(PropertyInterface("End Point", m)), p.o.setGroupProperty(PropertyInterface("Opacity", m)), h
                  }

                  function i() {
                      return function() {
                          return null
                      }
                  }

                  function a(d, p, m) {
                      var h, g = propertyGroupFactory(C, m),
                          y = propertyGroupFactory(I, g);

                      function b(x) {
                          Object.defineProperty(I, d.d[x].nm, {
                              get: ExpressionPropertyInterface(p.d.dataProps[x].p)
                          })
                      }
                      var _ = d.d ? d.d.length : 0,
                          I = {};
                      for (h = 0; h < _; h += 1) b(h), p.d.dataProps[h].p.setGroupProperty(y);

                      function C(x) {
                          return x === "Color" || x === "color" ? C.color : x === "Opacity" || x === "opacity" ? C.opacity : x === "Stroke Width" || x === "stroke width" ? C.strokeWidth : null
                      }
                      return Object.defineProperties(C, {
                          color: {
                              get: ExpressionPropertyInterface(p.c)
                          },
                          opacity: {
                              get: ExpressionPropertyInterface(p.o)
                          },
                          strokeWidth: {
                              get: ExpressionPropertyInterface(p.w)
                          },
                          dash: {
                              get: function() {
                                  return I
                              }
                          },
                          _name: {
                              value: d.nm
                          },
                          mn: {
                              value: d.mn
                          }
                      }), p.c.setGroupProperty(PropertyInterface("Color", g)), p.o.setGroupProperty(PropertyInterface("Opacity", g)), p.w.setGroupProperty(PropertyInterface("Stroke Width", g)), C
                  }

                  function s(d, p, m) {
                      function h(y) {
                          return y === d.e.ix || y === "End" || y === "end" ? h.end : y === d.s.ix ? h.start : y === d.o.ix ? h.offset : null
                      }
                      var g = propertyGroupFactory(h, m);
                      return h.propertyIndex = d.ix, p.s.setGroupProperty(PropertyInterface("Start", g)), p.e.setGroupProperty(PropertyInterface("End", g)), p.o.setGroupProperty(PropertyInterface("Offset", g)), h.propertyIndex = d.ix, h.propertyGroup = m, Object.defineProperties(h, {
                          start: {
                              get: ExpressionPropertyInterface(p.s)
                          },
                          end: {
                              get: ExpressionPropertyInterface(p.e)
                          },
                          offset: {
                              get: ExpressionPropertyInterface(p.o)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.mn = d.mn, h
                  }

                  function o(d, p, m) {
                      function h(y) {
                          return d.a.ix === y || y === "Anchor Point" ? h.anchorPoint : d.o.ix === y || y === "Opacity" ? h.opacity : d.p.ix === y || y === "Position" ? h.position : d.r.ix === y || y === "Rotation" || y === "ADBE Vector Rotation" ? h.rotation : d.s.ix === y || y === "Scale" ? h.scale : d.sk && d.sk.ix === y || y === "Skew" ? h.skew : d.sa && d.sa.ix === y || y === "Skew Axis" ? h.skewAxis : null
                      }
                      var g = propertyGroupFactory(h, m);
                      return p.transform.mProps.o.setGroupProperty(PropertyInterface("Opacity", g)), p.transform.mProps.p.setGroupProperty(PropertyInterface("Position", g)), p.transform.mProps.a.setGroupProperty(PropertyInterface("Anchor Point", g)), p.transform.mProps.s.setGroupProperty(PropertyInterface("Scale", g)), p.transform.mProps.r.setGroupProperty(PropertyInterface("Rotation", g)), p.transform.mProps.sk && (p.transform.mProps.sk.setGroupProperty(PropertyInterface("Skew", g)), p.transform.mProps.sa.setGroupProperty(PropertyInterface("Skew Angle", g))), p.transform.op.setGroupProperty(PropertyInterface("Opacity", g)), Object.defineProperties(h, {
                          opacity: {
                              get: ExpressionPropertyInterface(p.transform.mProps.o)
                          },
                          position: {
                              get: ExpressionPropertyInterface(p.transform.mProps.p)
                          },
                          anchorPoint: {
                              get: ExpressionPropertyInterface(p.transform.mProps.a)
                          },
                          scale: {
                              get: ExpressionPropertyInterface(p.transform.mProps.s)
                          },
                          rotation: {
                              get: ExpressionPropertyInterface(p.transform.mProps.r)
                          },
                          skew: {
                              get: ExpressionPropertyInterface(p.transform.mProps.sk)
                          },
                          skewAxis: {
                              get: ExpressionPropertyInterface(p.transform.mProps.sa)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.ty = "tr", h.mn = d.mn, h.propertyGroup = m, h
                  }

                  function l(d, p, m) {
                      function h(b) {
                          return d.p.ix === b ? h.position : d.s.ix === b ? h.size : null
                      }
                      var g = propertyGroupFactory(h, m);
                      h.propertyIndex = d.ix;
                      var y = p.sh.ty === "tm" ? p.sh.prop : p.sh;
                      return y.s.setGroupProperty(PropertyInterface("Size", g)), y.p.setGroupProperty(PropertyInterface("Position", g)), Object.defineProperties(h, {
                          size: {
                              get: ExpressionPropertyInterface(y.s)
                          },
                          position: {
                              get: ExpressionPropertyInterface(y.p)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.mn = d.mn, h
                  }

                  function f(d, p, m) {
                      function h(b) {
                          return d.p.ix === b ? h.position : d.r.ix === b ? h.rotation : d.pt.ix === b ? h.points : d.or.ix === b || b === "ADBE Vector Star Outer Radius" ? h.outerRadius : d.os.ix === b ? h.outerRoundness : !d.ir || d.ir.ix !== b && b !== "ADBE Vector Star Inner Radius" ? d.is && d.is.ix === b ? h.innerRoundness : null : h.innerRadius
                      }
                      var g = propertyGroupFactory(h, m),
                          y = p.sh.ty === "tm" ? p.sh.prop : p.sh;
                      return h.propertyIndex = d.ix, y.or.setGroupProperty(PropertyInterface("Outer Radius", g)), y.os.setGroupProperty(PropertyInterface("Outer Roundness", g)), y.pt.setGroupProperty(PropertyInterface("Points", g)), y.p.setGroupProperty(PropertyInterface("Position", g)), y.r.setGroupProperty(PropertyInterface("Rotation", g)), d.ir && (y.ir.setGroupProperty(PropertyInterface("Inner Radius", g)), y.is.setGroupProperty(PropertyInterface("Inner Roundness", g))), Object.defineProperties(h, {
                          position: {
                              get: ExpressionPropertyInterface(y.p)
                          },
                          rotation: {
                              get: ExpressionPropertyInterface(y.r)
                          },
                          points: {
                              get: ExpressionPropertyInterface(y.pt)
                          },
                          outerRadius: {
                              get: ExpressionPropertyInterface(y.or)
                          },
                          outerRoundness: {
                              get: ExpressionPropertyInterface(y.os)
                          },
                          innerRadius: {
                              get: ExpressionPropertyInterface(y.ir)
                          },
                          innerRoundness: {
                              get: ExpressionPropertyInterface(y.is)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.mn = d.mn, h
                  }

                  function u(d, p, m) {
                      function h(b) {
                          return d.p.ix === b ? h.position : d.r.ix === b ? h.roundness : d.s.ix === b || b === "Size" || b === "ADBE Vector Rect Size" ? h.size : null
                      }
                      var g = propertyGroupFactory(h, m),
                          y = p.sh.ty === "tm" ? p.sh.prop : p.sh;
                      return h.propertyIndex = d.ix, y.p.setGroupProperty(PropertyInterface("Position", g)), y.s.setGroupProperty(PropertyInterface("Size", g)), y.r.setGroupProperty(PropertyInterface("Rotation", g)), Object.defineProperties(h, {
                          position: {
                              get: ExpressionPropertyInterface(y.p)
                          },
                          roundness: {
                              get: ExpressionPropertyInterface(y.r)
                          },
                          size: {
                              get: ExpressionPropertyInterface(y.s)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.mn = d.mn, h
                  }

                  function c(d, p, m) {
                      function h(b) {
                          return d.r.ix === b || b === "Round Corners 1" ? h.radius : null
                      }
                      var g = propertyGroupFactory(h, m),
                          y = p;
                      return h.propertyIndex = d.ix, y.rd.setGroupProperty(PropertyInterface("Radius", g)), Object.defineProperties(h, {
                          radius: {
                              get: ExpressionPropertyInterface(y.rd)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.mn = d.mn, h
                  }

                  function v(d, p, m) {
                      function h(b) {
                          return d.c.ix === b || b === "Copies" ? h.copies : d.o.ix === b || b === "Offset" ? h.offset : null
                      }
                      var g = propertyGroupFactory(h, m),
                          y = p;
                      return h.propertyIndex = d.ix, y.c.setGroupProperty(PropertyInterface("Copies", g)), y.o.setGroupProperty(PropertyInterface("Offset", g)), Object.defineProperties(h, {
                          copies: {
                              get: ExpressionPropertyInterface(y.c)
                          },
                          offset: {
                              get: ExpressionPropertyInterface(y.o)
                          },
                          _name: {
                              value: d.nm
                          }
                      }), h.mn = d.mn, h
                  }
                  return function(d, p, m) {
                      var h;

                      function g(y) {
                          if (typeof y == "number") return (y = y === void 0 ? 1 : y) === 0 ? m : h[y - 1];
                          for (var b = 0, _ = h.length; b < _;) {
                              if (h[b]._name === y) return h[b];
                              b += 1
                          }
                          return null
                      }
                      return g.propertyGroup = propertyGroupFactory(g, function() {
                          return m
                      }), h = e(d, p, g.propertyGroup), g.numProperties = h.length, g._name = "Contents", g
                  }
              }(),
              TextExpressionInterface = function(e) {
                  var t;

                  function r(n) {
                      return n === "ADBE Text Document" ? r.sourceText : null
                  }
                  return Object.defineProperty(r, "sourceText", {
                      get: function() {
                          e.textProperty.getValue();
                          var n = e.textProperty.currentData.t;
                          return t && n === t.value || ((t = new String(n))
                              .value = n || new String(n), Object.defineProperty(t, "style", {
                                  get: function() {
                                      return {
                                          fillColor: e.textProperty.currentData.fc
                                      }
                                  }
                              })), t
                      }
                  }), r
              };

          function _typeof(e) {
              return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
                  return typeof t
              } : function(t) {
                  return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
              }, _typeof(e)
          }
          var FootageInterface = (dataInterfaceFactory = function(e) {
                  function t(r) {
                      return r === "Outline" ? t.outlineInterface() : null
                  }
                  return t._name = "Outline", t.outlineInterface = function(r) {
                      var n = "",
                          i = r.getFootageData();

                      function a(s) {
                          if (i[s]) return n = s, _typeof(i = i[s]) === "object" ? a : i;
                          var o = s.indexOf(n);
                          if (o !== -1) {
                              var l = parseInt(s.substr(o + n.length), 10);
                              return _typeof(i = i[l]) === "object" ? a : i
                          }
                          return ""
                      }
                      return function() {
                          return n = "", i = r.getFootageData(), a
                      }
                  }(e), t
              }, function(e) {
                  function t(r) {
                      return r === "Data" ? t.dataInterface : null
                  }
                  return t._name = "Data", t.dataInterface = dataInterfaceFactory(e), t
              }),
              dataInterfaceFactory, interfaces = {
                  layer: LayerExpressionInterface,
                  effects: EffectsExpressionInterface,
                  comp: CompExpressionInterface,
                  shape: ShapeExpressionInterface,
                  text: TextExpressionInterface,
                  footage: FootageInterface
              };

          function getInterface(e) {
              return interfaces[e] || null
          }
          var expressionHelpers = {
              searchExpressions: function(e, t, r) {
                  t.x && (r.k = !0, r.x = !0, r.initiateExpression = ExpressionManager.initiateExpression, r.effectsSequence.push(r.initiateExpression(e, t, r)
                      .bind(r)))
              },
              getSpeedAtTime: function(e) {
                  var t = this.getValueAtTime(e),
                      r = this.getValueAtTime(e + -.01),
                      n = 0;
                  if (t.length) {
                      var i;
                      for (i = 0; i < t.length; i += 1) n += Math.pow(r[i] - t[i], 2);
                      n = 100 * Math.sqrt(n)
                  } else n = 0;
                  return n
              },
              getVelocityAtTime: function(e) {
                  if (this.vel !== void 0) return this.vel;
                  var t, r, n = -.001,
                      i = this.getValueAtTime(e),
                      a = this.getValueAtTime(e + n);
                  if (i.length)
                      for (t = createTypedArray("float32", i.length), r = 0; r < i.length; r += 1) t[r] = (a[r] - i[r]) / n;
                  else t = (a - i) / n;
                  return t
              },
              getValueAtTime: function(e) {
                  return e *= this.elem.globalData.frameRate, (e -= this.offsetTime) !== this._cachingAtTime.lastFrame && (this._cachingAtTime.lastIndex = this._cachingAtTime.lastFrame < e ? this._cachingAtTime.lastIndex : 0, this._cachingAtTime.value = this.interpolateValue(e, this._cachingAtTime), this._cachingAtTime.lastFrame = e), this._cachingAtTime.value
              },
              getStaticValueAtTime: function() {
                  return this.pv
              },
              setGroupProperty: function(e) {
                  this.propertyGroup = e
              }
          };

          function addPropertyDecorator() {
              function e(c, v, d) {
                  if (!this.k || !this.keyframes) return this.pv;
                  c = c ? c.toLowerCase() : "";
                  var p, m, h, g, y, b = this.comp.renderedFrame,
                      _ = this.keyframes,
                      I = _[_.length - 1].t;
                  if (b <= I) return this.pv;
                  if (d ? m = I - (p = v ? Math.abs(I - this.elem.comp.globalData.frameRate * v) : Math.max(0, I - this.elem.data.ip)) : ((!v || v > _.length - 1) && (v = _.length - 1), p = I - (m = _[_.length - 1 - v].t)), c === "pingpong") {
                      if (Math.floor((b - m) / p) % 2 != 0) return this.getValueAtTime((p - (b - m) % p + m) / this.comp.globalData.frameRate, 0)
                  } else {
                      if (c === "offset") {
                          var C = this.getValueAtTime(m / this.comp.globalData.frameRate, 0),
                              x = this.getValueAtTime(I / this.comp.globalData.frameRate, 0),
                              O = this.getValueAtTime(((b - m) % p + m) / this.comp.globalData.frameRate, 0),
                              L = Math.floor((b - m) / p);
                          if (this.pv.length) {
                              for (g = (y = new Array(C.length))
                                  .length, h = 0; h < g; h += 1) y[h] = (x[h] - C[h]) * L + O[h];
                              return y
                          }
                          return (x - C) * L + O
                      }
                      if (c === "continue") {
                          var D = this.getValueAtTime(I / this.comp.globalData.frameRate, 0),
                              A = this.getValueAtTime((I - .001) / this.comp.globalData.frameRate, 0);
                          if (this.pv.length) {
                              for (g = (y = new Array(D.length))
                                  .length, h = 0; h < g; h += 1) y[h] = D[h] + (D[h] - A[h]) * ((b - I) / this.comp.globalData.frameRate) / 5e-4;
                              return y
                          }
                          return D + (b - I) / .001 * (D - A)
                      }
                  }
                  return this.getValueAtTime(((b - m) % p + m) / this.comp.globalData.frameRate, 0)
              }

              function t(c, v, d) {
                  if (!this.k) return this.pv;
                  c = c ? c.toLowerCase() : "";
                  var p, m, h, g, y, b = this.comp.renderedFrame,
                      _ = this.keyframes,
                      I = _[0].t;
                  if (b >= I) return this.pv;
                  if (d ? m = I + (p = v ? Math.abs(this.elem.comp.globalData.frameRate * v) : Math.max(0, this.elem.data.op - I)) : ((!v || v > _.length - 1) && (v = _.length - 1), p = (m = _[v].t) - I), c === "pingpong") {
                      if (Math.floor((I - b) / p) % 2 == 0) return this.getValueAtTime(((I - b) % p + I) / this.comp.globalData.frameRate, 0)
                  } else {
                      if (c === "offset") {
                          var C = this.getValueAtTime(I / this.comp.globalData.frameRate, 0),
                              x = this.getValueAtTime(m / this.comp.globalData.frameRate, 0),
                              O = this.getValueAtTime((p - (I - b) % p + I) / this.comp.globalData.frameRate, 0),
                              L = Math.floor((I - b) / p) + 1;
                          if (this.pv.length) {
                              for (g = (y = new Array(C.length))
                                  .length, h = 0; h < g; h += 1) y[h] = O[h] - (x[h] - C[h]) * L;
                              return y
                          }
                          return O - (x - C) * L
                      }
                      if (c === "continue") {
                          var D = this.getValueAtTime(I / this.comp.globalData.frameRate, 0),
                              A = this.getValueAtTime((I + .001) / this.comp.globalData.frameRate, 0);
                          if (this.pv.length) {
                              for (g = (y = new Array(D.length))
                                  .length, h = 0; h < g; h += 1) y[h] = D[h] + (D[h] - A[h]) * (I - b) / .001;
                              return y
                          }
                          return D + (D - A) * (I - b) / .001
                      }
                  }
                  return this.getValueAtTime((p - ((I - b) % p + I)) / this.comp.globalData.frameRate, 0)
              }

              function r(c, v) {
                  if (!this.k) return this.pv;
                  if (c = .5 * (c || .4), (v = Math.floor(v || 5)) <= 1) return this.pv;
                  var d, p, m = this.comp.renderedFrame / this.comp.globalData.frameRate,
                      h = m - c,
                      g = v > 1 ? (m + c - h) / (v - 1) : 1,
                      y = 0,
                      b = 0;
                  for (d = this.pv.length ? createTypedArray("float32", this.pv.length) : 0; y < v;) {
                      if (p = this.getValueAtTime(h + y * g), this.pv.length)
                          for (b = 0; b < this.pv.length; b += 1) d[b] += p[b];
                      else d += p;
                      y += 1
                  }
                  if (this.pv.length)
                      for (b = 0; b < this.pv.length; b += 1) d[b] /= v;
                  else d /= v;
                  return d
              }

              function n(c) {
                  this._transformCachingAtTime || (this._transformCachingAtTime = {
                      v: new Matrix
                  });
                  var v = this._transformCachingAtTime.v;
                  if (v.cloneFromProps(this.pre.props), this.appliedTransformations < 1) {
                      var d = this.a.getValueAtTime(c);
                      v.translate(-d[0] * this.a.mult, -d[1] * this.a.mult, d[2] * this.a.mult)
                  }
                  if (this.appliedTransformations < 2) {
                      var p = this.s.getValueAtTime(c);
                      v.scale(p[0] * this.s.mult, p[1] * this.s.mult, p[2] * this.s.mult)
                  }
                  if (this.sk && this.appliedTransformations < 3) {
                      var m = this.sk.getValueAtTime(c),
                          h = this.sa.getValueAtTime(c);
                      v.skewFromAxis(-m * this.sk.mult, h * this.sa.mult)
                  }
                  if (this.r && this.appliedTransformations < 4) {
                      var g = this.r.getValueAtTime(c);
                      v.rotate(-g * this.r.mult)
                  } else if (!this.r && this.appliedTransformations < 4) {
                      var y = this.rz.getValueAtTime(c),
                          b = this.ry.getValueAtTime(c),
                          _ = this.rx.getValueAtTime(c),
                          I = this.or.getValueAtTime(c);
                      v.rotateZ(-y * this.rz.mult)
                          .rotateY(b * this.ry.mult)
                          .rotateX(_ * this.rx.mult)
                          .rotateZ(-I[2] * this.or.mult)
                          .rotateY(I[1] * this.or.mult)
                          .rotateX(I[0] * this.or.mult)
                  }
                  if (this.data.p && this.data.p.s) {
                      var C = this.px.getValueAtTime(c),
                          x = this.py.getValueAtTime(c);
                      if (this.data.p.z) {
                          var O = this.pz.getValueAtTime(c);
                          v.translate(C * this.px.mult, x * this.py.mult, -O * this.pz.mult)
                      } else v.translate(C * this.px.mult, x * this.py.mult, 0)
                  } else {
                      var L = this.p.getValueAtTime(c);
                      v.translate(L[0] * this.p.mult, L[1] * this.p.mult, -L[2] * this.p.mult)
                  }
                  return v
              }

              function i() {
                  return this.v.clone(new Matrix)
              }
              var a = TransformPropertyFactory.getTransformProperty;
              TransformPropertyFactory.getTransformProperty = function(c, v, d) {
                  var p = a(c, v, d);
                  return p.dynamicProperties.length ? p.getValueAtTime = n.bind(p) : p.getValueAtTime = i.bind(p), p.setGroupProperty = expressionHelpers.setGroupProperty, p
              };
              var s = PropertyFactory.getProp;
              PropertyFactory.getProp = function(c, v, d, p, m) {
                  var h = s(c, v, d, p, m);
                  h.kf ? h.getValueAtTime = expressionHelpers.getValueAtTime.bind(h) : h.getValueAtTime = expressionHelpers.getStaticValueAtTime.bind(h), h.setGroupProperty = expressionHelpers.setGroupProperty, h.loopOut = e, h.loopIn = t, h.smooth = r, h.getVelocityAtTime = expressionHelpers.getVelocityAtTime.bind(h), h.getSpeedAtTime = expressionHelpers.getSpeedAtTime.bind(h), h.numKeys = v.a === 1 ? v.k.length : 0, h.propertyIndex = v.ix;
                  var g = 0;
                  return d !== 0 && (g = createTypedArray("float32", v.a === 1 ? v.k[0].s.length : v.k.length)), h._cachingAtTime = {
                      lastFrame: initialDefaultFrame,
                      lastIndex: 0,
                      value: g
                  }, expressionHelpers.searchExpressions(c, v, h), h.k && m.addDynamicProperty(h), h
              };
              var o = ShapePropertyFactory.getConstructorFunction(),
                  l = ShapePropertyFactory.getKeyframedConstructorFunction();

              function f() {}
              f.prototype = {
                  vertices: function(c, v) {
                      this.k && this.getValue();
                      var d, p = this.v;
                      v !== void 0 && (p = this.getValueAtTime(v, 0));
                      var m = p._length,
                          h = p[c],
                          g = p.v,
                          y = createSizedArray(m);
                      for (d = 0; d < m; d += 1) y[d] = c === "i" || c === "o" ? [h[d][0] - g[d][0], h[d][1] - g[d][1]] : [h[d][0], h[d][1]];
                      return y
                  },
                  points: function(c) {
                      return this.vertices("v", c)
                  },
                  inTangents: function(c) {
                      return this.vertices("i", c)
                  },
                  outTangents: function(c) {
                      return this.vertices("o", c)
                  },
                  isClosed: function() {
                      return this.v.c
                  },
                  pointOnPath: function(c, v) {
                      var d = this.v;
                      v !== void 0 && (d = this.getValueAtTime(v, 0)), this._segmentsLength || (this._segmentsLength = bez.getSegmentsLength(d));
                      for (var p, m = this._segmentsLength, h = m.lengths, g = m.totalLength * c, y = 0, b = h.length, _ = 0; y < b;) {
                          if (_ + h[y].addedLength > g) {
                              var I = y,
                                  C = d.c && y === b - 1 ? 0 : y + 1,
                                  x = (g - _) / h[y].addedLength;
                              p = bez.getPointInSegment(d.v[I], d.v[C], d.o[I], d.i[C], x, h[y]);
                              break
                          }
                          _ += h[y].addedLength, y += 1
                      }
                      return p || (p = d.c ? [d.v[0][0], d.v[0][1]] : [d.v[d._length - 1][0], d.v[d._length - 1][1]]), p
                  },
                  vectorOnPath: function(c, v, d) {
                      c == 1 ? c = this.v.c : c == 0 && (c = .999);
                      var p = this.pointOnPath(c, v),
                          m = this.pointOnPath(c + .001, v),
                          h = m[0] - p[0],
                          g = m[1] - p[1],
                          y = Math.sqrt(Math.pow(h, 2) + Math.pow(g, 2));
                      return y === 0 ? [0, 0] : d === "tangent" ? [h / y, g / y] : [-g / y, h / y]
                  },
                  tangentOnPath: function(c, v) {
                      return this.vectorOnPath(c, v, "tangent")
                  },
                  normalOnPath: function(c, v) {
                      return this.vectorOnPath(c, v, "normal")
                  },
                  setGroupProperty: expressionHelpers.setGroupProperty,
                  getValueAtTime: expressionHelpers.getStaticValueAtTime
              }, extendPrototype([f], o), extendPrototype([f], l), l.prototype.getValueAtTime = function(c) {
                  return this._cachingAtTime || (this._cachingAtTime = {
                      shapeValue: shapePool.clone(this.pv),
                      lastIndex: 0,
                      lastTime: initialDefaultFrame
                  }), c *= this.elem.globalData.frameRate, (c -= this.offsetTime) !== this._cachingAtTime.lastTime && (this._cachingAtTime.lastIndex = this._cachingAtTime.lastTime < c ? this._caching.lastIndex : 0, this._cachingAtTime.lastTime = c, this.interpolateShape(c, this._cachingAtTime.shapeValue, this._cachingAtTime)), this._cachingAtTime.shapeValue
              }, l.prototype.initiateExpression = ExpressionManager.initiateExpression;
              var u = ShapePropertyFactory.getShapeProp;
              ShapePropertyFactory.getShapeProp = function(c, v, d, p, m) {
                  var h = u(c, v, d, p, m);
                  return h.propertyIndex = v.ix, h.lock = !1, d === 3 ? expressionHelpers.searchExpressions(c, v.pt, h) : d === 4 && expressionHelpers.searchExpressions(c, v.ks, h), h.k && c.addDynamicProperty(h), h
              }
          }

          function initialize$1() {
              addPropertyDecorator()
          }

          function addDecorator() {
              TextProperty.prototype.getExpressionValue = function(e, t) {
                  var r = this.calculateExpression(t);
                  if (e.t !== r) {
                      var n = {};
                      return this.copyData(n, e), n.t = r.toString(), n.__complete = !1, n
                  }
                  return e
              }, TextProperty.prototype.searchProperty = function() {
                  var e = this.searchKeyframes(),
                      t = this.searchExpressions();
                  return this.kf = e || t, this.kf
              }, TextProperty.prototype.searchExpressions = function() {
                  return this.data.d.x ? (this.calculateExpression = ExpressionManager.initiateExpression.bind(this)(this.elem, this.data.d, this), this.addEffect(this.getExpressionValue.bind(this)), !0) : null
              }
          }

          function initialize() {
              addDecorator()
          }

          function SVGComposableEffect() {}
          SVGComposableEffect.prototype = {
              createMergeNode: function(e, t) {
                  var r, n, i = createNS("feMerge");
                  for (i.setAttribute("result", e), n = 0; n < t.length; n += 1)(r = createNS("feMergeNode"))
                      .setAttribute("in", t[n]), i.appendChild(r), i.appendChild(r);
                  return i
              }
          };
          var linearFilterValue = "0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0";

          function SVGTintFilter(e, t, r, n, i) {
              this.filterManager = t;
              var a = createNS("feColorMatrix");
              a.setAttribute("type", "matrix"), a.setAttribute("color-interpolation-filters", "linearRGB"), a.setAttribute("values", linearFilterValue + " 1 0"), this.linearFilter = a, a.setAttribute("result", n + "_tint_1"), e.appendChild(a), (a = createNS("feColorMatrix"))
                  .setAttribute("type", "matrix"), a.setAttribute("color-interpolation-filters", "sRGB"), a.setAttribute("values", "1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"), a.setAttribute("result", n + "_tint_2"), e.appendChild(a), this.matrixFilter = a;
              var s = this.createMergeNode(n, [i, n + "_tint_1", n + "_tint_2"]);
              e.appendChild(s)
          }

          function SVGFillFilter(e, t, r, n) {
              this.filterManager = t;
              var i = createNS("feColorMatrix");
              i.setAttribute("type", "matrix"), i.setAttribute("color-interpolation-filters", "sRGB"), i.setAttribute("values", "1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"), i.setAttribute("result", n), e.appendChild(i), this.matrixFilter = i
          }

          function SVGStrokeEffect(e, t, r) {
              this.initialized = !1, this.filterManager = t, this.elem = r, this.paths = []
          }

          function SVGTritoneFilter(e, t, r, n) {
              this.filterManager = t;
              var i = createNS("feColorMatrix");
              i.setAttribute("type", "matrix"), i.setAttribute("color-interpolation-filters", "linearRGB"), i.setAttribute("values", "0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"), e.appendChild(i);
              var a = createNS("feComponentTransfer");
              a.setAttribute("color-interpolation-filters", "sRGB"), a.setAttribute("result", n), this.matrixFilter = a;
              var s = createNS("feFuncR");
              s.setAttribute("type", "table"), a.appendChild(s), this.feFuncR = s;
              var o = createNS("feFuncG");
              o.setAttribute("type", "table"), a.appendChild(o), this.feFuncG = o;
              var l = createNS("feFuncB");
              l.setAttribute("type", "table"), a.appendChild(l), this.feFuncB = l, e.appendChild(a)
          }

          function SVGProLevelsFilter(e, t, r, n) {
              this.filterManager = t;
              var i = this.filterManager.effectElements,
                  a = createNS("feComponentTransfer");
              (i[10].p.k || i[10].p.v !== 0 || i[11].p.k || i[11].p.v !== 1 || i[12].p.k || i[12].p.v !== 1 || i[13].p.k || i[13].p.v !== 0 || i[14].p.k || i[14].p.v !== 1) && (this.feFuncR = this.createFeFunc("feFuncR", a)), (i[17].p.k || i[17].p.v !== 0 || i[18].p.k || i[18].p.v !== 1 || i[19].p.k || i[19].p.v !== 1 || i[20].p.k || i[20].p.v !== 0 || i[21].p.k || i[21].p.v !== 1) && (this.feFuncG = this.createFeFunc("feFuncG", a)), (i[24].p.k || i[24].p.v !== 0 || i[25].p.k || i[25].p.v !== 1 || i[26].p.k || i[26].p.v !== 1 || i[27].p.k || i[27].p.v !== 0 || i[28].p.k || i[28].p.v !== 1) && (this.feFuncB = this.createFeFunc("feFuncB", a)), (i[31].p.k || i[31].p.v !== 0 || i[32].p.k || i[32].p.v !== 1 || i[33].p.k || i[33].p.v !== 1 || i[34].p.k || i[34].p.v !== 0 || i[35].p.k || i[35].p.v !== 1) && (this.feFuncA = this.createFeFunc("feFuncA", a)), (this.feFuncR || this.feFuncG || this.feFuncB || this.feFuncA) && (a.setAttribute("color-interpolation-filters", "sRGB"), e.appendChild(a)), (i[3].p.k || i[3].p.v !== 0 || i[4].p.k || i[4].p.v !== 1 || i[5].p.k || i[5].p.v !== 1 || i[6].p.k || i[6].p.v !== 0 || i[7].p.k || i[7].p.v !== 1) && ((a = createNS("feComponentTransfer"))
                  .setAttribute("color-interpolation-filters", "sRGB"), a.setAttribute("result", n), e.appendChild(a), this.feFuncRComposed = this.createFeFunc("feFuncR", a), this.feFuncGComposed = this.createFeFunc("feFuncG", a), this.feFuncBComposed = this.createFeFunc("feFuncB", a))
          }

          function SVGDropShadowEffect(e, t, r, n, i) {
              var a = t.container.globalData.renderConfig.filterSize,
                  s = t.data.fs || a;
              e.setAttribute("x", s.x || a.x), e.setAttribute("y", s.y || a.y), e.setAttribute("width", s.width || a.width), e.setAttribute("height", s.height || a.height), this.filterManager = t;
              var o = createNS("feGaussianBlur");
              o.setAttribute("in", "SourceAlpha"), o.setAttribute("result", n + "_drop_shadow_1"), o.setAttribute("stdDeviation", "0"), this.feGaussianBlur = o, e.appendChild(o);
              var l = createNS("feOffset");
              l.setAttribute("dx", "25"), l.setAttribute("dy", "0"), l.setAttribute("in", n + "_drop_shadow_1"), l.setAttribute("result", n + "_drop_shadow_2"), this.feOffset = l, e.appendChild(l);
              var f = createNS("feFlood");
              f.setAttribute("flood-color", "#00ff00"), f.setAttribute("flood-opacity", "1"), f.setAttribute("result", n + "_drop_shadow_3"), this.feFlood = f, e.appendChild(f);
              var u = createNS("feComposite");
              u.setAttribute("in", n + "_drop_shadow_3"), u.setAttribute("in2", n + "_drop_shadow_2"), u.setAttribute("operator", "in"), u.setAttribute("result", n + "_drop_shadow_4"), e.appendChild(u);
              var c = this.createMergeNode(n, [n + "_drop_shadow_4", i]);
              e.appendChild(c)
          }
          extendPrototype([SVGComposableEffect], SVGTintFilter), SVGTintFilter.prototype.renderFrame = function(e) {
              if (e || this.filterManager._mdf) {
                  var t = this.filterManager.effectElements[0].p.v,
                      r = this.filterManager.effectElements[1].p.v,
                      n = this.filterManager.effectElements[2].p.v / 100;
                  this.linearFilter.setAttribute("values", linearFilterValue + " " + n + " 0"), this.matrixFilter.setAttribute("values", r[0] - t[0] + " 0 0 0 " + t[0] + " " + (r[1] - t[1]) + " 0 0 0 " + t[1] + " " + (r[2] - t[2]) + " 0 0 0 " + t[2] + " 0 0 0 1 0")
              }
          }, SVGFillFilter.prototype.renderFrame = function(e) {
              if (e || this.filterManager._mdf) {
                  var t = this.filterManager.effectElements[2].p.v,
                      r = this.filterManager.effectElements[6].p.v;
                  this.matrixFilter.setAttribute("values", "0 0 0 0 " + t[0] + " 0 0 0 0 " + t[1] + " 0 0 0 0 " + t[2] + " 0 0 0 " + r + " 0")
              }
          }, SVGStrokeEffect.prototype.initialize = function() {
              var e, t, r, n, i = this.elem.layerElement.children || this.elem.layerElement.childNodes;
              for (this.filterManager.effectElements[1].p.v === 1 ? (n = this.elem.maskManager.masksProperties.length, r = 0) : n = (r = this.filterManager.effectElements[0].p.v - 1) + 1, (t = createNS("g"))
                  .setAttribute("fill", "none"), t.setAttribute("stroke-linecap", "round"), t.setAttribute("stroke-dashoffset", 1); r < n; r += 1) e = createNS("path"), t.appendChild(e), this.paths.push({
                  p: e,
                  m: r
              });
              if (this.filterManager.effectElements[10].p.v === 3) {
                  var a = createNS("mask"),
                      s = createElementID();
                  a.setAttribute("id", s), a.setAttribute("mask-type", "alpha"), a.appendChild(t), this.elem.globalData.defs.appendChild(a);
                  var o = createNS("g");
                  for (o.setAttribute("mask", "url(" + getLocationHref() + "#" + s + ")"); i[0];) o.appendChild(i[0]);
                  this.elem.layerElement.appendChild(o), this.masker = a, t.setAttribute("stroke", "#fff")
              } else if (this.filterManager.effectElements[10].p.v === 1 || this.filterManager.effectElements[10].p.v === 2) {
                  if (this.filterManager.effectElements[10].p.v === 2)
                      for (i = this.elem.layerElement.children || this.elem.layerElement.childNodes; i.length;) this.elem.layerElement.removeChild(i[0]);
                  this.elem.layerElement.appendChild(t), this.elem.layerElement.removeAttribute("mask"), t.setAttribute("stroke", "#fff")
              }
              this.initialized = !0, this.pathMasker = t
          }, SVGStrokeEffect.prototype.renderFrame = function(e) {
              var t;
              this.initialized || this.initialize();
              var r, n, i = this.paths.length;
              for (t = 0; t < i; t += 1)
                  if (this.paths[t].m !== -1 && (r = this.elem.maskManager.viewData[this.paths[t].m], n = this.paths[t].p, (e || this.filterManager._mdf || r.prop._mdf) && n.setAttribute("d", r.lastPath), e || this.filterManager.effectElements[9].p._mdf || this.filterManager.effectElements[4].p._mdf || this.filterManager.effectElements[7].p._mdf || this.filterManager.effectElements[8].p._mdf || r.prop._mdf)) {
                      var a;
                      if (this.filterManager.effectElements[7].p.v !== 0 || this.filterManager.effectElements[8].p.v !== 100) {
                          var s = .01 * Math.min(this.filterManager.effectElements[7].p.v, this.filterManager.effectElements[8].p.v),
                              o = .01 * Math.max(this.filterManager.effectElements[7].p.v, this.filterManager.effectElements[8].p.v),
                              l = n.getTotalLength();
                          a = "0 0 0 " + l * s + " ";
                          var f, u = l * (o - s),
                              c = 1 + 2 * this.filterManager.effectElements[4].p.v * this.filterManager.effectElements[9].p.v * .01,
                              v = Math.floor(u / c);
                          for (f = 0; f < v; f += 1) a += "1 " + 2 * this.filterManager.effectElements[4].p.v * this.filterManager.effectElements[9].p.v * .01 + " ";
                          a += "0 " + 10 * l + " 0 0"
                      } else a = "1 " + 2 * this.filterManager.effectElements[4].p.v * this.filterManager.effectElements[9].p.v * .01;
                      n.setAttribute("stroke-dasharray", a)
                  } if ((e || this.filterManager.effectElements[4].p._mdf) && this.pathMasker.setAttribute("stroke-width", 2 * this.filterManager.effectElements[4].p.v), (e || this.filterManager.effectElements[6].p._mdf) && this.pathMasker.setAttribute("opacity", this.filterManager.effectElements[6].p.v), (this.filterManager.effectElements[10].p.v === 1 || this.filterManager.effectElements[10].p.v === 2) && (e || this.filterManager.effectElements[3].p._mdf)) {
                  var d = this.filterManager.effectElements[3].p.v;
                  this.pathMasker.setAttribute("stroke", "rgb(" + bmFloor(255 * d[0]) + "," + bmFloor(255 * d[1]) + "," + bmFloor(255 * d[2]) + ")")
              }
          }, SVGTritoneFilter.prototype.renderFrame = function(e) {
              if (e || this.filterManager._mdf) {
                  var t = this.filterManager.effectElements[0].p.v,
                      r = this.filterManager.effectElements[1].p.v,
                      n = this.filterManager.effectElements[2].p.v,
                      i = n[0] + " " + r[0] + " " + t[0],
                      a = n[1] + " " + r[1] + " " + t[1],
                      s = n[2] + " " + r[2] + " " + t[2];
                  this.feFuncR.setAttribute("tableValues", i), this.feFuncG.setAttribute("tableValues", a), this.feFuncB.setAttribute("tableValues", s)
              }
          }, SVGProLevelsFilter.prototype.createFeFunc = function(e, t) {
              var r = createNS(e);
              return r.setAttribute("type", "table"), t.appendChild(r), r
          }, SVGProLevelsFilter.prototype.getTableValue = function(e, t, r, n, i) {
              for (var a, s, o = 0, l = Math.min(e, t), f = Math.max(e, t), u = Array.call(null, {
                      length: 256
                  }), c = 0, v = i - n, d = t - e; o <= 256;) s = (a = o / 256) <= l ? d < 0 ? i : n : a >= f ? d < 0 ? n : i : n + v * Math.pow((a - e) / d, 1 / r), u[c] = s, c += 1, o += 256 / 255;
              return u.join(" ")
          }, SVGProLevelsFilter.prototype.renderFrame = function(e) {
              if (e || this.filterManager._mdf) {
                  var t, r = this.filterManager.effectElements;
                  this.feFuncRComposed && (e || r[3].p._mdf || r[4].p._mdf || r[5].p._mdf || r[6].p._mdf || r[7].p._mdf) && (t = this.getTableValue(r[3].p.v, r[4].p.v, r[5].p.v, r[6].p.v, r[7].p.v), this.feFuncRComposed.setAttribute("tableValues", t), this.feFuncGComposed.setAttribute("tableValues", t), this.feFuncBComposed.setAttribute("tableValues", t)), this.feFuncR && (e || r[10].p._mdf || r[11].p._mdf || r[12].p._mdf || r[13].p._mdf || r[14].p._mdf) && (t = this.getTableValue(r[10].p.v, r[11].p.v, r[12].p.v, r[13].p.v, r[14].p.v), this.feFuncR.setAttribute("tableValues", t)), this.feFuncG && (e || r[17].p._mdf || r[18].p._mdf || r[19].p._mdf || r[20].p._mdf || r[21].p._mdf) && (t = this.getTableValue(r[17].p.v, r[18].p.v, r[19].p.v, r[20].p.v, r[21].p.v), this.feFuncG.setAttribute("tableValues", t)), this.feFuncB && (e || r[24].p._mdf || r[25].p._mdf || r[26].p._mdf || r[27].p._mdf || r[28].p._mdf) && (t = this.getTableValue(r[24].p.v, r[25].p.v, r[26].p.v, r[27].p.v, r[28].p.v), this.feFuncB.setAttribute("tableValues", t)), this.feFuncA && (e || r[31].p._mdf || r[32].p._mdf || r[33].p._mdf || r[34].p._mdf || r[35].p._mdf) && (t = this.getTableValue(r[31].p.v, r[32].p.v, r[33].p.v, r[34].p.v, r[35].p.v), this.feFuncA.setAttribute("tableValues", t))
              }
          }, extendPrototype([SVGComposableEffect], SVGDropShadowEffect), SVGDropShadowEffect.prototype.renderFrame = function(e) {
              if (e || this.filterManager._mdf) {
                  if ((e || this.filterManager.effectElements[4].p._mdf) && this.feGaussianBlur.setAttribute("stdDeviation", this.filterManager.effectElements[4].p.v / 4), e || this.filterManager.effectElements[0].p._mdf) {
                      var t = this.filterManager.effectElements[0].p.v;
                      this.feFlood.setAttribute("flood-color", rgbToHex(Math.round(255 * t[0]), Math.round(255 * t[1]), Math.round(255 * t[2])))
                  }
                  if ((e || this.filterManager.effectElements[1].p._mdf) && this.feFlood.setAttribute("flood-opacity", this.filterManager.effectElements[1].p.v / 255), e || this.filterManager.effectElements[2].p._mdf || this.filterManager.effectElements[3].p._mdf) {
                      var r = this.filterManager.effectElements[3].p.v,
                          n = (this.filterManager.effectElements[2].p.v - 90) * degToRads,
                          i = r * Math.cos(n),
                          a = r * Math.sin(n);
                      this.feOffset.setAttribute("dx", i), this.feOffset.setAttribute("dy", a)
                  }
              }
          };
          var _svgMatteSymbols = [];

          function SVGMatte3Effect(e, t, r) {
              this.initialized = !1, this.filterManager = t, this.filterElem = e, this.elem = r, r.matteElement = createNS("g"), r.matteElement.appendChild(r.layerElement), r.matteElement.appendChild(r.transformedElement), r.baseElement = r.matteElement
          }

          function SVGGaussianBlurEffect(e, t, r, n) {
              e.setAttribute("x", "-100%"), e.setAttribute("y", "-100%"), e.setAttribute("width", "300%"), e.setAttribute("height", "300%"), this.filterManager = t;
              var i = createNS("feGaussianBlur");
              i.setAttribute("result", n), e.appendChild(i), this.feGaussianBlur = i
          }

          function TransformEffect() {}

          function SVGTransformEffect(e, t) {
              this.init(t)
          }

          function CVTransformEffect(e) {
              this.init(e)
          }
          return SVGMatte3Effect.prototype.findSymbol = function(e) {
              for (var t = 0, r = _svgMatteSymbols.length; t < r;) {
                  if (_svgMatteSymbols[t] === e) return _svgMatteSymbols[t];
                  t += 1
              }
              return null
          }, SVGMatte3Effect.prototype.replaceInParent = function(e, t) {
              var r = e.layerElement.parentNode;
              if (r) {
                  for (var n, i = r.children, a = 0, s = i.length; a < s && i[a] !== e.layerElement;) a += 1;
                  a <= s - 2 && (n = i[a + 1]);
                  var o = createNS("use");
                  o.setAttribute("href", "#" + t), n ? r.insertBefore(o, n) : r.appendChild(o)
              }
          }, SVGMatte3Effect.prototype.setElementAsMask = function(e, t) {
              if (!this.findSymbol(t)) {
                  var r = createElementID(),
                      n = createNS("mask");
                  n.setAttribute("id", t.layerId), n.setAttribute("mask-type", "alpha"), _svgMatteSymbols.push(t);
                  var i = e.globalData.defs;
                  i.appendChild(n);
                  var a = createNS("symbol");
                  a.setAttribute("id", r), this.replaceInParent(t, r), a.appendChild(t.layerElement), i.appendChild(a);
                  var s = createNS("use");
                  s.setAttribute("href", "#" + r), n.appendChild(s), t.data.hd = !1, t.show()
              }
              e.setMatte(t.layerId)
          }, SVGMatte3Effect.prototype.initialize = function() {
              for (var e = this.filterManager.effectElements[0].p.v, t = this.elem.comp.elements, r = 0, n = t.length; r < n;) t[r] && t[r].data.ind === e && this.setElementAsMask(this.elem, t[r]), r += 1;
              this.initialized = !0
          }, SVGMatte3Effect.prototype.renderFrame = function() {
              this.initialized || this.initialize()
          }, SVGGaussianBlurEffect.prototype.renderFrame = function(e) {
              if (e || this.filterManager._mdf) {
                  var t = .3 * this.filterManager.effectElements[0].p.v,
                      r = this.filterManager.effectElements[1].p.v,
                      n = r == 3 ? 0 : t,
                      i = r == 2 ? 0 : t;
                  this.feGaussianBlur.setAttribute("stdDeviation", n + " " + i);
                  var a = this.filterManager.effectElements[2].p.v == 1 ? "wrap" : "duplicate";
                  this.feGaussianBlur.setAttribute("edgeMode", a)
              }
          }, TransformEffect.prototype.init = function(e) {
              this.effectsManager = e, this.type = effectTypes.TRANSFORM_EFFECT, this.matrix = new Matrix, this.opacity = -1, this._mdf = !1, this._opMdf = !1
          }, TransformEffect.prototype.renderFrame = function(e) {
              if (this._opMdf = !1, this._mdf = !1, e || this.effectsManager._mdf) {
                  var t = this.effectsManager.effectElements,
                      r = t[0].p.v,
                      n = t[1].p.v,
                      i = t[2].p.v === 1,
                      a = t[3].p.v,
                      s = i ? a : t[4].p.v,
                      o = t[5].p.v,
                      l = t[6].p.v,
                      f = t[7].p.v;
                  this.matrix.reset(), this.matrix.translate(-r[0], -r[1], r[2]), this.matrix.scale(.01 * s, .01 * a, 1), this.matrix.rotate(-f * degToRads), this.matrix.skewFromAxis(-o * degToRads, (l + 90) * degToRads), this.matrix.translate(n[0], n[1], 0), this._mdf = !0, this.opacity !== t[8].p.v && (this.opacity = t[8].p.v, this._opMdf = !0)
              }
          }, extendPrototype([TransformEffect], SVGTransformEffect), extendPrototype([TransformEffect], CVTransformEffect), registerRenderer("canvas", CanvasRenderer), registerRenderer("html", HybridRenderer), registerRenderer("svg", SVGRenderer), ShapeModifiers.registerModifier("tm", TrimModifier), ShapeModifiers.registerModifier("pb", PuckerAndBloatModifier), ShapeModifiers.registerModifier("rp", RepeaterModifier), ShapeModifiers.registerModifier("rd", RoundCornersModifier), ShapeModifiers.registerModifier("zz", ZigZagModifier), ShapeModifiers.registerModifier("op", OffsetPathModifier), setExpressionsPlugin(Expressions), setExpressionInterfaces(getInterface), initialize$1(), initialize(), registerEffect$1(20, SVGTintFilter, !0), registerEffect$1(21, SVGFillFilter, !0), registerEffect$1(22, SVGStrokeEffect, !1), registerEffect$1(23, SVGTritoneFilter, !0), registerEffect$1(24, SVGProLevelsFilter, !0), registerEffect$1(25, SVGDropShadowEffect, !0), registerEffect$1(28, SVGMatte3Effect, !1), registerEffect$1(29, SVGGaussianBlurEffect, !0), registerEffect$1(35, SVGTransformEffect, !1), registerEffect(35, CVTransformEffect), lottie
      })
  });
  var Y_ = E((Sle, K_) => {
      var fU = Xe(),
          xi = X_(),
          pU = $_();
      fU.define("lottie", K_.exports = function() {
          return {
              lottie: pU,
              createInstance: xi.createInstance,
              cleanupElement: xi.cleanupElement,
              init: xi.init,
              destroy: xi.destroy,
              ready: xi.ready
          }
      })
  });
  var Q_ = E(() => {
      (function() {
          if (typeof window > "u") return;
          let e = window.navigator.userAgent.match(/Edge\/(\d{2})\./),
              t = e ? parseInt(e[1], 10) >= 16 : !1;
          if ("objectFit" in document.documentElement.style && !t) {
              window.objectFitPolyfill = function() {
                  return !1
              };
              return
          }
          let n = function(o) {
                  let l = window.getComputedStyle(o, null),
                      f = l.getPropertyValue("position"),
                      u = l.getPropertyValue("overflow"),
                      c = l.getPropertyValue("display");
                  (!f || f === "static") && (o.style.position = "relative"), u !== "hidden" && (o.style.overflow = "hidden"), (!c || c === "inline") && (o.style.display = "block"), o.clientHeight === 0 && (o.style.height = "100%"), o.className.indexOf("object-fit-polyfill") === -1 && (o.className += " object-fit-polyfill")
              },
              i = function(o) {
                  let l = window.getComputedStyle(o, null),
                      f = {
                          "max-width": "none",
                          "max-height": "none",
                          "min-width": "0px",
                          "min-height": "0px",
                          top: "auto",
                          right: "auto",
                          bottom: "auto",
                          left: "auto",
                          "margin-top": "0px",
                          "margin-right": "0px",
                          "margin-bottom": "0px",
                          "margin-left": "0px"
                      };
                  for (let u in f) l.getPropertyValue(u) !== f[u] && (o.style[u] = f[u])
              },
              a = function(o) {
                  let l = o.parentNode;
                  n(l), i(o), o.style.position = "absolute", o.style.height = "100%", o.style.width = "auto", o.clientWidth > l.clientWidth ? (o.style.top = "0", o.style.marginTop = "0", o.style.left = "50%", o.style.marginLeft = o.clientWidth / -2 + "px") : (o.style.width = "100%", o.style.height = "auto", o.style.left = "0", o.style.marginLeft = "0", o.style.top = "50%", o.style.marginTop = o.clientHeight / -2 + "px")
              },
              s = function(o) {
                  if (typeof o > "u" || o instanceof Event) o = document.querySelectorAll("[data-object-fit]");
                  else if (o && o.nodeName) o = [o];
                  else if (typeof o == "object" && o.length && o[0].nodeName) o = o;
                  else return !1;
                  for (let l = 0; l < o.length; l++) {
                      if (!o[l].nodeName) continue;
                      let f = o[l].nodeName.toLowerCase();
                      if (f === "img") {
                          if (t) continue;
                          o[l].complete ? a(o[l]) : o[l].addEventListener("load", function() {
                              a(this)
                          })
                      } else f === "video" ? o[l].readyState > 0 ? a(o[l]) : o[l].addEventListener("loadedmetadata", function() {
                          a(this)
                      }) : a(o[l])
                  }
                  return !0
              };
          document.readyState === "loading" ? document.addEventListener("DOMContentLoaded", s) : s(), window.addEventListener("resize", s), window.objectFitPolyfill = s
      })()
  });
  var Z_ = E(() => {
      (function() {
          if (typeof window > "u") return;

          function e(n) {
              Webflow.env("design") || ($("video")
                  .each(function() {
                      n && $(this)
                          .prop("autoplay") ? this.play() : this.pause()
                  }), $(".w-background-video--control")
                  .each(function() {
                      n ? r($(this)) : t($(this))
                  }))
          }

          function t(n) {
              n.find("> span")
                  .each(function(i) {
                      $(this)
                          .prop("hidden", () => i === 0)
                  })
          }

          function r(n) {
              n.find("> span")
                  .each(function(i) {
                      $(this)
                          .prop("hidden", () => i === 1)
                  })
          }
          $(document)
              .ready(() => {
                  let n = window.matchMedia("(prefers-reduced-motion: reduce)");
                  n.addEventListener("change", i => {
                          e(!i.matches)
                      }), n.matches && e(!1), $("video:not([autoplay])")
                      .each(function() {
                          $(this)
                              .parent()
                              .find(".w-background-video--control")
                              .each(function() {
                                  t($(this))
                              })
                      }), $(document)
                      .on("click", ".w-background-video--control", function(i) {
                          if (Webflow.env("design")) return;
                          let a = $(i.currentTarget),
                              s = $(`video#${a.attr("aria-controls")}`)
                              .get(0);
                          if (s)
                              if (s.paused) {
                                  let o = s.play();
                                  r(a), o && typeof o.catch == "function" && o.catch(() => {
                                      t(a)
                                  })
                              } else s.pause(), t(a)
                      })
              })
      })()
  });
  var tS = E((Ple, eS) => {
      var J_ = Xe();
      J_.define("brand", eS.exports = function(e) {
          var t = {},
              r = document,
              n = e("html"),
              i = e("body"),
              a = ".w-webflow-badge",
              s = window.location,
              o = /PhantomJS/i.test(navigator.userAgent),
              l = "fullscreenchange webkitfullscreenchange mozfullscreenchange msfullscreenchange",
              f;
          t.ready = function() {
              var d = n.attr("data-wf-status"),
                  p = n.attr("data-wf-domain") || "";
              /\.webflow\.io$/i.test(p) && s.hostname !== p && (d = !0), d && !o && (f = f || c(), v(), setTimeout(v, 500), e(r)
                  .off(l, u)
                  .on(l, u))
          };

          function u() {
              var d = r.fullScreen || r.mozFullScreen || r.webkitIsFullScreen || r.msFullscreenElement || !!r.webkitFullscreenElement;
              e(f)
                  .attr("style", d ? "display: none !important;" : "")
          }

          function c() {
              var d = e('<a class="w-webflow-badge"></a>')
                  .attr("href", "https://webflow.com?utm_campaign=brandjs"),
                  p = e("<img>")
                  .attr("src", "https://d3e54v103j8qbb.cloudfront.net/img/webflow-badge-icon.f67cd735e3.svg")
                  .attr("alt", "")
                  .css({
                      marginRight: "8px",
                      width: "16px"
                  }),
                  m = e("<img>")
                  .attr("src", "https://d1otoma47x30pg.cloudfront.net/img/webflow-badge-text.6faa6a38cd.svg")
                  .attr("alt", "Made in Webflow");
              return d.append(p, m), d[0]
          }

          function v() {
              var d = i.children(a),
                  p = d.length && d.get(0) === f,
                  m = J_.env("editor");
              if (p) {
                  m && d.remove();
                  return
              }
              d.length && d.remove(), m || i.append(f)
          }
          return t
      })
  });
  var nS = E((Cle, rS) => {
      var ju = Xe();
      ju.define("edit", rS.exports = function(e, t, r) {
          if (r = r || {}, (ju.env("test") || ju.env("frame")) && !r.fixture && !dU()) return {
              exit: 1
          };
          var n = {},
              i = e(window),
              a = e(document.documentElement),
              s = document.location,
              o = "hashchange",
              l, f = r.load || v,
              u = !1;
          try {
              u = localStorage && localStorage.getItem && localStorage.getItem("WebflowEditor")
          } catch {}
          u ? f() : s.search ? (/[?&](edit)(?:[=&?]|$)/.test(s.search) || /\?edit$/.test(s.href)) && f() : i.on(o, c)
              .triggerHandler(o);

          function c() {
              l || /\?edit/.test(s.hash) && f()
          }

          function v() {
              l = !0, window.WebflowEditor = !0, i.off(o, c), y(function(_) {
                  e.ajax({
                      url: g("https://editor-api.webflow.com/api/editor/view"),
                      data: {
                          siteId: a.attr("data-wf-site")
                      },
                      xhrFields: {
                          withCredentials: !0
                      },
                      dataType: "json",
                      crossDomain: !0,
                      success: d(_)
                  })
              })
          }

          function d(_) {
              return function(I) {
                  if (!I) {
                      console.error("Could not load editor data");
                      return
                  }
                  I.thirdPartyCookiesSupported = _, p(h(I.bugReporterScriptPath), function() {
                      p(h(I.scriptPath), function() {
                          window.WebflowEditor(I)
                      })
                  })
              }
          }

          function p(_, I) {
              e.ajax({
                      type: "GET",
                      url: _,
                      dataType: "script",
                      cache: !0
                  })
                  .then(I, m)
          }

          function m(_, I, C) {
              throw console.error("Could not load editor script: " + I), C
          }

          function h(_) {
              return _.indexOf("//") >= 0 ? _ : g("https://editor-api.webflow.com" + _)
          }

          function g(_) {
              return _.replace(/([^:])\/\//g, "$1/")
          }

          function y(_) {
              var I = window.document.createElement("iframe");
              I.src = "https://webflow.com/site/third-party-cookie-check.html", I.style.display = "none", I.sandbox = "allow-scripts allow-same-origin";
              var C = function(x) {
                  x.data === "WF_third_party_cookies_unsupported" ? (b(I, C), _(!1)) : x.data === "WF_third_party_cookies_supported" && (b(I, C), _(!0))
              };
              I.onerror = function() {
                  b(I, C), _(!1)
              }, window.addEventListener("message", C, !1), window.document.body.appendChild(I)
          }

          function b(_, I) {
              window.removeEventListener("message", I, !1), _.remove()
          }
          return n
      });

      function dU() {
          try {
              return window.top.__Cypress__
          } catch {
              return !1
          }
      }
  });
  var aS = E((wle, iS) => {
      var mU = Xe();
      mU.define("focus-visible", iS.exports = function() {
          function e(r) {
              var n = !0,
                  i = !1,
                  a = null,
                  s = {
                      text: !0,
                      search: !0,
                      url: !0,
                      tel: !0,
                      email: !0,
                      password: !0,
                      number: !0,
                      date: !0,
                      month: !0,
                      week: !0,
                      time: !0,
                      datetime: !0,
                      "datetime-local": !0
                  };

              function o(b) {
                  return !!(b && b !== document && b.nodeName !== "HTML" && b.nodeName !== "BODY" && "classList" in b && "contains" in b.classList)
              }

              function l(b) {
                  var _ = b.type,
                      I = b.tagName;
                  return !!(I === "INPUT" && s[_] && !b.readOnly || I === "TEXTAREA" && !b.readOnly || b.isContentEditable)
              }

              function f(b) {
                  b.getAttribute("data-wf-focus-visible") || b.setAttribute("data-wf-focus-visible", "true")
              }

              function u(b) {
                  b.getAttribute("data-wf-focus-visible") && b.removeAttribute("data-wf-focus-visible")
              }

              function c(b) {
                  b.metaKey || b.altKey || b.ctrlKey || (o(r.activeElement) && f(r.activeElement), n = !0)
              }

              function v() {
                  n = !1
              }

              function d(b) {
                  o(b.target) && (n || l(b.target)) && f(b.target)
              }

              function p(b) {
                  o(b.target) && b.target.hasAttribute("data-wf-focus-visible") && (i = !0, window.clearTimeout(a), a = window.setTimeout(function() {
                      i = !1
                  }, 100), u(b.target))
              }

              function m() {
                  document.visibilityState === "hidden" && (i && (n = !0), h())
              }

              function h() {
                  document.addEventListener("mousemove", y), document.addEventListener("mousedown", y), document.addEventListener("mouseup", y), document.addEventListener("pointermove", y), document.addEventListener("pointerdown", y), document.addEventListener("pointerup", y), document.addEventListener("touchmove", y), document.addEventListener("touchstart", y), document.addEventListener("touchend", y)
              }

              function g() {
                  document.removeEventListener("mousemove", y), document.removeEventListener("mousedown", y), document.removeEventListener("mouseup", y), document.removeEventListener("pointermove", y), document.removeEventListener("pointerdown", y), document.removeEventListener("pointerup", y), document.removeEventListener("touchmove", y), document.removeEventListener("touchstart", y), document.removeEventListener("touchend", y)
              }

              function y(b) {
                  b.target.nodeName && b.target.nodeName.toLowerCase() === "html" || (n = !1, g())
              }
              document.addEventListener("keydown", c, !0), document.addEventListener("mousedown", v, !0), document.addEventListener("pointerdown", v, !0), document.addEventListener("touchstart", v, !0), document.addEventListener("visibilitychange", m, !0), h(), r.addEventListener("focus", d, !0), r.addEventListener("blur", p, !0)
          }

          function t() {
              if (typeof document < "u") try {
                  document.querySelector(":focus-visible")
              } catch {
                  e(document)
              }
          }
          return {
              ready: t
          }
      })
  });
  var lS = E((Ole, oS) => {
      var sS = Xe();
      sS.define("focus", oS.exports = function() {
          var e = [],
              t = !1;

          function r(s) {
              t && (s.preventDefault(), s.stopPropagation(), s.stopImmediatePropagation(), e.unshift(s))
          }

          function n(s) {
              var o = s.target,
                  l = o.tagName;
              return /^a$/i.test(l) && o.href != null || /^(button|textarea)$/i.test(l) && o.disabled !== !0 || /^input$/i.test(l) && /^(button|reset|submit|radio|checkbox)$/i.test(o.type) && !o.disabled || !/^(button|input|textarea|select|a)$/i.test(l) && !Number.isNaN(Number.parseFloat(o.tabIndex)) || /^audio$/i.test(l) || /^video$/i.test(l) && o.controls === !0
          }

          function i(s) {
              n(s) && (t = !0, setTimeout(() => {
                  for (t = !1, s.target.focus(); e.length > 0;) {
                      var o = e.pop();
                      o.target.dispatchEvent(new MouseEvent(o.type, o))
                  }
              }, 0))
          }

          function a() {
              typeof document < "u" && document.body.hasAttribute("data-wf-focus-within") && sS.env.safari && (document.addEventListener("mousedown", i, !0), document.addEventListener("mouseup", r, !0), document.addEventListener("click", r, !0))
          }
          return {
              ready: a
          }
      })
  });
  var hs = E((Mle, hS) => {
      "use strict";
      var Wu = window.jQuery,
          Vt = {},
          ls = [],
          uS = ".w-ix",
          us = {
              reset: function(e, t) {
                  t.__wf_intro = null
              },
              intro: function(e, t) {
                  t.__wf_intro || (t.__wf_intro = !0, Wu(t)
                      .triggerHandler(Vt.types.INTRO))
              },
              outro: function(e, t) {
                  t.__wf_intro && (t.__wf_intro = null, Wu(t)
                      .triggerHandler(Vt.types.OUTRO))
              }
          };
      Vt.triggers = {};
      Vt.types = {
          INTRO: "w-ix-intro" + uS,
          OUTRO: "w-ix-outro" + uS
      };
      Vt.init = function() {
          for (var e = ls.length, t = 0; t < e; t++) {
              var r = ls[t];
              r[0](0, r[1])
          }
          ls = [], Wu.extend(Vt.triggers, us)
      };
      Vt.async = function() {
          for (var e in us) {
              var t = us[e];
              us.hasOwnProperty(e) && (Vt.triggers[e] = function(r, n) {
                  ls.push([t, n])
              })
          }
      };
      Vt.async();
      hS.exports = Vt
  });
  var fS = E((Rle, cS) => {
      var Ct = Xe(),
          cs = hs();
      Ct.define("ix", cS.exports = function(e, t) {
          var r = {},
              n, i = e(window),
              a = ".w-ix",
              s = e.tram,
              o = Ct.env,
              l = o(),
              f = o.chrome && o.chrome < 35,
              u = "none 0s ease 0s",
              c = e(),
              v = {},
              d = [],
              p = [],
              m = [],
              h, g = 1,
              y = {
                  tabs: ".w-tab-link, .w-tab-pane",
                  dropdown: ".w-dropdown",
                  slider: ".w-slide",
                  navbar: ".w-nav"
              };
          r.init = function(W) {
              setTimeout(function() {
                  b(W)
              }, 1)
          }, r.preview = function() {
              n = !1, g = 100, setTimeout(function() {
                  b(window.__wf_ix)
              }, 1)
          }, r.design = function() {
              n = !0, r.destroy()
          }, r.destroy = function() {
              h = !0, c.each(O), Ct.scroll.off(L), cs.async(), d = [], p = [], m = []
          }, r.ready = function() {
              if (l) return o("design") ? r.design() : r.preview();
              v && h && (h = !1, _())
          }, r.run = q, r.style = l ? F : k;

          function b(W) {
              W && (v = {}, t.each(W, function(S) {
                  v[S.slug] = S.value
              }), _())
          }

          function _() {
              I(), cs.init(), Ct.redraw.up()
          }

          function I() {
              var W = e("[data-ix]");
              W.length && (W.each(O), W.each(C), d.length && (Ct.scroll.on(L), setTimeout(L, 1)), p.length && Ct.load(D), m.length && setTimeout(A, g))
          }

          function C(W, S) {
              var R = e(S),
                  V = R.attr("data-ix"),
                  P = v[V];
              if (P) {
                  var N = P.triggers;
                  N && (r.style(R, P.style), t.each(N, function(B) {
                      var T = {},
                          z = B.type,
                          Q = B.stepsB && B.stepsB.length;

                      function G() {
                          q(B, R, {
                              group: "A"
                          })
                      }

                      function J() {
                          q(B, R, {
                              group: "B"
                          })
                      }
                      if (z === "load") {
                          B.preload && !l ? p.push(G) : m.push(G);
                          return
                      }
                      if (z === "click") {
                          R.on("click" + a, function(fe) {
                              Ct.validClick(fe.currentTarget) && (R.attr("href") === "#" && fe.preventDefault(), q(B, R, {
                                  group: T.clicked ? "B" : "A"
                              }), Q && (T.clicked = !T.clicked))
                          }), c = c.add(R);
                          return
                      }
                      if (z === "hover") {
                          R.on("mouseenter" + a, G), R.on("mouseleave" + a, J), c = c.add(R);
                          return
                      }
                      if (z === "scroll") {
                          d.push({
                              el: R,
                              trigger: B,
                              state: {
                                  active: !1
                              },
                              offsetTop: x(B.offsetTop),
                              offsetBot: x(B.offsetBot)
                          });
                          return
                      }
                      var ae = y[z];
                      if (ae) {
                          var re = R.closest(ae);
                          re.on(cs.types.INTRO, G)
                              .on(cs.types.OUTRO, J), c = c.add(re);
                          return
                      }
                  }))
              }
          }

          function x(W) {
              if (!W) return 0;
              W = String(W);
              var S = parseInt(W, 10);
              return S !== S ? 0 : (W.indexOf("%") > 0 && (S /= 100, S >= 1 && (S = .999)), S)
          }

          function O(W, S) {
              e(S)
                  .off(a)
          }

          function L() {
              for (var W = i.scrollTop(), S = i.height(), R = d.length, V = 0; V < R; V++) {
                  var P = d[V],
                      N = P.el,
                      B = P.trigger,
                      T = B.stepsB && B.stepsB.length,
                      z = P.state,
                      Q = N.offset()
                      .top,
                      G = N.outerHeight(),
                      J = P.offsetTop,
                      ae = P.offsetBot;
                  J < 1 && J > 0 && (J *= S), ae < 1 && ae > 0 && (ae *= S);
                  var re = Q + G - J >= W && Q + ae <= W + S;
                  re !== z.active && (re === !1 && !T || (z.active = re, q(B, N, {
                      group: re ? "A" : "B"
                  })))
              }
          }

          function D() {
              for (var W = p.length, S = 0; S < W; S++) p[S]()
          }

          function A() {
              for (var W = m.length, S = 0; S < W; S++) m[S]()
          }

          function q(W, S, R, V) {
              R = R || {};
              var P = R.done,
                  N = W.preserve3d;
              if (n && !R.force) return;
              var B = R.group || "A",
                  T = W["loop" + B],
                  z = W["steps" + B];
              if (!z || !z.length) return;
              if (z.length < 2 && (T = !1), !V) {
                  var Q = W.selector;
                  Q && (W.descend ? S = S.find(Q) : W.siblings ? S = S.siblings(Q) : S = e(Q), l && S.attr("data-ix-affect", 1)), f && S.addClass("w-ix-emptyfix"), N && S.css("transform-style", "preserve-3d")
              }
              for (var G = s(S), J = {
                      omit3d: !N
                  }, ae = 0; ae < z.length; ae++) w(G, z[ae], J);

              function re() {
                  if (T) return q(W, S, R, !0);
                  J.width === "auto" && G.set({
                      width: "auto"
                  }), J.height === "auto" && G.set({
                      height: "auto"
                  }), P && P()
              }
              J.start ? G.then(re) : re()
          }

          function w(W, S, R) {
              var V = "add",
                  P = "start";
              R.start && (V = P = "then");
              var N = S.transition;
              if (N) {
                  N = N.split(",");
                  for (var B = 0; B < N.length; B++) {
                      var T = N[B];
                      W[V](T)
                  }
              }
              var z = U(S, R) || {};
              if (z.width != null && (R.width = z.width), z.height != null && (R.height = z.height), N == null) {
                  R.start ? W.then(function() {
                      var J = this.queue;
                      this.set(z), z.display && (W.redraw(), Ct.redraw.up()), this.queue = J, this.next()
                  }) : (W.set(z), z.display && (W.redraw(), Ct.redraw.up()));
                  var Q = z.wait;
                  Q != null && (W.wait(Q), R.start = !0)
              } else {
                  if (z.display) {
                      var G = z.display;
                      delete z.display, R.start ? W.then(function() {
                          var J = this.queue;
                          this.set({
                                  display: G
                              })
                              .redraw(), Ct.redraw.up(), this.queue = J, this.next()
                      }) : (W.set({
                              display: G
                          })
                          .redraw(), Ct.redraw.up())
                  }
                  W[P](z), R.start = !0
              }
          }

          function F(W, S) {
              var R = s(W);
              if (!e.isEmptyObject(S)) {
                  W.css("transition", "");
                  var V = W.css("transition");
                  V === u && (V = R.upstream = null), R.upstream = u, R.set(U(S)), R.upstream = V
              }
          }

          function k(W, S) {
              s(W)
                  .set(U(S))
          }

          function U(W, S) {
              var R = S && S.omit3d,
                  V = {},
                  P = !1;
              for (var N in W) N !== "transition" && N !== "keysort" && (R && (N === "z" || N === "rotateX" || N === "rotateY" || N === "scaleZ") || (V[N] = W[N], P = !0));
              return P ? V : null
          }
          return r
      })
  });
  var Ai = E((Dle, mS) => {
      "use strict";
      var Uu = hs();

      function pS(e, t) {
          var r = document.createEvent("CustomEvent");
          r.initCustomEvent(t, !0, !0, null), e.dispatchEvent(r)
      }
      var vU = window.jQuery,
          fs = {},
          dS = ".w-ix",
          gU = {
              reset: function(e, t) {
                  Uu.triggers.reset(e, t)
              },
              intro: function(e, t) {
                  Uu.triggers.intro(e, t), pS(t, "COMPONENT_ACTIVE")
              },
              outro: function(e, t) {
                  Uu.triggers.outro(e, t), pS(t, "COMPONENT_INACTIVE")
              }
          };
      fs.triggers = {};
      fs.types = {
          INTRO: "w-ix-intro" + dS,
          OUTRO: "w-ix-outro" + dS
      };
      vU.extend(fs.triggers, gU);
      mS.exports = fs
  });
  var vS = E((Fle, rr) => {
      function Xu(e) {
          return rr.exports = Xu = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
              return typeof t
          } : function(t) {
              return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
          }, rr.exports.__esModule = !0, rr.exports.default = rr.exports, Xu(e)
      }
      rr.exports = Xu, rr.exports.__esModule = !0, rr.exports.default = rr.exports
  });
  var Vr = E((qle, Pi) => {
      var yU = vS()
          .default;

      function gS(e) {
          if (typeof WeakMap != "function") return null;
          var t = new WeakMap,
              r = new WeakMap;
          return (gS = function(i) {
              return i ? r : t
          })(e)
      }

      function EU(e, t) {
          if (!t && e && e.__esModule) return e;
          if (e === null || yU(e) !== "object" && typeof e != "function") return {
              default: e
          };
          var r = gS(t);
          if (r && r.has(e)) return r.get(e);
          var n = {},
              i = Object.defineProperty && Object.getOwnPropertyDescriptor;
          for (var a in e)
              if (a !== "default" && Object.prototype.hasOwnProperty.call(e, a)) {
                  var s = i ? Object.getOwnPropertyDescriptor(e, a) : null;
                  s && (s.get || s.set) ? Object.defineProperty(n, a, s) : n[a] = e[a]
              } return n.default = e, r && r.set(e, n), n
      }
      Pi.exports = EU, Pi.exports.__esModule = !0, Pi.exports.default = Pi.exports
  });
  var ES = E((Lle, yS) => {
      var bU = oe(),
          _U = Te();
      yS.exports = function(e, t) {
          return _U(bU[e].prototype[t])
      }
  });
  var _S = E((kle, bS) => {
      Rl();
      var SU = ES();
      bS.exports = SU("Array", "includes")
  });
  var IS = E((Nle, SS) => {
      var IU = _S();
      SS.exports = IU
  });
  var xS = E((Ble, TS) => {
      var TU = IS();
      TS.exports = TU
  });
  var $u = E((Vle, AS) => {
      var xU = Co(),
          AU = xU(Object.getPrototypeOf, Object);
      AS.exports = AU
  });
  var Ku = E((Gle, CS) => {
      var PU = sr(),
          CU = $u(),
          wU = $t(),
          OU = "[object Object]",
          MU = Function.prototype,
          RU = Object.prototype,
          PS = MU.toString,
          DU = RU.hasOwnProperty,
          FU = PS.call(Object);

      function qU(e) {
          if (!wU(e) || PU(e) != OU) return !1;
          var t = CU(e);
          if (t === null) return !0;
          var r = DU.call(t, "constructor") && t.constructor;
          return typeof r == "function" && r instanceof r && PS.call(r) == FU
      }
      CS.exports = qU
  });
  var wS = E(Yu => {
      "use strict";
      Object.defineProperty(Yu, "__esModule", {
          value: !0
      });
      Yu.default = LU;

      function LU(e) {
          var t, r = e.Symbol;
          return typeof r == "function" ? r.observable ? t = r.observable : (t = r("observable"), r.observable = t) : t = "@@observable", t
      }
  });
  var OS = E((Zu, Qu) => {
      "use strict";
      Object.defineProperty(Zu, "__esModule", {
          value: !0
      });
      var kU = wS(),
          NU = BU(kU);

      function BU(e) {
          return e && e.__esModule ? e : {
              default: e
          }
      }
      var bn;
      typeof self < "u" ? bn = self : typeof window < "u" ? bn = window : typeof global < "u" ? bn = global : typeof Qu < "u" ? bn = Qu : bn = Function("return this")();
      var VU = (0, NU.default)(bn);
      Zu.default = VU
  });
  var Ju = E(Ci => {
      "use strict";
      Ci.__esModule = !0;
      Ci.ActionTypes = void 0;
      Ci.default = FS;
      var GU = Ku(),
          zU = DS(GU),
          HU = OS(),
          MS = DS(HU);

      function DS(e) {
          return e && e.__esModule ? e : {
              default: e
          }
      }
      var RS = Ci.ActionTypes = {
          INIT: "@@redux/INIT"
      };

      function FS(e, t, r) {
          var n;
          if (typeof t == "function" && typeof r > "u" && (r = t, t = void 0), typeof r < "u") {
              if (typeof r != "function") throw new Error("Expected the enhancer to be a function.");
              return r(FS)(e, t)
          }
          if (typeof e != "function") throw new Error("Expected the reducer to be a function.");
          var i = e,
              a = t,
              s = [],
              o = s,
              l = !1;

          function f() {
              o === s && (o = s.slice())
          }

          function u() {
              return a
          }

          function c(m) {
              if (typeof m != "function") throw new Error("Expected listener to be a function.");
              var h = !0;
              return f(), o.push(m),
                  function() {
                      if (h) {
                          h = !1, f();
                          var y = o.indexOf(m);
                          o.splice(y, 1)
                      }
                  }
          }

          function v(m) {
              if (!(0, zU.default)(m)) throw new Error("Actions must be plain objects. Use custom middleware for async actions.");
              if (typeof m.type > "u") throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?');
              if (l) throw new Error("Reducers may not dispatch actions.");
              try {
                  l = !0, a = i(a, m)
              } finally {
                  l = !1
              }
              for (var h = s = o, g = 0; g < h.length; g++) h[g]();
              return m
          }

          function d(m) {
              if (typeof m != "function") throw new Error("Expected the nextReducer to be a function.");
              i = m, v({
                  type: RS.INIT
              })
          }

          function p() {
              var m, h = c;
              return m = {
                  subscribe: function(y) {
                      if (typeof y != "object") throw new TypeError("Expected the observer to be an object.");

                      function b() {
                          y.next && y.next(u())
                      }
                      b();
                      var _ = h(b);
                      return {
                          unsubscribe: _
                      }
                  }
              }, m[MS.default] = function() {
                  return this
              }, m
          }
          return v({
              type: RS.INIT
          }), n = {
              dispatch: v,
              subscribe: c,
              getState: u,
              replaceReducer: d
          }, n[MS.default] = p, n
      }
  });
  var th = E(eh => {
      "use strict";
      eh.__esModule = !0;
      eh.default = jU;

      function jU(e) {
          typeof console < "u" && typeof console.error == "function" && console.error(e);
          try {
              throw new Error(e)
          } catch {}
      }
  });
  var kS = E(rh => {
      "use strict";
      rh.__esModule = !0;
      rh.default = KU;
      var qS = Ju(),
          WU = Ku(),
          Wle = LS(WU),
          UU = th(),
          Ule = LS(UU);

      function LS(e) {
          return e && e.__esModule ? e : {
              default: e
          }
      }

      function XU(e, t) {
          var r = t && t.type,
              n = r && '"' + r.toString() + '"' || "an action";
          return "Given action " + n + ', reducer "' + e + '" returned undefined. To ignore an action, you must explicitly return the previous state.'
      }

      function $U(e) {
          Object.keys(e)
              .forEach(function(t) {
                  var r = e[t],
                      n = r(void 0, {
                          type: qS.ActionTypes.INIT
                      });
                  if (typeof n > "u") throw new Error('Reducer "' + t + '" returned undefined during initialization. If the state passed to the reducer is undefined, you must explicitly return the initial state. The initial state may not be undefined.');
                  var i = "@@redux/PROBE_UNKNOWN_ACTION_" + Math.random()
                      .toString(36)
                      .substring(7)
                      .split("")
                      .join(".");
                  if (typeof r(void 0, {
                          type: i
                      }) > "u") throw new Error('Reducer "' + t + '" returned undefined when probed with a random type. ' + ("Don't try to handle " + qS.ActionTypes.INIT + ' or other actions in "redux/*" ') + "namespace. They are considered private. Instead, you must return the current state for any unknown actions, unless it is undefined, in which case you must return the initial state, regardless of the action type. The initial state may not be undefined.")
              })
      }

      function KU(e) {
          for (var t = Object.keys(e), r = {}, n = 0; n < t.length; n++) {
              var i = t[n];
              typeof e[i] == "function" && (r[i] = e[i])
          }
          var a = Object.keys(r);
          if (!1) var s;
          var o;
          try {
              $U(r)
          } catch (l) {
              o = l
          }
          return function() {
              var f = arguments.length <= 0 || arguments[0] === void 0 ? {} : arguments[0],
                  u = arguments[1];
              if (o) throw o;
              if (!1) var c;
              for (var v = !1, d = {}, p = 0; p < a.length; p++) {
                  var m = a[p],
                      h = r[m],
                      g = f[m],
                      y = h(g, u);
                  if (typeof y > "u") {
                      var b = XU(m, u);
                      throw new Error(b)
                  }
                  d[m] = y, v = v || y !== g
              }
              return v ? d : f
          }
      }
  });
  var BS = E(nh => {
      "use strict";
      nh.__esModule = !0;
      nh.default = YU;

      function NS(e, t) {
          return function() {
              return t(e.apply(void 0, arguments))
          }
      }

      function YU(e, t) {
          if (typeof e == "function") return NS(e, t);
          if (typeof e != "object" || e === null) throw new Error("bindActionCreators expected an object or a function, instead received " + (e === null ? "null" : typeof e) + '. Did you write "import ActionCreators from" instead of "import * as ActionCreators from"?');
          for (var r = Object.keys(e), n = {}, i = 0; i < r.length; i++) {
              var a = r[i],
                  s = e[a];
              typeof s == "function" && (n[a] = NS(s, t))
          }
          return n
      }
  });
  var ah = E(ih => {
      "use strict";
      ih.__esModule = !0;
      ih.default = QU;

      function QU() {
          for (var e = arguments.length, t = Array(e), r = 0; r < e; r++) t[r] = arguments[r];
          if (t.length === 0) return function(a) {
              return a
          };
          if (t.length === 1) return t[0];
          var n = t[t.length - 1],
              i = t.slice(0, -1);
          return function() {
              return i.reduceRight(function(a, s) {
                  return s(a)
              }, n.apply(void 0, arguments))
          }
      }
  });
  var VS = E(sh => {
      "use strict";
      sh.__esModule = !0;
      var ZU = Object.assign || function(e) {
          for (var t = 1; t < arguments.length; t++) {
              var r = arguments[t];
              for (var n in r) Object.prototype.hasOwnProperty.call(r, n) && (e[n] = r[n])
          }
          return e
      };
      sh.default = rX;
      var JU = ah(),
          eX = tX(JU);

      function tX(e) {
          return e && e.__esModule ? e : {
              default: e
          }
      }

      function rX() {
          for (var e = arguments.length, t = Array(e), r = 0; r < e; r++) t[r] = arguments[r];
          return function(n) {
              return function(i, a, s) {
                  var o = n(i, a, s),
                      l = o.dispatch,
                      f = [],
                      u = {
                          getState: o.getState,
                          dispatch: function(v) {
                              return l(v)
                          }
                      };
                  return f = t.map(function(c) {
                      return c(u)
                  }), l = eX.default.apply(void 0, f)(o.dispatch), ZU({}, o, {
                      dispatch: l
                  })
              }
          }
      }
  });
  var oh = E(gt => {
      "use strict";
      gt.__esModule = !0;
      gt.compose = gt.applyMiddleware = gt.bindActionCreators = gt.combineReducers = gt.createStore = void 0;
      var nX = Ju(),
          iX = _n(nX),
          aX = kS(),
          sX = _n(aX),
          oX = BS(),
          lX = _n(oX),
          uX = VS(),
          hX = _n(uX),
          cX = ah(),
          fX = _n(cX),
          pX = th(),
          Qle = _n(pX);

      function _n(e) {
          return e && e.__esModule ? e : {
              default: e
          }
      }
      gt.createStore = iX.default;
      gt.combineReducers = sX.default;
      gt.bindActionCreators = lX.default;
      gt.applyMiddleware = hX.default;
      gt.compose = fX.default
  });
  var GS = E(He => {
      "use strict";
      Object.defineProperty(He, "__esModule", {
          value: !0
      });
      He.QuickEffectIds = He.QuickEffectDirectionConsts = He.EventTypeConsts = He.EventLimitAffectedElements = He.EventContinuousMouseAxes = He.EventBasedOn = He.EventAppliesTo = void 0;
      var dX = {
          NAVBAR_OPEN: "NAVBAR_OPEN",
          NAVBAR_CLOSE: "NAVBAR_CLOSE",
          TAB_ACTIVE: "TAB_ACTIVE",
          TAB_INACTIVE: "TAB_INACTIVE",
          SLIDER_ACTIVE: "SLIDER_ACTIVE",
          SLIDER_INACTIVE: "SLIDER_INACTIVE",
          DROPDOWN_OPEN: "DROPDOWN_OPEN",
          DROPDOWN_CLOSE: "DROPDOWN_CLOSE",
          MOUSE_CLICK: "MOUSE_CLICK",
          MOUSE_SECOND_CLICK: "MOUSE_SECOND_CLICK",
          MOUSE_DOWN: "MOUSE_DOWN",
          MOUSE_UP: "MOUSE_UP",
          MOUSE_OVER: "MOUSE_OVER",
          MOUSE_OUT: "MOUSE_OUT",
          MOUSE_MOVE: "MOUSE_MOVE",
          MOUSE_MOVE_IN_VIEWPORT: "MOUSE_MOVE_IN_VIEWPORT",
          SCROLL_INTO_VIEW: "SCROLL_INTO_VIEW",
          SCROLL_OUT_OF_VIEW: "SCROLL_OUT_OF_VIEW",
          SCROLLING_IN_VIEW: "SCROLLING_IN_VIEW",
          ECOMMERCE_CART_OPEN: "ECOMMERCE_CART_OPEN",
          ECOMMERCE_CART_CLOSE: "ECOMMERCE_CART_CLOSE",
          PAGE_START: "PAGE_START",
          PAGE_FINISH: "PAGE_FINISH",
          PAGE_SCROLL_UP: "PAGE_SCROLL_UP",
          PAGE_SCROLL_DOWN: "PAGE_SCROLL_DOWN",
          PAGE_SCROLL: "PAGE_SCROLL"
      };
      He.EventTypeConsts = dX;
      var mX = {
          ELEMENT: "ELEMENT",
          CLASS: "CLASS",
          PAGE: "PAGE"
      };
      He.EventAppliesTo = mX;
      var vX = {
          ELEMENT: "ELEMENT",
          VIEWPORT: "VIEWPORT"
      };
      He.EventBasedOn = vX;
      var gX = {
          X_AXIS: "X_AXIS",
          Y_AXIS: "Y_AXIS"
      };
      He.EventContinuousMouseAxes = gX;
      var yX = {
          CHILDREN: "CHILDREN",
          SIBLINGS: "SIBLINGS",
          IMMEDIATE_CHILDREN: "IMMEDIATE_CHILDREN"
      };
      He.EventLimitAffectedElements = yX;
      var EX = {
          FADE_EFFECT: "FADE_EFFECT",
          SLIDE_EFFECT: "SLIDE_EFFECT",
          GROW_EFFECT: "GROW_EFFECT",
          SHRINK_EFFECT: "SHRINK_EFFECT",
          SPIN_EFFECT: "SPIN_EFFECT",
          FLY_EFFECT: "FLY_EFFECT",
          POP_EFFECT: "POP_EFFECT",
          FLIP_EFFECT: "FLIP_EFFECT",
          JIGGLE_EFFECT: "JIGGLE_EFFECT",
          PULSE_EFFECT: "PULSE_EFFECT",
          DROP_EFFECT: "DROP_EFFECT",
          BLINK_EFFECT: "BLINK_EFFECT",
          BOUNCE_EFFECT: "BOUNCE_EFFECT",
          FLIP_LEFT_TO_RIGHT_EFFECT: "FLIP_LEFT_TO_RIGHT_EFFECT",
          FLIP_RIGHT_TO_LEFT_EFFECT: "FLIP_RIGHT_TO_LEFT_EFFECT",
          RUBBER_BAND_EFFECT: "RUBBER_BAND_EFFECT",
          JELLO_EFFECT: "JELLO_EFFECT",
          GROW_BIG_EFFECT: "GROW_BIG_EFFECT",
          SHRINK_BIG_EFFECT: "SHRINK_BIG_EFFECT",
          PLUGIN_LOTTIE_EFFECT: "PLUGIN_LOTTIE_EFFECT"
      };
      He.QuickEffectIds = EX;
      var bX = {
          LEFT: "LEFT",
          RIGHT: "RIGHT",
          BOTTOM: "BOTTOM",
          TOP: "TOP",
          BOTTOM_LEFT: "BOTTOM_LEFT",
          BOTTOM_RIGHT: "BOTTOM_RIGHT",
          TOP_RIGHT: "TOP_RIGHT",
          TOP_LEFT: "TOP_LEFT",
          CLOCKWISE: "CLOCKWISE",
          COUNTER_CLOCKWISE: "COUNTER_CLOCKWISE"
      };
      He.QuickEffectDirectionConsts = bX
  });
  var lh = E(Sn => {
      "use strict";
      Object.defineProperty(Sn, "__esModule", {
          value: !0
      });
      Sn.ActionTypeConsts = Sn.ActionAppliesTo = void 0;
      var _X = {
          TRANSFORM_MOVE: "TRANSFORM_MOVE",
          TRANSFORM_SCALE: "TRANSFORM_SCALE",
          TRANSFORM_ROTATE: "TRANSFORM_ROTATE",
          TRANSFORM_SKEW: "TRANSFORM_SKEW",
          STYLE_OPACITY: "STYLE_OPACITY",
          STYLE_SIZE: "STYLE_SIZE",
          STYLE_FILTER: "STYLE_FILTER",
          STYLE_FONT_VARIATION: "STYLE_FONT_VARIATION",
          STYLE_BACKGROUND_COLOR: "STYLE_BACKGROUND_COLOR",
          STYLE_BORDER: "STYLE_BORDER",
          STYLE_TEXT_COLOR: "STYLE_TEXT_COLOR",
          OBJECT_VALUE: "OBJECT_VALUE",
          PLUGIN_LOTTIE: "PLUGIN_LOTTIE",
          PLUGIN_SPLINE: "PLUGIN_SPLINE",
          PLUGIN_VARIABLE: "PLUGIN_VARIABLE",
          GENERAL_DISPLAY: "GENERAL_DISPLAY",
          GENERAL_START_ACTION: "GENERAL_START_ACTION",
          GENERAL_CONTINUOUS_ACTION: "GENERAL_CONTINUOUS_ACTION",
          GENERAL_COMBO_CLASS: "GENERAL_COMBO_CLASS",
          GENERAL_STOP_ACTION: "GENERAL_STOP_ACTION",
          GENERAL_LOOP: "GENERAL_LOOP",
          STYLE_BOX_SHADOW: "STYLE_BOX_SHADOW"
      };
      Sn.ActionTypeConsts = _X;
      var SX = {
          ELEMENT: "ELEMENT",
          ELEMENT_CLASS: "ELEMENT_CLASS",
          TRIGGER_ELEMENT: "TRIGGER_ELEMENT"
      };
      Sn.ActionAppliesTo = SX
  });
  var zS = E(ps => {
      "use strict";
      Object.defineProperty(ps, "__esModule", {
          value: !0
      });
      ps.InteractionTypeConsts = void 0;
      var IX = {
          MOUSE_CLICK_INTERACTION: "MOUSE_CLICK_INTERACTION",
          MOUSE_HOVER_INTERACTION: "MOUSE_HOVER_INTERACTION",
          MOUSE_MOVE_INTERACTION: "MOUSE_MOVE_INTERACTION",
          SCROLL_INTO_VIEW_INTERACTION: "SCROLL_INTO_VIEW_INTERACTION",
          SCROLLING_IN_VIEW_INTERACTION: "SCROLLING_IN_VIEW_INTERACTION",
          MOUSE_MOVE_IN_VIEWPORT_INTERACTION: "MOUSE_MOVE_IN_VIEWPORT_INTERACTION",
          PAGE_IS_SCROLLING_INTERACTION: "PAGE_IS_SCROLLING_INTERACTION",
          PAGE_LOAD_INTERACTION: "PAGE_LOAD_INTERACTION",
          PAGE_SCROLLED_INTERACTION: "PAGE_SCROLLED_INTERACTION",
          NAVBAR_INTERACTION: "NAVBAR_INTERACTION",
          DROPDOWN_INTERACTION: "DROPDOWN_INTERACTION",
          ECOMMERCE_CART_INTERACTION: "ECOMMERCE_CART_INTERACTION",
          TAB_INTERACTION: "TAB_INTERACTION",
          SLIDER_INTERACTION: "SLIDER_INTERACTION"
      };
      ps.InteractionTypeConsts = IX
  });
  var HS = E(ds => {
      "use strict";
      Object.defineProperty(ds, "__esModule", {
          value: !0
      });
      ds.ReducedMotionTypes = void 0;
      var TX = lh(),
          {
              TRANSFORM_MOVE: xX,
              TRANSFORM_SCALE: AX,
              TRANSFORM_ROTATE: PX,
              TRANSFORM_SKEW: CX,
              STYLE_SIZE: wX,
              STYLE_FILTER: OX,
              STYLE_FONT_VARIATION: MX
          } = TX.ActionTypeConsts,
          RX = {
              [xX]: !0,
              [AX]: !0,
              [PX]: !0,
              [CX]: !0,
              [wX]: !0,
              [OX]: !0,
              [MX]: !0
          };
      ds.ReducedMotionTypes = RX
  });
  var jS = E(he => {
      "use strict";
      Object.defineProperty(he, "__esModule", {
          value: !0
      });
      he.IX2_VIEWPORT_WIDTH_CHANGED = he.IX2_TEST_FRAME_RENDERED = he.IX2_STOP_REQUESTED = he.IX2_SESSION_STOPPED = he.IX2_SESSION_STARTED = he.IX2_SESSION_INITIALIZED = he.IX2_RAW_DATA_IMPORTED = he.IX2_PREVIEW_REQUESTED = he.IX2_PLAYBACK_REQUESTED = he.IX2_PARAMETER_CHANGED = he.IX2_MEDIA_QUERIES_DEFINED = he.IX2_INSTANCE_STARTED = he.IX2_INSTANCE_REMOVED = he.IX2_INSTANCE_ADDED = he.IX2_EVENT_STATE_CHANGED = he.IX2_EVENT_LISTENER_ADDED = he.IX2_ELEMENT_STATE_CHANGED = he.IX2_CLEAR_REQUESTED = he.IX2_ANIMATION_FRAME_CHANGED = he.IX2_ACTION_LIST_PLAYBACK_CHANGED = void 0;
      var DX = "IX2_RAW_DATA_IMPORTED";
      he.IX2_RAW_DATA_IMPORTED = DX;
      var FX = "IX2_SESSION_INITIALIZED";
      he.IX2_SESSION_INITIALIZED = FX;
      var qX = "IX2_SESSION_STARTED";
      he.IX2_SESSION_STARTED = qX;
      var LX = "IX2_SESSION_STOPPED";
      he.IX2_SESSION_STOPPED = LX;
      var kX = "IX2_PREVIEW_REQUESTED";
      he.IX2_PREVIEW_REQUESTED = kX;
      var NX = "IX2_PLAYBACK_REQUESTED";
      he.IX2_PLAYBACK_REQUESTED = NX;
      var BX = "IX2_STOP_REQUESTED";
      he.IX2_STOP_REQUESTED = BX;
      var VX = "IX2_CLEAR_REQUESTED";
      he.IX2_CLEAR_REQUESTED = VX;
      var GX = "IX2_EVENT_LISTENER_ADDED";
      he.IX2_EVENT_LISTENER_ADDED = GX;
      var zX = "IX2_EVENT_STATE_CHANGED";
      he.IX2_EVENT_STATE_CHANGED = zX;
      var HX = "IX2_ANIMATION_FRAME_CHANGED";
      he.IX2_ANIMATION_FRAME_CHANGED = HX;
      var jX = "IX2_PARAMETER_CHANGED";
      he.IX2_PARAMETER_CHANGED = jX;
      var WX = "IX2_INSTANCE_ADDED";
      he.IX2_INSTANCE_ADDED = WX;
      var UX = "IX2_INSTANCE_STARTED";
      he.IX2_INSTANCE_STARTED = UX;
      var XX = "IX2_INSTANCE_REMOVED";
      he.IX2_INSTANCE_REMOVED = XX;
      var $X = "IX2_ELEMENT_STATE_CHANGED";
      he.IX2_ELEMENT_STATE_CHANGED = $X;
      var KX = "IX2_ACTION_LIST_PLAYBACK_CHANGED";
      he.IX2_ACTION_LIST_PLAYBACK_CHANGED = KX;
      var YX = "IX2_VIEWPORT_WIDTH_CHANGED";
      he.IX2_VIEWPORT_WIDTH_CHANGED = YX;
      var QX = "IX2_MEDIA_QUERIES_DEFINED";
      he.IX2_MEDIA_QUERIES_DEFINED = QX;
      var ZX = "IX2_TEST_FRAME_RENDERED";
      he.IX2_TEST_FRAME_RENDERED = ZX
  });
  var WS = E(Z => {
      "use strict";
      Object.defineProperty(Z, "__esModule", {
          value: !0
      });
      Z.W_MOD_JS = Z.W_MOD_IX = Z.WILL_CHANGE = Z.WIDTH = Z.WF_PAGE = Z.TRANSLATE_Z = Z.TRANSLATE_Y = Z.TRANSLATE_X = Z.TRANSLATE_3D = Z.TRANSFORM = Z.SKEW_Y = Z.SKEW_X = Z.SKEW = Z.SIBLINGS = Z.SCALE_Z = Z.SCALE_Y = Z.SCALE_X = Z.SCALE_3D = Z.ROTATE_Z = Z.ROTATE_Y = Z.ROTATE_X = Z.RENDER_TRANSFORM = Z.RENDER_STYLE = Z.RENDER_PLUGIN = Z.RENDER_GENERAL = Z.PRESERVE_3D = Z.PLAIN_OBJECT = Z.PARENT = Z.OPACITY = Z.IX2_ID_DELIMITER = Z.IMMEDIATE_CHILDREN = Z.HTML_ELEMENT = Z.HEIGHT = Z.FONT_VARIATION_SETTINGS = Z.FLEX = Z.FILTER = Z.DISPLAY = Z.CONFIG_Z_VALUE = Z.CONFIG_Z_UNIT = Z.CONFIG_Y_VALUE = Z.CONFIG_Y_UNIT = Z.CONFIG_X_VALUE = Z.CONFIG_X_UNIT = Z.CONFIG_VALUE = Z.CONFIG_UNIT = Z.COMMA_DELIMITER = Z.COLOR = Z.COLON_DELIMITER = Z.CHILDREN = Z.BOUNDARY_SELECTOR = Z.BORDER_COLOR = Z.BAR_DELIMITER = Z.BACKGROUND_COLOR = Z.BACKGROUND = Z.AUTO = Z.ABSTRACT_NODE = void 0;
      var JX = "|";
      Z.IX2_ID_DELIMITER = JX;
      var e4 = "data-wf-page";
      Z.WF_PAGE = e4;
      var t4 = "w-mod-js";
      Z.W_MOD_JS = t4;
      var r4 = "w-mod-ix";
      Z.W_MOD_IX = r4;
      var n4 = ".w-dyn-item";
      Z.BOUNDARY_SELECTOR = n4;
      var i4 = "xValue";
      Z.CONFIG_X_VALUE = i4;
      var a4 = "yValue";
      Z.CONFIG_Y_VALUE = a4;
      var s4 = "zValue";
      Z.CONFIG_Z_VALUE = s4;
      var o4 = "value";
      Z.CONFIG_VALUE = o4;
      var l4 = "xUnit";
      Z.CONFIG_X_UNIT = l4;
      var u4 = "yUnit";
      Z.CONFIG_Y_UNIT = u4;
      var h4 = "zUnit";
      Z.CONFIG_Z_UNIT = h4;
      var c4 = "unit";
      Z.CONFIG_UNIT = c4;
      var f4 = "transform";
      Z.TRANSFORM = f4;
      var p4 = "translateX";
      Z.TRANSLATE_X = p4;
      var d4 = "translateY";
      Z.TRANSLATE_Y = d4;
      var m4 = "translateZ";
      Z.TRANSLATE_Z = m4;
      var v4 = "translate3d";
      Z.TRANSLATE_3D = v4;
      var g4 = "scaleX";
      Z.SCALE_X = g4;
      var y4 = "scaleY";
      Z.SCALE_Y = y4;
      var E4 = "scaleZ";
      Z.SCALE_Z = E4;
      var b4 = "scale3d";
      Z.SCALE_3D = b4;
      var _4 = "rotateX";
      Z.ROTATE_X = _4;
      var S4 = "rotateY";
      Z.ROTATE_Y = S4;
      var I4 = "rotateZ";
      Z.ROTATE_Z = I4;
      var T4 = "skew";
      Z.SKEW = T4;
      var x4 = "skewX";
      Z.SKEW_X = x4;
      var A4 = "skewY";
      Z.SKEW_Y = A4;
      var P4 = "opacity";
      Z.OPACITY = P4;
      var C4 = "filter";
      Z.FILTER = C4;
      var w4 = "font-variation-settings";
      Z.FONT_VARIATION_SETTINGS = w4;
      var O4 = "width";
      Z.WIDTH = O4;
      var M4 = "height";
      Z.HEIGHT = M4;
      var R4 = "backgroundColor";
      Z.BACKGROUND_COLOR = R4;
      var D4 = "background";
      Z.BACKGROUND = D4;
      var F4 = "borderColor";
      Z.BORDER_COLOR = F4;
      var q4 = "color";
      Z.COLOR = q4;
      var L4 = "display";
      Z.DISPLAY = L4;
      var k4 = "flex";
      Z.FLEX = k4;
      var N4 = "willChange";
      Z.WILL_CHANGE = N4;
      var B4 = "AUTO";
      Z.AUTO = B4;
      var V4 = ",";
      Z.COMMA_DELIMITER = V4;
      var G4 = ":";
      Z.COLON_DELIMITER = G4;
      var z4 = "|";
      Z.BAR_DELIMITER = z4;
      var H4 = "CHILDREN";
      Z.CHILDREN = H4;
      var j4 = "IMMEDIATE_CHILDREN";
      Z.IMMEDIATE_CHILDREN = j4;
      var W4 = "SIBLINGS";
      Z.SIBLINGS = W4;
      var U4 = "PARENT";
      Z.PARENT = U4;
      var X4 = "preserve-3d";
      Z.PRESERVE_3D = X4;
      var $4 = "HTML_ELEMENT";
      Z.HTML_ELEMENT = $4;
      var K4 = "PLAIN_OBJECT";
      Z.PLAIN_OBJECT = K4;
      var Y4 = "ABSTRACT_NODE";
      Z.ABSTRACT_NODE = Y4;
      var Q4 = "RENDER_TRANSFORM";
      Z.RENDER_TRANSFORM = Q4;
      var Z4 = "RENDER_GENERAL";
      Z.RENDER_GENERAL = Z4;
      var J4 = "RENDER_STYLE";
      Z.RENDER_STYLE = J4;
      var e6 = "RENDER_PLUGIN";
      Z.RENDER_PLUGIN = e6
  });
  var st = E(Le => {
      "use strict";
      var US = Vr()
          .default;
      Object.defineProperty(Le, "__esModule", {
          value: !0
      });
      var ms = {
          IX2EngineActionTypes: !0,
          IX2EngineConstants: !0
      };
      Le.IX2EngineConstants = Le.IX2EngineActionTypes = void 0;
      var uh = GS();
      Object.keys(uh)
          .forEach(function(e) {
              e === "default" || e === "__esModule" || Object.prototype.hasOwnProperty.call(ms, e) || e in Le && Le[e] === uh[e] || Object.defineProperty(Le, e, {
                  enumerable: !0,
                  get: function() {
                      return uh[e]
                  }
              })
          });
      var hh = lh();
      Object.keys(hh)
          .forEach(function(e) {
              e === "default" || e === "__esModule" || Object.prototype.hasOwnProperty.call(ms, e) || e in Le && Le[e] === hh[e] || Object.defineProperty(Le, e, {
                  enumerable: !0,
                  get: function() {
                      return hh[e]
                  }
              })
          });
      var ch = zS();
      Object.keys(ch)
          .forEach(function(e) {
              e === "default" || e === "__esModule" || Object.prototype.hasOwnProperty.call(ms, e) || e in Le && Le[e] === ch[e] || Object.defineProperty(Le, e, {
                  enumerable: !0,
                  get: function() {
                      return ch[e]
                  }
              })
          });
      var fh = HS();
      Object.keys(fh)
          .forEach(function(e) {
              e === "default" || e === "__esModule" || Object.prototype.hasOwnProperty.call(ms, e) || e in Le && Le[e] === fh[e] || Object.defineProperty(Le, e, {
                  enumerable: !0,
                  get: function() {
                      return fh[e]
                  }
              })
          });
      var t6 = US(jS());
      Le.IX2EngineActionTypes = t6;
      var r6 = US(WS());
      Le.IX2EngineConstants = r6
  });
  var XS = E(vs => {
      "use strict";
      Object.defineProperty(vs, "__esModule", {
          value: !0
      });
      vs.ixData = void 0;
      var n6 = st(),
          {
              IX2_RAW_DATA_IMPORTED: i6
          } = n6.IX2EngineActionTypes,
          a6 = (e = Object.freeze({}), t) => {
              switch (t.type) {
                  case i6:
                      return t.payload.ixData || Object.freeze({});
                  default:
                      return e
              }
          };
      vs.ixData = a6
  });
  var In = E(Me => {
      "use strict";
      Object.defineProperty(Me, "__esModule", {
          value: !0
      });
      var s6 = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e) {
          return typeof e
      } : function(e) {
          return e && typeof Symbol == "function" && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
      };
      Me.clone = ys;
      Me.addLast = YS;
      Me.addFirst = QS;
      Me.removeLast = ZS;
      Me.removeFirst = JS;
      Me.insert = eI;
      Me.removeAt = tI;
      Me.replaceAt = rI;
      Me.getIn = Es;
      Me.set = bs;
      Me.setIn = _s;
      Me.update = iI;
      Me.updateIn = aI;
      Me.merge = sI;
      Me.mergeDeep = oI;
      Me.mergeIn = lI;
      Me.omit = uI;
      Me.addDefaults = hI;
      var $S = "INVALID_ARGS";

      function KS(e) {
          throw new Error(e)
      }

      function ph(e) {
          var t = Object.keys(e);
          return Object.getOwnPropertySymbols ? t.concat(Object.getOwnPropertySymbols(e)) : t
      }
      var o6 = {}.hasOwnProperty;

      function ys(e) {
          if (Array.isArray(e)) return e.slice();
          for (var t = ph(e), r = {}, n = 0; n < t.length; n++) {
              var i = t[n];
              r[i] = e[i]
          }
          return r
      }

      function ot(e, t, r) {
          var n = r;
          n == null && KS($S);
          for (var i = !1, a = arguments.length, s = Array(a > 3 ? a - 3 : 0), o = 3; o < a; o++) s[o - 3] = arguments[o];
          for (var l = 0; l < s.length; l++) {
              var f = s[l];
              if (f != null) {
                  var u = ph(f);
                  if (u.length)
                      for (var c = 0; c <= u.length; c++) {
                          var v = u[c];
                          if (!(e && n[v] !== void 0)) {
                              var d = f[v];
                              t && gs(n[v]) && gs(d) && (d = ot(e, t, n[v], d)), !(d === void 0 || d === n[v]) && (i || (i = !0, n = ys(n)), n[v] = d)
                          }
                      }
              }
          }
          return n
      }

      function gs(e) {
          var t = typeof e > "u" ? "undefined" : s6(e);
          return e != null && (t === "object" || t === "function")
      }

      function YS(e, t) {
          return Array.isArray(t) ? e.concat(t) : e.concat([t])
      }

      function QS(e, t) {
          return Array.isArray(t) ? t.concat(e) : [t].concat(e)
      }

      function ZS(e) {
          return e.length ? e.slice(0, e.length - 1) : e
      }

      function JS(e) {
          return e.length ? e.slice(1) : e
      }

      function eI(e, t, r) {
          return e.slice(0, t)
              .concat(Array.isArray(r) ? r : [r])
              .concat(e.slice(t))
      }

      function tI(e, t) {
          return t >= e.length || t < 0 ? e : e.slice(0, t)
              .concat(e.slice(t + 1))
      }

      function rI(e, t, r) {
          if (e[t] === r) return e;
          for (var n = e.length, i = Array(n), a = 0; a < n; a++) i[a] = e[a];
          return i[t] = r, i
      }

      function Es(e, t) {
          if (!Array.isArray(t) && KS($S), e != null) {
              for (var r = e, n = 0; n < t.length; n++) {
                  var i = t[n];
                  if (r = r?.[i], r === void 0) return r
              }
              return r
          }
      }

      function bs(e, t, r) {
          var n = typeof t == "number" ? [] : {},
              i = e ?? n;
          if (i[t] === r) return i;
          var a = ys(i);
          return a[t] = r, a
      }

      function nI(e, t, r, n) {
          var i = void 0,
              a = t[n];
          if (n === t.length - 1) i = r;
          else {
              var s = gs(e) && gs(e[a]) ? e[a] : typeof t[n + 1] == "number" ? [] : {};
              i = nI(s, t, r, n + 1)
          }
          return bs(e, a, i)
      }

      function _s(e, t, r) {
          return t.length ? nI(e, t, r, 0) : r
      }

      function iI(e, t, r) {
          var n = e?.[t],
              i = r(n);
          return bs(e, t, i)
      }

      function aI(e, t, r) {
          var n = Es(e, t),
              i = r(n);
          return _s(e, t, i)
      }

      function sI(e, t, r, n, i, a) {
          for (var s = arguments.length, o = Array(s > 6 ? s - 6 : 0), l = 6; l < s; l++) o[l - 6] = arguments[l];
          return o.length ? ot.call.apply(ot, [null, !1, !1, e, t, r, n, i, a].concat(o)) : ot(!1, !1, e, t, r, n, i, a)
      }

      function oI(e, t, r, n, i, a) {
          for (var s = arguments.length, o = Array(s > 6 ? s - 6 : 0), l = 6; l < s; l++) o[l - 6] = arguments[l];
          return o.length ? ot.call.apply(ot, [null, !1, !0, e, t, r, n, i, a].concat(o)) : ot(!1, !0, e, t, r, n, i, a)
      }

      function lI(e, t, r, n, i, a, s) {
          var o = Es(e, t);
          o == null && (o = {});
          for (var l = void 0, f = arguments.length, u = Array(f > 7 ? f - 7 : 0), c = 7; c < f; c++) u[c - 7] = arguments[c];
          return u.length ? l = ot.call.apply(ot, [null, !1, !1, o, r, n, i, a, s].concat(u)) : l = ot(!1, !1, o, r, n, i, a, s), _s(e, t, l)
      }

      function uI(e, t) {
          for (var r = Array.isArray(t) ? t : [t], n = !1, i = 0; i < r.length; i++)
              if (o6.call(e, r[i])) {
                  n = !0;
                  break
              } if (!n) return e;
          for (var a = {}, s = ph(e), o = 0; o < s.length; o++) {
              var l = s[o];
              r.indexOf(l) >= 0 || (a[l] = e[l])
          }
          return a
      }

      function hI(e, t, r, n, i, a) {
          for (var s = arguments.length, o = Array(s > 6 ? s - 6 : 0), l = 6; l < s; l++) o[l - 6] = arguments[l];
          return o.length ? ot.call.apply(ot, [null, !0, !1, e, t, r, n, i, a].concat(o)) : ot(!0, !1, e, t, r, n, i, a)
      }
      var l6 = {
          clone: ys,
          addLast: YS,
          addFirst: QS,
          removeLast: ZS,
          removeFirst: JS,
          insert: eI,
          removeAt: tI,
          replaceAt: rI,
          getIn: Es,
          set: bs,
          setIn: _s,
          update: iI,
          updateIn: aI,
          merge: sI,
          mergeDeep: oI,
          mergeIn: lI,
          omit: uI,
          addDefaults: hI
      };
      Me.default = l6
  });
  var fI = E(Ss => {
      "use strict";
      var u6 = ut()
          .default;
      Object.defineProperty(Ss, "__esModule", {
          value: !0
      });
      Ss.ixRequest = void 0;
      var h6 = u6(Pr()),
          c6 = st(),
          f6 = In(),
          {
              IX2_PREVIEW_REQUESTED: p6,
              IX2_PLAYBACK_REQUESTED: d6,
              IX2_STOP_REQUESTED: m6,
              IX2_CLEAR_REQUESTED: v6
          } = c6.IX2EngineActionTypes,
          g6 = {
              preview: {},
              playback: {},
              stop: {},
              clear: {}
          },
          cI = Object.create(null, {
              [p6]: {
                  value: "preview"
              },
              [d6]: {
                  value: "playback"
              },
              [m6]: {
                  value: "stop"
              },
              [v6]: {
                  value: "clear"
              }
          }),
          y6 = (e = g6, t) => {
              if (t.type in cI) {
                  let r = [cI[t.type]];
                  return (0, f6.setIn)(e, [r], (0, h6.default)({}, t.payload))
              }
              return e
          };
      Ss.ixRequest = y6
  });
  var dI = E(Is => {
      "use strict";
      Object.defineProperty(Is, "__esModule", {
          value: !0
      });
      Is.ixSession = void 0;
      var E6 = st(),
          Gt = In(),
          {
              IX2_SESSION_INITIALIZED: b6,
              IX2_SESSION_STARTED: _6,
              IX2_TEST_FRAME_RENDERED: S6,
              IX2_SESSION_STOPPED: I6,
              IX2_EVENT_LISTENER_ADDED: T6,
              IX2_EVENT_STATE_CHANGED: x6,
              IX2_ANIMATION_FRAME_CHANGED: A6,
              IX2_ACTION_LIST_PLAYBACK_CHANGED: P6,
              IX2_VIEWPORT_WIDTH_CHANGED: C6,
              IX2_MEDIA_QUERIES_DEFINED: w6
          } = E6.IX2EngineActionTypes,
          pI = {
              active: !1,
              tick: 0,
              eventListeners: [],
              eventState: {},
              playbackState: {},
              viewportWidth: 0,
              mediaQueryKey: null,
              hasBoundaryNodes: !1,
              hasDefinedMediaQueries: !1,
              reducedMotion: !1
          },
          O6 = 20,
          M6 = (e = pI, t) => {
              switch (t.type) {
                  case b6: {
                      let {
                          hasBoundaryNodes: r,
                          reducedMotion: n
                      } = t.payload;
                      return (0, Gt.merge)(e, {
                          hasBoundaryNodes: r,
                          reducedMotion: n
                      })
                  }
                  case _6:
                      return (0, Gt.set)(e, "active", !0);
                  case S6: {
                      let {
                          payload: {
                              step: r = O6
                          }
                      } = t;
                      return (0, Gt.set)(e, "tick", e.tick + r)
                  }
                  case I6:
                      return pI;
                  case A6: {
                      let {
                          payload: {
                              now: r
                          }
                      } = t;
                      return (0, Gt.set)(e, "tick", r)
                  }
                  case T6: {
                      let r = (0, Gt.addLast)(e.eventListeners, t.payload);
                      return (0, Gt.set)(e, "eventListeners", r)
                  }
                  case x6: {
                      let {
                          stateKey: r,
                          newState: n
                      } = t.payload;
                      return (0, Gt.setIn)(e, ["eventState", r], n)
                  }
                  case P6: {
                      let {
                          actionListId: r,
                          isPlaying: n
                      } = t.payload;
                      return (0, Gt.setIn)(e, ["playbackState", r], n)
                  }
                  case C6: {
                      let {
                          width: r,
                          mediaQueries: n
                      } = t.payload, i = n.length, a = null;
                      for (let s = 0; s < i; s++) {
                          let {
                              key: o,
                              min: l,
                              max: f
                          } = n[s];
                          if (r >= l && r <= f) {
                              a = o;
                              break
                          }
                      }
                      return (0, Gt.merge)(e, {
                          viewportWidth: r,
                          mediaQueryKey: a
                      })
                  }
                  case w6:
                      return (0, Gt.set)(e, "hasDefinedMediaQueries", !0);
                  default:
                      return e
              }
          };
      Is.ixSession = M6
  });
  var dh = E((hue, mI) => {
      var R6 = lr(),
          D6 = Cr(),
          F6 = $n();

      function q6(e) {
          return function(t, r, n) {
              var i = Object(t);
              if (!D6(t)) {
                  var a = R6(r, 3);
                  t = F6(t), r = function(o) {
                      return a(i[o], o, i)
                  }
              }
              var s = e(t, r, n);
              return s > -1 ? i[a ? t[s] : s] : void 0
          }
      }
      mI.exports = q6
  });
  var mh = E((cue, vI) => {
      var L6 = dh(),
          k6 = Ho(),
          N6 = L6(k6);
      vI.exports = N6
  });
  var xs = E(tt => {
      "use strict";
      var B6 = ut()
          .default;
      Object.defineProperty(tt, "__esModule", {
          value: !0
      });
      tt.withBrowser = tt.TRANSFORM_STYLE_PREFIXED = tt.TRANSFORM_PREFIXED = tt.IS_BROWSER_ENV = tt.FLEX_PREFIXED = tt.ELEMENT_MATCHES = void 0;
      var V6 = B6(mh()),
          yI = typeof window < "u";
      tt.IS_BROWSER_ENV = yI;
      var Ts = (e, t) => yI ? e() : t;
      tt.withBrowser = Ts;
      var G6 = Ts(() => (0, V6.default)(["matches", "matchesSelector", "mozMatchesSelector", "msMatchesSelector", "oMatchesSelector", "webkitMatchesSelector"], e => e in Element.prototype));
      tt.ELEMENT_MATCHES = G6;
      var z6 = Ts(() => {
          let e = document.createElement("i"),
              t = ["flex", "-webkit-flex", "-ms-flexbox", "-moz-box", "-webkit-box"],
              r = "";
          try {
              let {
                  length: n
              } = t;
              for (let i = 0; i < n; i++) {
                  let a = t[i];
                  if (e.style.display = a, e.style.display === a) return a
              }
              return r
          } catch {
              return r
          }
      }, "flex");
      tt.FLEX_PREFIXED = z6;
      var EI = Ts(() => {
          let e = document.createElement("i");
          if (e.style.transform == null) {
              let t = ["Webkit", "Moz", "ms"],
                  r = "Transform",
                  {
                      length: n
                  } = t;
              for (let i = 0; i < n; i++) {
                  let a = t[i] + r;
                  if (e.style[a] !== void 0) return a
              }
          }
          return "transform"
      }, "transform");
      tt.TRANSFORM_PREFIXED = EI;
      var gI = EI.split("transform")[0],
          H6 = gI ? gI + "TransformStyle" : "transformStyle";
      tt.TRANSFORM_STYLE_PREFIXED = H6
  });
  var vh = E((pue, TI) => {
      var j6 = 4,
          W6 = .001,
          U6 = 1e-7,
          X6 = 10,
          wi = 11,
          As = 1 / (wi - 1),
          $6 = typeof Float32Array == "function";

      function bI(e, t) {
          return 1 - 3 * t + 3 * e
      }

      function _I(e, t) {
          return 3 * t - 6 * e
      }

      function SI(e) {
          return 3 * e
      }

      function Ps(e, t, r) {
          return ((bI(t, r) * e + _I(t, r)) * e + SI(t)) * e
      }

      function II(e, t, r) {
          return 3 * bI(t, r) * e * e + 2 * _I(t, r) * e + SI(t)
      }

      function K6(e, t, r, n, i) {
          var a, s, o = 0;
          do s = t + (r - t) / 2, a = Ps(s, n, i) - e, a > 0 ? r = s : t = s; while (Math.abs(a) > U6 && ++o < X6);
          return s
      }

      function Y6(e, t, r, n) {
          for (var i = 0; i < j6; ++i) {
              var a = II(t, r, n);
              if (a === 0) return t;
              var s = Ps(t, r, n) - e;
              t -= s / a
          }
          return t
      }
      TI.exports = function(t, r, n, i) {
          if (!(0 <= t && t <= 1 && 0 <= n && n <= 1)) throw new Error("bezier x values must be in [0, 1] range");
          var a = $6 ? new Float32Array(wi) : new Array(wi);
          if (t !== r || n !== i)
              for (var s = 0; s < wi; ++s) a[s] = Ps(s * As, t, n);

          function o(l) {
              for (var f = 0, u = 1, c = wi - 1; u !== c && a[u] <= l; ++u) f += As;
              --u;
              var v = (l - a[u]) / (a[u + 1] - a[u]),
                  d = f + v * As,
                  p = II(d, t, n);
              return p >= W6 ? Y6(l, d, t, n) : p === 0 ? d : K6(l, f, f + As, t, n)
          }
          return function(f) {
              return t === r && n === i ? f : f === 0 ? 0 : f === 1 ? 1 : Ps(o(f), r, i)
          }
      }
  });
  var gh = E(ue => {
      "use strict";
      var Q6 = ut()
          .default;
      Object.defineProperty(ue, "__esModule", {
          value: !0
      });
      ue.bounce = D$;
      ue.bouncePast = F$;
      ue.easeOut = ue.easeInOut = ue.easeIn = ue.ease = void 0;
      ue.inBack = T$;
      ue.inCirc = b$;
      ue.inCubic = a$;
      ue.inElastic = P$;
      ue.inExpo = g$;
      ue.inOutBack = A$;
      ue.inOutCirc = S$;
      ue.inOutCubic = o$;
      ue.inOutElastic = w$;
      ue.inOutExpo = E$;
      ue.inOutQuad = i$;
      ue.inOutQuart = h$;
      ue.inOutQuint = p$;
      ue.inOutSine = v$;
      ue.inQuad = r$;
      ue.inQuart = l$;
      ue.inQuint = c$;
      ue.inSine = d$;
      ue.outBack = x$;
      ue.outBounce = I$;
      ue.outCirc = _$;
      ue.outCubic = s$;
      ue.outElastic = C$;
      ue.outExpo = y$;
      ue.outQuad = n$;
      ue.outQuart = u$;
      ue.outQuint = f$;
      ue.outSine = m$;
      ue.swingFrom = M$;
      ue.swingFromTo = O$;
      ue.swingTo = R$;
      var Cs = Q6(vh()),
          nr = 1.70158,
          Z6 = (0, Cs.default)(.25, .1, .25, 1);
      ue.ease = Z6;
      var J6 = (0, Cs.default)(.42, 0, 1, 1);
      ue.easeIn = J6;
      var e$ = (0, Cs.default)(0, 0, .58, 1);
      ue.easeOut = e$;
      var t$ = (0, Cs.default)(.42, 0, .58, 1);
      ue.easeInOut = t$;

      function r$(e) {
          return Math.pow(e, 2)
      }

      function n$(e) {
          return -(Math.pow(e - 1, 2) - 1)
      }

      function i$(e) {
          return (e /= .5) < 1 ? .5 * Math.pow(e, 2) : -.5 * ((e -= 2) * e - 2)
      }

      function a$(e) {
          return Math.pow(e, 3)
      }

      function s$(e) {
          return Math.pow(e - 1, 3) + 1
      }

      function o$(e) {
          return (e /= .5) < 1 ? .5 * Math.pow(e, 3) : .5 * (Math.pow(e - 2, 3) + 2)
      }

      function l$(e) {
          return Math.pow(e, 4)
      }

      function u$(e) {
          return -(Math.pow(e - 1, 4) - 1)
      }

      function h$(e) {
          return (e /= .5) < 1 ? .5 * Math.pow(e, 4) : -.5 * ((e -= 2) * Math.pow(e, 3) - 2)
      }

      function c$(e) {
          return Math.pow(e, 5)
      }

      function f$(e) {
          return Math.pow(e - 1, 5) + 1
      }

      function p$(e) {
          return (e /= .5) < 1 ? .5 * Math.pow(e, 5) : .5 * (Math.pow(e - 2, 5) + 2)
      }

      function d$(e) {
          return -Math.cos(e * (Math.PI / 2)) + 1
      }

      function m$(e) {
          return Math.sin(e * (Math.PI / 2))
      }

      function v$(e) {
          return -.5 * (Math.cos(Math.PI * e) - 1)
      }

      function g$(e) {
          return e === 0 ? 0 : Math.pow(2, 10 * (e - 1))
      }

      function y$(e) {
          return e === 1 ? 1 : -Math.pow(2, -10 * e) + 1
      }

      function E$(e) {
          return e === 0 ? 0 : e === 1 ? 1 : (e /= .5) < 1 ? .5 * Math.pow(2, 10 * (e - 1)) : .5 * (-Math.pow(2, -10 * --e) + 2)
      }

      function b$(e) {
          return -(Math.sqrt(1 - e * e) - 1)
      }

      function _$(e) {
          return Math.sqrt(1 - Math.pow(e - 1, 2))
      }

      function S$(e) {
          return (e /= .5) < 1 ? -.5 * (Math.sqrt(1 - e * e) - 1) : .5 * (Math.sqrt(1 - (e -= 2) * e) + 1)
      }

      function I$(e) {
          return e < 1 / 2.75 ? 7.5625 * e * e : e < 2 / 2.75 ? 7.5625 * (e -= 1.5 / 2.75) * e + .75 : e < 2.5 / 2.75 ? 7.5625 * (e -= 2.25 / 2.75) * e + .9375 : 7.5625 * (e -= 2.625 / 2.75) * e + .984375
      }

      function T$(e) {
          let t = nr;
          return e * e * ((t + 1) * e - t)
      }

      function x$(e) {
          let t = nr;
          return (e -= 1) * e * ((t + 1) * e + t) + 1
      }

      function A$(e) {
          let t = nr;
          return (e /= .5) < 1 ? .5 * (e * e * (((t *= 1.525) + 1) * e - t)) : .5 * ((e -= 2) * e * (((t *= 1.525) + 1) * e + t) + 2)
      }

      function P$(e) {
          let t = nr,
              r = 0,
              n = 1;
          return e === 0 ? 0 : e === 1 ? 1 : (r || (r = .3), n < 1 ? (n = 1, t = r / 4) : t = r / (2 * Math.PI) * Math.asin(1 / n), -(n * Math.pow(2, 10 * (e -= 1)) * Math.sin((e - t) * (2 * Math.PI) / r)))
      }

      function C$(e) {
          let t = nr,
              r = 0,
              n = 1;
          return e === 0 ? 0 : e === 1 ? 1 : (r || (r = .3), n < 1 ? (n = 1, t = r / 4) : t = r / (2 * Math.PI) * Math.asin(1 / n), n * Math.pow(2, -10 * e) * Math.sin((e - t) * (2 * Math.PI) / r) + 1)
      }

      function w$(e) {
          let t = nr,
              r = 0,
              n = 1;
          return e === 0 ? 0 : (e /= 1 / 2) === 2 ? 1 : (r || (r = .3 * 1.5), n < 1 ? (n = 1, t = r / 4) : t = r / (2 * Math.PI) * Math.asin(1 / n), e < 1 ? -.5 * (n * Math.pow(2, 10 * (e -= 1)) * Math.sin((e - t) * (2 * Math.PI) / r)) : n * Math.pow(2, -10 * (e -= 1)) * Math.sin((e - t) * (2 * Math.PI) / r) * .5 + 1)
      }

      function O$(e) {
          let t = nr;
          return (e /= .5) < 1 ? .5 * (e * e * (((t *= 1.525) + 1) * e - t)) : .5 * ((e -= 2) * e * (((t *= 1.525) + 1) * e + t) + 2)
      }

      function M$(e) {
          let t = nr;
          return e * e * ((t + 1) * e - t)
      }

      function R$(e) {
          let t = nr;
          return (e -= 1) * e * ((t + 1) * e + t) + 1
      }

      function D$(e) {
          return e < 1 / 2.75 ? 7.5625 * e * e : e < 2 / 2.75 ? 7.5625 * (e -= 1.5 / 2.75) * e + .75 : e < 2.5 / 2.75 ? 7.5625 * (e -= 2.25 / 2.75) * e + .9375 : 7.5625 * (e -= 2.625 / 2.75) * e + .984375
      }

      function F$(e) {
          return e < 1 / 2.75 ? 7.5625 * e * e : e < 2 / 2.75 ? 2 - (7.5625 * (e -= 1.5 / 2.75) * e + .75) : e < 2.5 / 2.75 ? 2 - (7.5625 * (e -= 2.25 / 2.75) * e + .9375) : 2 - (7.5625 * (e -= 2.625 / 2.75) * e + .984375)
      }
  });
  var Eh = E(Oi => {
      "use strict";
      var q$ = ut()
          .default,
          L$ = Vr()
          .default;
      Object.defineProperty(Oi, "__esModule", {
          value: !0
      });
      Oi.applyEasing = B$;
      Oi.createBezierEasing = N$;
      Oi.optimizeFloat = yh;
      var xI = L$(gh()),
          k$ = q$(vh());

      function yh(e, t = 5, r = 10) {
          let n = Math.pow(r, t),
              i = Number(Math.round(e * n) / n);
          return Math.abs(i) > 1e-4 ? i : 0
      }

      function N$(e) {
          return (0, k$.default)(...e)
      }

      function B$(e, t, r) {
          return t === 0 ? 0 : t === 1 ? 1 : yh(r ? t > 0 ? r(t) : t : t > 0 && e && xI[e] ? xI[e](t) : t)
      }
  });
  var wI = E(Tn => {
      "use strict";
      Object.defineProperty(Tn, "__esModule", {
          value: !0
      });
      Tn.createElementState = CI;
      Tn.ixElements = void 0;
      Tn.mergeActionState = bh;
      var ws = In(),
          PI = st(),
          {
              HTML_ELEMENT: vue,
              PLAIN_OBJECT: V$,
              ABSTRACT_NODE: gue,
              CONFIG_X_VALUE: G$,
              CONFIG_Y_VALUE: z$,
              CONFIG_Z_VALUE: H$,
              CONFIG_VALUE: j$,
              CONFIG_X_UNIT: W$,
              CONFIG_Y_UNIT: U$,
              CONFIG_Z_UNIT: X$,
              CONFIG_UNIT: $$
          } = PI.IX2EngineConstants,
          {
              IX2_SESSION_STOPPED: K$,
              IX2_INSTANCE_ADDED: Y$,
              IX2_ELEMENT_STATE_CHANGED: Q$
          } = PI.IX2EngineActionTypes,
          AI = {},
          Z$ = "refState",
          J$ = (e = AI, t = {}) => {
              switch (t.type) {
                  case K$:
                      return AI;
                  case Y$: {
                      let {
                          elementId: r,
                          element: n,
                          origin: i,
                          actionItem: a,
                          refType: s
                      } = t.payload, {
                          actionTypeId: o
                      } = a, l = e;
                      return (0, ws.getIn)(l, [r, n]) !== n && (l = CI(l, n, s, r, a)), bh(l, r, o, i, a)
                  }
                  case Q$: {
                      let {
                          elementId: r,
                          actionTypeId: n,
                          current: i,
                          actionItem: a
                      } = t.payload;
                      return bh(e, r, n, i, a)
                  }
                  default:
                      return e
              }
          };
      Tn.ixElements = J$;

      function CI(e, t, r, n, i) {
          let a = r === V$ ? (0, ws.getIn)(i, ["config", "target", "objectId"]) : null;
          return (0, ws.mergeIn)(e, [n], {
              id: n,
              ref: t,
              refId: a,
              refType: r
          })
      }

      function bh(e, t, r, n, i) {
          let a = tK(i),
              s = [t, Z$, r];
          return (0, ws.mergeIn)(e, s, n, a)
      }
      var eK = [
          [G$, W$],
          [z$, U$],
          [H$, X$],
          [j$, $$]
      ];

      function tK(e) {
          let {
              config: t
          } = e;
          return eK.reduce((r, n) => {
              let i = n[0],
                  a = n[1],
                  s = t[i],
                  o = t[a];
              return s != null && o != null && (r[a] = o), r
          }, {})
      }
  });
  var OI = E(je => {
      "use strict";
      Object.defineProperty(je, "__esModule", {
          value: !0
      });
      je.renderPlugin = je.getPluginOrigin = je.getPluginDuration = je.getPluginDestination = je.getPluginConfig = je.createPluginInstance = je.clearPlugin = void 0;
      var rK = e => e.value;
      je.getPluginConfig = rK;
      var nK = (e, t) => {
          if (t.config.duration !== "auto") return null;
          let r = parseFloat(e.getAttribute("data-duration"));
          return r > 0 ? r * 1e3 : parseFloat(e.getAttribute("data-default-duration")) * 1e3
      };
      je.getPluginDuration = nK;
      var iK = e => e || {
          value: 0
      };
      je.getPluginOrigin = iK;
      var aK = e => ({
          value: e.value
      });
      je.getPluginDestination = aK;
      var sK = e => {
          let t = window.Webflow.require("lottie")
              .createInstance(e);
          return t.stop(), t.setSubframe(!0), t
      };
      je.createPluginInstance = sK;
      var oK = (e, t, r) => {
          if (!e) return;
          let n = t[r.actionTypeId].value / 100;
          e.goToFrame(e.frames * n)
      };
      je.renderPlugin = oK;
      var lK = e => {
          window.Webflow.require("lottie")
              .createInstance(e)
              .stop()
      };
      je.clearPlugin = lK
  });
  var RI = E(We => {
      "use strict";
      Object.defineProperty(We, "__esModule", {
          value: !0
      });
      We.renderPlugin = We.getPluginOrigin = We.getPluginDuration = We.getPluginDestination = We.getPluginConfig = We.createPluginInstance = We.clearPlugin = void 0;
      var uK = e => document.querySelector(`[data-w-id="${e}"]`),
          hK = () => window.Webflow.require("spline"),
          cK = (e, t) => e.filter(r => !t.includes(r)),
          fK = (e, t) => e.value[t];
      We.getPluginConfig = fK;
      var pK = () => null;
      We.getPluginDuration = pK;
      var MI = Object.freeze({
              positionX: 0,
              positionY: 0,
              positionZ: 0,
              rotationX: 0,
              rotationY: 0,
              rotationZ: 0,
              scaleX: 1,
              scaleY: 1,
              scaleZ: 1
          }),
          dK = (e, t) => {
              let r = t.config.value,
                  n = Object.keys(r);
              if (e) {
                  let a = Object.keys(e),
                      s = cK(n, a);
                  return s.length ? s.reduce((l, f) => (l[f] = MI[f], l), e) : e
              }
              return n.reduce((a, s) => (a[s] = MI[s], a), {})
          };
      We.getPluginOrigin = dK;
      var mK = e => e.value;
      We.getPluginDestination = mK;
      var vK = (e, t) => {
          var r, n;
          let i = t == null || (r = t.config) === null || r === void 0 || (n = r.target) === null || n === void 0 ? void 0 : n.pluginElement;
          return i ? uK(i) : null
      };
      We.createPluginInstance = vK;
      var gK = (e, t, r) => {
          let n = hK()
              .getInstance(e),
              i = r.config.target.objectId;
          if (!n || !i) return;
          let a = n.spline.findObjectById(i);
          if (!a) return;
          let {
              PLUGIN_SPLINE: s
          } = t;
          s.positionX != null && (a.position.x = s.positionX), s.positionY != null && (a.position.y = s.positionY), s.positionZ != null && (a.position.z = s.positionZ), s.rotationX != null && (a.rotation.x = s.rotationX), s.rotationY != null && (a.rotation.y = s.rotationY), s.rotationZ != null && (a.rotation.z = s.rotationZ), s.scaleX != null && (a.scale.x = s.scaleX), s.scaleY != null && (a.scale.y = s.scaleY), s.scaleZ != null && (a.scale.z = s.scaleZ)
      };
      We.renderPlugin = gK;
      var yK = () => null;
      We.clearPlugin = yK
  });
  var FI = E(Be => {
      "use strict";
      Object.defineProperty(Be, "__esModule", {
          value: !0
      });
      Be.getPluginOrigin = Be.getPluginDuration = Be.getPluginDestination = Be.getPluginConfig = Be.createPluginInstance = Be.clearPlugin = void 0;
      Be.normalizeColor = DI;
      Be.renderPlugin = void 0;

      function DI(e) {
          let t, r, n, i = 1,
              a = e.replace(/\s/g, "")
              .toLowerCase();
          if (a.startsWith("#")) {
              let s = a.substring(1);
              s.length === 3 ? (t = parseInt(s[0] + s[0], 16), r = parseInt(s[1] + s[1], 16), n = parseInt(s[2] + s[2], 16)) : s.length === 6 && (t = parseInt(s.substring(0, 2), 16), r = parseInt(s.substring(2, 4), 16), n = parseInt(s.substring(4, 6), 16))
          } else if (a.startsWith("rgba")) {
              let s = a.match(/rgba\(([^)]+)\)/)[1].split(",");
              t = parseInt(s[0], 10), r = parseInt(s[1], 10), n = parseInt(s[2], 10), i = parseFloat(s[3])
          } else if (a.startsWith("rgb")) {
              let s = a.match(/rgb\(([^)]+)\)/)[1].split(",");
              t = parseInt(s[0], 10), r = parseInt(s[1], 10), n = parseInt(s[2], 10)
          } else if (a.startsWith("hsla")) {
              let s = a.match(/hsla\(([^)]+)\)/)[1].split(","),
                  o = parseFloat(s[0]),
                  l = parseFloat(s[1].replace("%", "")) / 100,
                  f = parseFloat(s[2].replace("%", "")) / 100;
              i = parseFloat(s[3]);
              let u = (1 - Math.abs(2 * f - 1)) * l,
                  c = u * (1 - Math.abs(o / 60 % 2 - 1)),
                  v = f - u / 2,
                  d, p, m;
              o >= 0 && o < 60 ? (d = u, p = c, m = 0) : o >= 60 && o < 120 ? (d = c, p = u, m = 0) : o >= 120 && o < 180 ? (d = 0, p = u, m = c) : o >= 180 && o < 240 ? (d = 0, p = c, m = u) : o >= 240 && o < 300 ? (d = c, p = 0, m = u) : (d = u, p = 0, m = c), t = Math.round((d + v) * 255), r = Math.round((p + v) * 255), n = Math.round((m + v) * 255)
          } else if (a.startsWith("hsl")) {
              let s = a.match(/hsl\(([^)]+)\)/)[1].split(","),
                  o = parseFloat(s[0]),
                  l = parseFloat(s[1].replace("%", "")) / 100,
                  f = parseFloat(s[2].replace("%", "")) / 100,
                  u = (1 - Math.abs(2 * f - 1)) * l,
                  c = u * (1 - Math.abs(o / 60 % 2 - 1)),
                  v = f - u / 2,
                  d, p, m;
              o >= 0 && o < 60 ? (d = u, p = c, m = 0) : o >= 60 && o < 120 ? (d = c, p = u, m = 0) : o >= 120 && o < 180 ? (d = 0, p = u, m = c) : o >= 180 && o < 240 ? (d = 0, p = c, m = u) : o >= 240 && o < 300 ? (d = c, p = 0, m = u) : (d = u, p = 0, m = c), t = Math.round((d + v) * 255), r = Math.round((p + v) * 255), n = Math.round((m + v) * 255)
          }
          return (Number.isNaN(t) || Number.isNaN(r) || Number.isNaN(n)) && `${e}`, {
              red: t,
              green: r,
              blue: n,
              alpha: i
          }
      }
      var EK = (e, t) => e.value[t];
      Be.getPluginConfig = EK;
      var bK = () => null;
      Be.getPluginDuration = bK;
      var _K = (e, t) => {
          if (e) return e;
          let r = t.config.value,
              n = t.config.target.objectId,
              i = getComputedStyle(document.documentElement)
              .getPropertyValue(n);
          if (r.size != null) return {
              size: parseInt(i, 10)
          };
          if (r.red != null && r.green != null && r.blue != null) return DI(i)
      };
      Be.getPluginOrigin = _K;
      var SK = e => e.value;
      Be.getPluginDestination = SK;
      var IK = () => null;
      Be.createPluginInstance = IK;
      var TK = (e, t, r) => {
          let n = r.config.target.objectId,
              i = r.config.value.unit,
              {
                  PLUGIN_VARIABLE: a
              } = t,
              {
                  size: s,
                  red: o,
                  green: l,
                  blue: f,
                  alpha: u
              } = a,
              c;
          s != null && (c = s + i), o != null && f != null && l != null && u != null && (c = `rgba(${o}, ${l}, ${f}, ${u})`), c != null && document.documentElement.style.setProperty(n, c)
      };
      Be.renderPlugin = TK;
      var xK = (e, t) => {
          let r = t.config.target.objectId;
          document.documentElement.style.removeProperty(r)
      };
      Be.clearPlugin = xK
  });
  var qI = E(Os => {
      "use strict";
      var Ih = Vr()
          .default,
          AK = ut()
          .default;
      Object.defineProperty(Os, "__esModule", {
          value: !0
      });
      Os.pluginMethodMap = void 0;
      var _h = AK(Pr()),
          Sh = st(),
          PK = Ih(OI()),
          CK = Ih(RI()),
          wK = Ih(FI()),
          OK = new Map([
              [Sh.ActionTypeConsts.PLUGIN_LOTTIE, (0, _h.default)({}, PK)],
              [Sh.ActionTypeConsts.PLUGIN_SPLINE, (0, _h.default)({}, CK)],
              [Sh.ActionTypeConsts.PLUGIN_VARIABLE, (0, _h.default)({}, wK)]
          ]);
      Os.pluginMethodMap = OK
  });
  var Th = E(Ve => {
      "use strict";
      Object.defineProperty(Ve, "__esModule", {
          value: !0
      });
      Ve.getPluginOrigin = Ve.getPluginDuration = Ve.getPluginDestination = Ve.getPluginConfig = Ve.createPluginInstance = Ve.clearPlugin = void 0;
      Ve.isPluginType = RK;
      Ve.renderPlugin = void 0;
      var MK = xs(),
          LI = qI();

      function RK(e) {
          return LI.pluginMethodMap.has(e)
      }
      var Gr = e => t => {
              if (!MK.IS_BROWSER_ENV) return () => null;
              let r = LI.pluginMethodMap.get(t);
              if (!r) throw new Error(`IX2 no plugin configured for: ${t}`);
              let n = r[e];
              if (!n) throw new Error(`IX2 invalid plugin method: ${e}`);
              return n
          },
          DK = Gr("getPluginConfig");
      Ve.getPluginConfig = DK;
      var FK = Gr("getPluginOrigin");
      Ve.getPluginOrigin = FK;
      var qK = Gr("getPluginDuration");
      Ve.getPluginDuration = qK;
      var LK = Gr("getPluginDestination");
      Ve.getPluginDestination = LK;
      var kK = Gr("createPluginInstance");
      Ve.createPluginInstance = kK;
      var NK = Gr("renderPlugin");
      Ve.renderPlugin = NK;
      var BK = Gr("clearPlugin");
      Ve.clearPlugin = BK
  });
  var NI = E((Tue, kI) => {
      function VK(e, t) {
          return e == null || e !== e ? t : e
      }
      kI.exports = VK
  });
  var VI = E((xue, BI) => {
      function GK(e, t, r, n) {
          var i = -1,
              a = e == null ? 0 : e.length;
          for (n && a && (r = e[++i]); ++i < a;) r = t(r, e[i], i, e);
          return r
      }
      BI.exports = GK
  });
  var zI = E((Aue, GI) => {
      function zK(e) {
          return function(t, r, n) {
              for (var i = -1, a = Object(t), s = n(t), o = s.length; o--;) {
                  var l = s[e ? o : ++i];
                  if (r(a[l], l, a) === !1) break
              }
              return t
          }
      }
      GI.exports = zK
  });
  var jI = E((Pue, HI) => {
      var HK = zI(),
          jK = HK();
      HI.exports = jK
  });
  var xh = E((Cue, WI) => {
      var WK = jI(),
          UK = $n();

      function XK(e, t) {
          return e && WK(e, t, UK)
      }
      WI.exports = XK
  });
  var XI = E((wue, UI) => {
      var $K = Cr();

      function KK(e, t) {
          return function(r, n) {
              if (r == null) return r;
              if (!$K(r)) return e(r, n);
              for (var i = r.length, a = t ? i : -1, s = Object(r);
                  (t ? a-- : ++a < i) && n(s[a], a, s) !== !1;);
              return r
          }
      }
      UI.exports = KK
  });
  var Ah = E((Oue, $I) => {
      var YK = xh(),
          QK = XI(),
          ZK = QK(YK);
      $I.exports = ZK
  });
  var YI = E((Mue, KI) => {
      function JK(e, t, r, n, i) {
          return i(e, function(a, s, o) {
              r = n ? (n = !1, a) : t(r, a, s, o)
          }), r
      }
      KI.exports = JK
  });
  var ZI = E((Rue, QI) => {
      var e8 = VI(),
          t8 = Ah(),
          r8 = lr(),
          n8 = YI(),
          i8 = ze();

      function a8(e, t, r) {
          var n = i8(e) ? e8 : n8,
              i = arguments.length < 3;
          return n(e, r8(t, 4), r, i, t8)
      }
      QI.exports = a8
  });
  var eT = E((Due, JI) => {
      var s8 = mo(),
          o8 = lr(),
          l8 = zo(),
          u8 = Math.max,
          h8 = Math.min;

      function c8(e, t, r) {
          var n = e == null ? 0 : e.length;
          if (!n) return -1;
          var i = n - 1;
          return r !== void 0 && (i = l8(r), i = r < 0 ? u8(n + i, 0) : h8(i, n - 1)), s8(e, o8(t, 3), i, !0)
      }
      JI.exports = c8
  });
  var rT = E((Fue, tT) => {
      var f8 = dh(),
          p8 = eT(),
          d8 = f8(p8);
      tT.exports = d8
  });
  var iT = E(Ms => {
      "use strict";
      Object.defineProperty(Ms, "__esModule", {
          value: !0
      });
      Ms.default = void 0;
      var m8 = Object.prototype.hasOwnProperty;

      function nT(e, t) {
          return e === t ? e !== 0 || t !== 0 || 1 / e === 1 / t : e !== e && t !== t
      }

      function v8(e, t) {
          if (nT(e, t)) return !0;
          if (typeof e != "object" || e === null || typeof t != "object" || t === null) return !1;
          let r = Object.keys(e),
              n = Object.keys(t);
          if (r.length !== n.length) return !1;
          for (let i = 0; i < r.length; i++)
              if (!m8.call(t, r[i]) || !nT(e[r[i]], t[r[i]])) return !1;
          return !0
      }
      var g8 = v8;
      Ms.default = g8
  });
  var IT = E(_e => {
      "use strict";
      var qs = ut()
          .default;
      Object.defineProperty(_e, "__esModule", {
          value: !0
      });
      _e.cleanupHTMLElement = m9;
      _e.clearAllStyles = d9;
      _e.clearObjectCache = q8;
      _e.getActionListProgress = g9;
      _e.getAffectedElements = Dh;
      _e.getComputedStyle = H8;
      _e.getDestinationValues = Y8;
      _e.getElementId = B8;
      _e.getInstanceId = k8;
      _e.getInstanceOrigin = U8;
      _e.getItemConfigByKey = void 0;
      _e.getMaxDurationItemIndex = ST;
      _e.getNamespacedParameterId = b9;
      _e.getRenderType = ET;
      _e.getStyleProp = Q8;
      _e.mediaQueriesEqual = S9;
      _e.observeStore = z8;
      _e.reduceListToGroup = y9;
      _e.reifyState = V8;
      _e.renderHTMLElement = Z8;
      Object.defineProperty(_e, "shallowEqual", {
          enumerable: !0,
          get: function() {
              return fT.default
          }
      });
      _e.shouldAllowMediaQuery = _9;
      _e.shouldNamespaceEventParameter = E9;
      _e.stringifyTarget = I9;
      var br = qs(NI()),
          wh = qs(ZI()),
          Ch = qs(rT()),
          aT = In(),
          zr = st(),
          fT = qs(iT()),
          y8 = Eh(),
          jt = Th(),
          rt = xs(),
          {
              BACKGROUND: E8,
              TRANSFORM: b8,
              TRANSLATE_3D: _8,
              SCALE_3D: S8,
              ROTATE_X: I8,
              ROTATE_Y: T8,
              ROTATE_Z: x8,
              SKEW: A8,
              PRESERVE_3D: P8,
              FLEX: C8,
              OPACITY: Ds,
              FILTER: Mi,
              FONT_VARIATION_SETTINGS: Ri,
              WIDTH: zt,
              HEIGHT: Ht,
              BACKGROUND_COLOR: pT,
              BORDER_COLOR: w8,
              COLOR: O8,
              CHILDREN: sT,
              IMMEDIATE_CHILDREN: M8,
              SIBLINGS: oT,
              PARENT: R8,
              DISPLAY: Fs,
              WILL_CHANGE: xn,
              AUTO: _r,
              COMMA_DELIMITER: Di,
              COLON_DELIMITER: D8,
              BAR_DELIMITER: Ph,
              RENDER_TRANSFORM: dT,
              RENDER_GENERAL: Oh,
              RENDER_STYLE: Mh,
              RENDER_PLUGIN: mT
          } = zr.IX2EngineConstants,
          {
              TRANSFORM_MOVE: An,
              TRANSFORM_SCALE: Pn,
              TRANSFORM_ROTATE: Cn,
              TRANSFORM_SKEW: Fi,
              STYLE_OPACITY: vT,
              STYLE_FILTER: qi,
              STYLE_FONT_VARIATION: Li,
              STYLE_SIZE: wn,
              STYLE_BACKGROUND_COLOR: On,
              STYLE_BORDER: Mn,
              STYLE_TEXT_COLOR: Rn,
              GENERAL_DISPLAY: Ls,
              OBJECT_VALUE: F8
          } = zr.ActionTypeConsts,
          gT = e => e.trim(),
          Rh = Object.freeze({
              [On]: pT,
              [Mn]: w8,
              [Rn]: O8
          }),
          yT = Object.freeze({
              [rt.TRANSFORM_PREFIXED]: b8,
              [pT]: E8,
              [Ds]: Ds,
              [Mi]: Mi,
              [zt]: zt,
              [Ht]: Ht,
              [Ri]: Ri
          }),
          Rs = new Map;

      function q8() {
          Rs.clear()
      }
      var L8 = 1;

      function k8() {
          return "i" + L8++
      }
      var N8 = 1;

      function B8(e, t) {
          for (let r in e) {
              let n = e[r];
              if (n && n.ref === t) return n.id
          }
          return "e" + N8++
      }

      function V8({
          events: e,
          actionLists: t,
          site: r
      } = {}) {
          let n = (0, wh.default)(e, (s, o) => {
                  let {
                      eventTypeId: l
                  } = o;
                  return s[l] || (s[l] = {}), s[l][o.id] = o, s
              }, {}),
              i = r && r.mediaQueries,
              a = [];
          return i ? a = i.map(s => s.key) : (i = [], console.warn("IX2 missing mediaQueries in site data")), {
              ixData: {
                  events: e,
                  actionLists: t,
                  eventTypeMap: n,
                  mediaQueries: i,
                  mediaQueryKeys: a
              }
          }
      }
      var G8 = (e, t) => e === t;

      function z8({
          store: e,
          select: t,
          onChange: r,
          comparator: n = G8
      }) {
          let {
              getState: i,
              subscribe: a
          } = e, s = a(l), o = t(i());

          function l() {
              let f = t(i());
              if (f == null) {
                  s();
                  return
              }
              n(f, o) || (o = f, r(o, e))
          }
          return s
      }

      function lT(e) {
          let t = typeof e;
          if (t === "string") return {
              id: e
          };
          if (e != null && t === "object") {
              let {
                  id: r,
                  objectId: n,
                  selector: i,
                  selectorGuids: a,
                  appliesTo: s,
                  useEventTarget: o
              } = e;
              return {
                  id: r,
                  objectId: n,
                  selector: i,
                  selectorGuids: a,
                  appliesTo: s,
                  useEventTarget: o
              }
          }
          return {}
      }

      function Dh({
          config: e,
          event: t,
          eventTarget: r,
          elementRoot: n,
          elementApi: i
      }) {
          var a, s, o;
          if (!i) throw new Error("IX2 missing elementApi");
          let {
              targets: l
          } = e;
          if (Array.isArray(l) && l.length > 0) return l.reduce((k, U) => k.concat(Dh({
              config: {
                  target: U
              },
              event: t,
              eventTarget: r,
              elementRoot: n,
              elementApi: i
          })), []);
          let {
              getValidDocument: f,
              getQuerySelector: u,
              queryDocument: c,
              getChildElements: v,
              getSiblingElements: d,
              matchSelector: p,
              elementContains: m,
              isSiblingNode: h
          } = i, {
              target: g
          } = e;
          if (!g) return [];
          let {
              id: y,
              objectId: b,
              selector: _,
              selectorGuids: I,
              appliesTo: C,
              useEventTarget: x
          } = lT(g);
          if (b) return [Rs.has(b) ? Rs.get(b) : Rs.set(b, {})
              .get(b)
          ];
          if (C === zr.EventAppliesTo.PAGE) {
              let k = f(y);
              return k ? [k] : []
          }
          let L = ((a = t == null || (s = t.action) === null || s === void 0 || (o = s.config) === null || o === void 0 ? void 0 : o.affectedElements) !== null && a !== void 0 ? a : {})[y || _] || {},
              D = !!(L.id || L.selector),
              A, q, w, F = t && u(lT(t.target));
          if (D ? (A = L.limitAffectedElements, q = F, w = u(L)) : q = w = u({
                  id: y,
                  selector: _,
                  selectorGuids: I
              }), t && x) {
              let k = r && (w || x === !0) ? [r] : c(F);
              if (w) {
                  if (x === R8) return c(w)
                      .filter(U => k.some(W => m(U, W)));
                  if (x === sT) return c(w)
                      .filter(U => k.some(W => m(W, U)));
                  if (x === oT) return c(w)
                      .filter(U => k.some(W => h(W, U)))
              }
              return k
          }
          return q == null || w == null ? [] : rt.IS_BROWSER_ENV && n ? c(w)
              .filter(k => n.contains(k)) : A === sT ? c(q, w) : A === M8 ? v(c(q))
              .filter(p(w)) : A === oT ? d(c(q))
              .filter(p(w)) : c(w)
      }

      function H8({
          element: e,
          actionItem: t
      }) {
          if (!rt.IS_BROWSER_ENV) return {};
          let {
              actionTypeId: r
          } = t;
          switch (r) {
              case wn:
              case On:
              case Mn:
              case Rn:
              case Ls:
                  return window.getComputedStyle(e);
              default:
                  return {}
          }
      }
      var uT = /px/,
          j8 = (e, t) => t.reduce((r, n) => (r[n.type] == null && (r[n.type] = J8[n.type]), r), e || {}),
          W8 = (e, t) => t.reduce((r, n) => (r[n.type] == null && (r[n.type] = e9[n.type] || n.defaultValue || 0), r), e || {});

      function U8(e, t = {}, r = {}, n, i) {
          let {
              getStyle: a
          } = i, {
              actionTypeId: s
          } = n;
          if ((0, jt.isPluginType)(s)) return (0, jt.getPluginOrigin)(s)(t[s], n);
          switch (n.actionTypeId) {
              case An:
              case Pn:
              case Cn:
              case Fi:
                  return t[n.actionTypeId] || Fh[n.actionTypeId];
              case qi:
                  return j8(t[n.actionTypeId], n.config.filters);
              case Li:
                  return W8(t[n.actionTypeId], n.config.fontVariations);
              case vT:
                  return {
                      value: (0, br.default)(parseFloat(a(e, Ds)), 1)
                  };
              case wn: {
                  let o = a(e, zt),
                      l = a(e, Ht),
                      f, u;
                  return n.config.widthUnit === _r ? f = uT.test(o) ? parseFloat(o) : parseFloat(r.width) : f = (0, br.default)(parseFloat(o), parseFloat(r.width)), n.config.heightUnit === _r ? u = uT.test(l) ? parseFloat(l) : parseFloat(r.height) : u = (0, br.default)(parseFloat(l), parseFloat(r.height)), {
                      widthValue: f,
                      heightValue: u
                  }
              }
              case On:
              case Mn:
              case Rn:
                  return c9({
                      element: e,
                      actionTypeId: n.actionTypeId,
                      computedStyle: r,
                      getStyle: a
                  });
              case Ls:
                  return {
                      value: (0, br.default)(a(e, Fs), r.display)
                  };
              case F8:
                  return t[n.actionTypeId] || {
                      value: 0
                  };
              default:
                  return
          }
      }
      var X8 = (e, t) => (t && (e[t.type] = t.value || 0), e),
          $8 = (e, t) => (t && (e[t.type] = t.value || 0), e),
          K8 = (e, t, r) => {
              if ((0, jt.isPluginType)(e)) return (0, jt.getPluginConfig)(e)(r, t);
              switch (e) {
                  case qi: {
                      let n = (0, Ch.default)(r.filters, ({
                          type: i
                      }) => i === t);
                      return n ? n.value : 0
                  }
                  case Li: {
                      let n = (0, Ch.default)(r.fontVariations, ({
                          type: i
                      }) => i === t);
                      return n ? n.value : 0
                  }
                  default:
                      return r[t]
              }
          };
      _e.getItemConfigByKey = K8;

      function Y8({
          element: e,
          actionItem: t,
          elementApi: r
      }) {
          if ((0, jt.isPluginType)(t.actionTypeId)) return (0, jt.getPluginDestination)(t.actionTypeId)(t.config);
          switch (t.actionTypeId) {
              case An:
              case Pn:
              case Cn:
              case Fi: {
                  let {
                      xValue: n,
                      yValue: i,
                      zValue: a
                  } = t.config;
                  return {
                      xValue: n,
                      yValue: i,
                      zValue: a
                  }
              }
              case wn: {
                  let {
                      getStyle: n,
                      setStyle: i,
                      getProperty: a
                  } = r, {
                      widthUnit: s,
                      heightUnit: o
                  } = t.config, {
                      widthValue: l,
                      heightValue: f
                  } = t.config;
                  if (!rt.IS_BROWSER_ENV) return {
                      widthValue: l,
                      heightValue: f
                  };
                  if (s === _r) {
                      let u = n(e, zt);
                      i(e, zt, ""), l = a(e, "offsetWidth"), i(e, zt, u)
                  }
                  if (o === _r) {
                      let u = n(e, Ht);
                      i(e, Ht, ""), f = a(e, "offsetHeight"), i(e, Ht, u)
                  }
                  return {
                      widthValue: l,
                      heightValue: f
                  }
              }
              case On:
              case Mn:
              case Rn: {
                  let {
                      rValue: n,
                      gValue: i,
                      bValue: a,
                      aValue: s
                  } = t.config;
                  return {
                      rValue: n,
                      gValue: i,
                      bValue: a,
                      aValue: s
                  }
              }
              case qi:
                  return t.config.filters.reduce(X8, {});
              case Li:
                  return t.config.fontVariations.reduce($8, {});
              default: {
                  let {
                      value: n
                  } = t.config;
                  return {
                      value: n
                  }
              }
          }
      }

      function ET(e) {
          if (/^TRANSFORM_/.test(e)) return dT;
          if (/^STYLE_/.test(e)) return Mh;
          if (/^GENERAL_/.test(e)) return Oh;
          if (/^PLUGIN_/.test(e)) return mT
      }

      function Q8(e, t) {
          return e === Mh ? t.replace("STYLE_", "")
              .toLowerCase() : null
      }

      function Z8(e, t, r, n, i, a, s, o, l) {
          switch (o) {
              case dT:
                  return n9(e, t, r, i, s);
              case Mh:
                  return f9(e, t, r, i, a, s);
              case Oh:
                  return p9(e, i, s);
              case mT: {
                  let {
                      actionTypeId: f
                  } = i;
                  if ((0, jt.isPluginType)(f)) return (0, jt.renderPlugin)(f)(l, t, i)
              }
          }
      }
      var Fh = {
              [An]: Object.freeze({
                  xValue: 0,
                  yValue: 0,
                  zValue: 0
              }),
              [Pn]: Object.freeze({
                  xValue: 1,
                  yValue: 1,
                  zValue: 1
              }),
              [Cn]: Object.freeze({
                  xValue: 0,
                  yValue: 0,
                  zValue: 0
              }),
              [Fi]: Object.freeze({
                  xValue: 0,
                  yValue: 0
              })
          },
          J8 = Object.freeze({
              blur: 0,
              "hue-rotate": 0,
              invert: 0,
              grayscale: 0,
              saturate: 100,
              sepia: 0,
              contrast: 100,
              brightness: 100
          }),
          e9 = Object.freeze({
              wght: 0,
              opsz: 0,
              wdth: 0,
              slnt: 0
          }),
          t9 = (e, t) => {
              let r = (0, Ch.default)(t.filters, ({
                  type: n
              }) => n === e);
              if (r && r.unit) return r.unit;
              switch (e) {
                  case "blur":
                      return "px";
                  case "hue-rotate":
                      return "deg";
                  default:
                      return "%"
              }
          },
          r9 = Object.keys(Fh);

      function n9(e, t, r, n, i) {
          let a = r9.map(o => {
                  let l = Fh[o],
                      {
                          xValue: f = l.xValue,
                          yValue: u = l.yValue,
                          zValue: c = l.zValue,
                          xUnit: v = "",
                          yUnit: d = "",
                          zUnit: p = ""
                      } = t[o] || {};
                  switch (o) {
                      case An:
                          return `${_8}(${f}${v}, ${u}${d}, ${c}${p})`;
                      case Pn:
                          return `${S8}(${f}${v}, ${u}${d}, ${c}${p})`;
                      case Cn:
                          return `${I8}(${f}${v}) ${T8}(${u}${d}) ${x8}(${c}${p})`;
                      case Fi:
                          return `${A8}(${f}${v}, ${u}${d})`;
                      default:
                          return ""
                  }
              })
              .join(" "),
              {
                  setStyle: s
              } = i;
          Hr(e, rt.TRANSFORM_PREFIXED, i), s(e, rt.TRANSFORM_PREFIXED, a), s9(n, r) && s(e, rt.TRANSFORM_STYLE_PREFIXED, P8)
      }

      function i9(e, t, r, n) {
          let i = (0, wh.default)(t, (s, o, l) => `${s} ${l}(${o}${t9(l,r)})`, ""),
              {
                  setStyle: a
              } = n;
          Hr(e, Mi, n), a(e, Mi, i)
      }

      function a9(e, t, r, n) {
          let i = (0, wh.default)(t, (s, o, l) => (s.push(`"${l}" ${o}`), s), [])
              .join(", "),
              {
                  setStyle: a
              } = n;
          Hr(e, Ri, n), a(e, Ri, i)
      }

      function s9({
          actionTypeId: e
      }, {
          xValue: t,
          yValue: r,
          zValue: n
      }) {
          return e === An && n !== void 0 || e === Pn && n !== void 0 || e === Cn && (t !== void 0 || r !== void 0)
      }
      var o9 = "\\(([^)]+)\\)",
          l9 = /^rgb/,
          u9 = RegExp(`rgba?${o9}`);

      function h9(e, t) {
          let r = e.exec(t);
          return r ? r[1] : ""
      }

      function c9({
          element: e,
          actionTypeId: t,
          computedStyle: r,
          getStyle: n
      }) {
          let i = Rh[t],
              a = n(e, i),
              s = l9.test(a) ? a : r[i],
              o = h9(u9, s)
              .split(Di);
          return {
              rValue: (0, br.default)(parseInt(o[0], 10), 255),
              gValue: (0, br.default)(parseInt(o[1], 10), 255),
              bValue: (0, br.default)(parseInt(o[2], 10), 255),
              aValue: (0, br.default)(parseFloat(o[3]), 1)
          }
      }

      function f9(e, t, r, n, i, a) {
          let {
              setStyle: s
          } = a;
          switch (n.actionTypeId) {
              case wn: {
                  let {
                      widthUnit: o = "",
                      heightUnit: l = ""
                  } = n.config, {
                      widthValue: f,
                      heightValue: u
                  } = r;
                  f !== void 0 && (o === _r && (o = "px"), Hr(e, zt, a), s(e, zt, f + o)), u !== void 0 && (l === _r && (l = "px"), Hr(e, Ht, a), s(e, Ht, u + l));
                  break
              }
              case qi: {
                  i9(e, r, n.config, a);
                  break
              }
              case Li: {
                  a9(e, r, n.config, a);
                  break
              }
              case On:
              case Mn:
              case Rn: {
                  let o = Rh[n.actionTypeId],
                      l = Math.round(r.rValue),
                      f = Math.round(r.gValue),
                      u = Math.round(r.bValue),
                      c = r.aValue;
                  Hr(e, o, a), s(e, o, c >= 1 ? `rgb(${l},${f},${u})` : `rgba(${l},${f},${u},${c})`);
                  break
              }
              default: {
                  let {
                      unit: o = ""
                  } = n.config;
                  Hr(e, i, a), s(e, i, r.value + o);
                  break
              }
          }
      }

      function p9(e, t, r) {
          let {
              setStyle: n
          } = r;
          switch (t.actionTypeId) {
              case Ls: {
                  let {
                      value: i
                  } = t.config;
                  i === C8 && rt.IS_BROWSER_ENV ? n(e, Fs, rt.FLEX_PREFIXED) : n(e, Fs, i);
                  return
              }
          }
      }

      function Hr(e, t, r) {
          if (!rt.IS_BROWSER_ENV) return;
          let n = yT[t];
          if (!n) return;
          let {
              getStyle: i,
              setStyle: a
          } = r, s = i(e, xn);
          if (!s) {
              a(e, xn, n);
              return
          }
          let o = s.split(Di)
              .map(gT);
          o.indexOf(n) === -1 && a(e, xn, o.concat(n)
              .join(Di))
      }

      function bT(e, t, r) {
          if (!rt.IS_BROWSER_ENV) return;
          let n = yT[t];
          if (!n) return;
          let {
              getStyle: i,
              setStyle: a
          } = r, s = i(e, xn);
          !s || s.indexOf(n) === -1 || a(e, xn, s.split(Di)
              .map(gT)
              .filter(o => o !== n)
              .join(Di))
      }

      function d9({
          store: e,
          elementApi: t
      }) {
          let {
              ixData: r
          } = e.getState(), {
              events: n = {},
              actionLists: i = {}
          } = r;
          Object.keys(n)
              .forEach(a => {
                  let s = n[a],
                      {
                          config: o
                      } = s.action,
                      {
                          actionListId: l
                      } = o,
                      f = i[l];
                  f && hT({
                      actionList: f,
                      event: s,
                      elementApi: t
                  })
              }), Object.keys(i)
              .forEach(a => {
                  hT({
                      actionList: i[a],
                      elementApi: t
                  })
              })
      }

      function hT({
          actionList: e = {},
          event: t,
          elementApi: r
      }) {
          let {
              actionItemGroups: n,
              continuousParameterGroups: i
          } = e;
          n && n.forEach(a => {
              cT({
                  actionGroup: a,
                  event: t,
                  elementApi: r
              })
          }), i && i.forEach(a => {
              let {
                  continuousActionGroups: s
              } = a;
              s.forEach(o => {
                  cT({
                      actionGroup: o,
                      event: t,
                      elementApi: r
                  })
              })
          })
      }

      function cT({
          actionGroup: e,
          event: t,
          elementApi: r
      }) {
          let {
              actionItems: n
          } = e;
          n.forEach(i => {
              let {
                  actionTypeId: a,
                  config: s
              } = i, o;
              (0, jt.isPluginType)(a) ? o = l => (0, jt.clearPlugin)(a)(l, i): o = _T({
                      effect: v9,
                      actionTypeId: a,
                      elementApi: r
                  }), Dh({
                      config: s,
                      event: t,
                      elementApi: r
                  })
                  .forEach(o)
          })
      }

      function m9(e, t, r) {
          let {
              setStyle: n,
              getStyle: i
          } = r, {
              actionTypeId: a
          } = t;
          if (a === wn) {
              let {
                  config: s
              } = t;
              s.widthUnit === _r && n(e, zt, ""), s.heightUnit === _r && n(e, Ht, "")
          }
          i(e, xn) && _T({
              effect: bT,
              actionTypeId: a,
              elementApi: r
          })(e)
      }
      var _T = ({
          effect: e,
          actionTypeId: t,
          elementApi: r
      }) => n => {
          switch (t) {
              case An:
              case Pn:
              case Cn:
              case Fi:
                  e(n, rt.TRANSFORM_PREFIXED, r);
                  break;
              case qi:
                  e(n, Mi, r);
                  break;
              case Li:
                  e(n, Ri, r);
                  break;
              case vT:
                  e(n, Ds, r);
                  break;
              case wn:
                  e(n, zt, r), e(n, Ht, r);
                  break;
              case On:
              case Mn:
              case Rn:
                  e(n, Rh[t], r);
                  break;
              case Ls:
                  e(n, Fs, r);
                  break
          }
      };

      function v9(e, t, r) {
          let {
              setStyle: n
          } = r;
          bT(e, t, r), n(e, t, ""), t === rt.TRANSFORM_PREFIXED && n(e, rt.TRANSFORM_STYLE_PREFIXED, "")
      }

      function ST(e) {
          let t = 0,
              r = 0;
          return e.forEach((n, i) => {
              let {
                  config: a
              } = n, s = a.delay + a.duration;
              s >= t && (t = s, r = i)
          }), r
      }

      function g9(e, t) {
          let {
              actionItemGroups: r,
              useFirstGroupAsInitialState: n
          } = e, {
              actionItem: i,
              verboseTimeElapsed: a = 0
          } = t, s = 0, o = 0;
          return r.forEach((l, f) => {
              if (n && f === 0) return;
              let {
                  actionItems: u
              } = l, c = u[ST(u)], {
                  config: v,
                  actionTypeId: d
              } = c;
              i.id === c.id && (o = s + a);
              let p = ET(d) === Oh ? 0 : v.duration;
              s += v.delay + p
          }), s > 0 ? (0, y8.optimizeFloat)(o / s) : 0
      }

      function y9({
          actionList: e,
          actionItemId: t,
          rawData: r
      }) {
          let {
              actionItemGroups: n,
              continuousParameterGroups: i
          } = e, a = [], s = o => (a.push((0, aT.mergeIn)(o, ["config"], {
              delay: 0,
              duration: 0
          })), o.id === t);
          return n && n.some(({
              actionItems: o
          }) => o.some(s)), i && i.some(o => {
              let {
                  continuousActionGroups: l
              } = o;
              return l.some(({
                  actionItems: f
              }) => f.some(s))
          }), (0, aT.setIn)(r, ["actionLists"], {
              [e.id]: {
                  id: e.id,
                  actionItemGroups: [{
                      actionItems: a
                  }]
              }
          })
      }

      function E9(e, {
          basedOn: t
      }) {
          return e === zr.EventTypeConsts.SCROLLING_IN_VIEW && (t === zr.EventBasedOn.ELEMENT || t == null) || e === zr.EventTypeConsts.MOUSE_MOVE && t === zr.EventBasedOn.ELEMENT
      }

      function b9(e, t) {
          return e + D8 + t
      }

      function _9(e, t) {
          return t == null ? !0 : e.indexOf(t) !== -1
      }

      function S9(e, t) {
          return (0, fT.default)(e && e.sort(), t && t.sort())
      }

      function I9(e) {
          if (typeof e == "string") return e;
          if (e.pluginElement && e.objectId) return e.pluginElement + Ph + e.objectId;
          if (e.objectId) return e.objectId;
          let {
              id: t = "",
              selector: r = "",
              useEventTarget: n = ""
          } = e;
          return t + Ph + r + Ph + n
      }
  });
  var jr = E(nt => {
      "use strict";
      var Dn = Vr()
          .default;
      Object.defineProperty(nt, "__esModule", {
          value: !0
      });
      nt.IX2VanillaUtils = nt.IX2VanillaPlugins = nt.IX2ElementsReducer = nt.IX2Easings = nt.IX2EasingUtils = nt.IX2BrowserSupport = void 0;
      var T9 = Dn(xs());
      nt.IX2BrowserSupport = T9;
      var x9 = Dn(gh());
      nt.IX2Easings = x9;
      var A9 = Dn(Eh());
      nt.IX2EasingUtils = A9;
      var P9 = Dn(wI());
      nt.IX2ElementsReducer = P9;
      var C9 = Dn(Th());
      nt.IX2VanillaPlugins = C9;
      var w9 = Dn(IT());
      nt.IX2VanillaUtils = w9
  });
  var PT = E(Ns => {
      "use strict";
      Object.defineProperty(Ns, "__esModule", {
          value: !0
      });
      Ns.ixInstances = void 0;
      var TT = st(),
          xT = jr(),
          Fn = In(),
          {
              IX2_RAW_DATA_IMPORTED: O9,
              IX2_SESSION_STOPPED: M9,
              IX2_INSTANCE_ADDED: R9,
              IX2_INSTANCE_STARTED: D9,
              IX2_INSTANCE_REMOVED: F9,
              IX2_ANIMATION_FRAME_CHANGED: q9
          } = TT.IX2EngineActionTypes,
          {
              optimizeFloat: ks,
              applyEasing: AT,
              createBezierEasing: L9
          } = xT.IX2EasingUtils,
          {
              RENDER_GENERAL: k9
          } = TT.IX2EngineConstants,
          {
              getItemConfigByKey: qh,
              getRenderType: N9,
              getStyleProp: B9
          } = xT.IX2VanillaUtils,
          V9 = (e, t) => {
              let {
                  position: r,
                  parameterId: n,
                  actionGroups: i,
                  destinationKeys: a,
                  smoothing: s,
                  restingValue: o,
                  actionTypeId: l,
                  customEasingFn: f,
                  skipMotion: u,
                  skipToValue: c
              } = e, {
                  parameters: v
              } = t.payload, d = Math.max(1 - s, .01), p = v[n];
              p == null && (d = 1, p = o);
              let m = Math.max(p, 0) || 0,
                  h = ks(m - r),
                  g = u ? c : ks(r + h * d),
                  y = g * 100;
              if (g === r && e.current) return e;
              let b, _, I, C;
              for (let O = 0, {
                      length: L
                  } = i; O < L; O++) {
                  let {
                      keyframe: D,
                      actionItems: A
                  } = i[O];
                  if (O === 0 && (b = A[0]), y >= D) {
                      b = A[0];
                      let q = i[O + 1],
                          w = q && y !== D;
                      _ = w ? q.actionItems[0] : null, w && (I = D / 100, C = (q.keyframe - D) / 100)
                  }
              }
              let x = {};
              if (b && !_)
                  for (let O = 0, {
                          length: L
                      } = a; O < L; O++) {
                      let D = a[O];
                      x[D] = qh(l, D, b.config)
                  } else if (b && _ && I !== void 0 && C !== void 0) {
                      let O = (g - I) / C,
                          L = b.config.easing,
                          D = AT(L, O, f);
                      for (let A = 0, {
                              length: q
                          } = a; A < q; A++) {
                          let w = a[A],
                              F = qh(l, w, b.config),
                              W = (qh(l, w, _.config) - F) * D + F;
                          x[w] = W
                      }
                  } return (0, Fn.merge)(e, {
                  position: g,
                  current: x
              })
          },
          G9 = (e, t) => {
              let {
                  active: r,
                  origin: n,
                  start: i,
                  immediate: a,
                  renderType: s,
                  verbose: o,
                  actionItem: l,
                  destination: f,
                  destinationKeys: u,
                  pluginDuration: c,
                  instanceDelay: v,
                  customEasingFn: d,
                  skipMotion: p
              } = e, m = l.config.easing, {
                  duration: h,
                  delay: g
              } = l.config;
              c != null && (h = c), g = v ?? g, s === k9 ? h = 0 : (a || p) && (h = g = 0);
              let {
                  now: y
              } = t.payload;
              if (r && n) {
                  let b = y - (i + g);
                  if (o) {
                      let O = y - i,
                          L = h + g,
                          D = ks(Math.min(Math.max(0, O / L), 1));
                      e = (0, Fn.set)(e, "verboseTimeElapsed", L * D)
                  }
                  if (b < 0) return e;
                  let _ = ks(Math.min(Math.max(0, b / h), 1)),
                      I = AT(m, _, d),
                      C = {},
                      x = null;
                  return u.length && (x = u.reduce((O, L) => {
                      let D = f[L],
                          A = parseFloat(n[L]) || 0,
                          w = (parseFloat(D) - A) * I + A;
                      return O[L] = w, O
                  }, {})), C.current = x, C.position = _, _ === 1 && (C.active = !1, C.complete = !0), (0, Fn.merge)(e, C)
              }
              return e
          },
          z9 = (e = Object.freeze({}), t) => {
              switch (t.type) {
                  case O9:
                      return t.payload.ixInstances || Object.freeze({});
                  case M9:
                      return Object.freeze({});
                  case R9: {
                      let {
                          instanceId: r,
                          elementId: n,
                          actionItem: i,
                          eventId: a,
                          eventTarget: s,
                          eventStateKey: o,
                          actionListId: l,
                          groupIndex: f,
                          isCarrier: u,
                          origin: c,
                          destination: v,
                          immediate: d,
                          verbose: p,
                          continuous: m,
                          parameterId: h,
                          actionGroups: g,
                          smoothing: y,
                          restingValue: b,
                          pluginInstance: _,
                          pluginDuration: I,
                          instanceDelay: C,
                          skipMotion: x,
                          skipToValue: O
                      } = t.payload, {
                              actionTypeId: L
                          } = i, D = N9(L), A = B9(D, L), q = Object.keys(v)
                          .filter(F => v[F] != null && typeof v[F] != "string"), {
                              easing: w
                          } = i.config;
                      return (0, Fn.set)(e, r, {
                          id: r,
                          elementId: n,
                          active: !1,
                          position: 0,
                          start: 0,
                          origin: c,
                          destination: v,
                          destinationKeys: q,
                          immediate: d,
                          verbose: p,
                          current: null,
                          actionItem: i,
                          actionTypeId: L,
                          eventId: a,
                          eventTarget: s,
                          eventStateKey: o,
                          actionListId: l,
                          groupIndex: f,
                          renderType: D,
                          isCarrier: u,
                          styleProp: A,
                          continuous: m,
                          parameterId: h,
                          actionGroups: g,
                          smoothing: y,
                          restingValue: b,
                          pluginInstance: _,
                          pluginDuration: I,
                          instanceDelay: C,
                          skipMotion: x,
                          skipToValue: O,
                          customEasingFn: Array.isArray(w) && w.length === 4 ? L9(w) : void 0
                      })
                  }
                  case D9: {
                      let {
                          instanceId: r,
                          time: n
                      } = t.payload;
                      return (0, Fn.mergeIn)(e, [r], {
                          active: !0,
                          complete: !1,
                          start: n
                      })
                  }
                  case F9: {
                      let {
                          instanceId: r
                      } = t.payload;
                      if (!e[r]) return e;
                      let n = {},
                          i = Object.keys(e),
                          {
                              length: a
                          } = i;
                      for (let s = 0; s < a; s++) {
                          let o = i[s];
                          o !== r && (n[o] = e[o])
                      }
                      return n
                  }
                  case q9: {
                      let r = e,
                          n = Object.keys(e),
                          {
                              length: i
                          } = n;
                      for (let a = 0; a < i; a++) {
                          let s = n[a],
                              o = e[s],
                              l = o.continuous ? V9 : G9;
                          r = (0, Fn.set)(r, s, l(o, t))
                      }
                      return r
                  }
                  default:
                      return e
              }
          };
      Ns.ixInstances = z9
  });
  var CT = E(Bs => {
      "use strict";
      Object.defineProperty(Bs, "__esModule", {
          value: !0
      });
      Bs.ixParameters = void 0;
      var H9 = st(),
          {
              IX2_RAW_DATA_IMPORTED: j9,
              IX2_SESSION_STOPPED: W9,
              IX2_PARAMETER_CHANGED: U9
          } = H9.IX2EngineActionTypes,
          X9 = (e = {}, t) => {
              switch (t.type) {
                  case j9:
                      return t.payload.ixParameters || {};
                  case W9:
                      return {};
                  case U9: {
                      let {
                          key: r,
                          value: n
                      } = t.payload;
                      return e[r] = n, e
                  }
                  default:
                      return e
              }
          };
      Bs.ixParameters = X9
  });
  var wT = E(Vs => {
      "use strict";
      Object.defineProperty(Vs, "__esModule", {
          value: !0
      });
      Vs.default = void 0;
      var $9 = oh(),
          K9 = XS(),
          Y9 = fI(),
          Q9 = dI(),
          Z9 = jr(),
          J9 = PT(),
          e7 = CT(),
          {
              ixElements: t7
          } = Z9.IX2ElementsReducer,
          r7 = (0, $9.combineReducers)({
              ixData: K9.ixData,
              ixRequest: Y9.ixRequest,
              ixSession: Q9.ixSession,
              ixElements: t7,
              ixInstances: J9.ixInstances,
              ixParameters: e7.ixParameters
          });
      Vs.default = r7
  });
  var OT = E((Gue, ki) => {
      function n7(e, t) {
          if (e == null) return {};
          var r = {},
              n = Object.keys(e),
              i, a;
          for (a = 0; a < n.length; a++) i = n[a], !(t.indexOf(i) >= 0) && (r[i] = e[i]);
          return r
      }
      ki.exports = n7, ki.exports.__esModule = !0, ki.exports.default = ki.exports
  });
  var RT = E((zue, MT) => {
      var i7 = sr(),
          a7 = ze(),
          s7 = $t(),
          o7 = "[object String]";

      function l7(e) {
          return typeof e == "string" || !a7(e) && s7(e) && i7(e) == o7
      }
      MT.exports = l7
  });
  var FT = E((Hue, DT) => {
      var u7 = Go(),
          h7 = u7("length");
      DT.exports = h7
  });
  var LT = E((jue, qT) => {
      var c7 = "\\ud800-\\udfff",
          f7 = "\\u0300-\\u036f",
          p7 = "\\ufe20-\\ufe2f",
          d7 = "\\u20d0-\\u20ff",
          m7 = f7 + p7 + d7,
          v7 = "\\ufe0e\\ufe0f",
          g7 = "\\u200d",
          y7 = RegExp("[" + g7 + c7 + m7 + v7 + "]");

      function E7(e) {
          return y7.test(e)
      }
      qT.exports = E7
  });
  var WT = E((Wue, jT) => {
      var NT = "\\ud800-\\udfff",
          b7 = "\\u0300-\\u036f",
          _7 = "\\ufe20-\\ufe2f",
          S7 = "\\u20d0-\\u20ff",
          I7 = b7 + _7 + S7,
          T7 = "\\ufe0e\\ufe0f",
          x7 = "[" + NT + "]",
          Lh = "[" + I7 + "]",
          kh = "\\ud83c[\\udffb-\\udfff]",
          A7 = "(?:" + Lh + "|" + kh + ")",
          BT = "[^" + NT + "]",
          VT = "(?:\\ud83c[\\udde6-\\uddff]){2}",
          GT = "[\\ud800-\\udbff][\\udc00-\\udfff]",
          P7 = "\\u200d",
          zT = A7 + "?",
          HT = "[" + T7 + "]?",
          C7 = "(?:" + P7 + "(?:" + [BT, VT, GT].join("|") + ")" + HT + zT + ")*",
          w7 = HT + zT + C7,
          O7 = "(?:" + [BT + Lh + "?", Lh, VT, GT, x7].join("|") + ")",
          kT = RegExp(kh + "(?=" + kh + ")|" + O7 + w7, "g");

      function M7(e) {
          for (var t = kT.lastIndex = 0; kT.test(e);) ++t;
          return t
      }
      jT.exports = M7
  });
  var XT = E((Uue, UT) => {
      var R7 = FT(),
          D7 = LT(),
          F7 = WT();

      function q7(e) {
          return D7(e) ? F7(e) : R7(e)
      }
      UT.exports = q7
  });
  var KT = E((Xue, $T) => {
      var L7 = ra(),
          k7 = na(),
          N7 = Cr(),
          B7 = RT(),
          V7 = XT(),
          G7 = "[object Map]",
          z7 = "[object Set]";

      function H7(e) {
          if (e == null) return 0;
          if (N7(e)) return B7(e) ? V7(e) : e.length;
          var t = k7(e);
          return t == G7 || t == z7 ? e.size : L7(e)
              .length
      }
      $T.exports = H7
  });
  var QT = E(($ue, YT) => {
      var j7 = "Expected a function";

      function W7(e) {
          if (typeof e != "function") throw new TypeError(j7);
          return function() {
              var t = arguments;
              switch (t.length) {
                  case 0:
                      return !e.call(this);
                  case 1:
                      return !e.call(this, t[0]);
                  case 2:
                      return !e.call(this, t[0], t[1]);
                  case 3:
                      return !e.call(this, t[0], t[1], t[2])
              }
              return !e.apply(this, t)
          }
      }
      YT.exports = W7
  });
  var Nh = E((Kue, ZT) => {
      var U7 = or(),
          X7 = function() {
              try {
                  var e = U7(Object, "defineProperty");
                  return e({}, "", {}), e
              } catch {}
          }();
      ZT.exports = X7
  });
  var Bh = E((Yue, ex) => {
      var JT = Nh();

      function $7(e, t, r) {
          t == "__proto__" && JT ? JT(e, t, {
              configurable: !0,
              enumerable: !0,
              value: r,
              writable: !0
          }) : e[t] = r
      }
      ex.exports = $7
  });
  var rx = E((Que, tx) => {
      var K7 = Bh(),
          Y7 = Ui(),
          Q7 = Object.prototype,
          Z7 = Q7.hasOwnProperty;

      function J7(e, t, r) {
          var n = e[t];
          (!(Z7.call(e, t) && Y7(n, r)) || r === void 0 && !(t in e)) && K7(e, t, r)
      }
      tx.exports = J7
  });
  var ax = E((Zue, ix) => {
      var eY = rx(),
          tY = Yn(),
          rY = Zi(),
          nx = qt(),
          nY = an();

      function iY(e, t, r, n) {
          if (!nx(e)) return e;
          t = tY(t, e);
          for (var i = -1, a = t.length, s = a - 1, o = e; o != null && ++i < a;) {
              var l = nY(t[i]),
                  f = r;
              if (l === "__proto__" || l === "constructor" || l === "prototype") return e;
              if (i != s) {
                  var u = o[l];
                  f = n ? n(u, l, o) : void 0, f === void 0 && (f = nx(u) ? u : rY(t[i + 1]) ? [] : {})
              }
              eY(o, l, f), o = o[l]
          }
          return e
      }
      ix.exports = iY
  });
  var ox = E((Jue, sx) => {
      var aY = sa(),
          sY = ax(),
          oY = Yn();

      function lY(e, t, r) {
          for (var n = -1, i = t.length, a = {}; ++n < i;) {
              var s = t[n],
                  o = aY(e, s);
              r(o, s) && sY(a, oY(s, e), o)
          }
          return a
      }
      sx.exports = lY
  });
  var ux = E((ehe, lx) => {
      var uY = Yi(),
          hY = $u(),
          cY = xo(),
          fY = To(),
          pY = Object.getOwnPropertySymbols,
          dY = pY ? function(e) {
              for (var t = []; e;) uY(t, cY(e)), e = hY(e);
              return t
          } : fY;
      lx.exports = dY
  });
  var cx = E((the, hx) => {
      function mY(e) {
          var t = [];
          if (e != null)
              for (var r in Object(e)) t.push(r);
          return t
      }
      hx.exports = mY
  });
  var px = E((rhe, fx) => {
      var vY = qt(),
          gY = ta(),
          yY = cx(),
          EY = Object.prototype,
          bY = EY.hasOwnProperty;

      function _Y(e) {
          if (!vY(e)) return yY(e);
          var t = gY(e),
              r = [];
          for (var n in e) n == "constructor" && (t || !bY.call(e, n)) || r.push(n);
          return r
      }
      fx.exports = _Y
  });
  var mx = E((nhe, dx) => {
      var SY = Po(),
          IY = px(),
          TY = Cr();

      function xY(e) {
          return TY(e) ? SY(e, !0) : IY(e)
      }
      dx.exports = xY
  });
  var gx = E((ihe, vx) => {
      var AY = Io(),
          PY = ux(),
          CY = mx();

      function wY(e) {
          return AY(e, CY, PY)
      }
      vx.exports = wY
  });
  var Ex = E((ahe, yx) => {
      var OY = Vo(),
          MY = lr(),
          RY = ox(),
          DY = gx();

      function FY(e, t) {
          if (e == null) return {};
          var r = OY(DY(e), function(n) {
              return [n]
          });
          return t = MY(t), RY(e, r, function(n, i) {
              return t(n, i[0])
          })
      }
      yx.exports = FY
  });
  var _x = E((she, bx) => {
      var qY = lr(),
          LY = QT(),
          kY = Ex();

      function NY(e, t) {
          return kY(e, LY(qY(t)))
      }
      bx.exports = NY
  });
  var Ix = E((ohe, Sx) => {
      var BY = ra(),
          VY = na(),
          GY = jn(),
          zY = ze(),
          HY = Cr(),
          jY = Qi(),
          WY = ta(),
          UY = ea(),
          XY = "[object Map]",
          $Y = "[object Set]",
          KY = Object.prototype,
          YY = KY.hasOwnProperty;

      function QY(e) {
          if (e == null) return !0;
          if (HY(e) && (zY(e) || typeof e == "string" || typeof e.splice == "function" || jY(e) || UY(e) || GY(e))) return !e.length;
          var t = VY(e);
          if (t == XY || t == $Y) return !e.size;
          if (WY(e)) return !BY(e)
              .length;
          for (var r in e)
              if (YY.call(e, r)) return !1;
          return !0
      }
      Sx.exports = QY
  });
  var xx = E((lhe, Tx) => {
      var ZY = Bh(),
          JY = xh(),
          eQ = lr();

      function tQ(e, t) {
          var r = {};
          return t = eQ(t, 3), JY(e, function(n, i, a) {
              ZY(r, i, t(n, i, a))
          }), r
      }
      Tx.exports = tQ
  });
  var Px = E((uhe, Ax) => {
      function rQ(e, t) {
          for (var r = -1, n = e == null ? 0 : e.length; ++r < n && t(e[r], r, e) !== !1;);
          return e
      }
      Ax.exports = rQ
  });
  var wx = E((hhe, Cx) => {
      var nQ = la();

      function iQ(e) {
          return typeof e == "function" ? e : nQ
      }
      Cx.exports = iQ
  });
  var Mx = E((che, Ox) => {
      var aQ = Px(),
          sQ = Ah(),
          oQ = wx(),
          lQ = ze();

      function uQ(e, t) {
          var r = lQ(e) ? aQ : sQ;
          return r(e, oQ(t))
      }
      Ox.exports = uQ
  });
  var Dx = E((fhe, Rx) => {
      var hQ = It(),
          cQ = function() {
              return hQ.Date.now()
          };
      Rx.exports = cQ
  });
  var Lx = E((phe, qx) => {
      var fQ = qt(),
          Vh = Dx(),
          Fx = ua(),
          pQ = "Expected a function",
          dQ = Math.max,
          mQ = Math.min;

      function vQ(e, t, r) {
          var n, i, a, s, o, l, f = 0,
              u = !1,
              c = !1,
              v = !0;
          if (typeof e != "function") throw new TypeError(pQ);
          t = Fx(t) || 0, fQ(r) && (u = !!r.leading, c = "maxWait" in r, a = c ? dQ(Fx(r.maxWait) || 0, t) : a, v = "trailing" in r ? !!r.trailing : v);

          function d(C) {
              var x = n,
                  O = i;
              return n = i = void 0, f = C, s = e.apply(O, x), s
          }

          function p(C) {
              return f = C, o = setTimeout(g, t), u ? d(C) : s
          }

          function m(C) {
              var x = C - l,
                  O = C - f,
                  L = t - x;
              return c ? mQ(L, a - O) : L
          }

          function h(C) {
              var x = C - l,
                  O = C - f;
              return l === void 0 || x >= t || x < 0 || c && O >= a
          }

          function g() {
              var C = Vh();
              if (h(C)) return y(C);
              o = setTimeout(g, m(C))
          }

          function y(C) {
              return o = void 0, v && n ? d(C) : (n = i = void 0, s)
          }

          function b() {
              o !== void 0 && clearTimeout(o), f = 0, n = l = i = o = void 0
          }

          function _() {
              return o === void 0 ? s : y(Vh())
          }

          function I() {
              var C = Vh(),
                  x = h(C);
              if (n = arguments, i = this, l = C, x) {
                  if (o === void 0) return p(l);
                  if (c) return clearTimeout(o), o = setTimeout(g, t), d(l)
              }
              return o === void 0 && (o = setTimeout(g, t)), s
          }
          return I.cancel = b, I.flush = _, I
      }
      qx.exports = vQ
  });
  var Nx = E((dhe, kx) => {
      var gQ = Lx(),
          yQ = qt(),
          EQ = "Expected a function";

      function bQ(e, t, r) {
          var n = !0,
              i = !0;
          if (typeof e != "function") throw new TypeError(EQ);
          return yQ(r) && (n = "leading" in r ? !!r.leading : n, i = "trailing" in r ? !!r.trailing : i), gQ(e, t, {
              leading: n,
              maxWait: t,
              trailing: i
          })
      }
      kx.exports = bQ
  });
  var Gs = E(ce => {
      "use strict";
      var _Q = ut()
          .default;
      Object.defineProperty(ce, "__esModule", {
          value: !0
      });
      ce.viewportWidthChanged = ce.testFrameRendered = ce.stopRequested = ce.sessionStopped = ce.sessionStarted = ce.sessionInitialized = ce.rawDataImported = ce.previewRequested = ce.playbackRequested = ce.parameterChanged = ce.mediaQueriesDefined = ce.instanceStarted = ce.instanceRemoved = ce.instanceAdded = ce.eventStateChanged = ce.eventListenerAdded = ce.elementStateChanged = ce.clearRequested = ce.animationFrameChanged = ce.actionListPlaybackChanged = void 0;
      var Bx = _Q(Pr()),
          Vx = st(),
          SQ = jr(),
          {
              IX2_RAW_DATA_IMPORTED: IQ,
              IX2_SESSION_INITIALIZED: TQ,
              IX2_SESSION_STARTED: xQ,
              IX2_SESSION_STOPPED: AQ,
              IX2_PREVIEW_REQUESTED: PQ,
              IX2_PLAYBACK_REQUESTED: CQ,
              IX2_STOP_REQUESTED: wQ,
              IX2_CLEAR_REQUESTED: OQ,
              IX2_EVENT_LISTENER_ADDED: MQ,
              IX2_TEST_FRAME_RENDERED: RQ,
              IX2_EVENT_STATE_CHANGED: DQ,
              IX2_ANIMATION_FRAME_CHANGED: FQ,
              IX2_PARAMETER_CHANGED: qQ,
              IX2_INSTANCE_ADDED: LQ,
              IX2_INSTANCE_STARTED: kQ,
              IX2_INSTANCE_REMOVED: NQ,
              IX2_ELEMENT_STATE_CHANGED: BQ,
              IX2_ACTION_LIST_PLAYBACK_CHANGED: VQ,
              IX2_VIEWPORT_WIDTH_CHANGED: GQ,
              IX2_MEDIA_QUERIES_DEFINED: zQ
          } = Vx.IX2EngineActionTypes,
          {
              reifyState: HQ
          } = SQ.IX2VanillaUtils,
          jQ = e => ({
              type: IQ,
              payload: (0, Bx.default)({}, HQ(e))
          });
      ce.rawDataImported = jQ;
      var WQ = ({
          hasBoundaryNodes: e,
          reducedMotion: t
      }) => ({
          type: TQ,
          payload: {
              hasBoundaryNodes: e,
              reducedMotion: t
          }
      });
      ce.sessionInitialized = WQ;
      var UQ = () => ({
          type: xQ
      });
      ce.sessionStarted = UQ;
      var XQ = () => ({
          type: AQ
      });
      ce.sessionStopped = XQ;
      var $Q = ({
          rawData: e,
          defer: t
      }) => ({
          type: PQ,
          payload: {
              defer: t,
              rawData: e
          }
      });
      ce.previewRequested = $Q;
      var KQ = ({
          actionTypeId: e = Vx.ActionTypeConsts.GENERAL_START_ACTION,
          actionListId: t,
          actionItemId: r,
          eventId: n,
          allowEvents: i,
          immediate: a,
          testManual: s,
          verbose: o,
          rawData: l
      }) => ({
          type: CQ,
          payload: {
              actionTypeId: e,
              actionListId: t,
              actionItemId: r,
              testManual: s,
              eventId: n,
              allowEvents: i,
              immediate: a,
              verbose: o,
              rawData: l
          }
      });
      ce.playbackRequested = KQ;
      var YQ = e => ({
          type: wQ,
          payload: {
              actionListId: e
          }
      });
      ce.stopRequested = YQ;
      var QQ = () => ({
          type: OQ
      });
      ce.clearRequested = QQ;
      var ZQ = (e, t) => ({
          type: MQ,
          payload: {
              target: e,
              listenerParams: t
          }
      });
      ce.eventListenerAdded = ZQ;
      var JQ = (e = 1) => ({
          type: RQ,
          payload: {
              step: e
          }
      });
      ce.testFrameRendered = JQ;
      var eZ = (e, t) => ({
          type: DQ,
          payload: {
              stateKey: e,
              newState: t
          }
      });
      ce.eventStateChanged = eZ;
      var tZ = (e, t) => ({
          type: FQ,
          payload: {
              now: e,
              parameters: t
          }
      });
      ce.animationFrameChanged = tZ;
      var rZ = (e, t) => ({
          type: qQ,
          payload: {
              key: e,
              value: t
          }
      });
      ce.parameterChanged = rZ;
      var nZ = e => ({
          type: LQ,
          payload: (0, Bx.default)({}, e)
      });
      ce.instanceAdded = nZ;
      var iZ = (e, t) => ({
          type: kQ,
          payload: {
              instanceId: e,
              time: t
          }
      });
      ce.instanceStarted = iZ;
      var aZ = e => ({
          type: NQ,
          payload: {
              instanceId: e
          }
      });
      ce.instanceRemoved = aZ;
      var sZ = (e, t, r, n) => ({
          type: BQ,
          payload: {
              elementId: e,
              actionTypeId: t,
              current: r,
              actionItem: n
          }
      });
      ce.elementStateChanged = sZ;
      var oZ = ({
          actionListId: e,
          isPlaying: t
      }) => ({
          type: VQ,
          payload: {
              actionListId: e,
              isPlaying: t
          }
      });
      ce.actionListPlaybackChanged = oZ;
      var lZ = ({
          width: e,
          mediaQueries: t
      }) => ({
          type: GQ,
          payload: {
              width: e,
              mediaQueries: t
          }
      });
      ce.viewportWidthChanged = lZ;
      var uZ = () => ({
          type: zQ
      });
      ce.mediaQueriesDefined = uZ
  });
  var Hx = E(Ue => {
      "use strict";
      Object.defineProperty(Ue, "__esModule", {
          value: !0
      });
      Ue.elementContains = _Z;
      Ue.getChildElements = IZ;
      Ue.getClosestElement = void 0;
      Ue.getProperty = vZ;
      Ue.getQuerySelector = yZ;
      Ue.getRefType = AZ;
      Ue.getSiblingElements = TZ;
      Ue.getStyle = mZ;
      Ue.getValidDocument = EZ;
      Ue.isSiblingNode = SZ;
      Ue.matchSelector = gZ;
      Ue.queryDocument = bZ;
      Ue.setStyle = dZ;
      var hZ = jr(),
          cZ = st(),
          {
              ELEMENT_MATCHES: Gh
          } = hZ.IX2BrowserSupport,
          {
              IX2_ID_DELIMITER: Gx,
              HTML_ELEMENT: fZ,
              PLAIN_OBJECT: pZ,
              WF_PAGE: zx
          } = cZ.IX2EngineConstants;

      function dZ(e, t, r) {
          e.style[t] = r
      }

      function mZ(e, t) {
          return e.style[t]
      }

      function vZ(e, t) {
          return e[t]
      }

      function gZ(e) {
          return t => t[Gh](e)
      }

      function yZ({
          id: e,
          selector: t
      }) {
          if (e) {
              let r = e;
              if (e.indexOf(Gx) !== -1) {
                  let n = e.split(Gx),
                      i = n[0];
                  if (r = n[1], i !== document.documentElement.getAttribute(zx)) return null
              }
              return `[data-w-id="${r}"], [data-w-id^="${r}_instance"]`
          }
          return t
      }

      function EZ(e) {
          return e == null || e === document.documentElement.getAttribute(zx) ? document : null
      }

      function bZ(e, t) {
          return Array.prototype.slice.call(document.querySelectorAll(t ? e + " " + t : e))
      }

      function _Z(e, t) {
          return e.contains(t)
      }

      function SZ(e, t) {
          return e !== t && e.parentNode === t.parentNode
      }

      function IZ(e) {
          let t = [];
          for (let r = 0, {
                  length: n
              } = e || []; r < n; r++) {
              let {
                  children: i
              } = e[r], {
                  length: a
              } = i;
              if (a)
                  for (let s = 0; s < a; s++) t.push(i[s])
          }
          return t
      }

      function TZ(e = []) {
          let t = [],
              r = [];
          for (let n = 0, {
                  length: i
              } = e; n < i; n++) {
              let {
                  parentNode: a
              } = e[n];
              if (!a || !a.children || !a.children.length || r.indexOf(a) !== -1) continue;
              r.push(a);
              let s = a.firstElementChild;
              for (; s != null;) e.indexOf(s) === -1 && t.push(s), s = s.nextElementSibling
          }
          return t
      }
      var xZ = Element.prototype.closest ? (e, t) => document.documentElement.contains(e) ? e.closest(t) : null : (e, t) => {
          if (!document.documentElement.contains(e)) return null;
          let r = e;
          do {
              if (r[Gh] && r[Gh](t)) return r;
              r = r.parentNode
          } while (r != null);
          return null
      };
      Ue.getClosestElement = xZ;

      function AZ(e) {
          return e != null && typeof e == "object" ? e instanceof Element ? fZ : pZ : null
      }
  });
  var zh = E((ghe, Wx) => {
      var PZ = qt(),
          jx = Object.create,
          CZ = function() {
              function e() {}
              return function(t) {
                  if (!PZ(t)) return {};
                  if (jx) return jx(t);
                  e.prototype = t;
                  var r = new e;
                  return e.prototype = void 0, r
              }
          }();
      Wx.exports = CZ
  });
  var zs = E((yhe, Ux) => {
      function wZ() {}
      Ux.exports = wZ
  });
  var js = E((Ehe, Xx) => {
      var OZ = zh(),
          MZ = zs();

      function Hs(e, t) {
          this.__wrapped__ = e, this.__actions__ = [], this.__chain__ = !!t, this.__index__ = 0, this.__values__ = void 0
      }
      Hs.prototype = OZ(MZ.prototype);
      Hs.prototype.constructor = Hs;
      Xx.exports = Hs
  });
  var Qx = E((bhe, Yx) => {
      var $x = Qr(),
          RZ = jn(),
          DZ = ze(),
          Kx = $x ? $x.isConcatSpreadable : void 0;

      function FZ(e) {
          return DZ(e) || RZ(e) || !!(Kx && e && e[Kx])
      }
      Yx.exports = FZ
  });
  var eA = E((_he, Jx) => {
      var qZ = Yi(),
          LZ = Qx();

      function Zx(e, t, r, n, i) {
          var a = -1,
              s = e.length;
          for (r || (r = LZ), i || (i = []); ++a < s;) {
              var o = e[a];
              t > 0 && r(o) ? t > 1 ? Zx(o, t - 1, r, n, i) : qZ(i, o) : n || (i[i.length] = o)
          }
          return i
      }
      Jx.exports = Zx
  });
  var rA = E((She, tA) => {
      var kZ = eA();

      function NZ(e) {
          var t = e == null ? 0 : e.length;
          return t ? kZ(e, 1) : []
      }
      tA.exports = NZ
  });
  var iA = E((Ihe, nA) => {
      function BZ(e, t, r) {
          switch (r.length) {
              case 0:
                  return e.call(t);
              case 1:
                  return e.call(t, r[0]);
              case 2:
                  return e.call(t, r[0], r[1]);
              case 3:
                  return e.call(t, r[0], r[1], r[2])
          }
          return e.apply(t, r)
      }
      nA.exports = BZ
  });
  var oA = E((The, sA) => {
      var VZ = iA(),
          aA = Math.max;

      function GZ(e, t, r) {
          return t = aA(t === void 0 ? e.length - 1 : t, 0),
              function() {
                  for (var n = arguments, i = -1, a = aA(n.length - t, 0), s = Array(a); ++i < a;) s[i] = n[t + i];
                  i = -1;
                  for (var o = Array(t + 1); ++i < t;) o[i] = n[i];
                  return o[t] = r(s), VZ(e, this, o)
              }
      }
      sA.exports = GZ
  });
  var uA = E((xhe, lA) => {
      function zZ(e) {
          return function() {
              return e
          }
      }
      lA.exports = zZ
  });
  var fA = E((Ahe, cA) => {
      var HZ = uA(),
          hA = Nh(),
          jZ = la(),
          WZ = hA ? function(e, t) {
              return hA(e, "toString", {
                  configurable: !0,
                  enumerable: !1,
                  value: HZ(t),
                  writable: !0
              })
          } : jZ;
      cA.exports = WZ
  });
  var dA = E((Phe, pA) => {
      var UZ = 800,
          XZ = 16,
          $Z = Date.now;

      function KZ(e) {
          var t = 0,
              r = 0;
          return function() {
              var n = $Z(),
                  i = XZ - (n - r);
              if (r = n, i > 0) {
                  if (++t >= UZ) return arguments[0]
              } else t = 0;
              return e.apply(void 0, arguments)
          }
      }
      pA.exports = KZ
  });
  var vA = E((Che, mA) => {
      var YZ = fA(),
          QZ = dA(),
          ZZ = QZ(YZ);
      mA.exports = ZZ
  });
  var yA = E((whe, gA) => {
      var JZ = rA(),
          eJ = oA(),
          tJ = vA();

      function rJ(e) {
          return tJ(eJ(e, void 0, JZ), e + "")
      }
      gA.exports = rJ
  });
  var _A = E((Ohe, bA) => {
      var EA = wo(),
          nJ = EA && new EA;
      bA.exports = nJ
  });
  var IA = E((Mhe, SA) => {
      function iJ() {}
      SA.exports = iJ
  });
  var Hh = E((Rhe, xA) => {
      var TA = _A(),
          aJ = IA(),
          sJ = TA ? function(e) {
              return TA.get(e)
          } : aJ;
      xA.exports = sJ
  });
  var PA = E((Dhe, AA) => {
      var oJ = {};
      AA.exports = oJ
  });
  var jh = E((Fhe, wA) => {
      var CA = PA(),
          lJ = Object.prototype,
          uJ = lJ.hasOwnProperty;

      function hJ(e) {
          for (var t = e.name + "", r = CA[t], n = uJ.call(CA, t) ? r.length : 0; n--;) {
              var i = r[n],
                  a = i.func;
              if (a == null || a == e) return i.name
          }
          return t
      }
      wA.exports = hJ
  });
  var Us = E((qhe, OA) => {
      var cJ = zh(),
          fJ = zs(),
          pJ = 4294967295;

      function Ws(e) {
          this.__wrapped__ = e, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = pJ, this.__views__ = []
      }
      Ws.prototype = cJ(fJ.prototype);
      Ws.prototype.constructor = Ws;
      OA.exports = Ws
  });
  var RA = E((Lhe, MA) => {
      function dJ(e, t) {
          var r = -1,
              n = e.length;
          for (t || (t = Array(n)); ++r < n;) t[r] = e[r];
          return t
      }
      MA.exports = dJ
  });
  var FA = E((khe, DA) => {
      var mJ = Us(),
          vJ = js(),
          gJ = RA();

      function yJ(e) {
          if (e instanceof mJ) return e.clone();
          var t = new vJ(e.__wrapped__, e.__chain__);
          return t.__actions__ = gJ(e.__actions__), t.__index__ = e.__index__, t.__values__ = e.__values__, t
      }
      DA.exports = yJ
  });
  var kA = E((Nhe, LA) => {
      var EJ = Us(),
          qA = js(),
          bJ = zs(),
          _J = ze(),
          SJ = $t(),
          IJ = FA(),
          TJ = Object.prototype,
          xJ = TJ.hasOwnProperty;

      function Xs(e) {
          if (SJ(e) && !_J(e) && !(e instanceof EJ)) {
              if (e instanceof qA) return e;
              if (xJ.call(e, "__wrapped__")) return IJ(e)
          }
          return new qA(e)
      }
      Xs.prototype = bJ.prototype;
      Xs.prototype.constructor = Xs;
      LA.exports = Xs
  });
  var BA = E((Bhe, NA) => {
      var AJ = Us(),
          PJ = Hh(),
          CJ = jh(),
          wJ = kA();

      function OJ(e) {
          var t = CJ(e),
              r = wJ[t];
          if (typeof r != "function" || !(t in AJ.prototype)) return !1;
          if (e === r) return !0;
          var n = PJ(r);
          return !!n && e === n[0]
      }
      NA.exports = OJ
  });
  var HA = E((Vhe, zA) => {
      var VA = js(),
          MJ = yA(),
          RJ = Hh(),
          Wh = jh(),
          DJ = ze(),
          GA = BA(),
          FJ = "Expected a function",
          qJ = 8,
          LJ = 32,
          kJ = 128,
          NJ = 256;

      function BJ(e) {
          return MJ(function(t) {
              var r = t.length,
                  n = r,
                  i = VA.prototype.thru;
              for (e && t.reverse(); n--;) {
                  var a = t[n];
                  if (typeof a != "function") throw new TypeError(FJ);
                  if (i && !s && Wh(a) == "wrapper") var s = new VA([], !0)
              }
              for (n = s ? n : r; ++n < r;) {
                  a = t[n];
                  var o = Wh(a),
                      l = o == "wrapper" ? RJ(a) : void 0;
                  l && GA(l[0]) && l[1] == (kJ | qJ | LJ | NJ) && !l[4].length && l[9] == 1 ? s = s[Wh(l[0])].apply(s, l[3]) : s = a.length == 1 && GA(a) ? s[o]() : s.thru(a)
              }
              return function() {
                  var f = arguments,
                      u = f[0];
                  if (s && f.length == 1 && DJ(u)) return s.plant(u)
                      .value();
                  for (var c = 0, v = r ? t[c].apply(this, f) : u; ++c < r;) v = t[c].call(this, v);
                  return v
              }
          })
      }
      zA.exports = BJ
  });
  var WA = E((Ghe, jA) => {
      var VJ = HA(),
          GJ = VJ();
      jA.exports = GJ
  });
  var XA = E((zhe, UA) => {
      function zJ(e, t, r) {
          return e === e && (r !== void 0 && (e = e <= r ? e : r), t !== void 0 && (e = e >= t ? e : t)), e
      }
      UA.exports = zJ
  });
  var KA = E((Hhe, $A) => {
      var HJ = XA(),
          Uh = ua();

      function jJ(e, t, r) {
          return r === void 0 && (r = t, t = void 0), r !== void 0 && (r = Uh(r), r = r === r ? r : 0), t !== void 0 && (t = Uh(t), t = t === t ? t : 0), HJ(Uh(e), t, r)
      }
      $A.exports = jJ
  });
  var pP = E(Zs => {
      "use strict";
      var Qs = ut()
          .default;
      Object.defineProperty(Zs, "__esModule", {
          value: !0
      });
      Zs.default = void 0;
      var yt = Qs(Pr()),
          WJ = Qs(WA()),
          UJ = Qs(oa()),
          XJ = Qs(KA()),
          Wr = st(),
          Xh = Qh(),
          $s = Gs(),
          $J = jr(),
          {
              MOUSE_CLICK: KJ,
              MOUSE_SECOND_CLICK: YJ,
              MOUSE_DOWN: QJ,
              MOUSE_UP: ZJ,
              MOUSE_OVER: JJ,
              MOUSE_OUT: eee,
              DROPDOWN_CLOSE: tee,
              DROPDOWN_OPEN: ree,
              SLIDER_ACTIVE: nee,
              SLIDER_INACTIVE: iee,
              TAB_ACTIVE: aee,
              TAB_INACTIVE: see,
              NAVBAR_CLOSE: oee,
              NAVBAR_OPEN: lee,
              MOUSE_MOVE: uee,
              PAGE_SCROLL_DOWN: iP,
              SCROLL_INTO_VIEW: aP,
              SCROLL_OUT_OF_VIEW: hee,
              PAGE_SCROLL_UP: cee,
              SCROLLING_IN_VIEW: fee,
              PAGE_FINISH: sP,
              ECOMMERCE_CART_CLOSE: pee,
              ECOMMERCE_CART_OPEN: dee,
              PAGE_START: oP,
              PAGE_SCROLL: mee
          } = Wr.EventTypeConsts,
          $h = "COMPONENT_ACTIVE",
          lP = "COMPONENT_INACTIVE",
          {
              COLON_DELIMITER: YA
          } = Wr.IX2EngineConstants,
          {
              getNamespacedParameterId: QA
          } = $J.IX2VanillaUtils,
          uP = e => t => typeof t == "object" && e(t) ? !0 : t,
          Bi = uP(({
              element: e,
              nativeEvent: t
          }) => e === t.target),
          vee = uP(({
              element: e,
              nativeEvent: t
          }) => e.contains(t.target)),
          Wt = (0, WJ.default)([Bi, vee]),
          hP = (e, t) => {
              if (t) {
                  let {
                      ixData: r
                  } = e.getState(), {
                      events: n
                  } = r, i = n[t];
                  if (i && !yee[i.eventTypeId]) return i
              }
              return null
          },
          gee = ({
              store: e,
              event: t
          }) => {
              let {
                  action: r
              } = t, {
                  autoStopEventId: n
              } = r.config;
              return !!hP(e, n)
          },
          lt = ({
              store: e,
              event: t,
              element: r,
              eventStateKey: n
          }, i) => {
              let {
                  action: a,
                  id: s
              } = t, {
                  actionListId: o,
                  autoStopEventId: l
              } = a.config, f = hP(e, l);
              return f && (0, Xh.stopActionGroup)({
                  store: e,
                  eventId: l,
                  eventTarget: r,
                  eventStateKey: l + YA + n.split(YA)[1],
                  actionListId: (0, UJ.default)(f, "action.config.actionListId")
              }), (0, Xh.stopActionGroup)({
                  store: e,
                  eventId: s,
                  eventTarget: r,
                  eventStateKey: n,
                  actionListId: o
              }), (0, Xh.startActionGroup)({
                  store: e,
                  eventId: s,
                  eventTarget: r,
                  eventStateKey: n,
                  actionListId: o
              }), i
          },
          wt = (e, t) => (r, n) => e(r, n) === !0 ? t(r, n) : n,
          Vi = {
              handler: wt(Wt, lt)
          },
          cP = (0, yt.default)({}, Vi, {
              types: [$h, lP].join(" ")
          }),
          Kh = [{
              target: window,
              types: "resize orientationchange",
              throttle: !0
          }, {
              target: document,
              types: "scroll wheel readystatechange IX2_PAGE_UPDATE",
              throttle: !0
          }],
          ZA = "mouseover mouseout",
          Yh = {
              types: Kh
          },
          yee = {
              PAGE_START: oP,
              PAGE_FINISH: sP
          },
          Ni = (() => {
              let e = window.pageXOffset !== void 0,
                  r = document.compatMode === "CSS1Compat" ? document.documentElement : document.body;
              return () => ({
                  scrollLeft: e ? window.pageXOffset : r.scrollLeft,
                  scrollTop: e ? window.pageYOffset : r.scrollTop,
                  stiffScrollTop: (0, XJ.default)(e ? window.pageYOffset : r.scrollTop, 0, r.scrollHeight - window.innerHeight),
                  scrollWidth: r.scrollWidth,
                  scrollHeight: r.scrollHeight,
                  clientWidth: r.clientWidth,
                  clientHeight: r.clientHeight,
                  innerWidth: window.innerWidth,
                  innerHeight: window.innerHeight
              })
          })(),
          Eee = (e, t) => !(e.left > t.right || e.right < t.left || e.top > t.bottom || e.bottom < t.top),
          bee = ({
              element: e,
              nativeEvent: t
          }) => {
              let {
                  type: r,
                  target: n,
                  relatedTarget: i
              } = t, a = e.contains(n);
              if (r === "mouseover" && a) return !0;
              let s = e.contains(i);
              return !!(r === "mouseout" && a && s)
          },
          _ee = e => {
              let {
                  element: t,
                  event: {
                      config: r
                  }
              } = e, {
                  clientWidth: n,
                  clientHeight: i
              } = Ni(), a = r.scrollOffsetValue, l = r.scrollOffsetUnit === "PX" ? a : i * (a || 0) / 100;
              return Eee(t.getBoundingClientRect(), {
                  left: 0,
                  top: l,
                  right: n,
                  bottom: i - l
              })
          },
          fP = e => (t, r) => {
              let {
                  type: n
              } = t.nativeEvent, i = [$h, lP].indexOf(n) !== -1 ? n === $h : r.isActive, a = (0, yt.default)({}, r, {
                  isActive: i
              });
              return (!r || a.isActive !== r.isActive) && e(t, a) || a
          },
          JA = e => (t, r) => {
              let n = {
                  elementHovered: bee(t)
              };
              return (r ? n.elementHovered !== r.elementHovered : n.elementHovered) && e(t, n) || n
          },
          See = e => (t, r) => {
              let n = (0, yt.default)({}, r, {
                  elementVisible: _ee(t)
              });
              return (r ? n.elementVisible !== r.elementVisible : n.elementVisible) && e(t, n) || n
          },
          eP = e => (t, r = {}) => {
              let {
                  stiffScrollTop: n,
                  scrollHeight: i,
                  innerHeight: a
              } = Ni(), {
                  event: {
                      config: s,
                      eventTypeId: o
                  }
              } = t, {
                  scrollOffsetValue: l,
                  scrollOffsetUnit: f
              } = s, u = f === "PX", c = i - a, v = Number((n / c)
                  .toFixed(2));
              if (r && r.percentTop === v) return r;
              let d = (u ? l : a * (l || 0) / 100) / c,
                  p, m, h = 0;
              r && (p = v > r.percentTop, m = r.scrollingDown !== p, h = m ? v : r.anchorTop);
              let g = o === iP ? v >= h + d : v <= h - d,
                  y = (0, yt.default)({}, r, {
                      percentTop: v,
                      inBounds: g,
                      anchorTop: h,
                      scrollingDown: p
                  });
              return r && g && (m || y.inBounds !== r.inBounds) && e(t, y) || y
          },
          Iee = (e, t) => e.left > t.left && e.left < t.right && e.top > t.top && e.top < t.bottom,
          Tee = e => (t, r) => {
              let n = {
                  finished: document.readyState === "complete"
              };
              return n.finished && !(r && r.finshed) && e(t), n
          },
          xee = e => (t, r) => {
              let n = {
                  started: !0
              };
              return r || e(t), n
          },
          tP = e => (t, r = {
              clickCount: 0
          }) => {
              let n = {
                  clickCount: r.clickCount % 2 + 1
              };
              return n.clickCount !== r.clickCount && e(t, n) || n
          },
          Ks = (e = !0) => (0, yt.default)({}, cP, {
              handler: wt(e ? Wt : Bi, fP((t, r) => r.isActive ? Vi.handler(t, r) : r))
          }),
          Ys = (e = !0) => (0, yt.default)({}, cP, {
              handler: wt(e ? Wt : Bi, fP((t, r) => r.isActive ? r : Vi.handler(t, r)))
          }),
          rP = (0, yt.default)({}, Yh, {
              handler: See((e, t) => {
                  let {
                      elementVisible: r
                  } = t, {
                      event: n,
                      store: i
                  } = e, {
                      ixData: a
                  } = i.getState(), {
                      events: s
                  } = a;
                  return !s[n.action.config.autoStopEventId] && t.triggered ? t : n.eventTypeId === aP === r ? (lt(e), (0, yt.default)({}, t, {
                      triggered: !0
                  })) : t
              })
          }),
          nP = .05,
          Aee = {
              [nee]: Ks(),
              [iee]: Ys(),
              [ree]: Ks(),
              [tee]: Ys(),
              [lee]: Ks(!1),
              [oee]: Ys(!1),
              [aee]: Ks(),
              [see]: Ys(),
              [dee]: {
                  types: "ecommerce-cart-open",
                  handler: wt(Wt, lt)
              },
              [pee]: {
                  types: "ecommerce-cart-close",
                  handler: wt(Wt, lt)
              },
              [KJ]: {
                  types: "click",
                  handler: wt(Wt, tP((e, {
                      clickCount: t
                  }) => {
                      gee(e) ? t === 1 && lt(e) : lt(e)
                  }))
              },
              [YJ]: {
                  types: "click",
                  handler: wt(Wt, tP((e, {
                      clickCount: t
                  }) => {
                      t === 2 && lt(e)
                  }))
              },
              [QJ]: (0, yt.default)({}, Vi, {
                  types: "mousedown"
              }),
              [ZJ]: (0, yt.default)({}, Vi, {
                  types: "mouseup"
              }),
              [JJ]: {
                  types: ZA,
                  handler: wt(Wt, JA((e, t) => {
                      t.elementHovered && lt(e)
                  }))
              },
              [eee]: {
                  types: ZA,
                  handler: wt(Wt, JA((e, t) => {
                      t.elementHovered || lt(e)
                  }))
              },
              [uee]: {
                  types: "mousemove mouseout scroll",
                  handler: ({
                      store: e,
                      element: t,
                      eventConfig: r,
                      nativeEvent: n,
                      eventStateKey: i
                  }, a = {
                      clientX: 0,
                      clientY: 0,
                      pageX: 0,
                      pageY: 0
                  }) => {
                      let {
                          basedOn: s,
                          selectedAxis: o,
                          continuousParameterGroupId: l,
                          reverse: f,
                          restingState: u = 0
                      } = r, {
                          clientX: c = a.clientX,
                          clientY: v = a.clientY,
                          pageX: d = a.pageX,
                          pageY: p = a.pageY
                      } = n, m = o === "X_AXIS", h = n.type === "mouseout", g = u / 100, y = l, b = !1;
                      switch (s) {
                          case Wr.EventBasedOn.VIEWPORT: {
                              g = m ? Math.min(c, window.innerWidth) / window.innerWidth : Math.min(v, window.innerHeight) / window.innerHeight;
                              break
                          }
                          case Wr.EventBasedOn.PAGE: {
                              let {
                                  scrollLeft: _,
                                  scrollTop: I,
                                  scrollWidth: C,
                                  scrollHeight: x
                              } = Ni();
                              g = m ? Math.min(_ + d, C) / C : Math.min(I + p, x) / x;
                              break
                          }
                          case Wr.EventBasedOn.ELEMENT:
                          default: {
                              y = QA(i, l);
                              let _ = n.type.indexOf("mouse") === 0;
                              if (_ && Wt({
                                      element: t,
                                      nativeEvent: n
                                  }) !== !0) break;
                              let I = t.getBoundingClientRect(),
                                  {
                                      left: C,
                                      top: x,
                                      width: O,
                                      height: L
                                  } = I;
                              if (!_ && !Iee({
                                      left: c,
                                      top: v
                                  }, I)) break;
                              b = !0, g = m ? (c - C) / O : (v - x) / L;
                              break
                          }
                      }
                      return h && (g > 1 - nP || g < nP) && (g = Math.round(g)), (s !== Wr.EventBasedOn.ELEMENT || b || b !== a.elementHovered) && (g = f ? 1 - g : g, e.dispatch((0, $s.parameterChanged)(y, g))), {
                          elementHovered: b,
                          clientX: c,
                          clientY: v,
                          pageX: d,
                          pageY: p
                      }
                  }
              },
              [mee]: {
                  types: Kh,
                  handler: ({
                      store: e,
                      eventConfig: t
                  }) => {
                      let {
                          continuousParameterGroupId: r,
                          reverse: n
                      } = t, {
                          scrollTop: i,
                          scrollHeight: a,
                          clientHeight: s
                      } = Ni(), o = i / (a - s);
                      o = n ? 1 - o : o, e.dispatch((0, $s.parameterChanged)(r, o))
                  }
              },
              [fee]: {
                  types: Kh,
                  handler: ({
                      element: e,
                      store: t,
                      eventConfig: r,
                      eventStateKey: n
                  }, i = {
                      scrollPercent: 0
                  }) => {
                      let {
                          scrollLeft: a,
                          scrollTop: s,
                          scrollWidth: o,
                          scrollHeight: l,
                          clientHeight: f
                      } = Ni(), {
                          basedOn: u,
                          selectedAxis: c,
                          continuousParameterGroupId: v,
                          startsEntering: d,
                          startsExiting: p,
                          addEndOffset: m,
                          addStartOffset: h,
                          addOffsetValue: g = 0,
                          endOffsetValue: y = 0
                      } = r, b = c === "X_AXIS";
                      if (u === Wr.EventBasedOn.VIEWPORT) {
                          let _ = b ? a / o : s / l;
                          return _ !== i.scrollPercent && t.dispatch((0, $s.parameterChanged)(v, _)), {
                              scrollPercent: _
                          }
                      } else {
                          let _ = QA(n, v),
                              I = e.getBoundingClientRect(),
                              C = (h ? g : 0) / 100,
                              x = (m ? y : 0) / 100;
                          C = d ? C : 1 - C, x = p ? x : 1 - x;
                          let O = I.top + Math.min(I.height * C, f),
                              D = I.top + I.height * x - O,
                              A = Math.min(f + D, l),
                              w = Math.min(Math.max(0, f - O), A) / A;
                          return w !== i.scrollPercent && t.dispatch((0, $s.parameterChanged)(_, w)), {
                              scrollPercent: w
                          }
                      }
                  }
              },
              [aP]: rP,
              [hee]: rP,
              [iP]: (0, yt.default)({}, Yh, {
                  handler: eP((e, t) => {
                      t.scrollingDown && lt(e)
                  })
              }),
              [cee]: (0, yt.default)({}, Yh, {
                  handler: eP((e, t) => {
                      t.scrollingDown || lt(e)
                  })
              }),
              [sP]: {
                  types: "readystatechange IX2_PAGE_UPDATE",
                  handler: wt(Bi, Tee(lt))
              },
              [oP]: {
                  types: "readystatechange IX2_PAGE_UPDATE",
                  handler: wt(Bi, xee(lt))
              }
          };
      Zs.default = Aee
  });
  var Qh = E(Ir => {
      "use strict";
      var Mt = ut()
          .default,
          Pee = Vr()
          .default;
      Object.defineProperty(Ir, "__esModule", {
          value: !0
      });
      Ir.observeRequests = nte;
      Ir.startActionGroup = nc;
      Ir.startEngine = no;
      Ir.stopActionGroup = rc;
      Ir.stopAllActionGroups = SP;
      Ir.stopEngine = io;
      var Cee = Mt(Pr()),
          wee = Mt(OT()),
          Oee = Mt(mh()),
          Sr = Mt(oa()),
          Mee = Mt(KT()),
          Ree = Mt(_x()),
          Dee = Mt(Ix()),
          Fee = Mt(xx()),
          Gi = Mt(Mx()),
          qee = Mt(Nx()),
          Ot = st(),
          vP = jr(),
          De = Gs(),
          ke = Pee(Hx()),
          Lee = Mt(pP()),
          kee = ["store", "computedStyle"],
          Nee = Object.keys(Ot.QuickEffectIds),
          Zh = e => Nee.includes(e),
          {
              COLON_DELIMITER: Jh,
              BOUNDARY_SELECTOR: Js,
              HTML_ELEMENT: gP,
              RENDER_GENERAL: Bee,
              W_MOD_IX: dP
          } = Ot.IX2EngineConstants,
          {
              getAffectedElements: eo,
              getElementId: Vee,
              getDestinationValues: ec,
              observeStore: Ur,
              getInstanceId: Gee,
              renderHTMLElement: zee,
              clearAllStyles: yP,
              getMaxDurationItemIndex: Hee,
              getComputedStyle: jee,
              getInstanceOrigin: Wee,
              reduceListToGroup: Uee,
              shouldNamespaceEventParameter: Xee,
              getNamespacedParameterId: $ee,
              shouldAllowMediaQuery: to,
              cleanupHTMLElement: Kee,
              clearObjectCache: Yee,
              stringifyTarget: Qee,
              mediaQueriesEqual: Zee,
              shallowEqual: Jee
          } = vP.IX2VanillaUtils,
          {
              isPluginType: ro,
              createPluginInstance: tc,
              getPluginDuration: ete
          } = vP.IX2VanillaPlugins,
          mP = navigator.userAgent,
          tte = mP.match(/iPad/i) || mP.match(/iPhone/),
          rte = 12;

      function nte(e) {
          Ur({
              store: e,
              select: ({
                  ixRequest: t
              }) => t.preview,
              onChange: ste
          }), Ur({
              store: e,
              select: ({
                  ixRequest: t
              }) => t.playback,
              onChange: ote
          }), Ur({
              store: e,
              select: ({
                  ixRequest: t
              }) => t.stop,
              onChange: lte
          }), Ur({
              store: e,
              select: ({
                  ixRequest: t
              }) => t.clear,
              onChange: ute
          })
      }

      function ite(e) {
          Ur({
              store: e,
              select: ({
                  ixSession: t
              }) => t.mediaQueryKey,
              onChange: () => {
                  io(e), yP({
                      store: e,
                      elementApi: ke
                  }), no({
                      store: e,
                      allowEvents: !0
                  }), EP()
              }
          })
      }

      function ate(e, t) {
          let r = Ur({
              store: e,
              select: ({
                  ixSession: n
              }) => n.tick,
              onChange: n => {
                  t(n), r()
              }
          })
      }

      function ste({
          rawData: e,
          defer: t
      }, r) {
          let n = () => {
              no({
                  store: r,
                  rawData: e,
                  allowEvents: !0
              }), EP()
          };
          t ? setTimeout(n, 0) : n()
      }

      function EP() {
          document.dispatchEvent(new CustomEvent("IX2_PAGE_UPDATE"))
      }

      function ote(e, t) {
          let {
              actionTypeId: r,
              actionListId: n,
              actionItemId: i,
              eventId: a,
              allowEvents: s,
              immediate: o,
              testManual: l,
              verbose: f = !0
          } = e, {
              rawData: u
          } = e;
          if (n && i && u && o) {
              let c = u.actionLists[n];
              c && (u = Uee({
                  actionList: c,
                  actionItemId: i,
                  rawData: u
              }))
          }
          if (no({
                  store: t,
                  rawData: u,
                  allowEvents: s,
                  testManual: l
              }), n && r === Ot.ActionTypeConsts.GENERAL_START_ACTION || Zh(r)) {
              rc({
                  store: t,
                  actionListId: n
              }), _P({
                  store: t,
                  actionListId: n,
                  eventId: a
              });
              let c = nc({
                  store: t,
                  eventId: a,
                  actionListId: n,
                  immediate: o,
                  verbose: f
              });
              f && c && t.dispatch((0, De.actionListPlaybackChanged)({
                  actionListId: n,
                  isPlaying: !o
              }))
          }
      }

      function lte({
          actionListId: e
      }, t) {
          e ? rc({
              store: t,
              actionListId: e
          }) : SP({
              store: t
          }), io(t)
      }

      function ute(e, t) {
          io(t), yP({
              store: t,
              elementApi: ke
          })
      }

      function no({
          store: e,
          rawData: t,
          allowEvents: r,
          testManual: n
      }) {
          let {
              ixSession: i
          } = e.getState();
          t && e.dispatch((0, De.rawDataImported)(t)), i.active || (e.dispatch((0, De.sessionInitialized)({
              hasBoundaryNodes: !!document.querySelector(Js),
              reducedMotion: document.body.hasAttribute("data-wf-ix-vacation") && window.matchMedia("(prefers-reduced-motion)")
                  .matches
          })), r && (mte(e), hte(), e.getState()
              .ixSession.hasDefinedMediaQueries && ite(e)), e.dispatch((0, De.sessionStarted)()), cte(e, n))
      }

      function hte() {
          let {
              documentElement: e
          } = document;
          e.className.indexOf(dP) === -1 && (e.className += ` ${dP}`)
      }

      function cte(e, t) {
          let r = n => {
              let {
                  ixSession: i,
                  ixParameters: a
              } = e.getState();
              i.active && (e.dispatch((0, De.animationFrameChanged)(n, a)), t ? ate(e, r) : requestAnimationFrame(r))
          };
          r(window.performance.now())
      }

      function io(e) {
          let {
              ixSession: t
          } = e.getState();
          if (t.active) {
              let {
                  eventListeners: r
              } = t;
              r.forEach(fte), Yee(), e.dispatch((0, De.sessionStopped)())
          }
      }

      function fte({
          target: e,
          listenerParams: t
      }) {
          e.removeEventListener.apply(e, t)
      }

      function pte({
          store: e,
          eventStateKey: t,
          eventTarget: r,
          eventId: n,
          eventConfig: i,
          actionListId: a,
          parameterGroup: s,
          smoothing: o,
          restingValue: l
      }) {
          let {
              ixData: f,
              ixSession: u
          } = e.getState(), {
              events: c
          } = f, v = c[n], {
              eventTypeId: d
          } = v, p = {}, m = {}, h = [], {
              continuousActionGroups: g
          } = s, {
              id: y
          } = s;
          Xee(d, i) && (y = $ee(t, y));
          let b = u.hasBoundaryNodes && r ? ke.getClosestElement(r, Js) : null;
          g.forEach(_ => {
              let {
                  keyframe: I,
                  actionItems: C
              } = _;
              C.forEach(x => {
                  let {
                      actionTypeId: O
                  } = x, {
                      target: L
                  } = x.config;
                  if (!L) return;
                  let D = L.boundaryMode ? b : null,
                      A = Qee(L) + Jh + O;
                  if (m[A] = dte(m[A], I, x), !p[A]) {
                      p[A] = !0;
                      let {
                          config: q
                      } = x;
                      eo({
                              config: q,
                              event: v,
                              eventTarget: r,
                              elementRoot: D,
                              elementApi: ke
                          })
                          .forEach(w => {
                              h.push({
                                  element: w,
                                  key: A
                              })
                          })
                  }
              })
          }), h.forEach(({
              element: _,
              key: I
          }) => {
              let C = m[I],
                  x = (0, Sr.default)(C, "[0].actionItems[0]", {}),
                  {
                      actionTypeId: O
                  } = x,
                  L = ro(O) ? tc(O)(_, x) : null,
                  D = ec({
                      element: _,
                      actionItem: x,
                      elementApi: ke
                  }, L);
              ic({
                  store: e,
                  element: _,
                  eventId: n,
                  actionListId: a,
                  actionItem: x,
                  destination: D,
                  continuous: !0,
                  parameterId: y,
                  actionGroups: C,
                  smoothing: o,
                  restingValue: l,
                  pluginInstance: L
              })
          })
      }

      function dte(e = [], t, r) {
          let n = [...e],
              i;
          return n.some((a, s) => a.keyframe === t ? (i = s, !0) : !1), i == null && (i = n.length, n.push({
              keyframe: t,
              actionItems: []
          })), n[i].actionItems.push(r), n
      }

      function mte(e) {
          let {
              ixData: t
          } = e.getState(), {
              eventTypeMap: r
          } = t;
          bP(e), (0, Gi.default)(r, (i, a) => {
              let s = Lee.default[a];
              if (!s) {
                  console.warn(`IX2 event type not configured: ${a}`);
                  return
              }
              _te({
                  logic: s,
                  store: e,
                  events: i
              })
          });
          let {
              ixSession: n
          } = e.getState();
          n.eventListeners.length && gte(e)
      }
      var vte = ["resize", "orientationchange"];

      function gte(e) {
          let t = () => {
              bP(e)
          };
          vte.forEach(r => {
              window.addEventListener(r, t), e.dispatch((0, De.eventListenerAdded)(window, [r, t]))
          }), t()
      }

      function bP(e) {
          let {
              ixSession: t,
              ixData: r
          } = e.getState(), n = window.innerWidth;
          if (n !== t.viewportWidth) {
              let {
                  mediaQueries: i
              } = r;
              e.dispatch((0, De.viewportWidthChanged)({
                  width: n,
                  mediaQueries: i
              }))
          }
      }
      var yte = (e, t) => (0, Ree.default)((0, Fee.default)(e, t), Dee.default),
          Ete = (e, t) => {
              (0, Gi.default)(e, (r, n) => {
                  r.forEach((i, a) => {
                      let s = n + Jh + a;
                      t(i, n, s)
                  })
              })
          },
          bte = e => {
              let t = {
                  target: e.target,
                  targets: e.targets
              };
              return eo({
                  config: t,
                  elementApi: ke
              })
          };

      function _te({
          logic: e,
          store: t,
          events: r
      }) {
          Ste(r);
          let {
              types: n,
              handler: i
          } = e, {
              ixData: a
          } = t.getState(), {
              actionLists: s
          } = a, o = yte(r, bte);
          if (!(0, Mee.default)(o)) return;
          (0, Gi.default)(o, (c, v) => {
              let d = r[v],
                  {
                      action: p,
                      id: m,
                      mediaQueries: h = a.mediaQueryKeys
                  } = d,
                  {
                      actionListId: g
                  } = p.config;
              Zee(h, a.mediaQueryKeys) || t.dispatch((0, De.mediaQueriesDefined)()), p.actionTypeId === Ot.ActionTypeConsts.GENERAL_CONTINUOUS_ACTION && (Array.isArray(d.config) ? d.config : [d.config])
                  .forEach(b => {
                      let {
                          continuousParameterGroupId: _
                      } = b, I = (0, Sr.default)(s, `${g}.continuousParameterGroups`, []), C = (0, Oee.default)(I, ({
                          id: L
                      }) => L === _), x = (b.smoothing || 0) / 100, O = (b.restingState || 0) / 100;
                      C && c.forEach((L, D) => {
                          let A = m + Jh + D;
                          pte({
                              store: t,
                              eventStateKey: A,
                              eventTarget: L,
                              eventId: m,
                              eventConfig: b,
                              actionListId: g,
                              parameterGroup: C,
                              smoothing: x,
                              restingValue: O
                          })
                      })
                  }), (p.actionTypeId === Ot.ActionTypeConsts.GENERAL_START_ACTION || Zh(p.actionTypeId)) && _P({
                      store: t,
                      actionListId: g,
                      eventId: m
                  })
          });
          let l = c => {
                  let {
                      ixSession: v
                  } = t.getState();
                  Ete(o, (d, p, m) => {
                      let h = r[p],
                          g = v.eventState[m],
                          {
                              action: y,
                              mediaQueries: b = a.mediaQueryKeys
                          } = h;
                      if (!to(b, v.mediaQueryKey)) return;
                      let _ = (I = {}) => {
                          let C = i({
                              store: t,
                              element: d,
                              event: h,
                              eventConfig: I,
                              nativeEvent: c,
                              eventStateKey: m
                          }, g);
                          Jee(C, g) || t.dispatch((0, De.eventStateChanged)(m, C))
                      };
                      y.actionTypeId === Ot.ActionTypeConsts.GENERAL_CONTINUOUS_ACTION ? (Array.isArray(h.config) ? h.config : [h.config])
                          .forEach(_) : _()
                  })
              },
              f = (0, qee.default)(l, rte),
              u = ({
                  target: c = document,
                  types: v,
                  throttle: d
              }) => {
                  v.split(" ")
                      .filter(Boolean)
                      .forEach(p => {
                          let m = d ? f : l;
                          c.addEventListener(p, m), t.dispatch((0, De.eventListenerAdded)(c, [p, m]))
                      })
              };
          Array.isArray(n) ? n.forEach(u) : typeof n == "string" && u(e)
      }

      function Ste(e) {
          if (!tte) return;
          let t = {},
              r = "";
          for (let n in e) {
              let {
                  eventTypeId: i,
                  target: a
              } = e[n], s = ke.getQuerySelector(a);
              t[s] || (i === Ot.EventTypeConsts.MOUSE_CLICK || i === Ot.EventTypeConsts.MOUSE_SECOND_CLICK) && (t[s] = !0, r += s + "{cursor: pointer;touch-action: manipulation;}")
          }
          if (r) {
              let n = document.createElement("style");
              n.textContent = r, document.body.appendChild(n)
          }
      }

      function _P({
          store: e,
          actionListId: t,
          eventId: r
      }) {
          let {
              ixData: n,
              ixSession: i
          } = e.getState(), {
              actionLists: a,
              events: s
          } = n, o = s[r], l = a[t];
          if (l && l.useFirstGroupAsInitialState) {
              let f = (0, Sr.default)(l, "actionItemGroups[0].actionItems", []),
                  u = (0, Sr.default)(o, "mediaQueries", n.mediaQueryKeys);
              if (!to(u, i.mediaQueryKey)) return;
              f.forEach(c => {
                  var v;
                  let {
                      config: d,
                      actionTypeId: p
                  } = c, m = (d == null || (v = d.target) === null || v === void 0 ? void 0 : v.useEventTarget) === !0 ? {
                      target: o.target,
                      targets: o.targets
                  } : d, h = eo({
                      config: m,
                      event: o,
                      elementApi: ke
                  }), g = ro(p);
                  h.forEach(y => {
                      let b = g ? tc(p)(y, c) : null;
                      ic({
                          destination: ec({
                              element: y,
                              actionItem: c,
                              elementApi: ke
                          }, b),
                          immediate: !0,
                          store: e,
                          element: y,
                          eventId: r,
                          actionItem: c,
                          actionListId: t,
                          pluginInstance: b
                      })
                  })
              })
          }
      }

      function SP({
          store: e
      }) {
          let {
              ixInstances: t
          } = e.getState();
          (0, Gi.default)(t, r => {
              if (!r.continuous) {
                  let {
                      actionListId: n,
                      verbose: i
                  } = r;
                  ac(r, e), i && e.dispatch((0, De.actionListPlaybackChanged)({
                      actionListId: n,
                      isPlaying: !1
                  }))
              }
          })
      }

      function rc({
          store: e,
          eventId: t,
          eventTarget: r,
          eventStateKey: n,
          actionListId: i
      }) {
          let {
              ixInstances: a,
              ixSession: s
          } = e.getState(), o = s.hasBoundaryNodes && r ? ke.getClosestElement(r, Js) : null;
          (0, Gi.default)(a, l => {
              let f = (0, Sr.default)(l, "actionItem.config.target.boundaryMode"),
                  u = n ? l.eventStateKey === n : !0;
              if (l.actionListId === i && l.eventId === t && u) {
                  if (o && f && !ke.elementContains(o, l.element)) return;
                  ac(l, e), l.verbose && e.dispatch((0, De.actionListPlaybackChanged)({
                      actionListId: i,
                      isPlaying: !1
                  }))
              }
          })
      }

      function nc({
          store: e,
          eventId: t,
          eventTarget: r,
          eventStateKey: n,
          actionListId: i,
          groupIndex: a = 0,
          immediate: s,
          verbose: o
      }) {
          var l;
          let {
              ixData: f,
              ixSession: u
          } = e.getState(), {
              events: c
          } = f, v = c[t] || {}, {
              mediaQueries: d = f.mediaQueryKeys
          } = v, p = (0, Sr.default)(f, `actionLists.${i}`, {}), {
              actionItemGroups: m,
              useFirstGroupAsInitialState: h
          } = p;
          if (!m || !m.length) return !1;
          a >= m.length && (0, Sr.default)(v, "config.loop") && (a = 0), a === 0 && h && a++;
          let y = (a === 0 || a === 1 && h) && Zh((l = v.action) === null || l === void 0 ? void 0 : l.actionTypeId) ? v.config.delay : void 0,
              b = (0, Sr.default)(m, [a, "actionItems"], []);
          if (!b.length || !to(d, u.mediaQueryKey)) return !1;
          let _ = u.hasBoundaryNodes && r ? ke.getClosestElement(r, Js) : null,
              I = Hee(b),
              C = !1;
          return b.forEach((x, O) => {
              let {
                  config: L,
                  actionTypeId: D
              } = x, A = ro(D), {
                  target: q
              } = L;
              if (!q) return;
              let w = q.boundaryMode ? _ : null;
              eo({
                      config: L,
                      event: v,
                      eventTarget: r,
                      elementRoot: w,
                      elementApi: ke
                  })
                  .forEach((k, U) => {
                      let W = A ? tc(D)(k, x) : null,
                          S = A ? ete(D)(k, x) : null;
                      C = !0;
                      let R = I === O && U === 0,
                          V = jee({
                              element: k,
                              actionItem: x
                          }),
                          P = ec({
                              element: k,
                              actionItem: x,
                              elementApi: ke
                          }, W);
                      ic({
                          store: e,
                          element: k,
                          actionItem: x,
                          eventId: t,
                          eventTarget: r,
                          eventStateKey: n,
                          actionListId: i,
                          groupIndex: a,
                          isCarrier: R,
                          computedStyle: V,
                          destination: P,
                          immediate: s,
                          verbose: o,
                          pluginInstance: W,
                          pluginDuration: S,
                          instanceDelay: y
                      })
                  })
          }), C
      }

      function ic(e) {
          var t;
          let {
              store: r,
              computedStyle: n
          } = e, i = (0, wee.default)(e, kee), {
              element: a,
              actionItem: s,
              immediate: o,
              pluginInstance: l,
              continuous: f,
              restingValue: u,
              eventId: c
          } = i, v = !f, d = Gee(), {
              ixElements: p,
              ixSession: m,
              ixData: h
          } = r.getState(), g = Vee(p, a), {
              refState: y
          } = p[g] || {}, b = ke.getRefType(a), _ = m.reducedMotion && Ot.ReducedMotionTypes[s.actionTypeId], I;
          if (_ && f) switch ((t = h.events[c]) === null || t === void 0 ? void 0 : t.eventTypeId) {
              case Ot.EventTypeConsts.MOUSE_MOVE:
              case Ot.EventTypeConsts.MOUSE_MOVE_IN_VIEWPORT:
                  I = u;
                  break;
              default:
                  I = .5;
                  break
          }
          let C = Wee(a, y, n, s, ke, l);
          if (r.dispatch((0, De.instanceAdded)((0, Cee.default)({
                  instanceId: d,
                  elementId: g,
                  origin: C,
                  refType: b,
                  skipMotion: _,
                  skipToValue: I
              }, i))), IP(document.body, "ix2-animation-started", d), o) {
              Ite(r, d);
              return
          }
          Ur({
              store: r,
              select: ({
                  ixInstances: x
              }) => x[d],
              onChange: TP
          }), v && r.dispatch((0, De.instanceStarted)(d, m.tick))
      }

      function ac(e, t) {
          IP(document.body, "ix2-animation-stopping", {
              instanceId: e.id,
              state: t.getState()
          });
          let {
              elementId: r,
              actionItem: n
          } = e, {
              ixElements: i
          } = t.getState(), {
              ref: a,
              refType: s
          } = i[r] || {};
          s === gP && Kee(a, n, ke), t.dispatch((0, De.instanceRemoved)(e.id))
      }

      function IP(e, t, r) {
          let n = document.createEvent("CustomEvent");
          n.initCustomEvent(t, !0, !0, r), e.dispatchEvent(n)
      }

      function Ite(e, t) {
          let {
              ixParameters: r
          } = e.getState();
          e.dispatch((0, De.instanceStarted)(t, 0)), e.dispatch((0, De.animationFrameChanged)(performance.now(), r));
          let {
              ixInstances: n
          } = e.getState();
          TP(n[t], e)
      }

      function TP(e, t) {
          let {
              active: r,
              continuous: n,
              complete: i,
              elementId: a,
              actionItem: s,
              actionTypeId: o,
              renderType: l,
              current: f,
              groupIndex: u,
              eventId: c,
              eventTarget: v,
              eventStateKey: d,
              actionListId: p,
              isCarrier: m,
              styleProp: h,
              verbose: g,
              pluginInstance: y
          } = e, {
              ixData: b,
              ixSession: _
          } = t.getState(), {
              events: I
          } = b, C = I[c] || {}, {
              mediaQueries: x = b.mediaQueryKeys
          } = C;
          if (to(x, _.mediaQueryKey) && (n || r || i)) {
              if (f || l === Bee && i) {
                  t.dispatch((0, De.elementStateChanged)(a, o, f, s));
                  let {
                      ixElements: O
                  } = t.getState(), {
                      ref: L,
                      refType: D,
                      refState: A
                  } = O[a] || {}, q = A && A[o];
                  (D === gP || ro(o)) && zee(L, A, q, c, s, h, ke, l, y)
              }
              if (i) {
                  if (m) {
                      let O = nc({
                          store: t,
                          eventId: c,
                          eventTarget: v,
                          eventStateKey: d,
                          actionListId: p,
                          groupIndex: u + 1,
                          verbose: g
                      });
                      g && !O && t.dispatch((0, De.actionListPlaybackChanged)({
                          actionListId: p,
                          isPlaying: !1
                      }))
                  }
                  ac(e, t)
              }
          }
      }
  });
  var AP = E(ir => {
      "use strict";
      var Tte = Vr()
          .default,
          xte = ut()
          .default;
      Object.defineProperty(ir, "__esModule", {
          value: !0
      });
      ir.actions = void 0;
      ir.destroy = xP;
      ir.init = Ote;
      ir.setEnv = wte;
      ir.store = void 0;
      xS();
      var Ate = oh(),
          Pte = xte(wT()),
          sc = Qh(),
          Cte = Tte(Gs());
      ir.actions = Cte;
      var ao = (0, Ate.createStore)(Pte.default);
      ir.store = ao;

      function wte(e) {
          e() && (0, sc.observeRequests)(ao)
      }

      function Ote(e) {
          xP(), (0, sc.startEngine)({
              store: ao,
              rawData: e,
              allowEvents: !0
          })
      }

      function xP() {
          (0, sc.stopEngine)(ao)
      }
  });
  var OP = E((Xhe, wP) => {
      var PP = Xe(),
          CP = AP();
      CP.setEnv(PP.env);
      PP.define("ix2", wP.exports = function() {
          return CP
      })
  });
  var RP = E(($he, MP) => {
      var qn = Xe();
      qn.define("links", MP.exports = function(e, t) {
          var r = {},
              n = e(window),
              i, a = qn.env(),
              s = window.location,
              o = document.createElement("a"),
              l = "w--current",
              f = /index\.(html|php)$/,
              u = /\/$/,
              c, v;
          r.ready = r.design = r.preview = d;

          function d() {
              i = a && qn.env("design"), v = qn.env("slug") || s.pathname || "", qn.scroll.off(m), c = [];
              for (var g = document.links, y = 0; y < g.length; ++y) p(g[y]);
              c.length && (qn.scroll.on(m), m())
          }

          function p(g) {
              var y = i && g.getAttribute("href-disabled") || g.getAttribute("href");
              if (o.href = y, !(y.indexOf(":") >= 0)) {
                  var b = e(g);
                  if (o.hash.length > 1 && o.host + o.pathname === s.host + s.pathname) {
                      if (!/^#[a-zA-Z0-9\-\_]+$/.test(o.hash)) return;
                      var _ = e(o.hash);
                      _.length && c.push({
                          link: b,
                          sec: _,
                          active: !1
                      });
                      return
                  }
                  if (!(y === "#" || y === "")) {
                      var I = o.href === s.href || y === v || f.test(y) && u.test(v);
                      h(b, l, I)
                  }
              }
          }

          function m() {
              var g = n.scrollTop(),
                  y = n.height();
              t.each(c, function(b) {
                  var _ = b.link,
                      I = b.sec,
                      C = I.offset()
                      .top,
                      x = I.outerHeight(),
                      O = y * .5,
                      L = I.is(":visible") && C + x - O >= g && C + O <= g + y;
                  b.active !== L && (b.active = L, h(_, l, L))
              })
          }

          function h(g, y, b) {
              var _ = g.hasClass(y);
              b && _ || !b && !_ || (b ? g.addClass(y) : g.removeClass(y))
          }
          return r
      })
  });
  var FP = E((Khe, DP) => {
      var so = Xe();
      so.define("scroll", DP.exports = function(e) {
          var t = {
                  WF_CLICK_EMPTY: "click.wf-empty-link",
                  WF_CLICK_SCROLL: "click.wf-scroll"
              },
              r = window.location,
              n = p() ? null : window.history,
              i = e(window),
              a = e(document),
              s = e(document.body),
              o = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || function(q) {
                  window.setTimeout(q, 15)
              },
              l = so.env("editor") ? ".w-editor-body" : "body",
              f = "header, " + l + " > .header, " + l + " > .w-nav:not([data-no-scroll])",
              u = 'a[href="#"]',
              c = 'a[href*="#"]:not(.w-tab-link):not(' + u + ")",
              v = '.wf-force-outline-none[tabindex="-1"]:focus{outline:none;}',
              d = document.createElement("style");
          d.appendChild(document.createTextNode(v));

          function p() {
              try {
                  return !!window.frameElement
              } catch {
                  return !0
              }
          }
          var m = /^#[a-zA-Z0-9][\w:.-]*$/;

          function h(q) {
              return m.test(q.hash) && q.host + q.pathname === r.host + r.pathname
          }
          let g = typeof window.matchMedia == "function" && window.matchMedia("(prefers-reduced-motion: reduce)");

          function y() {
              return document.body.getAttribute("data-wf-scroll-motion") === "none" || g.matches
          }

          function b(q, w) {
              var F;
              switch (w) {
                  case "add":
                      F = q.attr("tabindex"), F ? q.attr("data-wf-tabindex-swap", F) : q.attr("tabindex", "-1");
                      break;
                  case "remove":
                      F = q.attr("data-wf-tabindex-swap"), F ? (q.attr("tabindex", F), q.removeAttr("data-wf-tabindex-swap")) : q.removeAttr("tabindex");
                      break
              }
              q.toggleClass("wf-force-outline-none", w === "add")
          }

          function _(q) {
              var w = q.currentTarget;
              if (!(so.env("design") || window.$.mobile && /(?:^|\s)ui-link(?:$|\s)/.test(w.className))) {
                  var F = h(w) ? w.hash : "";
                  if (F !== "") {
                      var k = e(F);
                      k.length && (q && (q.preventDefault(), q.stopPropagation()), I(F, q), window.setTimeout(function() {
                          C(k, function() {
                              b(k, "add"), k.get(0)
                                  .focus({
                                      preventScroll: !0
                                  }), b(k, "remove")
                          })
                      }, q ? 0 : 300))
                  }
              }
          }

          function I(q) {
              if (r.hash !== q && n && n.pushState && !(so.env.chrome && r.protocol === "file:")) {
                  var w = n.state && n.state.hash;
                  w !== q && n.pushState({
                      hash: q
                  }, "", q)
              }
          }

          function C(q, w) {
              var F = i.scrollTop(),
                  k = x(q);
              if (F !== k) {
                  var U = O(q, F, k),
                      W = Date.now(),
                      S = function() {
                          var R = Date.now() - W;
                          window.scroll(0, L(F, k, R, U)), R <= U ? o(S) : typeof w == "function" && w()
                      };
                  o(S)
              }
          }

          function x(q) {
              var w = e(f),
                  F = w.css("position") === "fixed" ? w.outerHeight() : 0,
                  k = q.offset()
                  .top - F;
              if (q.data("scroll") === "mid") {
                  var U = i.height() - F,
                      W = q.outerHeight();
                  W < U && (k -= Math.round((U - W) / 2))
              }
              return k
          }

          function O(q, w, F) {
              if (y()) return 0;
              var k = 1;
              return s.add(q)
                  .each(function(U, W) {
                      var S = parseFloat(W.getAttribute("data-scroll-time"));
                      !isNaN(S) && S >= 0 && (k = S)
                  }), (472.143 * Math.log(Math.abs(w - F) + 125) - 2e3) * k
          }

          function L(q, w, F, k) {
              return F > k ? w : q + (w - q) * D(F / k)
          }

          function D(q) {
              return q < .5 ? 4 * q * q * q : (q - 1) * (2 * q - 2) * (2 * q - 2) + 1
          }

          function A() {
              var {
                  WF_CLICK_EMPTY: q,
                  WF_CLICK_SCROLL: w
              } = t;
              a.on(w, c, _), a.on(q, u, function(F) {
                  F.preventDefault()
              }), document.head.insertBefore(d, document.head.firstChild)
          }
          return {
              ready: A
          }
      })
  });
  var LP = E((Yhe, qP) => {
      var Mte = Xe();
      Mte.define("touch", qP.exports = function(e) {
          var t = {},
              r = window.getSelection;
          e.event.special.tap = {
              bindType: "click",
              delegateType: "click"
          }, t.init = function(a) {
              return a = typeof a == "string" ? e(a)
                  .get(0) : a, a ? new n(a) : null
          };

          function n(a) {
              var s = !1,
                  o = !1,
                  l = Math.min(Math.round(window.innerWidth * .04), 40),
                  f, u;
              a.addEventListener("touchstart", c, !1), a.addEventListener("touchmove", v, !1), a.addEventListener("touchend", d, !1), a.addEventListener("touchcancel", p, !1), a.addEventListener("mousedown", c, !1), a.addEventListener("mousemove", v, !1), a.addEventListener("mouseup", d, !1), a.addEventListener("mouseout", p, !1);

              function c(h) {
                  var g = h.touches;
                  g && g.length > 1 || (s = !0, g ? (o = !0, f = g[0].clientX) : f = h.clientX, u = f)
              }

              function v(h) {
                  if (s) {
                      if (o && h.type === "mousemove") {
                          h.preventDefault(), h.stopPropagation();
                          return
                      }
                      var g = h.touches,
                          y = g ? g[0].clientX : h.clientX,
                          b = y - u;
                      u = y, Math.abs(b) > l && r && String(r()) === "" && (i("swipe", h, {
                          direction: b > 0 ? "right" : "left"
                      }), p())
                  }
              }

              function d(h) {
                  if (s && (s = !1, o && h.type === "mouseup")) {
                      h.preventDefault(), h.stopPropagation(), o = !1;
                      return
                  }
              }

              function p() {
                  s = !1
              }

              function m() {
                  a.removeEventListener("touchstart", c, !1), a.removeEventListener("touchmove", v, !1), a.removeEventListener("touchend", d, !1), a.removeEventListener("touchcancel", p, !1), a.removeEventListener("mousedown", c, !1), a.removeEventListener("mousemove", v, !1), a.removeEventListener("mouseup", d, !1), a.removeEventListener("mouseout", p, !1), a = null
              }
              this.destroy = m
          }

          function i(a, s, o) {
              var l = e.Event(a, {
                  originalEvent: s
              });
              e(s.target)
                  .trigger(l, o)
          }
          return t.instance = t.init(document), t
      })
  });
  var BP = E((Qhe, NP) => {
      var Xr = Xe(),
          Rte = Ai(),
          Rt = {
              ARROW_LEFT: 37,
              ARROW_UP: 38,
              ARROW_RIGHT: 39,
              ARROW_DOWN: 40,
              ESCAPE: 27,
              SPACE: 32,
              ENTER: 13,
              HOME: 36,
              END: 35
          },
          kP = !0,
          Dte = /^#[a-zA-Z0-9\-_]+$/;
      Xr.define("dropdown", NP.exports = function(e, t) {
          var r = t.debounce,
              n = {},
              i = Xr.env(),
              a = !1,
              s, o = Xr.env.touch,
              l = ".w-dropdown",
              f = "w--open",
              u = Rte.triggers,
              c = 900,
              v = "focusout" + l,
              d = "keydown" + l,
              p = "mouseenter" + l,
              m = "mousemove" + l,
              h = "mouseleave" + l,
              g = (o ? "click" : "mouseup") + l,
              y = "w-close" + l,
              b = "setting" + l,
              _ = e(document),
              I;
          n.ready = C, n.design = function() {
              a && w(), a = !1, C()
          }, n.preview = function() {
              a = !0, C()
          };

          function C() {
              s = i && Xr.env("design"), I = _.find(l), I.each(x)
          }

          function x(T, z) {
              var Q = e(z),
                  G = e.data(z, l);
              G || (G = e.data(z, l, {
                  open: !1,
                  el: Q,
                  config: {},
                  selectedIdx: -1
              })), G.toggle = G.el.children(".w-dropdown-toggle"), G.list = G.el.children(".w-dropdown-list"), G.links = G.list.find("a:not(.w-dropdown .w-dropdown a)"), G.complete = U(G), G.mouseLeave = S(G), G.mouseUpOutside = k(G), G.mouseMoveOutside = R(G), O(G);
              var J = G.toggle.attr("id"),
                  ae = G.list.attr("id");
              J || (J = "w-dropdown-toggle-" + T), ae || (ae = "w-dropdown-list-" + T), G.toggle.attr("id", J), G.toggle.attr("aria-controls", ae), G.toggle.attr("aria-haspopup", "menu"), G.toggle.attr("aria-expanded", "false"), G.toggle.find(".w-icon-dropdown-toggle")
                  .attr("aria-hidden", "true"), G.toggle.prop("tagName") !== "BUTTON" && (G.toggle.attr("role", "button"), G.toggle.attr("tabindex") || G.toggle.attr("tabindex", "0")), G.list.attr("id", ae), G.list.attr("aria-labelledby", J), G.links.each(function(fe, ge) {
                      ge.hasAttribute("tabindex") || ge.setAttribute("tabindex", "0"), Dte.test(ge.hash) && ge.addEventListener("click", q.bind(null, G))
                  }), G.el.off(l), G.toggle.off(l), G.nav && G.nav.off(l);
              var re = D(G, kP);
              s && G.el.on(b, L(G)), s || (i && (G.hovering = !1, q(G)), G.config.hover && G.toggle.on(p, W(G)), G.el.on(y, re), G.el.on(d, V(G)), G.el.on(v, B(G)), G.toggle.on(g, re), G.toggle.on(d, N(G)), G.nav = G.el.closest(".w-nav"), G.nav.on(y, re))
          }

          function O(T) {
              var z = Number(T.el.css("z-index"));
              T.manageZ = z === c || z === c + 1, T.config = {
                  hover: T.el.attr("data-hover") === "true" && !o,
                  delay: T.el.attr("data-delay")
              }
          }

          function L(T) {
              return function(z, Q) {
                  Q = Q || {}, O(T), Q.open === !0 && A(T, !0), Q.open === !1 && q(T, {
                      immediate: !0
                  })
              }
          }

          function D(T, z) {
              return r(function(Q) {
                  if (T.open || Q && Q.type === "w-close") return q(T, {
                      forceClose: z
                  });
                  A(T)
              })
          }

          function A(T) {
              if (!T.open) {
                  F(T), T.open = !0, T.list.addClass(f), T.toggle.addClass(f), T.toggle.attr("aria-expanded", "true"), u.intro(0, T.el[0]), Xr.redraw.up(), T.manageZ && T.el.css("z-index", c + 1);
                  var z = Xr.env("editor");
                  s || _.on(g, T.mouseUpOutside), T.hovering && !z && T.el.on(h, T.mouseLeave), T.hovering && z && _.on(m, T.mouseMoveOutside), window.clearTimeout(T.delayId)
              }
          }

          function q(T, {
              immediate: z,
              forceClose: Q
          } = {}) {
              if (T.open && !(T.config.hover && T.hovering && !Q)) {
                  T.toggle.attr("aria-expanded", "false"), T.open = !1;
                  var G = T.config;
                  if (u.outro(0, T.el[0]), _.off(g, T.mouseUpOutside), _.off(m, T.mouseMoveOutside), T.el.off(h, T.mouseLeave), window.clearTimeout(T.delayId), !G.delay || z) return T.complete();
                  T.delayId = window.setTimeout(T.complete, G.delay)
              }
          }

          function w() {
              _.find(l)
                  .each(function(T, z) {
                      e(z)
                          .triggerHandler(y)
                  })
          }

          function F(T) {
              var z = T.el[0];
              I.each(function(Q, G) {
                  var J = e(G);
                  J.is(z) || J.has(z)
                      .length || J.triggerHandler(y)
              })
          }

          function k(T) {
              return T.mouseUpOutside && _.off(g, T.mouseUpOutside), r(function(z) {
                  if (T.open) {
                      var Q = e(z.target);
                      if (!Q.closest(".w-dropdown-toggle")
                          .length) {
                          var G = e.inArray(T.el[0], Q.parents(l)) === -1,
                              J = Xr.env("editor");
                          if (G) {
                              if (J) {
                                  var ae = Q.parents()
                                      .length === 1 && Q.parents("svg")
                                      .length === 1,
                                      re = Q.parents(".w-editor-bem-EditorHoverControls")
                                      .length;
                                  if (ae || re) return
                              }
                              q(T)
                          }
                      }
                  }
              })
          }

          function U(T) {
              return function() {
                  T.list.removeClass(f), T.toggle.removeClass(f), T.manageZ && T.el.css("z-index", "")
              }
          }

          function W(T) {
              return function() {
                  T.hovering = !0, A(T)
              }
          }

          function S(T) {
              return function() {
                  T.hovering = !1, T.links.is(":focus") || q(T)
              }
          }

          function R(T) {
              return r(function(z) {
                  if (T.open) {
                      var Q = e(z.target),
                          G = e.inArray(T.el[0], Q.parents(l)) === -1;
                      if (G) {
                          var J = Q.parents(".w-editor-bem-EditorHoverControls")
                              .length,
                              ae = Q.parents(".w-editor-bem-RTToolbar")
                              .length,
                              re = e(".w-editor-bem-EditorOverlay"),
                              fe = re.find(".w-editor-edit-outline")
                              .length || re.find(".w-editor-bem-RTToolbar")
                              .length;
                          if (J || ae || fe) return;
                          T.hovering = !1, q(T)
                      }
                  }
              })
          }

          function V(T) {
              return function(z) {
                  if (!(s || !T.open)) switch (T.selectedIdx = T.links.index(document.activeElement), z.keyCode) {
                      case Rt.HOME:
                          return T.open ? (T.selectedIdx = 0, P(T), z.preventDefault()) : void 0;
                      case Rt.END:
                          return T.open ? (T.selectedIdx = T.links.length - 1, P(T), z.preventDefault()) : void 0;
                      case Rt.ESCAPE:
                          return q(T), T.toggle.focus(), z.stopPropagation();
                      case Rt.ARROW_RIGHT:
                      case Rt.ARROW_DOWN:
                          return T.selectedIdx = Math.min(T.links.length - 1, T.selectedIdx + 1), P(T), z.preventDefault();
                      case Rt.ARROW_LEFT:
                      case Rt.ARROW_UP:
                          return T.selectedIdx = Math.max(-1, T.selectedIdx - 1), P(T), z.preventDefault()
                  }
              }
          }

          function P(T) {
              T.links[T.selectedIdx] && T.links[T.selectedIdx].focus()
          }

          function N(T) {
              var z = D(T, kP);
              return function(Q) {
                  if (!s) {
                      if (!T.open) switch (Q.keyCode) {
                          case Rt.ARROW_UP:
                          case Rt.ARROW_DOWN:
                              return Q.stopPropagation()
                      }
                      switch (Q.keyCode) {
                          case Rt.SPACE:
                          case Rt.ENTER:
                              return z(), Q.stopPropagation(), Q.preventDefault()
                      }
                  }
              }
          }

          function B(T) {
              return r(function(z) {
                  var {
                      relatedTarget: Q,
                      target: G
                  } = z, J = T.el[0], ae = J.contains(Q) || J.contains(G);
                  return ae || q(T), z.stopPropagation()
              })
          }
          return n
      })
  });
  var VP = E(oc => {
      "use strict";
      Object.defineProperty(oc, "__esModule", {
          value: !0
      });
      oc.default = Fte;

      function Fte(e, t, r, n, i, a, s, o, l, f, u, c, v) {
          return function(d) {
              e(d);
              var p = d.form,
                  m = {
                      name: p.attr("data-name") || p.attr("name") || "Untitled Form",
                      pageId: p.attr("data-wf-page-id") || "",
                      elementId: p.attr("data-wf-element-id") || "",
                      source: t.href,
                      test: r.env(),
                      fields: {},
                      fileUploads: {},
                      dolphin: /pass[\s-_]?(word|code)|secret|login|credentials/i.test(p.html()),
                      trackingCookies: n()
                  };
              let h = p.attr("data-wf-flow");
              h && (m.wfFlow = h), i(d);
              var g = a(p, m.fields);
              if (g) return s(g);
              if (m.fileUploads = o(p), l(d), !f) {
                  u(d);
                  return
              }
              c.ajax({
                      url: v,
                      type: "POST",
                      data: m,
                      dataType: "json",
                      crossDomain: !0
                  })
                  .done(function(y) {
                      y && y.code === 200 && (d.success = !0), u(d)
                  })
                  .fail(function() {
                      u(d)
                  })
          }
      }
  });
  var zP = E((Jhe, GP) => {
      var oo = Xe();
      oo.define("forms", GP.exports = function(e, t) {
          var r = {},
              n = e(document),
              i, a = window.location,
              s = window.XDomainRequest && !window.atob,
              o = ".w-form",
              l, f = /e(-)?mail/i,
              u = /^\S+@\S+$/,
              c = window.alert,
              v = oo.env(),
              d, p, m, h = /list-manage[1-9]?.com/i,
              g = t.debounce(function() {
                  c("Oops! This page has improperly configured forms. Please contact your website administrator to fix this issue.")
              }, 100);
          r.ready = r.design = r.preview = function() {
              y(), !v && !d && _()
          };

          function y() {
              l = e("html")
                  .attr("data-wf-site"), p = "https://webflow.com/api/v1/form/" + l, s && p.indexOf("https://webflow.com") >= 0 && (p = p.replace("https://webflow.com", "https://formdata.webflow.com")), m = `${p}/signFile`, i = e(o + " form"), i.length && i.each(b)
          }

          function b(R, V) {
              var P = e(V),
                  N = e.data(V, o);
              N || (N = e.data(V, o, {
                  form: P
              })), I(N);
              var B = P.closest("div.w-form");
              N.done = B.find("> .w-form-done"), N.fail = B.find("> .w-form-fail"), N.fileUploads = B.find(".w-file-upload"), N.fileUploads.each(function(Q) {
                  U(Q, N)
              });
              var T = N.form.attr("aria-label") || N.form.attr("data-name") || "Form";
              N.done.attr("aria-label") || N.form.attr("aria-label", T), N.done.attr("tabindex", "-1"), N.done.attr("role", "region"), N.done.attr("aria-label") || N.done.attr("aria-label", T + " success"), N.fail.attr("tabindex", "-1"), N.fail.attr("role", "region"), N.fail.attr("aria-label") || N.fail.attr("aria-label", T + " failure");
              var z = N.action = P.attr("action");
              if (N.handler = null, N.redirect = P.attr("data-redirect"), h.test(z)) {
                  N.handler = w;
                  return
              }
              if (!z) {
                  if (l) {
                      N.handler = (() => {
                          let Q = VP()
                              .default;
                          return Q(I, a, oo, D, k, x, c, O, C, l, F, e, p)
                      })();
                      return
                  }
                  g()
              }
          }

          function _() {
              d = !0, n.on("submit", o + " form", function(Q) {
                  var G = e.data(this, o);
                  G.handler && (G.evt = Q, G.handler(G))
              });
              let R = ".w-checkbox-input",
                  V = ".w-radio-input",
                  P = "w--redirected-checked",
                  N = "w--redirected-focus",
                  B = "w--redirected-focus-visible",
                  T = ":focus-visible, [data-wf-focus-visible]",
                  z = [
                      ["checkbox", R],
                      ["radio", V]
                  ];
              n.on("change", o + ' form input[type="checkbox"]:not(' + R + ")", Q => {
                  e(Q.target)
                      .siblings(R)
                      .toggleClass(P)
              }), n.on("change", o + ' form input[type="radio"]', Q => {
                  e(`input[name="${Q.target.name}"]:not(${R})`)
                      .map((J, ae) => e(ae)
                          .siblings(V)
                          .removeClass(P));
                  let G = e(Q.target);
                  G.hasClass("w-radio-input") || G.siblings(V)
                      .addClass(P)
              }), z.forEach(([Q, G]) => {
                  n.on("focus", o + ` form input[type="${Q}"]:not(` + G + ")", J => {
                      e(J.target)
                          .siblings(G)
                          .addClass(N), e(J.target)
                          .filter(T)
                          .siblings(G)
                          .addClass(B)
                  }), n.on("blur", o + ` form input[type="${Q}"]:not(` + G + ")", J => {
                      e(J.target)
                          .siblings(G)
                          .removeClass(`${N} ${B}`)
                  })
              })
          }

          function I(R) {
              var V = R.btn = R.form.find(':input[type="submit"]');
              R.wait = R.btn.attr("data-wait") || null, R.success = !1, V.prop("disabled", !1), R.label && V.val(R.label)
          }

          function C(R) {
              var V = R.btn,
                  P = R.wait;
              V.prop("disabled", !0), P && (R.label = V.val(), V.val(P))
          }

          function x(R, V) {
              var P = null;
              return V = V || {}, R.find(':input:not([type="submit"]):not([type="file"])')
                  .each(function(N, B) {
                      var T = e(B),
                          z = T.attr("type"),
                          Q = T.attr("data-name") || T.attr("name") || "Field " + (N + 1),
                          G = T.val();
                      if (z === "checkbox") G = T.is(":checked");
                      else if (z === "radio") {
                          if (V[Q] === null || typeof V[Q] == "string") return;
                          G = R.find('input[name="' + T.attr("name") + '"]:checked')
                              .val() || null
                      }
                      typeof G == "string" && (G = e.trim(G)), V[Q] = G, P = P || A(T, z, Q, G)
                  }), P
          }

          function O(R) {
              var V = {};
              return R.find(':input[type="file"]')
                  .each(function(P, N) {
                      var B = e(N),
                          T = B.attr("data-name") || B.attr("name") || "File " + (P + 1),
                          z = B.attr("data-value");
                      typeof z == "string" && (z = e.trim(z)), V[T] = z
                  }), V
          }
          let L = {
              _mkto_trk: "marketo"
          };

          function D() {
              return document.cookie.split("; ")
                  .reduce(function(V, P) {
                      let N = P.split("="),
                          B = N[0];
                      if (B in L) {
                          let T = L[B],
                              z = N.slice(1)
                              .join("=");
                          V[T] = z
                      }
                      return V
                  }, {})
          }

          function A(R, V, P, N) {
              var B = null;
              return V === "password" ? B = "Passwords cannot be submitted." : R.attr("required") ? N ? f.test(R.attr("type")) && (u.test(N) || (B = "Please enter a valid email address for: " + P)) : B = "Please fill out the required field: " + P : P === "g-recaptcha-response" && !N && (B = "Please confirm you\u2019re not a robot."), B
          }

          function q(R) {
              k(R), F(R)
          }

          function w(R) {
              I(R);
              var V = R.form,
                  P = {};
              if (/^https/.test(a.href) && !/^https/.test(R.action)) {
                  V.attr("method", "post");
                  return
              }
              k(R);
              var N = x(V, P);
              if (N) return c(N);
              C(R);
              var B;
              t.each(P, function(G, J) {
                  f.test(J) && (P.EMAIL = G), /^((full[ _-]?)?name)$/i.test(J) && (B = G), /^(first[ _-]?name)$/i.test(J) && (P.FNAME = G), /^(last[ _-]?name)$/i.test(J) && (P.LNAME = G)
              }), B && !P.FNAME && (B = B.split(" "), P.FNAME = B[0], P.LNAME = P.LNAME || B[1]);
              var T = R.action.replace("/post?", "/post-json?") + "&c=?",
                  z = T.indexOf("u=") + 2;
              z = T.substring(z, T.indexOf("&", z));
              var Q = T.indexOf("id=") + 3;
              Q = T.substring(Q, T.indexOf("&", Q)), P["b_" + z + "_" + Q] = "", e.ajax({
                      url: T,
                      data: P,
                      dataType: "jsonp"
                  })
                  .done(function(G) {
                      R.success = G.result === "success" || /already/.test(G.msg), R.success || console.info("MailChimp error: " + G.msg), F(R)
                  })
                  .fail(function() {
                      F(R)
                  })
          }

          function F(R) {
              var V = R.form,
                  P = R.redirect,
                  N = R.success;
              if (N && P) {
                  oo.location(P);
                  return
              }
              R.done.toggle(N), R.fail.toggle(!N), N ? R.done.focus() : R.fail.focus(), V.toggle(!N), I(R)
          }

          function k(R) {
              R.evt && R.evt.preventDefault(), R.evt = null
          }

          function U(R, V) {
              if (!V.fileUploads || !V.fileUploads[R]) return;
              var P, N = e(V.fileUploads[R]),
                  B = N.find("> .w-file-upload-default"),
                  T = N.find("> .w-file-upload-uploading"),
                  z = N.find("> .w-file-upload-success"),
                  Q = N.find("> .w-file-upload-error"),
                  G = B.find(".w-file-upload-input"),
                  J = B.find(".w-file-upload-label"),
                  ae = J.children(),
                  re = Q.find(".w-file-upload-error-msg"),
                  fe = z.find(".w-file-upload-file"),
                  ge = z.find(".w-file-remove-link"),
                  ye = fe.find(".w-file-upload-file-name"),
                  ie = re.attr("data-w-size-error"),
                  Pe = re.attr("data-w-type-error"),
                  Ge = re.attr("data-w-generic-error");
              if (v || J.on("click keydown", function(X) {
                      X.type === "keydown" && X.which !== 13 && X.which !== 32 || (X.preventDefault(), G.click())
                  }), J.find(".w-icon-file-upload-icon")
                  .attr("aria-hidden", "true"), ge.find(".w-icon-file-upload-remove")
                  .attr("aria-hidden", "true"), v) G.on("click", function(X) {
                  X.preventDefault()
              }), J.on("click", function(X) {
                  X.preventDefault()
              }), ae.on("click", function(X) {
                  X.preventDefault()
              });
              else {
                  ge.on("click keydown", function(X) {
                      if (X.type === "keydown") {
                          if (X.which !== 13 && X.which !== 32) return;
                          X.preventDefault()
                      }
                      G.removeAttr("data-value"), G.val(""), ye.html(""), B.toggle(!0), z.toggle(!1), J.focus()
                  }), G.on("change", function(X) {
                      P = X.target && X.target.files && X.target.files[0], P && (B.toggle(!1), Q.toggle(!1), T.toggle(!0), T.focus(), ye.text(P.name), Y() || C(V), V.fileUploads[R].uploading = !0, W(P, H))
                  });
                  var Ke = J.outerHeight();
                  G.height(Ke), G.width(1)
              }

              function M(X) {
                  var K = X.responseJSON && X.responseJSON.msg,
                      te = Ge;
                  typeof K == "string" && K.indexOf("InvalidFileTypeError") === 0 ? te = Pe : typeof K == "string" && K.indexOf("MaxFileSizeError") === 0 && (te = ie), re.text(te), G.removeAttr("data-value"), G.val(""), T.toggle(!1), B.toggle(!0), Q.toggle(!0), Q.focus(), V.fileUploads[R].uploading = !1, Y() || I(V)
              }

              function H(X, K) {
                  if (X) return M(X);
                  var te = K.fileName,
                      ne = K.postData,
                      me = K.fileId,
                      ee = K.s3Url;
                  G.attr("data-value", me), S(ee, ne, P, te, j)
              }

              function j(X) {
                  if (X) return M(X);
                  T.toggle(!1), z.css("display", "inline-block"), z.focus(), V.fileUploads[R].uploading = !1, Y() || I(V)
              }

              function Y() {
                  var X = V.fileUploads && V.fileUploads.toArray() || [];
                  return X.some(function(K) {
                      return K.uploading
                  })
              }
          }

          function W(R, V) {
              var P = new URLSearchParams({
                  name: R.name,
                  size: R.size
              });
              e.ajax({
                      type: "GET",
                      url: `${m}?${P}`,
                      crossDomain: !0
                  })
                  .done(function(N) {
                      V(null, N)
                  })
                  .fail(function(N) {
                      V(N)
                  })
          }

          function S(R, V, P, N, B) {
              var T = new FormData;
              for (var z in V) T.append(z, V[z]);
              T.append("file", P, N), e.ajax({
                      type: "POST",
                      url: R,
                      data: T,
                      processData: !1,
                      contentType: !1
                  })
                  .done(function() {
                      B(null)
                  })
                  .fail(function(Q) {
                      B(Q)
                  })
          }
          return r
      })
  });
  var WP = E((ece, jP) => {
      var Tr = Xe(),
          qte = Ai(),
          Ut = {
              ARROW_LEFT: 37,
              ARROW_UP: 38,
              ARROW_RIGHT: 39,
              ARROW_DOWN: 40,
              SPACE: 32,
              ENTER: 13,
              HOME: 36,
              END: 35
          },
          HP = 'a[href], area[href], [role="button"], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]';
      Tr.define("slider", jP.exports = function(e, t) {
          var r = {},
              n = e.tram,
              i = e(document),
              a, s, o = Tr.env(),
              l = ".w-slider",
              f = '<div class="w-slider-dot" data-wf-ignore />',
              u = '<div aria-live="off" aria-atomic="true" class="w-slider-aria-label" data-wf-ignore />',
              c = "w-slider-force-show",
              v = qte.triggers,
              d, p = !1;
          r.ready = function() {
              s = Tr.env("design"), m()
          }, r.design = function() {
              s = !0, setTimeout(m, 1e3)
          }, r.preview = function() {
              s = !1, m()
          }, r.redraw = function() {
              p = !0, m(), p = !1
          }, r.destroy = h;

          function m() {
              a = i.find(l), a.length && (a.each(b), !d && (h(), g()))
          }

          function h() {
              Tr.resize.off(y), Tr.redraw.off(r.redraw)
          }

          function g() {
              Tr.resize.on(y), Tr.redraw.on(r.redraw)
          }

          function y() {
              a.filter(":visible")
                  .each(U)
          }

          function b(P, N) {
              var B = e(N),
                  T = e.data(N, l);
              T || (T = e.data(N, l, {
                  index: 0,
                  depth: 1,
                  hasFocus: {
                      keyboard: !1,
                      mouse: !1
                  },
                  el: B,
                  config: {}
              })), T.mask = B.children(".w-slider-mask"), T.left = B.children(".w-slider-arrow-left"), T.right = B.children(".w-slider-arrow-right"), T.nav = B.children(".w-slider-nav"), T.slides = T.mask.children(".w-slide"), T.slides.each(v.reset), p && (T.maskWidth = 0), B.attr("role") === void 0 && B.attr("role", "region"), B.attr("aria-label") === void 0 && B.attr("aria-label", "carousel");
              var z = T.mask.attr("id");
              if (z || (z = "w-slider-mask-" + P, T.mask.attr("id", z)), !s && !T.ariaLiveLabel && (T.ariaLiveLabel = e(u)
                      .appendTo(T.mask)), T.left.attr("role", "button"), T.left.attr("tabindex", "0"), T.left.attr("aria-controls", z), T.left.attr("aria-label") === void 0 && T.left.attr("aria-label", "previous slide"), T.right.attr("role", "button"), T.right.attr("tabindex", "0"), T.right.attr("aria-controls", z), T.right.attr("aria-label") === void 0 && T.right.attr("aria-label", "next slide"), !n.support.transform) {
                  T.left.hide(), T.right.hide(), T.nav.hide(), d = !0;
                  return
              }
              T.el.off(l), T.left.off(l), T.right.off(l), T.nav.off(l), _(T), s ? (T.el.on("setting" + l, w(T)), q(T), T.hasTimer = !1) : (T.el.on("swipe" + l, w(T)), T.left.on("click" + l, O(T)), T.right.on("click" + l, L(T)), T.left.on("keydown" + l, x(T, O)), T.right.on("keydown" + l, x(T, L)), T.nav.on("keydown" + l, "> div", w(T)), T.config.autoplay && !T.hasTimer && (T.hasTimer = !0, T.timerCount = 1, A(T)), T.el.on("mouseenter" + l, C(T, !0, "mouse")), T.el.on("focusin" + l, C(T, !0, "keyboard")), T.el.on("mouseleave" + l, C(T, !1, "mouse")), T.el.on("focusout" + l, C(T, !1, "keyboard"))), T.nav.on("click" + l, "> div", w(T)), o || T.mask.contents()
                  .filter(function() {
                      return this.nodeType === 3
                  })
                  .remove();
              var Q = B.filter(":hidden");
              Q.addClass(c);
              var G = B.parents(":hidden");
              G.addClass(c), p || U(P, N), Q.removeClass(c), G.removeClass(c)
          }

          function _(P) {
              var N = {};
              N.crossOver = 0, N.animation = P.el.attr("data-animation") || "slide", N.animation === "outin" && (N.animation = "cross", N.crossOver = .5), N.easing = P.el.attr("data-easing") || "ease";
              var B = P.el.attr("data-duration");
              if (N.duration = B != null ? parseInt(B, 10) : 500, I(P.el.attr("data-infinite")) && (N.infinite = !0), I(P.el.attr("data-disable-swipe")) && (N.disableSwipe = !0), I(P.el.attr("data-hide-arrows")) ? N.hideArrows = !0 : P.config.hideArrows && (P.left.show(), P.right.show()), I(P.el.attr("data-autoplay"))) {
                  N.autoplay = !0, N.delay = parseInt(P.el.attr("data-delay"), 10) || 2e3, N.timerMax = parseInt(P.el.attr("data-autoplay-limit"), 10);
                  var T = "mousedown" + l + " touchstart" + l;
                  s || P.el.off(T)
                      .one(T, function() {
                          q(P)
                      })
              }
              var z = P.right.width();
              N.edge = z ? z + 40 : 100, P.config = N
          }

          function I(P) {
              return P === "1" || P === "true"
          }

          function C(P, N, B) {
              return function(T) {
                  if (N) P.hasFocus[B] = N;
                  else if (e.contains(P.el.get(0), T.relatedTarget) || (P.hasFocus[B] = N, P.hasFocus.mouse && B === "keyboard" || P.hasFocus.keyboard && B === "mouse")) return;
                  N ? (P.ariaLiveLabel.attr("aria-live", "polite"), P.hasTimer && q(P)) : (P.ariaLiveLabel.attr("aria-live", "off"), P.hasTimer && A(P))
              }
          }

          function x(P, N) {
              return function(B) {
                  switch (B.keyCode) {
                      case Ut.SPACE:
                      case Ut.ENTER:
                          return N(P)(), B.preventDefault(), B.stopPropagation()
                  }
              }
          }

          function O(P) {
              return function() {
                  k(P, {
                      index: P.index - 1,
                      vector: -1
                  })
              }
          }

          function L(P) {
              return function() {
                  k(P, {
                      index: P.index + 1,
                      vector: 1
                  })
              }
          }

          function D(P, N) {
              var B = null;
              N === P.slides.length && (m(), W(P)), t.each(P.anchors, function(T, z) {
                  e(T.els)
                      .each(function(Q, G) {
                          e(G)
                              .index() === N && (B = z)
                      })
              }), B != null && k(P, {
                  index: B,
                  immediate: !0
              })
          }

          function A(P) {
              q(P);
              var N = P.config,
                  B = N.timerMax;
              B && P.timerCount++ > B || (P.timerId = window.setTimeout(function() {
                  P.timerId == null || s || (L(P)(), A(P))
              }, N.delay))
          }

          function q(P) {
              window.clearTimeout(P.timerId), P.timerId = null
          }

          function w(P) {
              return function(N, B) {
                  B = B || {};
                  var T = P.config;
                  if (s && N.type === "setting") {
                      if (B.select === "prev") return O(P)();
                      if (B.select === "next") return L(P)();
                      if (_(P), W(P), B.select == null) return;
                      D(P, B.select);
                      return
                  }
                  if (N.type === "swipe") return T.disableSwipe || Tr.env("editor") ? void 0 : B.direction === "left" ? L(P)() : B.direction === "right" ? O(P)() : void 0;
                  if (P.nav.has(N.target)
                      .length) {
                      var z = e(N.target)
                          .index();
                      if (N.type === "click" && k(P, {
                              index: z
                          }), N.type === "keydown") switch (N.keyCode) {
                          case Ut.ENTER:
                          case Ut.SPACE: {
                              k(P, {
                                  index: z
                              }), N.preventDefault();
                              break
                          }
                          case Ut.ARROW_LEFT:
                          case Ut.ARROW_UP: {
                              F(P.nav, Math.max(z - 1, 0)), N.preventDefault();
                              break
                          }
                          case Ut.ARROW_RIGHT:
                          case Ut.ARROW_DOWN: {
                              F(P.nav, Math.min(z + 1, P.pages)), N.preventDefault();
                              break
                          }
                          case Ut.HOME: {
                              F(P.nav, 0), N.preventDefault();
                              break
                          }
                          case Ut.END: {
                              F(P.nav, P.pages), N.preventDefault();
                              break
                          }
                          default:
                              return
                      }
                  }
              }
          }

          function F(P, N) {
              var B = P.children()
                  .eq(N)
                  .focus();
              P.children()
                  .not(B)
          }

          function k(P, N) {
              N = N || {};
              var B = P.config,
                  T = P.anchors;
              P.previous = P.index;
              var z = N.index,
                  Q = {};
              z < 0 ? (z = T.length - 1, B.infinite && (Q.x = -P.endX, Q.from = 0, Q.to = T[0].width)) : z >= T.length && (z = 0, B.infinite && (Q.x = T[T.length - 1].width, Q.from = -T[T.length - 1].x, Q.to = Q.from - Q.x)), P.index = z;
              var G = P.nav.children()
                  .eq(z)
                  .addClass("w-active")
                  .attr("aria-pressed", "true")
                  .attr("tabindex", "0");
              P.nav.children()
                  .not(G)
                  .removeClass("w-active")
                  .attr("aria-pressed", "false")
                  .attr("tabindex", "-1"), B.hideArrows && (P.index === T.length - 1 ? P.right.hide() : P.right.show(), P.index === 0 ? P.left.hide() : P.left.show());
              var J = P.offsetX || 0,
                  ae = P.offsetX = -T[P.index].x,
                  re = {
                      x: ae,
                      opacity: 1,
                      visibility: ""
                  },
                  fe = e(T[P.index].els),
                  ge = e(T[P.previous] && T[P.previous].els),
                  ye = P.slides.not(fe),
                  ie = B.animation,
                  Pe = B.easing,
                  Ge = Math.round(B.duration),
                  Ke = N.vector || (P.index > P.previous ? 1 : -1),
                  M = "opacity " + Ge + "ms " + Pe,
                  H = "transform " + Ge + "ms " + Pe;
              if (fe.find(HP)
                  .removeAttr("tabindex"), fe.removeAttr("aria-hidden"), fe.find("*")
                  .removeAttr("aria-hidden"), ye.find(HP)
                  .attr("tabindex", "-1"), ye.attr("aria-hidden", "true"), ye.find("*")
                  .attr("aria-hidden", "true"), s || (fe.each(v.intro), ye.each(v.outro)), N.immediate && !p) {
                  n(fe)
                      .set(re), X();
                  return
              }
              if (P.index === P.previous) return;
              if (s || P.ariaLiveLabel.text(`Slide ${z+1} of ${T.length}.`), ie === "cross") {
                  var j = Math.round(Ge - Ge * B.crossOver),
                      Y = Math.round(Ge - j);
                  M = "opacity " + j + "ms " + Pe, n(ge)
                      .set({
                          visibility: ""
                      })
                      .add(M)
                      .start({
                          opacity: 0
                      }), n(fe)
                      .set({
                          visibility: "",
                          x: ae,
                          opacity: 0,
                          zIndex: P.depth++
                      })
                      .add(M)
                      .wait(Y)
                      .then({
                          opacity: 1
                      })
                      .then(X);
                  return
              }
              if (ie === "fade") {
                  n(ge)
                      .set({
                          visibility: ""
                      })
                      .stop(), n(fe)
                      .set({
                          visibility: "",
                          x: ae,
                          opacity: 0,
                          zIndex: P.depth++
                      })
                      .add(M)
                      .start({
                          opacity: 1
                      })
                      .then(X);
                  return
              }
              if (ie === "over") {
                  re = {
                          x: P.endX
                      }, n(ge)
                      .set({
                          visibility: ""
                      })
                      .stop(), n(fe)
                      .set({
                          visibility: "",
                          zIndex: P.depth++,
                          x: ae + T[P.index].width * Ke
                      })
                      .add(H)
                      .start({
                          x: ae
                      })
                      .then(X);
                  return
              }
              B.infinite && Q.x ? (n(P.slides.not(ge))
                  .set({
                      visibility: "",
                      x: Q.x
                  })
                  .add(H)
                  .start({
                      x: ae
                  }), n(ge)
                  .set({
                      visibility: "",
                      x: Q.from
                  })
                  .add(H)
                  .start({
                      x: Q.to
                  }), P.shifted = ge) : (B.infinite && P.shifted && (n(P.shifted)
                      .set({
                          visibility: "",
                          x: J
                      }), P.shifted = null), n(P.slides)
                  .set({
                      visibility: ""
                  })
                  .add(H)
                  .start({
                      x: ae
                  }));

              function X() {
                  fe = e(T[P.index].els), ye = P.slides.not(fe), ie !== "slide" && (re.visibility = "hidden"), n(ye)
                      .set(re)
              }
          }

          function U(P, N) {
              var B = e.data(N, l);
              if (B) {
                  if (R(B)) return W(B);
                  s && V(B) && W(B)
              }
          }

          function W(P) {
              var N = 1,
                  B = 0,
                  T = 0,
                  z = 0,
                  Q = P.maskWidth,
                  G = Q - P.config.edge;
              G < 0 && (G = 0), P.anchors = [{
                  els: [],
                  x: 0,
                  width: 0
              }], P.slides.each(function(ae, re) {
                  T - B > G && (N++, B += Q, P.anchors[N - 1] = {
                          els: [],
                          x: T,
                          width: 0
                      }), z = e(re)
                      .outerWidth(!0), T += z, P.anchors[N - 1].width += z, P.anchors[N - 1].els.push(re);
                  var fe = ae + 1 + " of " + P.slides.length;
                  e(re)
                      .attr("aria-label", fe), e(re)
                      .attr("role", "group")
              }), P.endX = T, s && (P.pages = null), P.nav.length && P.pages !== N && (P.pages = N, S(P));
              var J = P.index;
              J >= N && (J = N - 1), k(P, {
                  immediate: !0,
                  index: J
              })
          }

          function S(P) {
              var N = [],
                  B, T = P.el.attr("data-nav-spacing");
              T && (T = parseFloat(T) + "px");
              for (var z = 0, Q = P.pages; z < Q; z++) B = e(f), B.attr("aria-label", "Show slide " + (z + 1) + " of " + Q)
                  .attr("aria-pressed", "false")
                  .attr("role", "button")
                  .attr("tabindex", "-1"), P.nav.hasClass("w-num") && B.text(z + 1), T != null && B.css({
                      "margin-left": T,
                      "margin-right": T
                  }), N.push(B);
              P.nav.empty()
                  .append(N)
          }

          function R(P) {
              var N = P.mask.width();
              return P.maskWidth !== N ? (P.maskWidth = N, !0) : !1
          }

          function V(P) {
              var N = 0;
              return P.slides.each(function(B, T) {
                  N += e(T)
                      .outerWidth(!0)
              }), P.slidesWidth !== N ? (P.slidesWidth = N, !0) : !1
          }
          return r
      })
  });
  var XP = E((tce, UP) => {
      var xr = Xe(),
          Lte = Ai();
      xr.define("tabs", UP.exports = function(e) {
          var t = {},
              r = e.tram,
              n = e(document),
              i, a, s = xr.env,
              o = s.safari,
              l = s(),
              f = "data-w-tab",
              u = "data-w-pane",
              c = ".w-tabs",
              v = "w--current",
              d = "w--tab-active",
              p = Lte.triggers,
              m = !1;
          t.ready = t.design = t.preview = h, t.redraw = function() {
              m = !0, h(), m = !1
          }, t.destroy = function() {
              i = n.find(c), i.length && (i.each(b), g())
          };

          function h() {
              a = l && xr.env("design"), i = n.find(c), i.length && (i.each(_), xr.env("preview") && !m && i.each(b), g(), y())
          }

          f